// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// LogsData represents the logs data that can be stored in a persistent storage,
// OR can be embedded by other protocols that transfer OTLP logs data but do not
// implement the OTLP protocol.
type LogsData struct {
	ResourceLogs []*ResourceLogs
}

var (
	protoPoolLogsData = sync.Pool{
		New: func() any {
			return &LogsData{}
		},
	}
)

func NewLogsData() *LogsData {
	if !UseProtoPooling.IsEnabled() {
		return &LogsData{}
	}
	return protoPoolLogsData.Get().(*LogsData)
}

func DeleteLogsData(orig *LogsData, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	for i := range orig.ResourceLogs {
		DeleteResourceLogs(orig.ResourceLogs[i], true)
	}
	orig.Reset()
	if nullable {
		protoPoolLogsData.Put(orig)
	}
}

func CopyLogsData(dest, src *LogsData) *LogsData {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewLogsData()
	}
	dest.ResourceLogs = CopyResourceLogsPtrSlice(dest.ResourceLogs, src.ResourceLogs)

	return dest
}

func CopyLogsDataSlice(dest, src []LogsData) []LogsData {
	var newDest []LogsData
	if cap(dest) < len(src) {
		newDest = make([]LogsData, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteLogsData(&dest[i], false)
		}
	}
	for i := range src {
		CopyLogsData(&newDest[i], &src[i])
	}
	return newDest
}

func CopyLogsDataPtrSlice(dest, src []*LogsData) []*LogsData {
	var newDest []*LogsData
	if cap(dest) < len(src) {
		newDest = make([]*LogsData, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewLogsData()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteLogsData(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewLogsData()
		}
	}
	for i := range src {
		CopyLogsData(newDest[i], src[i])
	}
	return newDest
}

func (orig *LogsData) Reset() {
	*orig = LogsData{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *LogsData) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.ResourceLogs) > 0 {
		dest.WriteObjectField("resourceLogs")
		dest.WriteArrayStart()
		orig.ResourceLogs[0].MarshalJSON(dest)
		for i := 1; i < len(orig.ResourceLogs); i++ {
			dest.WriteMore()
			orig.ResourceLogs[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *LogsData) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "resourceLogs", "resource_logs":
			for iter.ReadArray() {
				orig.ResourceLogs = append(orig.ResourceLogs, NewResourceLogs())
				orig.ResourceLogs[len(orig.ResourceLogs)-1].UnmarshalJSON(iter)
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *LogsData) SizeProto() int {
	var n int
	var l int
	_ = l
	for i := range orig.ResourceLogs {
		l = orig.ResourceLogs[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *LogsData) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.ResourceLogs) - 1; i >= 0; i-- {
		l = orig.ResourceLogs[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	return len(buf) - pos
}

func (orig *LogsData) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceLogs", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.ResourceLogs = append(orig.ResourceLogs, NewResourceLogs())
			err = orig.ResourceLogs[len(orig.ResourceLogs)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestLogsData() *LogsData {
	orig := NewLogsData()
	orig.ResourceLogs = []*ResourceLogs{{}, GenTestResourceLogs()}
	return orig
}

func GenTestLogsDataPtrSlice() []*LogsData {
	orig := make([]*LogsData, 5)
	orig[0] = NewLogsData()
	orig[1] = GenTestLogsData()
	orig[2] = NewLogsData()
	orig[3] = GenTestLogsData()
	orig[4] = NewLogsData()
	return orig
}

func GenTestLogsDataSlice() []LogsData {
	orig := make([]LogsData, 5)
	orig[1] = *GenTestLogsData()
	orig[3] = *GenTestLogsData()
	return orig
}
