/* BackupDeviceBox.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BackupDeviceBox.vala, do not modify */

/*
 * BackupBox.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>

#define TEE_JEE_FILE_SYSTEM_KB ((gint64) 1000)
#define ICON_MANAGER_ICON_HARDDRIVE "drive-harddisk"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BACKUP_DEVICE_BOX (backup_device_box_get_type ())
#define BACKUP_DEVICE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKUP_DEVICE_BOX, BackupDeviceBox))
#define BACKUP_DEVICE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKUP_DEVICE_BOX, BackupDeviceBoxClass))
#define IS_BACKUP_DEVICE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKUP_DEVICE_BOX))
#define IS_BACKUP_DEVICE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKUP_DEVICE_BOX))
#define BACKUP_DEVICE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKUP_DEVICE_BOX, BackupDeviceBoxClass))

typedef struct _BackupDeviceBox BackupDeviceBox;
typedef struct _BackupDeviceBoxClass BackupDeviceBoxClass;
typedef struct _BackupDeviceBoxPrivate BackupDeviceBoxPrivate;
enum  {
	BACKUP_DEVICE_BOX_0_PROPERTY,
	BACKUP_DEVICE_BOX_NUM_PROPERTIES
};
static GParamSpec* backup_device_box_properties[BACKUP_DEVICE_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;

#define TYPE_APP_EXCLUDE_ENTRY (app_exclude_entry_get_type ())
#define APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntry))
#define APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))
#define IS_APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_EXCLUDE_ENTRY))
#define IS_APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_EXCLUDE_ENTRY))
#define APP_EXCLUDE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))

typedef struct _AppExcludeEntry AppExcludeEntry;
typedef struct _AppExcludeEntryClass AppExcludeEntryClass;

#define TYPE_MOUNT_ENTRY (mount_entry_get_type ())
#define MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ENTRY, MountEntry))
#define MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ENTRY, MountEntryClass))
#define IS_MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ENTRY))
#define IS_MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ENTRY))
#define MOUNT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ENTRY, MountEntryClass))

typedef struct _MountEntry MountEntry;
typedef struct _MountEntryClass MountEntryClass;

#define TYPE_SNAPSHOT_REPO (snapshot_repo_get_type ())
#define SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepo))
#define SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))
#define IS_SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_REPO))
#define IS_SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_REPO))
#define SNAPSHOT_REPO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))

typedef struct _SnapshotRepo SnapshotRepo;
typedef struct _SnapshotRepoClass SnapshotRepoClass;

#define TYPE_SUBVOLUME (subvolume_get_type ())
#define SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUBVOLUME, Subvolume))
#define SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUBVOLUME, SubvolumeClass))
#define IS_SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUBVOLUME))
#define IS_SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUBVOLUME))
#define SUBVOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUBVOLUME, SubvolumeClass))

typedef struct _Subvolume Subvolume;
typedef struct _SubvolumeClass SubvolumeClass;

#define TYPE_LINUX_DISTRO (linux_distro_get_type ())
#define LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINUX_DISTRO, LinuxDistro))
#define LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINUX_DISTRO, LinuxDistroClass))
#define IS_LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINUX_DISTRO))
#define IS_LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINUX_DISTRO))
#define LINUX_DISTRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINUX_DISTRO, LinuxDistroClass))

typedef struct _LinuxDistro LinuxDistro;
typedef struct _LinuxDistroClass LinuxDistroClass;

#define TYPE_APP_LOCK (app_lock_get_type ())
#define APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_LOCK, AppLock))
#define APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_LOCK, AppLockClass))
#define IS_APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_LOCK))
#define IS_APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_LOCK))
#define APP_LOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_LOCK, AppLockClass))

typedef struct _AppLock AppLock;
typedef struct _AppLockClass AppLockClass;

#define TYPE_SNAPSHOT (snapshot_get_type ())
#define SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT, Snapshot))
#define SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT, SnapshotClass))
#define IS_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT))
#define IS_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT))
#define SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT, SnapshotClass))

typedef struct _Snapshot Snapshot;
typedef struct _SnapshotClass SnapshotClass;

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;

#define TYPE_RSYNC_TASK (rsync_task_get_type ())
#define RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_TASK, RsyncTask))
#define RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_TASK, RsyncTaskClass))
#define IS_RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_TASK))
#define IS_RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_TASK))
#define RSYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_TASK, RsyncTaskClass))

typedef struct _RsyncTask RsyncTask;
typedef struct _RsyncTaskClass RsyncTaskClass;

#define TYPE_DELETE_FILE_TASK (delete_file_task_get_type ())
#define DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTask))
#define DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))
#define IS_DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_FILE_TASK))
#define IS_DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_FILE_TASK))
#define DELETE_FILE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))

typedef struct _DeleteFileTask DeleteFileTask;
typedef struct _DeleteFileTaskClass DeleteFileTaskClass;

#define TYPE_RSYNC_SPACE_CHECK_TASK (rsync_space_check_task_get_type ())
#define RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTask))
#define RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))
#define IS_RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_SPACE_CHECK_TASK))
#define IS_RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_SPACE_CHECK_TASK))
#define RSYNC_SPACE_CHECK_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))

typedef struct _RsyncSpaceCheckTask RsyncSpaceCheckTask;
typedef struct _RsyncSpaceCheckTaskClass RsyncSpaceCheckTaskClass;

#define TYPE_SYSTEM_USER (system_user_get_type ())
#define SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_USER, SystemUser))
#define SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYSTEM_USER, SystemUserClass))
#define IS_SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_USER))
#define IS_SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYSTEM_USER))
#define SYSTEM_USER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYSTEM_USER, SystemUserClass))

typedef struct _SystemUser SystemUser;
typedef struct _SystemUserClass SystemUserClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DevicePrivate DevicePrivate;
typedef struct _Block3Data Block3Data;
typedef struct _SnapshotRepoPrivate SnapshotRepoPrivate;
typedef enum  {
	SNAPSHOT_LOCATION_STATUS_NOT_SELECTED = -2,
	SNAPSHOT_LOCATION_STATUS_NOT_AVAILABLE = -1,
	SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_HAS_SPACE = 0,
	SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_NO_SPACE = 1,
	SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_NO_SPACE = 2,
	SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_HAS_SPACE = 3,
	SNAPSHOT_LOCATION_STATUS_READ_ONLY_FS = 4,
	SNAPSHOT_LOCATION_STATUS_HARDLINKS_NOT_SUPPORTED = 5,
	SNAPSHOT_LOCATION_STATUS_NO_BTRFS_SYSTEM = 6
} SnapshotLocationStatus;

#define TYPE_SNAPSHOT_LOCATION_STATUS (snapshot_location_status_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _BackupDeviceBox {
	GtkBox parent_instance;
	BackupDeviceBoxPrivate * priv;
};

struct _BackupDeviceBoxClass {
	GtkBoxClass parent_class;
};

struct _BackupDeviceBoxPrivate {
	GtkTreeView* tv_devices;
	GtkInfoBar* infobar_location;
	GtkLabel* lbl_infobar_location;
	GtkLabel* lbl_common;
	GtkWindow* parent_window;
};

struct _Main {
	GObject parent_instance;
	MainPrivate * priv;
	gchar* app_path;
	gchar* share_folder;
	gchar* rsnapshot_conf_path;
	gchar* app_conf_path;
	gchar* app_conf_path_old;
	gchar* app_conf_path_default;
	gboolean first_run;
	gchar* backup_uuid;
	gchar* backup_parent_uuid;
	gboolean btrfs_mode;
	gboolean include_btrfs_home_for_backup;
	gboolean include_btrfs_home_for_restore;
	gboolean stop_cron_emails;
	GeeArrayList* partitions;
	GeeArrayList* exclude_list_user;
	GeeArrayList* exclude_list_default;
	GeeArrayList* exclude_list_default_extra;
	GeeArrayList* exclude_list_home;
	GeeArrayList* exclude_list_restore;
	GeeArrayList* exclude_list_apps;
	GeeArrayList* mount_list;
	GeeArrayList* exclude_app_names;
	SnapshotRepo* repo;
	Device* sys_root;
	Device* sys_boot;
	Device* sys_efi;
	Device* sys_home;
	GeeHashMap* sys_subvolumes;
	gchar* mount_point_restore;
	gchar* mount_point_app;
	LinuxDistro* current_distro;
	gboolean mirror_system;
	gboolean schedule_monthly;
	gboolean schedule_weekly;
	gboolean schedule_daily;
	gboolean schedule_hourly;
	gboolean schedule_boot;
	gint count_monthly;
	gint count_weekly;
	gint count_daily;
	gint count_hourly;
	gint count_boot;
	gchar* app_mode;
	gboolean dry_run;
	gboolean thr_success;
	gboolean thread_restore_running;
	gboolean thread_restore_success;
	gboolean thread_delete_running;
	gboolean thread_delete_success;
	gboolean thread_subvol_info_running;
	gboolean thread_subvol_info_success;
	gint thr_retval;
	gchar* thr_arg1;
	gboolean thr_timeout_active;
	gchar* thr_timeout_cmd;
	gint startup_delay_interval_mins;
	gint retain_snapshots_max_days;
	gchar* log_dir;
	gchar* log_file;
	AppLock* app_lock;
	gchar* date_format;
	GeeArrayList* delete_list;
	Snapshot* snapshot_to_delete;
	Snapshot* snapshot_to_restore;
	gboolean reinstall_grub2;
	gboolean update_initramfs;
	gboolean update_grub;
	gchar* grub_device;
	gboolean use_option_raw;
	gboolean cmd_skip_grub;
	gchar* cmd_grub_device;
	gchar* cmd_target_device;
	gchar* cmd_backup_device;
	gchar* cmd_snapshot;
	gboolean cmd_confirm;
	gboolean cmd_verbose;
	gboolean cmd_scripted;
	gchar* cmd_comments;
	gchar* cmd_tags;
	gboolean* cmd_btrfs_mode;
	gchar* progress_text;
	GtkWindow* parent_window;
	RsyncTask* task;
	DeleteFileTask* delete_file_task;
	RsyncSpaceCheckTask* space_check_task;
	GeeHashMap* current_system_users;
	gchar* users_with_encrypted_home;
	gchar* encrypted_home_dirs;
	gboolean encrypted_home_warning_shown;
	gchar* encrypted_private_dirs;
	gboolean encrypted_private_warning_shown;
};

struct _MainClass {
	GObjectClass parent_class;
};

struct _Device {
	GObject parent_instance;
	DevicePrivate * priv;
	gchar* device;
	gchar* name;
	gchar* kname;
	gchar* pkname;
	gchar* pkname_toplevel;
	gchar* mapped_name;
	gchar* uuid;
	gchar* label;
	gchar* partuuid;
	gchar* partlabel;
	gint major;
	gint minor;
	gchar* device_mapper;
	gchar* device_by_uuid;
	gchar* device_by_label;
	gchar* device_by_partuuid;
	gchar* device_by_partlabel;
	gchar* type;
	gchar* fstype;
	gint order;
	gchar* vendor;
	gchar* model;
	gchar* serial;
	gchar* revision;
	gboolean removable;
	gboolean read_only;
	guint64 size_bytes;
	guint64 used_bytes;
	guint64 available_bytes;
	gchar* used_percent;
	gchar* dist_info;
	GeeArrayList* mount_points;
	GeeArrayList* symlinks;
	Device* parent;
	GeeArrayList* children;
};

struct _DeviceClass {
	GObjectClass parent_class;
};

struct _Block3Data {
	int _ref_count_;
	BackupDeviceBox* self;
	GtkTreeStore* store;
};

struct _SnapshotRepo {
	GObject parent_instance;
	SnapshotRepoPrivate * priv;
	Device* device;
	Device* device_home;
	gchar* mount_path;
	GeeHashMap* mount_paths;
	gboolean btrfs_mode;
	GeeArrayList* snapshots;
	GeeArrayList* invalid_snapshots;
	gchar* status_message;
	gchar* status_details;
	SnapshotLocationStatus status_code;
	gboolean last_snapshot_failed_space;
};

struct _SnapshotRepoClass {
	GObjectClass parent_class;
};

static gint BackupDeviceBox_private_offset;
static gpointer backup_device_box_parent_class = NULL;
VALA_EXTERN Main* App;

VALA_EXTERN GType backup_device_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackupDeviceBox, g_object_unref)
VALA_EXTERN BackupDeviceBox* backup_device_box_new (GtkWindow* _parent_window);
VALA_EXTERN BackupDeviceBox* backup_device_box_construct (GType object_type,
                                              GtkWindow* _parent_window);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN GtkLabel* tee_jee_gtk_helper_add_label_header (GtkBox* box,
                                               const gchar* text,
                                               gboolean large_heading);
VALA_EXTERN GtkLabel* tee_jee_gtk_helper_add_label (GtkBox* box,
                                        const gchar* text,
                                        gboolean bold,
                                        gboolean italic,
                                        gboolean large);
VALA_EXTERN GtkButton* tee_jee_gtk_helper_add_button (GtkBox* box,
                                          const gchar* text,
                                          const gchar* tooltip,
                                          GtkSizeGroup* size_group,
                                          GtkImage* icon);
static void __lambda41_ (BackupDeviceBox* self);
VALA_EXTERN GType main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Main, g_object_unref)
VALA_EXTERN void main_update_partitions (Main* self);
static void backup_device_box_tv_devices_refresh (BackupDeviceBox* self);
static void ___lambda41__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void backup_device_box_init_tv_devices (BackupDeviceBox* self);
static void backup_device_box_init_infobar_location (BackupDeviceBox* self);
VALA_EXTERN void backup_device_box_refresh (BackupDeviceBox* self);
static gboolean backup_device_box_check_backup_location (BackupDeviceBox* self);
VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN GType app_exclude_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppExcludeEntry, g_object_unref)
VALA_EXTERN GType mount_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountEntry, g_object_unref)
VALA_EXTERN GType snapshot_repo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotRepo, g_object_unref)
VALA_EXTERN GType subvolume_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Subvolume, g_object_unref)
VALA_EXTERN GType linux_distro_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinuxDistro, g_object_unref)
VALA_EXTERN GType app_lock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppLock, g_object_unref)
VALA_EXTERN GType snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Snapshot, g_object_unref)
VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType rsync_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncTask, g_object_unref)
VALA_EXTERN GType delete_file_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteFileTask, g_object_unref)
VALA_EXTERN GType rsync_space_check_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncSpaceCheckTask, g_object_unref)
VALA_EXTERN GType system_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SystemUser, g_object_unref)
VALA_EXTERN GtkTreeView* tee_jee_gtk_helper_add_treeview (GtkBox* box,
                                              GtkSelectionMode selection_mode);
VALA_EXTERN GtkTreeViewColumn* tee_jee_gtk_helper_add_column_icon_radio_text (GtkTreeView* treeview,
                                                                  const gchar* title,
                                                                  GtkCellRendererPixbuf** cell_pix,
                                                                  GtkCellRendererToggle** cell_radio,
                                                                  GtkCellRendererText** cell_text);
static void __lambda42_ (BackupDeviceBox* self,
                  GtkCellLayout* cell_layout,
                  GtkCellRenderer* cell,
                  GtkTreeModel* model,
                  GtkTreeIter* iter);
static void ___lambda42__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                             GtkCellRenderer* cell,
                                             GtkTreeModel* tree_model,
                                             GtkTreeIter* iter,
                                             gpointer self);
static void __lambda43_ (BackupDeviceBox* self,
                  GtkCellLayout* cell_layout,
                  GtkCellRenderer* cell,
                  GtkTreeModel* model,
                  GtkTreeIter* iter);
static void ___lambda43__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                             GtkCellRenderer* cell,
                                             GtkTreeModel* tree_model,
                                             GtkTreeIter* iter,
                                             gpointer self);
static void __lambda44_ (BackupDeviceBox* self,
                  GtkCellLayout* cell_layout,
                  GtkCellRenderer* cell,
                  GtkTreeModel* model,
                  GtkTreeIter* iter);
VALA_EXTERN gchar* tee_jee_file_system_format_file_size (guint64 size,
                                             gboolean binary_units,
                                             const gchar* unit,
                                             gboolean show_units,
                                             gint decimals);
static void ___lambda44__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                             GtkCellRenderer* cell,
                                             GtkTreeModel* tree_model,
                                             GtkTreeIter* iter,
                                             gpointer self);
VALA_EXTERN GtkTreeViewColumn* tee_jee_gtk_helper_add_column_text (GtkTreeView* treeview,
                                                       const gchar* title,
                                                       GtkCellRendererText** cell);
static void __lambda45_ (BackupDeviceBox* self,
                  GtkCellLayout* cell_layout,
                  GtkCellRenderer* cell,
                  GtkTreeModel* model,
                  GtkTreeIter* iter);
static void ___lambda45__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                             GtkCellRenderer* cell,
                                             GtkTreeModel* tree_model,
                                             GtkTreeIter* iter,
                                             gpointer self);
static void __lambda46_ (BackupDeviceBox* self,
                  GtkCellLayout* cell_layout,
                  GtkCellRenderer* cell,
                  GtkTreeModel* model,
                  GtkTreeIter* iter);
static void ___lambda46__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                             GtkCellRenderer* cell,
                                             GtkTreeModel* tree_model,
                                             GtkTreeIter* iter,
                                             gpointer self);
static void __lambda47_ (BackupDeviceBox* self,
                  GtkCellLayout* cell_layout,
                  GtkCellRenderer* cell,
                  GtkTreeModel* model,
                  GtkTreeIter* iter);
VALA_EXTERN guint64 device_get_free_bytes (Device* self);
static void ___lambda47__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                             GtkCellRenderer* cell,
                                             GtkTreeModel* tree_model,
                                             GtkTreeIter* iter,
                                             gpointer self);
static void __lambda48_ (BackupDeviceBox* self,
                  GtkCellLayout* cell_layout,
                  GtkCellRenderer* cell,
                  GtkTreeModel* model,
                  GtkTreeIter* iter);
static void ___lambda48__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                             GtkCellRenderer* cell,
                                             GtkTreeModel* tree_model,
                                             GtkTreeIter* iter,
                                             gpointer self);
static void __lambda49_ (BackupDeviceBox* self,
                  GtkCellLayout* cell_layout,
                  GtkCellRenderer* cell,
                  GtkTreeModel* model,
                  GtkTreeIter* iter);
static void ___lambda49__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                             GtkCellRenderer* cell,
                                             GtkTreeModel* tree_model,
                                             GtkTreeIter* iter,
                                             gpointer self);
static void __lambda50_ (BackupDeviceBox* self,
                  GtkTreePath* path,
                  GtkTreeViewColumn* column);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda51_ (Block3Data* _data3_,
                  GtkTreeModel* model,
                  GtkTreePath* path,
                  GtkTreeIter* iter);
VALA_EXTERN GType snapshot_location_status_get_type (void) G_GNUC_CONST ;
static void backup_device_box_try_change_device (BackupDeviceBox* self,
                                          Device* dev);
static void ___lambda51__gtk_tree_selection_foreach_func (GtkTreeModel* model,
                                                   GtkTreePath* path,
                                                   GtkTreeIter* iter,
                                                   gpointer self);
static gboolean __lambda52_ (Block3Data* _data3_,
                      GtkTreeModel* model,
                      GtkTreePath* path,
                      GtkTreeIter* iter);
static gboolean ___lambda52__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                   GtkTreePath* path,
                                                   GtkTreeIter* iter,
                                                   gpointer self);
static void ___lambda50__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                               GtkTreePath* path,
                                               GtkTreeViewColumn* column,
                                               gpointer self);
VALA_EXTERN gboolean device_has_linux_filesystem (Device* self);
static void backup_device_box_change_backup_device (BackupDeviceBox* self,
                                             Device* pi);
VALA_EXTERN gboolean device_has_children (Device* self);
VALA_EXTERN void tee_jee_gtk_helper_gtk_set_busy (gboolean busy,
                                      GtkWindow* win);
VALA_EXTERN void tee_jee_logging_log_msg (const gchar* message,
                              gboolean highlight);
VALA_EXTERN SnapshotRepo* snapshot_repo_new_from_device (Device* dev,
                                             GtkWindow* parent_win,
                                             gboolean btrfs_repo);
VALA_EXTERN SnapshotRepo* snapshot_repo_construct_from_device (GType object_type,
                                                   Device* dev,
                                                   GtkWindow* parent_win,
                                                   gboolean btrfs_repo);
VALA_EXTERN Device* device_find_device_in_list (GeeArrayList* list,
                                    const gchar* _dev_alias);
VALA_EXTERN void snapshot_repo_check_status (SnapshotRepo* self);
VALA_EXTERN gchar* tee_jee_misc_escape_html (const gchar* html);
VALA_EXTERN gboolean main_live_system (Main* self);
VALA_EXTERN gchar* device_tooltip_text (Device* self);
static void backup_device_box_tv_append_child_volumes (BackupDeviceBox* self,
                                                GtkTreeStore** model,
                                                GtkTreeIter* iter0,
                                                Device* parent);
VALA_EXTERN gboolean device_is_encrypted_partition (Device* self);
VALA_EXTERN gboolean device_is_lvm_partition (Device* self);
VALA_EXTERN Device* device_new (void);
VALA_EXTERN Device* device_construct (GType object_type);
VALA_EXTERN void device_copy_fields_from (Device* self,
                              Device* dev2);
static void backup_device_box_finalize (GObject * obj);
static GType backup_device_box_get_type_once (void);

static inline gpointer
backup_device_box_get_instance_private (BackupDeviceBox* self)
{
	return G_STRUCT_MEMBER_P (self, BackupDeviceBox_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda41_ (BackupDeviceBox* self)
{
	Main* _tmp0_;
	_tmp0_ = App;
	main_update_partitions (_tmp0_);
	backup_device_box_tv_devices_refresh (self);
}

static void
___lambda41__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda41_ ((BackupDeviceBox*) self);
}

BackupDeviceBox*
backup_device_box_construct (GType object_type,
                             GtkWindow* _parent_window)
{
	BackupDeviceBox * self = NULL;
	GtkWindow* _tmp0_;
	GtkBox* hbox = NULL;
	GtkBox* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp4_;
	GtkSizeGroup* size_group = NULL;
	GtkSizeGroup* _tmp5_;
	GtkButton* btn_refresh = NULL;
	GtkButton* _tmp6_;
	g_return_val_if_fail (_parent_window != NULL, NULL);
	tee_jee_logging_log_debug ("BackupDeviceBox: BackupDeviceBox()");
	self = (BackupDeviceBox*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 6, NULL);
	_tmp0_ = _g_object_ref0 (_parent_window);
	_g_object_unref0 (self->priv->parent_window);
	self->priv->parent_window = _tmp0_;
	g_object_set ((GtkWidget*) self, "margin", 12, NULL);
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp1_);
	hbox = _tmp1_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) hbox);
	_tmp2_ = tee_jee_gtk_helper_add_label_header (hbox, _ ("Select Snapshot Location"), TRUE);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	_tmp4_ = tee_jee_gtk_helper_add_label (hbox, "", FALSE, FALSE, FALSE);
	label = _tmp4_;
	gtk_widget_set_hexpand ((GtkWidget*) label, TRUE);
	_tmp5_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	size_group = _tmp5_;
	_tmp6_ = tee_jee_gtk_helper_add_button (hbox, _ ("Refresh"), "", size_group, NULL);
	btn_refresh = _tmp6_;
	g_signal_connect_object (btn_refresh, "clicked", (GCallback) ___lambda41__gtk_button_clicked, self, 0);
	backup_device_box_init_tv_devices (self);
	backup_device_box_init_infobar_location (self);
	tee_jee_logging_log_debug ("BackupDeviceBox: BackupDeviceBox(): exit");
	_g_object_unref0 (btn_refresh);
	_g_object_unref0 (size_group);
	_g_object_unref0 (label);
	_g_object_unref0 (hbox);
	return self;
}

BackupDeviceBox*
backup_device_box_new (GtkWindow* _parent_window)
{
	return backup_device_box_construct (TYPE_BACKUP_DEVICE_BOX, _parent_window);
}

void
backup_device_box_refresh (BackupDeviceBox* self)
{
	Main* _tmp0_;
	g_return_if_fail (self != NULL);
	backup_device_box_tv_devices_refresh (self);
	backup_device_box_check_backup_location (self);
	_tmp0_ = App;
	if (_tmp0_->btrfs_mode) {
		GtkLabel* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->lbl_common;
		_tmp2_ = g_strdup_printf ("<i>• %s\n• %s\n• %s</i>", _ ("Devices displayed above have BTRFS file systems."), _ ("BTRFS snapshots are saved on system partition. Other partitions are no" \
"t supported."), _ ("Snapshots are saved to /timeshift-btrfs on selected partition. Other l" \
"ocations are not supported."));
		_tmp3_ = _tmp2_;
		gtk_label_set_label (_tmp1_, _tmp3_);
		_g_free0 (_tmp3_);
	} else {
		GtkLabel* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->priv->lbl_common;
		_tmp5_ = g_strdup_printf ("<i>• %s\n• %s\n• %s\n• %s</i>", _ ("Devices displayed above have Linux file systems."), _ ("Devices with Windows file systems are not supported (NTFS, FAT, etc)."), _ ("Remote and network locations are not supported."), _ ("Snapshots are saved to /timeshift on selected partition. Other locatio" \
"ns are not supported."));
		_tmp6_ = _tmp5_;
		gtk_label_set_label (_tmp4_, _tmp6_);
		_g_free0 (_tmp6_);
	}
}

static void
__lambda42_ (BackupDeviceBox* self,
             GtkCellLayout* cell_layout,
             GtkCellRenderer* cell,
             GtkTreeModel* model,
             GtkTreeIter* iter)
{
	Device* dev = NULL;
	GtkTreeIter _tmp0_;
	Device* _tmp1_ = NULL;
	const gchar* _tmp2_;
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, -1, -1);
	_g_object_unref0 (dev);
	dev = _tmp1_;
	_tmp2_ = dev->type;
	gtk_cell_renderer_set_visible ((GtkCellRenderer*) G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_pixbuf_get_type (), GtkCellRendererPixbuf), g_strcmp0 (_tmp2_, "disk") == 0);
	_g_object_unref0 (dev);
}

static void
___lambda42__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                        GtkCellRenderer* cell,
                                        GtkTreeModel* tree_model,
                                        GtkTreeIter* iter,
                                        gpointer self)
{
	__lambda42_ ((BackupDeviceBox*) self, cell_layout, cell, tree_model, iter);
}

static void
__lambda43_ (BackupDeviceBox* self,
             GtkCellLayout* cell_layout,
             GtkCellRenderer* cell,
             GtkTreeModel* model,
             GtkTreeIter* iter)
{
	Device* dev = NULL;
	gboolean selected = FALSE;
	GtkTreeIter _tmp0_;
	Device* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	Device* _tmp5_;
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, 3, &_tmp2_, -1, -1);
	_g_object_unref0 (dev);
	dev = _tmp1_;
	selected = _tmp2_;
	gtk_cell_renderer_toggle_set_active (G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_toggle_get_type (), GtkCellRendererToggle), selected);
	_tmp5_ = dev;
	if (_tmp5_->size_bytes > ((guint64) (10 * TEE_JEE_FILE_SYSTEM_KB))) {
		Device* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = dev;
		_tmp7_ = _tmp6_->type;
		_tmp4_ = g_strcmp0 (_tmp7_, "disk") != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		Device* _tmp8_;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp8_ = dev;
		_tmp9_ = _tmp8_->children;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp3_ = _tmp11_ == 0;
	} else {
		_tmp3_ = FALSE;
	}
	gtk_cell_renderer_set_visible ((GtkCellRenderer*) G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_toggle_get_type (), GtkCellRendererToggle), _tmp3_);
	_g_object_unref0 (dev);
}

static void
___lambda43__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                        GtkCellRenderer* cell,
                                        GtkTreeModel* tree_model,
                                        GtkTreeIter* iter,
                                        gpointer self)
{
	__lambda43_ ((BackupDeviceBox*) self, cell_layout, cell, tree_model, iter);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
__lambda44_ (BackupDeviceBox* self,
             GtkCellLayout* cell_layout,
             GtkCellRenderer* cell,
             GtkTreeModel* model,
             GtkTreeIter* iter)
{
	Device* dev = NULL;
	GtkTreeIter _tmp0_;
	Device* _tmp1_ = NULL;
	Device* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, -1, -1);
	_g_object_unref0 (dev);
	dev = _tmp1_;
	_tmp2_ = dev;
	_tmp3_ = _tmp2_->type;
	if (g_strcmp0 (_tmp3_, "disk") == 0) {
		gchar* txt = NULL;
		Device* _tmp4_;
		const gchar* _tmp5_;
		Device* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp4_ = dev;
		_tmp5_ = _tmp4_->model;
		_tmp6_ = dev;
		_tmp7_ = _tmp6_->vendor;
		_tmp8_ = g_strdup_printf ("%s %s", _tmp5_, _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = string_strip (_tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		txt = _tmp11_;
		_tmp12_ = txt;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ == 0) {
			Device* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp15_ = dev;
			_tmp16_ = tee_jee_file_system_format_file_size (_tmp15_->size_bytes, FALSE, "", TRUE, 1);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_strdup_printf ("%s Disk", _tmp17_);
			_g_free0 (txt);
			txt = _tmp18_;
			_g_free0 (_tmp17_);
		}
		_tmp19_ = txt;
		_tmp20_ = string_strip (_tmp19_);
		_tmp21_ = _tmp20_;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), "text", _tmp21_, NULL);
		_g_free0 (_tmp21_);
		_g_free0 (txt);
	} else {
		Device* _tmp22_;
		const gchar* _tmp23_;
		_tmp22_ = dev;
		_tmp23_ = _tmp22_->kname;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), "text", _tmp23_, NULL);
	}
	_g_object_unref0 (dev);
}

static void
___lambda44__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                        GtkCellRenderer* cell,
                                        GtkTreeModel* tree_model,
                                        GtkTreeIter* iter,
                                        gpointer self)
{
	__lambda44_ ((BackupDeviceBox*) self, cell_layout, cell, tree_model, iter);
}

static void
__lambda45_ (BackupDeviceBox* self,
             GtkCellLayout* cell_layout,
             GtkCellRenderer* cell,
             GtkTreeModel* model,
             GtkTreeIter* iter)
{
	Device* dev = NULL;
	GtkTreeIter _tmp0_;
	Device* _tmp1_ = NULL;
	const gchar* _tmp2_;
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, -1, -1);
	_g_object_unref0 (dev);
	dev = _tmp1_;
	_tmp2_ = dev->fstype;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), "text", _tmp2_, NULL);
	_g_object_unref0 (dev);
}

static void
___lambda45__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                        GtkCellRenderer* cell,
                                        GtkTreeModel* tree_model,
                                        GtkTreeIter* iter,
                                        gpointer self)
{
	__lambda45_ ((BackupDeviceBox*) self, cell_layout, cell, tree_model, iter);
}

static void
__lambda46_ (BackupDeviceBox* self,
             GtkCellLayout* cell_layout,
             GtkCellRenderer* cell,
             GtkTreeModel* model,
             GtkTreeIter* iter)
{
	Device* dev = NULL;
	GtkTreeIter _tmp0_;
	Device* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	Device* _tmp3_;
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, -1, -1);
	_g_object_unref0 (dev);
	dev = _tmp1_;
	_tmp3_ = dev;
	if (_tmp3_->size_bytes > ((guint64) 0)) {
		Device* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = dev;
		_tmp5_ = tee_jee_file_system_format_file_size (_tmp4_->size_bytes, FALSE, "", TRUE, 0);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp5_;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("");
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp6_;
	}
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), "text", _tmp2_, NULL);
	_g_free0 (_tmp2_);
	_g_object_unref0 (dev);
}

static void
___lambda46__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                        GtkCellRenderer* cell,
                                        GtkTreeModel* tree_model,
                                        GtkTreeIter* iter,
                                        gpointer self)
{
	__lambda46_ ((BackupDeviceBox*) self, cell_layout, cell, tree_model, iter);
}

static void
__lambda47_ (BackupDeviceBox* self,
             GtkCellLayout* cell_layout,
             GtkCellRenderer* cell,
             GtkTreeModel* model,
             GtkTreeIter* iter)
{
	Device* dev = NULL;
	GtkTreeIter _tmp0_;
	Device* _tmp1_ = NULL;
	Device* _tmp2_;
	const gchar* _tmp3_;
	Device* _tmp13_;
	const gchar* _tmp14_;
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, -1, -1);
	_g_object_unref0 (dev);
	dev = _tmp1_;
	_tmp2_ = dev;
	_tmp3_ = _tmp2_->type;
	if (g_strcmp0 (_tmp3_, "disk") == 0) {
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), "text", "", NULL);
	} else {
		gchar* _tmp4_ = NULL;
		Device* _tmp5_;
		guint64 _tmp6_;
		guint64 _tmp7_;
		_tmp5_ = dev;
		_tmp6_ = device_get_free_bytes (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ > ((guint64) 0)) {
			Device* _tmp8_;
			guint64 _tmp9_;
			guint64 _tmp10_;
			gchar* _tmp11_;
			_tmp8_ = dev;
			_tmp9_ = device_get_free_bytes (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = tee_jee_file_system_format_file_size (_tmp10_, FALSE, "", TRUE, 0);
			_g_free0 (_tmp4_);
			_tmp4_ = _tmp11_;
		} else {
			gchar* _tmp12_;
			_tmp12_ = g_strdup ("");
			_g_free0 (_tmp4_);
			_tmp4_ = _tmp12_;
		}
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), "text", _tmp4_, NULL);
		_g_free0 (_tmp4_);
	}
	_tmp13_ = dev;
	_tmp14_ = _tmp13_->type;
	gtk_cell_renderer_set_sensitive ((GtkCellRenderer*) G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), g_strcmp0 (_tmp14_, "disk") != 0);
	_g_object_unref0 (dev);
}

static void
___lambda47__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                        GtkCellRenderer* cell,
                                        GtkTreeModel* tree_model,
                                        GtkTreeIter* iter,
                                        gpointer self)
{
	__lambda47_ ((BackupDeviceBox*) self, cell_layout, cell, tree_model, iter);
}

static void
__lambda48_ (BackupDeviceBox* self,
             GtkCellLayout* cell_layout,
             GtkCellRenderer* cell,
             GtkTreeModel* model,
             GtkTreeIter* iter)
{
	Device* dev = NULL;
	GtkTreeIter _tmp0_;
	Device* _tmp1_ = NULL;
	Device* _tmp2_;
	const gchar* _tmp3_;
	Device* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, -1, -1);
	_g_object_unref0 (dev);
	dev = _tmp1_;
	_tmp2_ = dev;
	_tmp3_ = _tmp2_->type;
	if (g_strcmp0 (_tmp3_, "disk") == 0) {
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), "text", "", NULL);
	} else {
		Device* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = dev;
		_tmp5_ = _tmp4_->partlabel;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), "text", _tmp5_, NULL);
	}
	_tmp6_ = dev;
	_tmp7_ = _tmp6_->type;
	gtk_cell_renderer_set_sensitive ((GtkCellRenderer*) G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), g_strcmp0 (_tmp7_, "disk") != 0);
	_g_object_unref0 (dev);
}

static void
___lambda48__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                        GtkCellRenderer* cell,
                                        GtkTreeModel* tree_model,
                                        GtkTreeIter* iter,
                                        gpointer self)
{
	__lambda48_ ((BackupDeviceBox*) self, cell_layout, cell, tree_model, iter);
}

static void
__lambda49_ (BackupDeviceBox* self,
             GtkCellLayout* cell_layout,
             GtkCellRenderer* cell,
             GtkTreeModel* model,
             GtkTreeIter* iter)
{
	Device* dev = NULL;
	GtkTreeIter _tmp0_;
	Device* _tmp1_ = NULL;
	Device* _tmp2_;
	const gchar* _tmp3_;
	Device* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, -1, -1);
	_g_object_unref0 (dev);
	dev = _tmp1_;
	_tmp2_ = dev;
	_tmp3_ = _tmp2_->type;
	if (g_strcmp0 (_tmp3_, "disk") == 0) {
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), "text", "", NULL);
	} else {
		Device* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = dev;
		_tmp5_ = _tmp4_->label;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), "text", _tmp5_, NULL);
	}
	_tmp6_ = dev;
	_tmp7_ = _tmp6_->type;
	gtk_cell_renderer_set_sensitive ((GtkCellRenderer*) G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), g_strcmp0 (_tmp7_, "disk") != 0);
	_g_object_unref0 (dev);
}

static void
___lambda49__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                        GtkCellRenderer* cell,
                                        GtkTreeModel* tree_model,
                                        GtkTreeIter* iter,
                                        gpointer self)
{
	__lambda49_ ((BackupDeviceBox*) self, cell_layout, cell, tree_model, iter);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		BackupDeviceBox* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->store);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda51_ (Block3Data* _data3_,
             GtkTreeModel* model,
             GtkTreePath* path,
             GtkTreeIter* iter)
{
	BackupDeviceBox* self;
	Device* dev = NULL;
	GtkTreeIter _tmp0_;
	Device* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Main* _tmp3_;
	SnapshotRepo* _tmp4_;
	Device* _tmp5_;
	self = _data3_->self;
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) _data3_->store, &_tmp0_, 0, &_tmp1_, -1);
	_g_object_unref0 (dev);
	dev = _tmp1_;
	_tmp3_ = App;
	_tmp4_ = _tmp3_->repo;
	_tmp5_ = _tmp4_->device;
	if (_tmp5_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		Main* _tmp6_;
		SnapshotRepo* _tmp7_;
		Device* _tmp8_;
		const gchar* _tmp9_;
		Device* _tmp10_;
		const gchar* _tmp11_;
		_tmp6_ = App;
		_tmp7_ = _tmp6_->repo;
		_tmp8_ = _tmp7_->device;
		_tmp9_ = _tmp8_->uuid;
		_tmp10_ = dev;
		_tmp11_ = _tmp10_->uuid;
		_tmp2_ = g_strcmp0 (_tmp9_, _tmp11_) != 0;
	}
	if (_tmp2_) {
		Device* _tmp12_;
		_tmp12_ = dev;
		backup_device_box_try_change_device (self, _tmp12_);
	} else {
		_g_object_unref0 (dev);
		return;
	}
	_g_object_unref0 (dev);
}

static void
___lambda51__gtk_tree_selection_foreach_func (GtkTreeModel* model,
                                              GtkTreePath* path,
                                              GtkTreeIter* iter,
                                              gpointer self)
{
	__lambda51_ (self, model, path, iter);
}

static gboolean
__lambda52_ (Block3Data* _data3_,
             GtkTreeModel* model,
             GtkTreePath* path,
             GtkTreeIter* iter)
{
	BackupDeviceBox* self;
	Device* dev = NULL;
	GtkTreeIter _tmp0_;
	Device* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Main* _tmp3_;
	SnapshotRepo* _tmp4_;
	Device* _tmp5_;
	gboolean result;
	self = _data3_->self;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) _data3_->store, &_tmp0_, 0, &_tmp1_, -1);
	_g_object_unref0 (dev);
	dev = _tmp1_;
	_tmp3_ = App;
	_tmp4_ = _tmp3_->repo;
	_tmp5_ = _tmp4_->device;
	if (_tmp5_ != NULL) {
		Main* _tmp6_;
		SnapshotRepo* _tmp7_;
		Device* _tmp8_;
		const gchar* _tmp9_;
		Device* _tmp10_;
		const gchar* _tmp11_;
		_tmp6_ = App;
		_tmp7_ = _tmp6_->repo;
		_tmp8_ = _tmp7_->device;
		_tmp9_ = _tmp8_->uuid;
		_tmp10_ = dev;
		_tmp11_ = _tmp10_->uuid;
		_tmp2_ = g_strcmp0 (_tmp9_, _tmp11_) == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GtkTreeIter _tmp12_;
		_tmp12_ = *iter;
		gtk_tree_store_set (_data3_->store, &_tmp12_, 3, TRUE, -1);
	} else {
		GtkTreeIter _tmp13_;
		_tmp13_ = *iter;
		gtk_tree_store_set (_data3_->store, &_tmp13_, 3, FALSE, -1);
	}
	result = FALSE;
	_g_object_unref0 (dev);
	return result;
}

static gboolean
___lambda52__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                          GtkTreePath* path,
                                          GtkTreeIter* iter,
                                          gpointer self)
{
	gboolean result;
	result = __lambda52_ (self, model, path, iter);
	return result;
}

static void
__lambda50_ (BackupDeviceBox* self,
             GtkTreePath* path,
             GtkTreeViewColumn* column)
{
	Block3Data* _data3_;
	GtkTreeView* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeStore* _tmp3_;
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp4_;
	GtkTreeSelection* _tmp5_;
	GtkTreeSelection* _tmp6_;
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->priv->tv_devices;
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_tree_store_get_type (), GtkTreeStore));
	_data3_->store = _tmp3_;
	_tmp4_ = self->priv->tv_devices;
	_tmp5_ = gtk_tree_view_get_selection (_tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	selection = _tmp6_;
	gtk_tree_selection_selected_foreach (selection, ___lambda51__gtk_tree_selection_foreach_func, _data3_);
	gtk_tree_model_foreach ((GtkTreeModel*) _data3_->store, ___lambda52__gtk_tree_model_foreach_func, _data3_);
	_g_object_unref0 (selection);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
___lambda50__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                          GtkTreePath* path,
                                          GtkTreeViewColumn* column,
                                          gpointer self)
{
	__lambda50_ ((BackupDeviceBox*) self, path, column);
}

static void
backup_device_box_init_tv_devices (BackupDeviceBox* self)
{
	GtkTreeView* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeView* _tmp2_;
	GtkTreeView* _tmp3_;
	GtkCellRendererPixbuf* cell_pix = NULL;
	GtkCellRendererToggle* cell_radio = NULL;
	GtkCellRendererText* cell_text = NULL;
	GtkTreeViewColumn* col = NULL;
	GtkTreeView* _tmp4_;
	GtkCellRendererPixbuf* _tmp5_ = NULL;
	GtkCellRendererToggle* _tmp6_ = NULL;
	GtkCellRendererText* _tmp7_ = NULL;
	GtkTreeViewColumn* _tmp8_;
	GtkTreeViewColumn* _tmp9_;
	GtkTreeViewColumn* _tmp10_;
	GtkTreeViewColumn* _tmp11_;
	GtkTreeViewColumn* _tmp12_;
	GtkTreeViewColumn* _tmp13_;
	GtkCellRendererText* _tmp14_;
	GtkTreeView* _tmp15_;
	GtkCellRendererText* _tmp16_ = NULL;
	GtkTreeViewColumn* _tmp17_;
	GtkTreeViewColumn* _tmp18_;
	GtkCellRendererText* _tmp19_;
	GtkTreeView* _tmp20_;
	GtkCellRendererText* _tmp21_ = NULL;
	GtkTreeViewColumn* _tmp22_;
	GtkCellRendererText* _tmp23_;
	GtkTreeViewColumn* _tmp24_;
	GtkCellRendererText* _tmp25_;
	GtkTreeView* _tmp26_;
	GtkCellRendererText* _tmp27_ = NULL;
	GtkTreeViewColumn* _tmp28_;
	GtkCellRendererText* _tmp29_;
	GtkTreeViewColumn* _tmp30_;
	GtkCellRendererText* _tmp31_;
	GtkTreeView* _tmp32_;
	GtkCellRendererText* _tmp33_ = NULL;
	GtkTreeViewColumn* _tmp34_;
	GtkCellRendererText* _tmp35_;
	GtkTreeViewColumn* _tmp36_;
	GtkCellRendererText* _tmp37_;
	GtkTreeView* _tmp38_;
	GtkCellRendererText* _tmp39_ = NULL;
	GtkTreeViewColumn* _tmp40_;
	GtkCellRendererText* _tmp41_;
	GtkTreeViewColumn* _tmp42_;
	GtkCellRendererText* _tmp43_;
	GtkTreeView* _tmp44_;
	GtkCellRendererText* _tmp45_ = NULL;
	GtkTreeViewColumn* _tmp46_;
	GtkTreeViewColumn* _tmp47_;
	GtkTreeView* _tmp48_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tee_jee_gtk_helper_add_treeview ((GtkBox*) self, GTK_SELECTION_SINGLE);
	_g_object_unref0 (self->priv->tv_devices);
	self->priv->tv_devices = _tmp0_;
	_tmp1_ = self->priv->tv_devices;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->tv_devices;
	gtk_tree_view_set_headers_clickable (_tmp2_, TRUE);
	_tmp3_ = self->priv->tv_devices;
	gtk_tree_view_set_activate_on_single_click (_tmp3_, TRUE);
	_tmp4_ = self->priv->tv_devices;
	_tmp8_ = tee_jee_gtk_helper_add_column_icon_radio_text (_tmp4_, _ ("Disk"), &_tmp5_, &_tmp6_, &_tmp7_);
	_g_object_unref0 (cell_pix);
	cell_pix = _tmp5_;
	_g_object_unref0 (cell_radio);
	cell_radio = _tmp6_;
	_g_object_unref0 (cell_text);
	cell_text = _tmp7_;
	col = _tmp8_;
	_tmp9_ = col;
	gtk_tree_view_column_set_resizable (_tmp9_, TRUE);
	_tmp10_ = col;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp10_, (GtkCellRenderer*) cell_pix, ___lambda42__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp11_ = col;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp11_, (GtkCellRenderer*) cell_pix, "icon-name", 2);
	_tmp12_ = col;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp12_, (GtkCellRenderer*) cell_radio, ___lambda43__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp13_ = col;
	_tmp14_ = cell_text;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp13_, (GtkCellRenderer*) _tmp14_, ___lambda44__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp15_ = self->priv->tv_devices;
	_tmp17_ = tee_jee_gtk_helper_add_column_text (_tmp15_, _ ("Type"), &_tmp16_);
	_g_object_unref0 (cell_text);
	cell_text = _tmp16_;
	_g_object_unref0 (col);
	col = _tmp17_;
	_tmp18_ = col;
	_tmp19_ = cell_text;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp18_, (GtkCellRenderer*) _tmp19_, ___lambda45__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp20_ = self->priv->tv_devices;
	_tmp22_ = tee_jee_gtk_helper_add_column_text (_tmp20_, _ ("Size"), &_tmp21_);
	_g_object_unref0 (cell_text);
	cell_text = _tmp21_;
	_g_object_unref0 (col);
	col = _tmp22_;
	_tmp23_ = cell_text;
	g_object_set ((GtkCellRenderer*) _tmp23_, "xalign", (gfloat) 1.0, NULL);
	_tmp24_ = col;
	_tmp25_ = cell_text;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp24_, (GtkCellRenderer*) _tmp25_, ___lambda46__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp26_ = self->priv->tv_devices;
	_tmp28_ = tee_jee_gtk_helper_add_column_text (_tmp26_, _ ("Free"), &_tmp27_);
	_g_object_unref0 (cell_text);
	cell_text = _tmp27_;
	_g_object_unref0 (col);
	col = _tmp28_;
	_tmp29_ = cell_text;
	g_object_set ((GtkCellRenderer*) _tmp29_, "xalign", (gfloat) 1.0, NULL);
	_tmp30_ = col;
	_tmp31_ = cell_text;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp30_, (GtkCellRenderer*) _tmp31_, ___lambda47__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp32_ = self->priv->tv_devices;
	_tmp34_ = tee_jee_gtk_helper_add_column_text (_tmp32_, _ ("Name"), &_tmp33_);
	_g_object_unref0 (cell_text);
	cell_text = _tmp33_;
	_g_object_unref0 (col);
	col = _tmp34_;
	_tmp35_ = cell_text;
	g_object_set ((GtkCellRenderer*) _tmp35_, "xalign", 0.0f, NULL);
	_tmp36_ = col;
	_tmp37_ = cell_text;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp36_, (GtkCellRenderer*) _tmp37_, ___lambda48__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp38_ = self->priv->tv_devices;
	_tmp40_ = tee_jee_gtk_helper_add_column_text (_tmp38_, _ ("Label"), &_tmp39_);
	_g_object_unref0 (cell_text);
	cell_text = _tmp39_;
	_g_object_unref0 (col);
	col = _tmp40_;
	_tmp41_ = cell_text;
	g_object_set ((GtkCellRenderer*) _tmp41_, "xalign", 0.0f, NULL);
	_tmp42_ = col;
	_tmp43_ = cell_text;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp42_, (GtkCellRenderer*) _tmp43_, ___lambda49__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp44_ = self->priv->tv_devices;
	_tmp46_ = tee_jee_gtk_helper_add_column_text (_tmp44_, "", &_tmp45_);
	_g_object_unref0 (cell_text);
	cell_text = _tmp45_;
	_g_object_unref0 (col);
	col = _tmp46_;
	_tmp47_ = col;
	gtk_tree_view_column_set_expand (_tmp47_, TRUE);
	_tmp48_ = self->priv->tv_devices;
	g_signal_connect_object (_tmp48_, "row-activated", (GCallback) ___lambda50__gtk_tree_view_row_activated, self, 0);
	_g_object_unref0 (col);
	_g_object_unref0 (cell_text);
	_g_object_unref0 (cell_radio);
	_g_object_unref0 (cell_pix);
}

static void
backup_device_box_init_infobar_location (BackupDeviceBox* self)
{
	GtkInfoBar* infobar = NULL;
	GtkInfoBar* _tmp0_;
	GtkInfoBar* _tmp1_;
	GtkBox* content = NULL;
	GtkContainer* _tmp2_;
	GtkBox* _tmp3_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkScrolledWindow* scrolled = NULL;
	GtkScrolledWindow* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkInfoBar*) gtk_info_bar_new ();
	g_object_ref_sink (_tmp0_);
	infobar = _tmp0_;
	gtk_widget_set_no_show_all ((GtkWidget*) infobar, TRUE);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) infobar);
	_tmp1_ = _g_object_ref0 (infobar);
	_g_object_unref0 (self->priv->infobar_location);
	self->priv->infobar_location = _tmp1_;
	_tmp2_ = gtk_info_bar_get_content_area (infobar);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_box_get_type (), GtkBox));
	content = _tmp3_;
	_tmp4_ = tee_jee_gtk_helper_add_label (content, "", FALSE, FALSE, FALSE);
	label = _tmp4_;
	_tmp5_ = label;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->lbl_infobar_location);
	self->priv->lbl_infobar_location = _tmp6_;
	_tmp7_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp7_);
	scrolled = _tmp7_;
	gtk_scrolled_window_set_shadow_type (scrolled, GTK_SHADOW_ETCHED_IN);
	g_object_set (scrolled, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_set (scrolled, "vscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_widget_set_size_request ((GtkWidget*) scrolled, -1, 100);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) scrolled);
	_tmp8_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (label);
	label = _tmp8_;
	_tmp9_ = label;
	gtk_label_set_use_markup (_tmp9_, TRUE);
	_tmp10_ = label;
	gtk_label_set_xalign (_tmp10_, (gfloat) 0.0);
	_tmp11_ = label;
	g_object_set (_tmp11_, "wrap", TRUE, NULL);
	_tmp12_ = label;
	g_object_set (_tmp12_, "wrap-mode", PANGO_WRAP_WORD, NULL);
	_tmp13_ = label;
	g_object_set ((GtkWidget*) _tmp13_, "margin", 6, NULL);
	_tmp14_ = label;
	gtk_container_add ((GtkContainer*) scrolled, (GtkWidget*) _tmp14_);
	_tmp15_ = label;
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_g_object_unref0 (self->priv->lbl_common);
	self->priv->lbl_common = _tmp16_;
	_g_object_unref0 (scrolled);
	_g_object_unref0 (label);
	_g_object_unref0 (content);
	_g_object_unref0 (infobar);
}

static void
backup_device_box_try_change_device (BackupDeviceBox* self,
                                     Device* dev)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dev != NULL);
	_tmp0_ = dev->device;
	_tmp1_ = g_strdup_printf ("try_change_device: %s", _tmp0_);
	_tmp2_ = _tmp1_;
	tee_jee_logging_log_debug (_tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = dev->type;
	if (g_strcmp0 (_tmp3_, "disk") == 0) {
		gboolean found_child = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		Main* _tmp6_;
		found_child = FALSE;
		_tmp6_ = App;
		if (_tmp6_->btrfs_mode) {
			const gchar* _tmp7_;
			_tmp7_ = dev->fstype;
			_tmp5_ = g_strcmp0 (_tmp7_, "btrfs") == 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			gboolean _tmp8_ = FALSE;
			Main* _tmp9_;
			_tmp9_ = App;
			if (!_tmp9_->btrfs_mode) {
				_tmp8_ = device_has_linux_filesystem (dev);
			} else {
				_tmp8_ = FALSE;
			}
			_tmp4_ = _tmp8_;
		}
		if (_tmp4_) {
			backup_device_box_change_backup_device (self, dev);
			found_child = TRUE;
		}
		if (!found_child) {
			{
				GeeArrayList* _child_list = NULL;
				GeeArrayList* _tmp10_;
				gint _child_size = 0;
				GeeArrayList* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _child_index = 0;
				_tmp10_ = dev->children;
				_child_list = _tmp10_;
				_tmp11_ = _child_list;
				_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
				_tmp13_ = _tmp12_;
				_child_size = _tmp13_;
				_child_index = -1;
				while (TRUE) {
					gint _tmp14_;
					gint _tmp15_;
					Device* child = NULL;
					GeeArrayList* _tmp16_;
					gpointer _tmp17_;
					gboolean _tmp18_ = FALSE;
					gboolean _tmp19_ = FALSE;
					Main* _tmp20_;
					_child_index = _child_index + 1;
					_tmp14_ = _child_index;
					_tmp15_ = _child_size;
					if (!(_tmp14_ < _tmp15_)) {
						break;
					}
					_tmp16_ = _child_list;
					_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _child_index);
					child = (Device*) _tmp17_;
					_tmp20_ = App;
					if (_tmp20_->btrfs_mode) {
						Device* _tmp21_;
						const gchar* _tmp22_;
						_tmp21_ = child;
						_tmp22_ = _tmp21_->fstype;
						_tmp19_ = g_strcmp0 (_tmp22_, "btrfs") == 0;
					} else {
						_tmp19_ = FALSE;
					}
					if (_tmp19_) {
						_tmp18_ = TRUE;
					} else {
						gboolean _tmp23_ = FALSE;
						Main* _tmp24_;
						_tmp24_ = App;
						if (!_tmp24_->btrfs_mode) {
							Device* _tmp25_;
							_tmp25_ = child;
							_tmp23_ = device_has_linux_filesystem (_tmp25_);
						} else {
							_tmp23_ = FALSE;
						}
						_tmp18_ = _tmp23_;
					}
					if (_tmp18_) {
						Device* _tmp26_;
						_tmp26_ = child;
						backup_device_box_change_backup_device (self, _tmp26_);
						found_child = TRUE;
						_g_object_unref0 (child);
						break;
					}
					_g_object_unref0 (child);
				}
			}
		}
		if (!found_child) {
			gchar* msg = NULL;
			gchar* _tmp27_;
			Main* _tmp28_;
			GtkLabel* _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			GtkInfoBar* _tmp34_;
			GtkInfoBar* _tmp35_;
			GtkInfoBar* _tmp36_;
			_tmp27_ = g_strdup (_ ("Selected device does not have Linux partition"));
			msg = _tmp27_;
			_tmp28_ = App;
			if (_tmp28_->btrfs_mode) {
				gchar* _tmp29_;
				_tmp29_ = g_strdup (_ ("Selected device does not have BTRFS partition"));
				_g_free0 (msg);
				msg = _tmp29_;
			}
			_tmp30_ = self->priv->lbl_infobar_location;
			_tmp31_ = msg;
			_tmp32_ = g_strdup_printf ("<span weight=\"bold\">%s</span>", _tmp31_);
			_tmp33_ = _tmp32_;
			gtk_label_set_label (_tmp30_, _tmp33_);
			_g_free0 (_tmp33_);
			_tmp34_ = self->priv->infobar_location;
			gtk_info_bar_set_message_type (_tmp34_, GTK_MESSAGE_ERROR);
			_tmp35_ = self->priv->infobar_location;
			gtk_widget_set_no_show_all ((GtkWidget*) _tmp35_, FALSE);
			_tmp36_ = self->priv->infobar_location;
			gtk_widget_show_all ((GtkWidget*) _tmp36_);
			_g_free0 (msg);
		}
	} else {
		if (device_has_children (dev)) {
			GeeArrayList* _tmp37_;
			gpointer _tmp38_;
			Device* _tmp39_;
			_tmp37_ = dev->children;
			_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, 0);
			_tmp39_ = (Device*) _tmp38_;
			backup_device_box_change_backup_device (self, _tmp39_);
			_g_object_unref0 (_tmp39_);
		} else {
			if (!device_has_children (dev)) {
				backup_device_box_change_backup_device (self, dev);
			} else {
				GtkLabel* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				GtkInfoBar* _tmp43_;
				GtkInfoBar* _tmp44_;
				GtkInfoBar* _tmp45_;
				_tmp40_ = self->priv->lbl_infobar_location;
				_tmp41_ = g_strdup_printf ("<span weight=\"bold\">%s</span>", _ ("Select a partition on this disk"));
				_tmp42_ = _tmp41_;
				gtk_label_set_label (_tmp40_, _tmp42_);
				_g_free0 (_tmp42_);
				_tmp43_ = self->priv->infobar_location;
				gtk_info_bar_set_message_type (_tmp43_, GTK_MESSAGE_ERROR);
				_tmp44_ = self->priv->infobar_location;
				gtk_widget_set_no_show_all ((GtkWidget*) _tmp44_, FALSE);
				_tmp45_ = self->priv->infobar_location;
				gtk_widget_show_all ((GtkWidget*) _tmp45_);
			}
		}
	}
}

static void
backup_device_box_change_backup_device (BackupDeviceBox* self,
                                        Device* pi)
{
	gboolean _tmp0_ = FALSE;
	Main* _tmp1_;
	SnapshotRepo* _tmp2_;
	Device* _tmp3_;
	GtkWindow* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	Main* _tmp16_;
	GtkWindow* _tmp17_;
	Main* _tmp18_;
	SnapshotRepo* _tmp19_;
	const gchar* _tmp20_;
	GtkWindow* _tmp54_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pi != NULL);
	_tmp1_ = App;
	_tmp2_ = _tmp1_->repo;
	_tmp3_ = _tmp2_->device;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		Main* _tmp5_;
		SnapshotRepo* _tmp6_;
		Device* _tmp7_;
		const gchar* _tmp8_;
		_tmp4_ = pi->uuid;
		_tmp5_ = App;
		_tmp6_ = _tmp5_->repo;
		_tmp7_ = _tmp6_->device;
		_tmp8_ = _tmp7_->uuid;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp8_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp9_ = self->priv->parent_window;
	tee_jee_gtk_helper_gtk_set_busy (TRUE, _tmp9_);
	tee_jee_logging_log_debug ("\n");
	_tmp10_ = pi->device;
	_tmp11_ = g_strdup_printf ("selected device: %s", _tmp10_);
	_tmp12_ = _tmp11_;
	tee_jee_logging_log_msg (_tmp12_, FALSE);
	_g_free0 (_tmp12_);
	_tmp13_ = pi->fstype;
	_tmp14_ = g_strdup_printf ("fstype: %s", _tmp13_);
	_tmp15_ = _tmp14_;
	tee_jee_logging_log_debug (_tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = App;
	_tmp17_ = self->priv->parent_window;
	_tmp18_ = App;
	_tmp19_ = snapshot_repo_new_from_device (pi, _tmp17_, _tmp18_->btrfs_mode);
	_g_object_unref0 (_tmp16_->repo);
	_tmp16_->repo = _tmp19_;
	_tmp20_ = pi->fstype;
	if (g_strcmp0 (_tmp20_, "luks") == 0) {
		Main* _tmp21_;
		Device* dev = NULL;
		Main* _tmp22_;
		GeeArrayList* _tmp23_;
		const gchar* _tmp24_;
		Device* _tmp25_;
		Device* _tmp26_;
		_tmp21_ = App;
		main_update_partitions (_tmp21_);
		_tmp22_ = App;
		_tmp23_ = _tmp22_->partitions;
		_tmp24_ = pi->uuid;
		_tmp25_ = device_find_device_in_list (_tmp23_, _tmp24_);
		dev = _tmp25_;
		_tmp26_ = dev;
		if (device_has_children (_tmp26_)) {
			Device* _tmp27_;
			GeeArrayList* _tmp28_;
			gpointer _tmp29_;
			Device* _tmp30_;
			gboolean _tmp31_;
			tee_jee_logging_log_debug ("has children");
			_tmp27_ = dev;
			_tmp28_ = _tmp27_->children;
			_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, 0);
			_tmp30_ = (Device*) _tmp29_;
			_tmp31_ = device_has_linux_filesystem (_tmp30_);
			_g_object_unref0 (_tmp30_);
			if (_tmp31_) {
				Device* _tmp32_;
				GeeArrayList* _tmp33_;
				gpointer _tmp34_;
				Device* _tmp35_;
				const gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				Device* _tmp39_;
				GeeArrayList* _tmp40_;
				gpointer _tmp41_;
				Device* _tmp42_;
				const gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				Main* _tmp46_;
				Device* _tmp47_;
				GeeArrayList* _tmp48_;
				gpointer _tmp49_;
				Device* _tmp50_;
				GtkWindow* _tmp51_;
				Main* _tmp52_;
				SnapshotRepo* _tmp53_;
				_tmp32_ = dev;
				_tmp33_ = _tmp32_->children;
				_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, 0);
				_tmp35_ = (Device*) _tmp34_;
				_tmp36_ = _tmp35_->fstype;
				_tmp37_ = g_strdup_printf ("has linux filesystem: %s", _tmp36_);
				_tmp38_ = _tmp37_;
				tee_jee_logging_log_debug (_tmp38_);
				_g_free0 (_tmp38_);
				_g_object_unref0 (_tmp35_);
				_tmp39_ = dev;
				_tmp40_ = _tmp39_->children;
				_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp40_, 0);
				_tmp42_ = (Device*) _tmp41_;
				_tmp43_ = _tmp42_->device;
				_tmp44_ = g_strdup_printf ("selecting child device: %s", _tmp43_);
				_tmp45_ = _tmp44_;
				tee_jee_logging_log_msg (_tmp45_, FALSE);
				_g_free0 (_tmp45_);
				_g_object_unref0 (_tmp42_);
				_tmp46_ = App;
				_tmp47_ = dev;
				_tmp48_ = _tmp47_->children;
				_tmp49_ = gee_abstract_list_get ((GeeAbstractList*) _tmp48_, 0);
				_tmp50_ = (Device*) _tmp49_;
				_tmp51_ = self->priv->parent_window;
				_tmp52_ = App;
				_tmp53_ = snapshot_repo_new_from_device (_tmp50_, _tmp51_, _tmp52_->btrfs_mode);
				_g_object_unref0 (_tmp46_->repo);
				_tmp46_->repo = _tmp53_;
				_g_object_unref0 (_tmp50_);
				backup_device_box_tv_devices_refresh (self);
			} else {
				tee_jee_logging_log_debug ("does not have linux filesystem");
			}
		}
		_g_object_unref0 (dev);
	}
	backup_device_box_check_backup_location (self);
	_tmp54_ = self->priv->parent_window;
	tee_jee_gtk_helper_gtk_set_busy (FALSE, _tmp54_);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
backup_device_box_check_backup_location (BackupDeviceBox* self)
{
	gboolean ok = FALSE;
	Main* _tmp0_;
	SnapshotRepo* _tmp1_;
	gchar* message = NULL;
	Main* _tmp2_;
	SnapshotRepo* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* details = NULL;
	Main* _tmp6_;
	SnapshotRepo* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gint status_code = 0;
	Main* _tmp10_;
	SnapshotRepo* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	Main* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	ok = TRUE;
	_tmp0_ = App;
	_tmp1_ = _tmp0_->repo;
	snapshot_repo_check_status (_tmp1_);
	_tmp2_ = App;
	_tmp3_ = _tmp2_->repo;
	_tmp4_ = _tmp3_->status_message;
	_tmp5_ = g_strdup (_tmp4_);
	message = _tmp5_;
	_tmp6_ = App;
	_tmp7_ = _tmp6_->repo;
	_tmp8_ = _tmp7_->status_details;
	_tmp9_ = g_strdup (_tmp8_);
	details = _tmp9_;
	_tmp10_ = App;
	_tmp11_ = _tmp10_->repo;
	status_code = (gint) _tmp11_->status_code;
	_tmp12_ = message;
	_tmp13_ = tee_jee_misc_escape_html (_tmp12_);
	_g_free0 (message);
	message = _tmp13_;
	_tmp14_ = details;
	_tmp15_ = tee_jee_misc_escape_html (_tmp14_);
	_g_free0 (details);
	details = _tmp15_;
	_tmp16_ = App;
	if (main_live_system (_tmp16_)) {
		switch (status_code) {
			case SNAPSHOT_LOCATION_STATUS_NOT_SELECTED:
			{
				GtkLabel* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				GtkInfoBar* _tmp21_;
				GtkInfoBar* _tmp22_;
				GtkInfoBar* _tmp23_;
				_tmp17_ = self->priv->lbl_infobar_location;
				_tmp18_ = details;
				_tmp19_ = g_strdup_printf ("<span weight=\"bold\">%s</span>", _tmp18_);
				_tmp20_ = _tmp19_;
				gtk_label_set_label (_tmp17_, _tmp20_);
				_g_free0 (_tmp20_);
				_tmp21_ = self->priv->infobar_location;
				gtk_info_bar_set_message_type (_tmp21_, GTK_MESSAGE_ERROR);
				_tmp22_ = self->priv->infobar_location;
				gtk_widget_set_no_show_all ((GtkWidget*) _tmp22_, FALSE);
				_tmp23_ = self->priv->infobar_location;
				gtk_widget_show_all ((GtkWidget*) _tmp23_);
				ok = FALSE;
				break;
			}
			case SNAPSHOT_LOCATION_STATUS_NOT_AVAILABLE:
			{
				GtkLabel* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				GtkInfoBar* _tmp28_;
				GtkInfoBar* _tmp29_;
				GtkInfoBar* _tmp30_;
				_tmp24_ = self->priv->lbl_infobar_location;
				_tmp25_ = message;
				_tmp26_ = g_strdup_printf ("<span weight=\"bold\">%s</span>", _tmp25_);
				_tmp27_ = _tmp26_;
				gtk_label_set_label (_tmp24_, _tmp27_);
				_g_free0 (_tmp27_);
				_tmp28_ = self->priv->infobar_location;
				gtk_info_bar_set_message_type (_tmp28_, GTK_MESSAGE_ERROR);
				_tmp29_ = self->priv->infobar_location;
				gtk_widget_set_no_show_all ((GtkWidget*) _tmp29_, FALSE);
				_tmp30_ = self->priv->infobar_location;
				gtk_widget_show_all ((GtkWidget*) _tmp30_);
				ok = FALSE;
				break;
			}
			case SNAPSHOT_LOCATION_STATUS_READ_ONLY_FS:
			case SNAPSHOT_LOCATION_STATUS_HARDLINKS_NOT_SUPPORTED:
			{
				GtkLabel* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				GtkInfoBar* _tmp35_;
				GtkInfoBar* _tmp36_;
				GtkInfoBar* _tmp37_;
				_tmp31_ = self->priv->lbl_infobar_location;
				_tmp32_ = message;
				_tmp33_ = g_strdup_printf ("<span weight=\"bold\">%s</span>", _tmp32_);
				_tmp34_ = _tmp33_;
				gtk_label_set_label (_tmp31_, _tmp34_);
				_g_free0 (_tmp34_);
				_tmp35_ = self->priv->infobar_location;
				gtk_info_bar_set_message_type (_tmp35_, GTK_MESSAGE_ERROR);
				_tmp36_ = self->priv->infobar_location;
				gtk_widget_set_no_show_all ((GtkWidget*) _tmp36_, FALSE);
				_tmp37_ = self->priv->infobar_location;
				gtk_widget_show_all ((GtkWidget*) _tmp37_);
				ok = FALSE;
				break;
			}
			case SNAPSHOT_LOCATION_STATUS_NO_BTRFS_SYSTEM:
			{
				GtkLabel* _tmp38_;
				const gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				GtkInfoBar* _tmp42_;
				GtkInfoBar* _tmp43_;
				GtkInfoBar* _tmp44_;
				_tmp38_ = self->priv->lbl_infobar_location;
				_tmp39_ = details;
				_tmp40_ = g_strdup_printf ("<span weight=\"bold\">%s</span>", _tmp39_);
				_tmp41_ = _tmp40_;
				gtk_label_set_label (_tmp38_, _tmp41_);
				_g_free0 (_tmp41_);
				_tmp42_ = self->priv->infobar_location;
				gtk_info_bar_set_message_type (_tmp42_, GTK_MESSAGE_ERROR);
				_tmp43_ = self->priv->infobar_location;
				gtk_widget_set_no_show_all ((GtkWidget*) _tmp43_, FALSE);
				_tmp44_ = self->priv->infobar_location;
				gtk_widget_show_all ((GtkWidget*) _tmp44_);
				ok = FALSE;
				break;
			}
			case SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_HAS_SPACE:
			case SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_NO_SPACE:
			{
				GtkLabel* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				GtkInfoBar* _tmp48_;
				GtkInfoBar* _tmp49_;
				GtkInfoBar* _tmp50_;
				_tmp45_ = self->priv->lbl_infobar_location;
				_tmp46_ = g_strdup_printf ("<span weight=\"bold\">%s</span>", _ ("There are no snapshots on this device"));
				_tmp47_ = _tmp46_;
				gtk_label_set_label (_tmp45_, _tmp47_);
				_g_free0 (_tmp47_);
				_tmp48_ = self->priv->infobar_location;
				gtk_info_bar_set_message_type (_tmp48_, GTK_MESSAGE_ERROR);
				_tmp49_ = self->priv->infobar_location;
				gtk_widget_set_no_show_all ((GtkWidget*) _tmp49_, FALSE);
				_tmp50_ = self->priv->infobar_location;
				gtk_widget_show_all ((GtkWidget*) _tmp50_);
				break;
			}
			case SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_NO_SPACE:
			case SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_HAS_SPACE:
			{
				GtkInfoBar* _tmp51_;
				_tmp51_ = self->priv->infobar_location;
				gtk_widget_hide ((GtkWidget*) _tmp51_);
				break;
			}
			default:
			break;
		}
	} else {
		switch (status_code) {
			case SNAPSHOT_LOCATION_STATUS_NOT_SELECTED:
			{
				GtkLabel* _tmp52_;
				const gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				GtkInfoBar* _tmp56_;
				GtkInfoBar* _tmp57_;
				GtkInfoBar* _tmp58_;
				_tmp52_ = self->priv->lbl_infobar_location;
				_tmp53_ = details;
				_tmp54_ = g_strdup_printf ("<span weight=\"bold\">%s</span>", _tmp53_);
				_tmp55_ = _tmp54_;
				gtk_label_set_label (_tmp52_, _tmp55_);
				_g_free0 (_tmp55_);
				_tmp56_ = self->priv->infobar_location;
				gtk_info_bar_set_message_type (_tmp56_, GTK_MESSAGE_ERROR);
				_tmp57_ = self->priv->infobar_location;
				gtk_widget_set_no_show_all ((GtkWidget*) _tmp57_, FALSE);
				_tmp58_ = self->priv->infobar_location;
				gtk_widget_show_all ((GtkWidget*) _tmp58_);
				ok = FALSE;
				break;
			}
			case SNAPSHOT_LOCATION_STATUS_NOT_AVAILABLE:
			case SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_NO_SPACE:
			case SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_NO_SPACE:
			{
				GtkLabel* _tmp59_;
				const gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				GtkInfoBar* _tmp65_;
				GtkInfoBar* _tmp66_;
				GtkInfoBar* _tmp67_;
				_tmp59_ = self->priv->lbl_infobar_location;
				_tmp60_ = message;
				_tmp61_ = string_replace (_tmp60_, "<", "&lt;");
				_tmp62_ = _tmp61_;
				_tmp63_ = g_strdup_printf ("<span weight=\"bold\">%s</span>", _tmp62_);
				_tmp64_ = _tmp63_;
				gtk_label_set_label (_tmp59_, _tmp64_);
				_g_free0 (_tmp64_);
				_g_free0 (_tmp62_);
				_tmp65_ = self->priv->infobar_location;
				gtk_info_bar_set_message_type (_tmp65_, GTK_MESSAGE_ERROR);
				_tmp66_ = self->priv->infobar_location;
				gtk_widget_set_no_show_all ((GtkWidget*) _tmp66_, FALSE);
				_tmp67_ = self->priv->infobar_location;
				gtk_widget_show_all ((GtkWidget*) _tmp67_);
				ok = FALSE;
				break;
			}
			case SNAPSHOT_LOCATION_STATUS_READ_ONLY_FS:
			case SNAPSHOT_LOCATION_STATUS_HARDLINKS_NOT_SUPPORTED:
			{
				GtkLabel* _tmp68_;
				const gchar* _tmp69_;
				gchar* _tmp70_;
				gchar* _tmp71_;
				GtkInfoBar* _tmp72_;
				GtkInfoBar* _tmp73_;
				GtkInfoBar* _tmp74_;
				_tmp68_ = self->priv->lbl_infobar_location;
				_tmp69_ = message;
				_tmp70_ = g_strdup_printf ("<span weight=\"bold\">%s</span>", _tmp69_);
				_tmp71_ = _tmp70_;
				gtk_label_set_label (_tmp68_, _tmp71_);
				_g_free0 (_tmp71_);
				_tmp72_ = self->priv->infobar_location;
				gtk_info_bar_set_message_type (_tmp72_, GTK_MESSAGE_ERROR);
				_tmp73_ = self->priv->infobar_location;
				gtk_widget_set_no_show_all ((GtkWidget*) _tmp73_, FALSE);
				_tmp74_ = self->priv->infobar_location;
				gtk_widget_show_all ((GtkWidget*) _tmp74_);
				ok = FALSE;
				break;
			}
			case SNAPSHOT_LOCATION_STATUS_NO_BTRFS_SYSTEM:
			{
				GtkLabel* _tmp75_;
				const gchar* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				GtkInfoBar* _tmp79_;
				GtkInfoBar* _tmp80_;
				GtkInfoBar* _tmp81_;
				_tmp75_ = self->priv->lbl_infobar_location;
				_tmp76_ = details;
				_tmp77_ = g_strdup_printf ("<span weight=\"bold\">%s</span>", _tmp76_);
				_tmp78_ = _tmp77_;
				gtk_label_set_label (_tmp75_, _tmp78_);
				_g_free0 (_tmp78_);
				_tmp79_ = self->priv->infobar_location;
				gtk_info_bar_set_message_type (_tmp79_, GTK_MESSAGE_ERROR);
				_tmp80_ = self->priv->infobar_location;
				gtk_widget_set_no_show_all ((GtkWidget*) _tmp80_, FALSE);
				_tmp81_ = self->priv->infobar_location;
				gtk_widget_show_all ((GtkWidget*) _tmp81_);
				ok = FALSE;
				break;
			}
			case 3:
			case 0:
			{
				GtkInfoBar* _tmp82_;
				_tmp82_ = self->priv->infobar_location;
				gtk_widget_hide ((GtkWidget*) _tmp82_);
				break;
			}
			default:
			break;
		}
	}
	result = ok;
	_g_free0 (details);
	_g_free0 (message);
	return result;
}

static void
backup_device_box_tv_devices_refresh (BackupDeviceBox* self)
{
	Main* _tmp0_;
	GtkTreeStore* model = NULL;
	GtkTreeStore* _tmp1_;
	GtkTreeView* _tmp2_;
	GtkTreeStore* _tmp3_;
	GtkTreeIter iter0 = {0};
	GtkTreeView* _tmp30_;
	GtkTreeView* _tmp31_;
	g_return_if_fail (self != NULL);
	_tmp0_ = App;
	main_update_partitions (_tmp0_);
	_tmp1_ = gtk_tree_store_new (4, TYPE_DEVICE, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);
	model = _tmp1_;
	_tmp2_ = self->priv->tv_devices;
	_tmp3_ = model;
	gtk_tree_view_set_model (_tmp2_, (GtkTreeModel*) _tmp3_);
	{
		GeeArrayList* _disk_list = NULL;
		Main* _tmp4_;
		GeeArrayList* _tmp5_;
		gint _disk_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _disk_index = 0;
		_tmp4_ = App;
		_tmp5_ = _tmp4_->partitions;
		_disk_list = _tmp5_;
		_tmp6_ = _disk_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_disk_size = _tmp8_;
		_disk_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			Device* disk = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			Device* _tmp13_;
			const gchar* _tmp14_;
			GtkTreeStore* _tmp15_;
			GtkTreeIter _tmp16_ = {0};
			GtkTreeStore* _tmp17_;
			GtkTreeIter _tmp18_;
			Device* _tmp19_;
			GtkTreeStore* _tmp20_;
			GtkTreeIter _tmp21_;
			Device* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			GtkTreeStore* _tmp25_;
			GtkTreeIter _tmp26_;
			GtkTreeStore* _tmp27_;
			GtkTreeIter _tmp28_;
			Device* _tmp29_;
			_disk_index = _disk_index + 1;
			_tmp9_ = _disk_index;
			_tmp10_ = _disk_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _disk_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _disk_index);
			disk = (Device*) _tmp12_;
			_tmp13_ = disk;
			_tmp14_ = _tmp13_->type;
			if (g_strcmp0 (_tmp14_, "disk") != 0) {
				_g_object_unref0 (disk);
				continue;
			}
			_tmp15_ = model;
			gtk_tree_store_append (_tmp15_, &_tmp16_, NULL);
			iter0 = _tmp16_;
			_tmp17_ = model;
			_tmp18_ = iter0;
			_tmp19_ = disk;
			gtk_tree_store_set (_tmp17_, &_tmp18_, 0, _tmp19_, -1, -1);
			_tmp20_ = model;
			_tmp21_ = iter0;
			_tmp22_ = disk;
			_tmp23_ = device_tooltip_text (_tmp22_);
			_tmp24_ = _tmp23_;
			gtk_tree_store_set (_tmp20_, &_tmp21_, 1, _tmp24_, -1, -1);
			_g_free0 (_tmp24_);
			_tmp25_ = model;
			_tmp26_ = iter0;
			gtk_tree_store_set (_tmp25_, &_tmp26_, 2, ICON_MANAGER_ICON_HARDDRIVE, -1, -1);
			_tmp27_ = model;
			_tmp28_ = iter0;
			gtk_tree_store_set (_tmp27_, &_tmp28_, 3, FALSE, -1, -1);
			_tmp29_ = disk;
			backup_device_box_tv_append_child_volumes (self, &model, &iter0, _tmp29_);
			_g_object_unref0 (disk);
		}
	}
	_tmp30_ = self->priv->tv_devices;
	gtk_tree_view_expand_all (_tmp30_);
	_tmp31_ = self->priv->tv_devices;
	gtk_tree_view_columns_autosize (_tmp31_);
	_g_object_unref0 (model);
}

static void
backup_device_box_tv_append_child_volumes (BackupDeviceBox* self,
                                           GtkTreeStore** model,
                                           GtkTreeIter* iter0,
                                           Device* parent)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (*model != NULL);
	g_return_if_fail (iter0 != NULL);
	g_return_if_fail (parent != NULL);
	{
		GeeArrayList* _part_list = NULL;
		Main* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _part_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _part_index = 0;
		_tmp0_ = App;
		_tmp1_ = _tmp0_->partitions;
		_part_list = _tmp1_;
		_tmp2_ = _part_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_part_size = _tmp4_;
		_part_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			Device* part = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			Device* _tmp9_;
			Main* _tmp10_;
			Device* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			_part_index = _part_index + 1;
			_tmp5_ = _part_index;
			_tmp6_ = _part_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _part_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _part_index);
			part = (Device*) _tmp8_;
			_tmp9_ = part;
			if (!device_has_linux_filesystem (_tmp9_)) {
				_g_object_unref0 (part);
				continue;
			}
			_tmp10_ = App;
			if (_tmp10_->btrfs_mode) {
				gboolean _tmp11_ = FALSE;
				Device* _tmp12_;
				_tmp12_ = part;
				if (device_is_encrypted_partition (_tmp12_)) {
					gboolean _tmp13_ = FALSE;
					Device* _tmp14_;
					_tmp14_ = part;
					if (!device_has_children (_tmp14_)) {
						_tmp13_ = TRUE;
					} else {
						Device* _tmp15_;
						GeeArrayList* _tmp16_;
						gpointer _tmp17_;
						Device* _tmp18_;
						const gchar* _tmp19_;
						_tmp15_ = part;
						_tmp16_ = _tmp15_->children;
						_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, 0);
						_tmp18_ = (Device*) _tmp17_;
						_tmp19_ = _tmp18_->fstype;
						_tmp13_ = g_strcmp0 (_tmp19_, "btrfs") == 0;
						_g_object_unref0 (_tmp18_);
					}
					_tmp11_ = _tmp13_;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
				} else {
					gboolean _tmp20_ = FALSE;
					Device* _tmp21_;
					_tmp21_ = part;
					if (device_is_lvm_partition (_tmp21_)) {
						gboolean _tmp22_ = FALSE;
						Device* _tmp23_;
						_tmp23_ = part;
						if (!device_has_children (_tmp23_)) {
							_tmp22_ = TRUE;
						} else {
							Device* _tmp24_;
							GeeArrayList* _tmp25_;
							gpointer _tmp26_;
							Device* _tmp27_;
							const gchar* _tmp28_;
							_tmp24_ = part;
							_tmp25_ = _tmp24_->children;
							_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, 0);
							_tmp27_ = (Device*) _tmp26_;
							_tmp28_ = _tmp27_->fstype;
							_tmp22_ = g_strcmp0 (_tmp28_, "btrfs") == 0;
							_g_object_unref0 (_tmp27_);
						}
						_tmp20_ = _tmp22_;
					} else {
						_tmp20_ = FALSE;
					}
					if (_tmp20_) {
					} else {
						Device* _tmp29_;
						const gchar* _tmp30_;
						_tmp29_ = part;
						_tmp30_ = _tmp29_->fstype;
						if (g_strcmp0 (_tmp30_, "btrfs") == 0) {
						} else {
							_g_object_unref0 (part);
							continue;
						}
					}
				}
			}
			_tmp31_ = part;
			_tmp32_ = _tmp31_->pkname;
			_tmp33_ = parent->kname;
			if (g_strcmp0 (_tmp32_, _tmp33_) == 0) {
				GtkTreeIter iter1 = {0};
				GtkTreeIter _tmp34_;
				GtkTreeIter _tmp35_ = {0};
				GtkTreeIter _tmp36_;
				Device* _tmp37_;
				GtkTreeIter _tmp38_;
				Device* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				const gchar* _tmp42_ = NULL;
				Device* _tmp43_;
				const gchar* _tmp44_;
				GtkTreeIter _tmp45_;
				const gchar* _tmp46_;
				gboolean _tmp48_ = FALSE;
				Main* _tmp49_;
				SnapshotRepo* _tmp50_;
				Device* _tmp51_;
				Device* _tmp60_;
				_tmp34_ = *iter0;
				gtk_tree_store_append (*model, &_tmp35_, &_tmp34_);
				iter1 = _tmp35_;
				_tmp36_ = iter1;
				_tmp37_ = part;
				gtk_tree_store_set (*model, &_tmp36_, 0, _tmp37_, -1, -1);
				_tmp38_ = iter1;
				_tmp39_ = part;
				_tmp40_ = device_tooltip_text (_tmp39_);
				_tmp41_ = _tmp40_;
				gtk_tree_store_set (*model, &_tmp38_, 1, _tmp41_, -1, -1);
				_g_free0 (_tmp41_);
				_tmp43_ = part;
				_tmp44_ = _tmp43_->fstype;
				if (g_strcmp0 (_tmp44_, "luks") == 0) {
					_tmp42_ = "locked";
				} else {
					_tmp42_ = ICON_MANAGER_ICON_HARDDRIVE;
				}
				_tmp45_ = iter1;
				gtk_tree_store_set (*model, &_tmp45_, 2, _tmp42_, -1, -1);
				_tmp46_ = parent->fstype;
				if (g_strcmp0 (_tmp46_, "luks") == 0) {
					GtkTreeIter _tmp47_;
					_tmp47_ = *iter0;
					gtk_tree_store_set (*model, &_tmp47_, 2, "unlocked", -1, -1);
				}
				_tmp49_ = App;
				_tmp50_ = _tmp49_->repo;
				_tmp51_ = _tmp50_->device;
				if (_tmp51_ != NULL) {
					Device* _tmp52_;
					const gchar* _tmp53_;
					Main* _tmp54_;
					SnapshotRepo* _tmp55_;
					Device* _tmp56_;
					const gchar* _tmp57_;
					_tmp52_ = part;
					_tmp53_ = _tmp52_->uuid;
					_tmp54_ = App;
					_tmp55_ = _tmp54_->repo;
					_tmp56_ = _tmp55_->device;
					_tmp57_ = _tmp56_->uuid;
					_tmp48_ = g_strcmp0 (_tmp53_, _tmp57_) == 0;
				} else {
					_tmp48_ = FALSE;
				}
				if (_tmp48_) {
					GtkTreeIter _tmp58_;
					_tmp58_ = iter1;
					gtk_tree_store_set (*model, &_tmp58_, 3, TRUE, -1, -1);
				} else {
					GtkTreeIter _tmp59_;
					_tmp59_ = iter1;
					gtk_tree_store_set (*model, &_tmp59_, 3, FALSE, -1, -1);
				}
				_tmp60_ = part;
				backup_device_box_tv_append_child_volumes (self, model, &iter1, _tmp60_);
			} else {
				gboolean _tmp61_ = FALSE;
				gboolean _tmp62_ = FALSE;
				gboolean _tmp63_ = FALSE;
				Device* _tmp64_;
				const gchar* _tmp65_;
				const gchar* _tmp66_;
				_tmp64_ = part;
				_tmp65_ = _tmp64_->kname;
				_tmp66_ = parent->kname;
				if (g_strcmp0 (_tmp65_, _tmp66_) == 0) {
					Device* _tmp67_;
					const gchar* _tmp68_;
					_tmp67_ = part;
					_tmp68_ = _tmp67_->type;
					_tmp63_ = g_strcmp0 (_tmp68_, "disk") == 0;
				} else {
					_tmp63_ = FALSE;
				}
				if (_tmp63_) {
					Device* _tmp69_;
					_tmp69_ = part;
					_tmp62_ = device_has_linux_filesystem (_tmp69_);
				} else {
					_tmp62_ = FALSE;
				}
				if (_tmp62_) {
					Device* _tmp70_;
					_tmp70_ = part;
					_tmp61_ = !device_has_children (_tmp70_);
				} else {
					_tmp61_ = FALSE;
				}
				if (_tmp61_) {
					Device* part2 = NULL;
					Device* _tmp71_;
					Device* _tmp72_;
					Device* _tmp73_;
					Device* _tmp74_;
					gchar* _tmp75_;
					Device* _tmp76_;
					Device* _tmp77_;
					const gchar* _tmp78_;
					gchar* _tmp79_;
					Device* _tmp80_;
					Device* _tmp81_;
					Device* _tmp82_;
					GtkTreeIter iter1 = {0};
					GtkTreeIter _tmp83_;
					GtkTreeIter _tmp84_ = {0};
					GtkTreeIter _tmp85_;
					Device* _tmp86_;
					GtkTreeIter _tmp87_;
					Device* _tmp88_;
					gchar* _tmp89_;
					gchar* _tmp90_;
					const gchar* _tmp91_ = NULL;
					Device* _tmp92_;
					const gchar* _tmp93_;
					GtkTreeIter _tmp94_;
					gboolean _tmp95_ = FALSE;
					Main* _tmp96_;
					SnapshotRepo* _tmp97_;
					Device* _tmp98_;
					_tmp71_ = device_new ();
					part2 = _tmp71_;
					_tmp72_ = part2;
					_tmp73_ = part;
					device_copy_fields_from (_tmp72_, _tmp73_);
					_tmp74_ = part2;
					_tmp75_ = g_strdup ("part");
					_g_free0 (_tmp74_->type);
					_tmp74_->type = _tmp75_;
					_tmp76_ = part2;
					_tmp77_ = part;
					_tmp78_ = _tmp77_->device;
					_tmp79_ = string_replace (_tmp78_, "/dev/", "");
					_g_free0 (_tmp76_->pkname);
					_tmp76_->pkname = _tmp79_;
					_tmp80_ = part2;
					_tmp81_ = part;
					_tmp82_ = _g_object_ref0 (_tmp81_);
					_g_object_unref0 (_tmp80_->parent);
					_tmp80_->parent = _tmp82_;
					_tmp83_ = *iter0;
					gtk_tree_store_append (*model, &_tmp84_, &_tmp83_);
					iter1 = _tmp84_;
					_tmp85_ = iter1;
					_tmp86_ = part2;
					gtk_tree_store_set (*model, &_tmp85_, 0, _tmp86_, -1, -1);
					_tmp87_ = iter1;
					_tmp88_ = part2;
					_tmp89_ = device_tooltip_text (_tmp88_);
					_tmp90_ = _tmp89_;
					gtk_tree_store_set (*model, &_tmp87_, 1, _tmp90_, -1, -1);
					_g_free0 (_tmp90_);
					_tmp92_ = part2;
					_tmp93_ = _tmp92_->fstype;
					if (g_strcmp0 (_tmp93_, "luks") == 0) {
						_tmp91_ = "locked";
					} else {
						_tmp91_ = ICON_MANAGER_ICON_HARDDRIVE;
					}
					_tmp94_ = iter1;
					gtk_tree_store_set (*model, &_tmp94_, 2, _tmp91_, -1, -1);
					_tmp96_ = App;
					_tmp97_ = _tmp96_->repo;
					_tmp98_ = _tmp97_->device;
					if (_tmp98_ != NULL) {
						Device* _tmp99_;
						const gchar* _tmp100_;
						Main* _tmp101_;
						SnapshotRepo* _tmp102_;
						Device* _tmp103_;
						const gchar* _tmp104_;
						_tmp99_ = part2;
						_tmp100_ = _tmp99_->uuid;
						_tmp101_ = App;
						_tmp102_ = _tmp101_->repo;
						_tmp103_ = _tmp102_->device;
						_tmp104_ = _tmp103_->uuid;
						_tmp95_ = g_strcmp0 (_tmp100_, _tmp104_) == 0;
					} else {
						_tmp95_ = FALSE;
					}
					if (_tmp95_) {
						GtkTreeIter _tmp105_;
						_tmp105_ = iter1;
						gtk_tree_store_set (*model, &_tmp105_, 3, TRUE, -1, -1);
					} else {
						GtkTreeIter _tmp106_;
						_tmp106_ = iter1;
						gtk_tree_store_set (*model, &_tmp106_, 3, FALSE, -1, -1);
					}
					_g_object_unref0 (part2);
				}
			}
			_g_object_unref0 (part);
		}
	}
}

static void
backup_device_box_class_init (BackupDeviceBoxClass * klass,
                              gpointer klass_data)
{
	backup_device_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BackupDeviceBox_private_offset);
	G_OBJECT_CLASS (klass)->finalize = backup_device_box_finalize;
}

static void
backup_device_box_instance_init (BackupDeviceBox * self,
                                 gpointer klass)
{
	self->priv = backup_device_box_get_instance_private (self);
}

static void
backup_device_box_finalize (GObject * obj)
{
	BackupDeviceBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BACKUP_DEVICE_BOX, BackupDeviceBox);
	_g_object_unref0 (self->priv->tv_devices);
	_g_object_unref0 (self->priv->infobar_location);
	_g_object_unref0 (self->priv->lbl_infobar_location);
	_g_object_unref0 (self->priv->lbl_common);
	_g_object_unref0 (self->priv->parent_window);
	G_OBJECT_CLASS (backup_device_box_parent_class)->finalize (obj);
}

static GType
backup_device_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BackupDeviceBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) backup_device_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackupDeviceBox), 0, (GInstanceInitFunc) backup_device_box_instance_init, NULL };
	GType backup_device_box_type_id;
	backup_device_box_type_id = g_type_register_static (gtk_box_get_type (), "BackupDeviceBox", &g_define_type_info, 0);
	BackupDeviceBox_private_offset = g_type_add_instance_private (backup_device_box_type_id, sizeof (BackupDeviceBoxPrivate));
	return backup_device_box_type_id;
}

GType
backup_device_box_get_type (void)
{
	static volatile gsize backup_device_box_type_id__once = 0;
	if (g_once_init_enter (&backup_device_box_type_id__once)) {
		GType backup_device_box_type_id;
		backup_device_box_type_id = backup_device_box_get_type_once ();
		g_once_init_leave (&backup_device_box_type_id__once, backup_device_box_type_id);
	}
	return backup_device_box_type_id__once;
}

