/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovySmartEnterProcessor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GrWhileConditionFixer
extends SmartEnterProcessorWithFixers.Fixer<GroovySmartEnterProcessor> {
    public void apply(@NotNull Editor editor, @NotNull GroovySmartEnterProcessor processor, @NotNull PsiElement psiElement) {
        if (editor == null) {
            GrWhileConditionFixer.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            GrWhileConditionFixer.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            GrWhileConditionFixer.$$$reportNull$$$0(2);
        }
        if (psiElement instanceof GrWhileStatement) {
            GrWhileStatement whileStatement = (GrWhileStatement)psiElement;
            Document doc = editor.getDocument();
            PsiElement rParenth = whileStatement.getRParenth();
            PsiElement lParenth = whileStatement.getLParenth();
            GrExpression condition = whileStatement.getCondition();
            if (condition == null) {
                if (lParenth == null || rParenth == null) {
                    int stopOffset = doc.getLineEndOffset(doc.getLineNumber(whileStatement.getTextRange().getStartOffset()));
                    GrStatement block = whileStatement.getBody();
                    if (block != null) {
                        stopOffset = Math.min(stopOffset, block.getTextRange().getStartOffset());
                    }
                    stopOffset = Math.min(stopOffset, whileStatement.getTextRange().getEndOffset());
                    doc.replaceString(whileStatement.getTextRange().getStartOffset(), stopOffset, (CharSequence)"while ()");
                    processor.registerUnresolvedError(whileStatement.getTextRange().getStartOffset() + "while (".length());
                } else {
                    processor.registerUnresolvedError(lParenth.getTextRange().getEndOffset());
                }
            } else if (rParenth == null) {
                doc.insertString(condition.getTextRange().getEndOffset(), (CharSequence)")");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/lang/completion/smartEnter/fixers/GrWhileConditionFixer";
        objectArray[2] = "apply";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

