/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.JsLibrary;
import org.jetbrains.kotlin.utils.JsLibraryUtils;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010!\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0011\u001a\u00020\u0005H\u0007J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/utils/KotlinJavascriptMetadataUtils;", "", "<init>", "()V", "JS_EXT", "", "META_JS_SUFFIX", "JS_MAP_EXT", "KOTLIN_JAVASCRIPT_METHOD_NAME", "KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN", "Ljava/util/regex/Pattern;", "METADATA_PATTERN", "loadMetadata", "", "Lorg/jetbrains/kotlin/utils/KotlinJavascriptMetadata;", "file", "Ljava/io/File;", "path", "parseMetadata", "", "text", "", "metadataList", "", "js.config"})
@SourceDebugExtension(value={"SMAP\nKotlinJavascriptMetadataUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinJavascriptMetadataUtils.kt\norg/jetbrains/kotlin/utils/KotlinJavascriptMetadataUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1#2:100\n*E\n"})
public final class KotlinJavascriptMetadataUtils {
    @NotNull
    public static final KotlinJavascriptMetadataUtils INSTANCE = new KotlinJavascriptMetadataUtils();
    @NotNull
    public static final String JS_EXT = ".js";
    @NotNull
    public static final String META_JS_SUFFIX = ".meta.js";
    @NotNull
    public static final String JS_MAP_EXT = ".js.map";
    @NotNull
    private static final String KOTLIN_JAVASCRIPT_METHOD_NAME = "kotlin_module_metadata";
    @NotNull
    private static final Pattern KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN;
    @NotNull
    private static final Pattern METADATA_PATTERN;

    private KotlinJavascriptMetadataUtils() {
    }

    @JvmStatic
    @NotNull
    public static final List<KotlinJavascriptMetadata> loadMetadata(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean bl = file.exists();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Library " + file + " not found";
            throw new AssertionError((Object)string);
        }
        ArrayList metadataList = new ArrayList();
        JsLibraryUtils.traverseJsLibrary(file, (Function1<? super JsLibrary, Unit>)((Function1)arg_0 -> KotlinJavascriptMetadataUtils.loadMetadata$lambda$1(metadataList, arg_0)));
        return metadataList;
    }

    @JvmStatic
    @NotNull
    public static final List<KotlinJavascriptMetadata> loadMetadata(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return KotlinJavascriptMetadataUtils.loadMetadata(new File(path));
    }

    @JvmStatic
    public static final void parseMetadata(@NotNull CharSequence text, @NotNull List<KotlinJavascriptMetadata> metadataList) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(metadataList, (String)"metadataList");
        if (!KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN.matcher(text).find()) {
            return;
        }
        Matcher matcher = METADATA_PATTERN.matcher(text);
        while (matcher.find()) {
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            JsMetadataVersion abiVersion = JsMetadataVersion.Companion.fromInteger(Integer.parseInt(string));
            String moduleName = matcher.group(3);
            String data = matcher.group(5);
            Intrinsics.checkNotNull((Object)moduleName);
            byte[] byArray = Base64.getDecoder().decode(data);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
            metadataList.add(new KotlinJavascriptMetadata(abiVersion, moduleName, byArray));
        }
    }

    private static final Unit loadMetadata$lambda$1(ArrayList $metadataList, JsLibrary library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        KotlinJavascriptMetadataUtils.parseMetadata(library.getContent(), $metadataList);
        return Unit.INSTANCE;
    }

    static {
        String string = "\\.kotlin_module_metadata\\(";
        int n = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN = pattern;
        string = "(?m)\\w+\\." + KOTLIN_JAVASCRIPT_METHOD_NAME + "\\((\\d+),\\s*(['\"])([^'\"]*)\\2,\\s*(['\"])([^'\"]*)\\4\\)";
        n = 0;
        Pattern pattern2 = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        METADATA_PATTERN = pattern2;
    }
}

