/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.reader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.AutoCloseableHelper;
import net.sf.mpxj.reader.AbstractProjectReader;

public abstract class AbstractProjectStreamReader
extends AbstractProjectReader {
    @Override
    public ProjectFile read(String fileName) throws MPXJException {
        return this.read(new File(fileName));
    }

    @Override
    public List<ProjectFile> readAll(String fileName) throws MPXJException {
        return this.readAll(new File(fileName));
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        ProjectFile projectFile;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            ProjectFile projectFile2 = this.read(fis);
            fis.close();
            projectFile = projectFile2;
        }
        catch (IOException ex) {
            try {
                throw new MPXJException("Error reading file", ex);
            }
            catch (Throwable throwable) {
                AutoCloseableHelper.closeQuietly(fis);
                throw throwable;
            }
        }
        AutoCloseableHelper.closeQuietly(fis);
        return projectFile;
    }

    @Override
    public List<ProjectFile> readAll(File file) throws MPXJException {
        List<ProjectFile> list;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            List<ProjectFile> projectFiles = this.readAll(fis);
            fis.close();
            list = projectFiles;
        }
        catch (IOException ex) {
            try {
                throw new MPXJException("Error reading file", ex);
            }
            catch (Throwable throwable) {
                AutoCloseableHelper.closeQuietly(fis);
                throw throwable;
            }
        }
        AutoCloseableHelper.closeQuietly(fis);
        return list;
    }
}

