/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.core.importer.UrlSource;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;

interface LocationResolver {
    public UrlSource resolveClassPath();

    @Internal
    public static class FromClasspathAndUrlClassLoaders
    implements LocationResolver {
        @Override
        public UrlSource resolveClassPath() {
            ImmutableList.Builder result = ImmutableList.builder();
            for (URLClassLoader loader : FromClasspathAndUrlClassLoaders.findAllUrlClassLoadersInContext()) {
                result.addAll(ImmutableList.copyOf(loader.getURLs()));
            }
            result.addAll((Iterable)UrlSource.From.classPathSystemProperties());
            return UrlSource.From.iterable(result.build());
        }

        private static Set<URLClassLoader> findAllUrlClassLoadersInContext() {
            return ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(FromClasspathAndUrlClassLoaders.findUrlClassLoadersInHierarchy(Thread.currentThread().getContextClassLoader()))).addAll(FromClasspathAndUrlClassLoaders.findUrlClassLoadersInHierarchy(UrlSource.class.getClassLoader()))).build();
        }

        private static Set<URLClassLoader> findUrlClassLoadersInHierarchy(ClassLoader loader) {
            HashSet<URLClassLoader> result = new HashSet<URLClassLoader>();
            while (loader != null) {
                if (loader instanceof URLClassLoader) {
                    result.add((URLClassLoader)loader);
                }
                loader = loader.getParent();
            }
            return result;
        }
    }
}

