/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter.condition;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.AllChildrenConditionDecorator;
import org.freeplane.features.filter.condition.AllDescendantsConditionDecorator;
import org.freeplane.features.filter.condition.AnyAncestorConditionDecorator;
import org.freeplane.features.filter.condition.AnyChildConditionDecorator;
import org.freeplane.features.filter.condition.AnyDescendantConditionDecorator;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.filter.condition.ConditionNotSatisfiedDecorator;
import org.freeplane.features.filter.condition.NoAncestorConditionDecorator;
import org.freeplane.features.filter.condition.NoChildConditionDecorator;
import org.freeplane.features.filter.condition.NoDescendantConditionDecorator;
import org.freeplane.features.filter.condition.ParentConditionDecorator;
import org.freeplane.n3.nanoxml.XMLElement;

public class DecoratedConditionFactory {
    private static final String FILTER_FOR_SELF = "filter_for_self";
    private final Map<TranslatedObject, Function<ASelectableCondition, ASelectableCondition>> byDescription = new LinkedHashMap<TranslatedObject, Function<ASelectableCondition, ASelectableCondition>>();
    private final Map<String, BiFunction<ConditionFactory, XMLElement, ASelectableCondition>> byName;
    Vector<TranslatedObject> keys;

    public DecoratedConditionFactory() {
        this.byDescription.put(TextUtils.createTranslatedString(FILTER_FOR_SELF), x -> x);
        this.byDescription.put(TextUtils.createTranslatedString("filter_for_parent"), ParentConditionDecorator::new);
        this.byDescription.put(TextUtils.createTranslatedString("filter_for_any_ancestor"), AnyAncestorConditionDecorator::new);
        this.byDescription.put(TextUtils.createTranslatedString("filter_for_no_ancestor"), NoAncestorConditionDecorator::new);
        this.byDescription.put(TextUtils.createTranslatedString("filter_for_any_child"), AnyChildConditionDecorator::new);
        this.byDescription.put(TextUtils.createTranslatedString("filter_for_all_children"), AllChildrenConditionDecorator::new);
        this.byDescription.put(TextUtils.createTranslatedString("filter_for_no_child"), NoChildConditionDecorator::new);
        this.byDescription.put(TextUtils.createTranslatedString("filter_for_any_descendant"), AnyDescendantConditionDecorator::new);
        this.byDescription.put(TextUtils.createTranslatedString("filter_for_all_descendants"), AllDescendantsConditionDecorator::new);
        this.byDescription.put(TextUtils.createTranslatedString("filter_for_no_descendant"), NoDescendantConditionDecorator::new);
        this.keys = new Vector(this.byDescription.size());
        this.byDescription.keySet().forEach(this.keys::add);
        this.byName = new HashMap<String, BiFunction<ConditionFactory, XMLElement, ASelectableCondition>>();
        this.byName.put("negate_condition".toLowerCase(), ConditionNotSatisfiedDecorator::load);
        this.byName.put("parent_condition".toLowerCase(), ParentConditionDecorator::load);
        this.byName.put("any_ancestor_condition".toLowerCase(), AnyAncestorConditionDecorator::load);
        this.byName.put("no_ancestor_condition".toLowerCase(), NoAncestorConditionDecorator::load);
        this.byName.put("any_child_condition".toLowerCase(), AnyChildConditionDecorator::load);
        this.byName.put("all_children_condition".toLowerCase(), AllChildrenConditionDecorator::load);
        this.byName.put("no_child_condition".toLowerCase(), NoChildConditionDecorator::load);
        this.byName.put("any_descendant_condition".toLowerCase(), AnyDescendantConditionDecorator::load);
        this.byName.put("all_descendants_condition".toLowerCase(), AllDescendantsConditionDecorator::load);
        this.byName.put("no_descendant_condition".toLowerCase(), NoDescendantConditionDecorator::load);
    }

    public ASelectableCondition createRelativeCondition(TranslatedObject key, ASelectableCondition originalCondition) {
        return this.byDescription.get(key).apply(originalCondition);
    }

    public ASelectableCondition createRelativeCondition(ConditionFactory factory, XMLElement element) {
        BiFunction<ConditionFactory, XMLElement, ASelectableCondition> decoratorFactory = this.byName.get(element.getName().toLowerCase());
        return decoratorFactory == null ? null : decoratorFactory.apply(factory, element);
    }

    public Vector<TranslatedObject> getKeys() {
        return this.keys;
    }
}

