/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSMarginRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.PageRule;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class MarginRule
extends BaseCSSDeclarationRule
implements CSSMarginRule {
    private static final long serialVersionUID = 1L;
    private String ruleName = null;

    protected MarginRule(AbstractCSSStyleSheet parentSheet, int origin, String ruleName) {
        super(parentSheet, (short)9, origin);
        this.ruleName = ruleName;
    }

    @Override
    public PageRule getParentRule() {
        return (PageRule)super.getParentRule();
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(32 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder buf = new StringBuilder(96);
        buf.append('@').append(this.ruleName).append('{');
        buf.append(this.getStyle().getMinifiedCssText()).append('}');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        context.startRule(wri, this.getPrecedingComments());
        wri.write('@');
        wri.write((CharSequence)this.ruleName);
        context.updateContext(this);
        context.writeLeftCurlyBracket(wri);
        context.startStyleDeclaration(wri);
        this.getStyle().writeCssText(wri, context);
        context.endCurrentContext(this);
        context.endStyleDeclaration(wri);
        context.writeRightCurlyBracket(wri);
        context.endRule(wri, this.getTrailingComments());
    }

    @Override
    public String getName() {
        return this.ruleName;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ruleName == null ? 0 : this.ruleName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MarginRule other = (MarginRule)obj;
        return !(this.ruleName == null ? other.ruleName != null : !this.ruleName.equals(other.ruleName));
    }

    @Override
    public MarginRule clone(AbstractCSSStyleSheet parentSheet) {
        MarginRule rule = new MarginRule(parentSheet, this.getOrigin(), this.ruleName);
        rule.setParentRule(this.getParentRule());
        String oldHrefContext = this.getParentStyleSheet().getHref();
        rule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), oldHrefContext);
        return rule;
    }
}

