---
stage: Security Risk Management
group: Security Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: GitLabセキュリティダッシュボードとセキュリティセンター
description: セキュリティダッシュボード、脆弱性の傾向、プロジェクト評価、メトリクス
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

## セキュリティダッシュボード {#security-dashboards}

セキュリティダッシュボードは、アプリケーションのセキュリティ対策状況を評価するために使用されます。GitLabは、プロジェクトで実行される[セキュリティスキャナー](../detect/_index.md)によって検出された脆弱性に関するメトリクス、評価、チャートのコレクションを提供します。セキュリティダッシュボードは、次のようなデータを提供します: 

- グループ内のすべてのプロジェクトについて、30日、60日、または90日の期間にわたる脆弱性のトレンド
- 脆弱性の重大度に基づいた各プロジェクトのレターグレード評価
- 過去365日以内に検出された脆弱性の総数（重大度を含む）

セキュリティダッシュボードから提供されたデータは、セキュリティ対策を改善するためにどのような決定を下せるかについてのインサイトを提供するのに役立ちます。たとえば、365日のトレンドビューを使用すると、かなりの数の脆弱性がいつ導入されたかを確認できます。次に、それらの特定の日に行われたコードの変更を調べて根本原因分析を実行し、将来の脆弱性の導入を防ぐためのより良いポリシーを作成できます。

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>概要については、[Security Dashboard - Advanced Security Testing](https://www.youtube.com/watch?v=Uo-pDns1OpQ)をご覧ください。

## バリューストリームダッシュボードの脆弱性のメトリクス {#vulnerability-metrics-in-the-value-streams-dashboard}

{{< history >}}

- GitLab 16.0で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/383697)されました。

{{< /history >}}

脆弱性のメトリクスは、組織のソフトウエアデリバリーワークフローのコンテキストでセキュリティエクスポージャーを理解するのに役立つ[Value Streams Dashboard](../../analytics/value_streams_dashboard.md)比較パネルでも表示できます。

## 前提要件 {#prerequisites}

セキュリティダッシュボードを表示するには、以下が必要です: 

- グループまたはプロジェクトのデベロッパーロールを持っている必要があります。
- プロジェクトで構成されている[セキュリティスキャナー](../detect/_index.md)が少なくとも1つ必要です。
- プロジェクトの[デフォルト](../../project/repository/branches/default.md)ブランチで実行されるセキュリティスキャンが成功していること。
- プロジェクトで少なくとも1つの検出された脆弱性。

{{< alert type="note" >}}

セキュリティダッシュボードには、[デフォルト](../../project/repository/branches/default.md)ブランチで最新の完了したパイプラインからのスキャンの結果が表示されます。ダッシュボードは、デフォルトブランチで実行される完了したパイプラインの結果で更新されます。他のマージされていないブランチからのパイプラインで検出された脆弱性は含まれません。

{{< /alert >}}

## セキュリティダッシュボードの表示 {#viewing-the-security-dashboard}

セキュリティダッシュボードは、プロジェクト、グループ、およびセキュリティセンターのレベルで表示できます。各ダッシュボードは、セキュリティセキュリティ対策状況の独自の視点を提供します。

### プロジェクトセキュリティダッシュボード {#project-security-dashboard}

プロジェクトセキュリティダッシュボードには、特定のプロジェクトについて、時間の経過とともに検出された脆弱性の総数が、最大365日分の履歴データとともに表示されます。ダッシュボードは、デフォルトブランチ内のオープンな脆弱性の履歴ビューです。オープンな脆弱性は、`Needs triage`または`Confirmed`ステータスのもののみです（`Dismissed`または`Resolved`脆弱性は除外されます）。

プロジェクトのセキュリティダッシュボードを表示するには、次の手順に従います: 

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **セキュリティ** > **セキュリティダッシュボード**を選択します。
1. 必要なものを絞り込んで検索します。
   - 重大度でチャートを絞り込むには、凡例名を選択します。
   - 特定の時間枠を表示するには、時間範囲ハンドル（{{< icon name="scroll-handle" >}}）を使用します。
   - チャートの特定の領域を表示するには、左端のアイコン（{{< icon name="marquee-selection" >}}）を選択し、チャート全体をドラッグします。
   - 元の範囲にリセットするには、**Remove Selection**（選択を削除）（{{< icon name="redo" >}}）を選択します。

![プロジェクトセキュリティダッシュボード](img/project_security_dashboard_v16_6.png)

#### 脆弱性チャートのダウンロード {#downloading-the-vulnerability-chart}

ドキュメントやプレゼンテーションなどで使用するために、プロジェクトセキュリティダッシュボードから脆弱性チャートの画像をダウンロードできます。脆弱性チャートの画像をダウンロードするには: 

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **セキュリティ** > **セキュリティダッシュボード**を選択します。
1. **Save chart as an image**（グラフを画像として保存）（{{< icon name="download" >}}）を選択します。

次に、SVG形式で画像をダウンロードするように求められます。

### グループセキュリティダッシュボード {#group-security-dashboard}

グループセキュリティダッシュボードは、グループとそのサブグループ内のすべてのプロジェクトのデフォルトブランチにある脆弱性の概要を提供します。グループセキュリティダッシュボードは、以下を提供します: 

- 30日、60日、または90日の期間にわたる脆弱性のトレンド
- 最高重大度のオープンな脆弱性に応じた、グループ内の各プロジェクトのレターグレードレターグレードは、次の基準を使用して割り当てられます: 

| グレード | 説明 |
| ----- | ----------- |
| **金** | 1つ以上の`critical`脆弱性 |
| **D** | 1つ以上の`high`または`unknown`脆弱性 |
| **C** | 1つ以上の`medium`脆弱性 |
| **B** | 1つ以上の`low`脆弱性 |
| **A** | 脆弱性がゼロ |

グループセキュリティダッシュボードを表示するには: 

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **セキュリティ > セキュリティダッシュボード**を選択します。
1. **時間経過による脆弱性の推移**チャートにカーソルを合わせると、脆弱性に関する詳細が表示されます。
   - 脆弱性のトレンドは、30日、60日、または90日の期間で表示できます（デフォルトは90日です）。
   - 90日を超える集計データを表示するには、[VulnerabilitiesCountByDay GraphQL API](../../../api/graphql/reference/_index.md#vulnerabilitiescountbyday)を使用します。GitLabは365日間データを保持します。

1. **プロジェクトのセキュリティ状態**セクションの下にある矢印を選択して、特定のレターグレード評価に該当するプロジェクトを確認します: 
   - 特定の重大度の脆弱性がプロジェクト内でいくつ見つかったかを確認できます
   - プロジェクト名を選択して、プロジェクトセキュリティダッシュボードに直接アクセスできます

![グループセキュリティダッシュボード](img/group_security_dashboard_v16_6.png)

## セキュリティセンター {#security-center}

セキュリティセンターは、所属するすべてのプロジェクトの脆弱性を表示できる、構成可能な個人用スペースです。セキュリティセンターには最大1,000個のプロジェクトを追加できますが、**プロジェクト**リストは**セキュリティセンター**設定ページに最大100個のプロジェクトを表示します。検索フィルターを使用して、最初の100個のプロジェクトに表示されないプロジェクトを検索できます。

セキュリティセンターには以下が含まれます: 

- グループセキュリティダッシュボード
- [脆弱性レポート](../vulnerability_report/_index.md)
- 表示するプロジェクトを構成するための設定領域

### セキュリティセンターの表示 {#viewing-the-security-center}

セキュリティセンターを表示するには: 

1. 左側のサイドバーで、**検索または移動先**を選択します。
1. **あなたの作業**を選択します。
1. **セキュリティ** > **セキュリティダッシュボード**を選択します。

セキュリティセンターはデフォルトで空白です。少なくとも1つのセキュリティスキャナーで構成されているプロジェクトを追加する必要があります。

### セキュリティセンターへのプロジェクトの追加 {#adding-projects-to-the-security-center}

プロジェクトを追加するには: 

1. 左側のサイドバーで、**検索または移動先**を選択します。
1. **あなたの作業**を選択します。
1. **セキュリティ**を展開する。
1. **設定**を選択します。
1. **プロジェクトを検索**テキストボックスを使用して、プロジェクトを検索して選択します。
1. **プロジェクトを追加**を選択します。

プロジェクトを追加すると、セキュリティダッシュボードと脆弱性レポートに、それらのプロジェクトのデフォルトブランチで見つかった脆弱性が表示されます。

### セキュリティセンターからのプロジェクトの削除 {#removing-projects-from-the-security-center}

セキュリティセンターには最大100個のプロジェクトが表示されるため、検索機能を使用してプロジェクトを削除する必要がある場合があります。プロジェクトを削除するには: 

1. 左側のサイドバーで、**検索または移動先**を選択します。
1. **あなたの作業**を選択します。
1. **セキュリティ**を展開する。
1. **設定**を選択します。
1. **プロジェクトを検索**テキストボックスを使用して、プロジェクトを検索します。
1. **ダッシュボードのプロジェクトを削除**（{{< icon name="remove" >}}）を選択します。

プロジェクトを削除すると、セキュリティダッシュボードと脆弱性レポートに、それらのプロジェクトのデフォルトブランチで見つかった脆弱性が表示されなくなります。

## エクスポート {#exporting}

{{< history >}}

- [Introduced](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196607) in GitLab 18.2.デフォルトでは有効になっています。
- 機能フラグ`vulnerabilities_pdf_export`は削除されました。

{{< /history >}}

セキュリティダッシュボードにリストされている脆弱性の詳細を含むPDFファイルをエクスポートできます。

エクスポートのチャートには以下が含まれます: 

- 時間経過による脆弱性のトレンド
- プロジェクトのセキュリティ状態
- プロジェクトのセキュリティダッシュボード

### 詳細をエクスポート {#export-details}

セキュリティダッシュボードにリストされているすべての脆弱性の詳細をエクスポートするには、**エクスポート**を選択します。

エクスポートされた詳細が利用可能になると、GitLabからメールが送信されます。エクスポートされた詳細をダウンロードするには、メール内のリンクを選択します。

## 関連トピック {#related-topics}

- [脆弱性レポート](../vulnerability_report/_index.md)
- [脆弱性ページ](../vulnerabilities/_index.md)
