---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Asana client secret'
---

## Description

The response body contains content that matches the pattern of an Asana Client Secret was detected. Client Secrets are used for authentication and authorization using OAuth. A malicious actor who got access to this secret could gain access to user accounts and execute functionality on their behalf.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet). To revoke the detected client secret: - Sign in to your developer account and access <https://app.asana.com/0/my-apps> - Under the "My apps" page find the application that uses the secret - Select your app in the developer console - Go to the "OAuth" tab in the sidebar - Select "Reset" next to your client secret For more information please [see their documentation on configuring OAuth](https://developers.asana.com/docs/oauth)

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.10 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
