/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentPassedTwice;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCall;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.MixingNamedAndPositionArguments;
import org.jetbrains.kotlin.resolve.calls.model.NameForAmbiguousParameter;
import org.jetbrains.kotlin.resolve.calls.model.NameNotFound;
import org.jetbrains.kotlin.resolve.calls.model.NamedArgumentNotAllowed;
import org.jetbrains.kotlin.resolve.calls.model.NamedArgumentReference;
import org.jetbrains.kotlin.resolve.calls.model.NoValueForParameter;
import org.jetbrains.kotlin.resolve.calls.model.NonVarargSpread;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.TooManyArguments;
import org.jetbrains.kotlin.resolve.calls.model.VarargArgumentOutsideParentheses;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\f\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper;", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "allowMixedNamedAndPositionArguments", "", "EmptyArgumentMapping", "Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$ArgumentMapping;", "getEmptyArgumentMapping", "()Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$ArgumentMapping;", "mapArguments", "call", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCall;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "argumentsInParenthesis", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "externalArgument", "ArgumentMapping", "CallArgumentProcessor", "resolution"})
public final class ArgumentsToParametersMapper {
    private final boolean allowMixedNamedAndPositionArguments;
    @NotNull
    private final ArgumentMapping EmptyArgumentMapping;

    public ArgumentsToParametersMapper(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.allowMixedNamedAndPositionArguments = languageVersionSettings.supportsFeature(LanguageFeature.MixedNamedArgumentsInTheirOwnPosition);
        this.EmptyArgumentMapping = new ArgumentMapping(MapsKt.emptyMap(), CollectionsKt.emptyList());
    }

    @NotNull
    public final ArgumentMapping getEmptyArgumentMapping() {
        return this.EmptyArgumentMapping;
    }

    @NotNull
    public final ArgumentMapping mapArguments(@NotNull KotlinCall call, @NotNull CallableDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.mapArguments(call.getArgumentsInParenthesis(), call.getExternalArgument(), descriptor);
    }

    @NotNull
    public final ArgumentMapping mapArguments(@NotNull List<? extends KotlinCallArgument> argumentsInParenthesis, @Nullable KotlinCallArgument externalArgument, @NotNull CallableDescriptor descriptor) {
        Intrinsics.checkNotNullParameter(argumentsInParenthesis, (String)"argumentsInParenthesis");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (argumentsInParenthesis.isEmpty() && externalArgument == null && descriptor.getValueParameters().isEmpty()) {
            return this.EmptyArgumentMapping;
        }
        CallArgumentProcessor processor = new CallArgumentProcessor(descriptor, this.allowMixedNamedAndPositionArguments);
        processor.processArgumentsInParenthesis(argumentsInParenthesis);
        if (externalArgument != null) {
            processor.processExternalArgument(externalArgument);
        }
        processor.processDefaultsAndRunChecks();
        return new ArgumentMapping(AddToStdlibKt.compactIfPossible(processor.getResult()), processor.getDiagnostics());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J/\u0010\u0011\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$ArgumentMapping;", "", "parameterToCallArgumentMap", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallArgument;", "diagnostics", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "<init>", "(Ljava/util/Map;Ljava/util/List;)V", "getParameterToCallArgumentMap", "()Ljava/util/Map;", "getDiagnostics", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "resolution"})
    public static final class ArgumentMapping {
        @NotNull
        private final Map<ValueParameterDescriptor, ResolvedCallArgument> parameterToCallArgumentMap;
        @NotNull
        private final List<KotlinCallDiagnostic> diagnostics;

        public ArgumentMapping(@NotNull Map<ValueParameterDescriptor, ? extends ResolvedCallArgument> parameterToCallArgumentMap, @NotNull List<? extends KotlinCallDiagnostic> diagnostics) {
            Intrinsics.checkNotNullParameter(parameterToCallArgumentMap, (String)"parameterToCallArgumentMap");
            Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
            this.parameterToCallArgumentMap = parameterToCallArgumentMap;
            this.diagnostics = diagnostics;
        }

        @NotNull
        public final Map<ValueParameterDescriptor, ResolvedCallArgument> getParameterToCallArgumentMap() {
            return this.parameterToCallArgumentMap;
        }

        @NotNull
        public final List<KotlinCallDiagnostic> getDiagnostics() {
            return this.diagnostics;
        }

        @NotNull
        public final Map<ValueParameterDescriptor, ResolvedCallArgument> component1() {
            return this.parameterToCallArgumentMap;
        }

        @NotNull
        public final List<KotlinCallDiagnostic> component2() {
            return this.diagnostics;
        }

        @NotNull
        public final ArgumentMapping copy(@NotNull Map<ValueParameterDescriptor, ? extends ResolvedCallArgument> parameterToCallArgumentMap, @NotNull List<? extends KotlinCallDiagnostic> diagnostics) {
            Intrinsics.checkNotNullParameter(parameterToCallArgumentMap, (String)"parameterToCallArgumentMap");
            Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
            return new ArgumentMapping(parameterToCallArgumentMap, diagnostics);
        }

        public static /* synthetic */ ArgumentMapping copy$default(ArgumentMapping argumentMapping, Map map, List list, int n, Object object) {
            if ((n & 1) != 0) {
                map = argumentMapping.parameterToCallArgumentMap;
            }
            if ((n & 2) != 0) {
                list = argumentMapping.diagnostics;
            }
            return argumentMapping.copy(map, list);
        }

        @NotNull
        public String toString() {
            return "ArgumentMapping(parameterToCallArgumentMap=" + this.parameterToCallArgumentMap + ", diagnostics=" + this.diagnostics + ')';
        }

        public int hashCode() {
            int result = ((Object)this.parameterToCallArgumentMap).hashCode();
            result = result * 31 + ((Object)this.diagnostics).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArgumentMapping)) {
                return false;
            }
            ArgumentMapping argumentMapping = (ArgumentMapping)other;
            if (!Intrinsics.areEqual(this.parameterToCallArgumentMap, argumentMapping.parameterToCallArgumentMap)) {
                return false;
            }
            return Intrinsics.areEqual(this.diagnostics, argumentMapping.diagnostics);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0012\b\u0002\u0018\u00002\u00020\u0001:\u00014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001aH\u0002J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015J\u0012\u0010&\u001a\u0004\u0018\u00010\u000e2\u0006\u0010'\u001a\u00020\u001dH\u0002J\u0010\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020\u001fH\u0002J\b\u0010*\u001a\u00020#H\u0002J\u0010\u0010+\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u001fH\u0002J\u0018\u0010,\u001a\u00020#2\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001dH\u0002J\u000e\u0010-\u001a\u0004\u0018\u00010\u000e*\u00020\u000eH\u0002J\u001a\u0010.\u001a\u0004\u0018\u00010\u000e2\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001dH\u0002J\u0014\u0010/\u001a\u00020#2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0015J\u000e\u00101\u001a\u00020#2\u0006\u00102\u001a\u00020\u001fJ\u0006\u00103\u001a\u00020#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$CallArgumentProcessor;", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "languageSettingsAllowMixedNamedAndPositionArguments", "", "<init>", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Z)V", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getLanguageSettingsAllowMixedNamedAndPositionArguments", "()Z", "result", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallArgument;", "getResult", "()Ljava/util/Map;", "state", "Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$CallArgumentProcessor$State;", "parameters", "", "getParameters", "()Ljava/util/List;", "diagnostics", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "nameToParameter", "", "Lorg/jetbrains/kotlin/name/Name;", "varargArguments", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "currentPositionedParameterIndex", "", "addDiagnostic", "", "diagnostic", "getDiagnostics", "getParameterByName", "name", "addVarargArgument", "argument", "completeVarargPositionArguments", "processPositionArgument", "processNamedArgument", "getOverriddenParameterWithOtherName", "findParameterByName", "processArgumentsInParenthesis", "arguments", "processExternalArgument", "externalArgument", "processDefaultsAndRunChecks", "State", "resolution"})
    @SourceDebugExtension(value={"SMAP\nArgumentsToParametersMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArgumentsToParametersMapper.kt\norg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$CallArgumentProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,279:1\n1208#2,2:280\n1236#2,4:282\n295#2,2:287\n295#2,2:289\n1#3:286\n*S KotlinDebug\n*F\n+ 1 ArgumentsToParametersMapper.kt\norg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$CallArgumentProcessor\n*L\n96#1:280,2\n96#1:282,4\n172#1:287,2\n182#1:289,2\n*E\n"})
    private static final class CallArgumentProcessor {
        @NotNull
        private final CallableDescriptor descriptor;
        private final boolean languageSettingsAllowMixedNamedAndPositionArguments;
        @NotNull
        private final Map<ValueParameterDescriptor, ResolvedCallArgument> result;
        @NotNull
        private State state;
        @Nullable
        private List<KotlinCallDiagnostic> diagnostics;
        @Nullable
        private Map<Name, ? extends ValueParameterDescriptor> nameToParameter;
        @Nullable
        private List<KotlinCallArgument> varargArguments;
        private int currentPositionedParameterIndex;

        public CallArgumentProcessor(@NotNull CallableDescriptor descriptor, boolean languageSettingsAllowMixedNamedAndPositionArguments) {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            this.descriptor = descriptor;
            this.languageSettingsAllowMixedNamedAndPositionArguments = languageSettingsAllowMixedNamedAndPositionArguments;
            this.result = new LinkedHashMap();
            this.state = State.POSITION_ARGUMENTS;
        }

        @NotNull
        public final CallableDescriptor getDescriptor() {
            return this.descriptor;
        }

        public final boolean getLanguageSettingsAllowMixedNamedAndPositionArguments() {
            return this.languageSettingsAllowMixedNamedAndPositionArguments;
        }

        @NotNull
        public final Map<ValueParameterDescriptor, ResolvedCallArgument> getResult() {
            return this.result;
        }

        private final List<ValueParameterDescriptor> getParameters() {
            List<ValueParameterDescriptor> list = this.descriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getValueParameters(...)");
            return list;
        }

        private final void addDiagnostic(KotlinCallDiagnostic diagnostic) {
            if (this.diagnostics == null) {
                this.diagnostics = new ArrayList();
            }
            List<KotlinCallDiagnostic> list = this.diagnostics;
            Intrinsics.checkNotNull(list);
            list.add(diagnostic);
        }

        @NotNull
        public final List<KotlinCallDiagnostic> getDiagnostics() {
            List list = this.diagnostics;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        /*
         * WARNING - void declaration
         */
        private final ValueParameterDescriptor getParameterByName(Name name) {
            if (this.nameToParameter == null) {
                void $this$associateByTo$iv$iv;
                void $this$associateBy$iv;
                Iterable iterable = this.getParameters();
                CallArgumentProcessor callArgumentProcessor = this;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                void var5_6 = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl = false;
                    Name name2 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
                    map.put(name2, element$iv$iv);
                }
                callArgumentProcessor.nameToParameter = destination$iv$iv;
            }
            Map<Name, ? extends ValueParameterDescriptor> map = this.nameToParameter;
            Intrinsics.checkNotNull(map);
            return map.get(name);
        }

        private final void addVarargArgument(KotlinCallArgument argument) {
            if (this.varargArguments == null) {
                this.varargArguments = new ArrayList();
            }
            List<KotlinCallArgument> list = this.varargArguments;
            Intrinsics.checkNotNull(list);
            list.add(argument);
        }

        private final void completeVarargPositionArguments() {
            boolean bl;
            boolean bl2 = bl = this.state == State.VARARG_POSITION;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Incorrect state: " + (Object)((Object)this.state);
                throw new AssertionError((Object)string);
            }
            ValueParameterDescriptor parameter = this.getParameters().get(this.currentPositionedParameterIndex);
            ValueParameterDescriptor valueParameterDescriptor = parameter.getOriginal();
            List<KotlinCallArgument> list = this.varargArguments;
            Intrinsics.checkNotNull(list);
            this.result.put(valueParameterDescriptor, new ResolvedCallArgument.VarargArgument(list));
        }

        private final boolean processPositionArgument(KotlinCallArgument argument) {
            if (this.state == State.NAMED_ONLY_ARGUMENTS) {
                this.addDiagnostic(new MixingNamedAndPositionArguments(argument));
                return false;
            }
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)CollectionsKt.getOrNull(this.getParameters(), (int)this.currentPositionedParameterIndex);
            if (parameter == null) {
                this.addDiagnostic(new TooManyArguments(argument, this.descriptor));
                return false;
            }
            if (!ArgumentsUtilsKt.isVararg(parameter)) {
                int n = this.currentPositionedParameterIndex;
                this.currentPositionedParameterIndex = n + 1;
                this.result.put(parameter.getOriginal(), new ResolvedCallArgument.SimpleArgument(argument));
                return false;
            }
            this.addVarargArgument(argument);
            return true;
        }

        private final void processNamedArgument(KotlinCallArgument argument, Name name) {
            if (!this.descriptor.hasStableParameterNames()) {
                this.addDiagnostic(new NamedArgumentNotAllowed(argument, this.descriptor));
            }
            boolean stateAllowsMixedNamedAndPositionArguments = this.state != State.NAMED_ONLY_ARGUMENTS;
            this.state = State.NAMED_ONLY_ARGUMENTS;
            ValueParameterDescriptor valueParameterDescriptor = this.findParameterByName(argument, name);
            if (valueParameterDescriptor == null) {
                return;
            }
            ValueParameterDescriptor parameter = valueParameterDescriptor;
            this.addDiagnostic(new NamedArgumentReference(argument, parameter));
            ResolvedCallArgument resolvedCallArgument = this.result.get(parameter.getOriginal());
            if (resolvedCallArgument != null) {
                ResolvedCallArgument it = resolvedCallArgument;
                boolean bl = false;
                this.addDiagnostic(new ArgumentPassedTwice(argument, parameter, it));
                return;
            }
            this.result.put(parameter.getOriginal(), new ResolvedCallArgument.SimpleArgument(argument));
            if (stateAllowsMixedNamedAndPositionArguments && this.languageSettingsAllowMixedNamedAndPositionArguments) {
                ValueParameterDescriptor valueParameterDescriptor2 = (ValueParameterDescriptor)CollectionsKt.getOrNull(this.getParameters(), (int)this.currentPositionedParameterIndex);
                if (Intrinsics.areEqual((Object)(valueParameterDescriptor2 != null ? valueParameterDescriptor2.getOriginal() : null), (Object)parameter.getOriginal())) {
                    this.state = State.POSITION_ARGUMENTS;
                    int n = this.currentPositionedParameterIndex;
                    this.currentPositionedParameterIndex = n + 1;
                }
            }
        }

        private final ValueParameterDescriptor getOverriddenParameterWithOtherName(ValueParameterDescriptor $this$getOverriddenParameterWithOtherName) {
            Object v0;
            block1: {
                Iterable $this$firstOrNull$iv = $this$getOverriddenParameterWithOtherName.getOverriddenDescriptors();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl = false;
                    if (!(it.getContainingDeclaration().hasStableParameterNames() && !Intrinsics.areEqual((Object)it.getName(), (Object)$this$getOverriddenParameterWithOtherName.getName()))) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private final ValueParameterDescriptor findParameterByName(KotlinCallArgument argument, Name name) {
            ValueParameterDescriptor parameter = this.getParameterByName(name);
            if (this.descriptor instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)this.descriptor).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                if (parameter == null) {
                    for (ValueParameterDescriptor valueParameter : ((CallableMemberDescriptor)this.descriptor).getValueParameters()) {
                        ValueParameterDescriptor matchedParameter;
                        Object v0;
                        block7: {
                            Iterable $this$firstOrNull$iv = valueParameter.getOverriddenDescriptors();
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                                boolean bl = false;
                                if (!(it.getContainingDeclaration().hasStableParameterNames() && Intrinsics.areEqual((Object)it.getName(), (Object)name))) continue;
                                v0 = element$iv;
                                break block7;
                            }
                            v0 = null;
                        }
                        if ((matchedParameter = (ValueParameterDescriptor)v0) == null) continue;
                        Intrinsics.checkNotNull((Object)valueParameter);
                        this.addDiagnostic(new NamedArgumentReference(argument, valueParameter));
                        this.addDiagnostic(new NameForAmbiguousParameter(argument, valueParameter, matchedParameter));
                        return valueParameter;
                    }
                } else {
                    ValueParameterDescriptor valueParameterDescriptor = this.getOverriddenParameterWithOtherName(parameter);
                    if (valueParameterDescriptor != null) {
                        ValueParameterDescriptor it = valueParameterDescriptor;
                        boolean bl = false;
                        this.addDiagnostic(new NameForAmbiguousParameter(argument, parameter, it));
                    }
                }
            }
            if (parameter == null) {
                this.addDiagnostic(new NameNotFound(argument, this.descriptor));
            }
            return parameter;
        }

        public final void processArgumentsInParenthesis(@NotNull List<? extends KotlinCallArgument> arguments) {
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            for (KotlinCallArgument kotlinCallArgument : arguments) {
                Name argumentName = kotlinCallArgument.getArgumentName();
                if (argumentName == null) {
                    if (!this.processPositionArgument(kotlinCallArgument)) continue;
                    this.state = State.VARARG_POSITION;
                    continue;
                }
                if (this.state == State.VARARG_POSITION) {
                    this.completeVarargPositionArguments();
                }
                this.processNamedArgument(kotlinCallArgument, argumentName);
            }
            if (this.state == State.VARARG_POSITION) {
                this.completeVarargPositionArguments();
            }
        }

        public final void processExternalArgument(@NotNull KotlinCallArgument externalArgument) {
            Intrinsics.checkNotNullParameter((Object)externalArgument, (String)"externalArgument");
            ValueParameterDescriptor lastParameter = (ValueParameterDescriptor)CollectionsKt.lastOrNull(this.getParameters());
            if (lastParameter == null) {
                this.addDiagnostic(new TooManyArguments(externalArgument, this.descriptor));
                return;
            }
            if (ArgumentsUtilsKt.isVararg(lastParameter)) {
                this.addDiagnostic(new VarargArgumentOutsideParentheses(externalArgument, lastParameter));
                return;
            }
            ResolvedCallArgument previousOccurrence = this.result.get(lastParameter.getOriginal());
            if (previousOccurrence != null) {
                this.addDiagnostic(new TooManyArguments(externalArgument, this.descriptor));
                return;
            }
            this.result.put(lastParameter.getOriginal(), new ResolvedCallArgument.SimpleArgument(externalArgument));
        }

        public final void processDefaultsAndRunChecks() {
            for (Map.Entry<ValueParameterDescriptor, ResolvedCallArgument> entry : this.result.entrySet()) {
                ValueParameterDescriptor parameter = entry.getKey();
                ResolvedCallArgument resolvedArgument = entry.getValue();
                if (ArgumentsUtilsKt.isVararg(parameter)) continue;
                if (!(resolvedArgument instanceof ResolvedCallArgument.SimpleArgument)) {
                    throw new IllegalStateException(("Incorrect resolved argument for parameter " + parameter + " :" + resolvedArgument).toString());
                }
                if (!((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument().isSpread()) continue;
                this.addDiagnostic(new NonVarargSpread(((ResolvedCallArgument.SimpleArgument)resolvedArgument).getCallArgument()));
            }
            for (ValueParameterDescriptor parameter : this.getParameters()) {
                if (this.result.containsKey(parameter.getOriginal())) continue;
                if (ArgumentsUtilsKt.hasDefaultValue(parameter)) {
                    this.result.put(parameter.getOriginal(), ResolvedCallArgument.DefaultArgument.INSTANCE);
                    continue;
                }
                if (ArgumentsUtilsKt.isVararg(parameter)) {
                    this.result.put(parameter.getOriginal(), new ResolvedCallArgument.VarargArgument(CollectionsKt.emptyList()));
                    continue;
                }
                this.addDiagnostic(new NoValueForParameter(parameter, this.descriptor));
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/ArgumentsToParametersMapper$CallArgumentProcessor$State;", "", "<init>", "(Ljava/lang/String;I)V", "POSITION_ARGUMENTS", "VARARG_POSITION", "NAMED_ONLY_ARGUMENTS", "resolution"})
        private static final class State
        extends Enum<State> {
            public static final /* enum */ State POSITION_ARGUMENTS = new State();
            public static final /* enum */ State VARARG_POSITION = new State();
            public static final /* enum */ State NAMED_ONLY_ARGUMENTS = new State();
            private static final /* synthetic */ State[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            @NotNull
            public static EnumEntries<State> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = stateArray = new State[]{State.POSITION_ARGUMENTS, State.VARARG_POSITION, State.NAMED_ONLY_ARGUMENTS};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

