/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.logging.resolve;

import com.intellij.analysis.logging.resolve.LoggingArgumentSymbol;
import com.intellij.codeInspection.logging.LoggingPlaceholderUtilKt;
import com.intellij.codeInspection.logging.PlaceholderContext;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageHandler;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.navigation.NavigatableSymbol;
import com.intellij.navigation.SymbolNavigationService;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.navigation.NavigationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00000\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/intellij/analysis/logging/resolve/LoggingArgumentSymbol;", "Lcom/intellij/model/Symbol;", "Lcom/intellij/navigation/NavigatableSymbol;", "Lcom/intellij/find/usages/api/SearchTarget;", "expression", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "getExpression", "()Lcom/intellij/psi/PsiElement;", "usageHandler", "Lcom/intellij/find/usages/api/UsageHandler;", "getUsageHandler", "()Lcom/intellij/find/usages/api/UsageHandler;", "getPlaceholderString", "Lorg/jetbrains/uast/UExpression;", "createPointer", "Lcom/intellij/model/Pointer;", "presentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "getNavigationTargets", "", "Lcom/intellij/platform/backend/navigation/NavigationTarget;", "project", "Lcom/intellij/openapi/project/Project;", "equals", "", "other", "", "hashCode", "", "intellij.jvm.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nLoggingArgumentSymbol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggingArgumentSymbol.kt\ncom/intellij/analysis/logging/resolve/LoggingArgumentSymbol\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,48:1\n171#2:49\n18#3:50\n*S KotlinDebug\n*F\n+ 1 LoggingArgumentSymbol.kt\ncom/intellij/analysis/logging/resolve/LoggingArgumentSymbol\n*L\n27#1:49\n28#1:50\n*E\n"})
public final class LoggingArgumentSymbol
implements Symbol,
NavigatableSymbol,
SearchTarget {
    @NotNull
    private final PsiElement expression;
    @NotNull
    private final UsageHandler usageHandler;

    public LoggingArgumentSymbol(@NotNull PsiElement expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.expression = expression;
        UsageHandler usageHandler = UsageHandler.createEmptyUsageHandler((String)this.expression.getText());
        Intrinsics.checkNotNullExpressionValue((Object)usageHandler, (String)"createEmptyUsageHandler(...)");
        this.usageHandler = usageHandler;
    }

    @NotNull
    public final PsiElement getExpression() {
        return this.expression;
    }

    @NotNull
    public UsageHandler getUsageHandler() {
        return this.usageHandler;
    }

    @Nullable
    public final UExpression getPlaceholderString() {
        PsiElement $this$toUElementOfType$iv = this.expression;
        boolean $i$f$toUElementOfType = false;
        UExpression uExpression = (UExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UExpression.class);
        if (uExpression == null) {
            return null;
        }
        UExpression uExpression2 = uExpression;
        UElement $this$getParentOfType_u24default$iv = (UElement)uExpression2;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        UCallExpression uCallExpression = (UCallExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UCallExpression.class, (boolean)strict$iv);
        if (uCallExpression == null) {
            return null;
        }
        UCallExpression uCallExpression2 = uCallExpression;
        UCallExpression uCallExpression3 = LoggingPlaceholderUtilKt.detectLoggerMethod(uCallExpression2);
        if (uCallExpression3 == null) {
            return null;
        }
        UCallExpression logMethod = uCallExpression3;
        PlaceholderContext placeholderContext = LoggingPlaceholderUtilKt.getPlaceholderContext$default(logMethod, LoggingPlaceholderUtilKt.getLOGGER_RESOLVE_TYPE_SEARCHERS(), null, 4, null);
        return placeholderContext != null ? placeholderContext.getLogStringArgument() : null;
    }

    @NotNull
    public Pointer<LoggingArgumentSymbol> createPointer() {
        Pointer pointer = Pointer.delegatingPointer((Pointer)((Pointer)SmartPointerManager.createPointer((PsiElement)this.expression)), arg_0 -> LoggingArgumentSymbol.createPointer$lambda$0(createPointer.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"delegatingPointer(...)");
        return pointer;
    }

    @NotNull
    public TargetPresentation presentation() {
        String string = this.expression.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(string).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @NotNull
    public Collection<NavigationTarget> getNavigationTargets(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CollectionsKt.listOf((Object)SymbolNavigationService.getInstance().psiElementNavigationTarget(this.expression));
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof LoggingArgumentSymbol)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((LoggingArgumentSymbol)other).expression, (Object)this.expression);
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    private static final LoggingArgumentSymbol createPointer$lambda$0(Function1 $tmp0, Object p0) {
        return (LoggingArgumentSymbol)$tmp0.invoke(p0);
    }
}

