/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.system.CpuArch;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathManager {
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    private static volatile String ourHomePath;
    private static volatile List<Path> ourBinDirectories;
    private static String ourConfigPath;
    private static String ourSystemPath;

    @NotNull
    public static String getHomePath() {
        String string2 = PathManager.getHomePath(true);
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(0);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="true -> !null")
    public static String getHomePath(boolean insideIde) {
        String result2 = ourHomePath;
        if (result2 != null) {
            return result2;
        }
        Class<PathManager> clazz = PathManager.class;
        synchronized (PathManager.class) {
            result2 = ourHomePath;
            if (result2 != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result2;
            }
            String explicit = PathManager.getExplicitPath("idea.home.path");
            if (explicit == null) {
                explicit = PathManager.getExplicitPath("idea.home");
            }
            if (explicit != null) {
                result2 = explicit;
                if (!Files.isDirectory(Paths.get(result2, new String[0]), new LinkOption[0])) {
                    ourHomePath = result2;
                    throw new RuntimeException("Invalid home path '" + result2 + "'");
                }
            } else if (insideIde && (result2 = PathManager.getHomePathFor(PathManager.class)) == null) {
                String advice = SystemInfoRt.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
                throw new RuntimeException("Could not find installation home path. Please " + advice);
            }
            if (result2 != null && SystemInfoRt.isWindows) {
                try {
                    result2 = Paths.get(result2, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
                }
                catch (IOException advice) {
                    // empty catch block
                }
            }
            if (result2 == null) {
                ourBinDirectories = Collections.emptyList();
            } else {
                Path root = Paths.get(result2, new String[0]);
                if (Boolean.getBoolean("idea.use.dev.build.server")) {
                    root = root.resolve("../../../..").normalize();
                }
                ourBinDirectories = PathManager.getBinDirectories(root);
            }
            ourHomePath = result2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result2;
        }
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class<?> aClass) {
        Path result2;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(3);
        }
        return (result2 = PathManager.getHomeDirFor(aClass)) == null ? null : result2.toString();
    }

    @Nullable
    public static Path getHomeDirFor(@NotNull Class<?> aClass) {
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(4);
        }
        Path result2 = null;
        String rootPath = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class");
        if (rootPath != null) {
            Path root = Paths.get(rootPath, new String[0]).toAbsolutePath();
            while ((root = root.getParent()) != null && !PathManager.isIdeaHome(root)) {
            }
            result2 = root;
        }
        return result2;
    }

    private static boolean isIdeaHome(Path root) {
        for (Path binDir : PathManager.getBinDirectories(root)) {
            if (!Files.isRegularFile(binDir.resolve("idea.properties"), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    private static List<Path> getBinDirectories(Path root) {
        ArrayList<Path> binDirs = new ArrayList<Path>();
        Path[] candidates = new Path[]{root.resolve("bin"), Paths.get(PathManager.getCommunityHomePath(root.toString()), "bin")};
        String osSuffix = SystemInfoRt.isWindows ? "win" : (SystemInfoRt.isMac ? "mac" : "linux");
        for (Path dir2 : candidates) {
            String arch;
            if (binDirs.contains(dir2) || !Files.isDirectory(dir2, new LinkOption[0])) continue;
            binDirs.add(dir2);
            dir2 = dir2.resolve(osSuffix);
            if (!Files.isDirectory(dir2, new LinkOption[0])) continue;
            binDirs.add(dir2);
            if (!SystemInfoRt.isWindows && !SystemInfoRt.isLinux) continue;
            String string2 = CpuArch.isIntel64() ? "amd64" : (arch = CpuArch.isArm64() ? "aarch64" : null);
            if (arch == null || !Files.isDirectory(dir2 = dir2.resolve(arch), new LinkOption[0])) continue;
            binDirs.add(dir2);
        }
        return binDirs;
    }

    @NotNull
    public static String getBinPath() {
        String string2 = PathManager.getHomePath() + '/' + "bin";
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    public static Path getConfigDir() {
        Path path = Paths.get(PathManager.getConfigPath(), new String[0]);
        if (path == null) {
            PathManager.$$$reportNull$$$0(13);
        }
        return path;
    }

    @NotNull
    public static String getConfigPath() {
        if (ourConfigPath != null) {
            String string2 = ourConfigPath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(14);
            }
            return string2;
        }
        String explicit = PathManager.getExplicitPath("idea.config.path");
        ourConfigPath = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + "config");
        String string3 = ourConfigPath;
        if (string3 == null) {
            PathManager.$$$reportNull$$$0(15);
        }
        return string3;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(18);
        }
        String string2 = PathManager.platformPath(selector, "Application Support", "", "APPDATA", "", "XDG_CONFIG_HOME", ".config", "");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(19);
        }
        return string2;
    }

    @NotNull
    public static String getSystemPath() {
        if (ourSystemPath != null) {
            String string2 = ourSystemPath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(29);
            }
            return string2;
        }
        String explicit = PathManager.getExplicitPath("idea.system.path");
        ourSystemPath = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultSystemPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + "system");
        String string3 = ourSystemPath;
        if (string3 == null) {
            PathManager.$$$reportNull$$$0(30);
        }
        return string3;
    }

    @NotNull
    public static String getDefaultSystemPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(31);
        }
        String string2 = PathManager.platformPath(selector, "Caches", "", "LOCALAPPDATA", "", "XDG_CACHE_HOME", ".cache", "");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(32);
        }
        return string2;
    }

    @NotNull
    public static Path getIndexRoot() {
        String indexRootPath = PathManager.getExplicitPath("index_root_path");
        if (indexRootPath == null) {
            indexRootPath = PathManager.getSystemPath() + "/index";
        }
        Path path = Paths.get(indexRootPath, new String[0]);
        if (path == null) {
            PathManager.$$$reportNull$$$0(37);
        }
        return path;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class<?> context, @NotNull String path) {
        URL url;
        if (context == null) {
            PathManager.$$$reportNull$$$0(46);
        }
        if (path == null) {
            PathManager.$$$reportNull$$$0(47);
        }
        if ((url = context.getResource(path)) == null) {
            url = ClassLoader.getSystemResource(path.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path) : null;
    }

    @Nullable
    private static String extractRoot(URL resourceURL, String resourcePath) {
        if (resourcePath.isEmpty() || resourcePath.charAt(0) != '/' && resourcePath.charAt(0) != '\\') {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            File result2;
            try {
                result2 = new File(resourceURL.toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("URL='" + resourceURL + "'", e);
            }
            String path = result2.getPath();
            String testPath = path.replace('\\', '/');
            String testResourcePath = resourcePath.replace('\\', '/');
            if (StringUtilRt.endsWithIgnoreCase(testPath, testResourcePath)) {
                resultPath = path.substring(0, path.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol)) {
            String jarPath = PathManager.splitJarUrl(resourceURL.getFile());
            if (jarPath != null) {
                resultPath = jarPath;
            }
        } else if ("jrt".equals(protocol)) {
            return null;
        }
        if (resultPath == null) {
            PathManager.log("cannot extract '" + resourcePath + "' from '" + resourceURL + "'");
            return null;
        }
        return Paths.get(resultPath, new String[0]).normalize().toString();
    }

    @Nullable
    private static String splitJarUrl(@NotNull String url) {
        int pivot;
        if (url == null) {
            PathManager.$$$reportNull$$$0(50);
        }
        if ((pivot = url.indexOf("!/")) < 0) {
            return null;
        }
        String jarPath = url.substring(0, pivot);
        boolean startsWithConcatenation = true;
        int offset = 0;
        for (String prefix : new String[]{"jar", ":"}) {
            int prefixLen = prefix.length();
            if (!jarPath.regionMatches(offset, prefix, 0, prefixLen)) {
                startsWithConcatenation = false;
                break;
            }
            offset += prefixLen;
        }
        if (startsWithConcatenation) {
            jarPath = jarPath.substring("jar".length() + 1);
        }
        if (!jarPath.startsWith("file")) {
            return jarPath;
        }
        try {
            File result2;
            URL parsedUrl = new URL(jarPath);
            try {
                result2 = new File(parsedUrl.toURI().getSchemeSpecificPart());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("URL='" + parsedUrl + "'", e);
            }
            return result2.getPath().replace('\\', '/');
        }
        catch (Exception e) {
            jarPath = jarPath.substring("file".length());
            if (jarPath.startsWith("://")) {
                return jarPath.substring("://".length());
            }
            if (!jarPath.isEmpty() && jarPath.charAt(0) == ':') {
                return jarPath.substring(1);
            }
            return jarPath;
        }
    }

    @NotNull
    public static String getCommunityHomePath() {
        return PathManager.getCommunityHomePath(PathManager.getHomePath());
    }

    @NotNull
    private static String getCommunityHomePath(@NotNull String homePath) {
        boolean isRunningFromSources;
        if (homePath == null) {
            PathManager.$$$reportNull$$$0(54);
        }
        if (!(isRunningFromSources = Files.isDirectory(Paths.get(homePath, ".idea"), new LinkOption[0]))) {
            String string2 = homePath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(55);
            }
            return string2;
        }
        if (Files.isDirectory(Paths.get(homePath, "community/.idea"), new LinkOption[0])) {
            String string3 = homePath + "/community";
            if (string3 == null) {
                PathManager.$$$reportNull$$$0(56);
            }
            return string3;
        }
        if (Files.isDirectory(Paths.get(homePath, "ultimate/community/.idea"), new LinkOption[0])) {
            String string4 = homePath + "/ultimate/community";
            if (string4 == null) {
                PathManager.$$$reportNull$$$0(57);
            }
            return string4;
        }
        if (Files.isDirectory(Paths.get(homePath, "../../../community/.idea"), new LinkOption[0])) {
            String string5 = homePath + "/../../../community";
            if (string5 == null) {
                PathManager.$$$reportNull$$$0(58);
            }
            return string5;
        }
        if (Files.isRegularFile(Paths.get(homePath, "../../.dotnet-products.root.marker"), new LinkOption[0])) {
            String string6 = homePath + "/../ultimate/community";
            if (string6 == null) {
                PathManager.$$$reportNull$$$0(59);
            }
            return string6;
        }
        String string7 = homePath;
        if (string7 == null) {
            PathManager.$$$reportNull$$$0(60);
        }
        return string7;
    }

    @Nullable
    public static String getJarPathForClass(@NotNull Class<?> aClass) {
        Path resourceRoot;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(61);
        }
        return (resourceRoot = PathManager.getJarForClass(aClass)) == null ? null : resourceRoot.toString();
    }

    @Nullable
    public static Path getJarForClass(@NotNull Class<?> aClass) {
        String resourceRoot;
        if (aClass == null) {
            PathManager.$$$reportNull$$$0(62);
        }
        return (resourceRoot = PathManager.getResourceRoot(aClass, '/' + aClass.getName().replace('.', '/') + ".class")) == null ? null : Paths.get(resourceRoot, new String[0]).toAbsolutePath();
    }

    private static void log(String x) {
        System.err.println(x);
    }

    @NotNull
    public static String getAbsolutePath(@NotNull String path) {
        if (path == null) {
            PathManager.$$$reportNull$$$0(63);
        }
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = System.getProperty("user.home") + path.substring(1);
        }
        String string2 = Paths.get(path, new String[0]).toAbsolutePath().normalize().toString();
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(64);
        }
        return string2;
    }

    @Nullable
    private static String getExplicitPath(@NotNull String property2) {
        String path;
        if (property2 == null) {
            PathManager.$$$reportNull$$$0(65);
        }
        if ((path = System.getProperty(property2)) == null) {
            return null;
        }
        boolean quoted = path.length() > 1 && '\"' == path.charAt(0) && '\"' == path.charAt(path.length() - 1);
        return PathManager.getAbsolutePath(quoted ? path.substring(1, path.length() - 1) : path);
    }

    private static String platformPath(String selector, String macDir, String macSub, String winVar, String winSub, String xdgVar, String xdgDfl, String xdgSub) {
        String userHome = System.getProperty("user.home");
        String vendorName = PathManager.vendorName();
        if (SystemInfoRt.isMac) {
            String dir2 = userHome + "/Library/" + macDir + '/' + vendorName;
            if (!selector.isEmpty()) {
                dir2 = dir2 + '/' + selector;
            }
            if (!macSub.isEmpty()) {
                dir2 = dir2 + '/' + macSub;
            }
            return dir2;
        }
        if (SystemInfoRt.isWindows) {
            String dir3 = System.getenv(winVar);
            if (dir3 == null || dir3.isEmpty()) {
                dir3 = userHome + "\\AppData\\" + (winVar.startsWith("LOCAL") ? "Local" : "Roaming");
            }
            dir3 = dir3 + '\\' + vendorName;
            if (!selector.isEmpty()) {
                dir3 = dir3 + '\\' + selector;
            }
            if (!winSub.isEmpty()) {
                dir3 = dir3 + '\\' + winSub;
            }
            return dir3;
        }
        if (SystemInfoRt.isUnix) {
            return PathManager.getUnixPlatformPath(userHome, selector, xdgVar, xdgDfl, xdgSub);
        }
        throw new UnsupportedOperationException("Unsupported OS: " + SystemInfoRt.OS_NAME);
    }

    private static String getUnixPlatformPath(String userHome, String selector, @Nullable String xdgVar, String xdgDfl, String xdgSub) {
        String dir2;
        String string2 = dir2 = xdgVar != null ? System.getenv(xdgVar) : null;
        if (dir2 == null || dir2.isEmpty()) {
            dir2 = userHome + '/' + xdgDfl;
        }
        dir2 = dir2 + '/' + PathManager.vendorName();
        if (!selector.isEmpty()) {
            dir2 = dir2 + '/' + selector;
        }
        if (!xdgSub.isEmpty()) {
            dir2 = dir2 + '/' + xdgSub;
        }
        return dir2;
    }

    private static String vendorName() {
        String property2 = System.getProperty("idea.vendor.name");
        if (property2 == null) {
            try {
                Class<?> ex = Class.forName("com.intellij.openapi.application.ex.ApplicationInfoEx");
                Class<?> impl = Class.forName("com.intellij.openapi.application.impl.ApplicationInfoImpl");
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Object instance2 = lookup.findStatic(impl, "getShadowInstance", MethodType.methodType(ex)).invoke();
                property2 = lookup.findVirtual(impl, "getShortCompanyName", MethodType.methodType(String.class)).invoke(instance2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.setProperty("idea.vendor.name", property2 != null ? property2 : "JetBrains");
        }
        return property2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 18: 
            case 21: 
            case 26: 
            case 31: 
            case 33: 
            case 34: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 61: 
            case 62: 
            case 63: 
            case 65: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 18: 
            case 21: 
            case 26: 
            case 31: 
            case 33: 
            case 34: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 61: 
            case 62: 
            case 63: 
            case 65: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 1: 
            case 47: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: 
            case 4: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 6: 
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 18: 
            case 26: 
            case 31: 
            case 34: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userHome";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaHomePath";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 18: 
            case 21: 
            case 26: 
            case 31: 
            case 33: 
            case 34: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 61: 
            case 62: 
            case 63: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinFileWithException";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreInstalledPluginsPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundledRuntimePath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonDataPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigDir";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getScratchPath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigPathFor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsDir";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsPath";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPluginPathFor";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemDir";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemPath";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSystemPathFor";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUnixSystemPath";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempPath";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexRoot";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogDir";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogPath";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLogPathFor";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartupScriptDir";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginTempPath";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileInLibDirectory";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommunityHomePath";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUnderHomeDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHomePathFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHomeDirFor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findBinFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findBinFileWithException";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfigPathFor";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsFile";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPluginPathFor";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSystemPathFor";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultUnixSystemPath";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultLogPathFor";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getResourceRoot";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "splitJarUrl";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "substituteVars";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findFileInLibDirectory";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getCommunityHomePath";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getJarPathForClass";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getJarForClass";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePath";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitPath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 18: 
            case 21: 
            case 26: 
            case 31: 
            case 33: 
            case 34: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 61: 
            case 62: 
            case 63: 
            case 65: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

