/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/SealedInheritorInSamePackageChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class SealedInheritorInSamePackageChecker
implements DeclarationChecker {
    @NotNull
    public static final SealedInheritorInSamePackageChecker INSTANCE = new SealedInheritorInSamePackageChecker();

    private SealedInheritorInSamePackageChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowSealedInheritorsInDifferentFilesOfSamePackage)) {
            return;
        }
        if (!(descriptor instanceof ClassDescriptor) || !(declaration instanceof KtClassOrObject)) {
            return;
        }
        FqName fqName = DescriptorUtilKt.containingPackage(descriptor);
        if (fqName == null) {
            return;
        }
        FqName classPackage = fqName;
        for (KtSuperTypeListEntry superTypeListEntry : ((KtClassOrObject)declaration).getSuperTypeListEntries()) {
            FqName superClassPackage;
            ClassifierDescriptor superClass;
            KotlinType superType;
            KtTypeReference typeReference;
            if (superTypeListEntry.getTypeReference() == null) continue;
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            KotlinType kotlinType = BindingContextUtilsKt.getAbbreviatedTypeOrType(typeReference, bindingContext);
            if (kotlinType == null) continue;
            if ((kotlinType = kotlinType.unwrap()) == null || (superType = kotlinType).getConstructor().getDeclarationDescriptor() == null || !DescriptorUtilKt.isSealed(superClass) || DescriptorUtilKt.containingPackage(superClass) == null || Intrinsics.areEqual(classPackage, superClassPackage)) continue;
            context.getTrace().report(Errors.SEALED_INHERITOR_IN_DIFFERENT_PACKAGE.on((KtTypeReference)((PsiElement)typeReference), classPackage, superClassPackage));
        }
    }
}

