/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.Validator;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.JavaFXBundle;
import org.jetbrains.plugins.javaFX.fxml.JavaFxCommonNames;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassTagDescriptorBase;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyTagDescriptor;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;

public final class JavaFxPsiUtil {
    private static final Logger LOG = Logger.getInstance(JavaFxPsiUtil.class);
    private static final Key<CachedValue<PsiClass>> INJECTED_CONTROLLER = Key.create((String)"javafx.injected.controller");

    public static XmlProcessingInstruction createSingleImportInstruction(String qualifiedName, Project project) {
        String importText = "<?import " + qualifiedName + "?>";
        PsiElement child = PsiFileFactory.getInstance((Project)project).createFileFromText("a.fxml", (Language)XMLLanguage.INSTANCE, (CharSequence)importText).getFirstChild();
        return (XmlProcessingInstruction)PsiTreeUtil.findChildOfType((PsiElement)child, XmlProcessingInstruction.class);
    }

    public static List<String> parseImports(XmlFile file) {
        return JavaFxPsiUtil.parseInstructions(file, "import");
    }

    public static List<String> parseInjectedLanguages(XmlFile file) {
        return JavaFxPsiUtil.parseInstructions(file, "language");
    }

    private static List<String> parseInstructions(XmlFile file, String instructionName) {
        ArrayList<String> definedImports = new ArrayList<String>();
        XmlDocument document = file.getDocument();
        if (document != null) {
            XmlProlog prolog = document.getProlog();
            ArrayList instructions = new ArrayList(PsiTreeUtil.findChildrenOfType((PsiElement)prolog, XmlProcessingInstruction.class));
            for (XmlProcessingInstruction instruction : instructions) {
                String instructionTarget = JavaFxPsiUtil.getInstructionTarget(instructionName, instruction);
                if (instructionTarget == null) continue;
                definedImports.add(instructionTarget);
            }
        }
        return definedImports;
    }

    @Nullable
    public static String getInstructionTarget(String instructionName, XmlProcessingInstruction instruction) {
        ASTNode node = instruction.getNode();
        ASTNode xmlNameNode = node.findChildByType(XmlTokenType.XML_NAME);
        ASTNode importNode = node.findChildByType(XmlTokenType.XML_TAG_CHARACTERS);
        if (xmlNameNode != null && instructionName.equals(xmlNameNode.getText()) && importNode != null) {
            return importNode.getText();
        }
        return null;
    }

    public static PsiClass findPsiClass(String name, PsiElement context) {
        Project project = context.getProject();
        if (!StringUtil.getShortName((String)name).equals(name)) {
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(name, GlobalSearchScope.allScope((Project)project));
            if (psiClass != null) {
                return psiClass;
            }
            return JavaFxPsiUtil.findNestedPsiClass(name, context, project);
        }
        return JavaFxPsiUtil.findPsiClass(name, JavaFxPsiUtil.parseImports((XmlFile)context.getContainingFile()), context, project);
    }

    private static PsiClass findNestedPsiClass(String name, PsiElement context, Project project) {
        String outerName;
        PsiClass outerClass;
        int dotIndex = name.indexOf(46);
        if (dotIndex > 0 && (outerClass = JavaFxPsiUtil.findPsiClass(outerName = name.substring(0, dotIndex), JavaFxPsiUtil.parseImports((XmlFile)context.getContainingFile()), context, project)) != null) {
            List nameChain = StringUtil.split((String)name, (String)".", (boolean)true, (boolean)false);
            List nestedNames = nameChain.subList(1, nameChain.size());
            PsiClass aClass = outerClass;
            for (String nestedName : nestedNames) {
                if ((aClass = aClass.findInnerClassByName(nestedName, true)) != null) continue;
                return null;
            }
            return aClass;
        }
        return null;
    }

    private static PsiClass findPsiClass(String name, List<String> imports, PsiElement context, Project project) {
        PsiClass psiClass = null;
        if (imports != null) {
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiFile file = context.getContainingFile();
            for (String anImport : imports) {
                if (StringUtil.getShortName((String)anImport).equals(name)) {
                    psiClass = psiFacade.findClass(anImport, file.getResolveScope());
                } else if (StringUtil.endsWith((CharSequence)anImport, (CharSequence)".*")) {
                    psiClass = psiFacade.findClass(StringUtil.trimEnd((String)anImport, (String)"*") + name, file.getResolveScope());
                }
                if (psiClass == null) continue;
                return psiClass;
            }
        }
        return null;
    }

    public static void insertImportWhenNeeded(XmlFile xmlFile, String shortName, String qualifiedName) {
        XmlDocument document;
        if (shortName != null && qualifiedName != null && JavaFxPsiUtil.findPsiClass(shortName, (PsiElement)xmlFile.getRootTag()) == null && (document = xmlFile.getDocument()) != null) {
            XmlProcessingInstruction processingInstruction = JavaFxPsiUtil.createSingleImportInstruction(qualifiedName, xmlFile.getProject());
            XmlProlog prolog = document.getProlog();
            if (prolog != null) {
                prolog.add((PsiElement)processingInstruction);
            } else {
                document.addBefore((PsiElement)processingInstruction, (PsiElement)document.getRootTag());
            }
            PostprocessReformattingAspect.getInstance((Project)xmlFile.getProject()).doPostponedFormatting(xmlFile.getViewProvider());
        }
    }

    public static PsiClass getPropertyClass(PsiElement member) {
        PsiClassType classType = JavaFxPsiUtil.getPropertyClassType(member);
        return classType != null ? classType.resolve() : null;
    }

    public static PsiClassType getPropertyClassType(PsiElement member) {
        return JavaFxPsiUtil.getPropertyClassType(member, "javafx.beans.property.ObjectProperty");
    }

    public static PsiClassType getPropertyClassType(PsiElement member, String superTypeFQN) {
        PsiClass objectProperty;
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass attributeClass;
        PsiType type;
        if (member instanceof PsiMember && (type = PropertyUtilBase.getPropertyType((PsiMember)((PsiMember)member))) instanceof PsiClassType && (attributeClass = (resolveResult = ((PsiClassType)type).resolveGenerics()).getElement()) != null && (objectProperty = JavaPsiFacade.getInstance((Project)attributeClass.getProject()).findClass(superTypeFQN, attributeClass.getResolveScope())) != null) {
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)objectProperty, (PsiClass)attributeClass, (PsiSubstitutor)resolveResult.getSubstitutor());
            if (superClassSubstitutor != null) {
                PsiType propertyType = superClassSubstitutor.substitute(objectProperty.getTypeParameters()[0]);
                if (propertyType instanceof PsiClassType) {
                    return (PsiClassType)propertyType;
                }
            } else {
                return (PsiClassType)type;
            }
        }
        return null;
    }

    public static PsiMethod findStaticPropertySetter(String attributeName, XmlTag context) {
        PsiClass classWithStaticProperty;
        String packageName = StringUtil.getPackageName((String)attributeName);
        if (context != null && !StringUtil.isEmptyOrSpaces((String)packageName) && (classWithStaticProperty = JavaFxPsiUtil.findPsiClass(packageName, (PsiElement)context)) != null) {
            return JavaFxPsiUtil.findStaticPropertySetter(attributeName, classWithStaticProperty);
        }
        return null;
    }

    @Nullable
    public static PsiMethod findStaticPropertySetter(@NotNull String attributeName, @Nullable PsiClass classWithStaticProperty) {
        PsiMethod[] setters;
        if (attributeName == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(0);
        }
        if (classWithStaticProperty == null) {
            return null;
        }
        String setterName = PropertyUtilBase.suggestSetterName((String)StringUtil.getShortName((String)attributeName));
        for (PsiMethod setter : setters = classWithStaticProperty.findMethodsByName(setterName, true)) {
            if (!setter.hasModifierProperty("public") || !setter.hasModifierProperty("static") || setter.getParameterList().getParametersCount() != 2) continue;
            return setter;
        }
        return null;
    }

    public static PsiMethod findPropertyGetter(@NotNull PsiClass psiClass, @Nullable String propertyName) {
        if (psiClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(1);
        }
        if (StringUtil.isEmpty((String)propertyName)) {
            return null;
        }
        PsiMethod getter = JavaFxPsiUtil.findPropertyGetter(psiClass, propertyName, null);
        if (getter != null) {
            return getter;
        }
        return JavaFxPsiUtil.findPropertyGetter(psiClass, propertyName, (PsiType)PsiTypes.booleanType());
    }

    private static PsiMethod findPropertyGetter(PsiClass psiClass, String propertyName, PsiType propertyType) {
        PsiMethod[] getters;
        String getterName = PropertyUtilBase.suggestGetterName((String)propertyName, (PsiType)propertyType);
        for (PsiMethod getter : getters = psiClass.findMethodsByName(getterName, true)) {
            if (!getter.hasModifierProperty("public") || getter.hasModifierProperty("static") || !PropertyUtilBase.isSimplePropertyGetter((PsiMethod)getter)) continue;
            return getter;
        }
        return null;
    }

    public static PsiMethod findObservablePropertyGetter(@NotNull PsiClass psiClass, @Nullable String propertyName) {
        PsiMethod[] getters;
        if (psiClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)propertyName)) {
            return null;
        }
        for (PsiMethod getter : getters = psiClass.findMethodsByName(propertyName + "Property", true)) {
            if (!getter.hasModifierProperty("public") || getter.hasModifierProperty("static") || !getter.getParameterList().isEmpty() || !InheritanceUtil.isInheritor((PsiType)getter.getReturnType(), (String)"javafx.beans.value.ObservableValue")) continue;
            return getter;
        }
        return null;
    }

    public static PsiClass getControllerClass(PsiFile containingFile) {
        if (containingFile instanceof XmlFile) {
            XmlAttribute rootTypeAttr;
            CachedValuesManager manager;
            PsiClass injectedControllerClass;
            PsiClass controllerClass;
            XmlAttribute attribute;
            XmlTag rootTag = ((XmlFile)containingFile).getRootTag();
            Project project = containingFile.getProject();
            if (rootTag != null && (attribute = rootTag.getAttribute("fx:controller")) != null && (controllerClass = JavaFxPsiUtil.findControllerClass(containingFile, project, attribute)) != null) {
                return controllerClass;
            }
            if (Registry.is((String)"javafx.fxml.controller.from.loader", (boolean)false) && (injectedControllerClass = (PsiClass)(manager = CachedValuesManager.getManager((Project)containingFile.getProject())).getCachedValue((UserDataHolder)containingFile, INJECTED_CONTROLLER, () -> JavaFxPsiUtil.computeInjectedControllerClass(containingFile), true)) != null) {
                return injectedControllerClass;
            }
            if (rootTag != null && "fx:root".equals(rootTag.getName()) && (rootTypeAttr = rootTag.getAttribute("type")) != null) {
                return JavaFxPsiUtil.findControllerClass(containingFile, project, rootTypeAttr);
            }
        }
        return null;
    }

    private static PsiClass findControllerClass(PsiFile containingFile, Project project, XmlAttribute attribute) {
        String attributeValue = attribute.getValue();
        if (!StringUtil.isEmptyOrSpaces((String)attributeValue)) {
            GlobalSearchScope customScope = GlobalSearchScope.projectScope((Project)project).intersectWith(containingFile.getResolveScope());
            return JavaPsiFacade.getInstance((Project)project).findClass(attributeValue, customScope);
        }
        return null;
    }

    public static boolean isEventHandlerProperty(@NotNull XmlAttribute attribute) {
        PsiClass tagClass;
        if (attribute == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(3);
        }
        return (tagClass = JavaFxPsiUtil.getTagClass(attribute.getParent())) != null && JavaFxPsiUtil.getEventHandlerPropertyType(tagClass, attribute.getName()) != null;
    }

    @Nullable
    public static PsiClass getTagClass(@Nullable XmlAttributeValue xmlAttributeValue) {
        PsiElement parent;
        if (xmlAttributeValue != null && (parent = xmlAttributeValue.getParent()) instanceof XmlAttribute) {
            XmlTag xmlTag = ((XmlAttribute)parent).getParent();
            return JavaFxPsiUtil.getTagClass(xmlTag);
        }
        return null;
    }

    @Nullable
    public static PsiClass getTagClass(@Nullable XmlTag xmlTag) {
        PsiElement declaration;
        XmlElementDescriptor descriptor;
        if (xmlTag != null && (descriptor = xmlTag.getDescriptor()) != null && (declaration = descriptor.getDeclaration()) instanceof PsiClass) {
            return (PsiClass)declaration;
        }
        return null;
    }

    @Nullable
    public static PsiElement getAttributeDeclaration(@Nullable XmlAttributeValue xmlAttributeValue) {
        XmlAttributeDescriptor descriptor;
        PsiElement parent;
        if (xmlAttributeValue != null && (parent = xmlAttributeValue.getParent()) instanceof XmlAttribute && (descriptor = ((XmlAttribute)parent).getDescriptor()) != null) {
            return descriptor.getDeclaration();
        }
        return null;
    }

    public static boolean isVisibleInFxml(@NotNull PsiMember psiMember) {
        if (psiMember == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(4);
        }
        return psiMember.hasModifierProperty("public") || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, (String)"javafx.fxml.FXML", (int)0);
    }

    @Nullable
    public static PsiMethod findValueOfMethod(@NotNull PsiType psiType) {
        PsiClass psiClass;
        if (psiType == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(5);
        }
        return (psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)psiType)) != null ? JavaFxPsiUtil.findValueOfMethod(psiClass) : null;
    }

    @Nullable
    public static PsiMethod findValueOfMethod(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(6);
        }
        return (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            PsiMethod[] methods;
            for (PsiMethod method : methods = psiClass.findMethodsByName("valueOf", true)) {
                PsiType type;
                PsiParameter[] parameters;
                if (!method.hasModifierProperty("static") || (parameters = method.getParameterList().getParameters()).length != 1 || !(type = parameters[0].getType()).equalsToText("java.lang.String") && !type.equalsToText("java.lang.Object") || !psiClass.equals(PsiUtil.resolveClassInType((PsiType)method.getReturnType()))) continue;
                return CachedValueProvider.Result.create((Object)method, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public static boolean isReadOnly(String attributeName, XmlTag tag) {
        if (JavaFxPsiUtil.findStaticPropertySetter(attributeName, tag) != null) {
            return false;
        }
        XmlElementDescriptor descriptor = tag.getDescriptor();
        if (descriptor instanceof JavaFxClassTagDescriptorBase) {
            return ((JavaFxClassTagDescriptorBase)descriptor).isReadOnlyAttribute(attributeName);
        }
        return false;
    }

    public static boolean isExpressionBinding(@Nullable String value) {
        return value != null && value.startsWith("${") && value.endsWith("}");
    }

    public static boolean isIncorrectExpressionBinding(@Nullable String value) {
        if (value == null || !value.startsWith("$")) {
            return false;
        }
        if (value.length() == 1) {
            return true;
        }
        boolean expressionStarts = value.startsWith("${");
        boolean expressionEnds = value.endsWith("}");
        if (expressionStarts && expressionEnds && value.length() == 3) {
            return true;
        }
        if (expressionStarts != expressionEnds) {
            return true;
        }
        if (expressionStarts && value.indexOf(123, 2) >= 2) {
            return true;
        }
        return expressionEnds && value.indexOf(125) < value.length() - 1;
    }

    @Nullable
    public static PsiType getWritablePropertyType(@Nullable PsiType type, @NotNull Project project) {
        PsiSubstitutor substitutor;
        PsiClass propertyClass;
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass psiClass;
        if (project == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(7);
        }
        if ((psiClass = (resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)type)).getElement()) != null && (propertyClass = JavaPsiFacade.getInstance((Project)project).findClass("javafx.beans.property.Property", GlobalSearchScope.allScope((Project)project))) != null && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)propertyClass, (PsiClass)psiClass, (PsiSubstitutor)resolveResult.getSubstitutor())) != null) {
            return substitutor.substitute(propertyClass.getTypeParameters()[0]);
        }
        return null;
    }

    @Nullable
    private static PsiType getDefaultPropertyExpectedType(@Nullable PsiClass aClass) {
        if (aClass == null) {
            return null;
        }
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> {
            String propertyName;
            PsiMethod getter;
            PsiAnnotationMemberValue memberValue;
            PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)aClass, Collections.singleton("javafx.beans.DefaultProperty"));
            if (annotation != null && (memberValue = annotation.findAttributeValue(null)) != null && (getter = JavaFxPsiUtil.findPropertyGetter(aClass, propertyName = StringUtil.unquoteString((String)memberValue.getText()))) != null) {
                PsiType propertyType = JavaFxPsiUtil.eraseFreeTypeParameters(getter.getReturnType(), (PsiMember)getter);
                return CachedValueProvider.Result.create((Object)propertyType, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public static String getDefaultPropertyName(@Nullable PsiClass aClass) {
        PsiAnnotationMemberValue memberValue;
        if (aClass == null) {
            return null;
        }
        PsiAnnotation annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)aClass, Collections.singleton("javafx.beans.DefaultProperty"));
        if (annotation != null && (memberValue = annotation.findAttributeValue(null)) != null) {
            return StringUtil.unquoteString((String)memberValue.getText());
        }
        return null;
    }

    public static boolean isAbleToInstantiate(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(8);
        }
        return JavaFxPsiUtil.isAbleToInstantiate(psiClass, message -> {});
    }

    public static boolean isAbleToInstantiate(@NotNull PsiClass psiClass, @NotNull Consumer<? super String> messageConsumer) {
        if (psiClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(9);
        }
        if (messageConsumer == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(10);
        }
        if (psiClass.isEnum() || JavaFxPsiUtil.hasNamedArgOrNoArgConstructor(psiClass)) {
            return true;
        }
        PsiMethod valueOf = JavaFxPsiUtil.findValueOfMethod(psiClass);
        if (valueOf == null && !JavaFxPsiUtil.hasBuilder(psiClass)) {
            messageConsumer.accept(JavaFXBundle.message("unable.to.instantiate", new Object[0]));
            return false;
        }
        return true;
    }

    private static boolean hasNamedArgOrNoArgConstructor(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(11);
        }
        if (psiClass.getConstructors().length == 0) {
            return true;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            for (PsiMethod constructor : psiClass.getConstructors()) {
                PsiParameter[] parameters = constructor.getParameterList().getParameters();
                if (parameters.length == 0) {
                    return CachedValueProvider.Result.create((Object)true, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
                boolean annotated = true;
                for (PsiParameter parameter : parameters) {
                    if (AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)"javafx.beans.NamedArg", (int)0)) continue;
                    annotated = false;
                    break;
                }
                if (!annotated) continue;
                return CachedValueProvider.Result.create((Object)true, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public static boolean hasBuilder(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(12);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            PsiMethod[] buildMethods;
            Project project = psiClass.getProject();
            PsiClass builderClass = JavaPsiFacade.getInstance((Project)project).findClass("javafx.util.Builder", GlobalSearchScope.allScope((Project)project));
            if (builderClass != null && (buildMethods = builderClass.findMethodsByName("build", false)).length == 1 && buildMethods[0].getParameterList().isEmpty() && ClassInheritorsSearch.search((PsiClass)builderClass).forEach(aClass -> {
                PsiType returnType = null;
                PsiMethod method = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)aClass, (PsiMethod)buildMethods[0], (boolean)false);
                if (method != null) {
                    returnType = method.getReturnType();
                }
                return !Comparing.equal((Object)psiClass, (Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)returnType));
            })) {
                return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            return CachedValueProvider.Result.create((Object)true, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public static boolean isClassAcceptable(@Nullable XmlTag targetTag, @Nullable PsiClass fromClass) {
        return JavaFxPsiUtil.isClassAcceptable(targetTag, fromClass, (message, type) -> {});
    }

    public static boolean isClassAcceptable(@Nullable XmlTag targetTag, @Nullable PsiClass fromClass, @NotNull BiConsumer<? super String, ? super Validator.ValidationHost.ErrorType> messageConsumer) {
        PsiElement tagDeclaration;
        if (messageConsumer == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(13);
        }
        if (targetTag == null || fromClass == null || !fromClass.isValid()) {
            return true;
        }
        XmlElementDescriptor tagDescriptor = targetTag.getDescriptor();
        if (tagDescriptor instanceof JavaFxPropertyTagDescriptor) {
            PsiClass containingClass = ((JavaFxPropertyTagDescriptor)tagDescriptor).getPsiClass();
            PsiType targetType = JavaFxPsiUtil.getWritablePropertyType(containingClass, tagDescriptor.getDeclaration());
            return JavaFxPsiUtil.canCoerce(targetType, fromClass, (PsiElement)targetTag, messageConsumer);
        }
        if (tagDescriptor instanceof JavaFxClassTagDescriptorBase && (tagDeclaration = tagDescriptor.getDeclaration()) instanceof PsiClass) {
            PsiType targetType;
            PsiClass defaultPropertyOwnerClass = (PsiClass)tagDeclaration;
            XmlAttribute factoryAttr = targetTag.getAttribute("fx:factory");
            if (factoryAttr != null) {
                defaultPropertyOwnerClass = JavaFxPsiUtil.getFactoryProducedClass((PsiClass)tagDeclaration, factoryAttr.getValue());
            }
            if ((targetType = JavaFxPsiUtil.getDefaultPropertyExpectedType(defaultPropertyOwnerClass)) != null) {
                return JavaFxPsiUtil.canCoerce(targetType, fromClass, (PsiElement)targetTag, messageConsumer);
            }
            if (!JavaFxPsiUtil.isObservableCollection(defaultPropertyOwnerClass)) {
                return JavaFxPsiUtil.noDefaultPropertyError(messageConsumer);
            }
        }
        return true;
    }

    private static boolean noDefaultPropertyError(@NotNull BiConsumer<? super String, ? super Validator.ValidationHost.ErrorType> messageConsumer) {
        if (messageConsumer == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(14);
        }
        messageConsumer.accept("Parent tag has no default property", (Validator.ValidationHost.ErrorType)Validator.ValidationHost.ErrorType.ERROR);
        return false;
    }

    private static boolean canCoerce(@Nullable PsiType targetType, @NotNull PsiClass fromClass, @NotNull PsiElement context, @NotNull BiConsumer<? super String, ? super Validator.ValidationHost.ErrorType> messageConsumer) {
        if (fromClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(15);
        }
        if (context == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(16);
        }
        if (messageConsumer == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(17);
        }
        if (targetType == null) {
            return true;
        }
        PsiType collectionItemType = JavaGenericsUtil.getCollectionItemType((PsiType)targetType, (GlobalSearchScope)fromClass.getResolveScope());
        if (collectionItemType == null && InheritanceUtil.isInheritor((PsiType)targetType, (String)"javafx.beans.property.Property")) {
            collectionItemType = JavaFxPsiUtil.getWritablePropertyType(targetType, fromClass.getProject());
        }
        if (collectionItemType != null) {
            return JavaFxPsiUtil.canCoerceImpl(collectionItemType, fromClass, context, messageConsumer);
        }
        return JavaFxPsiUtil.canCoerceImpl(targetType, fromClass, context, messageConsumer);
    }

    @Nullable
    private static PsiType eraseFreeTypeParameters(@Nullable PsiType psiType, @NotNull PsiMember member) {
        if (member == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(18);
        }
        PsiClass containingClass = member.getContainingClass();
        return JavaFxPsiUtil.eraseFreeTypeParameters(psiType, containingClass);
    }

    @Nullable
    private static PsiType eraseFreeTypeParameters(@Nullable PsiType psiType, @Nullable PsiClass containingClass) {
        if (containingClass == null) {
            return null;
        }
        return JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createRawSubstitutor((PsiTypeParameterListOwner)containingClass).substitute(psiType);
    }

    private static boolean canCoerceImpl(@NotNull PsiType targetType, @NotNull PsiClass fromClass, @NotNull PsiElement context, @NotNull BiConsumer<? super String, ? super Validator.ValidationHost.ErrorType> messageConsumer) {
        PsiType valueOfParameterType;
        PsiClassType boxedTargetClass;
        if (targetType == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(19);
        }
        if (fromClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(20);
        }
        if (context == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(21);
        }
        if (messageConsumer == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(22);
        }
        if (targetType.equalsToText("java.lang.Object") || targetType.equalsToText("java.lang.String") || targetType.isAssignableFrom((PsiType)PsiTypesUtil.getClassType((PsiClass)fromClass))) {
            return true;
        }
        PsiClassType psiClassType = boxedTargetClass = targetType instanceof PsiPrimitiveType ? ((PsiPrimitiveType)targetType).getBoxedType(context) : null;
        if (boxedTargetClass != null && InheritanceUtil.isInheritor((PsiType)boxedTargetClass, (String)"java.lang.Number") || InheritanceUtil.isInheritor((PsiType)targetType, (String)"java.lang.Number")) {
            if (Comparing.strEqual((String)fromClass.getQualifiedName(), (String)"java.lang.String") || InheritanceUtil.isInheritor((PsiClass)fromClass, (String)"java.lang.Number")) {
                return true;
            }
            return JavaFxPsiUtil.unrelatedTypesWarning(targetType, fromClass, messageConsumer);
        }
        PsiMethod valueOfMethod = JavaFxPsiUtil.findValueOfMethod(targetType);
        PsiType psiType = valueOfParameterType = valueOfMethod != null && valueOfMethod.getParameterList().getParametersCount() == 1 ? valueOfMethod.getParameterList().getParameters()[0].getType() : null;
        if (valueOfParameterType != null && valueOfParameterType.equalsToText("java.lang.Object")) {
            return true;
        }
        if (Comparing.strEqual((String)fromClass.getQualifiedName(), (String)"java.lang.String") && (JavaFxPsiUtil.isPrimitiveOrBoxed(targetType) || valueOfParameterType != null && valueOfParameterType.equalsToText("java.lang.String"))) {
            return true;
        }
        if (valueOfMethod != null) {
            return JavaFxPsiUtil.unrelatedTypesWarning(targetType, fromClass, messageConsumer);
        }
        return JavaFxPsiUtil.unableToCoerceError(targetType, fromClass, messageConsumer);
    }

    private static boolean unableToCoerceError(@NotNull PsiType targetType, @NotNull PsiClass fromClass, @NotNull BiConsumer<? super String, ? super Validator.ValidationHost.ErrorType> messageConsumer) {
        if (targetType == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(23);
        }
        if (fromClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(24);
        }
        if (messageConsumer == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(25);
        }
        messageConsumer.accept(JavaFXBundle.message("unable.to.coerce.error", HighlightNamesUtil.formatClass((PsiClass)fromClass), targetType.getCanonicalText()), (Validator.ValidationHost.ErrorType)Validator.ValidationHost.ErrorType.ERROR);
        return false;
    }

    private static boolean unrelatedTypesWarning(@NotNull PsiType targetType, @NotNull PsiClass fromClass, @NotNull BiConsumer<? super @InspectionMessage String, ? super // Could not load outer class - annotation placement on inner may be incorrect
    Validator.ValidationHost.ErrorType> messageConsumer) {
        if (targetType == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(26);
        }
        if (fromClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(27);
        }
        if (messageConsumer == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(28);
        }
        messageConsumer.accept(JavaFXBundle.message("conversion.between.unrelated.types.error", HighlightNamesUtil.formatClass((PsiClass)fromClass), targetType.getCanonicalText()), (Validator.ValidationHost.ErrorType)Validator.ValidationHost.ErrorType.WARNING);
        return true;
    }

    public static boolean isOutOfHierarchy(XmlAttributeValue element) {
        for (XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class); tag != null; tag = tag.getParentTag()) {
            if (!"fx:define".equals(tag.getName())) continue;
            return true;
        }
        return false;
    }

    public static PsiType getWrappedPropertyType(PsiField field, Project project, Map<String, PsiType> typeMap) {
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)field, () -> {
            PsiType propertyType;
            PsiType fieldType = field.getType();
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)fieldType);
            PsiClass fieldClass = resolveResult.getElement();
            if (fieldClass == null) {
                PsiType propertyType2 = JavaFxPsiUtil.eraseFreeTypeParameters(fieldType, (PsiMember)field);
                return CachedValueProvider.Result.create((Object)propertyType2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            PsiType substitute = null;
            for (String typeName : typeMap.keySet()) {
                if (!InheritanceUtil.isInheritor((PsiType)fieldType, (String)typeName)) continue;
                substitute = (PsiType)typeMap.get(typeName);
                break;
            }
            if (substitute == null) {
                if (!InheritanceUtil.isInheritor((PsiType)fieldType, (String)"javafx.beans.value.ObservableValue")) {
                    propertyType = JavaFxPsiUtil.eraseFreeTypeParameters(fieldType, (PsiMember)field);
                    return CachedValueProvider.Result.create((Object)propertyType, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
                PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass("javafx.beans.value.ObservableValue", GlobalSearchScope.allScope((Project)project));
                LOG.assertTrue(aClass != null);
                PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aClass, (PsiClass)fieldClass, (PsiSubstitutor)resolveResult.getSubstitutor());
                PsiMethod[] values = aClass.findMethodsByName("getValue", false);
                LOG.assertTrue(values.length == 1);
                substitute = substitutor.substitute(values[0].getReturnType());
            }
            propertyType = JavaFxPsiUtil.eraseFreeTypeParameters(substitute, (PsiMember)field);
            return CachedValueProvider.Result.create((Object)propertyType, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    public static PsiType getWritablePropertyType(@Nullable PsiClass containingClass, @Nullable PsiElement declaration) {
        if (declaration instanceof PsiField) {
            return JavaFxPsiUtil.getWrappedPropertyType((PsiField)declaration, declaration.getProject(), JavaFxCommonNames.ourWritableMap);
        }
        if (declaration instanceof PsiMethod) {
            PsiType setterArgumentType;
            PsiMethod setter;
            PsiClass psiClass;
            PsiMethod method = (PsiMethod)declaration;
            if (!method.getParameterList().isEmpty()) {
                return JavaFxPsiUtil.getSetterArgumentType(method);
            }
            String propertyName = PropertyUtilBase.getPropertyName((PsiMethod)method);
            PsiClass psiClass2 = psiClass = containingClass != null ? containingClass : method.getContainingClass();
            if (propertyName != null && containingClass != null && (setter = JavaFxPsiUtil.findInstancePropertySetter(psiClass, propertyName)) != null && (setterArgumentType = JavaFxPsiUtil.getSetterArgumentType(setter)) != null) {
                return setterArgumentType;
            }
            return JavaFxPsiUtil.getGetterReturnType(method);
        }
        return null;
    }

    @Nullable
    private static PsiType getSetterArgumentType(@NotNull PsiMethod method) {
        if (method == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(29);
        }
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            PsiParameter[] parameters = method.getParameterList().getParameters();
            boolean isStatic = method.hasModifierProperty("static");
            if (isStatic && parameters.length == 2 || !isStatic && parameters.length == 1) {
                PsiType argumentType = JavaFxPsiUtil.eraseFreeTypeParameters(parameters[parameters.length - 1].getType(), (PsiMember)method);
                return CachedValueProvider.Result.create((Object)argumentType, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static PsiType getGetterReturnType(@NotNull PsiMethod method) {
        if (method == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(30);
        }
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            PsiType returnType = JavaFxPsiUtil.eraseFreeTypeParameters(method.getReturnType(), (PsiMember)method);
            return CachedValueProvider.Result.create((Object)returnType, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @Nullable
    public static PsiType getReadablePropertyType(@Nullable PsiElement declaration) {
        PsiMethod psiMethod;
        if (declaration instanceof PsiField) {
            return JavaFxPsiUtil.getWrappedPropertyType((PsiField)declaration, declaration.getProject(), JavaFxCommonNames.ourReadOnlyMap);
        }
        if (declaration instanceof PsiMethod && (psiMethod = (PsiMethod)declaration).getParameterList().isEmpty() && !psiMethod.hasModifierProperty("static")) {
            return JavaFxPsiUtil.getGetterReturnType(psiMethod);
        }
        return null;
    }

    @NotNull
    public static Map<String, XmlAttributeValue> collectFileIds(@Nullable XmlTag currentTag) {
        if (currentTag == null) {
            Map<String, XmlAttributeValue> map = Collections.emptyMap();
            if (map == null) {
                JavaFxPsiUtil.$$$reportNull$$$0(31);
            }
            return map;
        }
        PsiFile containingFile = currentTag.getContainingFile();
        return JavaFxPsiUtil.collectFileIds(containingFile, false);
    }

    @NotNull
    public static Map<String, XmlAttributeValue> collectFileIds(@Nullable PsiFile psiFile, boolean skipController) {
        if (!(psiFile instanceof XmlFile)) {
            Map<String, XmlAttributeValue> map = Collections.emptyMap();
            if (map == null) {
                JavaFxPsiUtil.$$$reportNull$$$0(32);
            }
            return map;
        }
        XmlTag rootTag = ((XmlFile)psiFile).getRootTag();
        if (rootTag == null) {
            Map<String, XmlAttributeValue> map = Collections.emptyMap();
            if (map == null) {
                JavaFxPsiUtil.$$$reportNull$$$0(33);
            }
            return map;
        }
        Map cachedIds = (Map)CachedValuesManager.getCachedValue((PsiElement)rootTag, () -> new CachedValueProvider.Result(JavaFxPsiUtil.prepareFileIds(rootTag), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (skipController && cachedIds.containsKey("controller")) {
            HashMap<String, XmlAttributeValue> filteredIds = new HashMap<String, XmlAttributeValue>(cachedIds);
            filteredIds.remove("controller");
            HashMap<String, XmlAttributeValue> hashMap = filteredIds;
            if (hashMap == null) {
                JavaFxPsiUtil.$$$reportNull$$$0(34);
            }
            return hashMap;
        }
        Map map = cachedIds;
        if (map == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(35);
        }
        return map;
    }

    @NotNull
    private static Map<String, XmlAttributeValue> prepareFileIds(XmlTag rootTag) {
        HashMap<String, XmlAttributeValue> fileIds = new HashMap<String, XmlAttributeValue>();
        for (XmlTag tag : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)rootTag)).filter(XmlTag.class)) {
            String idValue;
            XmlAttribute idAttribute = tag.getAttribute("fx:id");
            if (idAttribute == null || (idValue = idAttribute.getValue()) == null) continue;
            fileIds.put(idValue, idAttribute.getValueElement());
        }
        XmlAttribute controllerAttribute = rootTag.getAttribute("fx:controller");
        if (controllerAttribute != null) {
            fileIds.put("controller", controllerAttribute.getValueElement());
        }
        HashMap<String, XmlAttributeValue> hashMap = fileIds;
        if (hashMap == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(36);
        }
        return hashMap;
    }

    @Nullable
    public static PsiClass getTagClassById(@Nullable XmlAttributeValue xmlAttributeValue, @Nullable String id, @NotNull PsiElement context) {
        if (context == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(37);
        }
        return "controller".equals(id) ? JavaFxPsiUtil.getControllerClass(context.getContainingFile()) : JavaFxPsiUtil.getTagClass(xmlAttributeValue);
    }

    @Nullable
    public static PsiClass getWritablePropertyClass(@Nullable XmlAttributeValue xmlAttributeValue) {
        if (xmlAttributeValue != null) {
            return JavaFxPsiUtil.getPropertyClass(JavaFxPsiUtil.getWritablePropertyType(xmlAttributeValue), (PsiElement)xmlAttributeValue);
        }
        return null;
    }

    @Nullable
    public static PsiType getWritablePropertyType(@Nullable XmlAttributeValue xmlAttributeValue) {
        PsiElement declaration;
        PsiClass tagClass = JavaFxPsiUtil.getTagClass(xmlAttributeValue);
        if (tagClass != null && (declaration = JavaFxPsiUtil.getAttributeDeclaration(xmlAttributeValue)) != null) {
            return JavaFxPsiUtil.getWritablePropertyType(tagClass, declaration);
        }
        return null;
    }

    @Nullable
    public static PsiClass getPropertyClass(@Nullable PsiType propertyType, @NotNull PsiElement context) {
        if (context == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(38);
        }
        if (propertyType instanceof PsiPrimitiveType) {
            PsiClassType boxedType = ((PsiPrimitiveType)propertyType).getBoxedType(context);
            return boxedType != null ? boxedType.resolve() : null;
        }
        return PsiUtil.resolveClassInType((PsiType)propertyType);
    }

    public static boolean hasConversionFromAnyType(@NotNull PsiClass targetClass) {
        if (targetClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(39);
        }
        return Comparing.strEqual((String)targetClass.getQualifiedName(), (String)"java.lang.String") || JavaFxPsiUtil.findValueOfMethod(targetClass) != null;
    }

    @Nullable
    public static String getBoxedPropertyType(@Nullable PsiClass containingClass, @Nullable PsiMember declaration) {
        PsiClass psiClass;
        PsiType psiType = JavaFxPsiUtil.getWritablePropertyType(containingClass, (PsiElement)declaration);
        if (psiType instanceof PsiPrimitiveType) {
            return ((PsiPrimitiveType)psiType).getBoxedTypeName();
        }
        if (PsiPrimitiveType.getUnboxedType((PsiType)psiType) != null && (psiClass = PsiUtil.resolveClassInType((PsiType)psiType)) != null) {
            return psiClass.getQualifiedName();
        }
        return null;
    }

    @Contract(value="null->false")
    public static boolean isPrimitiveOrBoxed(@Nullable PsiType psiType) {
        return psiType instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)psiType) != null;
    }

    @NotNull
    public static Map<String, PsiMember> getReadableProperties(@Nullable PsiClass psiClass) {
        if (psiClass != null) {
            Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create(JavaFxPsiUtil.prepareReadableProperties(psiClass), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
            if (map == null) {
                JavaFxPsiUtil.$$$reportNull$$$0(40);
            }
            return map;
        }
        Map<String, PsiMember> map = Collections.emptyMap();
        if (map == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(41);
        }
        return map;
    }

    @NotNull
    private static Map<String, PsiMember> prepareReadableProperties(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(42);
        }
        HashMap<String, PsiMember> acceptableMembers = new HashMap<String, PsiMember>();
        for (PsiMethod method : psiClass.getAllMethods()) {
            if (method.hasModifierProperty("static") || !method.hasModifierProperty("public") || !PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method)) continue;
            String propertyName = PropertyUtilBase.getPropertyName((PsiMethod)method);
            assert (propertyName != null);
            acceptableMembers.put(propertyName, (PsiMember)method);
        }
        HashMap<String, PsiMember> hashMap = acceptableMembers;
        if (hashMap == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(43);
        }
        return hashMap;
    }

    @NotNull
    public static Map<String, PsiMember> getWritableProperties(@Nullable PsiClass psiClass) {
        if (psiClass != null) {
            Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create(JavaFxPsiUtil.prepareWritableProperties(psiClass), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
            if (map == null) {
                JavaFxPsiUtil.$$$reportNull$$$0(44);
            }
            return map;
        }
        Map<String, PsiMember> map = Collections.emptyMap();
        if (map == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(45);
        }
        return map;
    }

    @NotNull
    private static Map<String, PsiMember> prepareWritableProperties(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(46);
        }
        HashMap<String, PsiMember> acceptableMembers = new HashMap<String, PsiMember>();
        for (String propertyName : JavaFxPsiUtil.prepareConstructorNamedArgProperties(psiClass)) {
            PsiField field;
            if (acceptableMembers.containsKey(propertyName) || (field = psiClass.findFieldByName(propertyName, true)) == null || field.hasModifierProperty("static")) continue;
            acceptableMembers.put(propertyName, (PsiMember)field);
        }
        for (PsiMethod method : psiClass.getAllMethods()) {
            if (method.hasModifierProperty("static") || !method.hasModifierProperty("public") || !PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method)) continue;
            PsiMethod acceptableMember = method;
            String propertyName = PropertyUtilBase.getPropertyName((PsiMethod)method);
            assert (propertyName != null);
            PsiMethod setter = JavaFxPsiUtil.findInstancePropertySetter(psiClass, propertyName);
            if (setter != null) {
                PsiType setterArgType = setter.getParameterList().getParameters()[0].getType();
                field = psiClass.findFieldByName(propertyName, true);
                if (field != null && !field.hasModifierProperty("static") && ((fieldType = JavaFxPsiUtil.getWritablePropertyType(psiClass, (PsiElement)field)) == null || setterArgType.isConvertibleFrom(fieldType))) {
                    acceptableMember = field;
                }
            } else {
                PsiType returnType = method.getReturnType();
                if (returnType != null && JavaFxPsiUtil.isWritablePropertyType(psiClass, returnType)) {
                    field = psiClass.findFieldByName(propertyName, true);
                    if (field != null && !field.hasModifierProperty("static") && ((fieldType = JavaFxPsiUtil.getWritablePropertyType(psiClass, (PsiElement)field)) == null || returnType.isAssignableFrom(fieldType))) {
                        acceptableMember = field;
                    }
                } else {
                    acceptableMember = null;
                }
            }
            if (acceptableMember == null) continue;
            acceptableMembers.put(propertyName, (PsiMember)acceptableMember);
        }
        HashMap<String, PsiMember> hashMap = acceptableMembers;
        if (hashMap == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(47);
        }
        return hashMap;
    }

    @Nullable
    private static String getPropertyNameFromNamedArgAnnotation(@NotNull PsiParameter parameter) {
        Object value;
        PsiAnnotationMemberValue psiValue;
        PsiAnnotation annotation;
        if (parameter == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(48);
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (String[])new String[]{"javafx.beans.NamedArg"})) != null && (psiValue = annotation.findAttributeValue("value")) instanceof PsiLiteralExpression && (value = ((PsiLiteralExpression)psiValue).getValue()) instanceof String) {
            return (String)value;
        }
        return null;
    }

    @NotNull
    public static Set<String> getConstructorNamedArgProperties(@Nullable PsiClass psiClass) {
        if (psiClass != null) {
            Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create(JavaFxPsiUtil.prepareConstructorNamedArgProperties(psiClass), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
            if (set == null) {
                JavaFxPsiUtil.$$$reportNull$$$0(49);
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(50);
        }
        return set;
    }

    @NotNull
    private static Set<String> prepareConstructorNamedArgProperties(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(51);
        }
        HashSet<String> properties = new HashSet<String>();
        for (PsiMethod constructor : psiClass.getConstructors()) {
            PsiParameter[] parameters;
            if (!constructor.hasModifierProperty("public")) continue;
            for (PsiParameter parameter : parameters = constructor.getParameterList().getParameters()) {
                String propertyName = JavaFxPsiUtil.getPropertyNameFromNamedArgAnnotation(parameter);
                if (StringUtil.isEmpty((String)propertyName)) continue;
                properties.add(propertyName);
            }
        }
        HashSet<String> hashSet = properties;
        if (hashSet == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(52);
        }
        return hashSet;
    }

    @Nullable
    public static PsiMethod findInstancePropertySetter(@NotNull PsiClass psiClass, @Nullable String propertyName) {
        PsiMethod[] setters;
        if (psiClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(53);
        }
        if (StringUtil.isEmpty((String)propertyName)) {
            return null;
        }
        String suggestedSetterName = PropertyUtilBase.suggestSetterName((String)propertyName);
        for (PsiMethod setter : setters = psiClass.findMethodsByName(suggestedSetterName, true)) {
            if (!setter.hasModifierProperty("public") || setter.hasModifierProperty("static") || !PropertyUtilBase.isSimplePropertySetter((PsiMethod)setter)) continue;
            return setter;
        }
        return null;
    }

    private static boolean isWritablePropertyType(@NotNull PsiClass psiClass, @NotNull PsiType fieldType) {
        if (psiClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(54);
        }
        if (fieldType == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(55);
        }
        return JavaFxPsiUtil.isObservableCollection(PsiUtil.resolveClassInType((PsiType)fieldType)) && JavaGenericsUtil.getCollectionItemType((PsiType)fieldType, (GlobalSearchScope)psiClass.getResolveScope()) != null || InheritanceUtil.isInheritor((PsiType)fieldType, (String)"javafx.collections.ObservableMap");
    }

    public static boolean isObservableCollection(@Nullable PsiClass psiClass) {
        return psiClass != null && (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"javafx.collections.ObservableList") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"javafx.collections.ObservableSet") || InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"javafx.collections.ObservableArray"));
    }

    @Nullable
    private static PsiSubstitutor getTagClassSubstitutor(@NotNull XmlAttribute xmlAttribute, @NotNull PsiClass controllerClass) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass resolvedClass;
        PsiField tagField;
        String tagFieldName;
        XmlTag xmlTag;
        PsiClass tagClass;
        if (xmlAttribute == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(56);
        }
        if (controllerClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(57);
        }
        if ((tagClass = JavaFxPsiUtil.getTagClass(xmlTag = xmlAttribute.getParent())) != null && !StringUtil.isEmpty((String)(tagFieldName = xmlTag.getAttributeValue("fx:id"))) && (tagField = controllerClass.findFieldByName(tagFieldName, true)) != null && !tagField.hasModifierProperty("static") && JavaFxPsiUtil.isVisibleInFxml((PsiMember)tagField) && (resolvedClass = (resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)tagField.getType())).getElement()) != null) {
            return TypeConversionUtil.getClassSubstitutor((PsiClass)tagClass, (PsiClass)resolvedClass, (PsiSubstitutor)resolveResult.getSubstitutor());
        }
        return null;
    }

    @Nullable
    public static PsiClassType getDeclaredEventType(@NotNull XmlAttribute xmlAttribute) {
        PsiClass controllerClass;
        PsiType eventHandlerPropertyType;
        PsiClass tagClass;
        if (xmlAttribute == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(58);
        }
        if ((tagClass = JavaFxPsiUtil.getTagClass(xmlAttribute.getParent())) != null && (eventHandlerPropertyType = JavaFxPsiUtil.getEventHandlerPropertyType(tagClass, xmlAttribute.getName())) != null && (controllerClass = JavaFxPsiUtil.getControllerClass(xmlAttribute.getContainingFile())) != null) {
            PsiSubstitutor tagClassSubstitutor = JavaFxPsiUtil.getTagClassSubstitutor(xmlAttribute, controllerClass);
            PsiType handlerType = tagClassSubstitutor != null ? tagClassSubstitutor.substitute(eventHandlerPropertyType) : eventHandlerPropertyType;
            PsiClassType eventType = JavaFxPsiUtil.substituteEventType(handlerType, xmlAttribute.getProject());
            PsiType erasedType = JavaFxPsiUtil.eraseFreeTypeParameters((PsiType)eventType, tagClass);
            return erasedType instanceof PsiClassType ? (PsiClassType)erasedType : null;
        }
        return null;
    }

    @Nullable
    private static PsiType getEventHandlerPropertyType(@NotNull PsiClass tagClass, @NotNull String eventName) {
        PsiMethod[] handlerSetterCandidates;
        if (tagClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(59);
        }
        if (eventName == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(60);
        }
        for (PsiMethod handlerSetter : handlerSetterCandidates = tagClass.findMethodsByName(PropertyUtilBase.suggestSetterName((String)eventName), true)) {
            PsiType propertyType;
            if (handlerSetter.hasModifierProperty("static") || !handlerSetter.hasModifierProperty("public") || !InheritanceUtil.isInheritor((PsiType)(propertyType = PropertyUtilBase.getPropertyType((PsiMember)handlerSetter)), (String)"javafx.event.EventHandler")) continue;
            return propertyType;
        }
        PsiField handlerField = tagClass.findFieldByName(eventName, true);
        PsiClassType propertyType = JavaFxPsiUtil.getPropertyClassType((PsiElement)handlerField);
        if (InheritanceUtil.isInheritor((PsiType)propertyType, (String)"javafx.event.EventHandler")) {
            return propertyType;
        }
        return null;
    }

    @Nullable
    private static PsiClassType substituteEventType(@Nullable PsiType eventHandlerType, @NotNull Project project) {
        PsiType boundType;
        if (project == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(61);
        }
        if (!(eventHandlerType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)eventHandlerType).resolveGenerics();
        PsiClass eventHandlerClass = resolveResult.getElement();
        if (eventHandlerClass == null) {
            return null;
        }
        PsiSubstitutor eventHandlerClassSubstitutor = resolveResult.getSubstitutor();
        PsiClass eventHandlerInterface = JavaPsiFacade.getInstance((Project)project).findClass("javafx.event.EventHandler", GlobalSearchScope.allScope((Project)project));
        if (eventHandlerInterface == null) {
            return null;
        }
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)eventHandlerClass, (PsiClass)eventHandlerInterface, (boolean)true)) {
            return null;
        }
        PsiTypeParameter[] typeParameters = eventHandlerInterface.getTypeParameters();
        if (typeParameters.length != 1) {
            return null;
        }
        PsiTypeParameter eventTypeParameter = typeParameters[0];
        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)eventHandlerInterface, (PsiClass)eventHandlerClass, (PsiSubstitutor)eventHandlerClassSubstitutor);
        PsiType eventType = substitutor.substitute(eventTypeParameter);
        if (eventType instanceof PsiClassType) {
            return (PsiClassType)eventType;
        }
        if (eventType instanceof PsiWildcardType && (boundType = ((PsiWildcardType)eventType).getBound()) instanceof PsiClassType) {
            return (PsiClassType)boundType;
        }
        return null;
    }

    @Nullable
    private static PsiClass getFactoryProducedClass(@Nullable PsiClass psiClass, @Nullable String factoryMethodName) {
        PsiMethod[] methods;
        if (psiClass == null || factoryMethodName == null) {
            return null;
        }
        for (PsiMethod method : methods = psiClass.findMethodsByName(factoryMethodName, true)) {
            if (!method.getParameterList().isEmpty() || !method.hasModifierProperty("static")) continue;
            return PsiUtil.resolveClassInClassTypeOnly((PsiType)method.getReturnType());
        }
        return null;
    }

    @Nullable
    @Nls
    public static String validateEnumConstant(@NotNull PsiClass enumClass, @NonNls @Nullable String name) {
        if (enumClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(62);
        }
        if (!enumClass.isEnum() || name == null) {
            return null;
        }
        Set constantNames = (Set)CachedValuesManager.getCachedValue((PsiElement)enumClass, () -> CachedValueProvider.Result.create((Object)Arrays.stream(enumClass.getFields()).filter(PsiEnumConstant.class::isInstance).map(PsiField::getName).map(StringUtil::toUpperCase).collect(Collectors.toCollection(HashSet::new)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (!constantNames.contains(StringUtil.toUpperCase((String)name))) {
            return JavaFXBundle.message("enum.constant.not.found", name, enumClass.getQualifiedName());
        }
        return null;
    }

    @NotNull
    public static String getPropertyName(@NotNull String memberName, boolean isMethod) {
        if (memberName == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(63);
        }
        if (!isMethod) {
            String string = memberName;
            if (string == null) {
                JavaFxPsiUtil.$$$reportNull$$$0(64);
            }
            return string;
        }
        String propertyName = PropertyUtilBase.getPropertyName((String)memberName);
        String string = propertyName != null ? propertyName : memberName;
        if (string == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(65);
        }
        return string;
    }

    @Nullable
    public static PsiClass getTagValueClass(@NotNull XmlTag xmlTag) {
        if (xmlTag == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(66);
        }
        return (PsiClass)JavaFxPsiUtil.getTagValueClass(xmlTag, JavaFxPsiUtil.getTagClass(xmlTag)).getFirst();
    }

    @NotNull
    public static Pair<PsiClass, Boolean> getTagValueClass(@NotNull XmlTag xmlTag, @Nullable PsiClass tagClass) {
        if (xmlTag == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(67);
        }
        if (tagClass != null) {
            XmlAttribute constAttr = xmlTag.getAttribute("fx:constant");
            if (constAttr != null) {
                PsiField constField = tagClass.findFieldByName(constAttr.getValue(), true);
                if (constField != null) {
                    PsiType constType = constField.getType();
                    Pair pair = Pair.create((Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)(constType instanceof PsiPrimitiveType ? ((PsiPrimitiveType)constType).getBoxedType((PsiElement)xmlTag) : constType)), (Object)true);
                    if (pair == null) {
                        JavaFxPsiUtil.$$$reportNull$$$0(68);
                    }
                    return pair;
                }
            } else {
                XmlAttribute factoryAttr = xmlTag.getAttribute("fx:factory");
                if (factoryAttr != null) {
                    Pair pair = Pair.create((Object)JavaFxPsiUtil.getFactoryProducedClass(tagClass, factoryAttr.getValue()), (Object)true);
                    if (pair == null) {
                        JavaFxPsiUtil.$$$reportNull$$$0(69);
                    }
                    return pair;
                }
            }
        }
        Pair pair = Pair.create((Object)tagClass, (Object)false);
        if (pair == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(70);
        }
        return pair;
    }

    public static boolean isControllerClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(71);
        }
        Project project = psiClass.getProject();
        GlobalSearchScope resolveScope = psiClass.getResolveScope();
        if (JavaFxPsiUtil.isControllerClassName(project, psiClass.getQualifiedName(), resolveScope)) {
            return true;
        }
        Ref refFound = new Ref((Object)false);
        ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)resolveScope, (boolean)true, (boolean)true, (boolean)false).forEach(aClass -> {
            if (JavaFxPsiUtil.isControllerClassName(project, aClass.getQualifiedName(), resolveScope)) {
                refFound.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)refFound.get();
    }

    private static boolean isControllerClassName(@NotNull Project project, @Nullable String qualifiedName, @NotNull GlobalSearchScope resolveScope) {
        if (project == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(72);
        }
        if (resolveScope == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(73);
        }
        return qualifiedName != null && !JavaFxControllerClassIndex.findFxmlWithController(project, qualifiedName, resolveScope).isEmpty();
    }

    @Nullable
    private static CachedValueProvider.Result<PsiClass> computeInjectedControllerClass(PsiFile containingFile) {
        return (CachedValueProvider.Result)RecursionManager.doPreventingRecursion((Object)containingFile, (boolean)true, () -> {
            PsiMethod[] injectControllerMethods;
            Project project = containingFile.getProject();
            Ref injectedController = new Ref();
            PsiClass fxmlLoader = JavaPsiFacade.getInstance((Project)project).findClass("javafx.fxml.FXMLLoader", GlobalSearchScope.allScope((Project)project));
            if (fxmlLoader != null && (injectControllerMethods = fxmlLoader.findMethodsByName("setController", false)).length == 1) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)containingFile.getResolveScope(), (FileType[])new FileType[]{JavaFileType.INSTANCE});
                VirtualFile[] virtualFiles = CacheManager.getInstance((Project)project).getVirtualFilesWithWord(ClassUtil.extractClassName((String)"javafx.fxml.FXMLLoader"), (short)1, globalSearchScope, true);
                if (virtualFiles.length == 0) {
                    return new CachedValueProvider.Result(null, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
                GlobalSearchScope filesScope = GlobalSearchScope.filesScope((Project)project, Arrays.asList(virtualFiles));
                Processor processor = loaderReference -> JavaFxPsiUtil.findControllerClassInjection(loaderReference, (Ref<? super PsiClass>)injectedController, injectControllerMethods[0]);
                ReferencesSearch.search((PsiElement)containingFile, (SearchScope)filesScope).forEach(reference -> {
                    PsiElement parent;
                    PsiType type;
                    PsiNewExpression expression;
                    PsiElement element = reference.getElement();
                    if (element instanceof PsiLiteralExpression && (expression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class)) != null && (type = expression.getType()) != null && type.equalsToText("javafx.fxml.FXMLLoader") && (parent = expression.getParent()) instanceof PsiLocalVariable) {
                        ReferencesSearch.search((PsiElement)parent).forEach(processor);
                        PsiClass controller = (PsiClass)injectedController.get();
                        if (controller != null) {
                            return false;
                        }
                    }
                    return true;
                });
            }
            return new CachedValueProvider.Result((Object)((PsiClass)injectedController.get()), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static boolean findControllerClassInjection(@NotNull PsiReference loaderReference, @NotNull Ref<? super PsiClass> injectedController, PsiMethod injectControllerMethod) {
        PsiClass psiClass;
        PsiExpression[] expressions;
        PsiMethodCallExpression methodCallExpression;
        PsiElement element;
        if (loaderReference == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(74);
        }
        if (injectedController == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(75);
        }
        if ((element = loaderReference.getElement()) instanceof PsiReferenceExpression && (methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class)) != null && methodCallExpression.resolveMethod() == injectControllerMethod && (expressions = methodCallExpression.getArgumentList().getExpressions()).length > 0 && (psiClass = PsiUtil.resolveClassInType((PsiType)expressions[0].getType())) != null) {
            injectedController.set((Object)psiClass);
            return false;
        }
        return true;
    }

    public static boolean isJavaFxPackageImported(@NotNull PsiFile file) {
        if (file == null) {
            JavaFxPsiUtil.$$$reportNull$$$0(76);
        }
        return file instanceof PsiJavaFile && (Boolean)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            PsiImportList importList = ((PsiJavaFile)file).getImportList();
            boolean javafx = importList != null && ContainerUtil.exists((Object[])importList.getAllImportStatements(), s -> {
                PsiJavaCodeReferenceElement ref = s.getImportReference();
                String qualifiedName = ref != null ? ref.getQualifiedName() : null;
                return qualifiedName != null && qualifiedName.startsWith("javafx.") && ref.resolve() != null;
            });
            return CachedValueProvider.Result.create((Object)javafx, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }) != false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 31, 32, 33, 34, 35, 36, 40, 41, 43, 44, 45, 47, 49, 50, 52, 64, 65, 68, 69, 70 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 42: 
            case 46: 
            case 51: 
            case 53: 
            case 54: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 7: 
            case 61: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageConsumer";
                break;
            }
            case 15: 
            case 20: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromClass";
                break;
            }
            case 16: 
            case 21: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 19: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlAttribute";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controllerClass";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagClass";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventName";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumClass";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlTag";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaderReference";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedController";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/JavaFxPsiUtil";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFileIds";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareFileIds";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableProperties";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareReadableProperties";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getWritableProperties";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareWritableProperties";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorNamedArgProperties";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareConstructorNamedArgProperties";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyName";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagValueClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findStaticPropertySetter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyGetter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findObservablePropertyGetter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEventHandlerProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isVisibleInFxml";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findValueOfMethod";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getWritablePropertyType";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAbleToInstantiate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasNamedArgOrNoArgConstructor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasBuilder";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isClassAcceptable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "noDefaultPropertyError";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "canCoerce";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "eraseFreeTypeParameters";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "canCoerceImpl";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "unableToCoerceError";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "unrelatedTypesWarning";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getSetterArgumentType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getGetterReturnType";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 52: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: {
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getTagClassById";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyClass";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "hasConversionFromAnyType";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "prepareReadableProperties";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "prepareWritableProperties";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNameFromNamedArgAnnotation";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "prepareConstructorNamedArgProperties";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findInstancePropertySetter";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isWritablePropertyType";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getTagClassSubstitutor";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredEventType";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getEventHandlerPropertyType";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "substituteEventType";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "validateEnumConstant";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getTagValueClass";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isControllerClass";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isControllerClassName";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "findControllerClassInjection";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isJavaFxPackageImported";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 31, 32, 33, 34, 35, 36, 40, 41, 43, 44, 45, 47, 49, 50, 52, 64, 65, 68, 69, 70 -> new IllegalStateException(string);
        };
    }
}

