/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.juife.wizard.UserInputPage;
import org.jsampler.CC;
import org.jsampler.MidiDeviceModel;
import org.jsampler.event.MidiDeviceListEvent;
import org.jsampler.event.MidiDeviceListListener;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.std.JSNewMidiDeviceDlg;
import org.linuxsampler.lscp.MidiInputDevice;

class MidiDeviceWizardPage
extends UserInputPage {
    private final JLabel lDevice = new JLabel(ClassicI18n.i18n.getLabel("MidiDeviceWizardPage.lDevice"));
    private final JComboBox cbDevices = new JComboBox();
    private final JButton btnNewDevice = new JButton(ClassicI18n.i18n.getButtonLabel("MidiDeviceWizardPage.btnNewDevice"));
    private final JRadioButton rbDefaultSettings = new JRadioButton(ClassicI18n.i18n.getButtonLabel("MidiDeviceWizardPage.rbDefaultSettings"));
    private final JRadioButton rbCustomSettings = new JRadioButton(ClassicI18n.i18n.getButtonLabel("MidiDeviceWizardPage.rbCustomSettings"));
    private final Handler handler = new Handler();

    MidiDeviceWizardPage() {
        super(ClassicI18n.i18n.getLabel("MidiDeviceWizardPage.subtitle"));
        this.setMainInstructions(ClassicI18n.i18n.getLabel("MidiDeviceWizardPage.mainInstructions"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.lDevice);
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        for (MidiDeviceModel midiDeviceModel : CC.getSamplerModel().getMidiDevices()) {
            this.cbDevices.addItem(midiDeviceModel.getDeviceInfo());
        }
        this.cbDevices.setMaximumSize(this.cbDevices.getPreferredSize());
        if (this.cbDevices.getItemCount() == 0) {
            this.enableDevComp(false);
        }
        jPanel.add(this.cbDevices);
        CC.getSamplerModel().addMidiDeviceListListener(this.getHandler());
        jPanel.add(Box.createRigidArea(new Dimension(12, 0)));
        jPanel.add(this.btnNewDevice);
        jPanel.setAlignmentX(0.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(jPanel);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 6)));
        this.rbDefaultSettings.setAlignmentX(0.0f);
        jPanel2.add(this.rbDefaultSettings);
        this.rbCustomSettings.setAlignmentX(0.0f);
        jPanel2.add(this.rbCustomSettings);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbDefaultSettings);
        buttonGroup.add(this.rbCustomSettings);
        this.rbDefaultSettings.setSelected(true);
        this.setMainPane(jPanel2);
        this.btnNewDevice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new JSNewMidiDeviceDlg(MidiDeviceWizardPage.this.getWizardDialog()).setVisible(true);
            }
        });
    }

    public MidiInputDevice getSelectedDevice() {
        return (MidiInputDevice)this.cbDevices.getSelectedItem();
    }

    private void enableDevComp(boolean bl) {
        this.cbDevices.setEnabled(bl);
        this.rbDefaultSettings.setEnabled(bl);
        this.rbCustomSettings.setEnabled(bl);
    }

    public boolean getCustomSettings() {
        return this.rbCustomSettings.isSelected();
    }

    private Handler getHandler() {
        return this.handler;
    }

    private class Handler
    implements MidiDeviceListListener {
        private Handler() {
        }

        @Override
        public void deviceAdded(MidiDeviceListEvent midiDeviceListEvent) {
            this.updateDeviceList(midiDeviceListEvent.getMidiDeviceModel().getDeviceInfo());
        }

        @Override
        public void deviceRemoved(MidiDeviceListEvent midiDeviceListEvent) {
            this.updateDeviceList(null);
        }

        private void updateDeviceList(MidiInputDevice midiInputDevice) {
            MidiDeviceWizardPage.this.cbDevices.removeAllItems();
            for (MidiDeviceModel midiDeviceModel : CC.getSamplerModel().getMidiDevices()) {
                MidiDeviceWizardPage.this.cbDevices.addItem(midiDeviceModel.getDeviceInfo());
            }
            if (MidiDeviceWizardPage.this.cbDevices.getItemCount() == 0) {
                MidiDeviceWizardPage.this.enableDevComp(false);
            } else {
                MidiDeviceWizardPage.this.enableDevComp(true);
                MidiDeviceWizardPage.this.cbDevices.setSelectedItem(midiInputDevice);
            }
            MidiDeviceWizardPage.this.cbDevices.setMaximumSize(MidiDeviceWizardPage.this.cbDevices.getPreferredSize());
        }
    }
}

