/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.metrics;

import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.metrics.stats.WindowedCount;

public class OffsetCommitMetricsManager {
    final MetricName commitLatencyAvg;
    final MetricName commitLatencyMax;
    final MetricName commitRate;
    final MetricName commitTotal;
    private final Sensor commitSensor;

    public OffsetCommitMetricsManager(Metrics metrics) {
        String metricGroupName = "consumer-coordinator-metrics";
        this.commitSensor = metrics.sensor("commit-latency");
        this.commitLatencyAvg = metrics.metricName("commit-latency-avg", "consumer-coordinator-metrics", "The average time taken for a commit request");
        this.commitSensor.add(this.commitLatencyAvg, new Avg());
        this.commitLatencyMax = metrics.metricName("commit-latency-max", "consumer-coordinator-metrics", "The max time taken for a commit request");
        this.commitSensor.add(this.commitLatencyMax, new Max());
        this.commitRate = metrics.metricName("commit-rate", "consumer-coordinator-metrics", "The number of commit calls per second");
        this.commitTotal = metrics.metricName("commit-total", "consumer-coordinator-metrics", "The total number of commit calls");
        this.commitSensor.add(new Meter(new WindowedCount(), this.commitRate, this.commitTotal));
    }

    public void recordRequestLatency(long responseLatencyMs) {
        this.commitSensor.record(responseLatencyMs);
    }
}

