/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

public class LogSegmentData {
    private final Path logSegment;
    private final Path offsetIndex;
    private final Path timeIndex;
    private final Optional<Path> transactionIndex;
    private final Path producerSnapshotIndex;
    private final ByteBuffer leaderEpochIndex;

    public LogSegmentData(Path logSegment, Path offsetIndex, Path timeIndex, Optional<Path> transactionIndex, Path producerSnapshotIndex, ByteBuffer leaderEpochIndex) {
        this.logSegment = Objects.requireNonNull(logSegment, "logSegment can not be null");
        this.offsetIndex = Objects.requireNonNull(offsetIndex, "offsetIndex can not be null");
        this.timeIndex = Objects.requireNonNull(timeIndex, "timeIndex can not be null");
        this.transactionIndex = Objects.requireNonNull(transactionIndex, "transactionIndex can not be null");
        this.producerSnapshotIndex = Objects.requireNonNull(producerSnapshotIndex, "producerSnapshotIndex can not be null");
        this.leaderEpochIndex = Objects.requireNonNull(leaderEpochIndex, "leaderEpochIndex can not be null");
    }

    public Path logSegment() {
        return this.logSegment;
    }

    public Path offsetIndex() {
        return this.offsetIndex;
    }

    public Path timeIndex() {
        return this.timeIndex;
    }

    public Optional<Path> transactionIndex() {
        return this.transactionIndex;
    }

    public Path producerSnapshotIndex() {
        return this.producerSnapshotIndex;
    }

    public ByteBuffer leaderEpochIndex() {
        return this.leaderEpochIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogSegmentData that = (LogSegmentData)o;
        return Objects.equals(this.logSegment, that.logSegment) && Objects.equals(this.offsetIndex, that.offsetIndex) && Objects.equals(this.timeIndex, that.timeIndex) && Objects.equals(this.transactionIndex, that.transactionIndex) && Objects.equals(this.producerSnapshotIndex, that.producerSnapshotIndex) && Objects.equals(this.leaderEpochIndex, that.leaderEpochIndex);
    }

    public int hashCode() {
        return Objects.hash(this.logSegment, this.offsetIndex, this.timeIndex, this.transactionIndex, this.producerSnapshotIndex, this.leaderEpochIndex);
    }

    public String toString() {
        return "LogSegmentData{logSegment=" + String.valueOf(this.logSegment) + ", offsetIndex=" + String.valueOf(this.offsetIndex) + ", timeIndex=" + String.valueOf(this.timeIndex) + ", txnIndex=" + String.valueOf(this.transactionIndex) + ", producerSnapshotIndex=" + String.valueOf(this.producerSnapshotIndex) + ", leaderEpochIndex=" + String.valueOf(this.leaderEpochIndex) + "}";
    }
}

