"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppserviceHttpError = void 0;
/**
 * Represents an HTTP error from the Appservice.
 * @category Error handling
 */
class AppserviceHttpError extends Error {
    body;
    status;
    /**
     * The Matrix error code
     */
    errcode;
    /**
     * Optional human-readable error message.
     */
    error;
    /**
     * Creates a new Appservice HTTP error
     * @param body The error body.
     * @param status The HTTP status code.
     */
    constructor(body, status) {
        super();
        this.body = body;
        this.status = status;
        this.errcode = body.errcode;
        this.error = body.error;
    }
    /**
     * Developer-friendly error message.
     */
    get message() {
        return `${this.errcode}: ${this.error}`;
    }
}
exports.AppserviceHttpError = AppserviceHttpError;
//# sourceMappingURL=AppserviceHttpError.js.map