/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm.tracker;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.tasks.TaskResourceTrackingService;
import org.opensearch.wlm.ResourceType;
import org.opensearch.wlm.WorkloadGroupLevelResourceUsageView;
import org.opensearch.wlm.WorkloadGroupTask;

public class WorkloadGroupResourceUsageTrackerService {
    public static final EnumSet<ResourceType> TRACKED_RESOURCES = EnumSet.allOf(ResourceType.class);
    private final TaskResourceTrackingService taskResourceTrackingService;

    public WorkloadGroupResourceUsageTrackerService(TaskResourceTrackingService taskResourceTrackingService) {
        this.taskResourceTrackingService = taskResourceTrackingService;
    }

    public Map<String, WorkloadGroupLevelResourceUsageView> constructWorkloadGroupLevelUsageViews() {
        Map<String, List<WorkloadGroupTask>> tasksByWorkloadGroup = this.getTasksGroupedByWorkloadGroup();
        HashMap<String, WorkloadGroupLevelResourceUsageView> workloadGroupViews = new HashMap<String, WorkloadGroupLevelResourceUsageView>();
        for (Map.Entry<String, List<WorkloadGroupTask>> workloadGroupEntry : tasksByWorkloadGroup.entrySet()) {
            this.taskResourceTrackingService.refreshResourceStats(workloadGroupEntry.getValue().toArray(new WorkloadGroupTask[0]));
            EnumMap<ResourceType, Double> workloadGroupUsage = new EnumMap<ResourceType, Double>(ResourceType.class);
            for (ResourceType resourceType : TRACKED_RESOURCES) {
                double usage = resourceType.getResourceUsageCalculator().calculateResourceUsage(workloadGroupEntry.getValue());
                workloadGroupUsage.put(resourceType, usage);
            }
            workloadGroupViews.put(workloadGroupEntry.getKey(), new WorkloadGroupLevelResourceUsageView(workloadGroupUsage, workloadGroupEntry.getValue()));
        }
        return workloadGroupViews;
    }

    private Map<String, List<WorkloadGroupTask>> getTasksGroupedByWorkloadGroup() {
        return this.taskResourceTrackingService.getResourceAwareTasks().values().stream().filter(WorkloadGroupTask.class::isInstance).map(WorkloadGroupTask.class::cast).filter(WorkloadGroupTask::isWorkloadGroupSet).collect(Collectors.groupingBy(WorkloadGroupTask::getWorkloadGroupId, Collectors.mapping(task -> task, Collectors.toList())));
    }
}

