"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.zeppelinURL = exports.wreckOptions = exports.OPENSEARCH_NOTEBOOKS_API = exports.NOTEBOOKS_FETCH_SIZE = exports.NOTEBOOKS_DOCUMENTATION_URL = exports.NOTEBOOKS_API_PREFIX = exports.CREATE_NOTE_MESSAGE = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const NOTEBOOKS_API_PREFIX = exports.NOTEBOOKS_API_PREFIX = '/api/observability/notebooks';
const NOTEBOOKS_FETCH_SIZE = exports.NOTEBOOKS_FETCH_SIZE = 1000;
const CREATE_NOTE_MESSAGE = exports.CREATE_NOTE_MESSAGE = 'Enter a name to describe the purpose of this notebook.';
const NOTEBOOKS_DOCUMENTATION_URL = exports.NOTEBOOKS_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/observability-plugin/notebooks/';
const zeppelinURL = exports.zeppelinURL = 'http://localhost:8080';
const wreckOptions = exports.wreckOptions = {
  baseUrl: zeppelinURL,
  headers: {
    'Content-Type': 'application/json'
  }
};
const BASE_NOTEBOOKS_URI = '/_plugins/_notebooks';
const OPENSEARCH_NOTEBOOKS_API = exports.OPENSEARCH_NOTEBOOKS_API = {
  GET_NOTEBOOKS: `${BASE_NOTEBOOKS_URI}/notebooks`,
  NOTEBOOK: `${BASE_NOTEBOOKS_URI}/notebook`
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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