/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.knn.plugin.transport.GetModelRequest;
import org.opensearch.knn.plugin.transport.GetModelResponse;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetModelTransportAction
extends HandledTransportAction<GetModelRequest, GetModelResponse> {
    private static final Logger LOG = LogManager.getLogger(GetModelTransportAction.class);
    private ModelDao modelDao = ModelDao.OpenSearchKNNModelDao.getInstance();

    @Inject
    public GetModelTransportAction(TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/knn_get_model_action", transportService, actionFilters, GetModelRequest::new);
    }

    protected void doExecute(Task task, GetModelRequest request, ActionListener<GetModelResponse> actionListener) {
        String modelID = request.getModelID();
        this.modelDao.get(modelID, actionListener);
    }
}

