/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.nodes.NodesInfoResponse;
import org.opensearch.client.opensearch.nodes.info.NodesInfoMetric;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class NodesInfoRequest
extends RequestBase
implements ToCopyableBuilder<Builder, NodesInfoRequest> {
    @Nullable
    private final Boolean flatSettings;
    @Nonnull
    private final List<NodesInfoMetric> metric;
    @Nonnull
    private final List<String> nodeId;
    @Nullable
    private final Time timeout;
    public static final Endpoint<NodesInfoRequest, NodesInfoResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<NodesInfoRequest, NodesInfoResponse>(request -> "GET", request -> {
        boolean _metric = true;
        int _nodeId = 2;
        int propsSet = 0;
        if (ApiTypeHelper.isDefined(request.metric())) {
            propsSet |= 1;
        }
        if (ApiTypeHelper.isDefined(request.nodeId())) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            return "/_nodes";
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.nodeId), buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.nodeId), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, NodesInfoResponse._DESERIALIZER);

    private NodesInfoRequest(Builder builder) {
        super(builder);
        this.flatSettings = builder.flatSettings;
        this.metric = ApiTypeHelper.unmodifiable(builder.metric);
        this.nodeId = ApiTypeHelper.unmodifiable(builder.nodeId);
        this.timeout = builder.timeout;
    }

    public static NodesInfoRequest of(Function<Builder, ObjectBuilder<NodesInfoRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean flatSettings() {
        return this.flatSettings;
    }

    @Nonnull
    public final List<NodesInfoMetric> metric() {
        return this.metric;
    }

    @Nonnull
    public final List<String> nodeId() {
        return this.nodeId;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.flatSettings != null) {
            params.put("flat_settings", String.valueOf(this.flatSettings));
        }
        if (this.timeout != null) {
            params.put("timeout", this.timeout._toJsonString());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.flatSettings);
        result = 31 * result + Objects.hashCode(this.metric);
        result = 31 * result + Objects.hashCode(this.nodeId);
        result = 31 * result + Objects.hashCode(this.timeout);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodesInfoRequest other = (NodesInfoRequest)o;
        return Objects.equals(this.flatSettings, other.flatSettings) && Objects.equals(this.metric, other.metric) && Objects.equals(this.nodeId, other.nodeId) && Objects.equals(this.timeout, other.timeout);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, NodesInfoRequest> {
        @Nullable
        private Boolean flatSettings;
        @Nullable
        private List<NodesInfoMetric> metric;
        @Nullable
        private List<String> nodeId;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(NodesInfoRequest o) {
            super(o);
            this.flatSettings = o.flatSettings;
            this.metric = Builder._listCopy(o.metric);
            this.nodeId = Builder._listCopy(o.nodeId);
            this.timeout = o.timeout;
        }

        private Builder(Builder o) {
            super(o);
            this.flatSettings = o.flatSettings;
            this.metric = Builder._listCopy(o.metric);
            this.nodeId = Builder._listCopy(o.nodeId);
            this.timeout = o.timeout;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder flatSettings(@Nullable Boolean value) {
            this.flatSettings = value;
            return this;
        }

        @Nonnull
        public final Builder metric(List<NodesInfoMetric> list) {
            this.metric = Builder._listAddAll(this.metric, list);
            return this;
        }

        @Nonnull
        public final Builder metric(NodesInfoMetric value, NodesInfoMetric ... values) {
            this.metric = Builder._listAdd(this.metric, value, values);
            return this;
        }

        @Nonnull
        public final Builder nodeId(List<String> list) {
            this.nodeId = Builder._listAddAll(this.nodeId, list);
            return this;
        }

        @Nonnull
        public final Builder nodeId(String value, String ... values) {
            this.nodeId = Builder._listAdd(this.nodeId, value, values);
            return this;
        }

        @Nonnull
        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        @Nonnull
        public NodesInfoRequest build() {
            this._checkSingleUse();
            return new NodesInfoRequest(this);
        }
    }
}

