/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.JsonbException;
import jakarta.json.bind.adapter.JsonbAdapter;
import jakarta.json.bind.serializer.JsonbSerializer;
import jakarta.json.bind.serializer.SerializationContext;
import jakarta.json.stream.JsonGenerator;
import java.lang.reflect.Type;
import org.eclipse.yasson.internal.Marshaller;
import org.eclipse.yasson.internal.ProcessingContext;
import org.eclipse.yasson.internal.components.AdapterBinding;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.JsonbPropertyInfo;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.ContainerSerializerProvider;
import org.eclipse.yasson.internal.serializer.CurrentItem;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;

public class AdaptedObjectSerializer<T, A>
implements CurrentItem<T>,
JsonbSerializer<T> {
    private final ClassModel classModel;
    private final AdapterBinding adapterInfo;

    public AdaptedObjectSerializer(ClassModel classModel, AdapterBinding adapter) {
        this.classModel = classModel;
        this.adapterInfo = adapter;
    }

    public void serialize(T obj, JsonGenerator generator, SerializationContext ctx) {
        block8: {
            ProcessingContext context = (ProcessingContext)ctx;
            try {
                if (context.addProcessedObject(obj)) {
                    JsonbAdapter<?, ?> adapter = this.adapterInfo.getAdapter();
                    Object adapted = adapter.adaptToJson(obj);
                    if (adapted == null) {
                        generator.writeNull();
                        return;
                    }
                    JsonbSerializer<Object> serializer = this.resolveSerializer((Marshaller)ctx, adapted);
                    serializer.serialize(adapted, generator, ctx);
                    break block8;
                }
                throw new JsonbException(Messages.getMessage(MessageKeys.RECURSIVE_REFERENCE, obj.getClass()));
            }
            catch (Exception e) {
                throw new JsonbException(Messages.getMessage(MessageKeys.ADAPTER_EXCEPTION, this.adapterInfo.getBindingType(), this.adapterInfo.getToType(), this.adapterInfo.getAdapter().getClass()), (Throwable)e);
            }
            finally {
                context.removeProcessedObject(obj);
            }
        }
    }

    private JsonbSerializer<A> resolveSerializer(Marshaller ctx, A adapted) {
        ContainerSerializerProvider cached = ctx.getMappingContext().getSerializerProvider(adapted.getClass());
        if (cached != null) {
            return cached.provideSerializer(new JsonbPropertyInfo().withWrapper(this).withRuntimeType(this.classModel == null ? null : this.classModel.getType()));
        }
        return ((SerializerBuilder)((SerializerBuilder)new SerializerBuilder(ctx.getJsonbContext()).withObjectClass(adapted.getClass()).withCustomization(this.classModel == null ? null : this.classModel.getClassCustomization())).withWrapper(this)).build();
    }

    @Override
    public ClassModel getClassModel() {
        return null;
    }

    @Override
    public CurrentItem<?> getWrapper() {
        return null;
    }

    @Override
    public Type getRuntimeType() {
        return null;
    }
}

