/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.internal.ExtendedDigest;
import org.bouncycastle.crypto.util.dispose.NativeDisposer;
import org.bouncycastle.crypto.util.dispose.NativeReference;
import org.bouncycastle.util.Memoable;

class SHA256NativeDigest
implements ExtendedDigest,
Memoable {
    protected DigestRefWrapper nativeRef = new DigestRefWrapper(SHA256NativeDigest.makeNative());

    SHA256NativeDigest() {
        this.reset();
    }

    SHA256NativeDigest(SHA256NativeDigest sHA256NativeDigest) {
        this();
        byte[] byArray = sHA256NativeDigest.getEncodedState();
        SHA256NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, 0);
    }

    SHA256NativeDigest restoreState(byte[] byArray, int n) {
        SHA256NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, n);
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-256";
    }

    @Override
    public int getDigestSize() {
        return SHA256NativeDigest.getDigestSize(this.nativeRef.getReference());
    }

    @Override
    public void update(byte by) {
        SHA256NativeDigest.update(this.nativeRef.getReference(), by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        SHA256NativeDigest.update(this.nativeRef.getReference(), byArray, n, n2);
    }

    @Override
    public int doFinal(byte[] byArray, int n) {
        return SHA256NativeDigest.doFinal(this.nativeRef.getReference(), byArray, n);
    }

    @Override
    public void reset() {
        SHA256NativeDigest.reset(this.nativeRef.getReference());
    }

    @Override
    public int getByteLength() {
        return SHA256NativeDigest.getByteLength(this.nativeRef.getReference());
    }

    @Override
    public Memoable copy() {
        return new SHA256NativeDigest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        SHA256NativeDigest sHA256NativeDigest = (SHA256NativeDigest)memoable;
        SHA256NativeDigest.restoreFullState(this.nativeRef.getReference(), sHA256NativeDigest.getEncodedState(), 0);
    }

    public byte[] getEncodedState() {
        int n = SHA256NativeDigest.encodeFullState(this.nativeRef.getReference(), null, 0);
        byte[] byArray = new byte[n];
        SHA256NativeDigest.encodeFullState(this.nativeRef.getReference(), byArray, 0);
        return byArray;
    }

    void restoreFullState(byte[] byArray, int n) {
        SHA256NativeDigest.restoreFullState(this.nativeRef.getReference(), byArray, n);
    }

    public String toString() {
        return "SHA256[Native]()";
    }

    static native long makeNative();

    static native void destroy(long var0);

    static native int getDigestSize(long var0);

    static native void update(long var0, byte var2);

    static native void update(long var0, byte[] var2, int var3, int var4);

    static native int doFinal(long var0, byte[] var2, int var3);

    static native void reset(long var0);

    static native int getByteLength(long var0);

    static native int encodeFullState(long var0, byte[] var2, int var3);

    static native void restoreFullState(long var0, byte[] var2, int var3);

    private static class DigestRefWrapper
    extends NativeReference {
        public DigestRefWrapper(long l) {
            super(l);
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    private static class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            SHA256NativeDigest.destroy(l);
        }
    }
}

