/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.datagrid.CsvReader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import dk.brics.automaton.SpecialOperations;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvLexer {
    public static final int MAX_CHARACTERS = 0x500000;
    private CsvReader myReader;
    private CsvRecordFormat myCsvFormat;
    private TokenType myType;
    private long myStart;
    private long myEnd;
    private long myOffset;
    private long myTokenLine;
    private String myText;
    private long myEndOffset;
    private long myTokenEndLine;
    private State myState;
    private RunAutomaton myQuotedAutomaton;
    private RunAutomaton myValueAutomaton;
    private RunAutomaton mySeparatorRewindAutomaton;
    private int myMaxSeparatorRewind;

    public CsvLexer(@NotNull CsvReader reader) {
        if (reader == null) {
            CsvLexer.$$$reportNull$$$0(0);
        }
        this.reset(reader);
    }

    public void reset(@NotNull CsvReader reader) {
        if (reader == null) {
            CsvLexer.$$$reportNull$$$0(1);
        }
        this.myState = State.RECORD_START;
        this.myReader = reader;
    }

    public void setCsvFormat(@NotNull CsvRecordFormat csvFormat) {
        if (csvFormat == null) {
            CsvLexer.$$$reportNull$$$0(2);
        }
        this.myCsvFormat = csvFormat;
        this.buildAutomatons();
    }

    private void buildAutomatons() {
        this.myQuotedAutomaton = this.buildQuotationAutomaton();
        this.myValueAutomaton = this.buildValueAutomaton();
        this.mySeparatorRewindAutomaton = this.buildSeparatorRewindAutomaton();
        this.myMaxSeparatorRewind = Math.max(this.myCsvFormat.recordSeparator.length() + this.myCsvFormat.suffix.length(), this.myCsvFormat.valueSeparator.length());
    }

    @Nullable
    private RunAutomaton buildQuotationAutomaton() {
        StringBuilder pattern = new StringBuilder();
        CsvLexer.appendQuotesValuePattern(pattern, this.myCsvFormat.quotes);
        if (!pattern.isEmpty()) {
            CsvLexer.appendValueEndLookahead(pattern, this.myCsvFormat);
            return CsvLexer.buildRunAutomaton(pattern);
        }
        return null;
    }

    @Nullable
    private RunAutomaton buildSeparatorRewindAutomaton() {
        StringBuilder pattern = new StringBuilder();
        if (!CsvLexer.appendSeparatorPattern(pattern, this.myCsvFormat).isEmpty()) {
            Automaton automaton = CsvLexer.buildAutomaton(pattern);
            SpecialOperations.reverse((Automaton)automaton);
            return new RunAutomaton(automaton);
        }
        return null;
    }

    @NotNull
    private RunAutomaton buildValueAutomaton() {
        StringBuilder pattern = new StringBuilder(".*");
        CsvLexer.appendValueEndLookahead(pattern, this.myCsvFormat);
        return CsvLexer.buildRunAutomaton(pattern);
    }

    @NotNull
    public CsvRecordFormat getCsvFormat() {
        CsvRecordFormat csvRecordFormat = this.myCsvFormat;
        if (csvRecordFormat == null) {
            CsvLexer.$$$reportNull$$$0(3);
        }
        return csvRecordFormat;
    }

    @NotNull
    private static RunAutomaton buildRunAutomaton(StringBuilder builder) {
        return new RunAutomaton(CsvLexer.buildAutomaton(builder));
    }

    private static Automaton buildAutomaton(StringBuilder builder) {
        return new RegExp(builder.toString()).toAutomaton();
    }

    public static StringBuilder appendQuotesValuePattern(StringBuilder res, List<CsvRecordFormat.Quotes> quotes) {
        res.append("(");
        boolean first = true;
        for (CsvRecordFormat.Quotes quote : quotes) {
            if (quote.leftQuote.isEmpty() || quote.rightQuote.isEmpty()) continue;
            if (!first) {
                res.append("|");
            } else {
                first = false;
            }
            CsvLexer.appendQuoteValuePattern(res, quote);
        }
        res.append(")");
        return res;
    }

    private static void appendValueEndLookahead(StringBuilder res, CsvRecordFormat format) {
        if (format.recordSeparator.isEmpty() && format.valueSeparator.isEmpty() && format.suffix.isEmpty()) {
            res.append("\u0000");
            return;
        }
        res.append("(");
        CsvLexer.appendSeparatorPattern(res, format);
        res.append(")");
    }

    private static StringBuilder appendSeparatorPattern(StringBuilder res, CsvRecordFormat format) {
        if (format.recordSeparator.isEmpty() && format.valueSeparator.isEmpty() && format.suffix.isEmpty()) {
            return res;
        }
        res.append("\u0000");
        CharSequence rec = CsvLexer.bricsEscape(format.recordSeparator);
        if (!rec.isEmpty()) {
            res.append("|").append(rec).append("\u0000?");
        }
        if (!format.valueSeparator.isEmpty()) {
            res.append("|").append(CsvLexer.bricsEscape(format.valueSeparator)).append("\u0000?");
        }
        if (!format.suffix.isEmpty()) {
            res.append("|").append(CsvLexer.bricsEscape(format.suffix));
            if (!rec.isEmpty()) {
                res.append("(\u0000|").append(rec).append("\u0000?").append(")");
            }
        }
        return res;
    }

    private static void appendQuoteValuePattern(StringBuilder res, CsvRecordFormat.Quotes quote) {
        CharSequence el = CsvLexer.bricsEscape(quote.leftQuote);
        CharSequence er = CsvLexer.bricsEscape(quote.rightQuote);
        CharSequence eer = CsvLexer.bricsEscape(quote.rightQuoteEscaped);
        res.append(el);
        res.append('(').append(eer).append("|.&~(").append(er).append("))*");
        res.append(er);
    }

    @NotNull
    private static CharSequence bricsEscape(String text) {
        if (text.isEmpty()) {
            String string = text;
            if (string == null) {
                CsvLexer.$$$reportNull$$$0(4);
            }
            return string;
        }
        StringBuilder r = new StringBuilder();
        boolean opened = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\"') {
                if (opened) {
                    r.append('\"');
                    opened = false;
                }
                r.append('\\');
            } else if (!opened) {
                opened = true;
                r.append('\"');
            }
            r.append(c);
        }
        if (opened) {
            r.append('\"');
        }
        StringBuilder stringBuilder = r;
        if (stringBuilder == null) {
            CsvLexer.$$$reportNull$$$0(5);
        }
        return stringBuilder;
    }

    public void advance() throws IOException {
        if (!this.myReader.isReady()) {
            this.myState.end(this);
            this.nextState();
            return;
        }
        this.myState.nextToken(this);
        while (this.myReader.isReady() && this.myType == null) {
            this.nextState();
            this.myState.nextToken(this);
        }
        this.nextState();
    }

    public boolean isReady() throws IOException {
        return this.myReader.isReady();
    }

    @Nullable
    public String readAhead(int count) throws IOException {
        return this.myReader.readAhead(count);
    }

    public long getLine() {
        return this.myReader.getLine();
    }

    public long getCharacters() {
        return this.myReader.getCharacters();
    }

    public long getLineCharacters() {
        return this.myReader.getLineCharacters();
    }

    public long getTokenLine() {
        return this.myTokenLine;
    }

    @Nullable
    public TokenType getType() {
        return this.myType;
    }

    public long getStart() {
        return this.myStart;
    }

    public long getEnd() {
        return this.myEnd;
    }

    public long getOffset() {
        return this.myOffset;
    }

    @Nullable
    public String getText() {
        return this.myText;
    }

    public boolean hasToken() {
        return this.myType != null;
    }

    public void valueOrQuoted() throws IOException {
        int quotedCount = this.matchAndRewindSeparators(this.myQuotedAutomaton);
        if (quotedCount != -1) {
            String quoted = StringUtil.notNullize((String)this.myReader.readString(quotedCount));
            this.setToken(TokenType.QUOTED_VALUE, quoted);
        } else {
            int valueCount = this.matchAndRewindSeparators(this.myValueAutomaton);
            String value = StringUtil.notNullize((String)this.myReader.readString(valueCount));
            this.setToken(TokenType.VALUE, value);
        }
    }

    private int matchAndRewindSeparators(RunAutomaton automaton) throws IOException {
        int matched = automaton == null ? -1 : this.myReader.matchAhead(automaton, 0);
        return matched == -1 ? -1 : this.rewindSeparators(matched);
    }

    private int rewindSeparators(int count) throws IOException {
        int rewCount = this.mySeparatorRewindAutomaton == null ? -1 : this.myReader.matchBackward(count, this.mySeparatorRewindAutomaton, this.myMaxSeparatorRewind);
        return rewCount == -1 ? count : count - rewCount;
    }

    protected void nextState() throws IOException {
        this.setState(this.myState.nextState(this.myType));
    }

    private void setState(@Nullable State state) {
        this.myState = state;
    }

    private void setToken(@Nullable TokenType type, @Nullable String text) {
        this.setToken(type, text, this.myEnd, this.getCharacters(), this.myTokenEndLine, this.myEndOffset);
    }

    private void setToken(@Nullable TokenType type, @Nullable String text, long start, long end, long line, long offset) {
        this.myType = type;
        this.myText = text;
        this.myStart = start;
        this.myEnd = end;
        this.myTokenLine = line;
        this.myOffset = offset;
        this.myTokenEndLine = this.getLine();
        this.myEndOffset = this.getLineCharacters();
    }

    private void setNullToken() {
        this.setToken(null, null);
    }

    private void getSymbolToken(@NotNull String symbol, @NotNull TokenType type) throws IOException {
        if (symbol == null) {
            CsvLexer.$$$reportNull$$$0(6);
        }
        if (type == null) {
            CsvLexer.$$$reportNull$$$0(7);
        }
        if (!this.myReader.isReady()) {
            this.setNullToken();
        } else if (this.myReader.read(symbol)) {
            this.setToken(type, symbol);
        } else {
            this.setNullToken();
        }
    }

    private void separator() throws IOException {
        if (!this.myReader.isReady()) {
            this.setNullToken();
        } else if (this.isSuffix() && this.myReader.read(this.myCsvFormat.suffix, true)) {
            this.setToken(TokenType.SUFFIX, this.myCsvFormat.suffix);
        } else if (this.myReader.read(this.myCsvFormat.recordSeparator)) {
            this.setToken(TokenType.RECORD_SEPARATOR, this.myCsvFormat.recordSeparator);
        } else if (this.myReader.read(this.myCsvFormat.valueSeparator)) {
            this.setToken(TokenType.VALUE_SEPARATOR, this.myCsvFormat.valueSeparator);
        } else {
            this.setNullToken();
        }
    }

    private boolean isSuffix() throws IOException {
        if (this.myCsvFormat.suffix.isEmpty()) {
            return false;
        }
        String suffix = this.myCsvFormat.suffix + this.myCsvFormat.recordSeparator;
        return this.myReader.matchAhead(suffix, true) != -1;
    }

    @NotNull
    private static String getElementText(@NotNull IElementType type) {
        if (type == null) {
            CsvLexer.$$$reportNull$$$0(8);
        }
        String s = StringUtil.toLowerCase((String)type.toString());
        String string = StringUtil.join((String[])s.split("_"), (String)" ");
        if (string == null) {
            CsvLexer.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "csvFormat";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/CsvLexer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/CsvLexer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCsvFormat";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "bricsEscape";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCsvFormat";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolToken";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 9 -> new IllegalStateException(string);
        };
    }

    private static enum State {
        RECORD_START{

            @Override
            void nextToken(@NotNull CsvLexer lexer) throws IOException {
                if (lexer == null) {
                    1.$$$reportNull$$$0(0);
                }
                lexer.getSymbolToken(lexer.myCsvFormat.prefix, TokenType.PREFIX);
            }

            @Override
            @NotNull
            State nextState(@Nullable TokenType type) {
                State state = VALUE_START;
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                return state;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lexer";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$State$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$State$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "nextState";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "nextToken";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
        ,
        RECORD_END{

            @Override
            void nextToken(@NotNull CsvLexer lexer) throws IOException {
                if (lexer == null) {
                    2.$$$reportNull$$$0(0);
                }
                lexer.getSymbolToken(lexer.myCsvFormat.suffix, TokenType.SUFFIX);
            }

            @Override
            @NotNull
            State nextState(@Nullable TokenType type) {
                State state = type == null || type == TokenType.RECORD_SEPARATOR ? VALUE_START : VALUE_END;
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                return state;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lexer";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$State$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$State$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "nextState";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "nextToken";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
        ,
        VALUE_START{

            @Override
            void nextToken(@NotNull CsvLexer lexer) throws IOException {
                if (lexer == null) {
                    3.$$$reportNull$$$0(0);
                }
                lexer.valueOrQuoted();
            }

            @Override
            void end(@NotNull CsvLexer lexer) throws IOException {
                if (lexer == null) {
                    3.$$$reportNull$$$0(1);
                }
                lexer.valueOrQuoted();
            }

            @Override
            @NotNull
            State nextState(@Nullable TokenType type) {
                State state = VALUE_END;
                if (state == null) {
                    3.$$$reportNull$$$0(2);
                }
                return state;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lexer";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$State$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$State$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "nextState";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "nextToken";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "end";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }
        ,
        VALUE_END{

            @Override
            void nextToken(@NotNull CsvLexer lexer) throws IOException {
                if (lexer == null) {
                    4.$$$reportNull$$$0(0);
                }
                lexer.separator();
            }

            @Override
            @NotNull
            State nextState(@Nullable TokenType type) {
                State state = type == null ? RECORD_END : (type == TokenType.SUFFIX ? VALUE_END : (type == TokenType.RECORD_SEPARATOR ? RECORD_START : VALUE_START));
                if (state == null) {
                    4.$$$reportNull$$$0(1);
                }
                return state;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lexer";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$State$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$State$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "nextState";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "nextToken";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };


        abstract void nextToken(@NotNull CsvLexer var1) throws IOException;

        void end(@NotNull CsvLexer lexer) throws IOException {
            if (lexer == null) {
                State.$$$reportNull$$$0(0);
            }
            lexer.setNullToken();
        }

        @NotNull
        abstract State nextState(@Nullable TokenType var1) throws IOException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/datagrid/CsvLexer$State", "end"));
        }
    }

    public static class TokenType {
        private static final IElementType RECORD_SEPARATOR_TYPE = new IElementType("RECORD_SEPARATOR", null);
        private static final IElementType VALUE_SEPARATOR_TYPE = new IElementType("VALUE_SEPARATOR", null);
        private static final IElementType VALUE_TYPE = new IElementType("VALUE", null);
        private static final IElementType QUOTED_VALUE_TYPE = new IElementType("QUOTED_VALUE", null);
        private static final IElementType SUFFIX_TYPE = new IElementType("SUFFIX", null);
        private static final IElementType PREFIX_TYPE = new IElementType("PREFIX", null);
        public static final TokenType RECORD_SEPARATOR = new TokenType(RECORD_SEPARATOR_TYPE){

            @Override
            @NotNull
            public String getDebugName(@NotNull CsvRecordFormat format) {
                if (format == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = super.getDebugName(format) + " (" + format.recordSeparator + ")";
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @NotNull
            String getTokenRepresentation(@NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(2);
                }
                String string = this.myName + " " + super.getTokenRepresentation(text);
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "format";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$TokenType$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$TokenType$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDebugName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTokenRepresentation";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getDebugName";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getTokenRepresentation";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3 -> new IllegalStateException(string);
                };
            }
        };
        public static final TokenType VALUE_SEPARATOR = new TokenType(VALUE_SEPARATOR_TYPE){

            @Override
            @NotNull
            public String getDebugName(@NotNull CsvRecordFormat format) {
                if (format == null) {
                    2.$$$reportNull$$$0(0);
                }
                String string = super.getDebugName(format) + " (" + format.valueSeparator + ")";
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @NotNull
            String getTokenRepresentation(@NotNull String text) {
                if (text == null) {
                    2.$$$reportNull$$$0(2);
                }
                String string = this.myName + " " + super.getTokenRepresentation(text);
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "format";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$TokenType$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$TokenType$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDebugName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTokenRepresentation";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getDebugName";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getTokenRepresentation";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3 -> new IllegalStateException(string);
                };
            }
        };
        public static final TokenType VALUE = new TokenType(VALUE_TYPE){

            @Override
            @NotNull
            protected String wrap(@NotNull String s) {
                if (s == null) {
                    3.$$$reportNull$$$0(0);
                }
                String string = "\"" + s + "\"";
                if (string == null) {
                    3.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$TokenType$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$TokenType$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "wrap";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "wrap";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        public static final TokenType QUOTED_VALUE = new TokenType(QUOTED_VALUE_TYPE){

            @Override
            @NotNull
            public String getDebugName(@NotNull CsvRecordFormat format) {
                if (format == null) {
                    4.$$$reportNull$$$0(0);
                }
                return "value";
            }

            @Override
            @NotNull
            protected String wrap(@NotNull String s) {
                if (s == null) {
                    4.$$$reportNull$$$0(1);
                }
                String string = s;
                if (string == null) {
                    4.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "format";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$TokenType$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$TokenType$4";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "wrap";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getDebugName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "wrap";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        public static final TokenType PREFIX = new TokenType(PREFIX_TYPE){

            @Override
            @NotNull
            public String getDebugName(@NotNull CsvRecordFormat format) {
                if (format == null) {
                    5.$$$reportNull$$$0(0);
                }
                String string = super.getDebugName(format) + " (" + format.prefix + ")";
                if (string == null) {
                    5.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @NotNull
            String getTokenRepresentation(@NotNull String text) {
                if (text == null) {
                    5.$$$reportNull$$$0(2);
                }
                String string = this.myName + " " + super.getTokenRepresentation(text);
                if (string == null) {
                    5.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "format";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$TokenType$5";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$TokenType$5";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDebugName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTokenRepresentation";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getDebugName";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getTokenRepresentation";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3 -> new IllegalStateException(string);
                };
            }
        };
        public static final TokenType SUFFIX = new TokenType(SUFFIX_TYPE){

            @Override
            @NotNull
            public String getDebugName(@NotNull CsvRecordFormat format) {
                if (format == null) {
                    6.$$$reportNull$$$0(0);
                }
                String string = super.getDebugName(format) + " (" + format.suffix + ")";
                if (string == null) {
                    6.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @NotNull
            String getTokenRepresentation(@NotNull String text) {
                if (text == null) {
                    6.$$$reportNull$$$0(2);
                }
                String string = this.myName + " " + super.getTokenRepresentation(text);
                if (string == null) {
                    6.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "format";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$TokenType$6";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$TokenType$6";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDebugName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTokenRepresentation";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getDebugName";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getTokenRepresentation";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3 -> new IllegalStateException(string);
                };
            }
        };
        protected final String myName;
        private final IElementType myElementType;

        private TokenType(@NotNull IElementType type) {
            if (type == null) {
                TokenType.$$$reportNull$$$0(0);
            }
            this.myElementType = type;
            this.myName = CsvLexer.getElementText(type);
        }

        @NotNull
        public String getDebugName(@NotNull CsvRecordFormat format) {
            if (format == null) {
                TokenType.$$$reportNull$$$0(1);
            }
            String string = this.myName;
            if (string == null) {
                TokenType.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        String getTokenRepresentation(@NotNull String text) {
            if (text == null) {
                TokenType.$$$reportNull$$$0(3);
            }
            String string = this.wrap(StringUtil.escapeStringCharacters((String)text));
            if (string == null) {
                TokenType.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        protected String wrap(@NotNull String s) {
            if (s == null) {
                TokenType.$$$reportNull$$$0(5);
            }
            String string = "(" + s + ")";
            if (string == null) {
                TokenType.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public IElementType getElementType() {
            IElementType iElementType = this.myElementType;
            if (iElementType == null) {
                TokenType.$$$reportNull$$$0(7);
            }
            return iElementType;
        }

        public String toString() {
            return this.myElementType.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/CsvLexer$TokenType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/CsvLexer$TokenType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebugName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTokenRepresentation";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrap";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getDebugName";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getTokenRepresentation";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "wrap";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4, 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

