/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.hadoop.shaded.org.xbill.DNS.CNAMERecord;
import org.apache.hadoop.shaded.org.xbill.DNS.Compression;
import org.apache.hadoop.shaded.org.xbill.DNS.DClass;
import org.apache.hadoop.shaded.org.xbill.DNS.DNAMERecord;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSInput;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSOutput;
import org.apache.hadoop.shaded.org.xbill.DNS.Header;
import org.apache.hadoop.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.shaded.org.xbill.DNS.NameTooLongException;
import org.apache.hadoop.shaded.org.xbill.DNS.OPTRecord;
import org.apache.hadoop.shaded.org.xbill.DNS.RRset;
import org.apache.hadoop.shaded.org.xbill.DNS.Record;
import org.apache.hadoop.shaded.org.xbill.DNS.Resolver;
import org.apache.hadoop.shaded.org.xbill.DNS.SIGRecord;
import org.apache.hadoop.shaded.org.xbill.DNS.Section;
import org.apache.hadoop.shaded.org.xbill.DNS.TSIG;
import org.apache.hadoop.shaded.org.xbill.DNS.TSIGRecord;
import org.apache.hadoop.shaded.org.xbill.DNS.Type;
import org.apache.hadoop.shaded.org.xbill.DNS.Update;
import org.apache.hadoop.shaded.org.xbill.DNS.WireParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message
implements Cloneable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Message.class);
    public static final int MAXLENGTH = 65535;
    private Header header;
    private List<Record>[] sections;
    private int size;
    private TSIG tsigkey;
    private TSIGRecord generatedTsig;
    private TSIGRecord querytsig;
    private int tsigerror;
    private Resolver resolver;
    int tsigstart;
    int tsigState;
    int sig0start;
    static final int TSIG_UNSIGNED = 0;
    static final int TSIG_VERIFIED = 1;
    static final int TSIG_INTERMEDIATE = 2;
    static final int TSIG_SIGNED = 3;
    static final int TSIG_FAILED = 4;
    private static final Record[] emptyRecordArray = new Record[0];

    private Message(Header header) {
        this.sections = new List[4];
        this.header = header;
    }

    public Message(int id) {
        this(new Header(id));
    }

    public Message() {
        this(new Header());
    }

    public static Message newQuery(Record r) {
        Message m4 = new Message();
        m4.header.setOpcode(0);
        m4.header.setFlag(7);
        m4.addRecord(r, 0);
        return m4;
    }

    public static Message newUpdate(Name zone) {
        return new Update(zone);
    }

    Message(DNSInput in) throws IOException {
        block7: {
            this(new Header(in));
            boolean isUpdate = this.header.getOpcode() == 5;
            boolean truncated = this.header.getFlag(6);
            try {
                for (int i = 0; i < 4; ++i) {
                    int count = this.header.getCount(i);
                    if (count > 0) {
                        this.sections[i] = new ArrayList<Record>(count);
                    }
                    for (int j = 0; j < count; ++j) {
                        SIGRecord sig;
                        int pos = in.current();
                        Record rec = Record.fromWire(in, i, isUpdate);
                        this.sections[i].add(rec);
                        if (i != 3) continue;
                        if (rec.getType() == 250) {
                            this.tsigstart = pos;
                            if (j != count - 1) {
                                throw new WireParseException("TSIG is not the last record in the message");
                            }
                        }
                        if (rec.getType() != 24 || (sig = (SIGRecord)rec).getTypeCovered() != 0) continue;
                        this.sig0start = pos;
                    }
                }
            }
            catch (WireParseException e) {
                if (truncated) break block7;
                throw e;
            }
        }
        this.size = in.current();
    }

    public Message(byte[] b) throws IOException {
        this(new DNSInput(b));
    }

    public Message(ByteBuffer byteBuffer) throws IOException {
        this(new DNSInput(byteBuffer));
    }

    public void setHeader(Header h2) {
        this.header = h2;
    }

    public Header getHeader() {
        return this.header;
    }

    public void addRecord(Record r, int section) {
        if (this.sections[section] == null) {
            this.sections[section] = new LinkedList<Record>();
        }
        this.header.incCount(section);
        this.sections[section].add(r);
    }

    public boolean removeRecord(Record r, int section) {
        Section.check(section);
        if (this.sections[section] != null && this.sections[section].remove(r)) {
            this.header.decCount(section);
            return true;
        }
        return false;
    }

    public void removeAllRecords(int section) {
        Section.check(section);
        this.sections[section] = null;
        this.header.setCount(section, 0);
    }

    public boolean findRecord(Record r, int section) {
        Section.check(section);
        return this.sections[section] != null && this.sections[section].contains(r);
    }

    public boolean findRecord(Record r) {
        for (int i = 1; i <= 3; ++i) {
            if (this.sections[i] == null || !this.sections[i].contains(r)) continue;
            return true;
        }
        return false;
    }

    public boolean findRRset(Name name, int type, int section) {
        Type.check(type);
        Section.check(section);
        if (this.sections[section] == null) {
            return false;
        }
        for (int i = 0; i < this.sections[section].size(); ++i) {
            Record r = this.sections[section].get(i);
            if (r.getType() != type || !name.equals(r.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean findRRset(Name name, int type) {
        return this.findRRset(name, type, 1) || this.findRRset(name, type, 2) || this.findRRset(name, type, 3);
    }

    public Record getQuestion() {
        List<Record> l = this.sections[0];
        if (l == null || l.isEmpty()) {
            return null;
        }
        return l.get(0);
    }

    public TSIGRecord getTSIG() {
        int count = this.header.getCount(3);
        if (count == 0) {
            return null;
        }
        List<Record> l = this.sections[3];
        Record rec = l.get(count - 1);
        if (rec.type != 250) {
            return null;
        }
        return (TSIGRecord)rec;
    }

    TSIGRecord getGeneratedTSIG() {
        return this.generatedTsig;
    }

    public boolean isSigned() {
        return this.tsigState == 3 || this.tsigState == 1 || this.tsigState == 4;
    }

    public boolean isVerified() {
        return this.tsigState == 1;
    }

    public OPTRecord getOPT() {
        for (Record r : this.getSection(3)) {
            if (!(r instanceof OPTRecord)) continue;
            return (OPTRecord)r;
        }
        return null;
    }

    public int getRcode() {
        int rcode = this.header.getRcode();
        OPTRecord opt = this.getOPT();
        if (opt != null) {
            rcode += opt.getExtendedRcode() << 4;
        }
        return rcode;
    }

    @Deprecated
    public Record[] getSectionArray(int section) {
        Section.check(section);
        if (this.sections[section] == null) {
            return emptyRecordArray;
        }
        List<Record> l = this.sections[section];
        return l.toArray(new Record[0]);
    }

    public List<Record> getSection(int section) {
        Section.check(section);
        if (this.sections[section] == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.sections[section]);
    }

    public List<RRset> getSectionRRsets(int section) {
        Section.check(section);
        if (this.sections[section] == null) {
            return Collections.emptyList();
        }
        LinkedList<RRset> sets = new LinkedList<RRset>();
        block0: for (Record rec : this.sections[section]) {
            for (int j = sets.size() - 1; j >= 0; --j) {
                RRset set = (RRset)sets.get(j);
                if (!rec.sameRRset(set)) continue;
                set.addRR(rec);
                continue block0;
            }
            sets.add(new RRset(rec));
        }
        return sets;
    }

    void toWire(DNSOutput out) {
        this.header.toWire(out);
        Compression c = new Compression();
        for (int i = 0; i < this.sections.length; ++i) {
            if (this.sections[i] == null) continue;
            for (Record rec : this.sections[i]) {
                rec.toWire(out, i, c);
            }
        }
    }

    private int sectionToWire(DNSOutput out, int section, Compression c, int maxLength) {
        int n = this.sections[section].size();
        int pos = out.current();
        int rendered = 0;
        int count = 0;
        Record lastrec = null;
        for (int i = 0; i < n; ++i) {
            Record rec = this.sections[section].get(i);
            if (section == 3 && rec instanceof OPTRecord) continue;
            if (lastrec != null && !rec.sameRRset(lastrec)) {
                pos = out.current();
                rendered = count;
            }
            lastrec = rec;
            rec.toWire(out, section, c);
            if (out.current() > maxLength) {
                out.jump(pos);
                return n - rendered;
            }
            ++count;
        }
        return n - count;
    }

    private void toWire(DNSOutput out, int maxLength) {
        if (maxLength < 12) {
            return;
        }
        int tempMaxLength = maxLength;
        if (this.tsigkey != null) {
            tempMaxLength -= this.tsigkey.recordLength();
        }
        OPTRecord opt = this.getOPT();
        byte[] optBytes = null;
        if (opt != null) {
            optBytes = opt.toWire(3);
            tempMaxLength -= optBytes.length;
        }
        int startpos = out.current();
        this.header.toWire(out);
        Compression c = new Compression();
        int flags = this.header.getFlagsByte();
        int additionalCount = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.sections[i] == null) continue;
            int skipped = this.sectionToWire(out, i, c, tempMaxLength);
            if (skipped != 0 && i != 3) {
                flags = Header.setFlag(flags, 6, true);
                out.writeU16At(this.header.getCount(i) - skipped, startpos + 4 + 2 * i);
                for (int j = i + 1; j < 3; ++j) {
                    out.writeU16At(0, startpos + 4 + 2 * j);
                }
                break;
            }
            if (i != 3) continue;
            additionalCount = this.header.getCount(i) - skipped;
        }
        if (optBytes != null) {
            out.writeByteArray(optBytes);
            ++additionalCount;
        }
        if (flags != this.header.getFlagsByte()) {
            out.writeU16At(flags, startpos + 2);
        }
        if (additionalCount != this.header.getCount(3)) {
            out.writeU16At(additionalCount, startpos + 10);
        }
        if (this.tsigkey != null) {
            TSIGRecord tsigrec = this.tsigkey.generate(this, out.toByteArray(), this.tsigerror, this.querytsig);
            tsigrec.toWire(out, 3, c);
            this.generatedTsig = tsigrec;
            out.writeU16At(additionalCount + 1, startpos + 10);
        }
    }

    public byte[] toWire() {
        DNSOutput out = new DNSOutput();
        this.toWire(out);
        this.size = out.current();
        return out.toByteArray();
    }

    public byte[] toWire(int maxLength) {
        DNSOutput out = new DNSOutput();
        this.toWire(out, maxLength);
        this.size = out.current();
        return out.toByteArray();
    }

    public void setTSIG(TSIG key) {
        this.setTSIG(key, 0, null);
    }

    public void setTSIG(TSIG key, int error, TSIGRecord querytsig) {
        this.tsigkey = key;
        this.tsigerror = error;
        this.querytsig = querytsig;
    }

    public int numBytes() {
        return this.size;
    }

    public String sectionToString(int section) {
        Section.check(section);
        StringBuilder sb = new StringBuilder();
        this.sectionToString(sb, section);
        return sb.toString();
    }

    private void sectionToString(StringBuilder sb, int i) {
        if (i > 3) {
            return;
        }
        for (Record rec : this.getSection(i)) {
            if (i == 0) {
                sb.append(";;\t").append(rec.name);
                sb.append(", type = ").append(Type.string(rec.type));
                sb.append(", class = ").append(DClass.string(rec.dclass));
            } else if (!(rec instanceof OPTRecord)) {
                sb.append(rec);
            }
            sb.append("\n");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        OPTRecord opt = this.getOPT();
        if (opt != null) {
            sb.append(this.header.toStringWithRcode(this.getRcode())).append("\n\n");
            opt.printPseudoSection(sb);
            sb.append('\n');
        } else {
            sb.append(this.header).append('\n');
        }
        if (this.isSigned()) {
            sb.append(";; TSIG ");
            if (this.isVerified()) {
                sb.append("ok");
            } else {
                sb.append("invalid");
            }
            sb.append('\n');
        }
        for (int i = 0; i < 4; ++i) {
            if (this.header.getOpcode() != 5) {
                sb.append(";; ").append(Section.longString(i)).append(":\n");
            } else {
                sb.append(";; ").append(Section.updString(i)).append(":\n");
            }
            this.sectionToString(sb, i);
            sb.append("\n");
        }
        sb.append(";; Message size: ").append(this.numBytes()).append(" bytes");
        return sb.toString();
    }

    public Message clone() {
        Message m4 = (Message)super.clone();
        m4.sections = new List[this.sections.length];
        for (int i = 0; i < this.sections.length; ++i) {
            if (this.sections[i] == null) continue;
            m4.sections[i] = new LinkedList<Record>(this.sections[i]);
        }
        m4.header = this.header.clone();
        if (this.querytsig != null) {
            m4.querytsig = (TSIGRecord)this.querytsig.cloneRecord();
        }
        if (this.generatedTsig != null) {
            m4.generatedTsig = (TSIGRecord)this.generatedTsig.cloneRecord();
        }
        return m4;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public Optional<Resolver> getResolver() {
        return Optional.ofNullable(this.resolver);
    }

    boolean isTypeAllowedInSection(int type, int section) {
        Type.check(type);
        Section.check(section);
        switch (section) {
            case 2: {
                if (type != 6 && type != 2 && type != 43 && type != 47 && type != 50) break;
                return true;
            }
            case 3: {
                if (type != 1 && type != 28) break;
                return true;
            }
        }
        return !Boolean.parseBoolean(System.getProperty("dnsjava.harden_unknown_additional", "true"));
    }

    public Message normalize(Message query) {
        try {
            return this.normalize(query, false);
        }
        catch (WireParseException wireParseException) {
            return null;
        }
    }

    public Message normalize(Message query, boolean throwOnIrrelevantRecord) throws WireParseException {
        if (this.getRcode() != 0 && this.getRcode() != 3) {
            return this;
        }
        Name sname = query.getQuestion().getName();
        List<RRset> answerSectionSets = this.getSectionRRsets(1);
        List<RRset> additionalSectionSets = this.getSectionRRsets(3);
        List<RRset> authoritySectionSets = this.getSectionRRsets(2);
        ArrayList<RRset> cleanedAnswerSection = new ArrayList<RRset>();
        ArrayList<RRset> cleanedAuthoritySection = new ArrayList<RRset>();
        ArrayList<RRset> cleanedAdditionalSection = new ArrayList<RRset>();
        boolean hadNsInAuthority = false;
        for (int i = 0; i < answerSectionSets.size(); ++i) {
            RRset rrset = answerSectionSets.get(i);
            Name oldSname = sname;
            if (rrset.getType() == 39 && sname.subdomain(rrset.getName())) {
                if (rrset.size() > 1) {
                    String template = "Normalization failed in response to <{}/{}/{}> (id {}), found {} entries (instead of just one) in DNAME RRSet <{}/{}>";
                    if (throwOnIrrelevantRecord) {
                        throw new WireParseException(template.replace("{}", "%s"));
                    }
                    log.warn(template, new Object[]{sname, Type.string(query.getQuestion().getType()), DClass.string(query.getQuestion().getDClass()), this.getHeader().getID(), rrset.size(), rrset.getName(), DClass.string(rrset.getDClass())});
                    return null;
                }
                if (query.getQuestion().getType() != 39) {
                    cleanedAnswerSection.add(rrset);
                    RRset nextRRSet = answerSectionSets.size() >= i + 2 ? answerSectionSets.get(i + 1) : null;
                    DNAMERecord dname = (DNAMERecord)rrset.first();
                    try {
                        Name expected;
                        if (nextRRSet != null && nextRRSet.getType() == 5 && nextRRSet.getName().equals(sname) && (expected = Name.concatenate(nextRRSet.getName().relativize(dname.getName()), dname.getTarget())).equals(((CNAMERecord)nextRRSet.first()).getTarget())) continue;
                        Name dnameTarget = sname.fromDNAME(dname);
                        cleanedAnswerSection.add(new RRset((Record)new CNAMERecord(sname, dname.getDClass(), 0L, dnameTarget)));
                        sname = dnameTarget;
                        if (query.getQuestion().getType() != 255) continue;
                        ++i;
                        while (i < answerSectionSets.size() && (rrset = answerSectionSets.get(i)).getName().equals(oldSname)) {
                            cleanedAnswerSection.add(rrset);
                            ++i;
                        }
                        continue;
                    }
                    catch (NameTooLongException e) {
                        String template = "Normalization failed in response to <{}/{}/{}> (id {}), could not synthesize CNAME for DNAME <{}/{}>";
                        if (throwOnIrrelevantRecord) {
                            throw new WireParseException(template.replace("{}", "%s"), e);
                        }
                        log.warn(template, new Object[]{sname, Type.string(query.getQuestion().getType()), DClass.string(query.getQuestion().getDClass()), this.getHeader().getID(), rrset.getName(), DClass.string(rrset.getDClass())});
                        return null;
                    }
                }
            }
            if (!sname.equals(rrset.getName())) {
                this.logOrThrow(throwOnIrrelevantRecord, "Ignoring irrelevant RRset <{}/{}/{}> in response to <{}/{}/{}> (id {})", rrset, sname, query);
                continue;
            }
            if (rrset.getType() == 5 && query.getQuestion().getType() != 5) {
                if (rrset.size() > 1) {
                    String template = "Found {} CNAMEs in <{}/{}> response to <{}/{}/{}> (id {}), removing all but the first";
                    if (throwOnIrrelevantRecord) {
                        throw new WireParseException(String.format(template.replace("{}", "%s"), rrset.rrs(false).size(), rrset.getName(), DClass.string(rrset.getDClass()), sname, Type.string(query.getQuestion().getType()), DClass.string(query.getQuestion().getDClass()), this.getHeader().getID()));
                    }
                    log.warn(template, new Object[]{rrset.rrs(false).size(), rrset.getName(), DClass.string(rrset.getDClass()), sname, Type.string(query.getQuestion().getType()), DClass.string(query.getQuestion().getDClass()), this.getHeader().getID()});
                    List<Record> cnameRRset = rrset.rrs(false);
                    for (int cnameIndex = 1; cnameIndex < cnameRRset.size(); ++cnameIndex) {
                        rrset.deleteRR(cnameRRset.get(i));
                    }
                }
                sname = ((CNAMERecord)rrset.first()).getTarget();
                cleanedAnswerSection.add(rrset);
                if (query.getQuestion().getType() != 255) continue;
                ++i;
                while (i < answerSectionSets.size() && (rrset = answerSectionSets.get(i)).getName().equals(oldSname)) {
                    cleanedAnswerSection.add(rrset);
                    ++i;
                }
                continue;
            }
            int qtype = this.getQuestion().getType();
            if (qtype != 255 && rrset.getActualType() != qtype) {
                this.logOrThrow(throwOnIrrelevantRecord, "Ignoring irrelevant RRset <{}/{}/{}> in ANSWER section response to <{}/{}/{}> (id {})", rrset, sname, query);
                continue;
            }
            cleanedAnswerSection.add(rrset);
            if (!sname.equals(rrset.getName())) continue;
            this.addAdditionalRRset(rrset, additionalSectionSets, cleanedAdditionalSection);
        }
        block9: for (RRset rrset : authoritySectionSets) {
            switch (rrset.getType()) {
                case 1: 
                case 5: 
                case 28: 
                case 39: {
                    this.logOrThrow(throwOnIrrelevantRecord, "Ignoring forbidden RRset <{}/{}/{}> in AUTHORITY section response to <{}/{}/{}> (id {})", rrset, sname, query);
                    continue block9;
                }
            }
            if (!this.isTypeAllowedInSection(rrset.getType(), 2)) {
                this.logOrThrow(throwOnIrrelevantRecord, "Ignoring disallowed RRset <{}/{}/{}> in AUTHORITY section response to <{}/{}/{}> (id {})", rrset, sname, query);
                continue;
            }
            if (rrset.getType() == 2) {
                if (!sname.subdomain(rrset.getName())) {
                    this.logOrThrow(throwOnIrrelevantRecord, "Ignoring disallowed RRset <{}/{}/{}> in AUTHORITY section response to <{}/{}/{}> (id {}), not a subdomain of the query", rrset, sname, query);
                    continue;
                }
                if (this.getRcode() == 3 || this.getRcode() == 0 && authoritySectionSets.stream().anyMatch(set -> set.getType() == 6) && this.sections[1] == null) {
                    this.logOrThrow(throwOnIrrelevantRecord, "Ignoring disallowed RRset <{}/{}/{}> in AUTHORITY section response to <{}/{}/{}> (id {}), NXDOMAIN or NODATA", rrset, sname, query);
                    continue;
                }
                if (!hadNsInAuthority) {
                    hadNsInAuthority = true;
                } else {
                    this.logOrThrow(throwOnIrrelevantRecord, "Ignoring disallowed RRset <{}/{}/{}> in AUTHORITY section response to <{}/{}/{}> (id {}), already seen another NS", rrset, sname, query);
                    continue;
                }
            }
            cleanedAuthoritySection.add(rrset);
            this.addAdditionalRRset(rrset, additionalSectionSets, cleanedAdditionalSection);
        }
        Message cleanedMessage = new Message(this.getHeader());
        cleanedMessage.sections[0] = this.sections[0];
        cleanedMessage.sections[1] = this.rrsetListToRecords(cleanedAnswerSection);
        cleanedMessage.sections[2] = this.rrsetListToRecords(cleanedAuthoritySection);
        cleanedMessage.sections[3] = this.rrsetListToRecords(cleanedAdditionalSection);
        return cleanedMessage;
    }

    private void logOrThrow(boolean throwOnIrrelevantRecord, String format, RRset rrset, Name sname, Message query) throws WireParseException {
        if (throwOnIrrelevantRecord) {
            throw new WireParseException(String.format(format.replace("{}", "%s") + this, rrset.getName(), DClass.string(rrset.getDClass()), Type.string(rrset.getType()), sname, DClass.string(query.getQuestion().getDClass()), Type.string(query.getQuestion().getType()), this.getHeader().getID()));
        }
        log.debug(format, new Object[]{rrset.getName(), DClass.string(rrset.getDClass()), Type.string(rrset.getType()), sname, DClass.string(query.getQuestion().getDClass()), Type.string(query.getQuestion().getType()), this.getHeader().getID()});
    }

    private List<Record> rrsetListToRecords(List<RRset> rrsets) {
        if (rrsets.isEmpty()) {
            return null;
        }
        ArrayList<Record> result = new ArrayList<Record>(rrsets.size());
        for (RRset set : rrsets) {
            result.addAll(set.rrs(false));
            result.addAll(set.sigs());
        }
        return result;
    }

    private void addAdditionalRRset(RRset rrset, List<RRset> additionalSectionSets, List<RRset> cleanedAdditionalSection) {
        if (!this.doesTypeHaveAdditionalRecords(rrset.getType())) {
            return;
        }
        for (Record r : rrset.rrs(false)) {
            for (RRset set : additionalSectionSets) {
                if (!set.getName().equals(r.getAdditionalName()) || !this.isTypeAllowedInSection(set.getType(), 3)) continue;
                cleanedAdditionalSection.add(set);
            }
        }
    }

    private boolean doesTypeHaveAdditionalRecords(int type) {
        switch (type) {
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 15: 
            case 33: 
            case 35: 
            case 36: {
                return true;
            }
        }
        return false;
    }
}

