/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.file.PathUtils;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.LockFactory;
import org.apache.solr.core.CachingDirectoryFactory;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.NRTCachingDirectoryFactory;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DirectoryFactory
implements NamedListInitializedPlugin,
Closeable {
    public static final IOContext IOCONTEXT_NO_CACHE = new IOContext(new FlushInfo(10000000, 100000000000L));
    protected static final String INDEX_W_TIMESTAMP_REGEX = "index\\.[0-9]{17}";
    protected Path dataHomePath;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String LOCK_TYPE_SIMPLE = "simple";
    public static final String LOCK_TYPE_NATIVE = "native";
    public static final String LOCK_TYPE_SINGLE = "single";
    public static final String LOCK_TYPE_NONE = "none";
    protected volatile CoreContainer coreContainer;

    public abstract void doneWithDirectory(Directory var1) throws IOException;

    public abstract void addCloseListener(Directory var1, CachingDirectoryFactory.CloseListener var2);

    @Override
    public abstract void close() throws IOException;

    protected abstract Directory create(String var1, LockFactory var2, DirContext var3) throws IOException;

    protected abstract LockFactory createLockFactory(String var1) throws IOException;

    public abstract boolean exists(String var1) throws IOException;

    public abstract void remove(Directory var1) throws IOException;

    public abstract void remove(Directory var1, boolean var2) throws IOException;

    public abstract void remove(String var1, boolean var2) throws IOException;

    public abstract void remove(String var1) throws IOException;

    public long size(Directory directory) throws IOException {
        return DirectoryFactory.sizeOfDirectory(directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size(String path) throws IOException {
        long size;
        Directory dir = this.get(path, DirContext.DEFAULT, null);
        try {
            size = DirectoryFactory.sizeOfDirectory(dir);
        }
        finally {
            this.release(dir);
        }
        return size;
    }

    public void move(Directory fromDir, Directory toDir, String fileName, IOContext ioContext) throws IOException {
        toDir.copyFrom(fromDir, fileName, fileName, ioContext);
        fromDir.deleteFile(fileName);
    }

    public void renameWithOverwrite(Directory dir, String fileName, String toName) throws IOException {
        try {
            dir.deleteFile(toName);
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
        }
        catch (Exception e) {
            log.error("Exception deleting file", (Throwable)e);
        }
        dir.rename(fileName, toName);
    }

    public abstract Directory get(String var1, DirContext var2, String var3) throws IOException;

    public abstract void incRef(Directory var1);

    public abstract boolean isPersistent();

    public boolean isSharedStorage() {
        return false;
    }

    public abstract void release(Directory var1) throws IOException;

    public String normalize(String path) throws IOException {
        return path;
    }

    public boolean isAbsolute(String path) {
        return Path.of(path, new String[0]).isAbsolute();
    }

    public static long sizeOfDirectory(Directory directory) throws IOException {
        String[] files = directory.listAll();
        long size = 0L;
        for (String file : files) {
            if ((size += DirectoryFactory.sizeOf(directory, file)) < 0L) break;
        }
        return size;
    }

    public static long sizeOf(Directory directory, String file) throws IOException {
        try {
            return directory.fileLength(file);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public static boolean empty(Directory dir) {
        boolean isSuccess = true;
        try {
            String[] contents = dir.listAll();
            if (contents != null) {
                for (String file : contents) {
                    dir.deleteFile(file);
                }
            }
        }
        catch (IOException e) {
            log.error("Error deleting files from Directory", (Throwable)e);
            isSuccess = false;
        }
        return isSuccess;
    }

    public boolean searchersReserveCommitPoints() {
        return false;
    }

    public String getDataHome(CoreDescriptor cd) throws IOException {
        Path dataDir;
        if (this.dataHomePath != null) {
            Path instanceDirLastPath = cd.getInstanceDir().getName(cd.getInstanceDir().getNameCount() - 1);
            dataDir = this.dataHomePath.resolve(instanceDirLastPath).resolve(cd.getDataDir());
        } else {
            dataDir = cd.getInstanceDir().resolve(cd.getDataDir());
        }
        assert (dataDir.isAbsolute());
        return dataDir.toString();
    }

    public void cleanupOldIndexDirectories(String dataDirPath, String currentIndexDirPath, boolean afterCoreReload) {
        File dataDir = new File(dataDirPath);
        if (!dataDir.isDirectory()) {
            log.debug("{} does not point to a valid data directory; skipping clean-up of old index directories.", (Object)dataDirPath);
            return;
        }
        final File currentIndexDir = new File(currentIndexDirPath);
        File[] oldIndexDirs = dataDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String fileName = file.getName();
                return file.isDirectory() && !file.equals(currentIndexDir) && (fileName.equals("index") || fileName.matches(DirectoryFactory.INDEX_W_TIMESTAMP_REGEX));
            }
        });
        if (oldIndexDirs == null || oldIndexDirs.length == 0) {
            return;
        }
        List<File> dirsList = Arrays.asList(oldIndexDirs);
        dirsList.sort(Collections.reverseOrder());
        int i = 0;
        if (afterCoreReload) {
            log.info("Will not remove most recent old directory after reload {}", (Object)oldIndexDirs[0]);
            i = 1;
        }
        log.info("Found {} old index directories to clean-up under {} afterReload={}", new Object[]{oldIndexDirs.length - i, dataDirPath, afterCoreReload});
        while (i < dirsList.size()) {
            File dir = dirsList.get(i);
            String dirToRmPath = dir.getAbsolutePath();
            try {
                if (this.deleteOldIndexDirectory(dirToRmPath)) {
                    log.info("Deleted old index directory: {}", (Object)dirToRmPath);
                } else {
                    log.warn("Delete old index directory {} failed.", (Object)dirToRmPath);
                }
            }
            catch (IOException ioExc) {
                log.error("Failed to delete old directory {} due to: ", (Object)dir.getAbsolutePath(), (Object)ioExc);
            }
            ++i;
        }
    }

    protected boolean deleteOldIndexDirectory(String oldDirPath) throws IOException {
        Path dirToRm = Path.of(oldDirPath, new String[0]);
        PathUtils.deleteDirectory((Path)dirToRm);
        return !Files.isDirectory(dirToRm, new LinkOption[0]);
    }

    public void initCoreContainer(CoreContainer cc) {
        this.coreContainer = cc;
        if (cc != null && cc.getConfig() != null) {
            this.dataHomePath = cc.getConfig().getSolrDataHome();
        }
    }

    protected Directory getBaseDir(Directory dir) {
        Directory baseDir = dir;
        while (baseDir instanceof FilterDirectory) {
            baseDir = ((FilterDirectory)baseDir).getDelegate();
        }
        return baseDir;
    }

    static DirectoryFactory loadDirectoryFactory(SolrConfig config, CoreContainer cc, String registryName) {
        DirectoryFactory dirFactory;
        PluginInfo info = config.getPluginInfo(DirectoryFactory.class.getName());
        if (info != null) {
            log.debug(info.className);
            dirFactory = config.getResourceLoader().newInstance(info, DirectoryFactory.class, true);
            dirFactory.initCoreContainer(cc);
            dirFactory.init(info.initArgs);
        } else {
            log.debug("solr.NRTCachingDirectoryFactory");
            dirFactory = new NRTCachingDirectoryFactory();
            dirFactory.initCoreContainer(cc);
        }
        return dirFactory;
    }

    public UpdateLog newDefaultUpdateLog() {
        return new UpdateLog();
    }

    public static enum DirContext {
        DEFAULT,
        META_DATA,
        REPLICATION,
        BACKUP;

    }
}

