/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.export;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.solr.common.MapWriter;
import org.apache.solr.handler.export.FieldWriter;
import org.apache.solr.handler.export.SortDoc;
import org.apache.solr.handler.export.SortValue;
import org.apache.solr.search.DocValuesIteratorCache;

class FloatFieldWriter
extends FieldWriter {
    private final String field;
    private final DocValuesIteratorCache.FieldDocValuesSupplier docValuesCache;

    public FloatFieldWriter(String field, DocValuesIteratorCache.FieldDocValuesSupplier docValuesCache) {
        this.field = field;
        this.docValuesCache = docValuesCache;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean write(SortDoc sortDoc, LeafReaderContext readerContext, MapWriter.EntryWriter ew, int fieldIndex) throws IOException {
        float val;
        SortValue sortValue = sortDoc.getSortValue(this.field);
        if (sortValue != null) {
            if (!sortValue.isPresent()) return false;
            val = ((Float)sortValue.getCurrentValue()).floatValue();
        } else {
            NumericDocValues vals = this.docValuesCache.getNumericDocValues(sortDoc.docId, readerContext.reader(), readerContext.ord);
            if (vals == null) return false;
            val = Float.intBitsToFloat((int)vals.longValue());
        }
        ew.put((CharSequence)this.field, val);
        return true;
    }
}

