/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.sis.feature.AbstractAssociation;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureType;
import org.apache.sis.feature.FieldType;
import org.apache.sis.feature.NamedFeatureType;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.metadata.Identifier;
import org.opengis.util.GenericName;

public class DefaultAssociationRole
extends FieldType {
    private static final long serialVersionUID = 1592712639262027124L;
    private volatile FeatureType valueType;
    private volatile transient String titleProperty;

    public DefaultAssociationRole(Map<String, ?> map, DefaultFeatureType defaultFeatureType, int n, int n2) {
        super(map, n, n2);
        ArgumentChecks.ensureNonNull("valueType", defaultFeatureType);
        this.valueType = defaultFeatureType;
    }

    public DefaultAssociationRole(Map<String, ?> map, GenericName genericName, int n, int n2) {
        super(map, n, n2);
        ArgumentChecks.ensureNonNull("valueType", genericName);
        this.valueType = new NamedFeatureType(genericName);
    }

    public final boolean isResolved() {
        FeatureType featureType = this.valueType;
        if (featureType instanceof NamedFeatureType) {
            FeatureType featureType2 = ((NamedFeatureType)featureType).resolved;
            if (featureType2 == null) {
                return false;
            }
            this.valueType = featureType2;
        }
        return true;
    }

    final boolean resolve(DefaultFeatureType defaultFeatureType, Collection<AbstractIdentifiedType> collection) {
        FeatureType featureType = this.valueType;
        if (featureType instanceof NamedFeatureType) {
            FeatureType featureType2 = ((NamedFeatureType)featureType).resolved;
            if (featureType2 == null) {
                GenericName genericName = featureType.getName();
                if (genericName.equals((Object)defaultFeatureType.getName())) {
                    featureType2 = defaultFeatureType;
                } else {
                    ArrayList<DefaultFeatureType> arrayList = new ArrayList<DefaultFeatureType>();
                    featureType2 = DefaultAssociationRole.search(defaultFeatureType, collection, genericName, arrayList);
                    if (featureType2 == null && (arrayList.isEmpty() || (featureType2 = DefaultAssociationRole.deepSearch(arrayList, genericName)) == null)) {
                        return false;
                    }
                }
                ((NamedFeatureType)featureType).resolved = featureType2;
            }
            this.valueType = featureType2;
        }
        return true;
    }

    private static DefaultFeatureType search(DefaultFeatureType defaultFeatureType, Collection<? extends AbstractIdentifiedType> collection, GenericName genericName, List<DefaultFeatureType> list) {
        if (collection == null) {
            collection = defaultFeatureType.getProperties(false);
        }
        for (AbstractIdentifiedType abstractIdentifiedType : collection) {
            FeatureType featureType;
            if (!(abstractIdentifiedType instanceof DefaultAssociationRole) || (featureType = ((DefaultAssociationRole)abstractIdentifiedType).valueType) instanceof NamedFeatureType) continue;
            if (genericName.equals((Object)featureType.getName())) {
                return (DefaultFeatureType)featureType;
            }
            list.add((DefaultFeatureType)featureType);
        }
        for (DefaultFeatureType defaultFeatureType2 : defaultFeatureType.getSuperTypes()) {
            if (genericName.equals((Object)defaultFeatureType2.getName())) {
                return defaultFeatureType2;
            }
            DefaultFeatureType defaultFeatureType3 = DefaultAssociationRole.search(defaultFeatureType2, null, genericName, list);
            if (defaultFeatureType3 == null) continue;
            return defaultFeatureType3;
        }
        return null;
    }

    private static DefaultFeatureType deepSearch(List<DefaultFeatureType> list, GenericName genericName) {
        IdentityHashMap<DefaultFeatureType, Boolean> identityHashMap = new IdentityHashMap<DefaultFeatureType, Boolean>(8);
        int n = 0;
        while (n < list.size()) {
            DefaultFeatureType defaultFeatureType;
            if (identityHashMap.put(defaultFeatureType = list.get(n++), Boolean.TRUE) != null) continue;
            list.subList(0, n).clear();
            defaultFeatureType = DefaultAssociationRole.search(defaultFeatureType, null, genericName, list);
            if (defaultFeatureType != null) {
                return defaultFeatureType;
            }
            n = 0;
        }
        return null;
    }

    public final DefaultFeatureType getValueType() {
        FeatureType featureType = this.valueType;
        if (featureType instanceof NamedFeatureType) {
            featureType = ((NamedFeatureType)featureType).resolved;
            if (featureType == null) {
                throw new IllegalStateException(Resources.format((short)71, this.getName()));
            }
            this.valueType = featureType;
        }
        return (DefaultFeatureType)featureType;
    }

    static GenericName getValueTypeName(DefaultAssociationRole defaultAssociationRole) {
        return defaultAssociationRole.valueType.getName();
    }

    static String getTitleProperty(DefaultAssociationRole defaultAssociationRole) {
        String string = defaultAssociationRole.titleProperty;
        if (string != null) {
            return string.isEmpty() ? null : string;
        }
        string = DefaultAssociationRole.searchTitleProperty(defaultAssociationRole.getValueType());
        defaultAssociationRole.titleProperty = string != null ? string : "";
        return string;
    }

    private static String searchTitleProperty(DefaultFeatureType defaultFeatureType) {
        String string = null;
        try {
            return defaultFeatureType.getProperty("sis:identifier").getName().toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            for (AbstractIdentifiedType abstractIdentifiedType : defaultFeatureType.getProperties(true)) {
                DefaultAttributeType defaultAttributeType;
                Class clazz;
                if (!(abstractIdentifiedType instanceof DefaultAttributeType) || !CharSequence.class.isAssignableFrom(clazz = (defaultAttributeType = (DefaultAttributeType)abstractIdentifiedType).getValueClass()) && !GenericName.class.isAssignableFrom(clazz) && !Identifier.class.isAssignableFrom(clazz)) continue;
                String string2 = defaultAttributeType.getName().toString();
                if (defaultAttributeType.getMaximumOccurs() != 0) {
                    return string2;
                }
                if (string != null) continue;
                string = string2;
            }
            return string;
        }
    }

    @Override
    public final int getMinimumOccurs() {
        return super.getMinimumOccurs();
    }

    @Override
    public final int getMaximumOccurs() {
        return super.getMaximumOccurs();
    }

    public AbstractAssociation newInstance() {
        return AbstractAssociation.create(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.valueType.getName().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            DefaultAssociationRole defaultAssociationRole = (DefaultAssociationRole)object;
            return this.valueType.equals(defaultAssociationRole.valueType);
        }
        return false;
    }

    public String toString() {
        return DefaultAssociationRole.toString(this.deprecated, "FeatureAssociationRole", this.getName(), this.valueType.getName()).toString();
    }
}

