/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.spatial.ShapeValues;
import org.apache.lucene.spatial.ShapeValuesSource;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.DistanceCalculator;
import org.locationtech.spatial4j.shape.Point;

public class DistanceToShapeValueSource
extends DoubleValuesSource {
    private final ShapeValuesSource shapeValueSource;
    private final Point queryPoint;
    private final double multiplier;
    private final DistanceCalculator distCalc;
    private final double nullValue;

    public DistanceToShapeValueSource(ShapeValuesSource shapeValueSource, Point queryPoint, double multiplier, SpatialContext ctx) {
        this.shapeValueSource = shapeValueSource;
        this.queryPoint = queryPoint;
        this.multiplier = multiplier;
        this.distCalc = ctx.getDistCalc();
        this.nullValue = ctx.isGeo() ? 180.0 * multiplier : Double.MAX_VALUE;
    }

    public String toString() {
        return "distance(" + String.valueOf(this.queryPoint) + " to " + this.shapeValueSource.toString() + ")*" + this.multiplier + ")";
    }

    public DoubleValues getValues(LeafReaderContext readerContext, DoubleValues scores) throws IOException {
        final ShapeValues shapeValues = this.shapeValueSource.getValues(readerContext);
        return DoubleValues.withDefault((DoubleValues)new DoubleValues(){

            public double doubleValue() throws IOException {
                return DistanceToShapeValueSource.this.distCalc.distance(DistanceToShapeValueSource.this.queryPoint, shapeValues.value().getCenter()) * DistanceToShapeValueSource.this.multiplier;
            }

            public boolean advanceExact(int doc) throws IOException {
                return shapeValues.advanceExact(doc);
            }
        }, (double)this.nullValue);
    }

    public boolean needsScores() {
        return false;
    }

    public boolean isCacheable(LeafReaderContext ctx) {
        return this.shapeValueSource.isCacheable(ctx);
    }

    public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DistanceToShapeValueSource that = (DistanceToShapeValueSource)((Object)o);
        if (!this.queryPoint.equals(that.queryPoint)) {
            return false;
        }
        if (Double.compare(that.multiplier, this.multiplier) != 0) {
            return false;
        }
        if (!this.shapeValueSource.equals(that.shapeValueSource)) {
            return false;
        }
        return this.distCalc.equals(that.distCalc);
    }

    public int hashCode() {
        int result = this.shapeValueSource.hashCode();
        result = 31 * result + this.queryPoint.hashCode();
        long temp = Double.doubleToLongBits(this.multiplier);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

