/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.extraction;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.Utils;
import org.apache.solr.handler.extraction.ExtractionMetadata;
import org.apache.solr.handler.extraction.XmlSanitizingReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TikaServerParser {
    private final SAXParser saxParser;

    public TikaServerParser() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.saxParser = factory.newSAXParser();
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    public void parseXml(InputStream inputStream, ContentHandler handler, ExtractionMetadata metadata) throws IOException, SAXException {
        TikaXmlResponseSaxContentHandler xmlHandler = new TikaXmlResponseSaxContentHandler(handler, metadata);
        try (XmlSanitizingReader reader = new XmlSanitizingReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            this.saxParser.parse(new InputSource(reader), (DefaultHandler)xmlHandler);
        }
    }

    void parseRmetaJson(InputStream jsonStream, DefaultHandler handler, ExtractionMetadata md) throws IOException, SAXException {
        Object parsed = Utils.fromJSON((InputStream)jsonStream);
        if (!(parsed instanceof List)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unexpected /rmeta response, expected JSON array");
        }
        List list = (List)parsed;
        for (Object o : list) {
            String xhtml;
            if (!(o instanceof Map)) continue;
            Map map = (Map)o;
            for (Object k : map.keySet()) {
                String key = String.valueOf(k);
                Object val = map.get(k);
                if ("X-TIKA:content".equalsIgnoreCase(key)) continue;
                if (val instanceof List) {
                    for (Object v : (List)val) {
                        if (v == null) continue;
                        md.add(key, String.valueOf(v));
                    }
                    continue;
                }
                if (val == null) continue;
                md.add(key, String.valueOf(val));
            }
            Object content = map.get("X-TIKA:content");
            if (content == null || (xhtml = String.valueOf(content)).isEmpty() || handler == null) continue;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xhtml.getBytes(StandardCharsets.UTF_8));
            try (XmlSanitizingReader reader = new XmlSanitizingReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));){
                this.saxParser.parse(new InputSource(reader), handler);
            }
        }
    }

    static class TikaXmlResponseSaxContentHandler
    extends DefaultHandler {
        private final ContentHandler delegate;
        private final ExtractionMetadata metadata;
        private boolean inHead = false;

        public TikaXmlResponseSaxContentHandler(ContentHandler delegate, ExtractionMetadata metadata) {
            this.delegate = delegate;
            this.metadata = metadata;
        }

        @Override
        public void startDocument() throws SAXException {
            if (this.delegate != null) {
                this.delegate.startDocument();
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.delegate != null) {
                this.delegate.endDocument();
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String ln;
            String string = ln = localName != null && !localName.isEmpty() ? localName : qName;
            if ("head".equalsIgnoreCase(ln)) {
                this.inHead = true;
            } else if (this.inHead && "meta".equalsIgnoreCase(ln) && attributes != null) {
                String name = attributes.getValue("name");
                String content = attributes.getValue("content");
                if (name != null && content != null) {
                    this.metadata.add(name, content);
                }
            }
            if (this.delegate != null) {
                this.delegate.startElement(uri, localName, qName, attributes);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String ln;
            String string = ln = localName != null && !localName.isEmpty() ? localName : qName;
            if ("head".equalsIgnoreCase(ln)) {
                this.inHead = false;
            }
            if (this.delegate != null) {
                this.delegate.endElement(uri, localName, qName);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.delegate != null) {
                this.delegate.characters(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.delegate != null) {
                this.delegate.ignorableWhitespace(ch, start, length);
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (this.delegate != null) {
                this.delegate.startPrefixMapping(prefix, uri);
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            if (this.delegate != null) {
                this.delegate.endPrefixMapping(prefix);
            }
        }
    }
}

