# Modern

## Introduction

The modern sky culture is used internationally by modern astronomers, and is the official scheme of The International Astronomical Union. It has historical roots in Ancient Greek astronomy, with influences from Islamic astronomy.

## Description

The modern sky culture divides the celestial sphere into 88 areas of various sizes called constellations, each with precise boundary, issued by the International Astronomical Union in 1922. These constellations have become the standard way to describe the sky, replacing similar sets in other sky cultures exhaustively in daily usage.

The constellations in use today are based mainly on ancient Greek constellations depicted by Ptolemy in his book the Almagest during the 2nd century CE. In the subsequent centuries, this book has been translated from Greek into Arabic (6th to 9th century) and later to medieval Latin. In the Arabic more than in the Latin tradition, the Ptolemaic figures were enriched and transformed by native Arabic constellations and star names.

In the 16-18th centuries, European astronomers suggested new constellations to fill the gaps between northern constellations (e.g. the constellation of "the lynx" for an area close to the Great Bear but with stars so faint that you would need the eyes of a lynx to see them) and also created new constellations in the southern part of the sky which had not been visible to Ptolemy. These new constellations were usually named after new technical inventions of the early modern period (e.g. a chemical furnace, a balloon, an air pump) or exotic animals (e.g. a chamaeleon, a tucan, a paradise bird). Among them several constellations were also named with political consideration to honor certain kings or patrons.

In the beginning of the 20th century, the IAU (International Astronomical Union) aimed for a large clean-up: in 1922, it officially accepted the list of 88 constellation names. In 1928 it also defined precise constellation boundaries [#40] still in use today.

### Extras

In the 2nd century CE, Ptolemy in Alexandria published a multi-volume book which summarised the astronomical knowledge of the time, rooted in a tradition of mathematical astronomy since Hipparchus (at least 265 years earlier). In the subsequent centuries, this book has been translated from Greek into Arabic (6th to 9th century), from Arabic into Latin, and later, from the original ancient Greek into medieval Latin. Due to this transformation, it is now known under the artificial name Almagest, derived from the Arabic title [#46].

The Almagest star catalogue (books VII and VIII) has been depicted many times in the Islamic as well as in the Christian astronomical traditions. Often, the figures were re-drawn in order to adapt them to the taste of art of the epoch. In the Arabic more than in the Latin tradition, the Ptolemaic figures were enriched and transformed by native Arabic constellations and star names. Therefore, this sky culture displays a modern descendant of the Ptolemaic one with traces of translations, misunderstandings, transformations, and deliberate additions.

In 1603 the lawyer and hobby astronomer Johann Bayer from Augsburg, Germany, made a new celestial atlas, called Uranometria [#41]. In this atlas, he introduced a systematic naming of stars starting with alpha, the brightest, beta, the second brightest, gamma, the third ... within a constellation. Subsequently, it was established to name a star with a Greek letter and the Latin constellation name in casus genitive.

In the 18th century, the century of great atlases (Flamsteed, Fortin, Bode: [#42][#43]), new constellations were added to fill the gaps between northern constellations. Additionally, there were suggestions to create new constellations in the southern part of the sky which had not been visible to Ptolemy. European astronomers visited the European colonies and instead of asking the native people for their constellations, the Europeans were creative. This way, many new technical inventions of the early modern period were depicted in constellations (e.g. a chemical furnace, a balloon, an air pump) as well as exotic animals (e.g. a chamaeleon, a tucan, a paradise bird).

The problem was that sometimes astronomers did not agree with each other and, thus, atlases showed deviations from each other.

After many centuries of astronomers taking liberties in interpretation of the Ptolemaic original, there were many variants of constellations. As constellations are a positioning system, i.e. astronomers describe positions in the sky relative to stars and stars relative to constellations (like "Betelgeuse", Orion's right shoulder), it is necessary to use constellation names and star names uniformly all over the world.

In the "Fin de siècle", there were upcoming suggestions in the astronomical community to unify the system of constellations and star names [#44].

The IAU, only founded in 1919, in 1928 defined the boundaries of these areas [#43] and not the way of drawing artwork or connecting lines within them. Consequently several sub-cultures of painting figures and drawing simplified stickfigures were developed during the 20th and 21st century. We provide some of them as further sky cultures.

### Constellations

These constellations are based mainly on the Ptolemaic tradition which had been used in all three Abrahamitic religions and, thus, was common in the Near East, in Europe and its colonies on all continents. However, between the ancient Greek constellations there were gaps of areas with only faint stars belonging to no constellation.[#47] In the Modern Epoch, several astronomers suggested constellation figures for these gaps, among them several political constellations to the honor of certain kings or patrons. In the late 19th century, the astronomical research community aimed for a huge clean-up to avoid ambiguities in assigning stars to constellations.

In 1922, the IAU officially approved the list of 88 constellation names and their official abbreviations with three letters. The only remaining political constellation is Scutum, the shield of a Polish king but without mentioning the political reference anymore. The Belgian priest E. Delporte got the task to define constellation boundaries according to coordinates. In 1928, he finished the work, based on an atlas from Argentina [#51], and the IAU accepted his delimitations [#40].

These "constellations" are naked areas in the sky without any stick figures or depictions [#44]. The borders simply follow the lines of right ascension and declination from the epoch 1875.0. Precession causes a slowly increasing deviation from the originally rectilinear grid. These constellations became the standard way to describe the sky, replacing similar sets in other sky cultures exhaustively in daily usage.

Stellarium by default displays the precise RA-DEC-boundaries and a set of artwork constellations on the basis of Ptolemaic figures but following our contemporary taste of art.

### Asterisms

The term "asterism" (assembly of stars) can sometimes be used synonymously to "constellation". In the modern use it describes a figure which is not part of the official canon. Sometimes an asterism is a part of a constellation, e.g. the Big Dipper as part of Ursa Major, or Great Square as part of Pegasus. Other asterisms span over several constellations, e.g. the Summer Triangle or Winter Hexagon. Yet others are only visible in binoculars or telescopes and are aptly named "telescopic asterism", e.g. the Coathanger. They are often discussed in the observing columns of popular astronomy magazines.

### Ray Helpers

Seasoned observers can find their way around the sky easily. One mnemonic tool are associative chains of stars that span large distances. We show them as "ray helpers". These are not standardized.

### Proper names of stars

Ptolemy's star catalogue had the layout of a table listing the description of the star's position in the constellation's figure, the ecliptical coordinates, and the magnitude e.g.: "The star at the tip of the tail of Ursa Minor", "Gem 0 1/6, +66", "Mag 3".

In most cases, the star names evolved by astronomer's systematical abbreviations of these descriptions, e.g., a first astronomer abbreviated in a text "tip of the tail", a next astronomer drew a map with less space and wrote only "tail" next to the star and this name remained. Over centuries, these descriptions were translated into Arabic and Latin, and in some cases the translators or scribes made mistakes because of misreading or misspelling of the Arabic words (e.g. the Arabic "yad al gauza", the hand of the giant woman, was mangled to the common term "Betelgeuse").

However, there are also a few original Greek words like the red star "Antares", the counterpart of Ares (Mars), and even a few original Babylonian terms like "Shargaz", the Sting, in Scorpius. Our modern, most recent IAU star names [#45] are a renewed mixture, also with influences or even politically wanted additions of star names from the non-Ptolemaic sky cultures, e.g. the traditional Pingsing, a Chinese star name for a star in Hydra (its meaning is only "star", a reminescence to his lonely position), or newly adopted star names from Polynesian, Hawaiian, or Aboriginal cultures for names of stars with exoplanets.

The IAU is the only scientifically accepted authority to assign new names to stars. Commercial exploits like "star name registries", who sell stars for commemorative purposes or as gifts, only sell printed pieces of paper. These names are not approved and never used by scientists.

## References

 - [#1]: Kunitzsch, P.; Smart T. (2006). "A Dictionary of Modern star Names: A Short Guide to 254 Star Names and Their Derivations" (2nd rev. ed.). Cambridge, MA: Sky Pub. ISBN 978-1-931559-44-7.
 - [#2]: Allen, R. H. (1963). "Star Names: Their Lore and Meaning" (rep. ed.). New York, NY: Dover Publications Inc. ISBN 0-486-21079-0.
 - [#3]: [2000, A&AS, 143, 9, "The SIMBAD astronomical database", Wenger et al.](http://adsabs.harvard.edu/abs/2000A%26AS..143....9W)
 - [#4]: [Final Results of NameExoWorlds Public Vote Released](http://www.iau.org/news/pressreleases/detail/iau1514/)
 - [#5]: [STARS by Jim Kaler, Prof. Emeritus of Astronomy, University of Illinois](http://stars.astro.illinois.edu/sow/sowlist.html)
 - [#6]: [IAU Catalog of Star Names (IAU-CSN)](http://www.pas.rochester.edu/~emamajek/WGSN/IAU-CSN.txt)
 - [#7]: [Covington, Michael (2002). "Celestial Objects for Modern Telescopes: Practical Amateur Astronomy". Cambridge University Press.](https://books.google.com/books?id=ql7wLq1fP5QC&pg=PA209)
 - [#8]: ["61 Cyg (Piazzi's Flying Star)". Science&Space News. Retrieved June 1, 2015.](http://news.sky-map.org/starview?object_type=1&object_id=2282&object_name=HD+201091&locale=EN)
 - [#9]: [Kruger 60](https://en.wikipedia.org/wiki/Kruger_60)
 - [#10]: [List of Named Stars in Alphabetical Order](https://web.archive.org/web/20220701073320/http://www.astro.wisc.edu/~dolan/constellations/starname_list.html)
 - [#11]: [Jack W. Rhoads (1971). "Reduced Star Catalog Containing 537 Named Stars", Jet Propulsion Laboratory, California Institute of Technology; November 15, 1971](https://ntrs.nasa.gov/citations/19720005197)
 - [#12]: [IAU Naming Stars](https://www.iau.org/public/themes/naming_stars/)
 - [#13]: [Bright Star Catalogue, 5th Revised Ed. (Hoffleit+, 1991)](http://vizier.u-strasbg.fr/viz-bin/VizieR?-source=V/50)
 - [#14]: Piazzi, G, ed. (1814). "Praecipuarum Stellarum Inerrantium Positiones Mediae Ineunte Saeculo XIX: ex Observationibus Habitis in Specula Panormitana ab anno 1792 ad annum 1813". Palermo. p. 21.
 - [#15]: Kunitzsch, P. (1959). "Arabische Sternnamen in Europa". Wiesbaden: Otto Harrassowitz. p. 155.
 - [#16]: Laffitte, R. (2005). "Héritages arabes: Des noms arabes pour les étoiles" (2éme revue et corrigée ed.). Paris: Librairie Orientaliste Paul Geunthner / Les Cahiers de l'Orient. p. 229.
 - [#17]: Burritt, E. H. (1835). "Atlas, Designed to Illustrate the Geography of the Heavens" (new ed.). New York: F. J. Huntington. plate III.
 - [#18]: Burnham, Robert Jr. (1978, 1979). "Burnham's Celestial Handbook: An Observer's Guide to the Universe Beyond the Solar System", Vol. 1, 2, 3. NY: Dover Publications. ISBN 978-0486235677, 978-0486235684, 978-0486236735
 - [#19]: [Iota Ursae Majoris](https://en.wikipedia.org/wiki/Iota_Ursae_Majoris)
 - [#20]: [Falkner, David E. (2011). "The Mythology of the Night Sky: An Amateur Astronomer's Guide to the Ancient Greek and Roman Legends", Patrick Moore's Practical Astronomy, Springer. ISBN 1-4614-0136-4](https://books.google.com/books?id=tyj8UUE968wC)
 - [#21]: Peters, C. A. F. (1853). "On the Parallax of Argelander's Star". Monthly Notices of the Royal Astronomical Society, Vol. 14, p.49. DOI: 10.1093/mnras/14.2.49
 - [#22]: Maddocks, Hugh C. (1991). "Deep-Sky Name Index 2000.0". Foxon-Maddocks Associates. ISBN 0-9628305-0-X.
 - [#23]: Josef Klepesta, Antonin Rükl (1977). "Constellations: A concise guide in colour". ISBN 0600008932.
 - [#24]: Oswald Thomas (1945). "Atlas der Sternbilder". Das Bergland-Buch, Salzburg.
 - [#25]: Fred Schaaf (2019). "An Assortment of Asterisms". Sky & Telescope, p.45 (Nov 2019)
 - [#26]: Gary Seronik (2017). "Binocular Highlights Revised & Expanded: 109 Celestial Sights for Binocular Users". F W Publications Inc. ISBN 9781940038445
 - [#27]: Tony Flanders (2019). "Constellation Close-up: Centaurus and Crux". Sky & Telescope, pp.22-27 (Apr 2019).
 - [#28]: Sue French (2019). "Deep-Sky Wonders: Heavenly Hero". Sky & Telescope, pp.54-56 (Jul 2019).
 - [#29]: [Software Bisque: A Complete List of Asterisms](https://www.bisque.com/tom/asterisms/list.asp)
 - [#30]: [University of Northern Iowa, EARTHSCI 1100 - Astronomy, Asterisms.](https://sites.uni.edu/morgans/astro/asterisms.html)
 - [#31]: [Horvatin - Obsolete Constellations, Department of Physics and Astronomy, Michigan State University.](https://web.pa.msu.edu/people/horvatin/Astronomy_Facts/obsolete_pages/triangulum_minor.htm)
 - [#32]: [Donald H. Menzel (1964). A Field Guide to the Stars and Planets by Donald H. Menzel, Collins books - St. James's Place, London. ISBN: 0395934311, ISBN13: 9780395934319](http://www.arvindguptatoys.com/arvindgupta/menzel-fieldguide.pdf)
 - [#33]: [James B. (Jim) Kaler. Professor Emeritus of Astronomy, University of Illinois.](http://stars.astro.illinois.edu/sow/6tri.html)
 - [#34]: [Astronomy Club of Tulsa - Observer, December 2008.](http://www.astrotulsa.com/cms_files/200812.pdf)
 - [#35]: [Baylor University, School of Engineering and Computer Science, Astronomy observing log.](http://cs.baylor.edu/~hamerly/personal/astro/log.html)
 - [#36]: [IAU100 NameExoWorlds](http://nameexoworlds.iau.org/)
 - [#37]: [The Washington Double Star Catalog (Mason+ 2001-2020)](https://vizier.u-strasbg.fr/viz-bin/VizieR?-source=B/wds)
 - [#38]: [Patrick Moore, Paul Doherty, H. J. P. Arnold, The Photographic Atlas of the Stars, CRC Press LLC, 1999. ISBN 0750306548 (EXCLUDED (too many typos))](https://books.google.com/books?id=YjcvJUfnWBAC&pg=PA97#v=onepage&q&f=false)
 - [#39]: [Guy Consolmagno, Dan M. Davis, Turn Left at Orion, Cambridge University Press, 2019. ISBN 9781108558464](https://doi.org/10.1017/9781108558464)
 - [#40]: Delporte, Eugene (1930). "Delimitation scientifique des constellations (tables et cartes)". Cambridge.
 - [#41]: facsimile: Uranometria von Johannes Bayer, Kunstschätzeverlag, Gerchsheim, 2010
 - [#42]: facsimile: Die große Flamsteed Edition - Himmelskartographie nach John Flamsteed von 1776 bis 1805, Albireo Verlag, Köln, 2017
 - [#43]: Latußeck, Arndt and Hoffmann, Susanne M: "Ein nützliches Unternehmen", Albireo Verlag, Köln, 2017
 - [#44]: [Constellation english names. IAU Constellations Page](https://www.iau.org/public/themes/constellations/)
 - [#45]: [IAU Working Group Star Names. WGSN](https://www.iau.org/science/scientific_bodies/working_groups/280/)
 - [#46]: Grasshoff, Gerd: The History of Ptolemy's Star Catalogue, Springer, New York, 1990
 - [#47]: Hoffmann, Susanne M.: Hipparchs Himmelsglobus, Springer, Wiesbaden / New York, 2017
 - [#48]: [Constellation. Article on Wikipedia](http://en.wikipedia.org/wiki/Constellation)
 - [#49]: [Star Catalogue. Article on Wikipedia](http://en.wikipedia.org/wiki/Star_catalogue)
 - [#50]: [Constellation image library of the U.S. Naval Observatory and the Space Telescope Science Institute. Johannes Hevelius Engravings.](http://hubblesource.stsci.edu/sources/illustrations/constellations/)
 - [#51]: Santiago Paolantonio, Beatriz García (2019). "Uranometría Argentina and the constellation boundaries". Under One Sky: The IAU Centenary Symposium. Cambridge. p. 505.
 - [#52]: Meade Instruction Manual 7" LX200 Maksutov-Cassegrain Telescope; 8", 10", and 12" LX200 Schmidt-Cassegrain Telescopes
 - [#53]: [Mike Wall (2013). "Strange 'Methuselah' Star Looks Older Than the Universe". Space.com](https://www.space.com/20112-oldest-known-star-universe.html)
 - [#54]: [Space Telescope Science Institute (STScI). "Hubble finds 'birth certificate' of oldest known star." ScienceDaily. ScienceDaily, 7 March 2013](www.sciencedaily.com/releases/2013/03/130307145103.htm)
 - [#55]: [Atlas Coeli Skalnaté Pleso 1950.0](https://en.wikipedia.org/wiki/Skalnate_Pleso_Atlas_of_the_Heavens)
 - [#56]: [Karlseiche](https://de.wikipedia.org/wiki/Karlseiche)
 - [#57]: [Mural Quadrant](https://de.wikipedia.org/wiki/Mauerquadrant_(Sternbild))
 - [#58]: WAA/Alexander Pikhard. Own creation, 2001. https://www.waa.at/bericht/2001/06_sofiexp/20010612/bb20010612.html. 

## Authors

Stellarium's team

## License

Text and data: CC BY-SA 4.0

Illustrations: Free Art License
