/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.res.StringManager;

public class IdentityInputFilter
implements InputFilter,
ApplicationBufferHandler {
    private static final StringManager sm = StringManager.getManager(IdentityInputFilter.class);
    protected static final String ENCODING_NAME = "identity";
    protected static final ByteChunk ENCODING = new ByteChunk();
    protected long contentLength = -1L;
    protected long remaining = 0L;
    protected InputBuffer buffer;
    protected ByteBuffer tempRead;
    private final int maxSwallowSize;

    public IdentityInputFilter(int n) {
        this.maxSwallowSize = n;
    }

    @Override
    public int doRead(ApplicationBufferHandler applicationBufferHandler) throws IOException {
        int n;
        if (this.contentLength >= 0L) {
            if (this.remaining > 0L) {
                int n2 = this.buffer.doRead(applicationBufferHandler);
                if ((long)n2 > this.remaining) {
                    applicationBufferHandler.getByteBuffer().limit(applicationBufferHandler.getByteBuffer().position() + (int)this.remaining);
                    n = (int)this.remaining;
                } else {
                    n = n2;
                }
                if (n2 > 0) {
                    this.remaining -= (long)n2;
                }
            } else {
                if (applicationBufferHandler.getByteBuffer() != null) {
                    applicationBufferHandler.getByteBuffer().position(0).limit(0);
                }
                n = -1;
            }
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public void setRequest(Request request) {
        this.remaining = this.contentLength = request.getContentLengthLong();
    }

    @Override
    public long end() throws IOException {
        boolean bl = this.maxSwallowSize > -1 && this.remaining > (long)this.maxSwallowSize;
        long l = 0L;
        while (this.remaining > 0L) {
            int n = this.buffer.doRead(this);
            this.tempRead = null;
            if (n > 0) {
                this.remaining -= (long)n;
                if (!bl || (l += (long)n) <= (long)this.maxSwallowSize) continue;
                throw new IOException(sm.getString("inputFilter.maxSwallow"));
            }
            this.remaining = 0L;
        }
        return -this.remaining;
    }

    @Override
    public int available() {
        return this.buffer.available();
    }

    @Override
    public void setBuffer(InputBuffer inputBuffer) {
        this.buffer = inputBuffer;
    }

    @Override
    public void recycle() {
        this.contentLength = -1L;
        this.remaining = 0L;
    }

    @Override
    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    @Override
    public boolean isFinished() {
        return this.contentLength > -1L && this.remaining <= 0L;
    }

    @Override
    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.tempRead = byteBuffer;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.tempRead;
    }

    @Override
    public void expand(int n) {
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(StandardCharsets.ISO_8859_1), 0, ENCODING_NAME.length());
    }
}

