/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import net.sf.json.JSONObject;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.zaproxy.zap.authentication.AbstractCredentialsOptionsPanel;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.authentication.TotpAuthenticationCredentials;
import org.zaproxy.zap.authentication.TotpTabbedPane;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.EncodingUtils;
import org.zaproxy.zap.view.DynamicFieldsPanel;

public class GenericAuthenticationCredentials
extends TotpAuthenticationCredentials {
    private static final String API_NAME = "GenericAuthenticationCredentials";
    private static final String FIELD_SEPARATOR = "~";
    private String[] paramNames;
    private Map<String, String> paramValues;
    private static final String ACTION_SET_CREDENTIALS = "scriptBasedAuthenticationCredentials";
    private static final String PARAM_CONFIG_PARAMS = "authenticationCredentialsParams";

    public GenericAuthenticationCredentials(String[] paramNames) {
        this(paramNames, false);
    }

    public GenericAuthenticationCredentials(String[] paramNames, boolean enableTotp) {
        super(enableTotp);
        this.paramNames = paramNames;
        this.paramValues = new HashMap<String, String>(paramNames.length);
    }

    public String getParam(String paramName) {
        return this.paramValues.get(paramName);
    }

    public String setParam(String paramName, String paramValue) {
        return this.paramValues.put(paramName, paramValue);
    }

    @Override
    public boolean isConfigured() {
        return true;
    }

    @Override
    public String encode(String parentFieldSeparator) {
        StringBuilder out = new StringBuilder();
        out.append(EncodingUtils.mapToString(this.paramValues)).append(FIELD_SEPARATOR);
        this.encodeTotpData(out, FIELD_SEPARATOR);
        return out.toString();
    }

    @Override
    public void decode(String encodedCredentials) {
        String[] pieces = encodedCredentials.split(FIELD_SEPARATOR);
        this.paramValues = EncodingUtils.stringToMap(pieces[0]);
        this.paramNames = this.paramValues.keySet().toArray(new String[this.paramValues.size()]);
        if (pieces.length > 1) {
            this.decodeTotpData(Arrays.asList(pieces).subList(1, pieces.length));
        }
    }

    @Override
    public ApiResponse getApiResponseRepresentation() {
        HashMap<String, Object> values = new HashMap<String, Object>(this.paramValues);
        values.put("type", API_NAME);
        this.setTotpData(values);
        return new ApiResponseSet<Object>("credentials", values);
    }

    public static ApiDynamicActionImplementor getSetCredentialsForUserApiAction(final AuthenticationMethodType methodType) {
        TotpAuthenticationCredentials totpCreds;
        List<String> optionalParameters = new ArrayList<String>();
        optionalParameters.add(PARAM_CONFIG_PARAMS);
        AuthenticationCredentials authenticationCredentials = methodType.createAuthenticationCredentials();
        if (authenticationCredentials instanceof TotpAuthenticationCredentials && (totpCreds = (TotpAuthenticationCredentials)authenticationCredentials).isTotpEnabled()) {
            optionalParameters = TotpAuthenticationCredentials.getApiParameters();
        }
        return new ApiDynamicActionImplementor(ACTION_SET_CREDENTIALS, null, optionalParameters){

            @Override
            public void handleAction(JSONObject params) throws ApiException {
                Context context = ApiUtils.getContextByParamId(params, "contextId");
                int userId = ApiUtils.getIntParam(params, "userId");
                if (!methodType.isTypeForMethod(context.getAuthenticationMethod())) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "User's credentials should match authentication method type of the context: " + context.getAuthenticationMethod().getType().getName());
                }
                ExtensionUserManagement extensionUserManagement = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
                User user = extensionUserManagement.getContextUserAuthManager(context.getId()).getUserById(userId);
                if (user == null) {
                    throw new ApiException(ApiException.Type.USER_NOT_FOUND, "userId");
                }
                GenericAuthenticationCredentials credentials = (GenericAuthenticationCredentials)context.getAuthenticationMethod().createAuthenticationCredentials();
                for (String paramName : credentials.paramNames) {
                    credentials.setParam(paramName, ApiUtils.getNonEmptyStringParam(params, paramName));
                }
                credentials.readTotpData(params);
                user.setAuthenticationCredentials(credentials);
            }
        };
    }

    protected static class GenericAuthenticationCredentialsOptionsPanel
    extends AbstractCredentialsOptionsPanel<GenericAuthenticationCredentials> {
        private static final long serialVersionUID = -6486907666459197059L;
        private DynamicFieldsPanel fieldsPanel;
        private TotpTabbedPane totpTabbedPane;

        public GenericAuthenticationCredentialsOptionsPanel(GenericAuthenticationCredentials credentials) {
            super(credentials);
            this.initialize();
        }

        private void initialize() {
            this.setLayout(new BorderLayout());
            this.fieldsPanel = new DynamicFieldsPanel(((GenericAuthenticationCredentials)this.credentials).paramNames);
            this.fieldsPanel.bindFieldValues(((GenericAuthenticationCredentials)this.credentials).paramValues);
            if (((GenericAuthenticationCredentials)this.getCredentials()).isTotpEnabled()) {
                this.totpTabbedPane = new TotpTabbedPane(this.fieldsPanel);
                this.totpTabbedPane.setTotpData(((GenericAuthenticationCredentials)this.getCredentials()).getTotpData());
                this.add(this.totpTabbedPane);
            } else {
                this.add(this.fieldsPanel);
            }
        }

        @Override
        public boolean validateFields() {
            try {
                this.fieldsPanel.validateFields();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), Constant.messages.getString("authentication.method.fb.dialog.error.title"), 2);
                return false;
            }
            return true;
        }

        @Override
        public void saveCredentials() {
            ((GenericAuthenticationCredentials)this.credentials).paramValues = new HashMap<String, String>(this.fieldsPanel.getFieldValues());
            if (this.totpTabbedPane != null) {
                ((GenericAuthenticationCredentials)this.credentials).setTotpData(this.totpTabbedPane.getTotpData());
            }
        }
    }
}

