// Copyright 2026 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   qtwebengine/common/extensions/api/tabs.json
// by tools/json_schema_compiler.
// DO NOT EDIT.

#ifndef QTWEBENGINE_COMMON_EXTENSIONS_API_TABS_H__
#define QTWEBENGINE_COMMON_EXTENSIONS_API_TABS_H__

#include <stdint.h>

#include <map>
#include <memory>
#include <optional>
#include <string>
#include <vector>

#include "base/values.h"

namespace extensions {
namespace api {
namespace tabs {

//
// Properties
//

// An ID that represents the absence of a browser tab.
extern const int TAB_ID_NONE;

//
// Types
//

struct Tab {
  Tab();
  ~Tab();
  Tab(const Tab&) = delete;
  Tab& operator=(const Tab&) = delete;
  Tab(Tab&& rhs) noexcept;
  Tab& operator=(Tab&& rhs) noexcept;

  // Populates a Tab object from a base::Value& instance. Returns whether |out|
  // was successfully populated.
  static bool Populate(const base::Value& value, Tab& out);

  // Populates a Tab object from a Dict& instance. Returns whether |out| was
  // successfully populated.
  static bool Populate(const base::Value::Dict& value, Tab& out);

  // Creates a deep copy of Tab.
  Tab Clone() const;

  // Creates a Tab object from a base::Value::Dict, or nullopt on failure.
  static std::optional<Tab> FromValue(const base::Value::Dict& value);

  // Creates a Tab object from a base::Value, or nullopt on failure.
  static std::optional<Tab> FromValue(const base::Value& value);

  // Returns a new base::Value::Dict representing the serialized form of thisTab
  // object.
  base::Value::Dict ToValue() const;

  // The ID of the tab. Tab IDs are unique within a browser session.
  int id;

  // The zero-based index of the tab within its window.
  int index;

  // The ID of the window the tab is contained within.
  int window_id;

  // Whether the tab is selected.
  bool selected;

  // Whether the tab is highlighted.
  bool highlighted;

  // Whether the tab is active in its window.
  bool active;

  // Whether the tab is pinned.
  bool pinned;

  // The URL the tab is displaying.
  std::string url;

  // The title of the tab. This may not be available if the tab is loading.
  std::optional<std::string> title;

  // The URL of the tab's favicon. This may not be available if the tab is
  // loading.
  std::optional<std::string> fav_icon_url;

  // Either <em>loading</em> or <em>complete</em>.
  std::optional<std::string> status;

  // Whether the tab is in an incognito window.
  bool incognito;

};


//
// Functions
//

namespace Update {

struct Params {
  static std::optional<Params> Create(const base::Value::List& args);
  Params(const Params&) = delete;
  Params& operator=(const Params&) = delete;
  Params(Params&& rhs) noexcept;
  Params& operator=(Params&& rhs) noexcept;
  ~Params();

  struct UpdateProperties {
    UpdateProperties();
    ~UpdateProperties();
    UpdateProperties(const UpdateProperties&) = delete;
    UpdateProperties& operator=(const UpdateProperties&) = delete;
    UpdateProperties(UpdateProperties&& rhs) noexcept;
    UpdateProperties& operator=(UpdateProperties&& rhs) noexcept;

    // Populates a UpdateProperties object from a base::Value& instance. Returns
    // whether |out| was successfully populated.
    static bool Populate(const base::Value& value, UpdateProperties& out);

    // Populates a UpdateProperties object from a Dict& instance. Returns whether
    // |out| was successfully populated.
    static bool Populate(const base::Value::Dict& value, UpdateProperties& out);

    // Creates a deep copy of UpdateProperties.
    UpdateProperties Clone() const;

    // Creates a UpdateProperties object from a base::Value::Dict, or nullopt on
    // failure.
    static std::optional<UpdateProperties> FromValue(const base::Value::Dict& value);

    // Creates a UpdateProperties object from a base::Value, or nullopt on
    // failure.
    static std::optional<UpdateProperties> FromValue(const base::Value& value);

    // A URL to navigate the tab to. JavaScript URLs are not supported; use
    // $(ref:tabs.executeScript) instead.
    std::optional<std::string> url;

    // Whether the tab should be active. Does not affect whether the window is
    // focused (see $(ref:windows.update)).
    std::optional<bool> active;

    // Adds or removes the tab from the current selection.
    std::optional<bool> highlighted;

    // Whether the tab should be selected.
    std::optional<bool> selected;

    // Whether the tab should be pinned.
    std::optional<bool> pinned;

    // Whether the tab should be muted.
    std::optional<bool> muted;

    // The ID of the tab that opened this tab. If specified, the opener tab must be
    // in the same window as this tab.
    std::optional<int> opener_tab_id;

    // Whether the tab should be discarded automatically by the browser when
    // resources are low.
    std::optional<bool> auto_discardable;

  };


  // Defaults to the selected tab of the <a href='windows#current-window'>current
  // window</a>.
  std::optional<int> tab_id;

  UpdateProperties update_properties;


 private:
  Params();
};

namespace Results {

// Details about the updated tab. The $(ref:tabs.Tab) object does not contain
// <code>url</code>, <code>pendingUrl</code>, <code>title</code>, and
// <code>favIconUrl</code> if the <code>"tabs"</code> permission has not been
// requested.
base::Value::List Create(const Tab& tab);
}  // namespace Results

}  // namespace Update

}  // namespace tabs
}  // namespace api
}  // namespace extensions

#endif  // QTWEBENGINE_COMMON_EXTENSIONS_API_TABS_H__
