// services/data_decoder/public/mojom/json_parser.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_JSON_PARSER_MOJOM_PARAMS_DATA_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_JSON_PARSER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace data_decoder::mojom {
namespace internal {
class  JsonParser_Parse_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> json;
  uint32_t options;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<JsonParser_Parse_Params_Data>;

  JsonParser_Parse_Params_Data();
  ~JsonParser_Parse_Params_Data() = delete;
};
static_assert(sizeof(JsonParser_Parse_Params_Data) == 24,
              "Bad sizeof(JsonParser_Parse_Params_Data)");
class  JsonParser_Parse_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  ::mojo_base::mojom::internal::Value_Data result;
  mojo::internal::Pointer<mojo::internal::String_Data> error;

 private:
  friend class mojo::internal::MessageFragment<JsonParser_Parse_ResponseParams_Data>;

  JsonParser_Parse_ResponseParams_Data();
  ~JsonParser_Parse_ResponseParams_Data() = delete;
};
static_assert(sizeof(JsonParser_Parse_ResponseParams_Data) == 32,
              "Bad sizeof(JsonParser_Parse_ResponseParams_Data)");

}  // namespace internal


class JsonParser_Parse_ParamsDataView {
 public:
  JsonParser_Parse_ParamsDataView() = default;

  JsonParser_Parse_ParamsDataView(
      internal::JsonParser_Parse_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetJsonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadJson(UserType* output) {
    
    auto* pointer = data_->json.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t options() const {
    return data_->options;
  }
 private:
  internal::JsonParser_Parse_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class JsonParser_Parse_ResponseParamsDataView {
 public:
  JsonParser_Parse_ResponseParamsDataView() = default;

  JsonParser_Parse_ResponseParamsDataView(
      internal::JsonParser_Parse_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      ::mojo_base::mojom::ValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ValueDataView, UserType>(),
    "Attempting to read the optional `result` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadResult` instead "
    "of `ReadResult if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->result.is_null() ? &data_->result : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::ValueDataView>(
        pointer, output, message_);
  }
  inline void GetErrorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `error` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadError` instead "
    "of `ReadError if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->error.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::JsonParser_Parse_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void JsonParser_Parse_ParamsDataView::GetJsonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->json.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void JsonParser_Parse_ResponseParamsDataView::GetResultDataView(
    ::mojo_base::mojom::ValueDataView* output) {
  auto pointer = &data_->result;
  *output = ::mojo_base::mojom::ValueDataView(pointer, message_);
}
inline void JsonParser_Parse_ResponseParamsDataView::GetErrorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // data_decoder::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_DATA_DECODER_PUBLIC_MOJOM_JSON_PARSER_MOJOM_PARAMS_DATA_H_