// services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-params-data.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-import-headers.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-test-utils.h"


namespace viz::mojom {
VideoCaptureTarget::VideoCaptureTarget()
    : frame_sink_id(),
      sub_target() {}

VideoCaptureTarget::VideoCaptureTarget(
    const ::viz::FrameSinkId& frame_sink_id_in,
    const ::viz::VideoCaptureSubTarget& sub_target_in)
    : frame_sink_id(std::move(frame_sink_id_in)),
      sub_target(std::move(sub_target_in)) {}

VideoCaptureTarget::~VideoCaptureTarget() = default;

void VideoCaptureTarget::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_sink_id"), this->frame_sink_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::FrameSinkId&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sub_target"), this->sub_target,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::VideoCaptureSubTarget&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoCaptureTarget::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoCaptureSubTarget::VideoCaptureSubTarget() : tag_(Tag::kSubtreeCaptureId) {
  data_.subtree_capture_id = new ::viz::SubtreeCaptureId;
}

VideoCaptureSubTarget::~VideoCaptureSubTarget() {
  DestroyActive();
}


void VideoCaptureSubTarget::set_subtree_capture_id(
    const ::viz::SubtreeCaptureId& subtree_capture_id) {
  if (tag_ == Tag::kSubtreeCaptureId) {
    *(data_.subtree_capture_id) = std::move(subtree_capture_id);
  } else {
    DestroyActive();
    tag_ = Tag::kSubtreeCaptureId;
    data_.subtree_capture_id = new ::viz::SubtreeCaptureId(
        std::move(subtree_capture_id));
  }
}
void VideoCaptureSubTarget::set_region_capture_crop_id(
    const ::base::Token& region_capture_crop_id) {
  if (tag_ == Tag::kRegionCaptureCropId) {
    *(data_.region_capture_crop_id) = std::move(region_capture_crop_id);
  } else {
    DestroyActive();
    tag_ = Tag::kRegionCaptureCropId;
    data_.region_capture_crop_id = new ::base::Token(
        std::move(region_capture_crop_id));
  }
}

void VideoCaptureSubTarget::DestroyActive() {
  switch (tag_) {

    case Tag::kSubtreeCaptureId:

      delete data_.subtree_capture_id;
      break;
    case Tag::kRegionCaptureCropId:

      delete data_.region_capture_crop_id;
      break;
  }
}

bool VideoCaptureSubTarget::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char FrameSinkVideoConsumerFrameCallbacks::Name_[] = "viz.mojom.FrameSinkVideoConsumerFrameCallbacks";

FrameSinkVideoConsumerFrameCallbacks::IPCStableHashFunction FrameSinkVideoConsumerFrameCallbacks::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrameSinkVideoConsumerFrameCallbacks>(message.name())) {
    case messages::FrameSinkVideoConsumerFrameCallbacks::kDone: {
      return &FrameSinkVideoConsumerFrameCallbacks::Done_Sym::IPCStableHash;
    }
    case messages::FrameSinkVideoConsumerFrameCallbacks::kProvideFeedback: {
      return &FrameSinkVideoConsumerFrameCallbacks::ProvideFeedback_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrameSinkVideoConsumerFrameCallbacks::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrameSinkVideoConsumerFrameCallbacks>(message.name())) {
      case messages::FrameSinkVideoConsumerFrameCallbacks::kDone:
            return "Receive viz::mojom::FrameSinkVideoConsumerFrameCallbacks::Done";
      case messages::FrameSinkVideoConsumerFrameCallbacks::kProvideFeedback:
            return "Receive viz::mojom::FrameSinkVideoConsumerFrameCallbacks::ProvideFeedback";
    }
  } else {
    switch (static_cast<messages::FrameSinkVideoConsumerFrameCallbacks>(message.name())) {
      case messages::FrameSinkVideoConsumerFrameCallbacks::kDone:
            return "Receive reply viz::mojom::FrameSinkVideoConsumerFrameCallbacks::Done";
      case messages::FrameSinkVideoConsumerFrameCallbacks::kProvideFeedback:
            return "Receive reply viz::mojom::FrameSinkVideoConsumerFrameCallbacks::ProvideFeedback";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrameSinkVideoConsumerFrameCallbacks::Done_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoConsumerFrameCallbacks::Done");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkVideoConsumerFrameCallbacks::ProvideFeedback_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoConsumerFrameCallbacks::ProvideFeedback");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FrameSinkVideoConsumerFrameCallbacksProxy::FrameSinkVideoConsumerFrameCallbacksProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameSinkVideoConsumerFrameCallbacksProxy::Done(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::FrameSinkVideoConsumerFrameCallbacks::Done");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoConsumerFrameCallbacks::kDone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoConsumerFrameCallbacks::Name_);
  message.set_method_name("Done");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkVideoConsumerFrameCallbacksProxy::ProvideFeedback(
    const ::media::VideoCaptureFeedback& in_feedback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkVideoConsumerFrameCallbacks::ProvideFeedback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feedback"), in_feedback,
                        "<value of type const ::media::VideoCaptureFeedback&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoConsumerFrameCallbacks::kProvideFeedback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->feedback)::BaseType> feedback_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoCaptureFeedbackDataView>(
      in_feedback, feedback_fragment);
  params->feedback.Set(
      feedback_fragment.is_null() ? nullptr : feedback_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->feedback.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null feedback in FrameSinkVideoConsumerFrameCallbacks.ProvideFeedback request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoConsumerFrameCallbacks::Name_);
  message.set_method_name("ProvideFeedback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FrameSinkVideoConsumerFrameCallbacksStubDispatch::Accept(
    FrameSinkVideoConsumerFrameCallbacks* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrameSinkVideoConsumerFrameCallbacks>(message->header()->name)) {
    case messages::FrameSinkVideoConsumerFrameCallbacks::kDone: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoConsumerFrameCallbacks.0
      bool success = true;
      FrameSinkVideoConsumerFrameCallbacks_Done_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoConsumerFrameCallbacks::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Done(        );
      return true;
    }
    case messages::FrameSinkVideoConsumerFrameCallbacks::kProvideFeedback: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoConsumerFrameCallbacks.1
      bool success = true;
      ::media::VideoCaptureFeedback p_feedback{};
      FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeedback(&p_feedback))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoConsumerFrameCallbacks::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ProvideFeedback(        
        std::move(p_feedback));
      return true;
    }
  }
  return false;
}

// static
bool FrameSinkVideoConsumerFrameCallbacksStubDispatch::AcceptWithResponder(
    FrameSinkVideoConsumerFrameCallbacks* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrameSinkVideoConsumerFrameCallbacks>(message->header()->name)) {
    case messages::FrameSinkVideoConsumerFrameCallbacks::kDone: {
      break;
    }
    case messages::FrameSinkVideoConsumerFrameCallbacks::kProvideFeedback: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameSinkVideoConsumerFrameCallbacksValidationInfo[] = {
    {base::to_underlying(messages::FrameSinkVideoConsumerFrameCallbacks::kDone),
     { &internal::FrameSinkVideoConsumerFrameCallbacks_Done_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkVideoConsumerFrameCallbacks::kProvideFeedback),
     { &internal::FrameSinkVideoConsumerFrameCallbacks_ProvideFeedback_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameSinkVideoConsumerFrameCallbacksRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::FrameSinkVideoConsumerFrameCallbacks::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameSinkVideoConsumerFrameCallbacksValidationInfo);
}

const char FrameSinkVideoConsumer::Name_[] = "viz.mojom.FrameSinkVideoConsumer";

FrameSinkVideoConsumer::IPCStableHashFunction FrameSinkVideoConsumer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrameSinkVideoConsumer>(message.name())) {
    case messages::FrameSinkVideoConsumer::kOnFrameCaptured: {
      return &FrameSinkVideoConsumer::OnFrameCaptured_Sym::IPCStableHash;
    }
    case messages::FrameSinkVideoConsumer::kOnNewSubCaptureTargetVersion: {
      return &FrameSinkVideoConsumer::OnNewSubCaptureTargetVersion_Sym::IPCStableHash;
    }
    case messages::FrameSinkVideoConsumer::kOnFrameWithEmptyRegionCapture: {
      return &FrameSinkVideoConsumer::OnFrameWithEmptyRegionCapture_Sym::IPCStableHash;
    }
    case messages::FrameSinkVideoConsumer::kOnStopped: {
      return &FrameSinkVideoConsumer::OnStopped_Sym::IPCStableHash;
    }
    case messages::FrameSinkVideoConsumer::kOnLog: {
      return &FrameSinkVideoConsumer::OnLog_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrameSinkVideoConsumer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrameSinkVideoConsumer>(message.name())) {
      case messages::FrameSinkVideoConsumer::kOnFrameCaptured:
            return "Receive viz::mojom::FrameSinkVideoConsumer::OnFrameCaptured";
      case messages::FrameSinkVideoConsumer::kOnNewSubCaptureTargetVersion:
            return "Receive viz::mojom::FrameSinkVideoConsumer::OnNewSubCaptureTargetVersion";
      case messages::FrameSinkVideoConsumer::kOnFrameWithEmptyRegionCapture:
            return "Receive viz::mojom::FrameSinkVideoConsumer::OnFrameWithEmptyRegionCapture";
      case messages::FrameSinkVideoConsumer::kOnStopped:
            return "Receive viz::mojom::FrameSinkVideoConsumer::OnStopped";
      case messages::FrameSinkVideoConsumer::kOnLog:
            return "Receive viz::mojom::FrameSinkVideoConsumer::OnLog";
    }
  } else {
    switch (static_cast<messages::FrameSinkVideoConsumer>(message.name())) {
      case messages::FrameSinkVideoConsumer::kOnFrameCaptured:
            return "Receive reply viz::mojom::FrameSinkVideoConsumer::OnFrameCaptured";
      case messages::FrameSinkVideoConsumer::kOnNewSubCaptureTargetVersion:
            return "Receive reply viz::mojom::FrameSinkVideoConsumer::OnNewSubCaptureTargetVersion";
      case messages::FrameSinkVideoConsumer::kOnFrameWithEmptyRegionCapture:
            return "Receive reply viz::mojom::FrameSinkVideoConsumer::OnFrameWithEmptyRegionCapture";
      case messages::FrameSinkVideoConsumer::kOnStopped:
            return "Receive reply viz::mojom::FrameSinkVideoConsumer::OnStopped";
      case messages::FrameSinkVideoConsumer::kOnLog:
            return "Receive reply viz::mojom::FrameSinkVideoConsumer::OnLog";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrameSinkVideoConsumer::OnFrameCaptured_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoConsumer::OnFrameCaptured");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkVideoConsumer::OnNewSubCaptureTargetVersion_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoConsumer::OnNewSubCaptureTargetVersion");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkVideoConsumer::OnFrameWithEmptyRegionCapture_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoConsumer::OnFrameWithEmptyRegionCapture");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkVideoConsumer::OnStopped_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoConsumer::OnStopped");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkVideoConsumer::OnLog_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoConsumer::OnLog");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FrameSinkVideoConsumerProxy::FrameSinkVideoConsumerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameSinkVideoConsumerProxy::OnFrameCaptured(
    ::media::mojom::VideoBufferHandlePtr in_data, ::media::mojom::VideoFrameInfoPtr in_info, const ::gfx::Rect& in_content_rect, ::mojo::PendingRemote<FrameSinkVideoConsumerFrameCallbacks> in_callbacks) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkVideoConsumer::OnFrameCaptured", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::media::mojom::VideoBufferHandlePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type ::media::mojom::VideoFrameInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("content_rect"), in_content_rect,
                        "<value of type const ::gfx::Rect&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("callbacks"), in_callbacks,
                        "<value of type ::mojo::PendingRemote<FrameSinkVideoConsumerFrameCallbacks>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoConsumer::kOnFrameCaptured), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoConsumer_OnFrameCaptured_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  mojo::internal::Serialize<::media::mojom::VideoBufferHandleDataView>(
      in_data, data_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in FrameSinkVideoConsumer.OnFrameCaptured request");
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoFrameInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null info in FrameSinkVideoConsumer.OnFrameCaptured request");
  mojo::internal::MessageFragment<
      typename decltype(params->content_rect)::BaseType> content_rect_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_content_rect, content_rect_fragment);
  params->content_rect.Set(
      content_rect_fragment.is_null() ? nullptr : content_rect_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->content_rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null content_rect in FrameSinkVideoConsumer.OnFrameCaptured request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::FrameSinkVideoConsumerFrameCallbacksInterfaceBase>>(
      in_callbacks, &params->callbacks, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->callbacks),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid callbacks in FrameSinkVideoConsumer.OnFrameCaptured request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoConsumer::Name_);
  message.set_method_name("OnFrameCaptured");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkVideoConsumerProxy::OnNewSubCaptureTargetVersion(
    uint32_t in_sub_capture_target_version) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkVideoConsumer::OnNewSubCaptureTargetVersion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sub_capture_target_version"), in_sub_capture_target_version,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoConsumer::kOnNewSubCaptureTargetVersion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoConsumer_OnNewSubCaptureTargetVersion_Params_Data> params(
          message);
  params.Allocate();
  params->sub_capture_target_version = in_sub_capture_target_version;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoConsumer::Name_);
  message.set_method_name("OnNewSubCaptureTargetVersion");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkVideoConsumerProxy::OnFrameWithEmptyRegionCapture(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::FrameSinkVideoConsumer::OnFrameWithEmptyRegionCapture");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoConsumer::kOnFrameWithEmptyRegionCapture), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoConsumer_OnFrameWithEmptyRegionCapture_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoConsumer::Name_);
  message.set_method_name("OnFrameWithEmptyRegionCapture");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkVideoConsumerProxy::OnStopped(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::FrameSinkVideoConsumer::OnStopped");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoConsumer::kOnStopped), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoConsumer_OnStopped_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoConsumer::Name_);
  message.set_method_name("OnStopped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkVideoConsumerProxy::OnLog(
    const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkVideoConsumer::OnLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoConsumer::kOnLog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoConsumer_OnLog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_message, message_fragment);
  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in FrameSinkVideoConsumer.OnLog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoConsumer::Name_);
  message.set_method_name("OnLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FrameSinkVideoConsumerStubDispatch::Accept(
    FrameSinkVideoConsumer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrameSinkVideoConsumer>(message->header()->name)) {
    case messages::FrameSinkVideoConsumer::kOnFrameCaptured: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoConsumer_OnFrameCaptured_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoConsumer_OnFrameCaptured_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoConsumer.0
      bool success = true;
      ::media::mojom::VideoBufferHandlePtr p_data{};
      ::media::mojom::VideoFrameInfoPtr p_info{};
      ::gfx::Rect p_content_rect{};
      ::mojo::PendingRemote<FrameSinkVideoConsumerFrameCallbacks> p_callbacks{};
      FrameSinkVideoConsumer_OnFrameCaptured_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success && !input_data_view.ReadInfo(&p_info))
        success = false;
      if (success && !input_data_view.ReadContentRect(&p_content_rect))
        success = false;
      if (success) {
        p_callbacks =
            input_data_view.TakeCallbacks<decltype(p_callbacks)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoConsumer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameCaptured(        
        std::move(p_data), 
        std::move(p_info), 
        std::move(p_content_rect), 
        std::move(p_callbacks));
      return true;
    }
    case messages::FrameSinkVideoConsumer::kOnNewSubCaptureTargetVersion: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoConsumer_OnNewSubCaptureTargetVersion_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoConsumer_OnNewSubCaptureTargetVersion_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoConsumer.1
      bool success = true;
      uint32_t p_sub_capture_target_version{};
      FrameSinkVideoConsumer_OnNewSubCaptureTargetVersion_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_sub_capture_target_version = input_data_view.sub_capture_target_version();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoConsumer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNewSubCaptureTargetVersion(        
        std::move(p_sub_capture_target_version));
      return true;
    }
    case messages::FrameSinkVideoConsumer::kOnFrameWithEmptyRegionCapture: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoConsumer_OnFrameWithEmptyRegionCapture_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoConsumer_OnFrameWithEmptyRegionCapture_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoConsumer.2
      bool success = true;
      FrameSinkVideoConsumer_OnFrameWithEmptyRegionCapture_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoConsumer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFrameWithEmptyRegionCapture(        );
      return true;
    }
    case messages::FrameSinkVideoConsumer::kOnStopped: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoConsumer_OnStopped_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoConsumer_OnStopped_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoConsumer.3
      bool success = true;
      FrameSinkVideoConsumer_OnStopped_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoConsumer::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStopped(        );
      return true;
    }
    case messages::FrameSinkVideoConsumer::kOnLog: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoConsumer_OnLog_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoConsumer_OnLog_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoConsumer.4
      bool success = true;
      std::string p_message{};
      FrameSinkVideoConsumer_OnLog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoConsumer::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLog(        
        std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool FrameSinkVideoConsumerStubDispatch::AcceptWithResponder(
    FrameSinkVideoConsumer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrameSinkVideoConsumer>(message->header()->name)) {
    case messages::FrameSinkVideoConsumer::kOnFrameCaptured: {
      break;
    }
    case messages::FrameSinkVideoConsumer::kOnNewSubCaptureTargetVersion: {
      break;
    }
    case messages::FrameSinkVideoConsumer::kOnFrameWithEmptyRegionCapture: {
      break;
    }
    case messages::FrameSinkVideoConsumer::kOnStopped: {
      break;
    }
    case messages::FrameSinkVideoConsumer::kOnLog: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameSinkVideoConsumerValidationInfo[] = {
    {base::to_underlying(messages::FrameSinkVideoConsumer::kOnFrameCaptured),
     { &internal::FrameSinkVideoConsumer_OnFrameCaptured_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkVideoConsumer::kOnNewSubCaptureTargetVersion),
     { &internal::FrameSinkVideoConsumer_OnNewSubCaptureTargetVersion_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkVideoConsumer::kOnFrameWithEmptyRegionCapture),
     { &internal::FrameSinkVideoConsumer_OnFrameWithEmptyRegionCapture_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkVideoConsumer::kOnStopped),
     { &internal::FrameSinkVideoConsumer_OnStopped_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkVideoConsumer::kOnLog),
     { &internal::FrameSinkVideoConsumer_OnLog_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameSinkVideoConsumerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::FrameSinkVideoConsumer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameSinkVideoConsumerValidationInfo);
}

const char FrameSinkVideoCapturer::Name_[] = "viz.mojom.FrameSinkVideoCapturer";

FrameSinkVideoCapturer::IPCStableHashFunction FrameSinkVideoCapturer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrameSinkVideoCapturer>(message.name())) {
    case messages::FrameSinkVideoCapturer::kSetFormat: {
      return &FrameSinkVideoCapturer::SetFormat_Sym::IPCStableHash;
    }
    case messages::FrameSinkVideoCapturer::kSetMinCapturePeriod: {
      return &FrameSinkVideoCapturer::SetMinCapturePeriod_Sym::IPCStableHash;
    }
    case messages::FrameSinkVideoCapturer::kSetMinSizeChangePeriod: {
      return &FrameSinkVideoCapturer::SetMinSizeChangePeriod_Sym::IPCStableHash;
    }
    case messages::FrameSinkVideoCapturer::kSetResolutionConstraints: {
      return &FrameSinkVideoCapturer::SetResolutionConstraints_Sym::IPCStableHash;
    }
    case messages::FrameSinkVideoCapturer::kSetAutoThrottlingEnabled: {
      return &FrameSinkVideoCapturer::SetAutoThrottlingEnabled_Sym::IPCStableHash;
    }
    case messages::FrameSinkVideoCapturer::kChangeTarget: {
      return &FrameSinkVideoCapturer::ChangeTarget_Sym::IPCStableHash;
    }
    case messages::FrameSinkVideoCapturer::kStart: {
      return &FrameSinkVideoCapturer::Start_Sym::IPCStableHash;
    }
    case messages::FrameSinkVideoCapturer::kStop: {
      return &FrameSinkVideoCapturer::Stop_Sym::IPCStableHash;
    }
    case messages::FrameSinkVideoCapturer::kRequestRefreshFrame: {
      return &FrameSinkVideoCapturer::RequestRefreshFrame_Sym::IPCStableHash;
    }
    case messages::FrameSinkVideoCapturer::kCreateOverlay: {
      return &FrameSinkVideoCapturer::CreateOverlay_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrameSinkVideoCapturer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrameSinkVideoCapturer>(message.name())) {
      case messages::FrameSinkVideoCapturer::kSetFormat:
            return "Receive viz::mojom::FrameSinkVideoCapturer::SetFormat";
      case messages::FrameSinkVideoCapturer::kSetMinCapturePeriod:
            return "Receive viz::mojom::FrameSinkVideoCapturer::SetMinCapturePeriod";
      case messages::FrameSinkVideoCapturer::kSetMinSizeChangePeriod:
            return "Receive viz::mojom::FrameSinkVideoCapturer::SetMinSizeChangePeriod";
      case messages::FrameSinkVideoCapturer::kSetResolutionConstraints:
            return "Receive viz::mojom::FrameSinkVideoCapturer::SetResolutionConstraints";
      case messages::FrameSinkVideoCapturer::kSetAutoThrottlingEnabled:
            return "Receive viz::mojom::FrameSinkVideoCapturer::SetAutoThrottlingEnabled";
      case messages::FrameSinkVideoCapturer::kChangeTarget:
            return "Receive viz::mojom::FrameSinkVideoCapturer::ChangeTarget";
      case messages::FrameSinkVideoCapturer::kStart:
            return "Receive viz::mojom::FrameSinkVideoCapturer::Start";
      case messages::FrameSinkVideoCapturer::kStop:
            return "Receive viz::mojom::FrameSinkVideoCapturer::Stop";
      case messages::FrameSinkVideoCapturer::kRequestRefreshFrame:
            return "Receive viz::mojom::FrameSinkVideoCapturer::RequestRefreshFrame";
      case messages::FrameSinkVideoCapturer::kCreateOverlay:
            return "Receive viz::mojom::FrameSinkVideoCapturer::CreateOverlay";
    }
  } else {
    switch (static_cast<messages::FrameSinkVideoCapturer>(message.name())) {
      case messages::FrameSinkVideoCapturer::kSetFormat:
            return "Receive reply viz::mojom::FrameSinkVideoCapturer::SetFormat";
      case messages::FrameSinkVideoCapturer::kSetMinCapturePeriod:
            return "Receive reply viz::mojom::FrameSinkVideoCapturer::SetMinCapturePeriod";
      case messages::FrameSinkVideoCapturer::kSetMinSizeChangePeriod:
            return "Receive reply viz::mojom::FrameSinkVideoCapturer::SetMinSizeChangePeriod";
      case messages::FrameSinkVideoCapturer::kSetResolutionConstraints:
            return "Receive reply viz::mojom::FrameSinkVideoCapturer::SetResolutionConstraints";
      case messages::FrameSinkVideoCapturer::kSetAutoThrottlingEnabled:
            return "Receive reply viz::mojom::FrameSinkVideoCapturer::SetAutoThrottlingEnabled";
      case messages::FrameSinkVideoCapturer::kChangeTarget:
            return "Receive reply viz::mojom::FrameSinkVideoCapturer::ChangeTarget";
      case messages::FrameSinkVideoCapturer::kStart:
            return "Receive reply viz::mojom::FrameSinkVideoCapturer::Start";
      case messages::FrameSinkVideoCapturer::kStop:
            return "Receive reply viz::mojom::FrameSinkVideoCapturer::Stop";
      case messages::FrameSinkVideoCapturer::kRequestRefreshFrame:
            return "Receive reply viz::mojom::FrameSinkVideoCapturer::RequestRefreshFrame";
      case messages::FrameSinkVideoCapturer::kCreateOverlay:
            return "Receive reply viz::mojom::FrameSinkVideoCapturer::CreateOverlay";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrameSinkVideoCapturer::SetFormat_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoCapturer::SetFormat");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkVideoCapturer::SetMinCapturePeriod_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoCapturer::SetMinCapturePeriod");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkVideoCapturer::SetMinSizeChangePeriod_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoCapturer::SetMinSizeChangePeriod");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkVideoCapturer::SetResolutionConstraints_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoCapturer::SetResolutionConstraints");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkVideoCapturer::SetAutoThrottlingEnabled_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoCapturer::SetAutoThrottlingEnabled");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkVideoCapturer::ChangeTarget_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoCapturer::ChangeTarget");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkVideoCapturer::Start_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoCapturer::Start");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkVideoCapturer::Stop_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoCapturer::Stop");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkVideoCapturer::RequestRefreshFrame_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoCapturer::RequestRefreshFrame");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkVideoCapturer::CreateOverlay_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoCapturer::CreateOverlay");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FrameSinkVideoCapturerProxy::FrameSinkVideoCapturerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameSinkVideoCapturerProxy::SetFormat(
    ::media::VideoPixelFormat in_format) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkVideoCapturer::SetFormat", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("format"), in_format,
                        "<value of type ::media::VideoPixelFormat>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoCapturer::kSetFormat), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_SetFormat_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::media::mojom::VideoPixelFormat>(
      in_format, &params->format);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("SetFormat");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkVideoCapturerProxy::SetMinCapturePeriod(
    ::base::TimeDelta in_min_period) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkVideoCapturer::SetMinCapturePeriod", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("min_period"), in_min_period,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoCapturer::kSetMinCapturePeriod), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->min_period)::BaseType> min_period_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_min_period, min_period_fragment);
  params->min_period.Set(
      min_period_fragment.is_null() ? nullptr : min_period_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->min_period.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null min_period in FrameSinkVideoCapturer.SetMinCapturePeriod request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("SetMinCapturePeriod");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkVideoCapturerProxy::SetMinSizeChangePeriod(
    ::base::TimeDelta in_min_period) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkVideoCapturer::SetMinSizeChangePeriod", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("min_period"), in_min_period,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoCapturer::kSetMinSizeChangePeriod), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->min_period)::BaseType> min_period_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_min_period, min_period_fragment);
  params->min_period.Set(
      min_period_fragment.is_null() ? nullptr : min_period_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->min_period.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null min_period in FrameSinkVideoCapturer.SetMinSizeChangePeriod request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("SetMinSizeChangePeriod");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkVideoCapturerProxy::SetResolutionConstraints(
    const ::gfx::Size& in_min_size, const ::gfx::Size& in_max_size, bool in_use_fixed_aspect_ratio) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkVideoCapturer::SetResolutionConstraints", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("min_size"), in_min_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_size"), in_max_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("use_fixed_aspect_ratio"), in_use_fixed_aspect_ratio,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoCapturer::kSetResolutionConstraints), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->min_size)::BaseType> min_size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_min_size, min_size_fragment);
  params->min_size.Set(
      min_size_fragment.is_null() ? nullptr : min_size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->min_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null min_size in FrameSinkVideoCapturer.SetResolutionConstraints request");
  mojo::internal::MessageFragment<
      typename decltype(params->max_size)::BaseType> max_size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_max_size, max_size_fragment);
  params->max_size.Set(
      max_size_fragment.is_null() ? nullptr : max_size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->max_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null max_size in FrameSinkVideoCapturer.SetResolutionConstraints request");
  params->use_fixed_aspect_ratio = in_use_fixed_aspect_ratio;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("SetResolutionConstraints");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkVideoCapturerProxy::SetAutoThrottlingEnabled(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkVideoCapturer::SetAutoThrottlingEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoCapturer::kSetAutoThrottlingEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data> params(
          message);
  params.Allocate();
  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("SetAutoThrottlingEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkVideoCapturerProxy::ChangeTarget(
    const std::optional<::viz::VideoCaptureTarget>& in_target, uint32_t in_sub_capture_target_version) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkVideoCapturer::ChangeTarget", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target"), in_target,
                        "<value of type const std::optional<::viz::VideoCaptureTarget>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sub_capture_target_version"), in_sub_capture_target_version,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoCapturer::kChangeTarget), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_ChangeTarget_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->target)::BaseType> target_fragment(
          params.message());
  mojo::internal::Serialize<::viz::mojom::VideoCaptureTargetDataView>(
      in_target, target_fragment);
  params->target.Set(
      target_fragment.is_null() ? nullptr : target_fragment.data());
  params->sub_capture_target_version = in_sub_capture_target_version;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("ChangeTarget");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkVideoCapturerProxy::Start(
    ::mojo::PendingRemote<FrameSinkVideoConsumer> in_consumer, BufferFormatPreference in_buffer_format_preference) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkVideoCapturer::Start", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("consumer"), in_consumer,
                        "<value of type ::mojo::PendingRemote<FrameSinkVideoConsumer>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_format_preference"), in_buffer_format_preference,
                        "<value of type BufferFormatPreference>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoCapturer::kStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_Start_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::FrameSinkVideoConsumerInterfaceBase>>(
      in_consumer, &params->consumer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->consumer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid consumer in FrameSinkVideoCapturer.Start request");
  mojo::internal::Serialize<::viz::mojom::BufferFormatPreference>(
      in_buffer_format_preference, &params->buffer_format_preference);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("Start");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkVideoCapturerProxy::Stop(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::FrameSinkVideoCapturer::Stop");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoCapturer::kStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_Stop_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("Stop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkVideoCapturerProxy::RequestRefreshFrame(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send viz::mojom::FrameSinkVideoCapturer::RequestRefreshFrame");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoCapturer::kRequestRefreshFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("RequestRefreshFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkVideoCapturerProxy::CreateOverlay(
    int32_t in_stacking_index, ::mojo::PendingReceiver<FrameSinkVideoCaptureOverlay> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkVideoCapturer::CreateOverlay", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stacking_index"), in_stacking_index,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<FrameSinkVideoCaptureOverlay>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoCapturer::kCreateOverlay), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCapturer_CreateOverlay_Params_Data> params(
          message);
  params.Allocate();
  params->stacking_index = in_stacking_index;
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::FrameSinkVideoCaptureOverlayInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in FrameSinkVideoCapturer.CreateOverlay request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCapturer::Name_);
  message.set_method_name("CreateOverlay");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FrameSinkVideoCapturerStubDispatch::Accept(
    FrameSinkVideoCapturer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrameSinkVideoCapturer>(message->header()->name)) {
    case messages::FrameSinkVideoCapturer::kSetFormat: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_SetFormat_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_SetFormat_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoCapturer.0
      bool success = true;
      ::media::VideoPixelFormat p_format{};
      FrameSinkVideoCapturer_SetFormat_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFormat(&p_format))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFormat(        
        std::move(p_format));
      return true;
    }
    case messages::FrameSinkVideoCapturer::kSetMinCapturePeriod: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoCapturer.1
      bool success = true;
      ::base::TimeDelta p_min_period{};
      FrameSinkVideoCapturer_SetMinCapturePeriod_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMinPeriod(&p_min_period))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMinCapturePeriod(        
        std::move(p_min_period));
      return true;
    }
    case messages::FrameSinkVideoCapturer::kSetMinSizeChangePeriod: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoCapturer.2
      bool success = true;
      ::base::TimeDelta p_min_period{};
      FrameSinkVideoCapturer_SetMinSizeChangePeriod_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMinPeriod(&p_min_period))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMinSizeChangePeriod(        
        std::move(p_min_period));
      return true;
    }
    case messages::FrameSinkVideoCapturer::kSetResolutionConstraints: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoCapturer.3
      bool success = true;
      ::gfx::Size p_min_size{};
      ::gfx::Size p_max_size{};
      bool p_use_fixed_aspect_ratio{};
      FrameSinkVideoCapturer_SetResolutionConstraints_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMinSize(&p_min_size))
        success = false;
      if (success && !input_data_view.ReadMaxSize(&p_max_size))
        success = false;
      if (success)
        p_use_fixed_aspect_ratio = input_data_view.use_fixed_aspect_ratio();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetResolutionConstraints(        
        std::move(p_min_size), 
        std::move(p_max_size), 
        std::move(p_use_fixed_aspect_ratio));
      return true;
    }
    case messages::FrameSinkVideoCapturer::kSetAutoThrottlingEnabled: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoCapturer.4
      bool success = true;
      bool p_enabled{};
      FrameSinkVideoCapturer_SetAutoThrottlingEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAutoThrottlingEnabled(        
        std::move(p_enabled));
      return true;
    }
    case messages::FrameSinkVideoCapturer::kChangeTarget: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_ChangeTarget_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_ChangeTarget_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoCapturer.5
      bool success = true;
      std::optional<::viz::VideoCaptureTarget> p_target{};
      uint32_t p_sub_capture_target_version{};
      FrameSinkVideoCapturer_ChangeTarget_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTarget(&p_target))
        success = false;
      if (success)
        p_sub_capture_target_version = input_data_view.sub_capture_target_version();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChangeTarget(        
        std::move(p_target), 
        std::move(p_sub_capture_target_version));
      return true;
    }
    case messages::FrameSinkVideoCapturer::kStart: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_Start_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_Start_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoCapturer.6
      bool success = true;
      ::mojo::PendingRemote<FrameSinkVideoConsumer> p_consumer{};
      BufferFormatPreference p_buffer_format_preference{};
      FrameSinkVideoCapturer_Start_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_consumer =
            input_data_view.TakeConsumer<decltype(p_consumer)>();
      }
      if (success && !input_data_view.ReadBufferFormatPreference(&p_buffer_format_preference))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(        
        std::move(p_consumer), 
        std::move(p_buffer_format_preference));
      return true;
    }
    case messages::FrameSinkVideoCapturer::kStop: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_Stop_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_Stop_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoCapturer.7
      bool success = true;
      FrameSinkVideoCapturer_Stop_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop(        );
      return true;
    }
    case messages::FrameSinkVideoCapturer::kRequestRefreshFrame: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoCapturer.8
      bool success = true;
      FrameSinkVideoCapturer_RequestRefreshFrame_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestRefreshFrame(        );
      return true;
    }
    case messages::FrameSinkVideoCapturer::kCreateOverlay: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCapturer_CreateOverlay_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCapturer_CreateOverlay_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoCapturer.9
      bool success = true;
      int32_t p_stacking_index{};
      ::mojo::PendingReceiver<FrameSinkVideoCaptureOverlay> p_receiver{};
      FrameSinkVideoCapturer_CreateOverlay_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_stacking_index = input_data_view.stacking_index();
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCapturer::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateOverlay(        
        std::move(p_stacking_index), 
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool FrameSinkVideoCapturerStubDispatch::AcceptWithResponder(
    FrameSinkVideoCapturer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrameSinkVideoCapturer>(message->header()->name)) {
    case messages::FrameSinkVideoCapturer::kSetFormat: {
      break;
    }
    case messages::FrameSinkVideoCapturer::kSetMinCapturePeriod: {
      break;
    }
    case messages::FrameSinkVideoCapturer::kSetMinSizeChangePeriod: {
      break;
    }
    case messages::FrameSinkVideoCapturer::kSetResolutionConstraints: {
      break;
    }
    case messages::FrameSinkVideoCapturer::kSetAutoThrottlingEnabled: {
      break;
    }
    case messages::FrameSinkVideoCapturer::kChangeTarget: {
      break;
    }
    case messages::FrameSinkVideoCapturer::kStart: {
      break;
    }
    case messages::FrameSinkVideoCapturer::kStop: {
      break;
    }
    case messages::FrameSinkVideoCapturer::kRequestRefreshFrame: {
      break;
    }
    case messages::FrameSinkVideoCapturer::kCreateOverlay: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameSinkVideoCapturerValidationInfo[] = {
    {base::to_underlying(messages::FrameSinkVideoCapturer::kSetFormat),
     { &internal::FrameSinkVideoCapturer_SetFormat_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkVideoCapturer::kSetMinCapturePeriod),
     { &internal::FrameSinkVideoCapturer_SetMinCapturePeriod_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkVideoCapturer::kSetMinSizeChangePeriod),
     { &internal::FrameSinkVideoCapturer_SetMinSizeChangePeriod_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkVideoCapturer::kSetResolutionConstraints),
     { &internal::FrameSinkVideoCapturer_SetResolutionConstraints_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkVideoCapturer::kSetAutoThrottlingEnabled),
     { &internal::FrameSinkVideoCapturer_SetAutoThrottlingEnabled_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkVideoCapturer::kChangeTarget),
     { &internal::FrameSinkVideoCapturer_ChangeTarget_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkVideoCapturer::kStart),
     { &internal::FrameSinkVideoCapturer_Start_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkVideoCapturer::kStop),
     { &internal::FrameSinkVideoCapturer_Stop_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkVideoCapturer::kRequestRefreshFrame),
     { &internal::FrameSinkVideoCapturer_RequestRefreshFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkVideoCapturer::kCreateOverlay),
     { &internal::FrameSinkVideoCapturer_CreateOverlay_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameSinkVideoCapturerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::FrameSinkVideoCapturer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameSinkVideoCapturerValidationInfo);
}

const char FrameSinkVideoCaptureOverlay::Name_[] = "viz.mojom.FrameSinkVideoCaptureOverlay";

FrameSinkVideoCaptureOverlay::IPCStableHashFunction FrameSinkVideoCaptureOverlay::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FrameSinkVideoCaptureOverlay>(message.name())) {
    case messages::FrameSinkVideoCaptureOverlay::kSetImageAndBounds: {
      return &FrameSinkVideoCaptureOverlay::SetImageAndBounds_Sym::IPCStableHash;
    }
    case messages::FrameSinkVideoCaptureOverlay::kSetBounds: {
      return &FrameSinkVideoCaptureOverlay::SetBounds_Sym::IPCStableHash;
    }
    case messages::FrameSinkVideoCaptureOverlay::kOnCapturedMouseEvent: {
      return &FrameSinkVideoCaptureOverlay::OnCapturedMouseEvent_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FrameSinkVideoCaptureOverlay::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FrameSinkVideoCaptureOverlay>(message.name())) {
      case messages::FrameSinkVideoCaptureOverlay::kSetImageAndBounds:
            return "Receive viz::mojom::FrameSinkVideoCaptureOverlay::SetImageAndBounds";
      case messages::FrameSinkVideoCaptureOverlay::kSetBounds:
            return "Receive viz::mojom::FrameSinkVideoCaptureOverlay::SetBounds";
      case messages::FrameSinkVideoCaptureOverlay::kOnCapturedMouseEvent:
            return "Receive viz::mojom::FrameSinkVideoCaptureOverlay::OnCapturedMouseEvent";
    }
  } else {
    switch (static_cast<messages::FrameSinkVideoCaptureOverlay>(message.name())) {
      case messages::FrameSinkVideoCaptureOverlay::kSetImageAndBounds:
            return "Receive reply viz::mojom::FrameSinkVideoCaptureOverlay::SetImageAndBounds";
      case messages::FrameSinkVideoCaptureOverlay::kSetBounds:
            return "Receive reply viz::mojom::FrameSinkVideoCaptureOverlay::SetBounds";
      case messages::FrameSinkVideoCaptureOverlay::kOnCapturedMouseEvent:
            return "Receive reply viz::mojom::FrameSinkVideoCaptureOverlay::OnCapturedMouseEvent";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FrameSinkVideoCaptureOverlay::SetImageAndBounds_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoCaptureOverlay::SetImageAndBounds");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkVideoCaptureOverlay::SetBounds_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoCaptureOverlay::SetBounds");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FrameSinkVideoCaptureOverlay::OnCapturedMouseEvent_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)viz::mojom::FrameSinkVideoCaptureOverlay::OnCapturedMouseEvent");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FrameSinkVideoCaptureOverlayProxy::FrameSinkVideoCaptureOverlayProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameSinkVideoCaptureOverlayProxy::SetImageAndBounds(
    const ::SkBitmap& in_image, const ::gfx::RectF& in_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkVideoCaptureOverlay::SetImageAndBounds", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image"), in_image,
                        "<value of type const ::SkBitmap&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds,
                        "<value of type const ::gfx::RectF&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoCaptureOverlay::kSetImageAndBounds), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->image)::BaseType> image_fragment(
          params.message());
  mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
      in_image, image_fragment);
  params->image.Set(
      image_fragment.is_null() ? nullptr : image_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->image.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image in FrameSinkVideoCaptureOverlay.SetImageAndBounds request");
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_bounds, bounds_fragment);
  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounds in FrameSinkVideoCaptureOverlay.SetImageAndBounds request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCaptureOverlay::Name_);
  message.set_method_name("SetImageAndBounds");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkVideoCaptureOverlayProxy::SetBounds(
    const ::gfx::RectF& in_bounds) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkVideoCaptureOverlay::SetBounds", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bounds"), in_bounds,
                        "<value of type const ::gfx::RectF&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoCaptureOverlay::kSetBounds), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCaptureOverlay_SetBounds_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bounds)::BaseType> bounds_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
      in_bounds, bounds_fragment);
  params->bounds.Set(
      bounds_fragment.is_null() ? nullptr : bounds_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bounds.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounds in FrameSinkVideoCaptureOverlay.SetBounds request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCaptureOverlay::Name_);
  message.set_method_name("SetBounds");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FrameSinkVideoCaptureOverlayProxy::OnCapturedMouseEvent(
    const ::gfx::Point& in_coordinates) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::FrameSinkVideoCaptureOverlay::OnCapturedMouseEvent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("coordinates"), in_coordinates,
                        "<value of type const ::gfx::Point&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FrameSinkVideoCaptureOverlay::kOnCapturedMouseEvent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::FrameSinkVideoCaptureOverlay_OnCapturedMouseEvent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->coordinates)::BaseType> coordinates_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_coordinates, coordinates_fragment);
  params->coordinates.Set(
      coordinates_fragment.is_null() ? nullptr : coordinates_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->coordinates.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null coordinates in FrameSinkVideoCaptureOverlay.OnCapturedMouseEvent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameSinkVideoCaptureOverlay::Name_);
  message.set_method_name("OnCapturedMouseEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FrameSinkVideoCaptureOverlayStubDispatch::Accept(
    FrameSinkVideoCaptureOverlay* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FrameSinkVideoCaptureOverlay>(message->header()->name)) {
    case messages::FrameSinkVideoCaptureOverlay::kSetImageAndBounds: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoCaptureOverlay.0
      bool success = true;
      ::SkBitmap p_image{};
      ::gfx::RectF p_bounds{};
      FrameSinkVideoCaptureOverlay_SetImageAndBounds_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadImage(&p_image))
        success = false;
      if (success && !input_data_view.ReadBounds(&p_bounds))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCaptureOverlay::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetImageAndBounds(        
        std::move(p_image), 
        std::move(p_bounds));
      return true;
    }
    case messages::FrameSinkVideoCaptureOverlay::kSetBounds: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCaptureOverlay_SetBounds_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCaptureOverlay_SetBounds_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoCaptureOverlay.1
      bool success = true;
      ::gfx::RectF p_bounds{};
      FrameSinkVideoCaptureOverlay_SetBounds_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBounds(&p_bounds))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCaptureOverlay::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBounds(        
        std::move(p_bounds));
      return true;
    }
    case messages::FrameSinkVideoCaptureOverlay::kOnCapturedMouseEvent: {
      DCHECK(message->is_serialized());
      internal::FrameSinkVideoCaptureOverlay_OnCapturedMouseEvent_Params_Data* params =
          reinterpret_cast<internal::FrameSinkVideoCaptureOverlay_OnCapturedMouseEvent_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for FrameSinkVideoCaptureOverlay.2
      bool success = true;
      ::gfx::Point p_coordinates{};
      FrameSinkVideoCaptureOverlay_OnCapturedMouseEvent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCoordinates(&p_coordinates))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameSinkVideoCaptureOverlay::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCapturedMouseEvent(        
        std::move(p_coordinates));
      return true;
    }
  }
  return false;
}

// static
bool FrameSinkVideoCaptureOverlayStubDispatch::AcceptWithResponder(
    FrameSinkVideoCaptureOverlay* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FrameSinkVideoCaptureOverlay>(message->header()->name)) {
    case messages::FrameSinkVideoCaptureOverlay::kSetImageAndBounds: {
      break;
    }
    case messages::FrameSinkVideoCaptureOverlay::kSetBounds: {
      break;
    }
    case messages::FrameSinkVideoCaptureOverlay::kOnCapturedMouseEvent: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameSinkVideoCaptureOverlayValidationInfo[] = {
    {base::to_underlying(messages::FrameSinkVideoCaptureOverlay::kSetImageAndBounds),
     { &internal::FrameSinkVideoCaptureOverlay_SetImageAndBounds_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkVideoCaptureOverlay::kSetBounds),
     { &internal::FrameSinkVideoCaptureOverlay_SetBounds_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::FrameSinkVideoCaptureOverlay::kOnCapturedMouseEvent),
     { &internal::FrameSinkVideoCaptureOverlay_OnCapturedMouseEvent_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameSinkVideoCaptureOverlayRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::FrameSinkVideoCaptureOverlay::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameSinkVideoCaptureOverlayValidationInfo);
}



}  // viz::mojom


namespace mojo {


// static
bool StructTraits<::viz::mojom::VideoCaptureTarget::DataView, ::viz::mojom::VideoCaptureTargetPtr>::Read(
    ::viz::mojom::VideoCaptureTarget::DataView input,
    ::viz::mojom::VideoCaptureTargetPtr* output) {
  bool success = true;
  ::viz::mojom::VideoCaptureTargetPtr result(::viz::mojom::VideoCaptureTarget::New());
  
      if (success && !input.ReadFrameSinkId(&result->frame_sink_id))
        success = false;
      if (success && !input.ReadSubTarget(&result->sub_target))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::viz::mojom::VideoCaptureSubTarget::DataView, ::viz::mojom::VideoCaptureSubTargetPtr>::Read(
    ::viz::mojom::VideoCaptureSubTarget::DataView input,
    ::viz::mojom::VideoCaptureSubTargetPtr* output) {
  using UnionType = ::viz::mojom::VideoCaptureSubTarget;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSubtreeCaptureId: {
      ::viz::SubtreeCaptureId result_subtree_capture_id;
      if (!input.ReadSubtreeCaptureId(&result_subtree_capture_id))
        return false;

      *output = UnionType::NewSubtreeCaptureId(
          std::move(result_subtree_capture_id));
      break;
    }
    case Tag::kRegionCaptureCropId: {
      ::base::Token result_region_capture_crop_id;
      if (!input.ReadRegionCaptureCropId(&result_region_capture_crop_id))
        return false;

      *output = UnionType::NewRegionCaptureCropId(
          std::move(result_region_capture_crop_id));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {


void FrameSinkVideoConsumerFrameCallbacksInterceptorForTesting::Done() {
  GetForwardingInterface()->Done();
}
void FrameSinkVideoConsumerFrameCallbacksInterceptorForTesting::ProvideFeedback(const ::media::VideoCaptureFeedback& feedback) {
  GetForwardingInterface()->ProvideFeedback(
    std::move(feedback)
    );
}
FrameSinkVideoConsumerFrameCallbacksAsyncWaiter::FrameSinkVideoConsumerFrameCallbacksAsyncWaiter(
    FrameSinkVideoConsumerFrameCallbacks* proxy) : proxy_(proxy) {}

FrameSinkVideoConsumerFrameCallbacksAsyncWaiter::~FrameSinkVideoConsumerFrameCallbacksAsyncWaiter() = default;




void FrameSinkVideoConsumerInterceptorForTesting::OnFrameCaptured(::media::mojom::VideoBufferHandlePtr data, ::media::mojom::VideoFrameInfoPtr info, const ::gfx::Rect& content_rect, ::mojo::PendingRemote<FrameSinkVideoConsumerFrameCallbacks> callbacks) {
  GetForwardingInterface()->OnFrameCaptured(
    std::move(data)
    , 
    std::move(info)
    , 
    std::move(content_rect)
    , 
    std::move(callbacks)
    );
}
void FrameSinkVideoConsumerInterceptorForTesting::OnNewSubCaptureTargetVersion(uint32_t sub_capture_target_version) {
  GetForwardingInterface()->OnNewSubCaptureTargetVersion(
    std::move(sub_capture_target_version)
    );
}
void FrameSinkVideoConsumerInterceptorForTesting::OnFrameWithEmptyRegionCapture() {
  GetForwardingInterface()->OnFrameWithEmptyRegionCapture();
}
void FrameSinkVideoConsumerInterceptorForTesting::OnStopped() {
  GetForwardingInterface()->OnStopped();
}
void FrameSinkVideoConsumerInterceptorForTesting::OnLog(const std::string& message) {
  GetForwardingInterface()->OnLog(
    std::move(message)
    );
}
FrameSinkVideoConsumerAsyncWaiter::FrameSinkVideoConsumerAsyncWaiter(
    FrameSinkVideoConsumer* proxy) : proxy_(proxy) {}

FrameSinkVideoConsumerAsyncWaiter::~FrameSinkVideoConsumerAsyncWaiter() = default;




void FrameSinkVideoCapturerInterceptorForTesting::SetFormat(::media::VideoPixelFormat format) {
  GetForwardingInterface()->SetFormat(
    std::move(format)
    );
}
void FrameSinkVideoCapturerInterceptorForTesting::SetMinCapturePeriod(::base::TimeDelta min_period) {
  GetForwardingInterface()->SetMinCapturePeriod(
    std::move(min_period)
    );
}
void FrameSinkVideoCapturerInterceptorForTesting::SetMinSizeChangePeriod(::base::TimeDelta min_period) {
  GetForwardingInterface()->SetMinSizeChangePeriod(
    std::move(min_period)
    );
}
void FrameSinkVideoCapturerInterceptorForTesting::SetResolutionConstraints(const ::gfx::Size& min_size, const ::gfx::Size& max_size, bool use_fixed_aspect_ratio) {
  GetForwardingInterface()->SetResolutionConstraints(
    std::move(min_size)
    , 
    std::move(max_size)
    , 
    std::move(use_fixed_aspect_ratio)
    );
}
void FrameSinkVideoCapturerInterceptorForTesting::SetAutoThrottlingEnabled(bool enabled) {
  GetForwardingInterface()->SetAutoThrottlingEnabled(
    std::move(enabled)
    );
}
void FrameSinkVideoCapturerInterceptorForTesting::ChangeTarget(const std::optional<::viz::VideoCaptureTarget>& target, uint32_t sub_capture_target_version) {
  GetForwardingInterface()->ChangeTarget(
    std::move(target)
    , 
    std::move(sub_capture_target_version)
    );
}
void FrameSinkVideoCapturerInterceptorForTesting::Start(::mojo::PendingRemote<FrameSinkVideoConsumer> consumer, BufferFormatPreference buffer_format_preference) {
  GetForwardingInterface()->Start(
    std::move(consumer)
    , 
    std::move(buffer_format_preference)
    );
}
void FrameSinkVideoCapturerInterceptorForTesting::Stop() {
  GetForwardingInterface()->Stop();
}
void FrameSinkVideoCapturerInterceptorForTesting::RequestRefreshFrame() {
  GetForwardingInterface()->RequestRefreshFrame();
}
void FrameSinkVideoCapturerInterceptorForTesting::CreateOverlay(int32_t stacking_index, ::mojo::PendingReceiver<FrameSinkVideoCaptureOverlay> receiver) {
  GetForwardingInterface()->CreateOverlay(
    std::move(stacking_index)
    , 
    std::move(receiver)
    );
}
FrameSinkVideoCapturerAsyncWaiter::FrameSinkVideoCapturerAsyncWaiter(
    FrameSinkVideoCapturer* proxy) : proxy_(proxy) {}

FrameSinkVideoCapturerAsyncWaiter::~FrameSinkVideoCapturerAsyncWaiter() = default;




void FrameSinkVideoCaptureOverlayInterceptorForTesting::SetImageAndBounds(const ::SkBitmap& image, const ::gfx::RectF& bounds) {
  GetForwardingInterface()->SetImageAndBounds(
    std::move(image)
    , 
    std::move(bounds)
    );
}
void FrameSinkVideoCaptureOverlayInterceptorForTesting::SetBounds(const ::gfx::RectF& bounds) {
  GetForwardingInterface()->SetBounds(
    std::move(bounds)
    );
}
void FrameSinkVideoCaptureOverlayInterceptorForTesting::OnCapturedMouseEvent(const ::gfx::Point& coordinates) {
  GetForwardingInterface()->OnCapturedMouseEvent(
    std::move(coordinates)
    );
}
FrameSinkVideoCaptureOverlayAsyncWaiter::FrameSinkVideoCaptureOverlayAsyncWaiter(
    FrameSinkVideoCaptureOverlay* proxy) : proxy_(proxy) {}

FrameSinkVideoCaptureOverlayAsyncWaiter::~FrameSinkVideoCaptureOverlayAsyncWaiter() = default;






}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif