// services/viz/public/mojom/compositing/copy_output_result.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_RESULT_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_RESULT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/copy_output_result.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox.mojom-shared.h"
#include "services/viz/public/mojom/compositing/bitmap_in_shared_memory.mojom-shared.h"
#include "services/viz/public/mojom/compositing/texture_releaser.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace viz::mojom {
class CopyOutputResultDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::CopyOutputResultDataView> {
  using Data = ::viz::mojom::internal::CopyOutputResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class CopyOutputResultFormat : int32_t {
  
  RGBA = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

 std::ostream& operator<<(std::ostream& os, CopyOutputResultFormat value);
inline bool IsKnownEnumValue(CopyOutputResultFormat value) {
  return internal::CopyOutputResultFormat_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CopyOutputResultDestination : int32_t {
  
  kSystemMemory = 0,
  
  kNativeTextures = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CopyOutputResultDestination value);
inline bool IsKnownEnumValue(CopyOutputResultDestination value) {
  return internal::CopyOutputResultDestination_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class CopyOutputResultDataView {
 public:
  CopyOutputResultDataView() = default;

  CopyOutputResultDataView(
      internal::CopyOutputResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadFormat(UserType* output) const {
    auto data_value = data_->format;
    return mojo::internal::Deserialize<::viz::mojom::CopyOutputResultFormat>(
        data_value, output);
  }
  CopyOutputResultFormat format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::CopyOutputResultFormat>(data_->format));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDestination(UserType* output) const {
    auto data_value = data_->destination;
    return mojo::internal::Deserialize<::viz::mojom::CopyOutputResultDestination>(
        data_value, output);
  }
  CopyOutputResultDestination destination() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::CopyOutputResultDestination>(data_->destination));
  }
  inline void GetRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRect(UserType* output) {
    
    auto* pointer = data_->rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetBitmapDataView(
      ::viz::mojom::BitmapInSharedMemoryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBitmap(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::viz::mojom::BitmapInSharedMemoryDataView, UserType>(),
    "Attempting to read the optional `bitmap` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBitmap` instead "
    "of `ReadBitmap if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bitmap.Get();
    return mojo::internal::Deserialize<::viz::mojom::BitmapInSharedMemoryDataView>(
        pointer, output, message_);
  }
  inline void GetMailboxDataView(
      ::gpu::mojom::MailboxDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMailbox(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::MailboxDataView, UserType>(),
    "Attempting to read the optional `mailbox` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMailbox` instead "
    "of `ReadMailbox if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mailbox.Get();
    return mojo::internal::Deserialize<::gpu::mojom::MailboxDataView>(
        pointer, output, message_);
  }
  inline void GetColorSpaceDataView(
      ::gfx::mojom::ColorSpaceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorSpace(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::ColorSpaceDataView, UserType>(),
    "Attempting to read the optional `color_space` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadColorSpace` instead "
    "of `ReadColorSpace if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->color_space.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ColorSpaceDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeReleaser() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::viz::mojom::TextureReleaserInterfaceBase>>(
            &data_->releaser, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CopyOutputResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

namespace std {

template <>
struct hash<::viz::mojom::CopyOutputResultFormat>
    : public mojo::internal::EnumHashImpl<::viz::mojom::CopyOutputResultFormat> {};

template <>
struct hash<::viz::mojom::CopyOutputResultDestination>
    : public mojo::internal::EnumHashImpl<::viz::mojom::CopyOutputResultDestination> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::CopyOutputResultFormat, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::CopyOutputResultFormat, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::CopyOutputResultFormat>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::CopyOutputResultDestination, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::CopyOutputResultDestination, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::CopyOutputResultDestination>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::CopyOutputResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::CopyOutputResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::CopyOutputResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::viz::mojom::CopyOutputResultFormat>(
        Traits::format(input), &fragment->format);
    mojo::internal::Serialize<::viz::mojom::CopyOutputResultDestination>(
        Traits::destination(input), &fragment->destination);
    decltype(Traits::rect(input)) in_rect = Traits::rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rect)::BaseType> rect_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_rect, rect_fragment);
    fragment->rect.Set(
        rect_fragment.is_null() ? nullptr : rect_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rect in CopyOutputResult struct");
    decltype(Traits::bitmap(input)) in_bitmap = Traits::bitmap(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bitmap)::BaseType> bitmap_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::BitmapInSharedMemoryDataView>(
        in_bitmap, bitmap_fragment);
    fragment->bitmap.Set(
        bitmap_fragment.is_null() ? nullptr : bitmap_fragment.data());
    decltype(Traits::mailbox(input)) in_mailbox = Traits::mailbox(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mailbox)::BaseType> mailbox_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::MailboxDataView>(
        in_mailbox, mailbox_fragment);
    fragment->mailbox.Set(
        mailbox_fragment.is_null() ? nullptr : mailbox_fragment.data());
    decltype(Traits::color_space(input)) in_color_space = Traits::color_space(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_space)::BaseType> color_space_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::ColorSpaceDataView>(
        in_color_space, color_space_fragment);
    fragment->color_space.Set(
        color_space_fragment.is_null() ? nullptr : color_space_fragment.data());
    decltype(Traits::releaser(input)) in_releaser = Traits::releaser(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::TextureReleaserInterfaceBase>>(
        in_releaser, &fragment->releaser, &fragment.message());
  }

  static bool Deserialize(::viz::mojom::internal::CopyOutputResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::CopyOutputResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void CopyOutputResultDataView::GetRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void CopyOutputResultDataView::GetBitmapDataView(
    ::viz::mojom::BitmapInSharedMemoryDataView* output) {
  auto pointer = data_->bitmap.Get();
  *output = ::viz::mojom::BitmapInSharedMemoryDataView(pointer, message_);
}
inline void CopyOutputResultDataView::GetMailboxDataView(
    ::gpu::mojom::MailboxDataView* output) {
  auto pointer = data_->mailbox.Get();
  *output = ::gpu::mojom::MailboxDataView(pointer, message_);
}
inline void CopyOutputResultDataView::GetColorSpaceDataView(
    ::gfx::mojom::ColorSpaceDataView* output) {
  auto pointer = data_->color_space.Get();
  *output = ::gfx::mojom::ColorSpaceDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::CopyOutputResultFormat> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::CopyOutputResultFormat value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::CopyOutputResultDestination> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::CopyOutputResultDestination value);
};

} // namespace perfetto

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COPY_OUTPUT_RESULT_MOJOM_SHARED_H_