// services/viz/public/mojom/compositing/offset_tag.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_OFFSET_TAG_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_OFFSET_TAG_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/offset_tag.mojom-shared-internal.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_range.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"







namespace viz::mojom {
class OffsetTagDataView;

class OffsetTagValueDataView;

class OffsetTagDefinitionDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::OffsetTagDataView> {
  using Data = ::viz::mojom::internal::OffsetTag_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::OffsetTagValueDataView> {
  using Data = ::viz::mojom::internal::OffsetTagValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::OffsetTagDefinitionDataView> {
  using Data = ::viz::mojom::internal::OffsetTagDefinition_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


class OffsetTagDataView {
 public:
  OffsetTagDataView() = default;

  OffsetTagDataView(
      internal::OffsetTag_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      ::mojo_base::mojom::TokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::OffsetTag_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OffsetTagValueDataView {
 public:
  OffsetTagValueDataView() = default;

  OffsetTagValueDataView(
      internal::OffsetTagValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTagDataView(
      OffsetTagDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTag(UserType* output) {
    
    auto* pointer = data_->tag.Get();
    return mojo::internal::Deserialize<::viz::mojom::OffsetTagDataView>(
        pointer, output, message_);
  }
  inline void GetOffsetDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOffset(UserType* output) {
    
    auto* pointer = data_->offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
 private:
  internal::OffsetTagValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OffsetTagDefinitionDataView {
 public:
  OffsetTagDefinitionDataView() = default;

  OffsetTagDefinitionDataView(
      internal::OffsetTagDefinition_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTagDataView(
      OffsetTagDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTag(UserType* output) {
    
    auto* pointer = data_->tag.Get();
    return mojo::internal::Deserialize<::viz::mojom::OffsetTagDataView>(
        pointer, output, message_);
  }
  inline void GetProviderDataView(
      ::viz::mojom::SurfaceRangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProvider(UserType* output) {
    
    auto* pointer = data_->provider.Get();
    return mojo::internal::Deserialize<::viz::mojom::SurfaceRangeDataView>(
        pointer, output, message_);
  }
  inline void GetMinOffsetDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMinOffset(UserType* output) {
    
    auto* pointer = data_->min_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
  inline void GetMaxOffsetDataView(
      ::gfx::mojom::Vector2dFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMaxOffset(UserType* output) {
    
    auto* pointer = data_->max_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dFDataView>(
        pointer, output, message_);
  }
 private:
  internal::OffsetTagDefinition_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::OffsetTagDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::OffsetTagDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::OffsetTag_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::token(input)) in_token = Traits::token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->token)::BaseType> token_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
        in_token, token_fragment);
    fragment->token.Set(
        token_fragment.is_null() ? nullptr : token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null token in OffsetTag struct");
  }

  static bool Deserialize(::viz::mojom::internal::OffsetTag_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::OffsetTagDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::OffsetTagValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::OffsetTagValueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::OffsetTagValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::tag(input)) in_tag = Traits::tag(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tag)::BaseType> tag_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::OffsetTagDataView>(
        in_tag, tag_fragment);
    fragment->tag.Set(
        tag_fragment.is_null() ? nullptr : tag_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->tag.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tag in OffsetTagValue struct");
    decltype(Traits::offset(input)) in_offset = Traits::offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->offset)::BaseType> offset_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_offset, offset_fragment);
    fragment->offset.Set(
        offset_fragment.is_null() ? nullptr : offset_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->offset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null offset in OffsetTagValue struct");
  }

  static bool Deserialize(::viz::mojom::internal::OffsetTagValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::OffsetTagValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::OffsetTagDefinitionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::OffsetTagDefinitionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::OffsetTagDefinition_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::tag(input)) in_tag = Traits::tag(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tag)::BaseType> tag_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::OffsetTagDataView>(
        in_tag, tag_fragment);
    fragment->tag.Set(
        tag_fragment.is_null() ? nullptr : tag_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->tag.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tag in OffsetTagDefinition struct");
    decltype(Traits::provider(input)) in_provider = Traits::provider(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->provider)::BaseType> provider_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::SurfaceRangeDataView>(
        in_provider, provider_fragment);
    fragment->provider.Set(
        provider_fragment.is_null() ? nullptr : provider_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->provider.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null provider in OffsetTagDefinition struct");
    decltype(Traits::min_offset(input)) in_min_offset = Traits::min_offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->min_offset)::BaseType> min_offset_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_min_offset, min_offset_fragment);
    fragment->min_offset.Set(
        min_offset_fragment.is_null() ? nullptr : min_offset_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->min_offset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null min_offset in OffsetTagDefinition struct");
    decltype(Traits::max_offset(input)) in_max_offset = Traits::max_offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->max_offset)::BaseType> max_offset_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
        in_max_offset, max_offset_fragment);
    fragment->max_offset.Set(
        max_offset_fragment.is_null() ? nullptr : max_offset_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->max_offset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null max_offset in OffsetTagDefinition struct");
  }

  static bool Deserialize(::viz::mojom::internal::OffsetTagDefinition_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::OffsetTagDefinitionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void OffsetTagDataView::GetTokenDataView(
    ::mojo_base::mojom::TokenDataView* output) {
  auto pointer = data_->token.Get();
  *output = ::mojo_base::mojom::TokenDataView(pointer, message_);
}


inline void OffsetTagValueDataView::GetTagDataView(
    OffsetTagDataView* output) {
  auto pointer = data_->tag.Get();
  *output = OffsetTagDataView(pointer, message_);
}
inline void OffsetTagValueDataView::GetOffsetDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->offset.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}


inline void OffsetTagDefinitionDataView::GetTagDataView(
    OffsetTagDataView* output) {
  auto pointer = data_->tag.Get();
  *output = OffsetTagDataView(pointer, message_);
}
inline void OffsetTagDefinitionDataView::GetProviderDataView(
    ::viz::mojom::SurfaceRangeDataView* output) {
  auto pointer = data_->provider.Get();
  *output = ::viz::mojom::SurfaceRangeDataView(pointer, message_);
}
inline void OffsetTagDefinitionDataView::GetMinOffsetDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->min_offset.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}
inline void OffsetTagDefinitionDataView::GetMaxOffsetDataView(
    ::gfx::mojom::Vector2dFDataView* output) {
  auto pointer = data_->max_offset.Get();
  *output = ::gfx::mojom::Vector2dFDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_OFFSET_TAG_MOJOM_SHARED_H_