// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "LinePropertyGroup.h"

#include <QQmlEngine>

#include "QuickStyle.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

LinePropertyGroup::LinePropertyGroup(QuickStyle *style)
    : QObject()
    , m_style(style)
{
    m_image = std::make_unique<ImagePropertyGroup>(m_style);
}

void LinePropertyGroup::update(const std::optional<LineProperty> &newState)
{
    m_state = newState;

    if (!newState) {
        m_image->update(std::nullopt);
    } else {
        m_image->update(newState.value().image());
    }

    Q_EMIT sizeChanged();
    Q_EMIT colorChanged();
    Q_EMIT styleChanged();
    Q_EMIT updated();
}

QJSValue LinePropertyGroup::size() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state.value().size();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue LinePropertyGroup::color() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state.value().color();
    if (value) {
        return m_style->engine()->toScriptValue(value.value().toQColor());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue LinePropertyGroup::style() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state.value().style();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

ImagePropertyGroup *LinePropertyGroup::image() const
{
    return m_image.get();
}

#include "moc_LinePropertyGroup.cpp"