// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "StylePropertyGroup.h"

#include <QQmlEngine>

#include "QuickStyle.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

StylePropertyGroup::StylePropertyGroup(QuickStyle *style)
    : QObject()
    , m_style(style)
{
    m_layout = std::make_unique<LayoutPropertyGroup>(m_style);
    m_text = std::make_unique<TextPropertyGroup>(m_style);
    m_icon = std::make_unique<IconPropertyGroup>(m_style);
    m_background = std::make_unique<BackgroundPropertyGroup>(m_style);
    m_border = std::make_unique<BorderPropertyGroup>(m_style);
    m_outline = std::make_unique<OutlinePropertyGroup>(m_style);
    m_corners = std::make_unique<CornersPropertyGroup>(m_style);
    m_shadow = std::make_unique<ShadowPropertyGroup>(m_style);
}

void StylePropertyGroup::update(const std::optional<StyleProperty> &newState)
{
    m_state = newState;

    if (!newState) {
        m_layout->update(std::nullopt);
        m_text->update(std::nullopt);
        m_icon->update(std::nullopt);
        m_background->update(std::nullopt);
        m_border->update(std::nullopt);
        m_outline->update(std::nullopt);
        m_corners->update(std::nullopt);
        m_shadow->update(std::nullopt);
    } else {
        m_layout->update(newState.value().layout());
        m_text->update(newState.value().text());
        m_icon->update(newState.value().icon());
        m_background->update(newState.value().background());
        m_border->update(newState.value().border());
        m_outline->update(newState.value().outline());
        m_corners->update(newState.value().corners());
        m_shadow->update(newState.value().shadow());
    }

    Q_EMIT updated();
}

LayoutPropertyGroup *StylePropertyGroup::layout() const
{
    return m_layout.get();
}

TextPropertyGroup *StylePropertyGroup::text() const
{
    return m_text.get();
}

IconPropertyGroup *StylePropertyGroup::icon() const
{
    return m_icon.get();
}

BackgroundPropertyGroup *StylePropertyGroup::background() const
{
    return m_background.get();
}

BorderPropertyGroup *StylePropertyGroup::border() const
{
    return m_border.get();
}

OutlinePropertyGroup *StylePropertyGroup::outline() const
{
    return m_outline.get();
}

CornersPropertyGroup *StylePropertyGroup::corners() const
{
    return m_corners.get();
}

ShadowPropertyGroup *StylePropertyGroup::shadow() const
{
    return m_shadow.get();
}

#include "moc_StylePropertyGroup.cpp"