// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "CornerProperty.h"

#include <QRegularExpression>

#include "PropertiesTypes.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class Union::Properties::CornerPropertyPrivate
{
public:
    std::optional<qreal> radius;
    std::optional<qreal> width;
    std::optional<qreal> height;
    std::optional<Union::Color> color;
    std::unique_ptr<ImageProperty> image;
};

CornerProperty::CornerProperty()
    : d(std::make_unique<CornerPropertyPrivate>())
{
}

CornerProperty::CornerProperty(const CornerProperty &other)
    : d(std::make_unique<CornerPropertyPrivate>())
{
    d->radius = other.d->radius;
    d->width = other.d->width;
    d->height = other.d->height;
    d->color = other.d->color;
    d->image = std::make_unique<ImageProperty>();
    *(d->image) = *(other.d->image);
}

CornerProperty::CornerProperty(CornerProperty &&other)
    : d(std::move(other.d))
{
}

CornerProperty::~CornerProperty() = default;

CornerProperty &CornerProperty::operator=(const CornerProperty &other)
{
    if (this != &other) {
        d->radius = other.d->radius;
        d->width = other.d->width;
        d->height = other.d->height;
        d->color = other.d->color;
        *(d->image) = *(other.d->image);
    }
    return *this;
}

CornerProperty &CornerProperty::operator=(CornerProperty &&other)
{
    std::swap(d, other.d);
    return *this;
}

std::optional<qreal> CornerProperty::radius() const
{
    return d->radius;
}

void CornerProperty::setRadius(const std::optional<qreal> &newValue)
{
    if (newValue == d->radius) {
        return;
    }

    d->radius = newValue;
}

std::optional<qreal> CornerProperty::width() const
{
    return d->width;
}

void CornerProperty::setWidth(const std::optional<qreal> &newValue)
{
    if (newValue == d->width) {
        return;
    }

    d->width = newValue;
}

std::optional<qreal> CornerProperty::height() const
{
    return d->height;
}

void CornerProperty::setHeight(const std::optional<qreal> &newValue)
{
    if (newValue == d->height) {
        return;
    }

    d->height = newValue;
}

std::optional<Union::Color> CornerProperty::color() const
{
    return d->color;
}

void CornerProperty::setColor(const std::optional<Union::Color> &newValue)
{
    if (newValue == d->color) {
        return;
    }

    d->color = newValue;
}

ImageProperty *CornerProperty::image() const
{
    return d->image.get();
}

void CornerProperty::setImage(std::unique_ptr<ImageProperty> &&newValue)
{
    d->image = std::move(newValue);
}

bool CornerProperty::hasAnyValue() const
{
    if (d->radius.has_value()) {
        return true;
    }
    if (d->width.has_value()) {
        return true;
    }
    if (d->height.has_value()) {
        return true;
    }
    if (d->color.has_value()) {
        return true;
    }
    if (d->image && d->image->hasAnyValue()) {
        return true;
    }
    return false;
}

bool CornerProperty::isEmpty() const
{
    if (!hasAnyValue()) {
        return true;
    }

    if (d->radius.has_value() && d->radius.value() != emptyValue<qreal>()) {
        return false;
    }
    if (d->width.has_value() && d->width.value() != emptyValue<qreal>()) {
        return false;
    }
    if (d->height.has_value() && d->height.value() != emptyValue<qreal>()) {
        return false;
    }
    if (d->color.has_value() && d->color.value() != emptyValue<Union::Color>()) {
        return false;
    }
    if (d->image && !d->image->isEmpty()) {
        return false;
    }

    return true;
}

QString CornerProperty::toString(int indentation, ToStringFlags flags) const
{
    if (!hasAnyValue()) {
        return u"(empty)"_s;
    }

    const bool multiline = flags & ToStringFlag::MultiLine;
    const bool types = flags & ToStringFlag::Types;

    QString result;
    QTextStream out(&result);

    constexpr auto indent = [](int amount, bool multiline, bool first) {
        if (multiline) {
            return QByteArray(amount, ' ');
        } else if (!first) {
            return QByteArray(", ");
        } else {
            return QByteArray(" ");
        }
    };

    const QByteArray maybeNewLine = multiline ? "\n" : "";
    const QByteArray empty = "(empty)";

    if (types) {
        out << "CornerProperty(" << maybeNewLine;
    } else if (indentation > 0) {
        out << maybeNewLine;
    }

    out << indent(indentation, multiline, true) << "radius: ";
    if (d->radius) {
        out << d->radius.value() << maybeNewLine;
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "width: ";
    if (d->width) {
        out << d->width.value() << maybeNewLine;
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "height: ";
    if (d->height) {
        out << d->height.value() << maybeNewLine;
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "color: ";
    if (d->color) {
        out << d->color->toString() << maybeNewLine;
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "image: ";
    if (d->image) {
        out << d->image->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }

    if (types) {
        out << indent(indentation - 2, multiline, true) << ")";
    }
    out << maybeNewLine;

    out.flush();

    return result;
}

void CornerProperty::resolveProperties(const CornerProperty *source, CornerProperty *destination)
{
    if (!source || !destination) {
        return;
    }

    if (!destination->d->radius.has_value()) {
        destination->d->radius = source->d->radius;
    }
    if (!destination->d->width.has_value()) {
        destination->d->width = source->d->width;
    }
    if (!destination->d->height.has_value()) {
        destination->d->height = source->d->height;
    }
    if (!destination->d->color.has_value()) {
        destination->d->color = source->d->color;
    }
    if (source->d->image) {
        if (!destination->d->image) {
            destination->d->image = std::make_unique<ImageProperty>();
        }
        ImageProperty::resolveProperties(source->d->image.get(), destination->d->image.get());
    }
}

std::unique_ptr<CornerProperty> CornerProperty::empty()
{
    auto result = std::make_unique<CornerProperty>();
    result->d->radius = emptyValue<qreal>();
    result->d->width = emptyValue<qreal>();
    result->d->height = emptyValue<qreal>();
    result->d->color = emptyValue<Union::Color>();
    result->d->image = ImageProperty::empty();
    return result;
}

bool Union::Properties::operator==(const CornerProperty &left, const CornerProperty &right)
{
    if (left.radius() != right.radius()) {
        return false;
    }
    if (left.width() != right.width()) {
        return false;
    }
    if (left.height() != right.height()) {
        return false;
    }
    if (left.color() != right.color()) {
        return false;
    }
    if (left.image() && right.image()) {
        if (*(left.image()) != *(right.image())) {
            return false;
        }
    } else if (left.image() != right.image()) {
        return false;
    }
    return true;
}

QDebug operator<<(QDebug debug, Union::Properties::CornerProperty *type)
{
    QDebugStateSaver saver(debug);
    debug.nospace() << qPrintable(type->toString(0, ToStringFlag::Types));
    return debug;
}