/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "aud-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_plugin,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_plugin,
        gboolean arg_enable,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_boolean (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_section,
        const gchar *arg_name,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_section,
        const gchar *arg_name,
        const gchar *arg_value,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gboolean arg_show,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boolean (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_pos,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_vl,
        gint arg_vr,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              g_marshal_value_peek_int (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_band,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_DOUBLE_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectDoubleVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gdouble arg_preamp,
        GVariant *arg_bands,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectDoubleVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectDoubleVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_double (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_DOUBLE (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectDoubleFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gdouble arg_preamp,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectDoubleFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectDoubleFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_double (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_DOUBLE (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectIntDoubleFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        gint arg_band,
        gdouble arg_value,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectIntDoubleFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectIntDoubleFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_int (param_values + 2),
              g_marshal_value_peek_double (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_pos,
        const gchar *arg_tuple,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_url,
        gint arg_pos,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_int (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectBoxedFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *const *arg_filenames,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectBoxedFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectBoxedFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_boxed (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.atheme.audacious
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:ObjAudacious
 * @title: ObjAudacious
 * @short_description: Generated C code for the org.atheme.audacious D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-atheme-audacious.top_of_page">org.atheme.audacious</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.atheme.audacious ---- */

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_version_OUT_ARG_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_version_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_version_OUT_ARG_version.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_version =
{
  {
    -1,
    (gchar *) "Version",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_version_OUT_ARG_pointers,
    NULL
  },
  "handle-version",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_plugin_is_enabled_IN_ARG_plugin =
{
  {
    -1,
    (gchar *) "plugin",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_plugin_is_enabled_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_plugin_is_enabled_IN_ARG_plugin.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_plugin_is_enabled_OUT_ARG_enabled =
{
  {
    -1,
    (gchar *) "enabled",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_plugin_is_enabled_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_plugin_is_enabled_OUT_ARG_enabled.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_plugin_is_enabled =
{
  {
    -1,
    (gchar *) "PluginIsEnabled",
    (GDBusArgInfo **) &_obj_audacious_method_info_plugin_is_enabled_IN_ARG_pointers,
    (GDBusArgInfo **) &_obj_audacious_method_info_plugin_is_enabled_OUT_ARG_pointers,
    NULL
  },
  "handle-plugin-is-enabled",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_plugin_enable_IN_ARG_plugin =
{
  {
    -1,
    (gchar *) "plugin",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_plugin_enable_IN_ARG_enable =
{
  {
    -1,
    (gchar *) "enable",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_plugin_enable_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_plugin_enable_IN_ARG_plugin.parent_struct,
  &_obj_audacious_method_info_plugin_enable_IN_ARG_enable.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_plugin_enable =
{
  {
    -1,
    (gchar *) "PluginEnable",
    (GDBusArgInfo **) &_obj_audacious_method_info_plugin_enable_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-plugin-enable",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_config_get_IN_ARG_section =
{
  {
    -1,
    (gchar *) "section",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_config_get_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_config_get_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_config_get_IN_ARG_section.parent_struct,
  &_obj_audacious_method_info_config_get_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_config_get_OUT_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_config_get_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_config_get_OUT_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_config_get =
{
  {
    -1,
    (gchar *) "ConfigGet",
    (GDBusArgInfo **) &_obj_audacious_method_info_config_get_IN_ARG_pointers,
    (GDBusArgInfo **) &_obj_audacious_method_info_config_get_OUT_ARG_pointers,
    NULL
  },
  "handle-config-get",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_config_set_IN_ARG_section =
{
  {
    -1,
    (gchar *) "section",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_config_set_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_config_set_IN_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_config_set_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_config_set_IN_ARG_section.parent_struct,
  &_obj_audacious_method_info_config_set_IN_ARG_name.parent_struct,
  &_obj_audacious_method_info_config_set_IN_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_config_set =
{
  {
    -1,
    (gchar *) "ConfigSet",
    (GDBusArgInfo **) &_obj_audacious_method_info_config_set_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-config-set",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_quit =
{
  {
    -1,
    (gchar *) "Quit",
    NULL,
    NULL,
    NULL
  },
  "handle-quit",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_show_filebrowser_IN_ARG_show =
{
  {
    -1,
    (gchar *) "show",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_show_filebrowser_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_show_filebrowser_IN_ARG_show.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_show_filebrowser =
{
  {
    -1,
    (gchar *) "ShowFilebrowser",
    (GDBusArgInfo **) &_obj_audacious_method_info_show_filebrowser_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-show-filebrowser",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_eject =
{
  {
    -1,
    (gchar *) "Eject",
    NULL,
    NULL,
    NULL
  },
  "handle-eject",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_main_win_visible_OUT_ARG_is_main_win =
{
  {
    -1,
    (gchar *) "is_main_win",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_main_win_visible_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_main_win_visible_OUT_ARG_is_main_win.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_main_win_visible =
{
  {
    -1,
    (gchar *) "MainWinVisible",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_main_win_visible_OUT_ARG_pointers,
    NULL
  },
  "handle-main-win-visible",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_show_main_win_IN_ARG_show =
{
  {
    -1,
    (gchar *) "show",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_show_main_win_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_show_main_win_IN_ARG_show.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_show_main_win =
{
  {
    -1,
    (gchar *) "ShowMainWin",
    (GDBusArgInfo **) &_obj_audacious_method_info_show_main_win_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-show-main-win",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_show_prefs_box_IN_ARG_show =
{
  {
    -1,
    (gchar *) "show",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_show_prefs_box_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_show_prefs_box_IN_ARG_show.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_show_prefs_box =
{
  {
    -1,
    (gchar *) "ShowPrefsBox",
    (GDBusArgInfo **) &_obj_audacious_method_info_show_prefs_box_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-show-prefs-box",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_show_about_box_IN_ARG_show =
{
  {
    -1,
    (gchar *) "show",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_show_about_box_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_show_about_box_IN_ARG_show.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_show_about_box =
{
  {
    -1,
    (gchar *) "ShowAboutBox",
    (GDBusArgInfo **) &_obj_audacious_method_info_show_about_box_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-show-about-box",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_show_jtf_box_IN_ARG_show =
{
  {
    -1,
    (gchar *) "show",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_show_jtf_box_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_show_jtf_box_IN_ARG_show.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_show_jtf_box =
{
  {
    -1,
    (gchar *) "ShowJtfBox",
    (GDBusArgInfo **) &_obj_audacious_method_info_show_jtf_box_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-show-jtf-box",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_startup_notify_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_startup_notify_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_startup_notify_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_startup_notify =
{
  {
    -1,
    (gchar *) "StartupNotify",
    (GDBusArgInfo **) &_obj_audacious_method_info_startup_notify_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-startup-notify",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_get_tuple_fields_OUT_ARG_fields =
{
  {
    -1,
    (gchar *) "fields",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_get_tuple_fields_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_get_tuple_fields_OUT_ARG_fields.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_get_tuple_fields =
{
  {
    -1,
    (gchar *) "GetTupleFields",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_get_tuple_fields_OUT_ARG_pointers,
    NULL
  },
  "handle-get-tuple-fields",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_play =
{
  {
    -1,
    (gchar *) "Play",
    NULL,
    NULL,
    NULL
  },
  "handle-play",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_pause =
{
  {
    -1,
    (gchar *) "Pause",
    NULL,
    NULL,
    NULL
  },
  "handle-pause",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_play_pause =
{
  {
    -1,
    (gchar *) "PlayPause",
    NULL,
    NULL,
    NULL
  },
  "handle-play-pause",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_stop =
{
  {
    -1,
    (gchar *) "Stop",
    NULL,
    NULL,
    NULL
  },
  "handle-stop",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_playing_OUT_ARG_is_playing =
{
  {
    -1,
    (gchar *) "is_playing",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_playing_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_playing_OUT_ARG_is_playing.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_playing =
{
  {
    -1,
    (gchar *) "Playing",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_playing_OUT_ARG_pointers,
    NULL
  },
  "handle-playing",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_paused_OUT_ARG_is_paused =
{
  {
    -1,
    (gchar *) "is_paused",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_paused_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_paused_OUT_ARG_is_paused.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_paused =
{
  {
    -1,
    (gchar *) "Paused",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_paused_OUT_ARG_pointers,
    NULL
  },
  "handle-paused",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_stopped_OUT_ARG_is_stopped =
{
  {
    -1,
    (gchar *) "is_stopped",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_stopped_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_stopped_OUT_ARG_is_stopped.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_stopped =
{
  {
    -1,
    (gchar *) "Stopped",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_stopped_OUT_ARG_pointers,
    NULL
  },
  "handle-stopped",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_status_OUT_ARG_status =
{
  {
    -1,
    (gchar *) "status",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_status_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_status_OUT_ARG_status.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_status =
{
  {
    -1,
    (gchar *) "Status",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_status_OUT_ARG_pointers,
    NULL
  },
  "handle-status",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_record =
{
  {
    -1,
    (gchar *) "Record",
    NULL,
    NULL,
    NULL
  },
  "handle-record",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_recording_OUT_ARG_is_recording =
{
  {
    -1,
    (gchar *) "is_recording",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_recording_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_recording_OUT_ARG_is_recording.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_recording =
{
  {
    -1,
    (gchar *) "Recording",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_recording_OUT_ARG_pointers,
    NULL
  },
  "handle-recording",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_info_OUT_ARG_rate =
{
  {
    -1,
    (gchar *) "rate",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_info_OUT_ARG_freq =
{
  {
    -1,
    (gchar *) "freq",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_info_OUT_ARG_nch =
{
  {
    -1,
    (gchar *) "nch",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_info_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_info_OUT_ARG_rate.parent_struct,
  &_obj_audacious_method_info_info_OUT_ARG_freq.parent_struct,
  &_obj_audacious_method_info_info_OUT_ARG_nch.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_info =
{
  {
    -1,
    (gchar *) "Info",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_info_OUT_ARG_pointers,
    NULL
  },
  "handle-info",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_get_info_OUT_ARG_rate =
{
  {
    -1,
    (gchar *) "rate",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_get_info_OUT_ARG_freq =
{
  {
    -1,
    (gchar *) "freq",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_get_info_OUT_ARG_nch =
{
  {
    -1,
    (gchar *) "nch",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_get_info_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_get_info_OUT_ARG_rate.parent_struct,
  &_obj_audacious_method_info_get_info_OUT_ARG_freq.parent_struct,
  &_obj_audacious_method_info_get_info_OUT_ARG_nch.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_get_info =
{
  {
    -1,
    (gchar *) "GetInfo",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_get_info_OUT_ARG_pointers,
    NULL
  },
  "handle-get-info",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_time_OUT_ARG_time =
{
  {
    -1,
    (gchar *) "time",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_time_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_time_OUT_ARG_time.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_time =
{
  {
    -1,
    (gchar *) "Time",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_time_OUT_ARG_pointers,
    NULL
  },
  "handle-time",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_seek_IN_ARG_pos =
{
  {
    -1,
    (gchar *) "pos",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_seek_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_seek_IN_ARG_pos.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_seek =
{
  {
    -1,
    (gchar *) "Seek",
    (GDBusArgInfo **) &_obj_audacious_method_info_seek_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-seek",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_volume_OUT_ARG_vl =
{
  {
    -1,
    (gchar *) "vl",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_volume_OUT_ARG_vr =
{
  {
    -1,
    (gchar *) "vr",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_volume_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_volume_OUT_ARG_vl.parent_struct,
  &_obj_audacious_method_info_volume_OUT_ARG_vr.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_volume =
{
  {
    -1,
    (gchar *) "Volume",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_volume_OUT_ARG_pointers,
    NULL
  },
  "handle-volume",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_set_volume_IN_ARG_vl =
{
  {
    -1,
    (gchar *) "vl",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_set_volume_IN_ARG_vr =
{
  {
    -1,
    (gchar *) "vr",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_set_volume_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_set_volume_IN_ARG_vl.parent_struct,
  &_obj_audacious_method_info_set_volume_IN_ARG_vr.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_set_volume =
{
  {
    -1,
    (gchar *) "SetVolume",
    (GDBusArgInfo **) &_obj_audacious_method_info_set_volume_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-volume",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_balance_OUT_ARG_balance =
{
  {
    -1,
    (gchar *) "balance",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_balance_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_balance_OUT_ARG_balance.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_balance =
{
  {
    -1,
    (gchar *) "Balance",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_balance_OUT_ARG_pointers,
    NULL
  },
  "handle-balance",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_get_eq_OUT_ARG_preamp =
{
  {
    -1,
    (gchar *) "preamp",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_get_eq_OUT_ARG_bands =
{
  {
    -1,
    (gchar *) "bands",
    (gchar *) "ad",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_get_eq_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_get_eq_OUT_ARG_preamp.parent_struct,
  &_obj_audacious_method_info_get_eq_OUT_ARG_bands.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_get_eq =
{
  {
    -1,
    (gchar *) "GetEq",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_get_eq_OUT_ARG_pointers,
    NULL
  },
  "handle-get-eq",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_get_eq_preamp_OUT_ARG_preamp =
{
  {
    -1,
    (gchar *) "preamp",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_get_eq_preamp_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_get_eq_preamp_OUT_ARG_preamp.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_get_eq_preamp =
{
  {
    -1,
    (gchar *) "GetEqPreamp",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_get_eq_preamp_OUT_ARG_pointers,
    NULL
  },
  "handle-get-eq-preamp",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_get_eq_band_IN_ARG_band =
{
  {
    -1,
    (gchar *) "band",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_get_eq_band_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_get_eq_band_IN_ARG_band.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_get_eq_band_OUT_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_get_eq_band_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_get_eq_band_OUT_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_get_eq_band =
{
  {
    -1,
    (gchar *) "GetEqBand",
    (GDBusArgInfo **) &_obj_audacious_method_info_get_eq_band_IN_ARG_pointers,
    (GDBusArgInfo **) &_obj_audacious_method_info_get_eq_band_OUT_ARG_pointers,
    NULL
  },
  "handle-get-eq-band",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_set_eq_IN_ARG_preamp =
{
  {
    -1,
    (gchar *) "preamp",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_set_eq_IN_ARG_bands =
{
  {
    -1,
    (gchar *) "bands",
    (gchar *) "ad",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_set_eq_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_set_eq_IN_ARG_preamp.parent_struct,
  &_obj_audacious_method_info_set_eq_IN_ARG_bands.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_set_eq =
{
  {
    -1,
    (gchar *) "SetEq",
    (GDBusArgInfo **) &_obj_audacious_method_info_set_eq_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-eq",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_set_eq_preamp_IN_ARG_preamp =
{
  {
    -1,
    (gchar *) "preamp",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_set_eq_preamp_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_set_eq_preamp_IN_ARG_preamp.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_set_eq_preamp =
{
  {
    -1,
    (gchar *) "SetEqPreamp",
    (GDBusArgInfo **) &_obj_audacious_method_info_set_eq_preamp_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-eq-preamp",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_set_eq_band_IN_ARG_band =
{
  {
    -1,
    (gchar *) "band",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_set_eq_band_IN_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_set_eq_band_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_set_eq_band_IN_ARG_band.parent_struct,
  &_obj_audacious_method_info_set_eq_band_IN_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_set_eq_band =
{
  {
    -1,
    (gchar *) "SetEqBand",
    (GDBusArgInfo **) &_obj_audacious_method_info_set_eq_band_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-eq-band",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_equalizer_activate_IN_ARG_active =
{
  {
    -1,
    (gchar *) "active",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_equalizer_activate_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_equalizer_activate_IN_ARG_active.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_equalizer_activate =
{
  {
    -1,
    (gchar *) "EqualizerActivate",
    (GDBusArgInfo **) &_obj_audacious_method_info_equalizer_activate_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-equalizer-activate",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_select_displayed_playlist =
{
  {
    -1,
    (gchar *) "SelectDisplayedPlaylist",
    NULL,
    NULL,
    NULL
  },
  "handle-select-displayed-playlist",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_select_playing_playlist =
{
  {
    -1,
    (gchar *) "SelectPlayingPlaylist",
    NULL,
    NULL,
    NULL
  },
  "handle-select-playing-playlist",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_position_OUT_ARG_pos =
{
  {
    -1,
    (gchar *) "pos",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_position_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_position_OUT_ARG_pos.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_position =
{
  {
    -1,
    (gchar *) "Position",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_position_OUT_ARG_pointers,
    NULL
  },
  "handle-position",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_advance =
{
  {
    -1,
    (gchar *) "Advance",
    NULL,
    NULL,
    NULL
  },
  "handle-advance",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_advance_album =
{
  {
    -1,
    (gchar *) "AdvanceAlbum",
    NULL,
    NULL,
    NULL
  },
  "handle-advance-album",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_reverse =
{
  {
    -1,
    (gchar *) "Reverse",
    NULL,
    NULL,
    NULL
  },
  "handle-reverse",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_reverse_album =
{
  {
    -1,
    (gchar *) "ReverseAlbum",
    NULL,
    NULL,
    NULL
  },
  "handle-reverse-album",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_length_OUT_ARG_length =
{
  {
    -1,
    (gchar *) "length",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_length_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_length_OUT_ARG_length.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_length =
{
  {
    -1,
    (gchar *) "Length",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_length_OUT_ARG_pointers,
    NULL
  },
  "handle-length",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_song_title_IN_ARG_pos =
{
  {
    -1,
    (gchar *) "pos",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_song_title_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_song_title_IN_ARG_pos.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_song_title_OUT_ARG_title =
{
  {
    -1,
    (gchar *) "title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_song_title_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_song_title_OUT_ARG_title.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_song_title =
{
  {
    -1,
    (gchar *) "SongTitle",
    (GDBusArgInfo **) &_obj_audacious_method_info_song_title_IN_ARG_pointers,
    (GDBusArgInfo **) &_obj_audacious_method_info_song_title_OUT_ARG_pointers,
    NULL
  },
  "handle-song-title",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_song_filename_IN_ARG_pos =
{
  {
    -1,
    (gchar *) "pos",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_song_filename_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_song_filename_IN_ARG_pos.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_song_filename_OUT_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_song_filename_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_song_filename_OUT_ARG_filename.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_song_filename =
{
  {
    -1,
    (gchar *) "SongFilename",
    (GDBusArgInfo **) &_obj_audacious_method_info_song_filename_IN_ARG_pointers,
    (GDBusArgInfo **) &_obj_audacious_method_info_song_filename_OUT_ARG_pointers,
    NULL
  },
  "handle-song-filename",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_song_length_IN_ARG_pos =
{
  {
    -1,
    (gchar *) "pos",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_song_length_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_song_length_IN_ARG_pos.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_song_length_OUT_ARG_length =
{
  {
    -1,
    (gchar *) "length",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_song_length_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_song_length_OUT_ARG_length.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_song_length =
{
  {
    -1,
    (gchar *) "SongLength",
    (GDBusArgInfo **) &_obj_audacious_method_info_song_length_IN_ARG_pointers,
    (GDBusArgInfo **) &_obj_audacious_method_info_song_length_OUT_ARG_pointers,
    NULL
  },
  "handle-song-length",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_song_frames_IN_ARG_pos =
{
  {
    -1,
    (gchar *) "pos",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_song_frames_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_song_frames_IN_ARG_pos.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_song_frames_OUT_ARG_length =
{
  {
    -1,
    (gchar *) "length",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_song_frames_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_song_frames_OUT_ARG_length.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_song_frames =
{
  {
    -1,
    (gchar *) "SongFrames",
    (GDBusArgInfo **) &_obj_audacious_method_info_song_frames_IN_ARG_pointers,
    (GDBusArgInfo **) &_obj_audacious_method_info_song_frames_OUT_ARG_pointers,
    NULL
  },
  "handle-song-frames",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_song_tuple_IN_ARG_pos =
{
  {
    -1,
    (gchar *) "pos",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_song_tuple_IN_ARG_tuple =
{
  {
    -1,
    (gchar *) "tuple",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_song_tuple_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_song_tuple_IN_ARG_pos.parent_struct,
  &_obj_audacious_method_info_song_tuple_IN_ARG_tuple.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_song_tuple_OUT_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_song_tuple_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_song_tuple_OUT_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_song_tuple =
{
  {
    -1,
    (gchar *) "SongTuple",
    (GDBusArgInfo **) &_obj_audacious_method_info_song_tuple_IN_ARG_pointers,
    (GDBusArgInfo **) &_obj_audacious_method_info_song_tuple_OUT_ARG_pointers,
    NULL
  },
  "handle-song-tuple",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_jump_IN_ARG_pos =
{
  {
    -1,
    (gchar *) "pos",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_jump_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_jump_IN_ARG_pos.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_jump =
{
  {
    -1,
    (gchar *) "Jump",
    (GDBusArgInfo **) &_obj_audacious_method_info_jump_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-jump",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_add_IN_ARG_file =
{
  {
    -1,
    (gchar *) "file",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_add_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_add_IN_ARG_file.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_add =
{
  {
    -1,
    (gchar *) "Add",
    (GDBusArgInfo **) &_obj_audacious_method_info_add_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-add",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_add_url_IN_ARG_url =
{
  {
    -1,
    (gchar *) "url",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_add_url_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_add_url_IN_ARG_url.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_add_url =
{
  {
    -1,
    (gchar *) "AddUrl",
    (GDBusArgInfo **) &_obj_audacious_method_info_add_url_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-add-url",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_playlist_add_IN_ARG_list =
{
  {
    -1,
    (gchar *) "list",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_playlist_add_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_playlist_add_IN_ARG_list.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_playlist_add =
{
  {
    -1,
    (gchar *) "PlaylistAdd",
    (GDBusArgInfo **) &_obj_audacious_method_info_playlist_add_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-playlist-add",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_playlist_ins_url_string_IN_ARG_url =
{
  {
    -1,
    (gchar *) "url",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_playlist_ins_url_string_IN_ARG_pos =
{
  {
    -1,
    (gchar *) "pos",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_playlist_ins_url_string_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_playlist_ins_url_string_IN_ARG_url.parent_struct,
  &_obj_audacious_method_info_playlist_ins_url_string_IN_ARG_pos.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_playlist_ins_url_string =
{
  {
    -1,
    (gchar *) "PlaylistInsUrlString",
    (GDBusArgInfo **) &_obj_audacious_method_info_playlist_ins_url_string_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-playlist-ins-url-string",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_add_list_IN_ARG_filenames =
{
  {
    -1,
    (gchar *) "filenames",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_add_list_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_add_list_IN_ARG_filenames.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_add_list =
{
  {
    -1,
    (gchar *) "AddList",
    (GDBusArgInfo **) &_obj_audacious_method_info_add_list_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-add-list",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_open_list_IN_ARG_filenames =
{
  {
    -1,
    (gchar *) "filenames",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_open_list_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_open_list_IN_ARG_filenames.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_open_list =
{
  {
    -1,
    (gchar *) "OpenList",
    (GDBusArgInfo **) &_obj_audacious_method_info_open_list_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-open-list",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_playlist_enqueue_to_temp_IN_ARG_url =
{
  {
    -1,
    (gchar *) "url",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_playlist_enqueue_to_temp_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_playlist_enqueue_to_temp_IN_ARG_url.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_playlist_enqueue_to_temp =
{
  {
    -1,
    (gchar *) "PlaylistEnqueueToTemp",
    (GDBusArgInfo **) &_obj_audacious_method_info_playlist_enqueue_to_temp_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-playlist-enqueue-to-temp",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_open_list_to_temp_IN_ARG_filenames =
{
  {
    -1,
    (gchar *) "filenames",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_open_list_to_temp_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_open_list_to_temp_IN_ARG_filenames.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_open_list_to_temp =
{
  {
    -1,
    (gchar *) "OpenListToTemp",
    (GDBusArgInfo **) &_obj_audacious_method_info_open_list_to_temp_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-open-list-to-temp",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_delete_IN_ARG_pos =
{
  {
    -1,
    (gchar *) "pos",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_delete_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_delete_IN_ARG_pos.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_delete =
{
  {
    -1,
    (gchar *) "Delete",
    (GDBusArgInfo **) &_obj_audacious_method_info_delete_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-delete",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_clear =
{
  {
    -1,
    (gchar *) "Clear",
    NULL,
    NULL,
    NULL
  },
  "handle-clear",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_auto_advance_OUT_ARG_is_advance =
{
  {
    -1,
    (gchar *) "is_advance",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_auto_advance_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_auto_advance_OUT_ARG_is_advance.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_auto_advance =
{
  {
    -1,
    (gchar *) "AutoAdvance",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_auto_advance_OUT_ARG_pointers,
    NULL
  },
  "handle-auto-advance",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_toggle_auto_advance =
{
  {
    -1,
    (gchar *) "ToggleAutoAdvance",
    NULL,
    NULL,
    NULL
  },
  "handle-toggle-auto-advance",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_repeat_OUT_ARG_is_repeat =
{
  {
    -1,
    (gchar *) "is_repeat",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_repeat_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_repeat_OUT_ARG_is_repeat.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_repeat =
{
  {
    -1,
    (gchar *) "Repeat",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_repeat_OUT_ARG_pointers,
    NULL
  },
  "handle-repeat",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_toggle_repeat =
{
  {
    -1,
    (gchar *) "ToggleRepeat",
    NULL,
    NULL,
    NULL
  },
  "handle-toggle-repeat",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_shuffle_OUT_ARG_is_shuffle =
{
  {
    -1,
    (gchar *) "is_shuffle",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_shuffle_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_shuffle_OUT_ARG_is_shuffle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_shuffle =
{
  {
    -1,
    (gchar *) "Shuffle",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_shuffle_OUT_ARG_pointers,
    NULL
  },
  "handle-shuffle",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_toggle_shuffle =
{
  {
    -1,
    (gchar *) "ToggleShuffle",
    NULL,
    NULL,
    NULL
  },
  "handle-toggle-shuffle",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_stop_after_OUT_ARG_is_stopping =
{
  {
    -1,
    (gchar *) "is_stopping",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_stop_after_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_stop_after_OUT_ARG_is_stopping.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_stop_after =
{
  {
    -1,
    (gchar *) "StopAfter",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_stop_after_OUT_ARG_pointers,
    NULL
  },
  "handle-stop-after",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_toggle_stop_after =
{
  {
    -1,
    (gchar *) "ToggleStopAfter",
    NULL,
    NULL,
    NULL
  },
  "handle-toggle-stop-after",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_queue_get_list_pos_IN_ARG_qpos =
{
  {
    -1,
    (gchar *) "qpos",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_queue_get_list_pos_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_queue_get_list_pos_IN_ARG_qpos.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_queue_get_list_pos_OUT_ARG_pos =
{
  {
    -1,
    (gchar *) "pos",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_queue_get_list_pos_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_queue_get_list_pos_OUT_ARG_pos.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_queue_get_list_pos =
{
  {
    -1,
    (gchar *) "QueueGetListPos",
    (GDBusArgInfo **) &_obj_audacious_method_info_queue_get_list_pos_IN_ARG_pointers,
    (GDBusArgInfo **) &_obj_audacious_method_info_queue_get_list_pos_OUT_ARG_pointers,
    NULL
  },
  "handle-queue-get-list-pos",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_queue_get_queue_pos_IN_ARG_pos =
{
  {
    -1,
    (gchar *) "pos",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_queue_get_queue_pos_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_queue_get_queue_pos_IN_ARG_pos.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_queue_get_queue_pos_OUT_ARG_qpos =
{
  {
    -1,
    (gchar *) "qpos",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_queue_get_queue_pos_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_queue_get_queue_pos_OUT_ARG_qpos.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_queue_get_queue_pos =
{
  {
    -1,
    (gchar *) "QueueGetQueuePos",
    (GDBusArgInfo **) &_obj_audacious_method_info_queue_get_queue_pos_IN_ARG_pointers,
    (GDBusArgInfo **) &_obj_audacious_method_info_queue_get_queue_pos_OUT_ARG_pointers,
    NULL
  },
  "handle-queue-get-queue-pos",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_get_playqueue_length_OUT_ARG_length =
{
  {
    -1,
    (gchar *) "length",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_get_playqueue_length_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_get_playqueue_length_OUT_ARG_length.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_get_playqueue_length =
{
  {
    -1,
    (gchar *) "GetPlayqueueLength",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_get_playqueue_length_OUT_ARG_pointers,
    NULL
  },
  "handle-get-playqueue-length",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_playqueue_add_IN_ARG_pos =
{
  {
    -1,
    (gchar *) "pos",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_playqueue_add_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_playqueue_add_IN_ARG_pos.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_playqueue_add =
{
  {
    -1,
    (gchar *) "PlayqueueAdd",
    (GDBusArgInfo **) &_obj_audacious_method_info_playqueue_add_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-playqueue-add",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_playqueue_remove_IN_ARG_pos =
{
  {
    -1,
    (gchar *) "pos",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_playqueue_remove_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_playqueue_remove_IN_ARG_pos.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_playqueue_remove =
{
  {
    -1,
    (gchar *) "PlayqueueRemove",
    (GDBusArgInfo **) &_obj_audacious_method_info_playqueue_remove_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-playqueue-remove",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_playqueue_clear =
{
  {
    -1,
    (gchar *) "PlayqueueClear",
    NULL,
    NULL,
    NULL
  },
  "handle-playqueue-clear",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_playqueue_is_queued_IN_ARG_pos =
{
  {
    -1,
    (gchar *) "pos",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_playqueue_is_queued_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_playqueue_is_queued_IN_ARG_pos.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_playqueue_is_queued_OUT_ARG_is_queued =
{
  {
    -1,
    (gchar *) "is_queued",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_playqueue_is_queued_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_playqueue_is_queued_OUT_ARG_is_queued.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_playqueue_is_queued =
{
  {
    -1,
    (gchar *) "PlayqueueIsQueued",
    (GDBusArgInfo **) &_obj_audacious_method_info_playqueue_is_queued_IN_ARG_pointers,
    (GDBusArgInfo **) &_obj_audacious_method_info_playqueue_is_queued_OUT_ARG_pointers,
    NULL
  },
  "handle-playqueue-is-queued",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_number_of_playlists_OUT_ARG_count =
{
  {
    -1,
    (gchar *) "count",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_number_of_playlists_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_number_of_playlists_OUT_ARG_count.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_number_of_playlists =
{
  {
    -1,
    (gchar *) "NumberOfPlaylists",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_number_of_playlists_OUT_ARG_pointers,
    NULL
  },
  "handle-number-of-playlists",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_get_active_playlist_OUT_ARG_plnum =
{
  {
    -1,
    (gchar *) "plnum",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_get_active_playlist_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_get_active_playlist_OUT_ARG_plnum.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_get_active_playlist =
{
  {
    -1,
    (gchar *) "GetActivePlaylist",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_get_active_playlist_OUT_ARG_pointers,
    NULL
  },
  "handle-get-active-playlist",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_set_active_playlist_IN_ARG_plnum =
{
  {
    -1,
    (gchar *) "plnum",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_set_active_playlist_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_set_active_playlist_IN_ARG_plnum.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_set_active_playlist =
{
  {
    -1,
    (gchar *) "SetActivePlaylist",
    (GDBusArgInfo **) &_obj_audacious_method_info_set_active_playlist_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-active-playlist",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_get_active_playlist_name_OUT_ARG_plname =
{
  {
    -1,
    (gchar *) "plname",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_get_active_playlist_name_OUT_ARG_pointers[] =
{
  &_obj_audacious_method_info_get_active_playlist_name_OUT_ARG_plname.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_get_active_playlist_name =
{
  {
    -1,
    (gchar *) "GetActivePlaylistName",
    NULL,
    (GDBusArgInfo **) &_obj_audacious_method_info_get_active_playlist_name_OUT_ARG_pointers,
    NULL
  },
  "handle-get-active-playlist-name",
  FALSE
};

static const _ExtendedGDBusArgInfo _obj_audacious_method_info_set_active_playlist_name_IN_ARG_plname =
{
  {
    -1,
    (gchar *) "plname",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _obj_audacious_method_info_set_active_playlist_name_IN_ARG_pointers[] =
{
  &_obj_audacious_method_info_set_active_playlist_name_IN_ARG_plname.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_set_active_playlist_name =
{
  {
    -1,
    (gchar *) "SetActivePlaylistName",
    (GDBusArgInfo **) &_obj_audacious_method_info_set_active_playlist_name_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-active-playlist-name",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_new_playlist =
{
  {
    -1,
    (gchar *) "NewPlaylist",
    NULL,
    NULL,
    NULL
  },
  "handle-new-playlist",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_delete_active_playlist =
{
  {
    -1,
    (gchar *) "DeleteActivePlaylist",
    NULL,
    NULL,
    NULL
  },
  "handle-delete-active-playlist",
  FALSE
};

static const _ExtendedGDBusMethodInfo _obj_audacious_method_info_play_active_playlist =
{
  {
    -1,
    (gchar *) "PlayActivePlaylist",
    NULL,
    NULL,
    NULL
  },
  "handle-play-active-playlist",
  FALSE
};

static const GDBusMethodInfo * const _obj_audacious_method_info_pointers[] =
{
  &_obj_audacious_method_info_version.parent_struct,
  &_obj_audacious_method_info_plugin_is_enabled.parent_struct,
  &_obj_audacious_method_info_plugin_enable.parent_struct,
  &_obj_audacious_method_info_config_get.parent_struct,
  &_obj_audacious_method_info_config_set.parent_struct,
  &_obj_audacious_method_info_quit.parent_struct,
  &_obj_audacious_method_info_show_filebrowser.parent_struct,
  &_obj_audacious_method_info_eject.parent_struct,
  &_obj_audacious_method_info_main_win_visible.parent_struct,
  &_obj_audacious_method_info_show_main_win.parent_struct,
  &_obj_audacious_method_info_show_prefs_box.parent_struct,
  &_obj_audacious_method_info_show_about_box.parent_struct,
  &_obj_audacious_method_info_show_jtf_box.parent_struct,
  &_obj_audacious_method_info_startup_notify.parent_struct,
  &_obj_audacious_method_info_get_tuple_fields.parent_struct,
  &_obj_audacious_method_info_play.parent_struct,
  &_obj_audacious_method_info_pause.parent_struct,
  &_obj_audacious_method_info_play_pause.parent_struct,
  &_obj_audacious_method_info_stop.parent_struct,
  &_obj_audacious_method_info_playing.parent_struct,
  &_obj_audacious_method_info_paused.parent_struct,
  &_obj_audacious_method_info_stopped.parent_struct,
  &_obj_audacious_method_info_status.parent_struct,
  &_obj_audacious_method_info_record.parent_struct,
  &_obj_audacious_method_info_recording.parent_struct,
  &_obj_audacious_method_info_info.parent_struct,
  &_obj_audacious_method_info_get_info.parent_struct,
  &_obj_audacious_method_info_time.parent_struct,
  &_obj_audacious_method_info_seek.parent_struct,
  &_obj_audacious_method_info_volume.parent_struct,
  &_obj_audacious_method_info_set_volume.parent_struct,
  &_obj_audacious_method_info_balance.parent_struct,
  &_obj_audacious_method_info_get_eq.parent_struct,
  &_obj_audacious_method_info_get_eq_preamp.parent_struct,
  &_obj_audacious_method_info_get_eq_band.parent_struct,
  &_obj_audacious_method_info_set_eq.parent_struct,
  &_obj_audacious_method_info_set_eq_preamp.parent_struct,
  &_obj_audacious_method_info_set_eq_band.parent_struct,
  &_obj_audacious_method_info_equalizer_activate.parent_struct,
  &_obj_audacious_method_info_select_displayed_playlist.parent_struct,
  &_obj_audacious_method_info_select_playing_playlist.parent_struct,
  &_obj_audacious_method_info_position.parent_struct,
  &_obj_audacious_method_info_advance.parent_struct,
  &_obj_audacious_method_info_advance_album.parent_struct,
  &_obj_audacious_method_info_reverse.parent_struct,
  &_obj_audacious_method_info_reverse_album.parent_struct,
  &_obj_audacious_method_info_length.parent_struct,
  &_obj_audacious_method_info_song_title.parent_struct,
  &_obj_audacious_method_info_song_filename.parent_struct,
  &_obj_audacious_method_info_song_length.parent_struct,
  &_obj_audacious_method_info_song_frames.parent_struct,
  &_obj_audacious_method_info_song_tuple.parent_struct,
  &_obj_audacious_method_info_jump.parent_struct,
  &_obj_audacious_method_info_add.parent_struct,
  &_obj_audacious_method_info_add_url.parent_struct,
  &_obj_audacious_method_info_playlist_add.parent_struct,
  &_obj_audacious_method_info_playlist_ins_url_string.parent_struct,
  &_obj_audacious_method_info_add_list.parent_struct,
  &_obj_audacious_method_info_open_list.parent_struct,
  &_obj_audacious_method_info_playlist_enqueue_to_temp.parent_struct,
  &_obj_audacious_method_info_open_list_to_temp.parent_struct,
  &_obj_audacious_method_info_delete.parent_struct,
  &_obj_audacious_method_info_clear.parent_struct,
  &_obj_audacious_method_info_auto_advance.parent_struct,
  &_obj_audacious_method_info_toggle_auto_advance.parent_struct,
  &_obj_audacious_method_info_repeat.parent_struct,
  &_obj_audacious_method_info_toggle_repeat.parent_struct,
  &_obj_audacious_method_info_shuffle.parent_struct,
  &_obj_audacious_method_info_toggle_shuffle.parent_struct,
  &_obj_audacious_method_info_stop_after.parent_struct,
  &_obj_audacious_method_info_toggle_stop_after.parent_struct,
  &_obj_audacious_method_info_queue_get_list_pos.parent_struct,
  &_obj_audacious_method_info_queue_get_queue_pos.parent_struct,
  &_obj_audacious_method_info_get_playqueue_length.parent_struct,
  &_obj_audacious_method_info_playqueue_add.parent_struct,
  &_obj_audacious_method_info_playqueue_remove.parent_struct,
  &_obj_audacious_method_info_playqueue_clear.parent_struct,
  &_obj_audacious_method_info_playqueue_is_queued.parent_struct,
  &_obj_audacious_method_info_number_of_playlists.parent_struct,
  &_obj_audacious_method_info_get_active_playlist.parent_struct,
  &_obj_audacious_method_info_set_active_playlist.parent_struct,
  &_obj_audacious_method_info_get_active_playlist_name.parent_struct,
  &_obj_audacious_method_info_set_active_playlist_name.parent_struct,
  &_obj_audacious_method_info_new_playlist.parent_struct,
  &_obj_audacious_method_info_delete_active_playlist.parent_struct,
  &_obj_audacious_method_info_play_active_playlist.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _obj_audacious_interface_info =
{
  {
    -1,
    (gchar *) "org.atheme.audacious",
    (GDBusMethodInfo **) &_obj_audacious_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "audacious",
};


/**
 * obj_audacious_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-atheme-audacious.top_of_page">org.atheme.audacious</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
obj_audacious_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_obj_audacious_interface_info.parent_struct;
}

/**
 * obj_audacious_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #ObjAudacious interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
obj_audacious_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
obj_audacious_method_marshal_version (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_plugin_is_enabled (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_plugin_enable (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_config_get (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_config_set (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_quit (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_show_filebrowser (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_eject (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_main_win_visible (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_show_main_win (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_show_prefs_box (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_show_about_box (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_show_jtf_box (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_startup_notify (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_get_tuple_fields (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_play (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_pause (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_play_pause (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_stop (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_playing (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_paused (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_stopped (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_status (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_record (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_recording (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_info (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_get_info (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_time (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_seek (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_volume (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_set_volume (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_balance (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_get_eq (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_get_eq_preamp (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_get_eq_band (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_set_eq (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_DOUBLE_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_set_eq_preamp (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_DOUBLE (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_set_eq_band (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT_DOUBLE (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_equalizer_activate (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_select_displayed_playlist (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_select_playing_playlist (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_position (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_advance (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_advance_album (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_reverse (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_reverse_album (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_length (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_song_title (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_song_filename (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_song_length (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_song_frames (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_song_tuple (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_jump (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_add (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_add_url (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_playlist_add (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_playlist_ins_url_string (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_add_list (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_open_list (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_playlist_enqueue_to_temp (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_open_list_to_temp (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_BOXED (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_delete (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_clear (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_auto_advance (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_toggle_auto_advance (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_repeat (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_toggle_repeat (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_shuffle (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_toggle_shuffle (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_stop_after (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_toggle_stop_after (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_queue_get_list_pos (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_queue_get_queue_pos (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_get_playqueue_length (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_playqueue_add (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_playqueue_remove (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_playqueue_clear (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_playqueue_is_queued (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_number_of_playlists (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_get_active_playlist (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_set_active_playlist (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_get_active_playlist_name (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_set_active_playlist_name (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_new_playlist (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_delete_active_playlist (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
obj_audacious_method_marshal_play_active_playlist (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * ObjAudacious:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-atheme-audacious.top_of_page">org.atheme.audacious</link>.
 */

/**
 * ObjAudaciousIface:
 * @parent_iface: The parent interface.
 * @handle_add: Handler for the #ObjAudacious::handle-add signal.
 * @handle_add_list: Handler for the #ObjAudacious::handle-add-list signal.
 * @handle_add_url: Handler for the #ObjAudacious::handle-add-url signal.
 * @handle_advance: Handler for the #ObjAudacious::handle-advance signal.
 * @handle_advance_album: Handler for the #ObjAudacious::handle-advance-album signal.
 * @handle_auto_advance: Handler for the #ObjAudacious::handle-auto-advance signal.
 * @handle_balance: Handler for the #ObjAudacious::handle-balance signal.
 * @handle_clear: Handler for the #ObjAudacious::handle-clear signal.
 * @handle_config_get: Handler for the #ObjAudacious::handle-config-get signal.
 * @handle_config_set: Handler for the #ObjAudacious::handle-config-set signal.
 * @handle_delete: Handler for the #ObjAudacious::handle-delete signal.
 * @handle_delete_active_playlist: Handler for the #ObjAudacious::handle-delete-active-playlist signal.
 * @handle_eject: Handler for the #ObjAudacious::handle-eject signal.
 * @handle_equalizer_activate: Handler for the #ObjAudacious::handle-equalizer-activate signal.
 * @handle_get_active_playlist: Handler for the #ObjAudacious::handle-get-active-playlist signal.
 * @handle_get_active_playlist_name: Handler for the #ObjAudacious::handle-get-active-playlist-name signal.
 * @handle_get_eq: Handler for the #ObjAudacious::handle-get-eq signal.
 * @handle_get_eq_band: Handler for the #ObjAudacious::handle-get-eq-band signal.
 * @handle_get_eq_preamp: Handler for the #ObjAudacious::handle-get-eq-preamp signal.
 * @handle_get_info: Handler for the #ObjAudacious::handle-get-info signal.
 * @handle_get_playqueue_length: Handler for the #ObjAudacious::handle-get-playqueue-length signal.
 * @handle_get_tuple_fields: Handler for the #ObjAudacious::handle-get-tuple-fields signal.
 * @handle_info: Handler for the #ObjAudacious::handle-info signal.
 * @handle_jump: Handler for the #ObjAudacious::handle-jump signal.
 * @handle_length: Handler for the #ObjAudacious::handle-length signal.
 * @handle_main_win_visible: Handler for the #ObjAudacious::handle-main-win-visible signal.
 * @handle_new_playlist: Handler for the #ObjAudacious::handle-new-playlist signal.
 * @handle_number_of_playlists: Handler for the #ObjAudacious::handle-number-of-playlists signal.
 * @handle_open_list: Handler for the #ObjAudacious::handle-open-list signal.
 * @handle_open_list_to_temp: Handler for the #ObjAudacious::handle-open-list-to-temp signal.
 * @handle_pause: Handler for the #ObjAudacious::handle-pause signal.
 * @handle_paused: Handler for the #ObjAudacious::handle-paused signal.
 * @handle_play: Handler for the #ObjAudacious::handle-play signal.
 * @handle_play_active_playlist: Handler for the #ObjAudacious::handle-play-active-playlist signal.
 * @handle_play_pause: Handler for the #ObjAudacious::handle-play-pause signal.
 * @handle_playing: Handler for the #ObjAudacious::handle-playing signal.
 * @handle_playlist_add: Handler for the #ObjAudacious::handle-playlist-add signal.
 * @handle_playlist_enqueue_to_temp: Handler for the #ObjAudacious::handle-playlist-enqueue-to-temp signal.
 * @handle_playlist_ins_url_string: Handler for the #ObjAudacious::handle-playlist-ins-url-string signal.
 * @handle_playqueue_add: Handler for the #ObjAudacious::handle-playqueue-add signal.
 * @handle_playqueue_clear: Handler for the #ObjAudacious::handle-playqueue-clear signal.
 * @handle_playqueue_is_queued: Handler for the #ObjAudacious::handle-playqueue-is-queued signal.
 * @handle_playqueue_remove: Handler for the #ObjAudacious::handle-playqueue-remove signal.
 * @handle_plugin_enable: Handler for the #ObjAudacious::handle-plugin-enable signal.
 * @handle_plugin_is_enabled: Handler for the #ObjAudacious::handle-plugin-is-enabled signal.
 * @handle_position: Handler for the #ObjAudacious::handle-position signal.
 * @handle_queue_get_list_pos: Handler for the #ObjAudacious::handle-queue-get-list-pos signal.
 * @handle_queue_get_queue_pos: Handler for the #ObjAudacious::handle-queue-get-queue-pos signal.
 * @handle_quit: Handler for the #ObjAudacious::handle-quit signal.
 * @handle_record: Handler for the #ObjAudacious::handle-record signal.
 * @handle_recording: Handler for the #ObjAudacious::handle-recording signal.
 * @handle_repeat: Handler for the #ObjAudacious::handle-repeat signal.
 * @handle_reverse: Handler for the #ObjAudacious::handle-reverse signal.
 * @handle_reverse_album: Handler for the #ObjAudacious::handle-reverse-album signal.
 * @handle_seek: Handler for the #ObjAudacious::handle-seek signal.
 * @handle_select_displayed_playlist: Handler for the #ObjAudacious::handle-select-displayed-playlist signal.
 * @handle_select_playing_playlist: Handler for the #ObjAudacious::handle-select-playing-playlist signal.
 * @handle_set_active_playlist: Handler for the #ObjAudacious::handle-set-active-playlist signal.
 * @handle_set_active_playlist_name: Handler for the #ObjAudacious::handle-set-active-playlist-name signal.
 * @handle_set_eq: Handler for the #ObjAudacious::handle-set-eq signal.
 * @handle_set_eq_band: Handler for the #ObjAudacious::handle-set-eq-band signal.
 * @handle_set_eq_preamp: Handler for the #ObjAudacious::handle-set-eq-preamp signal.
 * @handle_set_volume: Handler for the #ObjAudacious::handle-set-volume signal.
 * @handle_show_about_box: Handler for the #ObjAudacious::handle-show-about-box signal.
 * @handle_show_filebrowser: Handler for the #ObjAudacious::handle-show-filebrowser signal.
 * @handle_show_jtf_box: Handler for the #ObjAudacious::handle-show-jtf-box signal.
 * @handle_show_main_win: Handler for the #ObjAudacious::handle-show-main-win signal.
 * @handle_show_prefs_box: Handler for the #ObjAudacious::handle-show-prefs-box signal.
 * @handle_shuffle: Handler for the #ObjAudacious::handle-shuffle signal.
 * @handle_song_filename: Handler for the #ObjAudacious::handle-song-filename signal.
 * @handle_song_frames: Handler for the #ObjAudacious::handle-song-frames signal.
 * @handle_song_length: Handler for the #ObjAudacious::handle-song-length signal.
 * @handle_song_title: Handler for the #ObjAudacious::handle-song-title signal.
 * @handle_song_tuple: Handler for the #ObjAudacious::handle-song-tuple signal.
 * @handle_startup_notify: Handler for the #ObjAudacious::handle-startup-notify signal.
 * @handle_status: Handler for the #ObjAudacious::handle-status signal.
 * @handle_stop: Handler for the #ObjAudacious::handle-stop signal.
 * @handle_stop_after: Handler for the #ObjAudacious::handle-stop-after signal.
 * @handle_stopped: Handler for the #ObjAudacious::handle-stopped signal.
 * @handle_time: Handler for the #ObjAudacious::handle-time signal.
 * @handle_toggle_auto_advance: Handler for the #ObjAudacious::handle-toggle-auto-advance signal.
 * @handle_toggle_repeat: Handler for the #ObjAudacious::handle-toggle-repeat signal.
 * @handle_toggle_shuffle: Handler for the #ObjAudacious::handle-toggle-shuffle signal.
 * @handle_toggle_stop_after: Handler for the #ObjAudacious::handle-toggle-stop-after signal.
 * @handle_version: Handler for the #ObjAudacious::handle-version signal.
 * @handle_volume: Handler for the #ObjAudacious::handle-volume signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-atheme-audacious.top_of_page">org.atheme.audacious</link>.
 */

typedef ObjAudaciousIface ObjAudaciousInterface;
G_DEFINE_INTERFACE (ObjAudacious, obj_audacious, G_TYPE_OBJECT)

static void
obj_audacious_default_init (ObjAudaciousIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * ObjAudacious::handle-version:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Version">Version()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_version() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-version",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_version),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_version,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-plugin-is-enabled:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_plugin: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.PluginIsEnabled">PluginIsEnabled()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_plugin_is_enabled() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-plugin-is-enabled",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_plugin_is_enabled),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_plugin_is_enabled,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * ObjAudacious::handle-plugin-enable:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_plugin: Argument passed by remote caller.
   * @arg_enable: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.PluginEnable">PluginEnable()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_plugin_enable() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-plugin-enable",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_plugin_enable),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_plugin_enable,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /**
   * ObjAudacious::handle-config-get:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_section: Argument passed by remote caller.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.ConfigGet">ConfigGet()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_config_get() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-config-get",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_config_get),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_config_get,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * ObjAudacious::handle-config-set:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_section: Argument passed by remote caller.
   * @arg_name: Argument passed by remote caller.
   * @arg_value: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.ConfigSet">ConfigSet()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_config_set() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-config-set",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_config_set),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_config_set,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * ObjAudacious::handle-quit:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Quit">Quit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_quit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-quit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_quit),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_quit,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-show-filebrowser:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_show: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.ShowFilebrowser">ShowFilebrowser()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_show_filebrowser() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-show-filebrowser",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_show_filebrowser),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_show_filebrowser,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * ObjAudacious::handle-eject:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Eject">Eject()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_eject() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-eject",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_eject),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_eject,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-main-win-visible:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.MainWinVisible">MainWinVisible()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_main_win_visible() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-main-win-visible",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_main_win_visible),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_main_win_visible,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-show-main-win:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_show: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.ShowMainWin">ShowMainWin()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_show_main_win() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-show-main-win",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_show_main_win),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_show_main_win,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * ObjAudacious::handle-show-prefs-box:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_show: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.ShowPrefsBox">ShowPrefsBox()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_show_prefs_box() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-show-prefs-box",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_show_prefs_box),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_show_prefs_box,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * ObjAudacious::handle-show-about-box:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_show: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.ShowAboutBox">ShowAboutBox()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_show_about_box() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-show-about-box",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_show_about_box),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_show_about_box,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * ObjAudacious::handle-show-jtf-box:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_show: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.ShowJtfBox">ShowJtfBox()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_show_jtf_box() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-show-jtf-box",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_show_jtf_box),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_show_jtf_box,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * ObjAudacious::handle-startup-notify:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.StartupNotify">StartupNotify()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_startup_notify() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-startup-notify",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_startup_notify),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_startup_notify,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * ObjAudacious::handle-get-tuple-fields:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.GetTupleFields">GetTupleFields()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_get_tuple_fields() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-tuple-fields",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_get_tuple_fields),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_get_tuple_fields,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-play:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Play">Play()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_play() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-play",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_play),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_play,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-pause:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Pause">Pause()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_pause() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pause",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_pause),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_pause,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-play-pause:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.PlayPause">PlayPause()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_play_pause() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-play-pause",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_play_pause),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_play_pause,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-stop:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Stop">Stop()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_stop() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_stop),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_stop,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-playing:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Playing">Playing()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_playing() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-playing",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_playing),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_playing,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-paused:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Paused">Paused()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_paused() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-paused",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_paused),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_paused,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-stopped:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Stopped">Stopped()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_stopped() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stopped",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_stopped),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_stopped,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-status:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Status">Status()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_status() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-status",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_status),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_status,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-record:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Record">Record()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_record() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-record",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_record),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_record,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-recording:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Recording">Recording()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_recording() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-recording",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_recording),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_recording,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-info:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Info">Info()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_info() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-info",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_info),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_info,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-get-info:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.GetInfo">GetInfo()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_get_info() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-info",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_get_info),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_get_info,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-time:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Time">Time()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_time() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-time",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_time),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_time,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-seek:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pos: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Seek">Seek()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_seek() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-seek",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_seek),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_seek,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * ObjAudacious::handle-volume:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Volume">Volume()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_volume() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-volume",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_volume),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_volume,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-set-volume:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_vl: Argument passed by remote caller.
   * @arg_vr: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.SetVolume">SetVolume()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_set_volume() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-volume",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_set_volume),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_set_volume,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT);

  /**
   * ObjAudacious::handle-balance:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Balance">Balance()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_balance() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-balance",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_balance),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_balance,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-get-eq:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.GetEq">GetEq()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_get_eq() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-eq",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_get_eq),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_get_eq,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-get-eq-preamp:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.GetEqPreamp">GetEqPreamp()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_get_eq_preamp() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-eq-preamp",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_get_eq_preamp),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_get_eq_preamp,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-get-eq-band:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_band: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.GetEqBand">GetEqBand()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_get_eq_band() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-eq-band",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_get_eq_band),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_get_eq_band,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

  /**
   * ObjAudacious::handle-set-eq:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_preamp: Argument passed by remote caller.
   * @arg_bands: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.SetEq">SetEq()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_set_eq() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-eq",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_set_eq),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_set_eq,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_DOUBLE, G_TYPE_VARIANT);

  /**
   * ObjAudacious::handle-set-eq-preamp:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_preamp: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.SetEqPreamp">SetEqPreamp()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_set_eq_preamp() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-eq-preamp",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_set_eq_preamp),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_set_eq_preamp,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_DOUBLE);

  /**
   * ObjAudacious::handle-set-eq-band:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_band: Argument passed by remote caller.
   * @arg_value: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.SetEqBand">SetEqBand()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_set_eq_band() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-eq-band",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_set_eq_band),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_set_eq_band,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_DOUBLE);

  /**
   * ObjAudacious::handle-equalizer-activate:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_active: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.EqualizerActivate">EqualizerActivate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_equalizer_activate() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-equalizer-activate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_equalizer_activate),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_equalizer_activate,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * ObjAudacious::handle-select-displayed-playlist:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.SelectDisplayedPlaylist">SelectDisplayedPlaylist()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_select_displayed_playlist() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-select-displayed-playlist",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_select_displayed_playlist),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_select_displayed_playlist,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-select-playing-playlist:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.SelectPlayingPlaylist">SelectPlayingPlaylist()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_select_playing_playlist() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-select-playing-playlist",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_select_playing_playlist),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_select_playing_playlist,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-position:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Position">Position()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_position() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-position",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_position),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_position,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-advance:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Advance">Advance()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_advance() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-advance",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_advance),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_advance,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-advance-album:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.AdvanceAlbum">AdvanceAlbum()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_advance_album() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-advance-album",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_advance_album),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_advance_album,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-reverse:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Reverse">Reverse()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_reverse() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reverse",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_reverse),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_reverse,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-reverse-album:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.ReverseAlbum">ReverseAlbum()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_reverse_album() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-reverse-album",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_reverse_album),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_reverse_album,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-length:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Length">Length()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_length() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-length",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_length),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_length,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-song-title:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pos: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.SongTitle">SongTitle()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_song_title() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-song-title",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_song_title),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_song_title,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * ObjAudacious::handle-song-filename:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pos: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.SongFilename">SongFilename()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_song_filename() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-song-filename",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_song_filename),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_song_filename,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * ObjAudacious::handle-song-length:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pos: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.SongLength">SongLength()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_song_length() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-song-length",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_song_length),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_song_length,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * ObjAudacious::handle-song-frames:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pos: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.SongFrames">SongFrames()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_song_frames() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-song-frames",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_song_frames),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_song_frames,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * ObjAudacious::handle-song-tuple:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pos: Argument passed by remote caller.
   * @arg_tuple: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.SongTuple">SongTuple()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_song_tuple() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-song-tuple",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_song_tuple),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_song_tuple,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_STRING);

  /**
   * ObjAudacious::handle-jump:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pos: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Jump">Jump()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_jump() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-jump",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_jump),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_jump,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * ObjAudacious::handle-add:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_file: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Add">Add()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_add() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_add),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_add,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * ObjAudacious::handle-add-url:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_url: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.AddUrl">AddUrl()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_add_url() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-url",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_add_url),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_add_url,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * ObjAudacious::handle-playlist-add:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_list: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.PlaylistAdd">PlaylistAdd()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_playlist_add() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-playlist-add",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_playlist_add),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_playlist_add,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * ObjAudacious::handle-playlist-ins-url-string:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_url: Argument passed by remote caller.
   * @arg_pos: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.PlaylistInsUrlString">PlaylistInsUrlString()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_playlist_ins_url_string() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-playlist-ins-url-string",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_playlist_ins_url_string),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_playlist_ins_url_string,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_INT);

  /**
   * ObjAudacious::handle-add-list:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_filenames: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.AddList">AddList()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_add_list() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-list",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_add_list),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_add_list,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * ObjAudacious::handle-open-list:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_filenames: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.OpenList">OpenList()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_open_list() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open-list",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_open_list),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_open_list,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * ObjAudacious::handle-playlist-enqueue-to-temp:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_url: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.PlaylistEnqueueToTemp">PlaylistEnqueueToTemp()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_playlist_enqueue_to_temp() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-playlist-enqueue-to-temp",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_playlist_enqueue_to_temp),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_playlist_enqueue_to_temp,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * ObjAudacious::handle-open-list-to-temp:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_filenames: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.OpenListToTemp">OpenListToTemp()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_open_list_to_temp() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open-list-to-temp",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_open_list_to_temp),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_open_list_to_temp,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRV);

  /**
   * ObjAudacious::handle-delete:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pos: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Delete">Delete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_delete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_delete),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_delete,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * ObjAudacious::handle-clear:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Clear">Clear()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_clear() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-clear",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_clear),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_clear,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-auto-advance:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.AutoAdvance">AutoAdvance()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_auto_advance() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-auto-advance",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_auto_advance),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_auto_advance,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-toggle-auto-advance:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.ToggleAutoAdvance">ToggleAutoAdvance()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_toggle_auto_advance() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-toggle-auto-advance",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_toggle_auto_advance),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_toggle_auto_advance,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-repeat:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Repeat">Repeat()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_repeat() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-repeat",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_repeat),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_repeat,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-toggle-repeat:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.ToggleRepeat">ToggleRepeat()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_toggle_repeat() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-toggle-repeat",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_toggle_repeat),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_toggle_repeat,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-shuffle:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.Shuffle">Shuffle()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_shuffle() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-shuffle",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_shuffle),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_shuffle,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-toggle-shuffle:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.ToggleShuffle">ToggleShuffle()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_toggle_shuffle() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-toggle-shuffle",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_toggle_shuffle),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_toggle_shuffle,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-stop-after:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.StopAfter">StopAfter()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_stop_after() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop-after",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_stop_after),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_stop_after,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-toggle-stop-after:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.ToggleStopAfter">ToggleStopAfter()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_toggle_stop_after() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-toggle-stop-after",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_toggle_stop_after),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_toggle_stop_after,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-queue-get-list-pos:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_qpos: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.QueueGetListPos">QueueGetListPos()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_queue_get_list_pos() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-queue-get-list-pos",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_queue_get_list_pos),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_queue_get_list_pos,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * ObjAudacious::handle-queue-get-queue-pos:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pos: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.QueueGetQueuePos">QueueGetQueuePos()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_queue_get_queue_pos() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-queue-get-queue-pos",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_queue_get_queue_pos),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_queue_get_queue_pos,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * ObjAudacious::handle-get-playqueue-length:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.GetPlayqueueLength">GetPlayqueueLength()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_get_playqueue_length() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-playqueue-length",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_get_playqueue_length),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_get_playqueue_length,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-playqueue-add:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pos: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.PlayqueueAdd">PlayqueueAdd()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_playqueue_add() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-playqueue-add",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_playqueue_add),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_playqueue_add,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

  /**
   * ObjAudacious::handle-playqueue-remove:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pos: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.PlayqueueRemove">PlayqueueRemove()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_playqueue_remove() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-playqueue-remove",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_playqueue_remove),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_playqueue_remove,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

  /**
   * ObjAudacious::handle-playqueue-clear:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.PlayqueueClear">PlayqueueClear()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_playqueue_clear() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-playqueue-clear",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_playqueue_clear),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_playqueue_clear,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-playqueue-is-queued:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pos: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.PlayqueueIsQueued">PlayqueueIsQueued()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_playqueue_is_queued() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-playqueue-is-queued",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_playqueue_is_queued),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_playqueue_is_queued,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

  /**
   * ObjAudacious::handle-number-of-playlists:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.NumberOfPlaylists">NumberOfPlaylists()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_number_of_playlists() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-number-of-playlists",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_number_of_playlists),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_number_of_playlists,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-get-active-playlist:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.GetActivePlaylist">GetActivePlaylist()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_get_active_playlist() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-active-playlist",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_get_active_playlist),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_get_active_playlist,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-set-active-playlist:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_plnum: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.SetActivePlaylist">SetActivePlaylist()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_set_active_playlist() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-active-playlist",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_set_active_playlist),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_set_active_playlist,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

  /**
   * ObjAudacious::handle-get-active-playlist-name:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.GetActivePlaylistName">GetActivePlaylistName()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_get_active_playlist_name() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-active-playlist-name",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_get_active_playlist_name),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_get_active_playlist_name,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-set-active-playlist-name:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_plname: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.SetActivePlaylistName">SetActivePlaylistName()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_set_active_playlist_name() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-active-playlist-name",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_set_active_playlist_name),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_set_active_playlist_name,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * ObjAudacious::handle-new-playlist:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.NewPlaylist">NewPlaylist()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_new_playlist() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-new-playlist",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_new_playlist),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_new_playlist,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-delete-active-playlist:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.DeleteActivePlaylist">DeleteActivePlaylist()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_delete_active_playlist() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete-active-playlist",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_delete_active_playlist),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_delete_active_playlist,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * ObjAudacious::handle-play-active-playlist:
   * @object: A #ObjAudacious.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-atheme-audacious.PlayActivePlaylist">PlayActivePlaylist()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call obj_audacious_complete_play_active_playlist() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-play-active-playlist",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (ObjAudaciousIface, handle_play_active_playlist),
    g_signal_accumulator_true_handled,
    NULL,
      obj_audacious_method_marshal_play_active_playlist,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * obj_audacious_call_version:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Version">Version()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_version_finish() to get the result of the operation.
 *
 * See obj_audacious_call_version_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_version (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Version",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_version_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_version: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_version().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_version().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_version_finish (
    ObjAudacious *proxy,
    gchar **out_version,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_version);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_version_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_version: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Version">Version()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_version() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_version_sync (
    ObjAudacious *proxy,
    gchar **out_version,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Version",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_version);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_plugin_is_enabled:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_plugin: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PluginIsEnabled">PluginIsEnabled()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_plugin_is_enabled_finish() to get the result of the operation.
 *
 * See obj_audacious_call_plugin_is_enabled_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_plugin_is_enabled (
    ObjAudacious *proxy,
    const gchar *arg_plugin,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PluginIsEnabled",
    g_variant_new ("(s)",
                   arg_plugin),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_plugin_is_enabled_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_enabled: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_plugin_is_enabled().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_plugin_is_enabled().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_plugin_is_enabled_finish (
    ObjAudacious *proxy,
    gboolean *out_enabled,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_enabled);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_plugin_is_enabled_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_plugin: Argument to pass with the method invocation.
 * @out_enabled: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PluginIsEnabled">PluginIsEnabled()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_plugin_is_enabled() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_plugin_is_enabled_sync (
    ObjAudacious *proxy,
    const gchar *arg_plugin,
    gboolean *out_enabled,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PluginIsEnabled",
    g_variant_new ("(s)",
                   arg_plugin),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_enabled);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_plugin_enable:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_plugin: Argument to pass with the method invocation.
 * @arg_enable: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PluginEnable">PluginEnable()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_plugin_enable_finish() to get the result of the operation.
 *
 * See obj_audacious_call_plugin_enable_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_plugin_enable (
    ObjAudacious *proxy,
    const gchar *arg_plugin,
    gboolean arg_enable,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PluginEnable",
    g_variant_new ("(sb)",
                   arg_plugin,
                   arg_enable),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_plugin_enable_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_plugin_enable().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_plugin_enable().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_plugin_enable_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_plugin_enable_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_plugin: Argument to pass with the method invocation.
 * @arg_enable: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PluginEnable">PluginEnable()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_plugin_enable() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_plugin_enable_sync (
    ObjAudacious *proxy,
    const gchar *arg_plugin,
    gboolean arg_enable,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PluginEnable",
    g_variant_new ("(sb)",
                   arg_plugin,
                   arg_enable),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_config_get:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_section: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ConfigGet">ConfigGet()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_config_get_finish() to get the result of the operation.
 *
 * See obj_audacious_call_config_get_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_config_get (
    ObjAudacious *proxy,
    const gchar *arg_section,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ConfigGet",
    g_variant_new ("(ss)",
                   arg_section,
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_config_get_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_config_get().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_config_get().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_config_get_finish (
    ObjAudacious *proxy,
    gchar **out_value,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_config_get_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_section: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ConfigGet">ConfigGet()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_config_get() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_config_get_sync (
    ObjAudacious *proxy,
    const gchar *arg_section,
    const gchar *arg_name,
    gchar **out_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ConfigGet",
    g_variant_new ("(ss)",
                   arg_section,
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_config_set:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_section: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ConfigSet">ConfigSet()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_config_set_finish() to get the result of the operation.
 *
 * See obj_audacious_call_config_set_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_config_set (
    ObjAudacious *proxy,
    const gchar *arg_section,
    const gchar *arg_name,
    const gchar *arg_value,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ConfigSet",
    g_variant_new ("(sss)",
                   arg_section,
                   arg_name,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_config_set_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_config_set().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_config_set().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_config_set_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_config_set_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_section: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ConfigSet">ConfigSet()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_config_set() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_config_set_sync (
    ObjAudacious *proxy,
    const gchar *arg_section,
    const gchar *arg_name,
    const gchar *arg_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ConfigSet",
    g_variant_new ("(sss)",
                   arg_section,
                   arg_name,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_quit:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Quit">Quit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_quit_finish() to get the result of the operation.
 *
 * See obj_audacious_call_quit_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_quit (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Quit",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_quit_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_quit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_quit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_quit_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_quit_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Quit">Quit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_quit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_quit_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Quit",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_show_filebrowser:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_show: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ShowFilebrowser">ShowFilebrowser()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_show_filebrowser_finish() to get the result of the operation.
 *
 * See obj_audacious_call_show_filebrowser_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_show_filebrowser (
    ObjAudacious *proxy,
    gboolean arg_show,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ShowFilebrowser",
    g_variant_new ("(b)",
                   arg_show),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_show_filebrowser_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_show_filebrowser().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_show_filebrowser().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_show_filebrowser_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_show_filebrowser_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_show: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ShowFilebrowser">ShowFilebrowser()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_show_filebrowser() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_show_filebrowser_sync (
    ObjAudacious *proxy,
    gboolean arg_show,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ShowFilebrowser",
    g_variant_new ("(b)",
                   arg_show),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_eject:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Eject">Eject()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_eject_finish() to get the result of the operation.
 *
 * See obj_audacious_call_eject_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_eject (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Eject",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_eject_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_eject().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_eject().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_eject_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_eject_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Eject">Eject()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_eject() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_eject_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Eject",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_main_win_visible:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.MainWinVisible">MainWinVisible()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_main_win_visible_finish() to get the result of the operation.
 *
 * See obj_audacious_call_main_win_visible_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_main_win_visible (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "MainWinVisible",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_main_win_visible_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_is_main_win: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_main_win_visible().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_main_win_visible().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_main_win_visible_finish (
    ObjAudacious *proxy,
    gboolean *out_is_main_win,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_main_win);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_main_win_visible_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_is_main_win: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.MainWinVisible">MainWinVisible()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_main_win_visible() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_main_win_visible_sync (
    ObjAudacious *proxy,
    gboolean *out_is_main_win,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "MainWinVisible",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_main_win);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_show_main_win:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_show: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ShowMainWin">ShowMainWin()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_show_main_win_finish() to get the result of the operation.
 *
 * See obj_audacious_call_show_main_win_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_show_main_win (
    ObjAudacious *proxy,
    gboolean arg_show,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ShowMainWin",
    g_variant_new ("(b)",
                   arg_show),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_show_main_win_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_show_main_win().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_show_main_win().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_show_main_win_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_show_main_win_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_show: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ShowMainWin">ShowMainWin()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_show_main_win() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_show_main_win_sync (
    ObjAudacious *proxy,
    gboolean arg_show,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ShowMainWin",
    g_variant_new ("(b)",
                   arg_show),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_show_prefs_box:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_show: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ShowPrefsBox">ShowPrefsBox()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_show_prefs_box_finish() to get the result of the operation.
 *
 * See obj_audacious_call_show_prefs_box_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_show_prefs_box (
    ObjAudacious *proxy,
    gboolean arg_show,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ShowPrefsBox",
    g_variant_new ("(b)",
                   arg_show),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_show_prefs_box_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_show_prefs_box().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_show_prefs_box().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_show_prefs_box_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_show_prefs_box_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_show: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ShowPrefsBox">ShowPrefsBox()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_show_prefs_box() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_show_prefs_box_sync (
    ObjAudacious *proxy,
    gboolean arg_show,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ShowPrefsBox",
    g_variant_new ("(b)",
                   arg_show),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_show_about_box:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_show: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ShowAboutBox">ShowAboutBox()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_show_about_box_finish() to get the result of the operation.
 *
 * See obj_audacious_call_show_about_box_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_show_about_box (
    ObjAudacious *proxy,
    gboolean arg_show,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ShowAboutBox",
    g_variant_new ("(b)",
                   arg_show),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_show_about_box_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_show_about_box().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_show_about_box().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_show_about_box_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_show_about_box_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_show: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ShowAboutBox">ShowAboutBox()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_show_about_box() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_show_about_box_sync (
    ObjAudacious *proxy,
    gboolean arg_show,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ShowAboutBox",
    g_variant_new ("(b)",
                   arg_show),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_show_jtf_box:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_show: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ShowJtfBox">ShowJtfBox()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_show_jtf_box_finish() to get the result of the operation.
 *
 * See obj_audacious_call_show_jtf_box_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_show_jtf_box (
    ObjAudacious *proxy,
    gboolean arg_show,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ShowJtfBox",
    g_variant_new ("(b)",
                   arg_show),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_show_jtf_box_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_show_jtf_box().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_show_jtf_box().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_show_jtf_box_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_show_jtf_box_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_show: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ShowJtfBox">ShowJtfBox()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_show_jtf_box() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_show_jtf_box_sync (
    ObjAudacious *proxy,
    gboolean arg_show,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ShowJtfBox",
    g_variant_new ("(b)",
                   arg_show),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_startup_notify:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.StartupNotify">StartupNotify()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_startup_notify_finish() to get the result of the operation.
 *
 * See obj_audacious_call_startup_notify_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_startup_notify (
    ObjAudacious *proxy,
    const gchar *arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StartupNotify",
    g_variant_new ("(s)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_startup_notify_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_startup_notify().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_startup_notify().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_startup_notify_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_startup_notify_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.StartupNotify">StartupNotify()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_startup_notify() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_startup_notify_sync (
    ObjAudacious *proxy,
    const gchar *arg_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StartupNotify",
    g_variant_new ("(s)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_get_tuple_fields:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.GetTupleFields">GetTupleFields()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_get_tuple_fields_finish() to get the result of the operation.
 *
 * See obj_audacious_call_get_tuple_fields_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_get_tuple_fields (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetTupleFields",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_get_tuple_fields_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_fields: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_get_tuple_fields().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_get_tuple_fields().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_get_tuple_fields_finish (
    ObjAudacious *proxy,
    gchar ***out_fields,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_fields);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_get_tuple_fields_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_fields: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.GetTupleFields">GetTupleFields()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_get_tuple_fields() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_get_tuple_fields_sync (
    ObjAudacious *proxy,
    gchar ***out_fields,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetTupleFields",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_fields);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_play:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Play">Play()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_play_finish() to get the result of the operation.
 *
 * See obj_audacious_call_play_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_play (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Play",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_play_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_play().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_play().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_play_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_play_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Play">Play()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_play() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_play_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Play",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_pause:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Pause">Pause()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_pause_finish() to get the result of the operation.
 *
 * See obj_audacious_call_pause_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_pause (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Pause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_pause_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_pause().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_pause().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_pause_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_pause_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Pause">Pause()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_pause() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_pause_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Pause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_play_pause:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PlayPause">PlayPause()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_play_pause_finish() to get the result of the operation.
 *
 * See obj_audacious_call_play_pause_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_play_pause (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PlayPause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_play_pause_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_play_pause().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_play_pause().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_play_pause_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_play_pause_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PlayPause">PlayPause()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_play_pause() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_play_pause_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PlayPause",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_stop:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Stop">Stop()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_stop_finish() to get the result of the operation.
 *
 * See obj_audacious_call_stop_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_stop (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_stop_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_stop().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_stop().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_stop_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_stop_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Stop">Stop()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_stop() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_stop_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stop",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_playing:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Playing">Playing()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_playing_finish() to get the result of the operation.
 *
 * See obj_audacious_call_playing_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_playing (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Playing",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_playing_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_is_playing: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_playing().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_playing().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_playing_finish (
    ObjAudacious *proxy,
    gboolean *out_is_playing,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_playing);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_playing_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_is_playing: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Playing">Playing()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_playing() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_playing_sync (
    ObjAudacious *proxy,
    gboolean *out_is_playing,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Playing",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_playing);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_paused:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Paused">Paused()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_paused_finish() to get the result of the operation.
 *
 * See obj_audacious_call_paused_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_paused (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Paused",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_paused_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_is_paused: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_paused().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_paused().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_paused_finish (
    ObjAudacious *proxy,
    gboolean *out_is_paused,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_paused);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_paused_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_is_paused: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Paused">Paused()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_paused() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_paused_sync (
    ObjAudacious *proxy,
    gboolean *out_is_paused,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Paused",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_paused);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_stopped:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Stopped">Stopped()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_stopped_finish() to get the result of the operation.
 *
 * See obj_audacious_call_stopped_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_stopped (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Stopped",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_stopped_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_is_stopped: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_stopped().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_stopped().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_stopped_finish (
    ObjAudacious *proxy,
    gboolean *out_is_stopped,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_stopped);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_stopped_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_is_stopped: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Stopped">Stopped()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_stopped() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_stopped_sync (
    ObjAudacious *proxy,
    gboolean *out_is_stopped,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Stopped",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_stopped);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_status:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Status">Status()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_status_finish() to get the result of the operation.
 *
 * See obj_audacious_call_status_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_status (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Status",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_status_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_status: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_status().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_status().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_status_finish (
    ObjAudacious *proxy,
    gchar **out_status,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_status);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_status_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_status: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Status">Status()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_status() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_status_sync (
    ObjAudacious *proxy,
    gchar **out_status,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Status",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_status);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_record:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Record">Record()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_record_finish() to get the result of the operation.
 *
 * See obj_audacious_call_record_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_record (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Record",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_record_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_record().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_record().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_record_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_record_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Record">Record()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_record() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_record_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Record",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_recording:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Recording">Recording()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_recording_finish() to get the result of the operation.
 *
 * See obj_audacious_call_recording_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_recording (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Recording",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_recording_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_is_recording: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_recording().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_recording().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_recording_finish (
    ObjAudacious *proxy,
    gboolean *out_is_recording,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_recording);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_recording_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_is_recording: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Recording">Recording()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_recording() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_recording_sync (
    ObjAudacious *proxy,
    gboolean *out_is_recording,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Recording",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_recording);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_info:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Info">Info()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_info_finish() to get the result of the operation.
 *
 * See obj_audacious_call_info_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_info (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Info",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_info_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_rate: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_freq: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_nch: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_info().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_info().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_info_finish (
    ObjAudacious *proxy,
    gint *out_rate,
    gint *out_freq,
    gint *out_nch,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(iii)",
                 out_rate,
                 out_freq,
                 out_nch);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_info_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_rate: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_freq: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_nch: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Info">Info()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_info() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_info_sync (
    ObjAudacious *proxy,
    gint *out_rate,
    gint *out_freq,
    gint *out_nch,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Info",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(iii)",
                 out_rate,
                 out_freq,
                 out_nch);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_get_info:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.GetInfo">GetInfo()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_get_info_finish() to get the result of the operation.
 *
 * See obj_audacious_call_get_info_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_get_info (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetInfo",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_get_info_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_rate: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_freq: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_nch: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_get_info().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_get_info().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_get_info_finish (
    ObjAudacious *proxy,
    gint *out_rate,
    gint *out_freq,
    gint *out_nch,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(iii)",
                 out_rate,
                 out_freq,
                 out_nch);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_get_info_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_rate: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_freq: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_nch: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.GetInfo">GetInfo()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_get_info() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_get_info_sync (
    ObjAudacious *proxy,
    gint *out_rate,
    gint *out_freq,
    gint *out_nch,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetInfo",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(iii)",
                 out_rate,
                 out_freq,
                 out_nch);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_time:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Time">Time()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_time_finish() to get the result of the operation.
 *
 * See obj_audacious_call_time_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_time (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Time",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_time_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_time: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_time().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_time().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_time_finish (
    ObjAudacious *proxy,
    guint *out_time,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_time);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_time_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_time: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Time">Time()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_time() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_time_sync (
    ObjAudacious *proxy,
    guint *out_time,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Time",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_time);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_seek:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Seek">Seek()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_seek_finish() to get the result of the operation.
 *
 * See obj_audacious_call_seek_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_seek (
    ObjAudacious *proxy,
    guint arg_pos,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Seek",
    g_variant_new ("(u)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_seek_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_seek().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_seek().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_seek_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_seek_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Seek">Seek()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_seek() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_seek_sync (
    ObjAudacious *proxy,
    guint arg_pos,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Seek",
    g_variant_new ("(u)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_volume:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Volume">Volume()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_volume_finish() to get the result of the operation.
 *
 * See obj_audacious_call_volume_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_volume (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Volume",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_volume_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_vl: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_vr: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_volume().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_volume().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_volume_finish (
    ObjAudacious *proxy,
    gint *out_vl,
    gint *out_vr,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(ii)",
                 out_vl,
                 out_vr);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_volume_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_vl: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_vr: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Volume">Volume()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_volume() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_volume_sync (
    ObjAudacious *proxy,
    gint *out_vl,
    gint *out_vr,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Volume",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(ii)",
                 out_vl,
                 out_vr);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_set_volume:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_vl: Argument to pass with the method invocation.
 * @arg_vr: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SetVolume">SetVolume()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_set_volume_finish() to get the result of the operation.
 *
 * See obj_audacious_call_set_volume_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_set_volume (
    ObjAudacious *proxy,
    gint arg_vl,
    gint arg_vr,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetVolume",
    g_variant_new ("(ii)",
                   arg_vl,
                   arg_vr),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_set_volume_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_set_volume().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_set_volume().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_set_volume_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_set_volume_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_vl: Argument to pass with the method invocation.
 * @arg_vr: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SetVolume">SetVolume()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_set_volume() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_set_volume_sync (
    ObjAudacious *proxy,
    gint arg_vl,
    gint arg_vr,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetVolume",
    g_variant_new ("(ii)",
                   arg_vl,
                   arg_vr),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_balance:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Balance">Balance()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_balance_finish() to get the result of the operation.
 *
 * See obj_audacious_call_balance_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_balance (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Balance",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_balance_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_balance: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_balance().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_balance().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_balance_finish (
    ObjAudacious *proxy,
    gint *out_balance,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_balance);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_balance_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_balance: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Balance">Balance()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_balance() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_balance_sync (
    ObjAudacious *proxy,
    gint *out_balance,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Balance",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_balance);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_get_eq:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.GetEq">GetEq()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_get_eq_finish() to get the result of the operation.
 *
 * See obj_audacious_call_get_eq_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_get_eq (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetEq",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_get_eq_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_preamp: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_bands: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_get_eq().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_get_eq().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_get_eq_finish (
    ObjAudacious *proxy,
    gdouble *out_preamp,
    GVariant **out_bands,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(d@ad)",
                 out_preamp,
                 out_bands);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_get_eq_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_preamp: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_bands: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.GetEq">GetEq()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_get_eq() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_get_eq_sync (
    ObjAudacious *proxy,
    gdouble *out_preamp,
    GVariant **out_bands,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetEq",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(d@ad)",
                 out_preamp,
                 out_bands);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_get_eq_preamp:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.GetEqPreamp">GetEqPreamp()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_get_eq_preamp_finish() to get the result of the operation.
 *
 * See obj_audacious_call_get_eq_preamp_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_get_eq_preamp (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetEqPreamp",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_get_eq_preamp_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_preamp: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_get_eq_preamp().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_get_eq_preamp().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_get_eq_preamp_finish (
    ObjAudacious *proxy,
    gdouble *out_preamp,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(d)",
                 out_preamp);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_get_eq_preamp_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_preamp: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.GetEqPreamp">GetEqPreamp()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_get_eq_preamp() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_get_eq_preamp_sync (
    ObjAudacious *proxy,
    gdouble *out_preamp,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetEqPreamp",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(d)",
                 out_preamp);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_get_eq_band:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_band: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.GetEqBand">GetEqBand()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_get_eq_band_finish() to get the result of the operation.
 *
 * See obj_audacious_call_get_eq_band_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_get_eq_band (
    ObjAudacious *proxy,
    gint arg_band,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetEqBand",
    g_variant_new ("(i)",
                   arg_band),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_get_eq_band_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_get_eq_band().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_get_eq_band().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_get_eq_band_finish (
    ObjAudacious *proxy,
    gdouble *out_value,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(d)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_get_eq_band_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_band: Argument to pass with the method invocation.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.GetEqBand">GetEqBand()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_get_eq_band() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_get_eq_band_sync (
    ObjAudacious *proxy,
    gint arg_band,
    gdouble *out_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetEqBand",
    g_variant_new ("(i)",
                   arg_band),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(d)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_set_eq:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_preamp: Argument to pass with the method invocation.
 * @arg_bands: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SetEq">SetEq()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_set_eq_finish() to get the result of the operation.
 *
 * See obj_audacious_call_set_eq_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_set_eq (
    ObjAudacious *proxy,
    gdouble arg_preamp,
    GVariant *arg_bands,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetEq",
    g_variant_new ("(d@ad)",
                   arg_preamp,
                   arg_bands),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_set_eq_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_set_eq().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_set_eq().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_set_eq_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_set_eq_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_preamp: Argument to pass with the method invocation.
 * @arg_bands: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SetEq">SetEq()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_set_eq() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_set_eq_sync (
    ObjAudacious *proxy,
    gdouble arg_preamp,
    GVariant *arg_bands,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetEq",
    g_variant_new ("(d@ad)",
                   arg_preamp,
                   arg_bands),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_set_eq_preamp:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_preamp: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SetEqPreamp">SetEqPreamp()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_set_eq_preamp_finish() to get the result of the operation.
 *
 * See obj_audacious_call_set_eq_preamp_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_set_eq_preamp (
    ObjAudacious *proxy,
    gdouble arg_preamp,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetEqPreamp",
    g_variant_new ("(d)",
                   arg_preamp),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_set_eq_preamp_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_set_eq_preamp().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_set_eq_preamp().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_set_eq_preamp_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_set_eq_preamp_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_preamp: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SetEqPreamp">SetEqPreamp()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_set_eq_preamp() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_set_eq_preamp_sync (
    ObjAudacious *proxy,
    gdouble arg_preamp,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetEqPreamp",
    g_variant_new ("(d)",
                   arg_preamp),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_set_eq_band:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_band: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SetEqBand">SetEqBand()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_set_eq_band_finish() to get the result of the operation.
 *
 * See obj_audacious_call_set_eq_band_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_set_eq_band (
    ObjAudacious *proxy,
    gint arg_band,
    gdouble arg_value,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetEqBand",
    g_variant_new ("(id)",
                   arg_band,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_set_eq_band_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_set_eq_band().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_set_eq_band().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_set_eq_band_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_set_eq_band_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_band: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SetEqBand">SetEqBand()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_set_eq_band() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_set_eq_band_sync (
    ObjAudacious *proxy,
    gint arg_band,
    gdouble arg_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetEqBand",
    g_variant_new ("(id)",
                   arg_band,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_equalizer_activate:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_active: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.EqualizerActivate">EqualizerActivate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_equalizer_activate_finish() to get the result of the operation.
 *
 * See obj_audacious_call_equalizer_activate_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_equalizer_activate (
    ObjAudacious *proxy,
    gboolean arg_active,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EqualizerActivate",
    g_variant_new ("(b)",
                   arg_active),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_equalizer_activate_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_equalizer_activate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_equalizer_activate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_equalizer_activate_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_equalizer_activate_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_active: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.EqualizerActivate">EqualizerActivate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_equalizer_activate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_equalizer_activate_sync (
    ObjAudacious *proxy,
    gboolean arg_active,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EqualizerActivate",
    g_variant_new ("(b)",
                   arg_active),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_select_displayed_playlist:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SelectDisplayedPlaylist">SelectDisplayedPlaylist()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_select_displayed_playlist_finish() to get the result of the operation.
 *
 * See obj_audacious_call_select_displayed_playlist_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_select_displayed_playlist (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SelectDisplayedPlaylist",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_select_displayed_playlist_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_select_displayed_playlist().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_select_displayed_playlist().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_select_displayed_playlist_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_select_displayed_playlist_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SelectDisplayedPlaylist">SelectDisplayedPlaylist()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_select_displayed_playlist() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_select_displayed_playlist_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SelectDisplayedPlaylist",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_select_playing_playlist:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SelectPlayingPlaylist">SelectPlayingPlaylist()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_select_playing_playlist_finish() to get the result of the operation.
 *
 * See obj_audacious_call_select_playing_playlist_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_select_playing_playlist (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SelectPlayingPlaylist",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_select_playing_playlist_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_select_playing_playlist().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_select_playing_playlist().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_select_playing_playlist_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_select_playing_playlist_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SelectPlayingPlaylist">SelectPlayingPlaylist()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_select_playing_playlist() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_select_playing_playlist_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SelectPlayingPlaylist",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_position:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Position">Position()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_position_finish() to get the result of the operation.
 *
 * See obj_audacious_call_position_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_position (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Position",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_position_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_pos: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_position().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_position().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_position_finish (
    ObjAudacious *proxy,
    guint *out_pos,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_pos);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_position_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_pos: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Position">Position()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_position() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_position_sync (
    ObjAudacious *proxy,
    guint *out_pos,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Position",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_pos);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_advance:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Advance">Advance()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_advance_finish() to get the result of the operation.
 *
 * See obj_audacious_call_advance_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_advance (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Advance",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_advance_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_advance().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_advance().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_advance_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_advance_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Advance">Advance()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_advance() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_advance_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Advance",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_advance_album:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.AdvanceAlbum">AdvanceAlbum()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_advance_album_finish() to get the result of the operation.
 *
 * See obj_audacious_call_advance_album_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_advance_album (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AdvanceAlbum",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_advance_album_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_advance_album().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_advance_album().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_advance_album_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_advance_album_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.AdvanceAlbum">AdvanceAlbum()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_advance_album() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_advance_album_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AdvanceAlbum",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_reverse:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Reverse">Reverse()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_reverse_finish() to get the result of the operation.
 *
 * See obj_audacious_call_reverse_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_reverse (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Reverse",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_reverse_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_reverse().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_reverse().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_reverse_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_reverse_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Reverse">Reverse()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_reverse() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_reverse_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Reverse",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_reverse_album:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ReverseAlbum">ReverseAlbum()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_reverse_album_finish() to get the result of the operation.
 *
 * See obj_audacious_call_reverse_album_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_reverse_album (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReverseAlbum",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_reverse_album_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_reverse_album().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_reverse_album().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_reverse_album_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_reverse_album_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ReverseAlbum">ReverseAlbum()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_reverse_album() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_reverse_album_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReverseAlbum",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_length:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Length">Length()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_length_finish() to get the result of the operation.
 *
 * See obj_audacious_call_length_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_length (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Length",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_length_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_length: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_length().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_length().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_length_finish (
    ObjAudacious *proxy,
    gint *out_length,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_length);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_length_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_length: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Length">Length()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_length() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_length_sync (
    ObjAudacious *proxy,
    gint *out_length,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Length",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_length);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_song_title:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SongTitle">SongTitle()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_song_title_finish() to get the result of the operation.
 *
 * See obj_audacious_call_song_title_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_song_title (
    ObjAudacious *proxy,
    guint arg_pos,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SongTitle",
    g_variant_new ("(u)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_song_title_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_title: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_song_title().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_song_title().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_song_title_finish (
    ObjAudacious *proxy,
    gchar **out_title,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_title);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_song_title_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @out_title: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SongTitle">SongTitle()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_song_title() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_song_title_sync (
    ObjAudacious *proxy,
    guint arg_pos,
    gchar **out_title,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SongTitle",
    g_variant_new ("(u)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_title);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_song_filename:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SongFilename">SongFilename()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_song_filename_finish() to get the result of the operation.
 *
 * See obj_audacious_call_song_filename_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_song_filename (
    ObjAudacious *proxy,
    guint arg_pos,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SongFilename",
    g_variant_new ("(u)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_song_filename_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_filename: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_song_filename().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_song_filename().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_song_filename_finish (
    ObjAudacious *proxy,
    gchar **out_filename,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_filename);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_song_filename_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @out_filename: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SongFilename">SongFilename()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_song_filename() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_song_filename_sync (
    ObjAudacious *proxy,
    guint arg_pos,
    gchar **out_filename,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SongFilename",
    g_variant_new ("(u)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_filename);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_song_length:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SongLength">SongLength()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_song_length_finish() to get the result of the operation.
 *
 * See obj_audacious_call_song_length_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_song_length (
    ObjAudacious *proxy,
    guint arg_pos,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SongLength",
    g_variant_new ("(u)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_song_length_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_length: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_song_length().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_song_length().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_song_length_finish (
    ObjAudacious *proxy,
    gint *out_length,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_length);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_song_length_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @out_length: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SongLength">SongLength()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_song_length() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_song_length_sync (
    ObjAudacious *proxy,
    guint arg_pos,
    gint *out_length,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SongLength",
    g_variant_new ("(u)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_length);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_song_frames:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SongFrames">SongFrames()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_song_frames_finish() to get the result of the operation.
 *
 * See obj_audacious_call_song_frames_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_song_frames (
    ObjAudacious *proxy,
    guint arg_pos,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SongFrames",
    g_variant_new ("(u)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_song_frames_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_length: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_song_frames().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_song_frames().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_song_frames_finish (
    ObjAudacious *proxy,
    gint *out_length,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_length);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_song_frames_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @out_length: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SongFrames">SongFrames()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_song_frames() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_song_frames_sync (
    ObjAudacious *proxy,
    guint arg_pos,
    gint *out_length,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SongFrames",
    g_variant_new ("(u)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_length);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_song_tuple:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @arg_tuple: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SongTuple">SongTuple()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_song_tuple_finish() to get the result of the operation.
 *
 * See obj_audacious_call_song_tuple_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_song_tuple (
    ObjAudacious *proxy,
    guint arg_pos,
    const gchar *arg_tuple,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SongTuple",
    g_variant_new ("(us)",
                   arg_pos,
                   arg_tuple),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_song_tuple_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_song_tuple().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_song_tuple().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_song_tuple_finish (
    ObjAudacious *proxy,
    GVariant **out_value,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@v)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_song_tuple_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @arg_tuple: Argument to pass with the method invocation.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SongTuple">SongTuple()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_song_tuple() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_song_tuple_sync (
    ObjAudacious *proxy,
    guint arg_pos,
    const gchar *arg_tuple,
    GVariant **out_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SongTuple",
    g_variant_new ("(us)",
                   arg_pos,
                   arg_tuple),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@v)",
                 out_value);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_jump:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Jump">Jump()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_jump_finish() to get the result of the operation.
 *
 * See obj_audacious_call_jump_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_jump (
    ObjAudacious *proxy,
    guint arg_pos,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Jump",
    g_variant_new ("(u)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_jump_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_jump().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_jump().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_jump_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_jump_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Jump">Jump()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_jump() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_jump_sync (
    ObjAudacious *proxy,
    guint arg_pos,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Jump",
    g_variant_new ("(u)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_add:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_file: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Add">Add()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_add_finish() to get the result of the operation.
 *
 * See obj_audacious_call_add_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_add (
    ObjAudacious *proxy,
    const gchar *arg_file,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Add",
    g_variant_new ("(s)",
                   arg_file),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_add_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_add().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_add().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_add_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_add_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_file: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Add">Add()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_add() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_add_sync (
    ObjAudacious *proxy,
    const gchar *arg_file,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Add",
    g_variant_new ("(s)",
                   arg_file),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_add_url:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_url: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.AddUrl">AddUrl()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_add_url_finish() to get the result of the operation.
 *
 * See obj_audacious_call_add_url_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_add_url (
    ObjAudacious *proxy,
    const gchar *arg_url,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AddUrl",
    g_variant_new ("(s)",
                   arg_url),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_add_url_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_add_url().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_add_url().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_add_url_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_add_url_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_url: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.AddUrl">AddUrl()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_add_url() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_add_url_sync (
    ObjAudacious *proxy,
    const gchar *arg_url,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AddUrl",
    g_variant_new ("(s)",
                   arg_url),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_playlist_add:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_list: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PlaylistAdd">PlaylistAdd()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_playlist_add_finish() to get the result of the operation.
 *
 * See obj_audacious_call_playlist_add_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_playlist_add (
    ObjAudacious *proxy,
    const gchar *arg_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PlaylistAdd",
    g_variant_new ("(s)",
                   arg_list),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_playlist_add_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_playlist_add().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_playlist_add().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_playlist_add_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_playlist_add_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_list: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PlaylistAdd">PlaylistAdd()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_playlist_add() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_playlist_add_sync (
    ObjAudacious *proxy,
    const gchar *arg_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PlaylistAdd",
    g_variant_new ("(s)",
                   arg_list),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_playlist_ins_url_string:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_url: Argument to pass with the method invocation.
 * @arg_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PlaylistInsUrlString">PlaylistInsUrlString()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_playlist_ins_url_string_finish() to get the result of the operation.
 *
 * See obj_audacious_call_playlist_ins_url_string_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_playlist_ins_url_string (
    ObjAudacious *proxy,
    const gchar *arg_url,
    gint arg_pos,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PlaylistInsUrlString",
    g_variant_new ("(si)",
                   arg_url,
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_playlist_ins_url_string_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_playlist_ins_url_string().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_playlist_ins_url_string().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_playlist_ins_url_string_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_playlist_ins_url_string_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_url: Argument to pass with the method invocation.
 * @arg_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PlaylistInsUrlString">PlaylistInsUrlString()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_playlist_ins_url_string() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_playlist_ins_url_string_sync (
    ObjAudacious *proxy,
    const gchar *arg_url,
    gint arg_pos,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PlaylistInsUrlString",
    g_variant_new ("(si)",
                   arg_url,
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_add_list:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_filenames: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.AddList">AddList()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_add_list_finish() to get the result of the operation.
 *
 * See obj_audacious_call_add_list_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_add_list (
    ObjAudacious *proxy,
    const gchar *const *arg_filenames,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AddList",
    g_variant_new ("(^as)",
                   arg_filenames),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_add_list_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_add_list().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_add_list().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_add_list_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_add_list_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_filenames: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.AddList">AddList()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_add_list() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_add_list_sync (
    ObjAudacious *proxy,
    const gchar *const *arg_filenames,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AddList",
    g_variant_new ("(^as)",
                   arg_filenames),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_open_list:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_filenames: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.OpenList">OpenList()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_open_list_finish() to get the result of the operation.
 *
 * See obj_audacious_call_open_list_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_open_list (
    ObjAudacious *proxy,
    const gchar *const *arg_filenames,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "OpenList",
    g_variant_new ("(^as)",
                   arg_filenames),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_open_list_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_open_list().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_open_list().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_open_list_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_open_list_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_filenames: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.OpenList">OpenList()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_open_list() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_open_list_sync (
    ObjAudacious *proxy,
    const gchar *const *arg_filenames,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "OpenList",
    g_variant_new ("(^as)",
                   arg_filenames),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_playlist_enqueue_to_temp:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_url: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PlaylistEnqueueToTemp">PlaylistEnqueueToTemp()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_playlist_enqueue_to_temp_finish() to get the result of the operation.
 *
 * See obj_audacious_call_playlist_enqueue_to_temp_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_playlist_enqueue_to_temp (
    ObjAudacious *proxy,
    const gchar *arg_url,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PlaylistEnqueueToTemp",
    g_variant_new ("(s)",
                   arg_url),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_playlist_enqueue_to_temp_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_playlist_enqueue_to_temp().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_playlist_enqueue_to_temp().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_playlist_enqueue_to_temp_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_playlist_enqueue_to_temp_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_url: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PlaylistEnqueueToTemp">PlaylistEnqueueToTemp()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_playlist_enqueue_to_temp() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_playlist_enqueue_to_temp_sync (
    ObjAudacious *proxy,
    const gchar *arg_url,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PlaylistEnqueueToTemp",
    g_variant_new ("(s)",
                   arg_url),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_open_list_to_temp:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_filenames: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.OpenListToTemp">OpenListToTemp()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_open_list_to_temp_finish() to get the result of the operation.
 *
 * See obj_audacious_call_open_list_to_temp_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_open_list_to_temp (
    ObjAudacious *proxy,
    const gchar *const *arg_filenames,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "OpenListToTemp",
    g_variant_new ("(^as)",
                   arg_filenames),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_open_list_to_temp_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_open_list_to_temp().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_open_list_to_temp().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_open_list_to_temp_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_open_list_to_temp_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_filenames: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.OpenListToTemp">OpenListToTemp()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_open_list_to_temp() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_open_list_to_temp_sync (
    ObjAudacious *proxy,
    const gchar *const *arg_filenames,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "OpenListToTemp",
    g_variant_new ("(^as)",
                   arg_filenames),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_delete:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Delete">Delete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_delete_finish() to get the result of the operation.
 *
 * See obj_audacious_call_delete_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_delete (
    ObjAudacious *proxy,
    guint arg_pos,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("(u)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_delete_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_delete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_delete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_delete_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_delete_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Delete">Delete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_delete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_delete_sync (
    ObjAudacious *proxy,
    guint arg_pos,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("(u)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_clear:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Clear">Clear()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_clear_finish() to get the result of the operation.
 *
 * See obj_audacious_call_clear_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_clear (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Clear",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_clear_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_clear().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_clear().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_clear_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_clear_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Clear">Clear()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_clear() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_clear_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Clear",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_auto_advance:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.AutoAdvance">AutoAdvance()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_auto_advance_finish() to get the result of the operation.
 *
 * See obj_audacious_call_auto_advance_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_auto_advance (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AutoAdvance",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_auto_advance_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_is_advance: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_auto_advance().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_auto_advance().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_auto_advance_finish (
    ObjAudacious *proxy,
    gboolean *out_is_advance,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_advance);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_auto_advance_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_is_advance: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.AutoAdvance">AutoAdvance()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_auto_advance() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_auto_advance_sync (
    ObjAudacious *proxy,
    gboolean *out_is_advance,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AutoAdvance",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_advance);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_toggle_auto_advance:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ToggleAutoAdvance">ToggleAutoAdvance()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_toggle_auto_advance_finish() to get the result of the operation.
 *
 * See obj_audacious_call_toggle_auto_advance_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_toggle_auto_advance (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ToggleAutoAdvance",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_toggle_auto_advance_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_toggle_auto_advance().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_toggle_auto_advance().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_toggle_auto_advance_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_toggle_auto_advance_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ToggleAutoAdvance">ToggleAutoAdvance()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_toggle_auto_advance() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_toggle_auto_advance_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ToggleAutoAdvance",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_repeat:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Repeat">Repeat()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_repeat_finish() to get the result of the operation.
 *
 * See obj_audacious_call_repeat_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_repeat (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Repeat",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_repeat_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_is_repeat: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_repeat().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_repeat().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_repeat_finish (
    ObjAudacious *proxy,
    gboolean *out_is_repeat,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_repeat);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_repeat_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_is_repeat: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Repeat">Repeat()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_repeat() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_repeat_sync (
    ObjAudacious *proxy,
    gboolean *out_is_repeat,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Repeat",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_repeat);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_toggle_repeat:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ToggleRepeat">ToggleRepeat()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_toggle_repeat_finish() to get the result of the operation.
 *
 * See obj_audacious_call_toggle_repeat_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_toggle_repeat (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ToggleRepeat",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_toggle_repeat_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_toggle_repeat().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_toggle_repeat().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_toggle_repeat_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_toggle_repeat_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ToggleRepeat">ToggleRepeat()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_toggle_repeat() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_toggle_repeat_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ToggleRepeat",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_shuffle:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Shuffle">Shuffle()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_shuffle_finish() to get the result of the operation.
 *
 * See obj_audacious_call_shuffle_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_shuffle (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Shuffle",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_shuffle_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_is_shuffle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_shuffle().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_shuffle().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_shuffle_finish (
    ObjAudacious *proxy,
    gboolean *out_is_shuffle,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_shuffle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_shuffle_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_is_shuffle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.Shuffle">Shuffle()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_shuffle() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_shuffle_sync (
    ObjAudacious *proxy,
    gboolean *out_is_shuffle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Shuffle",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_shuffle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_toggle_shuffle:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ToggleShuffle">ToggleShuffle()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_toggle_shuffle_finish() to get the result of the operation.
 *
 * See obj_audacious_call_toggle_shuffle_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_toggle_shuffle (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ToggleShuffle",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_toggle_shuffle_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_toggle_shuffle().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_toggle_shuffle().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_toggle_shuffle_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_toggle_shuffle_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ToggleShuffle">ToggleShuffle()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_toggle_shuffle() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_toggle_shuffle_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ToggleShuffle",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_stop_after:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.StopAfter">StopAfter()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_stop_after_finish() to get the result of the operation.
 *
 * See obj_audacious_call_stop_after_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_stop_after (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StopAfter",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_stop_after_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_is_stopping: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_stop_after().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_stop_after().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_stop_after_finish (
    ObjAudacious *proxy,
    gboolean *out_is_stopping,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_stopping);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_stop_after_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_is_stopping: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.StopAfter">StopAfter()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_stop_after() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_stop_after_sync (
    ObjAudacious *proxy,
    gboolean *out_is_stopping,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StopAfter",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_stopping);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_toggle_stop_after:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ToggleStopAfter">ToggleStopAfter()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_toggle_stop_after_finish() to get the result of the operation.
 *
 * See obj_audacious_call_toggle_stop_after_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_toggle_stop_after (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ToggleStopAfter",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_toggle_stop_after_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_toggle_stop_after().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_toggle_stop_after().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_toggle_stop_after_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_toggle_stop_after_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.ToggleStopAfter">ToggleStopAfter()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_toggle_stop_after() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_toggle_stop_after_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ToggleStopAfter",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_queue_get_list_pos:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_qpos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.QueueGetListPos">QueueGetListPos()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_queue_get_list_pos_finish() to get the result of the operation.
 *
 * See obj_audacious_call_queue_get_list_pos_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_queue_get_list_pos (
    ObjAudacious *proxy,
    guint arg_qpos,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "QueueGetListPos",
    g_variant_new ("(u)",
                   arg_qpos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_queue_get_list_pos_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_pos: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_queue_get_list_pos().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_queue_get_list_pos().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_queue_get_list_pos_finish (
    ObjAudacious *proxy,
    guint *out_pos,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_pos);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_queue_get_list_pos_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_qpos: Argument to pass with the method invocation.
 * @out_pos: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.QueueGetListPos">QueueGetListPos()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_queue_get_list_pos() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_queue_get_list_pos_sync (
    ObjAudacious *proxy,
    guint arg_qpos,
    guint *out_pos,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "QueueGetListPos",
    g_variant_new ("(u)",
                   arg_qpos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_pos);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_queue_get_queue_pos:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.QueueGetQueuePos">QueueGetQueuePos()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_queue_get_queue_pos_finish() to get the result of the operation.
 *
 * See obj_audacious_call_queue_get_queue_pos_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_queue_get_queue_pos (
    ObjAudacious *proxy,
    guint arg_pos,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "QueueGetQueuePos",
    g_variant_new ("(u)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_queue_get_queue_pos_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_qpos: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_queue_get_queue_pos().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_queue_get_queue_pos().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_queue_get_queue_pos_finish (
    ObjAudacious *proxy,
    guint *out_qpos,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_qpos);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_queue_get_queue_pos_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @out_qpos: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.QueueGetQueuePos">QueueGetQueuePos()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_queue_get_queue_pos() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_queue_get_queue_pos_sync (
    ObjAudacious *proxy,
    guint arg_pos,
    guint *out_qpos,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "QueueGetQueuePos",
    g_variant_new ("(u)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_qpos);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_get_playqueue_length:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.GetPlayqueueLength">GetPlayqueueLength()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_get_playqueue_length_finish() to get the result of the operation.
 *
 * See obj_audacious_call_get_playqueue_length_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_get_playqueue_length (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetPlayqueueLength",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_get_playqueue_length_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_length: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_get_playqueue_length().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_get_playqueue_length().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_get_playqueue_length_finish (
    ObjAudacious *proxy,
    gint *out_length,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_length);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_get_playqueue_length_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_length: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.GetPlayqueueLength">GetPlayqueueLength()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_get_playqueue_length() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_get_playqueue_length_sync (
    ObjAudacious *proxy,
    gint *out_length,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetPlayqueueLength",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_length);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_playqueue_add:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PlayqueueAdd">PlayqueueAdd()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_playqueue_add_finish() to get the result of the operation.
 *
 * See obj_audacious_call_playqueue_add_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_playqueue_add (
    ObjAudacious *proxy,
    gint arg_pos,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PlayqueueAdd",
    g_variant_new ("(i)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_playqueue_add_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_playqueue_add().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_playqueue_add().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_playqueue_add_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_playqueue_add_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PlayqueueAdd">PlayqueueAdd()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_playqueue_add() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_playqueue_add_sync (
    ObjAudacious *proxy,
    gint arg_pos,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PlayqueueAdd",
    g_variant_new ("(i)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_playqueue_remove:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PlayqueueRemove">PlayqueueRemove()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_playqueue_remove_finish() to get the result of the operation.
 *
 * See obj_audacious_call_playqueue_remove_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_playqueue_remove (
    ObjAudacious *proxy,
    gint arg_pos,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PlayqueueRemove",
    g_variant_new ("(i)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_playqueue_remove_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_playqueue_remove().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_playqueue_remove().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_playqueue_remove_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_playqueue_remove_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PlayqueueRemove">PlayqueueRemove()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_playqueue_remove() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_playqueue_remove_sync (
    ObjAudacious *proxy,
    gint arg_pos,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PlayqueueRemove",
    g_variant_new ("(i)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_playqueue_clear:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PlayqueueClear">PlayqueueClear()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_playqueue_clear_finish() to get the result of the operation.
 *
 * See obj_audacious_call_playqueue_clear_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_playqueue_clear (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PlayqueueClear",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_playqueue_clear_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_playqueue_clear().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_playqueue_clear().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_playqueue_clear_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_playqueue_clear_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PlayqueueClear">PlayqueueClear()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_playqueue_clear() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_playqueue_clear_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PlayqueueClear",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_playqueue_is_queued:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PlayqueueIsQueued">PlayqueueIsQueued()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_playqueue_is_queued_finish() to get the result of the operation.
 *
 * See obj_audacious_call_playqueue_is_queued_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_playqueue_is_queued (
    ObjAudacious *proxy,
    gint arg_pos,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PlayqueueIsQueued",
    g_variant_new ("(i)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_playqueue_is_queued_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_is_queued: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_playqueue_is_queued().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_playqueue_is_queued().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_playqueue_is_queued_finish (
    ObjAudacious *proxy,
    gboolean *out_is_queued,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_queued);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_playqueue_is_queued_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_pos: Argument to pass with the method invocation.
 * @out_is_queued: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PlayqueueIsQueued">PlayqueueIsQueued()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_playqueue_is_queued() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_playqueue_is_queued_sync (
    ObjAudacious *proxy,
    gint arg_pos,
    gboolean *out_is_queued,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PlayqueueIsQueued",
    g_variant_new ("(i)",
                   arg_pos),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_is_queued);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_number_of_playlists:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.NumberOfPlaylists">NumberOfPlaylists()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_number_of_playlists_finish() to get the result of the operation.
 *
 * See obj_audacious_call_number_of_playlists_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_number_of_playlists (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NumberOfPlaylists",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_number_of_playlists_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_count: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_number_of_playlists().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_number_of_playlists().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_number_of_playlists_finish (
    ObjAudacious *proxy,
    gint *out_count,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_count);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_number_of_playlists_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_count: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.NumberOfPlaylists">NumberOfPlaylists()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_number_of_playlists() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_number_of_playlists_sync (
    ObjAudacious *proxy,
    gint *out_count,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NumberOfPlaylists",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_count);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_get_active_playlist:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.GetActivePlaylist">GetActivePlaylist()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_get_active_playlist_finish() to get the result of the operation.
 *
 * See obj_audacious_call_get_active_playlist_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_get_active_playlist (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetActivePlaylist",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_get_active_playlist_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_plnum: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_get_active_playlist().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_get_active_playlist().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_get_active_playlist_finish (
    ObjAudacious *proxy,
    gint *out_plnum,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_plnum);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_get_active_playlist_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_plnum: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.GetActivePlaylist">GetActivePlaylist()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_get_active_playlist() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_get_active_playlist_sync (
    ObjAudacious *proxy,
    gint *out_plnum,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetActivePlaylist",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_plnum);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_set_active_playlist:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_plnum: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SetActivePlaylist">SetActivePlaylist()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_set_active_playlist_finish() to get the result of the operation.
 *
 * See obj_audacious_call_set_active_playlist_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_set_active_playlist (
    ObjAudacious *proxy,
    gint arg_plnum,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetActivePlaylist",
    g_variant_new ("(i)",
                   arg_plnum),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_set_active_playlist_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_set_active_playlist().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_set_active_playlist().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_set_active_playlist_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_set_active_playlist_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_plnum: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SetActivePlaylist">SetActivePlaylist()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_set_active_playlist() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_set_active_playlist_sync (
    ObjAudacious *proxy,
    gint arg_plnum,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetActivePlaylist",
    g_variant_new ("(i)",
                   arg_plnum),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_get_active_playlist_name:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.GetActivePlaylistName">GetActivePlaylistName()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_get_active_playlist_name_finish() to get the result of the operation.
 *
 * See obj_audacious_call_get_active_playlist_name_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_get_active_playlist_name (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetActivePlaylistName",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_get_active_playlist_name_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @out_plname: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_get_active_playlist_name().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_get_active_playlist_name().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_get_active_playlist_name_finish (
    ObjAudacious *proxy,
    gchar **out_plname,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_plname);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_get_active_playlist_name_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @out_plname: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.GetActivePlaylistName">GetActivePlaylistName()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_get_active_playlist_name() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_get_active_playlist_name_sync (
    ObjAudacious *proxy,
    gchar **out_plname,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetActivePlaylistName",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_plname);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_set_active_playlist_name:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_plname: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SetActivePlaylistName">SetActivePlaylistName()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_set_active_playlist_name_finish() to get the result of the operation.
 *
 * See obj_audacious_call_set_active_playlist_name_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_set_active_playlist_name (
    ObjAudacious *proxy,
    const gchar *arg_plname,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetActivePlaylistName",
    g_variant_new ("(s)",
                   arg_plname),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_set_active_playlist_name_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_set_active_playlist_name().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_set_active_playlist_name().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_set_active_playlist_name_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_set_active_playlist_name_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @arg_plname: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.SetActivePlaylistName">SetActivePlaylistName()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_set_active_playlist_name() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_set_active_playlist_name_sync (
    ObjAudacious *proxy,
    const gchar *arg_plname,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetActivePlaylistName",
    g_variant_new ("(s)",
                   arg_plname),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_new_playlist:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.NewPlaylist">NewPlaylist()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_new_playlist_finish() to get the result of the operation.
 *
 * See obj_audacious_call_new_playlist_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_new_playlist (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NewPlaylist",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_new_playlist_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_new_playlist().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_new_playlist().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_new_playlist_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_new_playlist_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.NewPlaylist">NewPlaylist()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_new_playlist() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_new_playlist_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NewPlaylist",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_delete_active_playlist:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.DeleteActivePlaylist">DeleteActivePlaylist()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_delete_active_playlist_finish() to get the result of the operation.
 *
 * See obj_audacious_call_delete_active_playlist_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_delete_active_playlist (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DeleteActivePlaylist",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_delete_active_playlist_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_delete_active_playlist().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_delete_active_playlist().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_delete_active_playlist_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_delete_active_playlist_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.DeleteActivePlaylist">DeleteActivePlaylist()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_delete_active_playlist() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_delete_active_playlist_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DeleteActivePlaylist",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_play_active_playlist:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PlayActivePlaylist">PlayActivePlaylist()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_call_play_active_playlist_finish() to get the result of the operation.
 *
 * See obj_audacious_call_play_active_playlist_sync() for the synchronous, blocking version of this method.
 */
void
obj_audacious_call_play_active_playlist (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PlayActivePlaylist",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * obj_audacious_call_play_active_playlist_finish:
 * @proxy: A #ObjAudaciousProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_call_play_active_playlist().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with obj_audacious_call_play_active_playlist().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_play_active_playlist_finish (
    ObjAudacious *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_call_play_active_playlist_sync:
 * @proxy: A #ObjAudaciousProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-atheme-audacious.PlayActivePlaylist">PlayActivePlaylist()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_call_play_active_playlist() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
obj_audacious_call_play_active_playlist_sync (
    ObjAudacious *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PlayActivePlaylist",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * obj_audacious_complete_version:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @version: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Version">Version()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_version (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *version)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   version));
}

/**
 * obj_audacious_complete_plugin_is_enabled:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @enabled: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.PluginIsEnabled">PluginIsEnabled()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_plugin_is_enabled (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean enabled)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   enabled));
}

/**
 * obj_audacious_complete_plugin_enable:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.PluginEnable">PluginEnable()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_plugin_enable (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_config_get:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @value: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.ConfigGet">ConfigGet()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_config_get (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *value)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   value));
}

/**
 * obj_audacious_complete_config_set:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.ConfigSet">ConfigSet()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_config_set (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_quit:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Quit">Quit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_quit (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_show_filebrowser:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.ShowFilebrowser">ShowFilebrowser()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_show_filebrowser (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_eject:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Eject">Eject()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_eject (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_main_win_visible:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @is_main_win: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.MainWinVisible">MainWinVisible()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_main_win_visible (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean is_main_win)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   is_main_win));
}

/**
 * obj_audacious_complete_show_main_win:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.ShowMainWin">ShowMainWin()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_show_main_win (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_show_prefs_box:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.ShowPrefsBox">ShowPrefsBox()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_show_prefs_box (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_show_about_box:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.ShowAboutBox">ShowAboutBox()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_show_about_box (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_show_jtf_box:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.ShowJtfBox">ShowJtfBox()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_show_jtf_box (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_startup_notify:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.StartupNotify">StartupNotify()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_startup_notify (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_get_tuple_fields:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fields: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.GetTupleFields">GetTupleFields()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_get_tuple_fields (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *fields)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   fields));
}

/**
 * obj_audacious_complete_play:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Play">Play()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_play (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_pause:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Pause">Pause()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_pause (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_play_pause:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.PlayPause">PlayPause()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_play_pause (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_stop:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Stop">Stop()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_stop (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_playing:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @is_playing: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Playing">Playing()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_playing (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean is_playing)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   is_playing));
}

/**
 * obj_audacious_complete_paused:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @is_paused: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Paused">Paused()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_paused (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean is_paused)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   is_paused));
}

/**
 * obj_audacious_complete_stopped:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @is_stopped: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Stopped">Stopped()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_stopped (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean is_stopped)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   is_stopped));
}

/**
 * obj_audacious_complete_status:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @status: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Status">Status()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_status (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *status)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   status));
}

/**
 * obj_audacious_complete_record:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Record">Record()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_record (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_recording:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @is_recording: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Recording">Recording()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_recording (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean is_recording)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   is_recording));
}

/**
 * obj_audacious_complete_info:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @rate: Parameter to return.
 * @freq: Parameter to return.
 * @nch: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Info">Info()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_info (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint rate,
    gint freq,
    gint nch)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(iii)",
                   rate,
                   freq,
                   nch));
}

/**
 * obj_audacious_complete_get_info:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @rate: Parameter to return.
 * @freq: Parameter to return.
 * @nch: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.GetInfo">GetInfo()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_get_info (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint rate,
    gint freq,
    gint nch)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(iii)",
                   rate,
                   freq,
                   nch));
}

/**
 * obj_audacious_complete_time:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @time: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Time">Time()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_time (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint time)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   time));
}

/**
 * obj_audacious_complete_seek:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Seek">Seek()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_seek (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_volume:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @vl: Parameter to return.
 * @vr: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Volume">Volume()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_volume (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint vl,
    gint vr)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(ii)",
                   vl,
                   vr));
}

/**
 * obj_audacious_complete_set_volume:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.SetVolume">SetVolume()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_set_volume (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_balance:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @balance: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Balance">Balance()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_balance (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint balance)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   balance));
}

/**
 * obj_audacious_complete_get_eq:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @preamp: Parameter to return.
 * @bands: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.GetEq">GetEq()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_get_eq (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gdouble preamp,
    GVariant *bands)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(d@ad)",
                   preamp,
                   bands));
}

/**
 * obj_audacious_complete_get_eq_preamp:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @preamp: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.GetEqPreamp">GetEqPreamp()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_get_eq_preamp (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gdouble preamp)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(d)",
                   preamp));
}

/**
 * obj_audacious_complete_get_eq_band:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @value: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.GetEqBand">GetEqBand()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_get_eq_band (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gdouble value)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(d)",
                   value));
}

/**
 * obj_audacious_complete_set_eq:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.SetEq">SetEq()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_set_eq (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_set_eq_preamp:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.SetEqPreamp">SetEqPreamp()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_set_eq_preamp (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_set_eq_band:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.SetEqBand">SetEqBand()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_set_eq_band (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_equalizer_activate:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.EqualizerActivate">EqualizerActivate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_equalizer_activate (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_select_displayed_playlist:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.SelectDisplayedPlaylist">SelectDisplayedPlaylist()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_select_displayed_playlist (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_select_playing_playlist:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.SelectPlayingPlaylist">SelectPlayingPlaylist()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_select_playing_playlist (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_position:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @pos: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Position">Position()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_position (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint pos)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   pos));
}

/**
 * obj_audacious_complete_advance:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Advance">Advance()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_advance (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_advance_album:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.AdvanceAlbum">AdvanceAlbum()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_advance_album (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_reverse:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Reverse">Reverse()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_reverse (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_reverse_album:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.ReverseAlbum">ReverseAlbum()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_reverse_album (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_length:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @length: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Length">Length()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_length (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint length)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   length));
}

/**
 * obj_audacious_complete_song_title:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @title: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.SongTitle">SongTitle()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_song_title (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *title)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   title));
}

/**
 * obj_audacious_complete_song_filename:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @filename: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.SongFilename">SongFilename()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_song_filename (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *filename)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   filename));
}

/**
 * obj_audacious_complete_song_length:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @length: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.SongLength">SongLength()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_song_length (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint length)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   length));
}

/**
 * obj_audacious_complete_song_frames:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @length: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.SongFrames">SongFrames()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_song_frames (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint length)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   length));
}

/**
 * obj_audacious_complete_song_tuple:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @value: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.SongTuple">SongTuple()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_song_tuple (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *value)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@v)",
                   value));
}

/**
 * obj_audacious_complete_jump:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Jump">Jump()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_jump (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_add:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Add">Add()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_add (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_add_url:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.AddUrl">AddUrl()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_add_url (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_playlist_add:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.PlaylistAdd">PlaylistAdd()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_playlist_add (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_playlist_ins_url_string:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.PlaylistInsUrlString">PlaylistInsUrlString()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_playlist_ins_url_string (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_add_list:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.AddList">AddList()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_add_list (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_open_list:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.OpenList">OpenList()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_open_list (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_playlist_enqueue_to_temp:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.PlaylistEnqueueToTemp">PlaylistEnqueueToTemp()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_playlist_enqueue_to_temp (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_open_list_to_temp:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.OpenListToTemp">OpenListToTemp()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_open_list_to_temp (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_delete:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Delete">Delete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_delete (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_clear:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Clear">Clear()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_clear (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_auto_advance:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @is_advance: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.AutoAdvance">AutoAdvance()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_auto_advance (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean is_advance)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   is_advance));
}

/**
 * obj_audacious_complete_toggle_auto_advance:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.ToggleAutoAdvance">ToggleAutoAdvance()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_toggle_auto_advance (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_repeat:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @is_repeat: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Repeat">Repeat()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_repeat (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean is_repeat)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   is_repeat));
}

/**
 * obj_audacious_complete_toggle_repeat:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.ToggleRepeat">ToggleRepeat()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_toggle_repeat (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_shuffle:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @is_shuffle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.Shuffle">Shuffle()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_shuffle (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean is_shuffle)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   is_shuffle));
}

/**
 * obj_audacious_complete_toggle_shuffle:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.ToggleShuffle">ToggleShuffle()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_toggle_shuffle (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_stop_after:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @is_stopping: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.StopAfter">StopAfter()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_stop_after (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean is_stopping)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   is_stopping));
}

/**
 * obj_audacious_complete_toggle_stop_after:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.ToggleStopAfter">ToggleStopAfter()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_toggle_stop_after (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_queue_get_list_pos:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @pos: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.QueueGetListPos">QueueGetListPos()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_queue_get_list_pos (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint pos)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   pos));
}

/**
 * obj_audacious_complete_queue_get_queue_pos:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @qpos: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.QueueGetQueuePos">QueueGetQueuePos()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_queue_get_queue_pos (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint qpos)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   qpos));
}

/**
 * obj_audacious_complete_get_playqueue_length:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @length: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.GetPlayqueueLength">GetPlayqueueLength()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_get_playqueue_length (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint length)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   length));
}

/**
 * obj_audacious_complete_playqueue_add:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.PlayqueueAdd">PlayqueueAdd()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_playqueue_add (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_playqueue_remove:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.PlayqueueRemove">PlayqueueRemove()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_playqueue_remove (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_playqueue_clear:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.PlayqueueClear">PlayqueueClear()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_playqueue_clear (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_playqueue_is_queued:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @is_queued: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.PlayqueueIsQueued">PlayqueueIsQueued()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_playqueue_is_queued (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean is_queued)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   is_queued));
}

/**
 * obj_audacious_complete_number_of_playlists:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @count: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.NumberOfPlaylists">NumberOfPlaylists()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_number_of_playlists (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint count)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   count));
}

/**
 * obj_audacious_complete_get_active_playlist:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @plnum: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.GetActivePlaylist">GetActivePlaylist()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_get_active_playlist (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint plnum)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   plnum));
}

/**
 * obj_audacious_complete_set_active_playlist:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.SetActivePlaylist">SetActivePlaylist()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_set_active_playlist (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_get_active_playlist_name:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @plname: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.GetActivePlaylistName">GetActivePlaylistName()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_get_active_playlist_name (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *plname)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   plname));
}

/**
 * obj_audacious_complete_set_active_playlist_name:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.SetActivePlaylistName">SetActivePlaylistName()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_set_active_playlist_name (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_new_playlist:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.NewPlaylist">NewPlaylist()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_new_playlist (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_delete_active_playlist:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.DeleteActivePlaylist">DeleteActivePlaylist()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_delete_active_playlist (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * obj_audacious_complete_play_active_playlist:
 * @object: A #ObjAudacious.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-atheme-audacious.PlayActivePlaylist">PlayActivePlaylist()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
obj_audacious_complete_play_active_playlist (
    ObjAudacious *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * ObjAudaciousProxy:
 *
 * The #ObjAudaciousProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ObjAudaciousProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ObjAudaciousProxy.
 */

struct _ObjAudaciousProxyPrivate
{
  GData *qdata;
};

static void obj_audacious_proxy_iface_init (ObjAudaciousIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ObjAudaciousProxy, obj_audacious_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (ObjAudaciousProxy)
                         G_IMPLEMENT_INTERFACE (OBJ_TYPE_AUDACIOUS, obj_audacious_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ObjAudaciousProxy, obj_audacious_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (OBJ_TYPE_AUDACIOUS, obj_audacious_proxy_iface_init))

#endif
static void
obj_audacious_proxy_finalize (GObject *object)
{
  ObjAudaciousProxy *proxy = OBJ_AUDACIOUS_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (obj_audacious_proxy_parent_class)->finalize (object);
}

static void
obj_audacious_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
obj_audacious_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
obj_audacious_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_obj_audacious_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], OBJ_TYPE_AUDACIOUS);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, OBJ_TYPE_AUDACIOUS);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
obj_audacious_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  ObjAudaciousProxy *proxy = OBJ_AUDACIOUS_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_obj_audacious_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_obj_audacious_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
obj_audacious_proxy_init (ObjAudaciousProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = obj_audacious_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, OBJ_TYPE_AUDACIOUS_PROXY, ObjAudaciousProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), obj_audacious_interface_info ());
}

static void
obj_audacious_proxy_class_init (ObjAudaciousProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = obj_audacious_proxy_finalize;
  gobject_class->get_property = obj_audacious_proxy_get_property;
  gobject_class->set_property = obj_audacious_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = obj_audacious_proxy_g_signal;
  proxy_class->g_properties_changed = obj_audacious_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ObjAudaciousProxyPrivate));
#endif
}

static void
obj_audacious_proxy_iface_init (ObjAudaciousIface *iface G_GNUC_UNUSED)
{
}

/**
 * obj_audacious_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-atheme-audacious.top_of_page">org.atheme.audacious</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_proxy_new_finish() to get the result of the operation.
 *
 * See obj_audacious_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
obj_audacious_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (OBJ_TYPE_AUDACIOUS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.atheme.audacious", NULL);
}

/**
 * obj_audacious_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with obj_audacious_proxy_new().
 *
 * Returns: (transfer full) (type ObjAudaciousProxy): The constructed proxy object or %NULL if @error is set.
 */
ObjAudacious *
obj_audacious_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return OBJ_AUDACIOUS (ret);
  else
    return NULL;
}

/**
 * obj_audacious_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-atheme-audacious.top_of_page">org.atheme.audacious</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ObjAudaciousProxy): The constructed proxy object or %NULL if @error is set.
 */
ObjAudacious *
obj_audacious_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (OBJ_TYPE_AUDACIOUS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.atheme.audacious", NULL);
  if (ret != NULL)
    return OBJ_AUDACIOUS (ret);
  else
    return NULL;
}


/**
 * obj_audacious_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like obj_audacious_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call obj_audacious_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See obj_audacious_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
obj_audacious_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (OBJ_TYPE_AUDACIOUS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.atheme.audacious", NULL);
}

/**
 * obj_audacious_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to obj_audacious_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with obj_audacious_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type ObjAudaciousProxy): The constructed proxy object or %NULL if @error is set.
 */
ObjAudacious *
obj_audacious_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return OBJ_AUDACIOUS (ret);
  else
    return NULL;
}

/**
 * obj_audacious_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like obj_audacious_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See obj_audacious_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type ObjAudaciousProxy): The constructed proxy object or %NULL if @error is set.
 */
ObjAudacious *
obj_audacious_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (OBJ_TYPE_AUDACIOUS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.atheme.audacious", NULL);
  if (ret != NULL)
    return OBJ_AUDACIOUS (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * ObjAudaciousSkeleton:
 *
 * The #ObjAudaciousSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * ObjAudaciousSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #ObjAudaciousSkeleton.
 */

struct _ObjAudaciousSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_obj_audacious_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  ObjAudaciousSkeleton *skeleton = OBJ_AUDACIOUS_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], OBJ_TYPE_AUDACIOUS);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, OBJ_TYPE_AUDACIOUS);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_obj_audacious_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  ObjAudaciousSkeleton *skeleton = OBJ_AUDACIOUS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_obj_audacious_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_obj_audacious_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  ObjAudaciousSkeleton *skeleton = OBJ_AUDACIOUS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_obj_audacious_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _obj_audacious_skeleton_vtable =
{
  _obj_audacious_skeleton_handle_method_call,
  _obj_audacious_skeleton_handle_get_property,
  _obj_audacious_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
obj_audacious_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return obj_audacious_interface_info ();
}

static GDBusInterfaceVTable *
obj_audacious_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_obj_audacious_skeleton_vtable;
}

static GVariant *
obj_audacious_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  ObjAudaciousSkeleton *skeleton = OBJ_AUDACIOUS_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_obj_audacious_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _obj_audacious_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _obj_audacious_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _obj_audacious_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.atheme.audacious", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
obj_audacious_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void obj_audacious_skeleton_iface_init (ObjAudaciousIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (ObjAudaciousSkeleton, obj_audacious_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (ObjAudaciousSkeleton)
                         G_IMPLEMENT_INTERFACE (OBJ_TYPE_AUDACIOUS, obj_audacious_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (ObjAudaciousSkeleton, obj_audacious_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (OBJ_TYPE_AUDACIOUS, obj_audacious_skeleton_iface_init))

#endif
static void
obj_audacious_skeleton_finalize (GObject *object)
{
  ObjAudaciousSkeleton *skeleton = OBJ_AUDACIOUS_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (obj_audacious_skeleton_parent_class)->finalize (object);
}

static void
obj_audacious_skeleton_init (ObjAudaciousSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = obj_audacious_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, OBJ_TYPE_AUDACIOUS_SKELETON, ObjAudaciousSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
obj_audacious_skeleton_class_init (ObjAudaciousSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = obj_audacious_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = obj_audacious_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = obj_audacious_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = obj_audacious_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = obj_audacious_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (ObjAudaciousSkeletonPrivate));
#endif
}

static void
obj_audacious_skeleton_iface_init (ObjAudaciousIface *iface G_GNUC_UNUSED)
{
}

/**
 * obj_audacious_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-atheme-audacious.top_of_page">org.atheme.audacious</link>.
 *
 * Returns: (transfer full) (type ObjAudaciousSkeleton): The skeleton object.
 */
ObjAudacious *
obj_audacious_skeleton_new (void)
{
  return OBJ_AUDACIOUS (g_object_new (OBJ_TYPE_AUDACIOUS_SKELETON, NULL));
}

