/******************************************************************************
  This source file is part of the Avogadro project.
  This source code is released under the 3-Clause BSD License, (see "LICENSE").
******************************************************************************/

#include <QtCore/QtPlugin>

#include "/build/avogadrolibs/src/avogadrolibs/avogadro/qtplugins/crystal/crystal.h"


namespace Avogadro::QtPlugins {

class CrystalFactory : public QObject, public QtGui::ExtensionPluginFactory
{
  Q_OBJECT
  Q_PLUGIN_METADATA(IID "org.openchemistry.avogadro.ExtensionPluginFactory")
  Q_INTERFACES(Avogadro::QtGui::ExtensionPluginFactory)

public:
  explicit CrystalFactory(QObject* parent_ = nullptr) : QObject(parent_) {}

  QtGui::ExtensionPlugin* createInstance(QObject* parent_ = nullptr) override
  {
    auto* object = new Crystal(parent_);
    object->setObjectName("Crystal");
    return object;
  }

  QString identifier() const override { return "Crystal"; }

  QString description() const override { return "Provide crystal-specific editing/analysis."; }

};

} // namespace Avogadro::QtPlugins

#include "CrystalPlugin.moc"
