﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/chime-sdk-identity/model/Configuration.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace ChimeSDKIdentity
{
namespace Model
{

Configuration::Configuration(JsonView jsonValue)
{
  *this = jsonValue;
}

Configuration& Configuration::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("Lex"))
  {
    m_lex = jsonValue.GetObject("Lex");
    m_lexHasBeenSet = true;
  }
  return *this;
}

JsonValue Configuration::Jsonize() const
{
  JsonValue payload;

  if(m_lexHasBeenSet)
  {
   payload.WithObject("Lex", m_lex.Jsonize());

  }

  return payload;
}

} // namespace Model
} // namespace ChimeSDKIdentity
} // namespace Aws
