﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/apigateway/model/UpdateBasePathMappingRequest.h>
#include <aws/core/http/URI.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::APIGateway::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

Aws::String UpdateBasePathMappingRequest::SerializePayload() const {
  JsonValue payload;

  if (m_patchOperationsHasBeenSet) {
    Aws::Utils::Array<JsonValue> patchOperationsJsonList(m_patchOperations.size());
    for (unsigned patchOperationsIndex = 0; patchOperationsIndex < patchOperationsJsonList.GetLength(); ++patchOperationsIndex) {
      patchOperationsJsonList[patchOperationsIndex].AsObject(m_patchOperations[patchOperationsIndex].Jsonize());
    }
    payload.WithArray("patchOperations", std::move(patchOperationsJsonList));
  }

  return payload.View().WriteReadable();
}

void UpdateBasePathMappingRequest::AddQueryStringParameters(URI& uri) const {
  Aws::StringStream ss;
  if (m_domainNameIdHasBeenSet) {
    ss << m_domainNameId;
    uri.AddQueryStringParameter("domainNameId", ss.str());
    ss.str("");
  }
}
