/* GridView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from GridView.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 *           2011-2012 Giulio Collura
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "slingshot.h"
#include <gtk/gtk.h>
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <handy.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <math.h>
#include <float.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define SLINGSHOT_WIDGETS_GRID_TYPE_PAGE (slingshot_widgets_grid_page_get_type ())
typedef struct _SlingshotWidgetsGridPage SlingshotWidgetsGridPage;
enum  {
	SLINGSHOT_WIDGETS_GRID_0_PROPERTY,
	SLINGSHOT_WIDGETS_GRID_NUM_PROPERTIES
};
static GParamSpec* slingshot_widgets_grid_properties[SLINGSHOT_WIDGETS_GRID_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	SLINGSHOT_WIDGETS_GRID_APP_LAUNCHED_SIGNAL,
	SLINGSHOT_WIDGETS_GRID_NUM_SIGNALS
};
static guint slingshot_widgets_grid_signals[SLINGSHOT_WIDGETS_GRID_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SlingshotWidgetsGridPage {
	guint rows;
	guint columns;
	gint number;
};

struct _SlingshotWidgetsGridPrivate {
	GtkGrid* current_grid;
	GtkWidget* focused_widget;
	GeeHashMap* grids;
	HdyCarousel* paginator;
	SlingshotWidgetsGridPage page;
	gint focused_column;
	gint focused_row;
	guint current_row;
	guint current_col;
};

static gint SlingshotWidgetsGrid_private_offset;
static gpointer slingshot_widgets_grid_parent_class = NULL;
static GSettings* slingshot_widgets_grid__settings;
static GSettings* slingshot_widgets_grid__settings = NULL;
static GType slingshot_widgets_grid_type_id = 0;

static GType slingshot_widgets_grid_page_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SlingshotWidgetsGridPage* slingshot_widgets_grid_page_dup (const SlingshotWidgetsGridPage* self);
static void slingshot_widgets_grid_page_free (SlingshotWidgetsGridPage* self);
static GSettings* slingshot_widgets_grid_get_settings (void);
static void slingshot_widgets_grid_create_new_grid (SlingshotWidgetsGrid* self);
static void ____lambda43_ (SlingshotWidgetsGrid* self);
static void _____lambda43__slingshot_widgets_app_button_app_launched (SlingshotWidgetsAppButton* _sender,
                                                               gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static GtkWidget* slingshot_widgets_grid_get_widget_at (SlingshotWidgetsGrid* self,
                                                 gint column,
                                                 gint row);
static gint slingshot_widgets_grid_get_n_pages (SlingshotWidgetsGrid* self);
static gint slingshot_widgets_grid_get_current_page (SlingshotWidgetsGrid* self);
static GtkWidget* slingshot_widgets_grid_get_page (SlingshotWidgetsGrid* self,
                                            gint number);
static gboolean slingshot_widgets_grid_set_focus (SlingshotWidgetsGrid* self,
                                           gint column,
                                           gint row);
static gboolean slingshot_widgets_grid_real_key_press_event (GtkWidget* base,
                                                      GdkEventKey* event);
static void slingshot_widgets_grid_move_left (SlingshotWidgetsGrid* self,
                                       GdkEventKey* event);
static void slingshot_widgets_grid_move_right (SlingshotWidgetsGrid* self,
                                        GdkEventKey* event);
static void slingshot_widgets_grid_set_settings (GSettings* value);
static GObject * slingshot_widgets_grid_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void slingshot_widgets_grid_finalize (GObject * obj);
static void _vala_slingshot_widgets_grid_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_slingshot_widgets_grid_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
slingshot_widgets_grid_get_instance_private (SlingshotWidgetsGrid* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotWidgetsGrid_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
____lambda43_ (SlingshotWidgetsGrid* self)
{
	g_signal_emit (self, slingshot_widgets_grid_signals[SLINGSHOT_WIDGETS_GRID_APP_LAUNCHED_SIGNAL], 0);
}

static void
_____lambda43__slingshot_widgets_app_button_app_launched (SlingshotWidgetsAppButton* _sender,
                                                          gpointer self)
{
	____lambda43_ ((SlingshotWidgetsGrid*) self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
slingshot_widgets_grid_populate (SlingshotWidgetsGrid* self,
                                 SlingshotBackendAppSystem* app_system)
{
	GeeHashMap* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	GSettings* _tmp14_;
	HdyCarousel* _tmp15_;
	GtkGrid* _tmp16_;
	GSList* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_system != NULL);
	{
		GeeIterator* _grid_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->grids;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_grid_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GtkGrid* grid = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GtkGrid* _tmp9_;
			_tmp6_ = _grid_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _grid_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			grid = (GtkGrid*) _tmp8_;
			_tmp9_ = grid;
			gtk_widget_destroy ((GtkWidget*) _tmp9_);
			_g_object_unref0 (grid);
		}
		_g_object_unref0 (_grid_it);
	}
	_tmp10_ = self->priv->grids;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp10_);
	_tmp11_ = slingshot_widgets_grid_get_settings ();
	_tmp12_ = _tmp11_;
	self->priv->page.rows = (guint) g_settings_get_int (_tmp12_, "rows");
	_tmp13_ = slingshot_widgets_grid_get_settings ();
	_tmp14_ = _tmp13_;
	self->priv->page.columns = (guint) g_settings_get_int (_tmp14_, "columns");
	self->priv->current_row = (guint) 0;
	self->priv->current_col = (guint) 0;
	self->priv->page.number = 1;
	slingshot_widgets_grid_create_new_grid (self);
	_tmp15_ = self->priv->paginator;
	_tmp16_ = self->priv->current_grid;
	hdy_carousel_scroll_to (_tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = slingshot_backend_app_system_get_apps_by_name (app_system);
	{
		GSList* app_collection = NULL;
		GSList* app_it = NULL;
		app_collection = _tmp17_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			SlingshotBackendApp* _tmp18_;
			SlingshotBackendApp* app = NULL;
			_tmp18_ = _g_object_ref0 ((SlingshotBackendApp*) app_it->data);
			app = _tmp18_;
			{
				gboolean _tmp19_ = FALSE;
				GSettings* _tmp20_;
				GSettings* _tmp21_;
				SlingshotWidgetsAppButton* app_button = NULL;
				SlingshotBackendApp* _tmp25_;
				SlingshotWidgetsAppButton* _tmp26_;
				SlingshotWidgetsAppButton* _tmp27_;
				SlingshotWidgetsGridPage _tmp28_;
				SlingshotWidgetsGridPage _tmp30_;
				GtkGrid* _tmp32_;
				GtkWidget* _tmp33_;
				GtkGrid* _tmp34_;
				SlingshotWidgetsAppButton* _tmp35_;
				guint _tmp36_;
				GtkGrid* _tmp37_;
				_tmp20_ = slingshot_widgets_grid_get_settings ();
				_tmp21_ = _tmp20_;
				if (!g_settings_get_boolean (_tmp21_, "show-terminal-apps")) {
					SlingshotBackendApp* _tmp22_;
					gboolean _tmp23_;
					gboolean _tmp24_;
					_tmp22_ = app;
					_tmp23_ = slingshot_backend_app_get_terminal (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp19_ = _tmp24_;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					_g_object_unref0 (app);
					continue;
				}
				_tmp25_ = app;
				_tmp26_ = slingshot_widgets_app_button_new (_tmp25_);
				g_object_ref_sink (_tmp26_);
				app_button = _tmp26_;
				_tmp27_ = app_button;
				g_signal_connect_object (_tmp27_, "app-launched", (GCallback) _____lambda43__slingshot_widgets_app_button_app_launched, self, 0);
				_tmp28_ = self->priv->page;
				if (self->priv->current_col == _tmp28_.columns) {
					guint _tmp29_;
					self->priv->current_col = (guint) 0;
					_tmp29_ = self->priv->current_row;
					self->priv->current_row = _tmp29_ + 1;
				}
				_tmp30_ = self->priv->page;
				if (self->priv->current_row == _tmp30_.rows) {
					gint _tmp31_;
					_tmp31_ = self->priv->page.number;
					self->priv->page.number = _tmp31_ + 1;
					slingshot_widgets_grid_create_new_grid (self);
					self->priv->current_row = (guint) 0;
				}
				_tmp32_ = self->priv->current_grid;
				_tmp33_ = gtk_grid_get_child_at (_tmp32_, (gint) self->priv->current_col, (gint) self->priv->current_row);
				gtk_widget_destroy (_tmp33_);
				_tmp34_ = self->priv->current_grid;
				_tmp35_ = app_button;
				gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp35_, (gint) self->priv->current_col, (gint) self->priv->current_row, 1, 1);
				_tmp36_ = self->priv->current_col;
				self->priv->current_col = _tmp36_ + 1;
				_tmp37_ = self->priv->current_grid;
				gtk_widget_show ((GtkWidget*) _tmp37_);
				_g_object_unref0 (app_button);
				_g_object_unref0 (app);
			}
		}
		(app_collection == NULL) ? NULL : (app_collection = (_g_slist_free__g_object_unref0_ (app_collection), NULL));
	}
	gtk_widget_show_all ((GtkWidget*) self);
}

static void
slingshot_widgets_grid_create_new_grid (SlingshotWidgetsGrid* self)
{
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkGrid* _tmp7_;
	GeeHashMap* _tmp8_;
	SlingshotWidgetsGridPage _tmp9_;
	GtkGrid* _tmp10_;
	HdyCarousel* _tmp11_;
	GtkGrid* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->current_grid);
	self->priv->current_grid = _tmp0_;
	_tmp1_ = self->priv->current_grid;
	g_object_set ((GtkWidget*) _tmp1_, "expand", TRUE, NULL);
	_tmp2_ = self->priv->current_grid;
	gtk_grid_set_row_homogeneous (_tmp2_, TRUE);
	_tmp3_ = self->priv->current_grid;
	gtk_grid_set_column_homogeneous (_tmp3_, TRUE);
	_tmp4_ = self->priv->current_grid;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp4_, 12);
	_tmp5_ = self->priv->current_grid;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp5_, 12);
	_tmp6_ = self->priv->current_grid;
	gtk_grid_set_row_spacing (_tmp6_, 24);
	_tmp7_ = self->priv->current_grid;
	gtk_grid_set_column_spacing (_tmp7_, 0);
	_tmp8_ = self->priv->grids;
	_tmp9_ = self->priv->page;
	_tmp10_ = self->priv->current_grid;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, (gpointer) ((gintptr) _tmp9_.number), _tmp10_);
	_tmp11_ = self->priv->paginator;
	_tmp12_ = self->priv->current_grid;
	gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				SlingshotWidgetsGridPage _tmp15_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = row;
					row = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp15_ = self->priv->page;
				if (!(((guint) row) < _tmp15_.rows)) {
					break;
				}
				{
					gint column = 0;
					column = 0;
					{
						gboolean _tmp16_ = FALSE;
						_tmp16_ = TRUE;
						while (TRUE) {
							SlingshotWidgetsGridPage _tmp18_;
							GtkGrid* _tmp19_;
							GtkGrid* _tmp20_;
							GtkGrid* _tmp21_;
							if (!_tmp16_) {
								gint _tmp17_;
								_tmp17_ = column;
								column = _tmp17_ + 1;
							}
							_tmp16_ = FALSE;
							_tmp18_ = self->priv->page;
							if (!(((guint) column) < _tmp18_.columns)) {
								break;
							}
							_tmp19_ = self->priv->current_grid;
							_tmp20_ = (GtkGrid*) gtk_grid_new ();
							g_object_ref_sink (_tmp20_);
							_tmp21_ = _tmp20_;
							gtk_grid_attach (_tmp19_, (GtkWidget*) _tmp21_, column, row, 1, 1);
							_g_object_unref0 (_tmp21_);
						}
					}
				}
			}
		}
	}
}

static GtkWidget*
slingshot_widgets_grid_get_widget_at (SlingshotWidgetsGrid* self,
                                      gint column,
                                      gint row)
{
	gint col = 0;
	SlingshotWidgetsGridPage _tmp0_;
	GtkGrid* grid = NULL;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	GtkGrid* _tmp3_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->page;
	col = ((gint) (column / _tmp0_.columns)) + 1;
	_tmp1_ = self->priv->grids;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) col));
	grid = (GtkGrid*) _tmp2_;
	_tmp3_ = grid;
	if (_tmp3_ != NULL) {
		GtkGrid* _tmp4_;
		SlingshotWidgetsGridPage _tmp5_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		_tmp4_ = grid;
		_tmp5_ = self->priv->page;
		_tmp6_ = gtk_grid_get_child_at (_tmp4_, column - (((gint) _tmp5_.columns) * (col - 1)), row);
		_tmp7_ = _g_object_ref0 ((GtkWidget*) (SLINGSHOT_WIDGETS_IS_APP_BUTTON (_tmp6_) ? ((SlingshotWidgetsAppButton*) _tmp6_) : NULL));
		result = _tmp7_;
		_g_object_unref0 (grid);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (grid);
		return result;
	}
}

static gint
slingshot_widgets_grid_get_n_pages (SlingshotWidgetsGrid* self)
{
	SlingshotWidgetsGridPage _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->page;
	result = (gint) _tmp0_.number;
	return result;
}

static gint
slingshot_widgets_grid_get_current_page (SlingshotWidgetsGrid* self)
{
	HdyCarousel* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->paginator;
	_tmp1_ = hdy_carousel_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	result = ((gint) round (_tmp2_)) + 1;
	return result;
}

static GtkWidget*
slingshot_widgets_grid_get_page (SlingshotWidgetsGrid* self,
                                 gint number)
{
	gboolean _tmp0_ = FALSE;
	HdyCarousel* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	gconstpointer _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (number > 0) {
		_tmp0_ = number <= slingshot_widgets_grid_get_n_pages (self);
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "number > 0 && number <= get_n_pages ()");
	_tmp1_ = self->priv->paginator;
	_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_list_nth_data (_tmp3_, (guint) (number - 1));
	_tmp5_ = _g_object_ref0 ((GtkWidget*) _tmp4_);
	_tmp6_ = _tmp5_;
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (g_list_free (_tmp3_), NULL));
	result = _tmp6_;
	return result;
}

void
slingshot_widgets_grid_go_to_next (SlingshotWidgetsGrid* self)
{
	gint page_number = 0;
	g_return_if_fail (self != NULL);
	page_number = slingshot_widgets_grid_get_current_page (self) + 1;
	if (page_number <= slingshot_widgets_grid_get_n_pages (self)) {
		slingshot_widgets_grid_go_to_number (self, page_number);
	}
}

void
slingshot_widgets_grid_go_to_previous (SlingshotWidgetsGrid* self)
{
	gint page_number = 0;
	g_return_if_fail (self != NULL);
	page_number = slingshot_widgets_grid_get_current_page (self) - 1;
	if (page_number > 0) {
		slingshot_widgets_grid_go_to_number (self, page_number);
	}
}

void
slingshot_widgets_grid_go_to_last (SlingshotWidgetsGrid* self)
{
	g_return_if_fail (self != NULL);
	slingshot_widgets_grid_go_to_number (self, slingshot_widgets_grid_get_n_pages (self));
}

void
slingshot_widgets_grid_go_to_number (SlingshotWidgetsGrid* self,
                                     gint number)
{
	HdyCarousel* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->paginator;
	_tmp1_ = slingshot_widgets_grid_get_page (self, number);
	_tmp2_ = _tmp1_;
	hdy_carousel_scroll_to (_tmp0_, _tmp2_);
	_g_object_unref0 (_tmp2_);
}

static gboolean
slingshot_widgets_grid_set_focus (SlingshotWidgetsGrid* self,
                                  gint column,
                                  gint row)
{
	GtkWidget* target_widget = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = slingshot_widgets_grid_get_widget_at (self, column, row);
	target_widget = _tmp0_;
	_tmp1_ = target_widget;
	if (_tmp1_ != NULL) {
		SlingshotWidgetsGridPage _tmp2_;
		GtkWidget* _tmp3_;
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		_tmp2_ = self->priv->page;
		slingshot_widgets_grid_go_to_number (self, ((gint) (column / _tmp2_.columns)) + 1);
		self->priv->focused_column = column;
		self->priv->focused_row = row;
		_tmp3_ = target_widget;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (self->priv->focused_widget);
		self->priv->focused_widget = _tmp4_;
		_tmp5_ = self->priv->focused_widget;
		gtk_widget_grab_focus (_tmp5_);
		result = TRUE;
		_g_object_unref0 (target_widget);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (target_widget);
	return result;
}

static gboolean
slingshot_widgets_grid_real_key_press_event (GtkWidget* base,
                                             GdkEventKey* event)
{
	SlingshotWidgetsGrid * self;
	gboolean result;
	self = (SlingshotWidgetsGrid*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	switch (event->keyval) {
		case GDK_KEY_Home:
		case GDK_KEY_KP_Home:
		{
			slingshot_widgets_grid_go_to_number (self, 1);
			result = GDK_EVENT_STOP;
			return result;
		}
		case GDK_KEY_Left:
		case GDK_KEY_KP_Left:
		{
			GtkStyleContext* _tmp0_;
			GtkTextDirection _tmp1_;
			GtkTextDirection _tmp2_;
			_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
			_tmp1_ = gtk_style_context_get_direction (_tmp0_);
			_tmp2_ = _tmp1_;
			if (_tmp2_ == GTK_TEXT_DIR_LTR) {
				slingshot_widgets_grid_move_left (self, event);
			} else {
				slingshot_widgets_grid_move_right (self, event);
			}
			result = GDK_EVENT_STOP;
			return result;
		}
		case GDK_KEY_Right:
		case GDK_KEY_KP_Right:
		{
			GtkStyleContext* _tmp3_;
			GtkTextDirection _tmp4_;
			GtkTextDirection _tmp5_;
			_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
			_tmp4_ = gtk_style_context_get_direction (_tmp3_);
			_tmp5_ = _tmp4_;
			if (_tmp5_ == GTK_TEXT_DIR_LTR) {
				slingshot_widgets_grid_move_right (self, event);
			} else {
				slingshot_widgets_grid_move_left (self, event);
			}
			result = GDK_EVENT_STOP;
			return result;
		}
		case GDK_KEY_Up:
		case GDK_KEY_KP_Up:
		{
			if (slingshot_widgets_grid_set_focus (self, self->priv->focused_column, self->priv->focused_row - 1)) {
				result = GDK_EVENT_STOP;
				return result;
			}
			break;
		}
		case GDK_KEY_Down:
		case GDK_KEY_KP_Down:
		{
			slingshot_widgets_grid_set_focus (self, self->priv->focused_column, self->priv->focused_row + 1);
			result = GDK_EVENT_STOP;
			return result;
		}
		default:
		break;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static void
slingshot_widgets_grid_move_left (SlingshotWidgetsGrid* self,
                                  GdkEventKey* event)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	if (event->state == GDK_SHIFT_MASK) {
		slingshot_widgets_grid_go_to_previous (self);
	} else {
		slingshot_widgets_grid_set_focus (self, self->priv->focused_column - 1, self->priv->focused_row);
	}
}

static void
slingshot_widgets_grid_move_right (SlingshotWidgetsGrid* self,
                                   GdkEventKey* event)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	if (event->state == GDK_SHIFT_MASK) {
		slingshot_widgets_grid_go_to_next (self);
	} else {
		slingshot_widgets_grid_set_focus (self, self->priv->focused_column + 1, self->priv->focused_row);
	}
}

SlingshotWidgetsGrid*
slingshot_widgets_grid_construct (GType object_type)
{
	SlingshotWidgetsGrid * self = NULL;
	self = (SlingshotWidgetsGrid*) g_object_new (object_type, NULL);
	return self;
}

SlingshotWidgetsGrid*
slingshot_widgets_grid_new (void)
{
	return slingshot_widgets_grid_construct (SLINGSHOT_WIDGETS_TYPE_GRID);
}

static GSettings*
slingshot_widgets_grid_get_settings (void)
{
	GSettings* result;
	GSettings* _tmp0_;
	_tmp0_ = slingshot_widgets_grid__settings;
	result = _tmp0_;
	return result;
}

static void
slingshot_widgets_grid_set_settings (GSettings* value)
{
	GSettings* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (slingshot_widgets_grid__settings);
	slingshot_widgets_grid__settings = _tmp0_;
}

static SlingshotWidgetsGridPage*
slingshot_widgets_grid_page_dup (const SlingshotWidgetsGridPage* self)
{
	SlingshotWidgetsGridPage* dup;
	dup = g_new0 (SlingshotWidgetsGridPage, 1);
	memcpy (dup, self, sizeof (SlingshotWidgetsGridPage));
	return dup;
}

static void
slingshot_widgets_grid_page_free (SlingshotWidgetsGridPage* self)
{
	g_free (self);
}

static GType
slingshot_widgets_grid_page_get_type_once (void)
{
	GType slingshot_widgets_grid_page_type_id;
	slingshot_widgets_grid_page_type_id = g_boxed_type_register_static ("SlingshotWidgetsGridPage", (GBoxedCopyFunc) slingshot_widgets_grid_page_dup, (GBoxedFreeFunc) slingshot_widgets_grid_page_free);
	return slingshot_widgets_grid_page_type_id;
}

static GType
slingshot_widgets_grid_page_get_type (void)
{
	static volatile gsize slingshot_widgets_grid_page_type_id__once = 0;
	if (g_once_init_enter (&slingshot_widgets_grid_page_type_id__once)) {
		GType slingshot_widgets_grid_page_type_id;
		slingshot_widgets_grid_page_type_id = slingshot_widgets_grid_page_get_type_once ();
		g_once_init_leave (&slingshot_widgets_grid_page_type_id__once, slingshot_widgets_grid_page_type_id);
	}
	return slingshot_widgets_grid_page_type_id__once;
}

static GObject *
slingshot_widgets_grid_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotWidgetsGrid * self;
	HdyCarousel* _tmp0_;
	HdyCarousel* _tmp1_;
	SlingshotWidgetsSwitcher* page_switcher = NULL;
	SlingshotWidgetsSwitcher* _tmp2_;
	SlingshotWidgetsSwitcher* _tmp3_;
	HdyCarousel* _tmp4_;
	HdyCarousel* _tmp5_;
	SlingshotWidgetsSwitcher* _tmp6_;
	GeeHashMap* _tmp7_;
	parent_class = G_OBJECT_CLASS (slingshot_widgets_grid_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_WIDGETS_TYPE_GRID, SlingshotWidgetsGrid);
	self->priv->page.rows = (guint) 3;
	self->priv->page.columns = (guint) 5;
	self->priv->page.number = 1;
	_tmp0_ = (HdyCarousel*) hdy_carousel_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->paginator);
	self->priv->paginator = _tmp0_;
	_tmp1_ = self->priv->paginator;
	g_object_set ((GtkWidget*) _tmp1_, "expand", TRUE, NULL);
	_tmp2_ = slingshot_widgets_switcher_new ();
	g_object_ref_sink (_tmp2_);
	page_switcher = _tmp2_;
	_tmp3_ = page_switcher;
	_tmp4_ = self->priv->paginator;
	slingshot_widgets_switcher_set_paginator (_tmp3_, _tmp4_);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 24);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 12);
	_tmp5_ = self->priv->paginator;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp5_);
	_tmp6_ = page_switcher;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp6_);
	_tmp7_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, gtk_grid_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->grids);
	self->priv->grids = _tmp7_;
	slingshot_widgets_grid_create_new_grid (self);
	slingshot_widgets_grid_go_to_number (self, 1);
	_g_object_unref0 (page_switcher);
	return obj;
}

static void
slingshot_widgets_grid_class_init (SlingshotWidgetsGridClass * klass,
                                   gpointer klass_data)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	slingshot_widgets_grid_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotWidgetsGrid_private_offset);
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) slingshot_widgets_grid_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_widgets_grid_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_widgets_grid_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_widgets_grid_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_widgets_grid_finalize;
	slingshot_widgets_grid_signals[SLINGSHOT_WIDGETS_GRID_APP_LAUNCHED_SIGNAL] = g_signal_new ("app-launched", SLINGSHOT_WIDGETS_TYPE_GRID, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_settings_new ("org.ubuntubudgie.plugins.budgie-appmenu");
	_tmp1_ = _tmp0_;
	slingshot_widgets_grid_set_settings (_tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
slingshot_widgets_grid_instance_init (SlingshotWidgetsGrid * self,
                                      gpointer klass)
{
	self->priv = slingshot_widgets_grid_get_instance_private (self);
	self->priv->current_row = (guint) 0;
	self->priv->current_col = (guint) 0;
}

static void
slingshot_widgets_grid_finalize (GObject * obj)
{
	SlingshotWidgetsGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_WIDGETS_TYPE_GRID, SlingshotWidgetsGrid);
	_g_object_unref0 (self->priv->current_grid);
	_g_object_unref0 (self->priv->focused_widget);
	_g_object_unref0 (self->priv->grids);
	_g_object_unref0 (self->priv->paginator);
	G_OBJECT_CLASS (slingshot_widgets_grid_parent_class)->finalize (obj);
}

GType
slingshot_widgets_grid_get_type (void)
{
	return slingshot_widgets_grid_type_id;
}

GType
slingshot_widgets_grid_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotWidgetsGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_widgets_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotWidgetsGrid), 0, (GInstanceInitFunc) slingshot_widgets_grid_instance_init, NULL };
	slingshot_widgets_grid_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "SlingshotWidgetsGrid", &g_define_type_info, 0);
	SlingshotWidgetsGrid_private_offset = sizeof (SlingshotWidgetsGridPrivate);
	return slingshot_widgets_grid_type_id;
}

static void
_vala_slingshot_widgets_grid_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SlingshotWidgetsGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_WIDGETS_TYPE_GRID, SlingshotWidgetsGrid);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_widgets_grid_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SlingshotWidgetsGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_WIDGETS_TYPE_GRID, SlingshotWidgetsGrid);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

