/* config-service.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from config-service.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include "slingshot.h"
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SYNAPSE_CONFIG_OBJECT_0_PROPERTY,
	SYNAPSE_CONFIG_OBJECT_NUM_PROPERTIES
};
static GParamSpec* synapse_config_object_properties[SYNAPSE_CONFIG_OBJECT_NUM_PROPERTIES];
enum  {
	SYNAPSE_CONFIG_SERVICE_0_PROPERTY,
	SYNAPSE_CONFIG_SERVICE_NUM_PROPERTIES
};
static GParamSpec* synapse_config_service_properties[SYNAPSE_CONFIG_SERVICE_NUM_PROPERTIES];
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block8Data Block8Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SynapseConfigServicePrivate {
	JsonNode* root_node;
	gchar* config_file_name;
	guint save_timer_id;
};

struct _Block8Data {
	int _ref_count_;
	SynapseConfigService* self;
	SynapseConfigObject* co;
	gchar* group;
	gchar* key;
};

static gpointer synapse_config_object_parent_class = NULL;
static GType synapse_config_object_type_id = 0;
static gint SynapseConfigService_private_offset;
static gpointer synapse_config_service_parent_class = NULL;
static SynapseConfigService* synapse_config_service_instance;
static SynapseConfigService* synapse_config_service_instance = NULL;
static GType synapse_config_service_type_id = 0;

static void _vala_JsonNode_free (JsonNode* self);
static SynapseConfigService* synapse_config_service_new (void);
static SynapseConfigService* synapse_config_service_construct (GType object_type);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda22_ (Block8Data* _data8_);
static void ___lambda22__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static gboolean synapse_config_service_save_timeout (SynapseConfigService* self);
static gboolean _synapse_config_service_save_timeout_gsource_func (gpointer self);
static GObject * synapse_config_service_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void synapse_config_service_finalize (GObject * obj);

SynapseConfigObject*
synapse_config_object_construct (GType object_type)
{
	SynapseConfigObject * self = NULL;
	self = (SynapseConfigObject*) g_object_new (object_type, NULL);
	return self;
}

static void
synapse_config_object_class_init (SynapseConfigObjectClass * klass,
                                  gpointer klass_data)
{
	synapse_config_object_parent_class = g_type_class_peek_parent (klass);
}

static void
synapse_config_object_instance_init (SynapseConfigObject * self,
                                     gpointer klass)
{
}

GType
synapse_config_object_get_type (void)
{
	return synapse_config_object_type_id;
}

GType
synapse_config_object_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseConfigObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_config_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseConfigObject), 0, (GInstanceInitFunc) synapse_config_object_instance_init, NULL };
	synapse_config_object_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "SynapseConfigObject", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return synapse_config_object_type_id;
}

static inline gpointer
synapse_config_service_get_instance_private (SynapseConfigService* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseConfigService_private_offset);
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SynapseConfigService*
synapse_config_service_get_default (void)
{
	SynapseConfigService* _tmp0_ = NULL;
	SynapseConfigService* _tmp1_;
	SynapseConfigService* _tmp2_;
	SynapseConfigService* _tmp4_;
	SynapseConfigService* result;
	_tmp1_ = synapse_config_service_instance;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		SynapseConfigService* _tmp3_;
		_tmp3_ = synapse_config_service_new ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static SynapseConfigService*
synapse_config_service_construct (GType object_type)
{
	SynapseConfigService * self = NULL;
	self = (SynapseConfigService*) g_object_new (object_type, NULL);
	return self;
}

static SynapseConfigService*
synapse_config_service_new (void)
{
	return synapse_config_service_construct (SYNAPSE_TYPE_CONFIG_SERVICE);
}

/**
        * Creates an instance of an object derived from ConfigObject class, which
        * will have its public properties set to values stored in config file, or
        * to the default values if this object wasn't yet stored.
        *
        * @param group A group name.
        * @param key A key name.
        * @param config_type Type of the object (must be subclass of ConfigObject)
        * @return An instance of config_type.
        */
SynapseConfigObject*
synapse_config_service_get_config (SynapseConfigService* self,
                                   const gchar* group,
                                   const gchar* key,
                                   GType config_type)
{
	JsonObject* obj = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	JsonNode* group_node = NULL;
	JsonObject* _tmp2_;
	JsonNode* _tmp3_;
	JsonNode* _tmp4_;
	GObject* _tmp17_;
	GObject* _tmp18_;
	SynapseConfigObject* _tmp19_;
	SynapseConfigObject* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->root_node;
	_tmp1_ = json_node_get_object (_tmp0_);
	obj = _tmp1_;
	_tmp2_ = obj;
	_tmp3_ = json_object_get_member (_tmp2_, group);
	group_node = _tmp3_;
	_tmp4_ = group_node;
	if (_tmp4_ != NULL) {
		JsonNode* _tmp5_;
		_tmp5_ = group_node;
		if (json_node_get_node_type (_tmp5_) == JSON_NODE_OBJECT) {
			JsonObject* group_obj = NULL;
			JsonNode* _tmp6_;
			JsonObject* _tmp7_;
			JsonNode* key_node = NULL;
			JsonObject* _tmp8_;
			JsonNode* _tmp9_;
			gboolean _tmp10_ = FALSE;
			JsonNode* _tmp11_;
			_tmp6_ = group_node;
			_tmp7_ = json_node_get_object (_tmp6_);
			group_obj = _tmp7_;
			_tmp8_ = group_obj;
			_tmp9_ = json_object_get_member (_tmp8_, key);
			key_node = _tmp9_;
			_tmp11_ = key_node;
			if (_tmp11_ != NULL) {
				JsonNode* _tmp12_;
				_tmp12_ = key_node;
				_tmp10_ = json_node_get_node_type (_tmp12_) == JSON_NODE_OBJECT;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				GObject* _result_ = NULL;
				JsonNode* _tmp13_;
				GObject* _tmp14_;
				GObject* _tmp15_;
				SynapseConfigObject* _tmp16_;
				_tmp13_ = key_node;
				_tmp14_ = json_gobject_deserialize (config_type, _tmp13_);
				_result_ = _tmp14_;
				_tmp15_ = _result_;
				_tmp16_ = _g_object_ref0 (SYNAPSE_IS_CONFIG_OBJECT (_tmp15_) ? ((SynapseConfigObject*) _tmp15_) : NULL);
				result = _tmp16_;
				_g_object_unref0 (_result_);
				return result;
			}
		}
	}
	_tmp17_ = g_object_new (config_type, NULL);
	_tmp18_ = G_IS_INITIALLY_UNOWNED (_tmp17_) ? g_object_ref_sink (_tmp17_) : _tmp17_;
	_tmp19_ = SYNAPSE_IS_CONFIG_OBJECT (_tmp18_) ? ((SynapseConfigObject*) _tmp18_) : NULL;
	if (_tmp19_ == NULL) {
		_g_object_unref0 (_tmp18_);
	}
	result = _tmp19_;
	return result;
}

/**
        * Behaves in a similar way to get_config, but it also watches for changes
        * in the returned config object and saves them back to the config file
        * (without the need of calling set_config).
        *
        * @param group A group name.
        * @param key A key name.
        * @param config_type Type of the object (must be subclass of ConfigObject)
        */
static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		SynapseConfigService* self;
		self = _data8_->self;
		_g_free0 (_data8_->group);
		_g_free0 (_data8_->key);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda22_ (Block8Data* _data8_)
{
	SynapseConfigService* self;
	self = _data8_->self;
	synapse_config_service_set_config (self, _data8_->group, _data8_->key, _data8_->co);
}

static void
___lambda22__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda22_ (self);
}

SynapseConfigObject*
synapse_config_service_bind_config (SynapseConfigService* self,
                                    const gchar* group,
                                    const gchar* key,
                                    GType config_type)
{
	Block8Data* _data8_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	SynapseConfigObject* config_object = NULL;
	SynapseConfigObject* _tmp2_;
	SynapseConfigObject* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = g_strdup (group);
	_g_free0 (_data8_->group);
	_data8_->group = _tmp0_;
	_tmp1_ = g_strdup (key);
	_g_free0 (_data8_->key);
	_data8_->key = _tmp1_;
	_tmp2_ = synapse_config_service_get_config (self, _data8_->group, _data8_->key, config_type);
	config_object = _tmp2_;
	_data8_->co = config_object;
	g_signal_connect_data ((GObject*) _data8_->co, "notify", (GCallback) ___lambda22__g_object_notify, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	result = config_object;
	block8_data_unref (_data8_);
	_data8_ = NULL;
	return result;
}

/**
        * Stores all public properties of the object to the config file under
        * specified group and key names.
        *
        * @param group A group name.
        * @param key A key name.
        * @param cfg_obj ConfigObject instance.
        */
static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static gboolean
_synapse_config_service_save_timeout_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_config_service_save_timeout ((SynapseConfigService*) self);
	return result;
}

void
synapse_config_service_set_config (SynapseConfigService* self,
                                   const gchar* group,
                                   const gchar* key,
                                   SynapseConfigObject* cfg_obj)
{
	JsonObject* obj = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	gboolean _tmp2_ = FALSE;
	JsonObject* _tmp3_;
	JsonObject* group_obj = NULL;
	JsonObject* _tmp8_;
	JsonObject* _tmp9_;
	JsonObject* _tmp10_;
	JsonNode* node = NULL;
	JsonNode* _tmp12_;
	JsonObject* _tmp13_;
	JsonNode* _tmp14_;
	JsonObject* _tmp15_;
	JsonObject* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (cfg_obj != NULL);
	_tmp0_ = self->priv->root_node;
	_tmp1_ = json_node_get_object (_tmp0_);
	obj = _tmp1_;
	_tmp3_ = obj;
	if (!json_object_has_member (_tmp3_, group)) {
		_tmp2_ = TRUE;
	} else {
		JsonObject* _tmp4_;
		JsonNode* _tmp5_;
		_tmp4_ = obj;
		_tmp5_ = json_object_get_member (_tmp4_, group);
		_tmp2_ = json_node_get_node_type (_tmp5_) != JSON_NODE_OBJECT;
	}
	if (_tmp2_) {
		JsonObject* _tmp6_;
		JsonObject* _tmp7_;
		_tmp6_ = obj;
		_tmp7_ = json_object_new ();
		json_object_set_object_member (_tmp6_, group, _tmp7_);
	}
	_tmp8_ = obj;
	_tmp9_ = json_object_get_object_member (_tmp8_, group);
	group_obj = _tmp9_;
	_tmp10_ = group_obj;
	if (json_object_has_member (_tmp10_, key)) {
		JsonObject* _tmp11_;
		_tmp11_ = group_obj;
		json_object_remove_member (_tmp11_, key);
	}
	_tmp12_ = json_gobject_serialize ((GObject*) cfg_obj);
	node = _tmp12_;
	_tmp13_ = group_obj;
	_tmp14_ = node;
	_tmp15_ = json_node_get_object (_tmp14_);
	_tmp16_ = _json_object_ref0 (_tmp15_);
	json_object_set_object_member (_tmp13_, key, _tmp16_);
	if (self->priv->save_timer_id != ((guint) 0)) {
		g_source_remove (self->priv->save_timer_id);
	}
	self->priv->save_timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 30000, _synapse_config_service_save_timeout_gsource_func, g_object_ref (self), g_object_unref);
	__vala_JsonNode_free0 (node);
}

static gboolean
synapse_config_service_save_timeout (SynapseConfigService* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->save_timer_id = (guint) 0;
	synapse_config_service_save (self);
	result = FALSE;
	return result;
}

/**
        * Forces immediate saving of the configuration file to the filesystem.
        */
void
synapse_config_service_save (SynapseConfigService* self)
{
	JsonGenerator* generator = NULL;
	JsonGenerator* _tmp0_;
	JsonNode* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->save_timer_id != ((guint) 0)) {
		g_source_remove (self->priv->save_timer_id);
		self->priv->save_timer_id = (guint) 0;
	}
	_tmp0_ = json_generator_new ();
	generator = _tmp0_;
	json_generator_set_pretty (generator, TRUE);
	_tmp1_ = self->priv->root_node;
	json_generator_set_root (generator, _tmp1_);
	_tmp2_ = self->priv->config_file_name;
	_tmp3_ = g_path_get_dirname (_tmp2_);
	_tmp4_ = _tmp3_;
	g_mkdir_with_parents (_tmp4_, 0755);
	_g_free0 (_tmp4_);
	{
		const gchar* _tmp5_;
		_tmp5_ = self->priv->config_file_name;
		json_generator_to_file (generator, _tmp5_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_warning ("config-service.vala:169: %s", _tmp7_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (generator);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (generator);
}

static GObject *
synapse_config_service_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseConfigService * self;
	JsonParser* parser = NULL;
	JsonParser* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (synapse_config_service_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigService);
	synapse_config_service_instance = self;
	_tmp0_ = json_parser_new ();
	parser = _tmp0_;
	_tmp1_ = g_get_user_config_dir ();
	_tmp2_ = g_build_filename (_tmp1_, "synapse", "config.json", NULL);
	_g_free0 (self->priv->config_file_name);
	self->priv->config_file_name = _tmp2_;
	{
		JsonParser* _tmp3_;
		const gchar* _tmp4_;
		JsonParser* _tmp5_;
		JsonNode* _tmp6_;
		JsonNode* _tmp7_;
		JsonNode* _tmp8_;
		_tmp3_ = parser;
		_tmp4_ = self->priv->config_file_name;
		json_parser_load_from_file (_tmp3_, _tmp4_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = parser;
		_tmp6_ = json_parser_get_root (_tmp5_);
		_tmp7_ = json_node_copy (_tmp6_);
		__vala_JsonNode_free0 (self->priv->root_node);
		self->priv->root_node = _tmp7_;
		_tmp8_ = self->priv->root_node;
		if (json_node_get_node_type (_tmp8_) != JSON_NODE_OBJECT) {
			JsonNode* _tmp9_;
			JsonNode* _tmp10_;
			JsonObject* _tmp11_;
			_tmp9_ = json_node_new (JSON_NODE_OBJECT);
			__vala_JsonNode_free0 (self->priv->root_node);
			self->priv->root_node = _tmp9_;
			_tmp10_ = self->priv->root_node;
			_tmp11_ = json_object_new ();
			json_node_take_object (_tmp10_, _tmp11_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		JsonNode* _tmp12_;
		JsonNode* _tmp13_;
		JsonObject* _tmp14_;
		g_clear_error (&_inner_error0_);
		_tmp12_ = json_node_new (JSON_NODE_OBJECT);
		__vala_JsonNode_free0 (self->priv->root_node);
		self->priv->root_node = _tmp12_;
		_tmp13_ = self->priv->root_node;
		_tmp14_ = json_object_new ();
		json_node_take_object (_tmp13_, _tmp14_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_g_object_unref0 (parser);
	return obj;
}

static void
synapse_config_service_class_init (SynapseConfigServiceClass * klass,
                                   gpointer klass_data)
{
	synapse_config_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseConfigService_private_offset);
	G_OBJECT_CLASS (klass)->constructor = synapse_config_service_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_config_service_finalize;
}

static void
synapse_config_service_instance_init (SynapseConfigService * self,
                                      gpointer klass)
{
	self->priv = synapse_config_service_get_instance_private (self);
	self->priv->save_timer_id = (guint) 0;
}

static void
synapse_config_service_finalize (GObject * obj)
{
	SynapseConfigService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CONFIG_SERVICE, SynapseConfigService);
	if (self->priv->save_timer_id != ((guint) 0)) {
		synapse_config_service_save (self);
	}
	synapse_config_service_instance = NULL;
	__vala_JsonNode_free0 (self->priv->root_node);
	_g_free0 (self->priv->config_file_name);
	G_OBJECT_CLASS (synapse_config_service_parent_class)->finalize (obj);
}

GType
synapse_config_service_get_type (void)
{
	return synapse_config_service_type_id;
}

GType
synapse_config_service_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseConfigServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_config_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseConfigService), 0, (GInstanceInitFunc) synapse_config_service_instance_init, NULL };
	synapse_config_service_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "SynapseConfigService", &g_define_type_info, 0);
	SynapseConfigService_private_offset = sizeof (SynapseConfigServicePrivate);
	return synapse_config_service_type_id;
}

