// Copyright 2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by gen-spdx-go. DO NOT EDIT.

package spdx

// LicenseListVersion is the version of the SPDX license list.
//
// See https://spdx.org/licenses.
const LicenseListVersion = "v3.23"

// lowercaseIDToLicense contains a map from lowercased ID to License.
//
// Licenses will be unique by License ID in a case-insensitive manner.
var lowercaseIDToLicense = map[string]License{
	"0bsd": {
		ID:              "0BSD",
		Name:            "BSD Zero Clause License",
		Reference:       "https://spdx.org/licenses/0BSD.html",
		ReferenceNumber: 78,
		DetailsURL:      "https://spdx.org/licenses/0BSD.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://landley.net/toybox/license.html",
			"https://opensource.org/licenses/0BSD",
		},
		OSIApproved: true,
	},
	"aal": {
		ID:              "AAL",
		Name:            "Attribution Assurance License",
		Reference:       "https://spdx.org/licenses/AAL.html",
		ReferenceNumber: 433,
		DetailsURL:      "https://spdx.org/licenses/AAL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/attribution",
		},
		OSIApproved: true,
	},
	"adsl": {
		ID:              "ADSL",
		Name:            "Amazon Digital Services License",
		Reference:       "https://spdx.org/licenses/ADSL.html",
		ReferenceNumber: 498,
		DetailsURL:      "https://spdx.org/licenses/ADSL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/AmazonDigitalServicesLicense",
		},
		OSIApproved: false,
	},
	"afl-1.1": {
		ID:              "AFL-1.1",
		Name:            "Academic Free License v1.1",
		Reference:       "https://spdx.org/licenses/AFL-1.1.html",
		ReferenceNumber: 106,
		DetailsURL:      "https://spdx.org/licenses/AFL-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://opensource.linux-mirror.org/licenses/afl-1.1.txt",
			"http://wayback.archive.org/web/20021004124254/http://www.opensource.org/licenses/academic.php",
		},
		OSIApproved: true,
	},
	"afl-1.2": {
		ID:              "AFL-1.2",
		Name:            "Academic Free License v1.2",
		Reference:       "https://spdx.org/licenses/AFL-1.2.html",
		ReferenceNumber: 628,
		DetailsURL:      "https://spdx.org/licenses/AFL-1.2.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://opensource.linux-mirror.org/licenses/afl-1.2.txt",
			"http://wayback.archive.org/web/20021204204652/http://www.opensource.org/licenses/academic.php",
		},
		OSIApproved: true,
	},
	"afl-2.0": {
		ID:              "AFL-2.0",
		Name:            "Academic Free License v2.0",
		Reference:       "https://spdx.org/licenses/AFL-2.0.html",
		ReferenceNumber: 366,
		DetailsURL:      "https://spdx.org/licenses/AFL-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://wayback.archive.org/web/20060924134533/http://www.opensource.org/licenses/afl-2.0.txt",
		},
		OSIApproved: true,
	},
	"afl-2.1": {
		ID:              "AFL-2.1",
		Name:            "Academic Free License v2.1",
		Reference:       "https://spdx.org/licenses/AFL-2.1.html",
		ReferenceNumber: 220,
		DetailsURL:      "https://spdx.org/licenses/AFL-2.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://opensource.linux-mirror.org/licenses/afl-2.1.txt",
		},
		OSIApproved: true,
	},
	"afl-3.0": {
		ID:              "AFL-3.0",
		Name:            "Academic Free License v3.0",
		Reference:       "https://spdx.org/licenses/AFL-3.0.html",
		ReferenceNumber: 599,
		DetailsURL:      "https://spdx.org/licenses/AFL-3.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.rosenlaw.com/AFL3.0.htm",
			"https://opensource.org/licenses/afl-3.0",
		},
		OSIApproved: true,
	},
	"agpl-1.0": {
		ID:              "AGPL-1.0",
		Name:            "Affero General Public License v1.0",
		Reference:       "https://spdx.org/licenses/AGPL-1.0.html",
		ReferenceNumber: 374,
		DetailsURL:      "https://spdx.org/licenses/AGPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.affero.org/oagpl.html",
		},
		OSIApproved: false,
	},
	"agpl-1.0-only": {
		ID:              "AGPL-1.0-only",
		Name:            "Affero General Public License v1.0 only",
		Reference:       "https://spdx.org/licenses/AGPL-1.0-only.html",
		ReferenceNumber: 310,
		DetailsURL:      "https://spdx.org/licenses/AGPL-1.0-only.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.affero.org/oagpl.html",
		},
		OSIApproved: false,
	},
	"agpl-1.0-or-later": {
		ID:              "AGPL-1.0-or-later",
		Name:            "Affero General Public License v1.0 or later",
		Reference:       "https://spdx.org/licenses/AGPL-1.0-or-later.html",
		ReferenceNumber: 418,
		DetailsURL:      "https://spdx.org/licenses/AGPL-1.0-or-later.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.affero.org/oagpl.html",
		},
		OSIApproved: false,
	},
	"agpl-3.0": {
		ID:              "AGPL-3.0",
		Name:            "GNU Affero General Public License v3.0",
		Reference:       "https://spdx.org/licenses/AGPL-3.0.html",
		ReferenceNumber: 631,
		DetailsURL:      "https://spdx.org/licenses/AGPL-3.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/agpl.txt",
			"https://opensource.org/licenses/AGPL-3.0",
		},
		OSIApproved: true,
	},
	"agpl-3.0-only": {
		ID:              "AGPL-3.0-only",
		Name:            "GNU Affero General Public License v3.0 only",
		Reference:       "https://spdx.org/licenses/AGPL-3.0-only.html",
		ReferenceNumber: 495,
		DetailsURL:      "https://spdx.org/licenses/AGPL-3.0-only.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/agpl.txt",
			"https://opensource.org/licenses/AGPL-3.0",
		},
		OSIApproved: true,
	},
	"agpl-3.0-or-later": {
		ID:              "AGPL-3.0-or-later",
		Name:            "GNU Affero General Public License v3.0 or later",
		Reference:       "https://spdx.org/licenses/AGPL-3.0-or-later.html",
		ReferenceNumber: 228,
		DetailsURL:      "https://spdx.org/licenses/AGPL-3.0-or-later.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/agpl.txt",
			"https://opensource.org/licenses/AGPL-3.0",
		},
		OSIApproved: true,
	},
	"amdplpa": {
		ID:              "AMDPLPA",
		Name:            "AMD's plpa_map.c License",
		Reference:       "https://spdx.org/licenses/AMDPLPA.html",
		ReferenceNumber: 100,
		DetailsURL:      "https://spdx.org/licenses/AMDPLPA.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/AMD_plpa_map_License",
		},
		OSIApproved: false,
	},
	"aml": {
		ID:              "AML",
		Name:            "Apple MIT License",
		Reference:       "https://spdx.org/licenses/AML.html",
		ReferenceNumber: 2,
		DetailsURL:      "https://spdx.org/licenses/AML.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Apple_MIT_License",
		},
		OSIApproved: false,
	},
	"aml-glslang": {
		ID:              "AML-glslang",
		Name:            "AML glslang variant License",
		Reference:       "https://spdx.org/licenses/AML-glslang.html",
		ReferenceNumber: 370,
		DetailsURL:      "https://spdx.org/licenses/AML-glslang.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/KhronosGroup/glslang/blob/main/LICENSE.txt#L949",
			"https://docs.omniverse.nvidia.com/install-guide/latest/common/licenses.html",
		},
		OSIApproved: false,
	},
	"ampas": {
		ID:              "AMPAS",
		Name:            "Academy of Motion Picture Arts and Sciences BSD",
		Reference:       "https://spdx.org/licenses/AMPAS.html",
		ReferenceNumber: 267,
		DetailsURL:      "https://spdx.org/licenses/AMPAS.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/BSD#AMPASBSD",
		},
		OSIApproved: false,
	},
	"antlr-pd": {
		ID:              "ANTLR-PD",
		Name:            "ANTLR Software Rights Notice",
		Reference:       "https://spdx.org/licenses/ANTLR-PD.html",
		ReferenceNumber: 586,
		DetailsURL:      "https://spdx.org/licenses/ANTLR-PD.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.antlr2.org/license.html",
		},
		OSIApproved: false,
	},
	"antlr-pd-fallback": {
		ID:              "ANTLR-PD-fallback",
		Name:            "ANTLR Software Rights Notice with license fallback",
		Reference:       "https://spdx.org/licenses/ANTLR-PD-fallback.html",
		ReferenceNumber: 133,
		DetailsURL:      "https://spdx.org/licenses/ANTLR-PD-fallback.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.antlr2.org/license.html",
		},
		OSIApproved: false,
	},
	"apafml": {
		ID:              "APAFML",
		Name:            "Adobe Postscript AFM License",
		Reference:       "https://spdx.org/licenses/APAFML.html",
		ReferenceNumber: 376,
		DetailsURL:      "https://spdx.org/licenses/APAFML.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/AdobePostscriptAFM",
		},
		OSIApproved: false,
	},
	"apl-1.0": {
		ID:              "APL-1.0",
		Name:            "Adaptive Public License 1.0",
		Reference:       "https://spdx.org/licenses/APL-1.0.html",
		ReferenceNumber: 226,
		DetailsURL:      "https://spdx.org/licenses/APL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/APL-1.0",
		},
		OSIApproved: true,
	},
	"apsl-1.0": {
		ID:              "APSL-1.0",
		Name:            "Apple Public Source License 1.0",
		Reference:       "https://spdx.org/licenses/APSL-1.0.html",
		ReferenceNumber: 536,
		DetailsURL:      "https://spdx.org/licenses/APSL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Apple_Public_Source_License_1.0",
		},
		OSIApproved: true,
	},
	"apsl-1.1": {
		ID:              "APSL-1.1",
		Name:            "Apple Public Source License 1.1",
		Reference:       "https://spdx.org/licenses/APSL-1.1.html",
		ReferenceNumber: 475,
		DetailsURL:      "https://spdx.org/licenses/APSL-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.opensource.apple.com/source/IOSerialFamily/IOSerialFamily-7/APPLE_LICENSE",
		},
		OSIApproved: true,
	},
	"apsl-1.2": {
		ID:              "APSL-1.2",
		Name:            "Apple Public Source License 1.2",
		Reference:       "https://spdx.org/licenses/APSL-1.2.html",
		ReferenceNumber: 547,
		DetailsURL:      "https://spdx.org/licenses/APSL-1.2.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.samurajdata.se/opensource/mirror/licenses/apsl.php",
		},
		OSIApproved: true,
	},
	"apsl-2.0": {
		ID:              "APSL-2.0",
		Name:            "Apple Public Source License 2.0",
		Reference:       "https://spdx.org/licenses/APSL-2.0.html",
		ReferenceNumber: 147,
		DetailsURL:      "https://spdx.org/licenses/APSL-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.opensource.apple.com/license/apsl/",
		},
		OSIApproved: true,
	},
	"aswf-digital-assets-1.0": {
		ID:              "ASWF-Digital-Assets-1.0",
		Name:            "ASWF Digital Assets License version 1.0",
		Reference:       "https://spdx.org/licenses/ASWF-Digital-Assets-1.0.html",
		ReferenceNumber: 64,
		DetailsURL:      "https://spdx.org/licenses/ASWF-Digital-Assets-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/AcademySoftwareFoundation/foundation/blob/main/digital_assets/aswf_digital_assets_license_v1.0.txt",
		},
		OSIApproved: false,
	},
	"aswf-digital-assets-1.1": {
		ID:              "ASWF-Digital-Assets-1.1",
		Name:            "ASWF Digital Assets License 1.1",
		Reference:       "https://spdx.org/licenses/ASWF-Digital-Assets-1.1.html",
		ReferenceNumber: 8,
		DetailsURL:      "https://spdx.org/licenses/ASWF-Digital-Assets-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/AcademySoftwareFoundation/foundation/blob/main/digital_assets/aswf_digital_assets_license_v1.1.txt",
		},
		OSIApproved: false,
	},
	"abstyles": {
		ID:              "Abstyles",
		Name:            "Abstyles License",
		Reference:       "https://spdx.org/licenses/Abstyles.html",
		ReferenceNumber: 395,
		DetailsURL:      "https://spdx.org/licenses/Abstyles.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Abstyles",
		},
		OSIApproved: false,
	},
	"adacore-doc": {
		ID:              "AdaCore-doc",
		Name:            "AdaCore Doc License",
		Reference:       "https://spdx.org/licenses/AdaCore-doc.html",
		ReferenceNumber: 108,
		DetailsURL:      "https://spdx.org/licenses/AdaCore-doc.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/AdaCore/xmlada/blob/master/docs/index.rst",
			"https://github.com/AdaCore/gnatcoll-core/blob/master/docs/index.rst",
			"https://github.com/AdaCore/gnatcoll-db/blob/master/docs/index.rst",
		},
		OSIApproved: false,
	},
	"adobe-2006": {
		ID:              "Adobe-2006",
		Name:            "Adobe Systems Incorporated Source Code License Agreement",
		Reference:       "https://spdx.org/licenses/Adobe-2006.html",
		ReferenceNumber: 358,
		DetailsURL:      "https://spdx.org/licenses/Adobe-2006.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/AdobeLicense",
		},
		OSIApproved: false,
	},
	"adobe-display-postscript": {
		ID:              "Adobe-Display-PostScript",
		Name:            "Adobe Display PostScript License",
		Reference:       "https://spdx.org/licenses/Adobe-Display-PostScript.html",
		ReferenceNumber: 272,
		DetailsURL:      "https://spdx.org/licenses/Adobe-Display-PostScript.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://gitlab.freedesktop.org/xorg/xserver/-/blob/master/COPYING?ref_type=heads#L752",
		},
		OSIApproved: false,
	},
	"adobe-glyph": {
		ID:              "Adobe-Glyph",
		Name:            "Adobe Glyph List License",
		Reference:       "https://spdx.org/licenses/Adobe-Glyph.html",
		ReferenceNumber: 297,
		DetailsURL:      "https://spdx.org/licenses/Adobe-Glyph.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/MIT#AdobeGlyph",
		},
		OSIApproved: false,
	},
	"adobe-utopia": {
		ID:              "Adobe-Utopia",
		Name:            "Adobe Utopia Font License",
		Reference:       "https://spdx.org/licenses/Adobe-Utopia.html",
		ReferenceNumber: 311,
		DetailsURL:      "https://spdx.org/licenses/Adobe-Utopia.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://gitlab.freedesktop.org/xorg/font/adobe-utopia-100dpi/-/blob/master/COPYING?ref_type=heads",
		},
		OSIApproved: false,
	},
	"afmparse": {
		ID:              "Afmparse",
		Name:            "Afmparse License",
		Reference:       "https://spdx.org/licenses/Afmparse.html",
		ReferenceNumber: 172,
		DetailsURL:      "https://spdx.org/licenses/Afmparse.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Afmparse",
		},
		OSIApproved: false,
	},
	"aladdin": {
		ID:              "Aladdin",
		Name:            "Aladdin Free Public License",
		Reference:       "https://spdx.org/licenses/Aladdin.html",
		ReferenceNumber: 35,
		DetailsURL:      "https://spdx.org/licenses/Aladdin.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://pages.cs.wisc.edu/~ghost/doc/AFPL/6.01/Public.htm",
		},
		OSIApproved: false,
	},
	"apache-1.0": {
		ID:              "Apache-1.0",
		Name:            "Apache License 1.0",
		Reference:       "https://spdx.org/licenses/Apache-1.0.html",
		ReferenceNumber: 463,
		DetailsURL:      "https://spdx.org/licenses/Apache-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.apache.org/licenses/LICENSE-1.0",
		},
		OSIApproved: false,
	},
	"apache-1.1": {
		ID:              "Apache-1.1",
		Name:            "Apache License 1.1",
		Reference:       "https://spdx.org/licenses/Apache-1.1.html",
		ReferenceNumber: 627,
		DetailsURL:      "https://spdx.org/licenses/Apache-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://apache.org/licenses/LICENSE-1.1",
			"https://opensource.org/licenses/Apache-1.1",
		},
		OSIApproved: true,
	},
	"apache-2.0": {
		ID:              "Apache-2.0",
		Name:            "Apache License 2.0",
		Reference:       "https://spdx.org/licenses/Apache-2.0.html",
		ReferenceNumber: 501,
		DetailsURL:      "https://spdx.org/licenses/Apache-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.apache.org/licenses/LICENSE-2.0",
			"https://opensource.org/licenses/Apache-2.0",
		},
		OSIApproved: true,
	},
	"app-s2p": {
		ID:              "App-s2p",
		Name:            "App::s2p License",
		Reference:       "https://spdx.org/licenses/App-s2p.html",
		ReferenceNumber: 123,
		DetailsURL:      "https://spdx.org/licenses/App-s2p.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/App-s2p",
		},
		OSIApproved: false,
	},
	"arphic-1999": {
		ID:              "Arphic-1999",
		Name:            "Arphic Public License",
		Reference:       "https://spdx.org/licenses/Arphic-1999.html",
		ReferenceNumber: 326,
		DetailsURL:      "https://spdx.org/licenses/Arphic-1999.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://ftp.gnu.org/gnu/non-gnu/chinese-fonts-truetype/LICENSE",
		},
		OSIApproved: false,
	},
	"artistic-1.0": {
		ID:              "Artistic-1.0",
		Name:            "Artistic License 1.0",
		Reference:       "https://spdx.org/licenses/Artistic-1.0.html",
		ReferenceNumber: 278,
		DetailsURL:      "https://spdx.org/licenses/Artistic-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/Artistic-1.0",
		},
		OSIApproved: true,
	},
	"artistic-1.0-perl": {
		ID:              "Artistic-1.0-Perl",
		Name:            "Artistic License 1.0 (Perl)",
		Reference:       "https://spdx.org/licenses/Artistic-1.0-Perl.html",
		ReferenceNumber: 634,
		DetailsURL:      "https://spdx.org/licenses/Artistic-1.0-Perl.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://dev.perl.org/licenses/artistic.html",
		},
		OSIApproved: true,
	},
	"artistic-1.0-cl8": {
		ID:              "Artistic-1.0-cl8",
		Name:            "Artistic License 1.0 w/clause 8",
		Reference:       "https://spdx.org/licenses/Artistic-1.0-cl8.html",
		ReferenceNumber: 234,
		DetailsURL:      "https://spdx.org/licenses/Artistic-1.0-cl8.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/Artistic-1.0",
		},
		OSIApproved: true,
	},
	"artistic-2.0": {
		ID:              "Artistic-2.0",
		Name:            "Artistic License 2.0",
		Reference:       "https://spdx.org/licenses/Artistic-2.0.html",
		ReferenceNumber: 222,
		DetailsURL:      "https://spdx.org/licenses/Artistic-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.perlfoundation.org/artistic_license_2_0",
			"https://www.perlfoundation.org/artistic-license-20.html",
			"https://opensource.org/licenses/artistic-license-2.0",
		},
		OSIApproved: true,
	},
	"bsd-1-clause": {
		ID:              "BSD-1-Clause",
		Name:            "BSD 1-Clause License",
		Reference:       "https://spdx.org/licenses/BSD-1-Clause.html",
		ReferenceNumber: 308,
		DetailsURL:      "https://spdx.org/licenses/BSD-1-Clause.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://svnweb.freebsd.org/base/head/include/ifaddrs.h?revision=326823",
		},
		OSIApproved: true,
	},
	"bsd-2-clause": {
		ID:              "BSD-2-Clause",
		Name:            "BSD 2-Clause \"Simplified\" License",
		Reference:       "https://spdx.org/licenses/BSD-2-Clause.html",
		ReferenceNumber: 232,
		DetailsURL:      "https://spdx.org/licenses/BSD-2-Clause.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/BSD-2-Clause",
		},
		OSIApproved: true,
	},
	"bsd-2-clause-darwin": {
		ID:              "BSD-2-Clause-Darwin",
		Name:            "BSD 2-Clause - Ian Darwin variant",
		Reference:       "https://spdx.org/licenses/BSD-2-Clause-Darwin.html",
		ReferenceNumber: 555,
		DetailsURL:      "https://spdx.org/licenses/BSD-2-Clause-Darwin.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/file/file/blob/master/COPYING",
		},
		OSIApproved: false,
	},
	"bsd-2-clause-freebsd": {
		ID:              "BSD-2-Clause-FreeBSD",
		Name:            "BSD 2-Clause FreeBSD License",
		Reference:       "https://spdx.org/licenses/BSD-2-Clause-FreeBSD.html",
		ReferenceNumber: 56,
		DetailsURL:      "https://spdx.org/licenses/BSD-2-Clause-FreeBSD.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.freebsd.org/copyright/freebsd-license.html",
		},
		OSIApproved: false,
	},
	"bsd-2-clause-netbsd": {
		ID:              "BSD-2-Clause-NetBSD",
		Name:            "BSD 2-Clause NetBSD License",
		Reference:       "https://spdx.org/licenses/BSD-2-Clause-NetBSD.html",
		ReferenceNumber: 530,
		DetailsURL:      "https://spdx.org/licenses/BSD-2-Clause-NetBSD.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.netbsd.org/about/redistribution.html#default",
		},
		OSIApproved: false,
	},
	"bsd-2-clause-patent": {
		ID:              "BSD-2-Clause-Patent",
		Name:            "BSD-2-Clause Plus Patent License",
		Reference:       "https://spdx.org/licenses/BSD-2-Clause-Patent.html",
		ReferenceNumber: 200,
		DetailsURL:      "https://spdx.org/licenses/BSD-2-Clause-Patent.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/BSDplusPatent",
		},
		OSIApproved: true,
	},
	"bsd-2-clause-views": {
		ID:              "BSD-2-Clause-Views",
		Name:            "BSD 2-Clause with views sentence",
		Reference:       "https://spdx.org/licenses/BSD-2-Clause-Views.html",
		ReferenceNumber: 539,
		DetailsURL:      "https://spdx.org/licenses/BSD-2-Clause-Views.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.freebsd.org/copyright/freebsd-license.html",
			"https://people.freebsd.org/~ivoras/wine/patch-wine-nvidia.sh",
			"https://github.com/protegeproject/protege/blob/master/license.txt",
		},
		OSIApproved: false,
	},
	"bsd-3-clause": {
		ID:              "BSD-3-Clause",
		Name:            "BSD 3-Clause \"New\" or \"Revised\" License",
		Reference:       "https://spdx.org/licenses/BSD-3-Clause.html",
		ReferenceNumber: 409,
		DetailsURL:      "https://spdx.org/licenses/BSD-3-Clause.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/BSD-3-Clause",
			"https://www.eclipse.org/org/documents/edl-v10.php",
		},
		OSIApproved: true,
	},
	"bsd-3-clause-attribution": {
		ID:              "BSD-3-Clause-Attribution",
		Name:            "BSD with attribution",
		Reference:       "https://spdx.org/licenses/BSD-3-Clause-Attribution.html",
		ReferenceNumber: 127,
		DetailsURL:      "https://spdx.org/licenses/BSD-3-Clause-Attribution.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/BSD_with_Attribution",
		},
		OSIApproved: false,
	},
	"bsd-3-clause-clear": {
		ID:              "BSD-3-Clause-Clear",
		Name:            "BSD 3-Clause Clear License",
		Reference:       "https://spdx.org/licenses/BSD-3-Clause-Clear.html",
		ReferenceNumber: 251,
		DetailsURL:      "https://spdx.org/licenses/BSD-3-Clause-Clear.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://labs.metacarta.com/license-explanation.html#license",
		},
		OSIApproved: false,
	},
	"bsd-3-clause-hp": {
		ID:              "BSD-3-Clause-HP",
		Name:            "Hewlett-Packard BSD variant license",
		Reference:       "https://spdx.org/licenses/BSD-3-Clause-HP.html",
		ReferenceNumber: 189,
		DetailsURL:      "https://spdx.org/licenses/BSD-3-Clause-HP.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/zdohnal/hplip/blob/master/COPYING#L939",
		},
		OSIApproved: false,
	},
	"bsd-3-clause-lbnl": {
		ID:              "BSD-3-Clause-LBNL",
		Name:            "Lawrence Berkeley National Labs BSD variant license",
		Reference:       "https://spdx.org/licenses/BSD-3-Clause-LBNL.html",
		ReferenceNumber: 377,
		DetailsURL:      "https://spdx.org/licenses/BSD-3-Clause-LBNL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/LBNLBSD",
		},
		OSIApproved: true,
	},
	"bsd-3-clause-modification": {
		ID:              "BSD-3-Clause-Modification",
		Name:            "BSD 3-Clause Modification",
		Reference:       "https://spdx.org/licenses/BSD-3-Clause-Modification.html",
		ReferenceNumber: 89,
		DetailsURL:      "https://spdx.org/licenses/BSD-3-Clause-Modification.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing:BSD#Modification_Variant",
		},
		OSIApproved: false,
	},
	"bsd-3-clause-no-military-license": {
		ID:              "BSD-3-Clause-No-Military-License",
		Name:            "BSD 3-Clause No Military License",
		Reference:       "https://spdx.org/licenses/BSD-3-Clause-No-Military-License.html",
		ReferenceNumber: 216,
		DetailsURL:      "https://spdx.org/licenses/BSD-3-Clause-No-Military-License.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://gitlab.syncad.com/hive/dhive/-/blob/master/LICENSE",
			"https://github.com/greymass/swift-eosio/blob/master/LICENSE",
		},
		OSIApproved: false,
	},
	"bsd-3-clause-no-nuclear-license": {
		ID:              "BSD-3-Clause-No-Nuclear-License",
		Name:            "BSD 3-Clause No Nuclear License",
		Reference:       "https://spdx.org/licenses/BSD-3-Clause-No-Nuclear-License.html",
		ReferenceNumber: 192,
		DetailsURL:      "https://spdx.org/licenses/BSD-3-Clause-No-Nuclear-License.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://download.oracle.com/otn-pub/java/licenses/bsd.txt?AuthParam=1467140197_43d516ce1776bd08a58235a7785be1cc",
		},
		OSIApproved: false,
	},
	"bsd-3-clause-no-nuclear-license-2014": {
		ID:              "BSD-3-Clause-No-Nuclear-License-2014",
		Name:            "BSD 3-Clause No Nuclear License 2014",
		Reference:       "https://spdx.org/licenses/BSD-3-Clause-No-Nuclear-License-2014.html",
		ReferenceNumber: 249,
		DetailsURL:      "https://spdx.org/licenses/BSD-3-Clause-No-Nuclear-License-2014.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://java.net/projects/javaeetutorial/pages/BerkeleyLicense",
		},
		OSIApproved: false,
	},
	"bsd-3-clause-no-nuclear-warranty": {
		ID:              "BSD-3-Clause-No-Nuclear-Warranty",
		Name:            "BSD 3-Clause No Nuclear Warranty",
		Reference:       "https://spdx.org/licenses/BSD-3-Clause-No-Nuclear-Warranty.html",
		ReferenceNumber: 437,
		DetailsURL:      "https://spdx.org/licenses/BSD-3-Clause-No-Nuclear-Warranty.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://jogamp.org/git/?p=gluegen.git;a=blob_plain;f=LICENSE.txt",
		},
		OSIApproved: false,
	},
	"bsd-3-clause-open-mpi": {
		ID:              "BSD-3-Clause-Open-MPI",
		Name:            "BSD 3-Clause Open MPI variant",
		Reference:       "https://spdx.org/licenses/BSD-3-Clause-Open-MPI.html",
		ReferenceNumber: 424,
		DetailsURL:      "https://spdx.org/licenses/BSD-3-Clause-Open-MPI.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.open-mpi.org/community/license.php",
			"http://www.netlib.org/lapack/LICENSE.txt",
		},
		OSIApproved: false,
	},
	"bsd-3-clause-sun": {
		ID:              "BSD-3-Clause-Sun",
		Name:            "BSD 3-Clause Sun Microsystems",
		Reference:       "https://spdx.org/licenses/BSD-3-Clause-Sun.html",
		ReferenceNumber: 596,
		DetailsURL:      "https://spdx.org/licenses/BSD-3-Clause-Sun.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/xmlark/msv/blob/b9316e2f2270bc1606952ea4939ec87fbba157f3/xsdlib/src/main/java/com/sun/msv/datatype/regexp/InternalImpl.java",
		},
		OSIApproved: false,
	},
	"bsd-3-clause-acpica": {
		ID:              "BSD-3-Clause-acpica",
		Name:            "BSD 3-Clause acpica variant",
		Reference:       "https://spdx.org/licenses/BSD-3-Clause-acpica.html",
		ReferenceNumber: 306,
		DetailsURL:      "https://spdx.org/licenses/BSD-3-Clause-acpica.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/acpica/acpica/blob/master/source/common/acfileio.c#L119",
		},
		OSIApproved: false,
	},
	"bsd-3-clause-flex": {
		ID:              "BSD-3-Clause-flex",
		Name:            "BSD 3-Clause Flex variant",
		Reference:       "https://spdx.org/licenses/BSD-3-Clause-flex.html",
		ReferenceNumber: 388,
		DetailsURL:      "https://spdx.org/licenses/BSD-3-Clause-flex.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/westes/flex/blob/master/COPYING",
		},
		OSIApproved: false,
	},
	"bsd-4-clause": {
		ID:              "BSD-4-Clause",
		Name:            "BSD 4-Clause \"Original\" or \"Old\" License",
		Reference:       "https://spdx.org/licenses/BSD-4-Clause.html",
		ReferenceNumber: 453,
		DetailsURL:      "https://spdx.org/licenses/BSD-4-Clause.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://directory.fsf.org/wiki/License:BSD_4Clause",
		},
		OSIApproved: false,
	},
	"bsd-4-clause-shortened": {
		ID:              "BSD-4-Clause-Shortened",
		Name:            "BSD 4 Clause Shortened",
		Reference:       "https://spdx.org/licenses/BSD-4-Clause-Shortened.html",
		ReferenceNumber: 46,
		DetailsURL:      "https://spdx.org/licenses/BSD-4-Clause-Shortened.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://metadata.ftp-master.debian.org/changelogs//main/a/arpwatch/arpwatch_2.1a15-7_copyright",
		},
		OSIApproved: false,
	},
	"bsd-4-clause-uc": {
		ID:              "BSD-4-Clause-UC",
		Name:            "BSD-4-Clause (University of California-Specific)",
		Reference:       "https://spdx.org/licenses/BSD-4-Clause-UC.html",
		ReferenceNumber: 350,
		DetailsURL:      "https://spdx.org/licenses/BSD-4-Clause-UC.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.freebsd.org/copyright/license.html",
		},
		OSIApproved: false,
	},
	"bsd-4.3reno": {
		ID:              "BSD-4.3RENO",
		Name:            "BSD 4.3 RENO License",
		Reference:       "https://spdx.org/licenses/BSD-4.3RENO.html",
		ReferenceNumber: 558,
		DetailsURL:      "https://spdx.org/licenses/BSD-4.3RENO.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://sourceware.org/git/?p=binutils-gdb.git;a=blob;f=libiberty/strcasecmp.c;h=131d81c2ce7881fa48c363dc5bf5fb302c61ce0b;hb=HEAD",
			"https://git.openldap.org/openldap/openldap/-/blob/master/COPYRIGHT#L55-63",
		},
		OSIApproved: false,
	},
	"bsd-4.3tahoe": {
		ID:              "BSD-4.3TAHOE",
		Name:            "BSD 4.3 TAHOE License",
		Reference:       "https://spdx.org/licenses/BSD-4.3TAHOE.html",
		ReferenceNumber: 372,
		DetailsURL:      "https://spdx.org/licenses/BSD-4.3TAHOE.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/389ds/389-ds-base/blob/main/ldap/include/sysexits-compat.h#L15",
			"https://git.savannah.gnu.org/cgit/indent.git/tree/doc/indent.texi?id=a74c6b4ee49397cf330b333da1042bffa60ed14f#n1788",
		},
		OSIApproved: false,
	},
	"bsd-advertising-acknowledgement": {
		ID:              "BSD-Advertising-Acknowledgement",
		Name:            "BSD Advertising Acknowledgement License",
		Reference:       "https://spdx.org/licenses/BSD-Advertising-Acknowledgement.html",
		ReferenceNumber: 466,
		DetailsURL:      "https://spdx.org/licenses/BSD-Advertising-Acknowledgement.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/python-excel/xlrd/blob/master/LICENSE#L33",
		},
		OSIApproved: false,
	},
	"bsd-attribution-hpnd-disclaimer": {
		ID:              "BSD-Attribution-HPND-disclaimer",
		Name:            "BSD with Attribution and HPND disclaimer",
		Reference:       "https://spdx.org/licenses/BSD-Attribution-HPND-disclaimer.html",
		ReferenceNumber: 434,
		DetailsURL:      "https://spdx.org/licenses/BSD-Attribution-HPND-disclaimer.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/cyrusimap/cyrus-sasl/blob/master/COPYING",
		},
		OSIApproved: false,
	},
	"bsd-inferno-nettverk": {
		ID:              "BSD-Inferno-Nettverk",
		Name:            "BSD-Inferno-Nettverk",
		Reference:       "https://spdx.org/licenses/BSD-Inferno-Nettverk.html",
		ReferenceNumber: 423,
		DetailsURL:      "https://spdx.org/licenses/BSD-Inferno-Nettverk.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.inet.no/dante/LICENSE",
		},
		OSIApproved: false,
	},
	"bsd-protection": {
		ID:              "BSD-Protection",
		Name:            "BSD Protection License",
		Reference:       "https://spdx.org/licenses/BSD-Protection.html",
		ReferenceNumber: 569,
		DetailsURL:      "https://spdx.org/licenses/BSD-Protection.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/BSD_Protection_License",
		},
		OSIApproved: false,
	},
	"bsd-source-code": {
		ID:              "BSD-Source-Code",
		Name:            "BSD Source Code Attribution",
		Reference:       "https://spdx.org/licenses/BSD-Source-Code.html",
		ReferenceNumber: 36,
		DetailsURL:      "https://spdx.org/licenses/BSD-Source-Code.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/robbiehanson/CocoaHTTPServer/blob/master/LICENSE.txt",
		},
		OSIApproved: false,
	},
	"bsd-source-beginning-file": {
		ID:              "BSD-Source-beginning-file",
		Name:            "BSD Source Code Attribution - beginning of file variant",
		Reference:       "https://spdx.org/licenses/BSD-Source-beginning-file.html",
		ReferenceNumber: 486,
		DetailsURL:      "https://spdx.org/licenses/BSD-Source-beginning-file.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/lattera/freebsd/blob/master/sys/cam/cam.c#L4",
		},
		OSIApproved: false,
	},
	"bsd-systemics": {
		ID:              "BSD-Systemics",
		Name:            "Systemics BSD variant license",
		Reference:       "https://spdx.org/licenses/BSD-Systemics.html",
		ReferenceNumber: 260,
		DetailsURL:      "https://spdx.org/licenses/BSD-Systemics.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://metacpan.org/release/DPARIS/Crypt-DES-2.07/source/COPYRIGHT",
		},
		OSIApproved: false,
	},
	"bsd-systemics-w3works": {
		ID:              "BSD-Systemics-W3Works",
		Name:            "Systemics W3Works BSD variant license",
		Reference:       "https://spdx.org/licenses/BSD-Systemics-W3Works.html",
		ReferenceNumber: 398,
		DetailsURL:      "https://spdx.org/licenses/BSD-Systemics-W3Works.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://metacpan.org/release/DPARIS/Crypt-Blowfish-2.14/source/COPYRIGHT#L7",
		},
		OSIApproved: false,
	},
	"bsl-1.0": {
		ID:              "BSL-1.0",
		Name:            "Boost Software License 1.0",
		Reference:       "https://spdx.org/licenses/BSL-1.0.html",
		ReferenceNumber: 600,
		DetailsURL:      "https://spdx.org/licenses/BSL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.boost.org/LICENSE_1_0.txt",
			"https://opensource.org/licenses/BSL-1.0",
		},
		OSIApproved: true,
	},
	"busl-1.1": {
		ID:              "BUSL-1.1",
		Name:            "Business Source License 1.1",
		Reference:       "https://spdx.org/licenses/BUSL-1.1.html",
		ReferenceNumber: 380,
		DetailsURL:      "https://spdx.org/licenses/BUSL-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://mariadb.com/bsl11/",
		},
		OSIApproved: false,
	},
	"baekmuk": {
		ID:              "Baekmuk",
		Name:            "Baekmuk License",
		Reference:       "https://spdx.org/licenses/Baekmuk.html",
		ReferenceNumber: 512,
		DetailsURL:      "https://spdx.org/licenses/Baekmuk.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing:Baekmuk?rd=Licensing/Baekmuk",
		},
		OSIApproved: false,
	},
	"bahyph": {
		ID:              "Bahyph",
		Name:            "Bahyph License",
		Reference:       "https://spdx.org/licenses/Bahyph.html",
		ReferenceNumber: 57,
		DetailsURL:      "https://spdx.org/licenses/Bahyph.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Bahyph",
		},
		OSIApproved: false,
	},
	"barr": {
		ID:              "Barr",
		Name:            "Barr License",
		Reference:       "https://spdx.org/licenses/Barr.html",
		ReferenceNumber: 425,
		DetailsURL:      "https://spdx.org/licenses/Barr.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Barr",
		},
		OSIApproved: false,
	},
	"beerware": {
		ID:              "Beerware",
		Name:            "Beerware License",
		Reference:       "https://spdx.org/licenses/Beerware.html",
		ReferenceNumber: 50,
		DetailsURL:      "https://spdx.org/licenses/Beerware.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Beerware",
			"https://people.freebsd.org/~phk/",
		},
		OSIApproved: false,
	},
	"bittorrent-1.0": {
		ID:              "BitTorrent-1.0",
		Name:            "BitTorrent Open Source License v1.0",
		Reference:       "https://spdx.org/licenses/BitTorrent-1.0.html",
		ReferenceNumber: 602,
		DetailsURL:      "https://spdx.org/licenses/BitTorrent-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://sources.gentoo.org/cgi-bin/viewvc.cgi/gentoo-x86/licenses/BitTorrent?r1=1.1&r2=1.1.1.1&diff_format=s",
		},
		OSIApproved: false,
	},
	"bittorrent-1.1": {
		ID:              "BitTorrent-1.1",
		Name:            "BitTorrent Open Source License v1.1",
		Reference:       "https://spdx.org/licenses/BitTorrent-1.1.html",
		ReferenceNumber: 161,
		DetailsURL:      "https://spdx.org/licenses/BitTorrent-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://directory.fsf.org/wiki/License:BitTorrentOSL1.1",
		},
		OSIApproved: false,
	},
	"bitstream-charter": {
		ID:              "Bitstream-Charter",
		Name:            "Bitstream Charter Font License",
		Reference:       "https://spdx.org/licenses/Bitstream-Charter.html",
		ReferenceNumber: 236,
		DetailsURL:      "https://spdx.org/licenses/Bitstream-Charter.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Charter#License_Text",
			"https://raw.githubusercontent.com/blackhole89/notekit/master/data/fonts/Charter%20license.txt",
		},
		OSIApproved: false,
	},
	"bitstream-vera": {
		ID:              "Bitstream-Vera",
		Name:            "Bitstream Vera Font License",
		Reference:       "https://spdx.org/licenses/Bitstream-Vera.html",
		ReferenceNumber: 421,
		DetailsURL:      "https://spdx.org/licenses/Bitstream-Vera.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://web.archive.org/web/20080207013128/http://www.gnome.org/fonts/",
			"https://docubrain.com/sites/default/files/licenses/bitstream-vera.html",
		},
		OSIApproved: false,
	},
	"blueoak-1.0.0": {
		ID:              "BlueOak-1.0.0",
		Name:            "Blue Oak Model License 1.0.0",
		Reference:       "https://spdx.org/licenses/BlueOak-1.0.0.html",
		ReferenceNumber: 570,
		DetailsURL:      "https://spdx.org/licenses/BlueOak-1.0.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://blueoakcouncil.org/license/1.0.0",
		},
		OSIApproved: true,
	},
	"boehm-gc": {
		ID:              "Boehm-GC",
		Name:            "Boehm-Demers-Weiser GC License",
		Reference:       "https://spdx.org/licenses/Boehm-GC.html",
		ReferenceNumber: 15,
		DetailsURL:      "https://spdx.org/licenses/Boehm-GC.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing:MIT#Another_Minimal_variant_(found_in_libatomic_ops)",
			"https://github.com/uim/libgcroots/blob/master/COPYING",
			"https://github.com/ivmai/libatomic_ops/blob/master/LICENSE",
		},
		OSIApproved: false,
	},
	"borceux": {
		ID:              "Borceux",
		Name:            "Borceux license",
		Reference:       "https://spdx.org/licenses/Borceux.html",
		ReferenceNumber: 113,
		DetailsURL:      "https://spdx.org/licenses/Borceux.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Borceux",
		},
		OSIApproved: false,
	},
	"brian-gladman-2-clause": {
		ID:              "Brian-Gladman-2-Clause",
		Name:            "Brian Gladman 2-Clause License",
		Reference:       "https://spdx.org/licenses/Brian-Gladman-2-Clause.html",
		ReferenceNumber: 316,
		DetailsURL:      "https://spdx.org/licenses/Brian-Gladman-2-Clause.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/krb5/krb5/blob/krb5-1.21.2-final/NOTICE#L140-L156",
			"https://web.mit.edu/kerberos/krb5-1.21/doc/mitK5license.html",
		},
		OSIApproved: false,
	},
	"brian-gladman-3-clause": {
		ID:              "Brian-Gladman-3-Clause",
		Name:            "Brian Gladman 3-Clause License",
		Reference:       "https://spdx.org/licenses/Brian-Gladman-3-Clause.html",
		ReferenceNumber: 444,
		DetailsURL:      "https://spdx.org/licenses/Brian-Gladman-3-Clause.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/SWI-Prolog/packages-clib/blob/master/sha1/brg_endian.h",
		},
		OSIApproved: false,
	},
	"c-uda-1.0": {
		ID:              "C-UDA-1.0",
		Name:            "Computational Use of Data Agreement v1.0",
		Reference:       "https://spdx.org/licenses/C-UDA-1.0.html",
		ReferenceNumber: 551,
		DetailsURL:      "https://spdx.org/licenses/C-UDA-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/microsoft/Computational-Use-of-Data-Agreement/blob/master/C-UDA-1.0.md",
			"https://cdla.dev/computational-use-of-data-agreement-v1-0/",
		},
		OSIApproved: false,
	},
	"cal-1.0": {
		ID:              "CAL-1.0",
		Name:            "Cryptographic Autonomy License 1.0",
		Reference:       "https://spdx.org/licenses/CAL-1.0.html",
		ReferenceNumber: 630,
		DetailsURL:      "https://spdx.org/licenses/CAL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://cryptographicautonomylicense.com/license-text.html",
			"https://opensource.org/licenses/CAL-1.0",
		},
		OSIApproved: true,
	},
	"cal-1.0-combined-work-exception": {
		ID:              "CAL-1.0-Combined-Work-Exception",
		Name:            "Cryptographic Autonomy License 1.0 (Combined Work Exception)",
		Reference:       "https://spdx.org/licenses/CAL-1.0-Combined-Work-Exception.html",
		ReferenceNumber: 158,
		DetailsURL:      "https://spdx.org/licenses/CAL-1.0-Combined-Work-Exception.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://cryptographicautonomylicense.com/license-text.html",
			"https://opensource.org/licenses/CAL-1.0",
		},
		OSIApproved: true,
	},
	"catosl-1.1": {
		ID:              "CATOSL-1.1",
		Name:            "Computer Associates Trusted Open Source License 1.1",
		Reference:       "https://spdx.org/licenses/CATOSL-1.1.html",
		ReferenceNumber: 319,
		DetailsURL:      "https://spdx.org/licenses/CATOSL-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/CATOSL-1.1",
		},
		OSIApproved: true,
	},
	"cc-by-1.0": {
		ID:              "CC-BY-1.0",
		Name:            "Creative Commons Attribution 1.0 Generic",
		Reference:       "https://spdx.org/licenses/CC-BY-1.0.html",
		ReferenceNumber: 384,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by/1.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-2.0": {
		ID:              "CC-BY-2.0",
		Name:            "Creative Commons Attribution 2.0 Generic",
		Reference:       "https://spdx.org/licenses/CC-BY-2.0.html",
		ReferenceNumber: 69,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by/2.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-2.5": {
		ID:              "CC-BY-2.5",
		Name:            "Creative Commons Attribution 2.5 Generic",
		Reference:       "https://spdx.org/licenses/CC-BY-2.5.html",
		ReferenceNumber: 482,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-2.5.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by/2.5/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-2.5-au": {
		ID:              "CC-BY-2.5-AU",
		Name:            "Creative Commons Attribution 2.5 Australia",
		Reference:       "https://spdx.org/licenses/CC-BY-2.5-AU.html",
		ReferenceNumber: 348,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-2.5-AU.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by/2.5/au/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-3.0": {
		ID:              "CC-BY-3.0",
		Name:            "Creative Commons Attribution 3.0 Unported",
		Reference:       "https://spdx.org/licenses/CC-BY-3.0.html",
		ReferenceNumber: 562,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-3.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by/3.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-3.0-at": {
		ID:              "CC-BY-3.0-AT",
		Name:            "Creative Commons Attribution 3.0 Austria",
		Reference:       "https://spdx.org/licenses/CC-BY-3.0-AT.html",
		ReferenceNumber: 314,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-3.0-AT.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by/3.0/at/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-3.0-au": {
		ID:              "CC-BY-3.0-AU",
		Name:            "Creative Commons Attribution 3.0 Australia",
		Reference:       "https://spdx.org/licenses/CC-BY-3.0-AU.html",
		ReferenceNumber: 235,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-3.0-AU.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by/3.0/au/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-3.0-de": {
		ID:              "CC-BY-3.0-DE",
		Name:            "Creative Commons Attribution 3.0 Germany",
		Reference:       "https://spdx.org/licenses/CC-BY-3.0-DE.html",
		ReferenceNumber: 110,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-3.0-DE.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by/3.0/de/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-3.0-igo": {
		ID:              "CC-BY-3.0-IGO",
		Name:            "Creative Commons Attribution 3.0 IGO",
		Reference:       "https://spdx.org/licenses/CC-BY-3.0-IGO.html",
		ReferenceNumber: 359,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-3.0-IGO.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by/3.0/igo/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-3.0-nl": {
		ID:              "CC-BY-3.0-NL",
		Name:            "Creative Commons Attribution 3.0 Netherlands",
		Reference:       "https://spdx.org/licenses/CC-BY-3.0-NL.html",
		ReferenceNumber: 130,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-3.0-NL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by/3.0/nl/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-3.0-us": {
		ID:              "CC-BY-3.0-US",
		Name:            "Creative Commons Attribution 3.0 United States",
		Reference:       "https://spdx.org/licenses/CC-BY-3.0-US.html",
		ReferenceNumber: 38,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-3.0-US.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by/3.0/us/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-4.0": {
		ID:              "CC-BY-4.0",
		Name:            "Creative Commons Attribution 4.0 International",
		Reference:       "https://spdx.org/licenses/CC-BY-4.0.html",
		ReferenceNumber: 122,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-4.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by/4.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-1.0": {
		ID:              "CC-BY-NC-1.0",
		Name:            "Creative Commons Attribution Non Commercial 1.0 Generic",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-1.0.html",
		ReferenceNumber: 29,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc/1.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-2.0": {
		ID:              "CC-BY-NC-2.0",
		Name:            "Creative Commons Attribution Non Commercial 2.0 Generic",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-2.0.html",
		ReferenceNumber: 588,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc/2.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-2.5": {
		ID:              "CC-BY-NC-2.5",
		Name:            "Creative Commons Attribution Non Commercial 2.5 Generic",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-2.5.html",
		ReferenceNumber: 400,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-2.5.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc/2.5/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-3.0": {
		ID:              "CC-BY-NC-3.0",
		Name:            "Creative Commons Attribution Non Commercial 3.0 Unported",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-3.0.html",
		ReferenceNumber: 104,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-3.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc/3.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-3.0-de": {
		ID:              "CC-BY-NC-3.0-DE",
		Name:            "Creative Commons Attribution Non Commercial 3.0 Germany",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-3.0-DE.html",
		ReferenceNumber: 351,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-3.0-DE.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc/3.0/de/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-4.0": {
		ID:              "CC-BY-NC-4.0",
		Name:            "Creative Commons Attribution Non Commercial 4.0 International",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-4.0.html",
		ReferenceNumber: 353,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-4.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc/4.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-nd-1.0": {
		ID:              "CC-BY-NC-ND-1.0",
		Name:            "Creative Commons Attribution Non Commercial No Derivatives 1.0 Generic",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-ND-1.0.html",
		ReferenceNumber: 454,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-ND-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nd-nc/1.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-nd-2.0": {
		ID:              "CC-BY-NC-ND-2.0",
		Name:            "Creative Commons Attribution Non Commercial No Derivatives 2.0 Generic",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-ND-2.0.html",
		ReferenceNumber: 53,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-ND-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc-nd/2.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-nd-2.5": {
		ID:              "CC-BY-NC-ND-2.5",
		Name:            "Creative Commons Attribution Non Commercial No Derivatives 2.5 Generic",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-ND-2.5.html",
		ReferenceNumber: 328,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-ND-2.5.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc-nd/2.5/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-nd-3.0": {
		ID:              "CC-BY-NC-ND-3.0",
		Name:            "Creative Commons Attribution Non Commercial No Derivatives 3.0 Unported",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-ND-3.0.html",
		ReferenceNumber: 70,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-ND-3.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc-nd/3.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-nd-3.0-de": {
		ID:              "CC-BY-NC-ND-3.0-DE",
		Name:            "Creative Commons Attribution Non Commercial No Derivatives 3.0 Germany",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-ND-3.0-DE.html",
		ReferenceNumber: 47,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-ND-3.0-DE.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc-nd/3.0/de/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-nd-3.0-igo": {
		ID:              "CC-BY-NC-ND-3.0-IGO",
		Name:            "Creative Commons Attribution Non Commercial No Derivatives 3.0 IGO",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-ND-3.0-IGO.html",
		ReferenceNumber: 213,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-ND-3.0-IGO.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc-nd/3.0/igo/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-nd-4.0": {
		ID:              "CC-BY-NC-ND-4.0",
		Name:            "Creative Commons Attribution Non Commercial No Derivatives 4.0 International",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-ND-4.0.html",
		ReferenceNumber: 550,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-ND-4.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc-nd/4.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-sa-1.0": {
		ID:              "CC-BY-NC-SA-1.0",
		Name:            "Creative Commons Attribution Non Commercial Share Alike 1.0 Generic",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-SA-1.0.html",
		ReferenceNumber: 99,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-SA-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc-sa/1.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-sa-2.0": {
		ID:              "CC-BY-NC-SA-2.0",
		Name:            "Creative Commons Attribution Non Commercial Share Alike 2.0 Generic",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-SA-2.0.html",
		ReferenceNumber: 491,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-SA-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc-sa/2.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-sa-2.0-de": {
		ID:              "CC-BY-NC-SA-2.0-DE",
		Name:            "Creative Commons Attribution Non Commercial Share Alike 2.0 Germany",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-SA-2.0-DE.html",
		ReferenceNumber: 246,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-SA-2.0-DE.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc-sa/2.0/de/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-sa-2.0-fr": {
		ID:              "CC-BY-NC-SA-2.0-FR",
		Name:            "Creative Commons Attribution-NonCommercial-ShareAlike 2.0 France",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-SA-2.0-FR.html",
		ReferenceNumber: 368,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-SA-2.0-FR.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc-sa/2.0/fr/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-sa-2.0-uk": {
		ID:              "CC-BY-NC-SA-2.0-UK",
		Name:            "Creative Commons Attribution Non Commercial Share Alike 2.0 England and Wales",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-SA-2.0-UK.html",
		ReferenceNumber: 451,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-SA-2.0-UK.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc-sa/2.0/uk/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-sa-2.5": {
		ID:              "CC-BY-NC-SA-2.5",
		Name:            "Creative Commons Attribution Non Commercial Share Alike 2.5 Generic",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-SA-2.5.html",
		ReferenceNumber: 352,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-SA-2.5.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc-sa/2.5/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-sa-3.0": {
		ID:              "CC-BY-NC-SA-3.0",
		Name:            "Creative Commons Attribution Non Commercial Share Alike 3.0 Unported",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-SA-3.0.html",
		ReferenceNumber: 41,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-SA-3.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc-sa/3.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-sa-3.0-de": {
		ID:              "CC-BY-NC-SA-3.0-DE",
		Name:            "Creative Commons Attribution Non Commercial Share Alike 3.0 Germany",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-SA-3.0-DE.html",
		ReferenceNumber: 582,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-SA-3.0-DE.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc-sa/3.0/de/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-sa-3.0-igo": {
		ID:              "CC-BY-NC-SA-3.0-IGO",
		Name:            "Creative Commons Attribution Non Commercial Share Alike 3.0 IGO",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-SA-3.0-IGO.html",
		ReferenceNumber: 205,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-SA-3.0-IGO.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc-sa/3.0/igo/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nc-sa-4.0": {
		ID:              "CC-BY-NC-SA-4.0",
		Name:            "Creative Commons Attribution Non Commercial Share Alike 4.0 International",
		Reference:       "https://spdx.org/licenses/CC-BY-NC-SA-4.0.html",
		ReferenceNumber: 610,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-NC-SA-4.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nd-1.0": {
		ID:              "CC-BY-ND-1.0",
		Name:            "Creative Commons Attribution No Derivatives 1.0 Generic",
		Reference:       "https://spdx.org/licenses/CC-BY-ND-1.0.html",
		ReferenceNumber: 18,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-ND-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nd/1.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nd-2.0": {
		ID:              "CC-BY-ND-2.0",
		Name:            "Creative Commons Attribution No Derivatives 2.0 Generic",
		Reference:       "https://spdx.org/licenses/CC-BY-ND-2.0.html",
		ReferenceNumber: 614,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-ND-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nd/2.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nd-2.5": {
		ID:              "CC-BY-ND-2.5",
		Name:            "Creative Commons Attribution No Derivatives 2.5 Generic",
		Reference:       "https://spdx.org/licenses/CC-BY-ND-2.5.html",
		ReferenceNumber: 540,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-ND-2.5.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nd/2.5/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nd-3.0": {
		ID:              "CC-BY-ND-3.0",
		Name:            "Creative Commons Attribution No Derivatives 3.0 Unported",
		Reference:       "https://spdx.org/licenses/CC-BY-ND-3.0.html",
		ReferenceNumber: 544,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-ND-3.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nd/3.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nd-3.0-de": {
		ID:              "CC-BY-ND-3.0-DE",
		Name:            "Creative Commons Attribution No Derivatives 3.0 Germany",
		Reference:       "https://spdx.org/licenses/CC-BY-ND-3.0-DE.html",
		ReferenceNumber: 355,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-ND-3.0-DE.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nd/3.0/de/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-nd-4.0": {
		ID:              "CC-BY-ND-4.0",
		Name:            "Creative Commons Attribution No Derivatives 4.0 International",
		Reference:       "https://spdx.org/licenses/CC-BY-ND-4.0.html",
		ReferenceNumber: 545,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-ND-4.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-nd/4.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-sa-1.0": {
		ID:              "CC-BY-SA-1.0",
		Name:            "Creative Commons Attribution Share Alike 1.0 Generic",
		Reference:       "https://spdx.org/licenses/CC-BY-SA-1.0.html",
		ReferenceNumber: 242,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-SA-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-sa/1.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-sa-2.0": {
		ID:              "CC-BY-SA-2.0",
		Name:            "Creative Commons Attribution Share Alike 2.0 Generic",
		Reference:       "https://spdx.org/licenses/CC-BY-SA-2.0.html",
		ReferenceNumber: 349,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-SA-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-sa/2.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-sa-2.0-uk": {
		ID:              "CC-BY-SA-2.0-UK",
		Name:            "Creative Commons Attribution Share Alike 2.0 England and Wales",
		Reference:       "https://spdx.org/licenses/CC-BY-SA-2.0-UK.html",
		ReferenceNumber: 197,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-SA-2.0-UK.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-sa/2.0/uk/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-sa-2.1-jp": {
		ID:              "CC-BY-SA-2.1-JP",
		Name:            "Creative Commons Attribution Share Alike 2.1 Japan",
		Reference:       "https://spdx.org/licenses/CC-BY-SA-2.1-JP.html",
		ReferenceNumber: 162,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-SA-2.1-JP.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-sa/2.1/jp/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-sa-2.5": {
		ID:              "CC-BY-SA-2.5",
		Name:            "Creative Commons Attribution Share Alike 2.5 Generic",
		Reference:       "https://spdx.org/licenses/CC-BY-SA-2.5.html",
		ReferenceNumber: 626,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-SA-2.5.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-sa/2.5/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-sa-3.0": {
		ID:              "CC-BY-SA-3.0",
		Name:            "Creative Commons Attribution Share Alike 3.0 Unported",
		Reference:       "https://spdx.org/licenses/CC-BY-SA-3.0.html",
		ReferenceNumber: 244,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-SA-3.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-sa/3.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-sa-3.0-at": {
		ID:              "CC-BY-SA-3.0-AT",
		Name:            "Creative Commons Attribution Share Alike 3.0 Austria",
		Reference:       "https://spdx.org/licenses/CC-BY-SA-3.0-AT.html",
		ReferenceNumber: 292,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-SA-3.0-AT.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-sa/3.0/at/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-sa-3.0-de": {
		ID:              "CC-BY-SA-3.0-DE",
		Name:            "Creative Commons Attribution Share Alike 3.0 Germany",
		Reference:       "https://spdx.org/licenses/CC-BY-SA-3.0-DE.html",
		ReferenceNumber: 317,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-SA-3.0-DE.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-sa/3.0/de/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-sa-3.0-igo": {
		ID:              "CC-BY-SA-3.0-IGO",
		Name:            "Creative Commons Attribution-ShareAlike 3.0 IGO",
		Reference:       "https://spdx.org/licenses/CC-BY-SA-3.0-IGO.html",
		ReferenceNumber: 139,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-SA-3.0-IGO.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-sa/3.0/igo/legalcode",
		},
		OSIApproved: false,
	},
	"cc-by-sa-4.0": {
		ID:              "CC-BY-SA-4.0",
		Name:            "Creative Commons Attribution Share Alike 4.0 International",
		Reference:       "https://spdx.org/licenses/CC-BY-SA-4.0.html",
		ReferenceNumber: 438,
		DetailsURL:      "https://spdx.org/licenses/CC-BY-SA-4.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/by-sa/4.0/legalcode",
		},
		OSIApproved: false,
	},
	"cc-pddc": {
		ID:              "CC-PDDC",
		Name:            "Creative Commons Public Domain Dedication and Certification",
		Reference:       "https://spdx.org/licenses/CC-PDDC.html",
		ReferenceNumber: 291,
		DetailsURL:      "https://spdx.org/licenses/CC-PDDC.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/licenses/publicdomain/",
		},
		OSIApproved: false,
	},
	"cc0-1.0": {
		ID:              "CC0-1.0",
		Name:            "Creative Commons Zero v1.0 Universal",
		Reference:       "https://spdx.org/licenses/CC0-1.0.html",
		ReferenceNumber: 285,
		DetailsURL:      "https://spdx.org/licenses/CC0-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://creativecommons.org/publicdomain/zero/1.0/legalcode",
		},
		OSIApproved: false,
	},
	"cddl-1.0": {
		ID:              "CDDL-1.0",
		Name:            "Common Development and Distribution License 1.0",
		Reference:       "https://spdx.org/licenses/CDDL-1.0.html",
		ReferenceNumber: 154,
		DetailsURL:      "https://spdx.org/licenses/CDDL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/cddl1",
		},
		OSIApproved: true,
	},
	"cddl-1.1": {
		ID:              "CDDL-1.1",
		Name:            "Common Development and Distribution License 1.1",
		Reference:       "https://spdx.org/licenses/CDDL-1.1.html",
		ReferenceNumber: 529,
		DetailsURL:      "https://spdx.org/licenses/CDDL-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://glassfish.java.net/public/CDDL+GPL_1_1.html",
			"https://javaee.github.io/glassfish/LICENSE",
		},
		OSIApproved: false,
	},
	"cdl-1.0": {
		ID:              "CDL-1.0",
		Name:            "Common Documentation License 1.0",
		Reference:       "https://spdx.org/licenses/CDL-1.0.html",
		ReferenceNumber: 243,
		DetailsURL:      "https://spdx.org/licenses/CDL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.opensource.apple.com/cdl/",
			"https://fedoraproject.org/wiki/Licensing/Common_Documentation_License",
			"https://www.gnu.org/licenses/license-list.html#ACDL",
		},
		OSIApproved: false,
	},
	"cdla-permissive-1.0": {
		ID:              "CDLA-Permissive-1.0",
		Name:            "Community Data License Agreement Permissive 1.0",
		Reference:       "https://spdx.org/licenses/CDLA-Permissive-1.0.html",
		ReferenceNumber: 477,
		DetailsURL:      "https://spdx.org/licenses/CDLA-Permissive-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://cdla.io/permissive-1-0",
		},
		OSIApproved: false,
	},
	"cdla-permissive-2.0": {
		ID:              "CDLA-Permissive-2.0",
		Name:            "Community Data License Agreement Permissive 2.0",
		Reference:       "https://spdx.org/licenses/CDLA-Permissive-2.0.html",
		ReferenceNumber: 335,
		DetailsURL:      "https://spdx.org/licenses/CDLA-Permissive-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://cdla.dev/permissive-2-0",
		},
		OSIApproved: false,
	},
	"cdla-sharing-1.0": {
		ID:              "CDLA-Sharing-1.0",
		Name:            "Community Data License Agreement Sharing 1.0",
		Reference:       "https://spdx.org/licenses/CDLA-Sharing-1.0.html",
		ReferenceNumber: 548,
		DetailsURL:      "https://spdx.org/licenses/CDLA-Sharing-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://cdla.io/sharing-1-0",
		},
		OSIApproved: false,
	},
	"cecill-1.0": {
		ID:              "CECILL-1.0",
		Name:            "CeCILL Free Software License Agreement v1.0",
		Reference:       "https://spdx.org/licenses/CECILL-1.0.html",
		ReferenceNumber: 60,
		DetailsURL:      "https://spdx.org/licenses/CECILL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.cecill.info/licences/Licence_CeCILL_V1-fr.html",
		},
		OSIApproved: false,
	},
	"cecill-1.1": {
		ID:              "CECILL-1.1",
		Name:            "CeCILL Free Software License Agreement v1.1",
		Reference:       "https://spdx.org/licenses/CECILL-1.1.html",
		ReferenceNumber: 344,
		DetailsURL:      "https://spdx.org/licenses/CECILL-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.cecill.info/licences/Licence_CeCILL_V1.1-US.html",
		},
		OSIApproved: false,
	},
	"cecill-2.0": {
		ID:              "CECILL-2.0",
		Name:            "CeCILL Free Software License Agreement v2.0",
		Reference:       "https://spdx.org/licenses/CECILL-2.0.html",
		ReferenceNumber: 410,
		DetailsURL:      "https://spdx.org/licenses/CECILL-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.cecill.info/licences/Licence_CeCILL_V2-en.html",
		},
		OSIApproved: false,
	},
	"cecill-2.1": {
		ID:              "CECILL-2.1",
		Name:            "CeCILL Free Software License Agreement v2.1",
		Reference:       "https://spdx.org/licenses/CECILL-2.1.html",
		ReferenceNumber: 174,
		DetailsURL:      "https://spdx.org/licenses/CECILL-2.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.cecill.info/licences/Licence_CeCILL_V2.1-en.html",
		},
		OSIApproved: true,
	},
	"cecill-b": {
		ID:              "CECILL-B",
		Name:            "CeCILL-B Free Software License Agreement",
		Reference:       "https://spdx.org/licenses/CECILL-B.html",
		ReferenceNumber: 256,
		DetailsURL:      "https://spdx.org/licenses/CECILL-B.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html",
		},
		OSIApproved: false,
	},
	"cecill-c": {
		ID:              "CECILL-C",
		Name:            "CeCILL-C Free Software License Agreement",
		Reference:       "https://spdx.org/licenses/CECILL-C.html",
		ReferenceNumber: 52,
		DetailsURL:      "https://spdx.org/licenses/CECILL-C.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html",
		},
		OSIApproved: false,
	},
	"cern-ohl-1.1": {
		ID:              "CERN-OHL-1.1",
		Name:            "CERN Open Hardware Licence v1.1",
		Reference:       "https://spdx.org/licenses/CERN-OHL-1.1.html",
		ReferenceNumber: 615,
		DetailsURL:      "https://spdx.org/licenses/CERN-OHL-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.ohwr.org/project/licenses/wikis/cern-ohl-v1.1",
		},
		OSIApproved: false,
	},
	"cern-ohl-1.2": {
		ID:              "CERN-OHL-1.2",
		Name:            "CERN Open Hardware Licence v1.2",
		Reference:       "https://spdx.org/licenses/CERN-OHL-1.2.html",
		ReferenceNumber: 324,
		DetailsURL:      "https://spdx.org/licenses/CERN-OHL-1.2.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.ohwr.org/project/licenses/wikis/cern-ohl-v1.2",
		},
		OSIApproved: false,
	},
	"cern-ohl-p-2.0": {
		ID:              "CERN-OHL-P-2.0",
		Name:            "CERN Open Hardware Licence Version 2 - Permissive",
		Reference:       "https://spdx.org/licenses/CERN-OHL-P-2.0.html",
		ReferenceNumber: 402,
		DetailsURL:      "https://spdx.org/licenses/CERN-OHL-P-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.ohwr.org/project/cernohl/wikis/Documents/CERN-OHL-version-2",
		},
		OSIApproved: true,
	},
	"cern-ohl-s-2.0": {
		ID:              "CERN-OHL-S-2.0",
		Name:            "CERN Open Hardware Licence Version 2 - Strongly Reciprocal",
		Reference:       "https://spdx.org/licenses/CERN-OHL-S-2.0.html",
		ReferenceNumber: 513,
		DetailsURL:      "https://spdx.org/licenses/CERN-OHL-S-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.ohwr.org/project/cernohl/wikis/Documents/CERN-OHL-version-2",
		},
		OSIApproved: true,
	},
	"cern-ohl-w-2.0": {
		ID:              "CERN-OHL-W-2.0",
		Name:            "CERN Open Hardware Licence Version 2 - Weakly Reciprocal",
		Reference:       "https://spdx.org/licenses/CERN-OHL-W-2.0.html",
		ReferenceNumber: 237,
		DetailsURL:      "https://spdx.org/licenses/CERN-OHL-W-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.ohwr.org/project/cernohl/wikis/Documents/CERN-OHL-version-2",
		},
		OSIApproved: true,
	},
	"cfitsio": {
		ID:              "CFITSIO",
		Name:            "CFITSIO License",
		Reference:       "https://spdx.org/licenses/CFITSIO.html",
		ReferenceNumber: 151,
		DetailsURL:      "https://spdx.org/licenses/CFITSIO.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://heasarc.gsfc.nasa.gov/docs/software/fitsio/c/f_user/node9.html",
			"https://heasarc.gsfc.nasa.gov/docs/software/ftools/fv/doc/license.html",
		},
		OSIApproved: false,
	},
	"cmu-mach": {
		ID:              "CMU-Mach",
		Name:            "CMU Mach License",
		Reference:       "https://spdx.org/licenses/CMU-Mach.html",
		ReferenceNumber: 492,
		DetailsURL:      "https://spdx.org/licenses/CMU-Mach.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.cs.cmu.edu/~410/licenses.html",
		},
		OSIApproved: false,
	},
	"cmu-mach-nodoc": {
		ID:              "CMU-Mach-nodoc",
		Name:            "CMU    Mach - no notices-in-documentation variant",
		Reference:       "https://spdx.org/licenses/CMU-Mach-nodoc.html",
		ReferenceNumber: 318,
		DetailsURL:      "https://spdx.org/licenses/CMU-Mach-nodoc.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/krb5/krb5/blob/krb5-1.21.2-final/NOTICE#L718-L728",
			"https://web.mit.edu/kerberos/krb5-1.21/doc/mitK5license.html",
		},
		OSIApproved: false,
	},
	"cnri-jython": {
		ID:              "CNRI-Jython",
		Name:            "CNRI Jython License",
		Reference:       "https://spdx.org/licenses/CNRI-Jython.html",
		ReferenceNumber: 203,
		DetailsURL:      "https://spdx.org/licenses/CNRI-Jython.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.jython.org/license.html",
		},
		OSIApproved: false,
	},
	"cnri-python": {
		ID:              "CNRI-Python",
		Name:            "CNRI Python License",
		Reference:       "https://spdx.org/licenses/CNRI-Python.html",
		ReferenceNumber: 218,
		DetailsURL:      "https://spdx.org/licenses/CNRI-Python.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/CNRI-Python",
		},
		OSIApproved: true,
	},
	"cnri-python-gpl-compatible": {
		ID:              "CNRI-Python-GPL-Compatible",
		Name:            "CNRI Python Open Source GPL Compatible License Agreement",
		Reference:       "https://spdx.org/licenses/CNRI-Python-GPL-Compatible.html",
		ReferenceNumber: 391,
		DetailsURL:      "https://spdx.org/licenses/CNRI-Python-GPL-Compatible.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.python.org/download/releases/1.6.1/download_win/",
		},
		OSIApproved: false,
	},
	"coil-1.0": {
		ID:              "COIL-1.0",
		Name:            "Copyfree Open Innovation License",
		Reference:       "https://spdx.org/licenses/COIL-1.0.html",
		ReferenceNumber: 375,
		DetailsURL:      "https://spdx.org/licenses/COIL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://coil.apotheon.org/plaintext/01.0.txt",
		},
		OSIApproved: false,
	},
	"cpal-1.0": {
		ID:              "CPAL-1.0",
		Name:            "Common Public Attribution License 1.0",
		Reference:       "https://spdx.org/licenses/CPAL-1.0.html",
		ReferenceNumber: 223,
		DetailsURL:      "https://spdx.org/licenses/CPAL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/CPAL-1.0",
		},
		OSIApproved: true,
	},
	"cpl-1.0": {
		ID:              "CPL-1.0",
		Name:            "Common Public License 1.0",
		Reference:       "https://spdx.org/licenses/CPL-1.0.html",
		ReferenceNumber: 181,
		DetailsURL:      "https://spdx.org/licenses/CPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/CPL-1.0",
		},
		OSIApproved: true,
	},
	"cpol-1.02": {
		ID:              "CPOL-1.02",
		Name:            "Code Project Open License 1.02",
		Reference:       "https://spdx.org/licenses/CPOL-1.02.html",
		ReferenceNumber: 176,
		DetailsURL:      "https://spdx.org/licenses/CPOL-1.02.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.codeproject.com/info/cpol10.aspx",
		},
		OSIApproved: false,
	},
	"cua-opl-1.0": {
		ID:              "CUA-OPL-1.0",
		Name:            "CUA Office Public License v1.0",
		Reference:       "https://spdx.org/licenses/CUA-OPL-1.0.html",
		ReferenceNumber: 313,
		DetailsURL:      "https://spdx.org/licenses/CUA-OPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/CUA-OPL-1.0",
		},
		OSIApproved: true,
	},
	"caldera": {
		ID:              "Caldera",
		Name:            "Caldera License",
		Reference:       "https://spdx.org/licenses/Caldera.html",
		ReferenceNumber: 282,
		DetailsURL:      "https://spdx.org/licenses/Caldera.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.lemis.com/grog/UNIX/ancient-source-all.pdf",
		},
		OSIApproved: false,
	},
	"caldera-no-preamble": {
		ID:              "Caldera-no-preamble",
		Name:            "Caldera License (without preamble)",
		Reference:       "https://spdx.org/licenses/Caldera-no-preamble.html",
		ReferenceNumber: 262,
		DetailsURL:      "https://spdx.org/licenses/Caldera-no-preamble.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/apache/apr/blob/trunk/LICENSE#L298C6-L298C29",
		},
		OSIApproved: false,
	},
	"clartistic": {
		ID:              "ClArtistic",
		Name:            "Clarified Artistic License",
		Reference:       "https://spdx.org/licenses/ClArtistic.html",
		ReferenceNumber: 441,
		DetailsURL:      "https://spdx.org/licenses/ClArtistic.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://gianluca.dellavedova.org/2011/01/03/clarified-artistic-license/",
			"http://www.ncftp.com/ncftp/doc/LICENSE.txt",
		},
		OSIApproved: false,
	},
	"clips": {
		ID:              "Clips",
		Name:            "Clips License",
		Reference:       "https://spdx.org/licenses/Clips.html",
		ReferenceNumber: 167,
		DetailsURL:      "https://spdx.org/licenses/Clips.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/DrItanium/maya/blob/master/LICENSE.CLIPS",
		},
		OSIApproved: false,
	},
	"community-spec-1.0": {
		ID:              "Community-Spec-1.0",
		Name:            "Community Specification License 1.0",
		Reference:       "https://spdx.org/licenses/Community-Spec-1.0.html",
		ReferenceNumber: 357,
		DetailsURL:      "https://spdx.org/licenses/Community-Spec-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/CommunitySpecification/1.0/blob/master/1._Community_Specification_License-v1.md",
		},
		OSIApproved: false,
	},
	"condor-1.1": {
		ID:              "Condor-1.1",
		Name:            "Condor Public License v1.1",
		Reference:       "https://spdx.org/licenses/Condor-1.1.html",
		ReferenceNumber: 385,
		DetailsURL:      "https://spdx.org/licenses/Condor-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://research.cs.wisc.edu/condor/license.html#condor",
			"http://web.archive.org/web/20111123062036/http://research.cs.wisc.edu/condor/license.html#condor",
		},
		OSIApproved: false,
	},
	"cornell-lossless-jpeg": {
		ID:              "Cornell-Lossless-JPEG",
		Name:            "Cornell Lossless JPEG License",
		Reference:       "https://spdx.org/licenses/Cornell-Lossless-JPEG.html",
		ReferenceNumber: 542,
		DetailsURL:      "https://spdx.org/licenses/Cornell-Lossless-JPEG.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://android.googlesource.com/platform/external/dng_sdk/+/refs/heads/master/source/dng_lossless_jpeg.cpp#16",
			"https://www.mssl.ucl.ac.uk/~mcrw/src/20050920/proto.h",
			"https://gitlab.freedesktop.org/libopenraw/libopenraw/blob/master/lib/ljpegdecompressor.cpp#L32",
		},
		OSIApproved: false,
	},
	"cronyx": {
		ID:              "Cronyx",
		Name:            "Cronyx License",
		Reference:       "https://spdx.org/licenses/Cronyx.html",
		ReferenceNumber: 303,
		DetailsURL:      "https://spdx.org/licenses/Cronyx.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://gitlab.freedesktop.org/xorg/font/alias/-/blob/master/COPYING",
			"https://gitlab.freedesktop.org/xorg/font/cronyx-cyrillic/-/blob/master/COPYING",
			"https://gitlab.freedesktop.org/xorg/font/misc-cyrillic/-/blob/master/COPYING",
			"https://gitlab.freedesktop.org/xorg/font/screen-cyrillic/-/blob/master/COPYING",
		},
		OSIApproved: false,
	},
	"crossword": {
		ID:              "Crossword",
		Name:            "Crossword License",
		Reference:       "https://spdx.org/licenses/Crossword.html",
		ReferenceNumber: 304,
		DetailsURL:      "https://spdx.org/licenses/Crossword.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Crossword",
		},
		OSIApproved: false,
	},
	"crystalstacker": {
		ID:              "CrystalStacker",
		Name:            "CrystalStacker License",
		Reference:       "https://spdx.org/licenses/CrystalStacker.html",
		ReferenceNumber: 522,
		DetailsURL:      "https://spdx.org/licenses/CrystalStacker.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing:CrystalStacker?rd=Licensing/CrystalStacker",
		},
		OSIApproved: false,
	},
	"cube": {
		ID:              "Cube",
		Name:            "Cube License",
		Reference:       "https://spdx.org/licenses/Cube.html",
		ReferenceNumber: 126,
		DetailsURL:      "https://spdx.org/licenses/Cube.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Cube",
		},
		OSIApproved: false,
	},
	"d-fsl-1.0": {
		ID:              "D-FSL-1.0",
		Name:            "Deutsche Freie Software Lizenz",
		Reference:       "https://spdx.org/licenses/D-FSL-1.0.html",
		ReferenceNumber: 31,
		DetailsURL:      "https://spdx.org/licenses/D-FSL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.dipp.nrw.de/d-fsl/lizenzen/",
			"http://www.dipp.nrw.de/d-fsl/index_html/lizenzen/de/D-FSL-1_0_de.txt",
			"http://www.dipp.nrw.de/d-fsl/index_html/lizenzen/en/D-FSL-1_0_en.txt",
			"https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl",
			"https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/deutsche-freie-software-lizenz",
			"https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/german-free-software-license",
			"https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/D-FSL-1_0_de.txt/at_download/file",
			"https://www.hbz-nrw.de/produkte/open-access/lizenzen/dfsl/D-FSL-1_0_en.txt/at_download/file",
		},
		OSIApproved: false,
	},
	"dec-3-clause": {
		ID:              "DEC-3-Clause",
		Name:            "DEC 3-Clause License",
		Reference:       "https://spdx.org/licenses/DEC-3-Clause.html",
		ReferenceNumber: 620,
		DetailsURL:      "https://spdx.org/licenses/DEC-3-Clause.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://gitlab.freedesktop.org/xorg/xserver/-/blob/master/COPYING?ref_type=heads#L239",
		},
		OSIApproved: false,
	},
	"dl-de-by-2.0": {
		ID:              "DL-DE-BY-2.0",
		Name:            "Data licence Germany – attribution – version 2.0",
		Reference:       "https://spdx.org/licenses/DL-DE-BY-2.0.html",
		ReferenceNumber: 363,
		DetailsURL:      "https://spdx.org/licenses/DL-DE-BY-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.govdata.de/dl-de/by-2-0",
		},
		OSIApproved: false,
	},
	"dl-de-zero-2.0": {
		ID:              "DL-DE-ZERO-2.0",
		Name:            "Data licence Germany – zero – version 2.0",
		Reference:       "https://spdx.org/licenses/DL-DE-ZERO-2.0.html",
		ReferenceNumber: 497,
		DetailsURL:      "https://spdx.org/licenses/DL-DE-ZERO-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.govdata.de/dl-de/zero-2-0",
		},
		OSIApproved: false,
	},
	"doc": {
		ID:              "DOC",
		Name:            "DOC License",
		Reference:       "https://spdx.org/licenses/DOC.html",
		ReferenceNumber: 82,
		DetailsURL:      "https://spdx.org/licenses/DOC.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.cs.wustl.edu/~schmidt/ACE-copying.html",
			"https://www.dre.vanderbilt.edu/~schmidt/ACE-copying.html",
		},
		OSIApproved: false,
	},
	"drl-1.0": {
		ID:              "DRL-1.0",
		Name:            "Detection Rule License 1.0",
		Reference:       "https://spdx.org/licenses/DRL-1.0.html",
		ReferenceNumber: 623,
		DetailsURL:      "https://spdx.org/licenses/DRL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/Neo23x0/sigma/blob/master/LICENSE.Detection.Rules.md",
		},
		OSIApproved: false,
	},
	"drl-1.1": {
		ID:              "DRL-1.1",
		Name:            "Detection Rule License 1.1",
		Reference:       "https://spdx.org/licenses/DRL-1.1.html",
		ReferenceNumber: 259,
		DetailsURL:      "https://spdx.org/licenses/DRL-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/SigmaHQ/Detection-Rule-License/blob/6ec7fbde6101d101b5b5d1fcb8f9b69fbc76c04a/LICENSE.Detection.Rules.md",
		},
		OSIApproved: false,
	},
	"dsdp": {
		ID:              "DSDP",
		Name:            "DSDP License",
		Reference:       "https://spdx.org/licenses/DSDP.html",
		ReferenceNumber: 549,
		DetailsURL:      "https://spdx.org/licenses/DSDP.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/DSDP",
		},
		OSIApproved: false,
	},
	"dotseqn": {
		ID:              "Dotseqn",
		Name:            "Dotseqn License",
		Reference:       "https://spdx.org/licenses/Dotseqn.html",
		ReferenceNumber: 148,
		DetailsURL:      "https://spdx.org/licenses/Dotseqn.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Dotseqn",
		},
		OSIApproved: false,
	},
	"ecl-1.0": {
		ID:              "ECL-1.0",
		Name:            "Educational Community License v1.0",
		Reference:       "https://spdx.org/licenses/ECL-1.0.html",
		ReferenceNumber: 40,
		DetailsURL:      "https://spdx.org/licenses/ECL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/ECL-1.0",
		},
		OSIApproved: true,
	},
	"ecl-2.0": {
		ID:              "ECL-2.0",
		Name:            "Educational Community License v2.0",
		Reference:       "https://spdx.org/licenses/ECL-2.0.html",
		ReferenceNumber: 224,
		DetailsURL:      "https://spdx.org/licenses/ECL-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/ECL-2.0",
		},
		OSIApproved: true,
	},
	"efl-1.0": {
		ID:              "EFL-1.0",
		Name:            "Eiffel Forum License v1.0",
		Reference:       "https://spdx.org/licenses/EFL-1.0.html",
		ReferenceNumber: 329,
		DetailsURL:      "https://spdx.org/licenses/EFL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.eiffel-nice.org/license/forum.txt",
			"https://opensource.org/licenses/EFL-1.0",
		},
		OSIApproved: true,
	},
	"efl-2.0": {
		ID:              "EFL-2.0",
		Name:            "Eiffel Forum License v2.0",
		Reference:       "https://spdx.org/licenses/EFL-2.0.html",
		ReferenceNumber: 535,
		DetailsURL:      "https://spdx.org/licenses/EFL-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.eiffel-nice.org/license/eiffel-forum-license-2.html",
			"https://opensource.org/licenses/EFL-2.0",
		},
		OSIApproved: true,
	},
	"epics": {
		ID:              "EPICS",
		Name:            "EPICS Open License",
		Reference:       "https://spdx.org/licenses/EPICS.html",
		ReferenceNumber: 523,
		DetailsURL:      "https://spdx.org/licenses/EPICS.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://epics.anl.gov/license/open.php",
		},
		OSIApproved: false,
	},
	"epl-1.0": {
		ID:              "EPL-1.0",
		Name:            "Eclipse Public License 1.0",
		Reference:       "https://spdx.org/licenses/EPL-1.0.html",
		ReferenceNumber: 229,
		DetailsURL:      "https://spdx.org/licenses/EPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.eclipse.org/legal/epl-v10.html",
			"https://opensource.org/licenses/EPL-1.0",
		},
		OSIApproved: true,
	},
	"epl-2.0": {
		ID:              "EPL-2.0",
		Name:            "Eclipse Public License 2.0",
		Reference:       "https://spdx.org/licenses/EPL-2.0.html",
		ReferenceNumber: 143,
		DetailsURL:      "https://spdx.org/licenses/EPL-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.eclipse.org/legal/epl-2.0",
			"https://www.opensource.org/licenses/EPL-2.0",
		},
		OSIApproved: true,
	},
	"eudatagrid": {
		ID:              "EUDatagrid",
		Name:            "EU DataGrid Software License",
		Reference:       "https://spdx.org/licenses/EUDatagrid.html",
		ReferenceNumber: 191,
		DetailsURL:      "https://spdx.org/licenses/EUDatagrid.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://eu-datagrid.web.cern.ch/eu-datagrid/license.html",
			"https://opensource.org/licenses/EUDatagrid",
		},
		OSIApproved: true,
	},
	"eupl-1.0": {
		ID:              "EUPL-1.0",
		Name:            "European Union Public License 1.0",
		Reference:       "https://spdx.org/licenses/EUPL-1.0.html",
		ReferenceNumber: 392,
		DetailsURL:      "https://spdx.org/licenses/EUPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://ec.europa.eu/idabc/en/document/7330.html",
			"http://ec.europa.eu/idabc/servlets/Doc027f.pdf?id=31096",
		},
		OSIApproved: false,
	},
	"eupl-1.1": {
		ID:              "EUPL-1.1",
		Name:            "European Union Public License 1.1",
		Reference:       "https://spdx.org/licenses/EUPL-1.1.html",
		ReferenceNumber: 26,
		DetailsURL:      "https://spdx.org/licenses/EUPL-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://joinup.ec.europa.eu/software/page/eupl/licence-eupl",
			"https://joinup.ec.europa.eu/sites/default/files/custom-page/attachment/eupl1.1.-licence-en_0.pdf",
			"https://opensource.org/licenses/EUPL-1.1",
		},
		OSIApproved: true,
	},
	"eupl-1.2": {
		ID:              "EUPL-1.2",
		Name:            "European Union Public License 1.2",
		Reference:       "https://spdx.org/licenses/EUPL-1.2.html",
		ReferenceNumber: 34,
		DetailsURL:      "https://spdx.org/licenses/EUPL-1.2.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://joinup.ec.europa.eu/page/eupl-text-11-12",
			"https://joinup.ec.europa.eu/sites/default/files/custom-page/attachment/eupl_v1.2_en.pdf",
			"https://joinup.ec.europa.eu/sites/default/files/custom-page/attachment/2020-03/EUPL-1.2%20EN.txt",
			"https://joinup.ec.europa.eu/sites/default/files/inline-files/EUPL%20v1_2%20EN(1).txt",
			"http://eur-lex.europa.eu/legal-content/EN/TXT/HTML/?uri=CELEX:32017D0863",
			"https://opensource.org/licenses/EUPL-1.2",
		},
		OSIApproved: true,
	},
	"elastic-2.0": {
		ID:              "Elastic-2.0",
		Name:            "Elastic License 2.0",
		Reference:       "https://spdx.org/licenses/Elastic-2.0.html",
		ReferenceNumber: 21,
		DetailsURL:      "https://spdx.org/licenses/Elastic-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.elastic.co/licensing/elastic-license",
			"https://github.com/elastic/elasticsearch/blob/master/licenses/ELASTIC-LICENSE-2.0.txt",
		},
		OSIApproved: false,
	},
	"entessa": {
		ID:              "Entessa",
		Name:            "Entessa Public License v1.0",
		Reference:       "https://spdx.org/licenses/Entessa.html",
		ReferenceNumber: 87,
		DetailsURL:      "https://spdx.org/licenses/Entessa.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/Entessa",
		},
		OSIApproved: true,
	},
	"erlpl-1.1": {
		ID:              "ErlPL-1.1",
		Name:            "Erlang Public License v1.1",
		Reference:       "https://spdx.org/licenses/ErlPL-1.1.html",
		ReferenceNumber: 592,
		DetailsURL:      "https://spdx.org/licenses/ErlPL-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.erlang.org/EPLICENSE",
		},
		OSIApproved: false,
	},
	"eurosym": {
		ID:              "Eurosym",
		Name:            "Eurosym License",
		Reference:       "https://spdx.org/licenses/Eurosym.html",
		ReferenceNumber: 584,
		DetailsURL:      "https://spdx.org/licenses/Eurosym.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Eurosym",
		},
		OSIApproved: false,
	},
	"fbm": {
		ID:              "FBM",
		Name:            "Fuzzy Bitmap License",
		Reference:       "https://spdx.org/licenses/FBM.html",
		ReferenceNumber: 227,
		DetailsURL:      "https://spdx.org/licenses/FBM.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/SWI-Prolog/packages-xpce/blob/161a40cd82004f731ba48024f9d30af388a7edf5/src/img/gifwrite.c#L21-L26",
		},
		OSIApproved: false,
	},
	"fdk-aac": {
		ID:              "FDK-AAC",
		Name:            "Fraunhofer FDK AAC Codec Library",
		Reference:       "https://spdx.org/licenses/FDK-AAC.html",
		ReferenceNumber: 323,
		DetailsURL:      "https://spdx.org/licenses/FDK-AAC.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/FDK-AAC",
			"https://directory.fsf.org/wiki/License:Fdk",
		},
		OSIApproved: false,
	},
	"fsfap": {
		ID:              "FSFAP",
		Name:            "FSF All Permissive License",
		Reference:       "https://spdx.org/licenses/FSFAP.html",
		ReferenceNumber: 273,
		DetailsURL:      "https://spdx.org/licenses/FSFAP.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/prep/maintain/html_node/License-Notices-for-Other-Files.html",
		},
		OSIApproved: false,
	},
	"fsfap-no-warranty-disclaimer": {
		ID:              "FSFAP-no-warranty-disclaimer",
		Name:            "FSF All Permissive License (without Warranty)",
		Reference:       "https://spdx.org/licenses/FSFAP-no-warranty-disclaimer.html",
		ReferenceNumber: 67,
		DetailsURL:      "https://spdx.org/licenses/FSFAP-no-warranty-disclaimer.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://git.savannah.gnu.org/cgit/wget.git/tree/util/trunc.c?h=v1.21.3&id=40747a11e44ced5a8ac628a41f879ced3e2ebce9#n6",
		},
		OSIApproved: false,
	},
	"fsful": {
		ID:              "FSFUL",
		Name:            "FSF Unlimited License",
		Reference:       "https://spdx.org/licenses/FSFUL.html",
		ReferenceNumber: 577,
		DetailsURL:      "https://spdx.org/licenses/FSFUL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License",
		},
		OSIApproved: false,
	},
	"fsfullr": {
		ID:              "FSFULLR",
		Name:            "FSF Unlimited License (with License Retention)",
		Reference:       "https://spdx.org/licenses/FSFULLR.html",
		ReferenceNumber: 96,
		DetailsURL:      "https://spdx.org/licenses/FSFULLR.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/FSF_Unlimited_License#License_Retention_Variant",
		},
		OSIApproved: false,
	},
	"fsfullrwd": {
		ID:              "FSFULLRWD",
		Name:            "FSF Unlimited License (With License Retention and Warranty Disclaimer)",
		Reference:       "https://spdx.org/licenses/FSFULLRWD.html",
		ReferenceNumber: 456,
		DetailsURL:      "https://spdx.org/licenses/FSFULLRWD.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://lists.gnu.org/archive/html/autoconf/2012-04/msg00061.html",
		},
		OSIApproved: false,
	},
	"ftl": {
		ID:              "FTL",
		Name:            "Freetype Project License",
		Reference:       "https://spdx.org/licenses/FTL.html",
		ReferenceNumber: 519,
		DetailsURL:      "https://spdx.org/licenses/FTL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://freetype.fis.uniroma2.it/FTL.TXT",
			"http://git.savannah.gnu.org/cgit/freetype/freetype2.git/tree/docs/FTL.TXT",
			"http://gitlab.freedesktop.org/freetype/freetype/-/raw/master/docs/FTL.TXT",
		},
		OSIApproved: false,
	},
	"fair": {
		ID:              "Fair",
		Name:            "Fair License",
		Reference:       "https://spdx.org/licenses/Fair.html",
		ReferenceNumber: 93,
		DetailsURL:      "https://spdx.org/licenses/Fair.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://web.archive.org/web/20150926120323/http://fairlicense.org/",
			"https://opensource.org/licenses/Fair",
		},
		OSIApproved: true,
	},
	"ferguson-twofish": {
		ID:              "Ferguson-Twofish",
		Name:            "Ferguson Twofish License",
		Reference:       "https://spdx.org/licenses/Ferguson-Twofish.html",
		ReferenceNumber: 447,
		DetailsURL:      "https://spdx.org/licenses/Ferguson-Twofish.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/wernerd/ZRTPCPP/blob/6b3cd8e6783642292bad0c21e3e5e5ce45ff3e03/cryptcommon/twofish.c#L113C3-L127",
		},
		OSIApproved: false,
	},
	"frameworx-1.0": {
		ID:              "Frameworx-1.0",
		Name:            "Frameworx Open License 1.0",
		Reference:       "https://spdx.org/licenses/Frameworx-1.0.html",
		ReferenceNumber: 152,
		DetailsURL:      "https://spdx.org/licenses/Frameworx-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/Frameworx-1.0",
		},
		OSIApproved: true,
	},
	"freebsd-doc": {
		ID:              "FreeBSD-DOC",
		Name:            "FreeBSD Documentation License",
		Reference:       "https://spdx.org/licenses/FreeBSD-DOC.html",
		ReferenceNumber: 73,
		DetailsURL:      "https://spdx.org/licenses/FreeBSD-DOC.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.freebsd.org/copyright/freebsd-doc-license/",
		},
		OSIApproved: false,
	},
	"freeimage": {
		ID:              "FreeImage",
		Name:            "FreeImage Public License v1.0",
		Reference:       "https://spdx.org/licenses/FreeImage.html",
		ReferenceNumber: 131,
		DetailsURL:      "https://spdx.org/licenses/FreeImage.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://freeimage.sourceforge.net/freeimage-license.txt",
		},
		OSIApproved: false,
	},
	"furuseth": {
		ID:              "Furuseth",
		Name:            "Furuseth License",
		Reference:       "https://spdx.org/licenses/Furuseth.html",
		ReferenceNumber: 604,
		DetailsURL:      "https://spdx.org/licenses/Furuseth.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://git.openldap.org/openldap/openldap/-/blob/master/COPYRIGHT?ref_type=heads#L39-51",
		},
		OSIApproved: false,
	},
	"gcr-docs": {
		ID:              "GCR-docs",
		Name:            "Gnome GCR Documentation License",
		Reference:       "https://spdx.org/licenses/GCR-docs.html",
		ReferenceNumber: 155,
		DetailsURL:      "https://spdx.org/licenses/GCR-docs.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/GNOME/gcr/blob/master/docs/COPYING",
		},
		OSIApproved: false,
	},
	"gd": {
		ID:              "GD",
		Name:            "GD License",
		Reference:       "https://spdx.org/licenses/GD.html",
		ReferenceNumber: 92,
		DetailsURL:      "https://spdx.org/licenses/GD.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://libgd.github.io/manuals/2.3.0/files/license-txt.html",
		},
		OSIApproved: false,
	},
	"gfdl-1.1": {
		ID:              "GFDL-1.1",
		Name:            "GNU Free Documentation License v1.1",
		Reference:       "https://spdx.org/licenses/GFDL-1.1.html",
		ReferenceNumber: 195,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.1-invariants-only": {
		ID:              "GFDL-1.1-invariants-only",
		Name:            "GNU Free Documentation License v1.1 only - invariants",
		Reference:       "https://spdx.org/licenses/GFDL-1.1-invariants-only.html",
		ReferenceNumber: 346,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.1-invariants-only.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.1-invariants-or-later": {
		ID:              "GFDL-1.1-invariants-or-later",
		Name:            "GNU Free Documentation License v1.1 or later - invariants",
		Reference:       "https://spdx.org/licenses/GFDL-1.1-invariants-or-later.html",
		ReferenceNumber: 269,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.1-invariants-or-later.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.1-no-invariants-only": {
		ID:              "GFDL-1.1-no-invariants-only",
		Name:            "GNU Free Documentation License v1.1 only - no invariants",
		Reference:       "https://spdx.org/licenses/GFDL-1.1-no-invariants-only.html",
		ReferenceNumber: 6,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.1-no-invariants-only.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.1-no-invariants-or-later": {
		ID:              "GFDL-1.1-no-invariants-or-later",
		Name:            "GNU Free Documentation License v1.1 or later - no invariants",
		Reference:       "https://spdx.org/licenses/GFDL-1.1-no-invariants-or-later.html",
		ReferenceNumber: 7,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.1-no-invariants-or-later.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.1-only": {
		ID:              "GFDL-1.1-only",
		Name:            "GNU Free Documentation License v1.1 only",
		Reference:       "https://spdx.org/licenses/GFDL-1.1-only.html",
		ReferenceNumber: 264,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.1-only.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.1-or-later": {
		ID:              "GFDL-1.1-or-later",
		Name:            "GNU Free Documentation License v1.1 or later",
		Reference:       "https://spdx.org/licenses/GFDL-1.1-or-later.html",
		ReferenceNumber: 196,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.1-or-later.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/fdl-1.1.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.2": {
		ID:              "GFDL-1.2",
		Name:            "GNU Free Documentation License v1.2",
		Reference:       "https://spdx.org/licenses/GFDL-1.2.html",
		ReferenceNumber: 97,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.2.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.2-invariants-only": {
		ID:              "GFDL-1.2-invariants-only",
		Name:            "GNU Free Documentation License v1.2 only - invariants",
		Reference:       "https://spdx.org/licenses/GFDL-1.2-invariants-only.html",
		ReferenceNumber: 611,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.2-invariants-only.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.2-invariants-or-later": {
		ID:              "GFDL-1.2-invariants-or-later",
		Name:            "GNU Free Documentation License v1.2 or later - invariants",
		Reference:       "https://spdx.org/licenses/GFDL-1.2-invariants-or-later.html",
		ReferenceNumber: 464,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.2-invariants-or-later.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.2-no-invariants-only": {
		ID:              "GFDL-1.2-no-invariants-only",
		Name:            "GNU Free Documentation License v1.2 only - no invariants",
		Reference:       "https://spdx.org/licenses/GFDL-1.2-no-invariants-only.html",
		ReferenceNumber: 75,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.2-no-invariants-only.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.2-no-invariants-or-later": {
		ID:              "GFDL-1.2-no-invariants-or-later",
		Name:            "GNU Free Documentation License v1.2 or later - no invariants",
		Reference:       "https://spdx.org/licenses/GFDL-1.2-no-invariants-or-later.html",
		ReferenceNumber: 14,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.2-no-invariants-or-later.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.2-only": {
		ID:              "GFDL-1.2-only",
		Name:            "GNU Free Documentation License v1.2 only",
		Reference:       "https://spdx.org/licenses/GFDL-1.2-only.html",
		ReferenceNumber: 322,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.2-only.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.2-or-later": {
		ID:              "GFDL-1.2-or-later",
		Name:            "GNU Free Documentation License v1.2 or later",
		Reference:       "https://spdx.org/licenses/GFDL-1.2-or-later.html",
		ReferenceNumber: 594,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.2-or-later.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/fdl-1.2.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.3": {
		ID:              "GFDL-1.3",
		Name:            "GNU Free Documentation License v1.3",
		Reference:       "https://spdx.org/licenses/GFDL-1.3.html",
		ReferenceNumber: 538,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.3.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/fdl-1.3.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.3-invariants-only": {
		ID:              "GFDL-1.3-invariants-only",
		Name:            "GNU Free Documentation License v1.3 only - invariants",
		Reference:       "https://spdx.org/licenses/GFDL-1.3-invariants-only.html",
		ReferenceNumber: 571,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.3-invariants-only.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/fdl-1.3.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.3-invariants-or-later": {
		ID:              "GFDL-1.3-invariants-or-later",
		Name:            "GNU Free Documentation License v1.3 or later - invariants",
		Reference:       "https://spdx.org/licenses/GFDL-1.3-invariants-or-later.html",
		ReferenceNumber: 300,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.3-invariants-or-later.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/fdl-1.3.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.3-no-invariants-only": {
		ID:              "GFDL-1.3-no-invariants-only",
		Name:            "GNU Free Documentation License v1.3 only - no invariants",
		Reference:       "https://spdx.org/licenses/GFDL-1.3-no-invariants-only.html",
		ReferenceNumber: 101,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.3-no-invariants-only.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/fdl-1.3.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.3-no-invariants-or-later": {
		ID:              "GFDL-1.3-no-invariants-or-later",
		Name:            "GNU Free Documentation License v1.3 or later - no invariants",
		Reference:       "https://spdx.org/licenses/GFDL-1.3-no-invariants-or-later.html",
		ReferenceNumber: 330,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.3-no-invariants-or-later.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/fdl-1.3.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.3-only": {
		ID:              "GFDL-1.3-only",
		Name:            "GNU Free Documentation License v1.3 only",
		Reference:       "https://spdx.org/licenses/GFDL-1.3-only.html",
		ReferenceNumber: 457,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.3-only.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/fdl-1.3.txt",
		},
		OSIApproved: false,
	},
	"gfdl-1.3-or-later": {
		ID:              "GFDL-1.3-or-later",
		Name:            "GNU Free Documentation License v1.3 or later",
		Reference:       "https://spdx.org/licenses/GFDL-1.3-or-later.html",
		ReferenceNumber: 472,
		DetailsURL:      "https://spdx.org/licenses/GFDL-1.3-or-later.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/fdl-1.3.txt",
		},
		OSIApproved: false,
	},
	"gl2ps": {
		ID:              "GL2PS",
		Name:            "GL2PS License",
		Reference:       "https://spdx.org/licenses/GL2PS.html",
		ReferenceNumber: 338,
		DetailsURL:      "https://spdx.org/licenses/GL2PS.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.geuz.org/gl2ps/COPYING.GL2PS",
		},
		OSIApproved: false,
	},
	"glwtpl": {
		ID:              "GLWTPL",
		Name:            "Good Luck With That Public License",
		Reference:       "https://spdx.org/licenses/GLWTPL.html",
		ReferenceNumber: 576,
		DetailsURL:      "https://spdx.org/licenses/GLWTPL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/me-shaon/GLWTPL/commit/da5f6bc734095efbacb442c0b31e33a65b9d6e85",
		},
		OSIApproved: false,
	},
	"gpl-1.0": {
		ID:              "GPL-1.0",
		Name:            "GNU General Public License v1.0 only",
		Reference:       "https://spdx.org/licenses/GPL-1.0.html",
		ReferenceNumber: 601,
		DetailsURL:      "https://spdx.org/licenses/GPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html",
		},
		OSIApproved: false,
	},
	"gpl-1.0+": {
		ID:              "GPL-1.0+",
		Name:            "GNU General Public License v1.0 or later",
		Reference:       "https://spdx.org/licenses/GPL-1.0+.html",
		ReferenceNumber: 442,
		DetailsURL:      "https://spdx.org/licenses/GPL-1.0+.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html",
		},
		OSIApproved: false,
	},
	"gpl-1.0-only": {
		ID:              "GPL-1.0-only",
		Name:            "GNU General Public License v1.0 only",
		Reference:       "https://spdx.org/licenses/GPL-1.0-only.html",
		ReferenceNumber: 527,
		DetailsURL:      "https://spdx.org/licenses/GPL-1.0-only.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html",
		},
		OSIApproved: false,
	},
	"gpl-1.0-or-later": {
		ID:              "GPL-1.0-or-later",
		Name:            "GNU General Public License v1.0 or later",
		Reference:       "https://spdx.org/licenses/GPL-1.0-or-later.html",
		ReferenceNumber: 0,
		DetailsURL:      "https://spdx.org/licenses/GPL-1.0-or-later.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/gpl-1.0-standalone.html",
		},
		OSIApproved: false,
	},
	"gpl-2.0": {
		ID:              "GPL-2.0",
		Name:            "GNU General Public License v2.0 only",
		Reference:       "https://spdx.org/licenses/GPL-2.0.html",
		ReferenceNumber: 473,
		DetailsURL:      "https://spdx.org/licenses/GPL-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html",
			"https://opensource.org/licenses/GPL-2.0",
		},
		OSIApproved: true,
	},
	"gpl-2.0+": {
		ID:              "GPL-2.0+",
		Name:            "GNU General Public License v2.0 or later",
		Reference:       "https://spdx.org/licenses/GPL-2.0+.html",
		ReferenceNumber: 502,
		DetailsURL:      "https://spdx.org/licenses/GPL-2.0+.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html",
			"https://opensource.org/licenses/GPL-2.0",
		},
		OSIApproved: true,
	},
	"gpl-2.0-only": {
		ID:              "GPL-2.0-only",
		Name:            "GNU General Public License v2.0 only",
		Reference:       "https://spdx.org/licenses/GPL-2.0-only.html",
		ReferenceNumber: 404,
		DetailsURL:      "https://spdx.org/licenses/GPL-2.0-only.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html",
			"https://www.gnu.org/licenses/old-licenses/gpl-2.0.txt",
			"https://opensource.org/licenses/GPL-2.0",
		},
		OSIApproved: true,
	},
	"gpl-2.0-or-later": {
		ID:              "GPL-2.0-or-later",
		Name:            "GNU General Public License v2.0 or later",
		Reference:       "https://spdx.org/licenses/GPL-2.0-or-later.html",
		ReferenceNumber: 389,
		DetailsURL:      "https://spdx.org/licenses/GPL-2.0-or-later.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html",
			"https://opensource.org/licenses/GPL-2.0",
		},
		OSIApproved: true,
	},
	"gpl-2.0-with-gcc-exception": {
		ID:              "GPL-2.0-with-GCC-exception",
		Name:            "GNU General Public License v2.0 w/GCC Runtime Library exception",
		Reference:       "https://spdx.org/licenses/GPL-2.0-with-GCC-exception.html",
		ReferenceNumber: 54,
		DetailsURL:      "https://spdx.org/licenses/GPL-2.0-with-GCC-exception.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://gcc.gnu.org/git/?p=gcc.git;a=blob;f=gcc/libgcc1.c;h=762f5143fc6eed57b6797c82710f3538aa52b40b;hb=cb143a3ce4fb417c68f5fa2691a1b1b1053dfba9#l10",
		},
		OSIApproved: false,
	},
	"gpl-2.0-with-autoconf-exception": {
		ID:              "GPL-2.0-with-autoconf-exception",
		Name:            "GNU General Public License v2.0 w/Autoconf exception",
		Reference:       "https://spdx.org/licenses/GPL-2.0-with-autoconf-exception.html",
		ReferenceNumber: 333,
		DetailsURL:      "https://spdx.org/licenses/GPL-2.0-with-autoconf-exception.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://ac-archive.sourceforge.net/doc/copyright.html",
		},
		OSIApproved: false,
	},
	"gpl-2.0-with-bison-exception": {
		ID:              "GPL-2.0-with-bison-exception",
		Name:            "GNU General Public License v2.0 w/Bison exception",
		Reference:       "https://spdx.org/licenses/GPL-2.0-with-bison-exception.html",
		ReferenceNumber: 117,
		DetailsURL:      "https://spdx.org/licenses/GPL-2.0-with-bison-exception.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://git.savannah.gnu.org/cgit/bison.git/tree/data/yacc.c?id=193d7c7054ba7197b0789e14965b739162319b5e#n141",
		},
		OSIApproved: false,
	},
	"gpl-2.0-with-classpath-exception": {
		ID:              "GPL-2.0-with-classpath-exception",
		Name:            "GNU General Public License v2.0 w/Classpath exception",
		Reference:       "https://spdx.org/licenses/GPL-2.0-with-classpath-exception.html",
		ReferenceNumber: 144,
		DetailsURL:      "https://spdx.org/licenses/GPL-2.0-with-classpath-exception.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/software/classpath/license.html",
		},
		OSIApproved: false,
	},
	"gpl-2.0-with-font-exception": {
		ID:              "GPL-2.0-with-font-exception",
		Name:            "GNU General Public License v2.0 w/Font exception",
		Reference:       "https://spdx.org/licenses/GPL-2.0-with-font-exception.html",
		ReferenceNumber: 286,
		DetailsURL:      "https://spdx.org/licenses/GPL-2.0-with-font-exception.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/gpl-faq.html#FontException",
		},
		OSIApproved: false,
	},
	"gpl-3.0": {
		ID:              "GPL-3.0",
		Name:            "GNU General Public License v3.0 only",
		Reference:       "https://spdx.org/licenses/GPL-3.0.html",
		ReferenceNumber: 233,
		DetailsURL:      "https://spdx.org/licenses/GPL-3.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/gpl-3.0-standalone.html",
			"https://opensource.org/licenses/GPL-3.0",
		},
		OSIApproved: true,
	},
	"gpl-3.0+": {
		ID:              "GPL-3.0+",
		Name:            "GNU General Public License v3.0 or later",
		Reference:       "https://spdx.org/licenses/GPL-3.0+.html",
		ReferenceNumber: 201,
		DetailsURL:      "https://spdx.org/licenses/GPL-3.0+.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/gpl-3.0-standalone.html",
			"https://opensource.org/licenses/GPL-3.0",
		},
		OSIApproved: true,
	},
	"gpl-3.0-only": {
		ID:              "GPL-3.0-only",
		Name:            "GNU General Public License v3.0 only",
		Reference:       "https://spdx.org/licenses/GPL-3.0-only.html",
		ReferenceNumber: 339,
		DetailsURL:      "https://spdx.org/licenses/GPL-3.0-only.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/gpl-3.0-standalone.html",
			"https://opensource.org/licenses/GPL-3.0",
		},
		OSIApproved: true,
	},
	"gpl-3.0-or-later": {
		ID:              "GPL-3.0-or-later",
		Name:            "GNU General Public License v3.0 or later",
		Reference:       "https://spdx.org/licenses/GPL-3.0-or-later.html",
		ReferenceNumber: 109,
		DetailsURL:      "https://spdx.org/licenses/GPL-3.0-or-later.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/gpl-3.0-standalone.html",
			"https://opensource.org/licenses/GPL-3.0",
		},
		OSIApproved: true,
	},
	"gpl-3.0-with-gcc-exception": {
		ID:              "GPL-3.0-with-GCC-exception",
		Name:            "GNU General Public License v3.0 w/GCC Runtime Library exception",
		Reference:       "https://spdx.org/licenses/GPL-3.0-with-GCC-exception.html",
		ReferenceNumber: 331,
		DetailsURL:      "https://spdx.org/licenses/GPL-3.0-with-GCC-exception.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/gcc-exception-3.1.html",
		},
		OSIApproved: true,
	},
	"gpl-3.0-with-autoconf-exception": {
		ID:              "GPL-3.0-with-autoconf-exception",
		Name:            "GNU General Public License v3.0 w/Autoconf exception",
		Reference:       "https://spdx.org/licenses/GPL-3.0-with-autoconf-exception.html",
		ReferenceNumber: 121,
		DetailsURL:      "https://spdx.org/licenses/GPL-3.0-with-autoconf-exception.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/autoconf-exception-3.0.html",
		},
		OSIApproved: false,
	},
	"giftware": {
		ID:              "Giftware",
		Name:            "Giftware License",
		Reference:       "https://spdx.org/licenses/Giftware.html",
		ReferenceNumber: 449,
		DetailsURL:      "https://spdx.org/licenses/Giftware.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://liballeg.org/license.html#allegro-4-the-giftware-license",
		},
		OSIApproved: false,
	},
	"glide": {
		ID:              "Glide",
		Name:            "3dfx Glide License",
		Reference:       "https://spdx.org/licenses/Glide.html",
		ReferenceNumber: 215,
		DetailsURL:      "https://spdx.org/licenses/Glide.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.users.on.net/~triforce/glidexp/COPYING.txt",
		},
		OSIApproved: false,
	},
	"glulxe": {
		ID:              "Glulxe",
		Name:            "Glulxe License",
		Reference:       "https://spdx.org/licenses/Glulxe.html",
		ReferenceNumber: 289,
		DetailsURL:      "https://spdx.org/licenses/Glulxe.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Glulxe",
		},
		OSIApproved: false,
	},
	"graphics-gems": {
		ID:              "Graphics-Gems",
		Name:            "Graphics Gems License",
		Reference:       "https://spdx.org/licenses/Graphics-Gems.html",
		ReferenceNumber: 68,
		DetailsURL:      "https://spdx.org/licenses/Graphics-Gems.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/erich666/GraphicsGems/blob/master/LICENSE.md",
		},
		OSIApproved: false,
	},
	"hp-1986": {
		ID:              "HP-1986",
		Name:            "Hewlett-Packard 1986 License",
		Reference:       "https://spdx.org/licenses/HP-1986.html",
		ReferenceNumber: 39,
		DetailsURL:      "https://spdx.org/licenses/HP-1986.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://sourceware.org/git/?p=newlib-cygwin.git;a=blob;f=newlib/libc/machine/hppa/memchr.S;h=1cca3e5e8867aa4bffef1f75a5c1bba25c0c441e;hb=HEAD#l2",
		},
		OSIApproved: false,
	},
	"hp-1989": {
		ID:              "HP-1989",
		Name:            "Hewlett-Packard 1989 License",
		Reference:       "https://spdx.org/licenses/HP-1989.html",
		ReferenceNumber: 578,
		DetailsURL:      "https://spdx.org/licenses/HP-1989.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/bleargh45/Data-UUID/blob/master/LICENSE",
		},
		OSIApproved: false,
	},
	"hpnd": {
		ID:              "HPND",
		Name:            "Historical Permission Notice and Disclaimer",
		Reference:       "https://spdx.org/licenses/HPND.html",
		ReferenceNumber: 624,
		DetailsURL:      "https://spdx.org/licenses/HPND.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/HPND",
			"http://lists.opensource.org/pipermail/license-discuss_lists.opensource.org/2002-November/006304.html",
		},
		OSIApproved: true,
	},
	"hpnd-dec": {
		ID:              "HPND-DEC",
		Name:            "Historical Permission Notice and Disclaimer - DEC variant",
		Reference:       "https://spdx.org/licenses/HPND-DEC.html",
		ReferenceNumber: 115,
		DetailsURL:      "https://spdx.org/licenses/HPND-DEC.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://gitlab.freedesktop.org/xorg/app/xkbcomp/-/blob/master/COPYING?ref_type=heads#L69",
		},
		OSIApproved: false,
	},
	"hpnd-fenneberg-livingston": {
		ID:              "HPND-Fenneberg-Livingston",
		Name:            "Historical Permission Notice and Disclaimer - Fenneberg-Livingston variant",
		Reference:       "https://spdx.org/licenses/HPND-Fenneberg-Livingston.html",
		ReferenceNumber: 305,
		DetailsURL:      "https://spdx.org/licenses/HPND-Fenneberg-Livingston.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/FreeRADIUS/freeradius-client/blob/master/COPYRIGHT#L32",
			"https://github.com/radcli/radcli/blob/master/COPYRIGHT#L34",
		},
		OSIApproved: false,
	},
	"hpnd-inria-imag": {
		ID:              "HPND-INRIA-IMAG",
		Name:            "Historical Permission Notice and Disclaimer    - INRIA-IMAG variant",
		Reference:       "https://spdx.org/licenses/HPND-INRIA-IMAG.html",
		ReferenceNumber: 10,
		DetailsURL:      "https://spdx.org/licenses/HPND-INRIA-IMAG.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/ppp-project/ppp/blob/master/pppd/ipv6cp.c#L75-L83",
		},
		OSIApproved: false,
	},
	"hpnd-kevlin-henney": {
		ID:              "HPND-Kevlin-Henney",
		Name:            "Historical Permission Notice and Disclaimer - Kevlin Henney variant",
		Reference:       "https://spdx.org/licenses/HPND-Kevlin-Henney.html",
		ReferenceNumber: 462,
		DetailsURL:      "https://spdx.org/licenses/HPND-Kevlin-Henney.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/mruby/mruby/blob/83d12f8d52522cdb7c8cc46fad34821359f453e6/mrbgems/mruby-dir/src/Win/dirent.c#L127-L140",
		},
		OSIApproved: false,
	},
	"hpnd-mit-disclaimer": {
		ID:              "HPND-MIT-disclaimer",
		Name:            "Historical Permission Notice and Disclaimer with MIT disclaimer",
		Reference:       "https://spdx.org/licenses/HPND-MIT-disclaimer.html",
		ReferenceNumber: 345,
		DetailsURL:      "https://spdx.org/licenses/HPND-MIT-disclaimer.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://metacpan.org/release/NLNETLABS/Net-DNS-SEC-1.22/source/LICENSE",
		},
		OSIApproved: false,
	},
	"hpnd-markus-kuhn": {
		ID:              "HPND-Markus-Kuhn",
		Name:            "Historical Permission Notice and Disclaimer - Markus Kuhn variant",
		Reference:       "https://spdx.org/licenses/HPND-Markus-Kuhn.html",
		ReferenceNumber: 367,
		DetailsURL:      "https://spdx.org/licenses/HPND-Markus-Kuhn.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.cl.cam.ac.uk/~mgk25/ucs/wcwidth.c",
			"https://sourceware.org/git/?p=binutils-gdb.git;a=blob;f=readline/readline/support/wcwidth.c;h=0f5ec995796f4813abbcf4972aec0378ab74722a;hb=HEAD#l55",
		},
		OSIApproved: false,
	},
	"hpnd-pbmplus": {
		ID:              "HPND-Pbmplus",
		Name:            "Historical Permission Notice and Disclaimer - Pbmplus variant",
		Reference:       "https://spdx.org/licenses/HPND-Pbmplus.html",
		ReferenceNumber: 204,
		DetailsURL:      "https://spdx.org/licenses/HPND-Pbmplus.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://sourceforge.net/p/netpbm/code/HEAD/tree/super_stable/netpbm.c#l8",
		},
		OSIApproved: false,
	},
	"hpnd-uc": {
		ID:              "HPND-UC",
		Name:            "Historical Permission Notice and Disclaimer - University of California variant",
		Reference:       "https://spdx.org/licenses/HPND-UC.html",
		ReferenceNumber: 107,
		DetailsURL:      "https://spdx.org/licenses/HPND-UC.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://core.tcl-lang.org/tk/file?name=compat/unistd.h",
		},
		OSIApproved: false,
	},
	"hpnd-doc": {
		ID:              "HPND-doc",
		Name:            "Historical Permission Notice and Disclaimer - documentation variant",
		Reference:       "https://spdx.org/licenses/HPND-doc.html",
		ReferenceNumber: 30,
		DetailsURL:      "https://spdx.org/licenses/HPND-doc.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://gitlab.freedesktop.org/xorg/lib/libxext/-/blob/master/COPYING?ref_type=heads#L185-197",
			"https://gitlab.freedesktop.org/xorg/lib/libxtst/-/blob/master/COPYING?ref_type=heads#L70-77",
		},
		OSIApproved: false,
	},
	"hpnd-doc-sell": {
		ID:              "HPND-doc-sell",
		Name:            "Historical Permission Notice and Disclaimer - documentation sell variant",
		Reference:       "https://spdx.org/licenses/HPND-doc-sell.html",
		ReferenceNumber: 184,
		DetailsURL:      "https://spdx.org/licenses/HPND-doc-sell.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://gitlab.freedesktop.org/xorg/lib/libxtst/-/blob/master/COPYING?ref_type=heads#L108-117",
			"https://gitlab.freedesktop.org/xorg/lib/libxext/-/blob/master/COPYING?ref_type=heads#L153-162",
		},
		OSIApproved: false,
	},
	"hpnd-export-us": {
		ID:              "HPND-export-US",
		Name:            "HPND with US Government export control warning",
		Reference:       "https://spdx.org/licenses/HPND-export-US.html",
		ReferenceNumber: 336,
		DetailsURL:      "https://spdx.org/licenses/HPND-export-US.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.kermitproject.org/ck90.html#source",
		},
		OSIApproved: false,
	},
	"hpnd-export-us-modify": {
		ID:              "HPND-export-US-modify",
		Name:            "HPND with US Government export control warning and modification rqmt",
		Reference:       "https://spdx.org/licenses/HPND-export-US-modify.html",
		ReferenceNumber: 261,
		DetailsURL:      "https://spdx.org/licenses/HPND-export-US-modify.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/krb5/krb5/blob/krb5-1.21.2-final/NOTICE#L1157-L1182",
			"https://github.com/pythongssapi/k5test/blob/v0.10.3/K5TEST-LICENSE.txt",
		},
		OSIApproved: false,
	},
	"hpnd-sell-mit-disclaimer-xserver": {
		ID:              "HPND-sell-MIT-disclaimer-xserver",
		Name:            "Historical Permission Notice and Disclaimer - sell xserver variant with MIT disclaimer",
		Reference:       "https://spdx.org/licenses/HPND-sell-MIT-disclaimer-xserver.html",
		ReferenceNumber: 532,
		DetailsURL:      "https://spdx.org/licenses/HPND-sell-MIT-disclaimer-xserver.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://gitlab.freedesktop.org/xorg/xserver/-/blob/master/COPYING?ref_type=heads#L1781",
		},
		OSIApproved: false,
	},
	"hpnd-sell-regexpr": {
		ID:              "HPND-sell-regexpr",
		Name:            "Historical Permission Notice and Disclaimer - sell regexpr variant",
		Reference:       "https://spdx.org/licenses/HPND-sell-regexpr.html",
		ReferenceNumber: 572,
		DetailsURL:      "https://spdx.org/licenses/HPND-sell-regexpr.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://gitlab.com/bacula-org/bacula/-/blob/Branch-11.0/bacula/LICENSE-FOSS?ref_type=heads#L245",
		},
		OSIApproved: false,
	},
	"hpnd-sell-variant": {
		ID:              "HPND-sell-variant",
		Name:            "Historical Permission Notice and Disclaimer - sell variant",
		Reference:       "https://spdx.org/licenses/HPND-sell-variant.html",
		ReferenceNumber: 414,
		DetailsURL:      "https://spdx.org/licenses/HPND-sell-variant.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/net/sunrpc/auth_gss/gss_generic_token.c?h=v4.19",
		},
		OSIApproved: false,
	},
	"hpnd-sell-variant-mit-disclaimer": {
		ID:              "HPND-sell-variant-MIT-disclaimer",
		Name:            "HPND sell variant with MIT disclaimer",
		Reference:       "https://spdx.org/licenses/HPND-sell-variant-MIT-disclaimer.html",
		ReferenceNumber: 51,
		DetailsURL:      "https://spdx.org/licenses/HPND-sell-variant-MIT-disclaimer.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/sigmavirus24/x11-ssh-askpass/blob/master/README",
		},
		OSIApproved: false,
	},
	"htmltidy": {
		ID:              "HTMLTIDY",
		Name:            "HTML Tidy License",
		Reference:       "https://spdx.org/licenses/HTMLTIDY.html",
		ReferenceNumber: 474,
		DetailsURL:      "https://spdx.org/licenses/HTMLTIDY.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/htacg/tidy-html5/blob/next/README/LICENSE.md",
		},
		OSIApproved: false,
	},
	"haskellreport": {
		ID:              "HaskellReport",
		Name:            "Haskell Language Report License",
		Reference:       "https://spdx.org/licenses/HaskellReport.html",
		ReferenceNumber: 138,
		DetailsURL:      "https://spdx.org/licenses/HaskellReport.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Haskell_Language_Report_License",
		},
		OSIApproved: false,
	},
	"hippocratic-2.1": {
		ID:              "Hippocratic-2.1",
		Name:            "Hippocratic License 2.1",
		Reference:       "https://spdx.org/licenses/Hippocratic-2.1.html",
		ReferenceNumber: 609,
		DetailsURL:      "https://spdx.org/licenses/Hippocratic-2.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://firstdonoharm.dev/version/2/1/license.html",
			"https://github.com/EthicalSource/hippocratic-license/blob/58c0e646d64ff6fbee275bfe2b9492f914e3ab2a/LICENSE.txt",
		},
		OSIApproved: false,
	},
	"ibm-pibs": {
		ID:              "IBM-pibs",
		Name:            "IBM PowerPC Initialization and Boot Software",
		Reference:       "https://spdx.org/licenses/IBM-pibs.html",
		ReferenceNumber: 417,
		DetailsURL:      "https://spdx.org/licenses/IBM-pibs.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://git.denx.de/?p=u-boot.git;a=blob;f=arch/powerpc/cpu/ppc4xx/miiphy.c;h=297155fdafa064b955e53e9832de93bfb0cfb85b;hb=9fab4bf4cc077c21e43941866f3f2c196f28670d",
		},
		OSIApproved: false,
	},
	"icu": {
		ID:              "ICU",
		Name:            "ICU License",
		Reference:       "https://spdx.org/licenses/ICU.html",
		ReferenceNumber: 153,
		DetailsURL:      "https://spdx.org/licenses/ICU.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://source.icu-project.org/repos/icu/icu/trunk/license.html",
		},
		OSIApproved: true,
	},
	"iec-code-components-eula": {
		ID:              "IEC-Code-Components-EULA",
		Name:            "IEC    Code Components End-user licence agreement",
		Reference:       "https://spdx.org/licenses/IEC-Code-Components-EULA.html",
		ReferenceNumber: 481,
		DetailsURL:      "https://spdx.org/licenses/IEC-Code-Components-EULA.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.iec.ch/webstore/custserv/pdf/CC-EULA.pdf",
			"https://www.iec.ch/CCv1",
			"https://www.iec.ch/copyright",
		},
		OSIApproved: false,
	},
	"ijg": {
		ID:              "IJG",
		Name:            "Independent JPEG Group License",
		Reference:       "https://spdx.org/licenses/IJG.html",
		ReferenceNumber: 90,
		DetailsURL:      "https://spdx.org/licenses/IJG.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://dev.w3.org/cvsweb/Amaya/libjpeg/Attic/README?rev=1.2",
		},
		OSIApproved: false,
	},
	"ijg-short": {
		ID:              "IJG-short",
		Name:            "Independent JPEG Group License - short",
		Reference:       "https://spdx.org/licenses/IJG-short.html",
		ReferenceNumber: 520,
		DetailsURL:      "https://spdx.org/licenses/IJG-short.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://sourceforge.net/p/xmedcon/code/ci/master/tree/libs/ljpg/",
		},
		OSIApproved: false,
	},
	"ipa": {
		ID:              "IPA",
		Name:            "IPA Font License",
		Reference:       "https://spdx.org/licenses/IPA.html",
		ReferenceNumber: 411,
		DetailsURL:      "https://spdx.org/licenses/IPA.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/IPA",
		},
		OSIApproved: true,
	},
	"ipl-1.0": {
		ID:              "IPL-1.0",
		Name:            "IBM Public License v1.0",
		Reference:       "https://spdx.org/licenses/IPL-1.0.html",
		ReferenceNumber: 508,
		DetailsURL:      "https://spdx.org/licenses/IPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/IPL-1.0",
		},
		OSIApproved: true,
	},
	"isc": {
		ID:              "ISC",
		Name:            "ISC License",
		Reference:       "https://spdx.org/licenses/ISC.html",
		ReferenceNumber: 483,
		DetailsURL:      "https://spdx.org/licenses/ISC.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.isc.org/licenses/",
			"https://www.isc.org/downloads/software-support-policy/isc-license/",
			"https://opensource.org/licenses/ISC",
		},
		OSIApproved: true,
	},
	"isc-veillard": {
		ID:              "ISC-Veillard",
		Name:            "ISC Veillard variant",
		Reference:       "https://spdx.org/licenses/ISC-Veillard.html",
		ReferenceNumber: 446,
		DetailsURL:      "https://spdx.org/licenses/ISC-Veillard.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://raw.githubusercontent.com/GNOME/libxml2/4c2e7c651f6c2f0d1a74f350cbda95f7df3e7017/hash.c",
			"https://github.com/GNOME/libxml2/blob/master/dict.c",
		},
		OSIApproved: false,
	},
	"imagemagick": {
		ID:              "ImageMagick",
		Name:            "ImageMagick License",
		Reference:       "https://spdx.org/licenses/ImageMagick.html",
		ReferenceNumber: 557,
		DetailsURL:      "https://spdx.org/licenses/ImageMagick.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.imagemagick.org/script/license.php",
		},
		OSIApproved: false,
	},
	"imlib2": {
		ID:              "Imlib2",
		Name:            "Imlib2 License",
		Reference:       "https://spdx.org/licenses/Imlib2.html",
		ReferenceNumber: 280,
		DetailsURL:      "https://spdx.org/licenses/Imlib2.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://trac.enlightenment.org/e/browser/trunk/imlib2/COPYING",
			"https://git.enlightenment.org/legacy/imlib2.git/tree/COPYING",
		},
		OSIApproved: false,
	},
	"info-zip": {
		ID:              "Info-ZIP",
		Name:            "Info-ZIP License",
		Reference:       "https://spdx.org/licenses/Info-ZIP.html",
		ReferenceNumber: 136,
		DetailsURL:      "https://spdx.org/licenses/Info-ZIP.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.info-zip.org/license.html",
		},
		OSIApproved: false,
	},
	"inner-net-2.0": {
		ID:              "Inner-Net-2.0",
		Name:            "Inner Net License v2.0",
		Reference:       "https://spdx.org/licenses/Inner-Net-2.0.html",
		ReferenceNumber: 277,
		DetailsURL:      "https://spdx.org/licenses/Inner-Net-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Inner_Net_License",
			"https://sourceware.org/git/?p=glibc.git;a=blob;f=LICENSES;h=530893b1dc9ea00755603c68fb36bd4fc38a7be8;hb=HEAD#l207",
		},
		OSIApproved: false,
	},
	"intel": {
		ID:              "Intel",
		Name:            "Intel Open Source License",
		Reference:       "https://spdx.org/licenses/Intel.html",
		ReferenceNumber: 187,
		DetailsURL:      "https://spdx.org/licenses/Intel.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/Intel",
		},
		OSIApproved: true,
	},
	"intel-acpi": {
		ID:              "Intel-ACPI",
		Name:            "Intel ACPI Software License Agreement",
		Reference:       "https://spdx.org/licenses/Intel-ACPI.html",
		ReferenceNumber: 554,
		DetailsURL:      "https://spdx.org/licenses/Intel-ACPI.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Intel_ACPI_Software_License_Agreement",
		},
		OSIApproved: false,
	},
	"interbase-1.0": {
		ID:              "Interbase-1.0",
		Name:            "Interbase Public License v1.0",
		Reference:       "https://spdx.org/licenses/Interbase-1.0.html",
		ReferenceNumber: 632,
		DetailsURL:      "https://spdx.org/licenses/Interbase-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://web.archive.org/web/20060319014854/http://info.borland.com/devsupport/interbase/opensource/IPL.html",
		},
		OSIApproved: false,
	},
	"jpl-image": {
		ID:              "JPL-image",
		Name:            "JPL Image Use Policy",
		Reference:       "https://spdx.org/licenses/JPL-image.html",
		ReferenceNumber: 379,
		DetailsURL:      "https://spdx.org/licenses/JPL-image.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.jpl.nasa.gov/jpl-image-use-policy",
		},
		OSIApproved: false,
	},
	"jpnic": {
		ID:              "JPNIC",
		Name:            "Japan Network Information Center License",
		Reference:       "https://spdx.org/licenses/JPNIC.html",
		ReferenceNumber: 103,
		DetailsURL:      "https://spdx.org/licenses/JPNIC.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://gitlab.isc.org/isc-projects/bind9/blob/master/COPYRIGHT#L366",
		},
		OSIApproved: false,
	},
	"json": {
		ID:              "JSON",
		Name:            "JSON License",
		Reference:       "https://spdx.org/licenses/JSON.html",
		ReferenceNumber: 219,
		DetailsURL:      "https://spdx.org/licenses/JSON.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.json.org/license.html",
		},
		OSIApproved: false,
	},
	"jam": {
		ID:              "Jam",
		Name:            "Jam License",
		Reference:       "https://spdx.org/licenses/Jam.html",
		ReferenceNumber: 4,
		DetailsURL:      "https://spdx.org/licenses/Jam.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.boost.org/doc/libs/1_35_0/doc/html/jam.html",
			"https://web.archive.org/web/20160330173339/https://swarm.workshop.perforce.com/files/guest/perforce_software/jam/src/README",
		},
		OSIApproved: true,
	},
	"jasper-2.0": {
		ID:              "JasPer-2.0",
		Name:            "JasPer License",
		Reference:       "https://spdx.org/licenses/JasPer-2.0.html",
		ReferenceNumber: 593,
		DetailsURL:      "https://spdx.org/licenses/JasPer-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.ece.uvic.ca/~mdadams/jasper/LICENSE",
		},
		OSIApproved: false,
	},
	"kastrup": {
		ID:              "Kastrup",
		Name:            "Kastrup License",
		Reference:       "https://spdx.org/licenses/Kastrup.html",
		ReferenceNumber: 406,
		DetailsURL:      "https://spdx.org/licenses/Kastrup.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://ctan.math.utah.edu/ctan/tex-archive/macros/generic/kastrup/binhex.dtx",
		},
		OSIApproved: false,
	},
	"kazlib": {
		ID:              "Kazlib",
		Name:            "Kazlib License",
		Reference:       "https://spdx.org/licenses/Kazlib.html",
		ReferenceNumber: 257,
		DetailsURL:      "https://spdx.org/licenses/Kazlib.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://git.savannah.gnu.org/cgit/kazlib.git/tree/except.c?id=0062df360c2d17d57f6af19b0e444c51feb99036",
		},
		OSIApproved: false,
	},
	"knuth-ctan": {
		ID:              "Knuth-CTAN",
		Name:            "Knuth CTAN License",
		Reference:       "https://spdx.org/licenses/Knuth-CTAN.html",
		ReferenceNumber: 514,
		DetailsURL:      "https://spdx.org/licenses/Knuth-CTAN.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://ctan.org/license/knuth",
		},
		OSIApproved: false,
	},
	"lal-1.2": {
		ID:              "LAL-1.2",
		Name:            "Licence Art Libre 1.2",
		Reference:       "https://spdx.org/licenses/LAL-1.2.html",
		ReferenceNumber: 621,
		DetailsURL:      "https://spdx.org/licenses/LAL-1.2.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://artlibre.org/licence/lal/licence-art-libre-12/",
		},
		OSIApproved: false,
	},
	"lal-1.3": {
		ID:              "LAL-1.3",
		Name:            "Licence Art Libre 1.3",
		Reference:       "https://spdx.org/licenses/LAL-1.3.html",
		ReferenceNumber: 182,
		DetailsURL:      "https://spdx.org/licenses/LAL-1.3.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://artlibre.org/",
		},
		OSIApproved: false,
	},
	"lgpl-2.0": {
		ID:              "LGPL-2.0",
		Name:            "GNU Library General Public License v2 only",
		Reference:       "https://spdx.org/licenses/LGPL-2.0.html",
		ReferenceNumber: 452,
		DetailsURL:      "https://spdx.org/licenses/LGPL-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html",
		},
		OSIApproved: true,
	},
	"lgpl-2.0+": {
		ID:              "LGPL-2.0+",
		Name:            "GNU Library General Public License v2 or later",
		Reference:       "https://spdx.org/licenses/LGPL-2.0+.html",
		ReferenceNumber: 342,
		DetailsURL:      "https://spdx.org/licenses/LGPL-2.0+.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html",
		},
		OSIApproved: true,
	},
	"lgpl-2.0-only": {
		ID:              "LGPL-2.0-only",
		Name:            "GNU Library General Public License v2 only",
		Reference:       "https://spdx.org/licenses/LGPL-2.0-only.html",
		ReferenceNumber: 563,
		DetailsURL:      "https://spdx.org/licenses/LGPL-2.0-only.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html",
		},
		OSIApproved: true,
	},
	"lgpl-2.0-or-later": {
		ID:              "LGPL-2.0-or-later",
		Name:            "GNU Library General Public License v2 or later",
		Reference:       "https://spdx.org/licenses/LGPL-2.0-or-later.html",
		ReferenceNumber: 575,
		DetailsURL:      "https://spdx.org/licenses/LGPL-2.0-or-later.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/lgpl-2.0-standalone.html",
		},
		OSIApproved: true,
	},
	"lgpl-2.1": {
		ID:              "LGPL-2.1",
		Name:            "GNU Lesser General Public License v2.1 only",
		Reference:       "https://spdx.org/licenses/LGPL-2.1.html",
		ReferenceNumber: 394,
		DetailsURL:      "https://spdx.org/licenses/LGPL-2.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html",
			"https://opensource.org/licenses/LGPL-2.1",
		},
		OSIApproved: true,
	},
	"lgpl-2.1+": {
		ID:              "LGPL-2.1+",
		Name:            "GNU Lesser General Public License v2.1 or later",
		Reference:       "https://spdx.org/licenses/LGPL-2.1+.html",
		ReferenceNumber: 12,
		DetailsURL:      "https://spdx.org/licenses/LGPL-2.1+.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html",
			"https://opensource.org/licenses/LGPL-2.1",
		},
		OSIApproved: true,
	},
	"lgpl-2.1-only": {
		ID:              "LGPL-2.1-only",
		Name:            "GNU Lesser General Public License v2.1 only",
		Reference:       "https://spdx.org/licenses/LGPL-2.1-only.html",
		ReferenceNumber: 180,
		DetailsURL:      "https://spdx.org/licenses/LGPL-2.1-only.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html",
			"https://opensource.org/licenses/LGPL-2.1",
		},
		OSIApproved: true,
	},
	"lgpl-2.1-or-later": {
		ID:              "LGPL-2.1-or-later",
		Name:            "GNU Lesser General Public License v2.1 or later",
		Reference:       "https://spdx.org/licenses/LGPL-2.1-or-later.html",
		ReferenceNumber: 422,
		DetailsURL:      "https://spdx.org/licenses/LGPL-2.1-or-later.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/old-licenses/lgpl-2.1-standalone.html",
			"https://opensource.org/licenses/LGPL-2.1",
		},
		OSIApproved: true,
	},
	"lgpl-3.0": {
		ID:              "LGPL-3.0",
		Name:            "GNU Lesser General Public License v3.0 only",
		Reference:       "https://spdx.org/licenses/LGPL-3.0.html",
		ReferenceNumber: 636,
		DetailsURL:      "https://spdx.org/licenses/LGPL-3.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/lgpl-3.0-standalone.html",
			"https://www.gnu.org/licenses/lgpl+gpl-3.0.txt",
			"https://opensource.org/licenses/LGPL-3.0",
		},
		OSIApproved: true,
	},
	"lgpl-3.0+": {
		ID:              "LGPL-3.0+",
		Name:            "GNU Lesser General Public License v3.0 or later",
		Reference:       "https://spdx.org/licenses/LGPL-3.0+.html",
		ReferenceNumber: 255,
		DetailsURL:      "https://spdx.org/licenses/LGPL-3.0+.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/lgpl-3.0-standalone.html",
			"https://www.gnu.org/licenses/lgpl+gpl-3.0.txt",
			"https://opensource.org/licenses/LGPL-3.0",
		},
		OSIApproved: true,
	},
	"lgpl-3.0-only": {
		ID:              "LGPL-3.0-only",
		Name:            "GNU Lesser General Public License v3.0 only",
		Reference:       "https://spdx.org/licenses/LGPL-3.0-only.html",
		ReferenceNumber: 83,
		DetailsURL:      "https://spdx.org/licenses/LGPL-3.0-only.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/lgpl-3.0-standalone.html",
			"https://www.gnu.org/licenses/lgpl+gpl-3.0.txt",
			"https://opensource.org/licenses/LGPL-3.0",
		},
		OSIApproved: true,
	},
	"lgpl-3.0-or-later": {
		ID:              "LGPL-3.0-or-later",
		Name:            "GNU Lesser General Public License v3.0 or later",
		Reference:       "https://spdx.org/licenses/LGPL-3.0-or-later.html",
		ReferenceNumber: 396,
		DetailsURL:      "https://spdx.org/licenses/LGPL-3.0-or-later.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/lgpl-3.0-standalone.html",
			"https://www.gnu.org/licenses/lgpl+gpl-3.0.txt",
			"https://opensource.org/licenses/LGPL-3.0",
		},
		OSIApproved: true,
	},
	"lgpllr": {
		ID:              "LGPLLR",
		Name:            "Lesser General Public License For Linguistic Resources",
		Reference:       "https://spdx.org/licenses/LGPLLR.html",
		ReferenceNumber: 135,
		DetailsURL:      "https://spdx.org/licenses/LGPLLR.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www-igm.univ-mlv.fr/~unitex/lgpllr.html",
		},
		OSIApproved: false,
	},
	"loop": {
		ID:              "LOOP",
		Name:            "Common Lisp LOOP License",
		Reference:       "https://spdx.org/licenses/LOOP.html",
		ReferenceNumber: 263,
		DetailsURL:      "https://spdx.org/licenses/LOOP.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://gitlab.com/embeddable-common-lisp/ecl/-/blob/develop/src/lsp/loop.lsp",
			"http://git.savannah.gnu.org/cgit/gcl.git/tree/gcl/lsp/gcl_loop.lsp?h=Version_2_6_13pre",
			"https://sourceforge.net/p/sbcl/sbcl/ci/master/tree/src/code/loop.lisp",
			"https://github.com/cl-adams/adams/blob/master/LICENSE.md",
			"https://github.com/blakemcbride/eclipse-lisp/blob/master/lisp/loop.lisp",
			"https://gitlab.common-lisp.net/cmucl/cmucl/-/blob/master/src/code/loop.lisp",
		},
		OSIApproved: false,
	},
	"lpd-document": {
		ID:              "LPD-document",
		Name:            "LPD Documentation License",
		Reference:       "https://spdx.org/licenses/LPD-document.html",
		ReferenceNumber: 271,
		DetailsURL:      "https://spdx.org/licenses/LPD-document.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/Cyan4973/xxHash/blob/dev/doc/xxhash_spec.md",
			"https://www.ietf.org/rfc/rfc1952.txt",
		},
		OSIApproved: false,
	},
	"lpl-1.0": {
		ID:              "LPL-1.0",
		Name:            "Lucent Public License Version 1.0",
		Reference:       "https://spdx.org/licenses/LPL-1.0.html",
		ReferenceNumber: 468,
		DetailsURL:      "https://spdx.org/licenses/LPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/LPL-1.0",
		},
		OSIApproved: true,
	},
	"lpl-1.02": {
		ID:              "LPL-1.02",
		Name:            "Lucent Public License v1.02",
		Reference:       "https://spdx.org/licenses/LPL-1.02.html",
		ReferenceNumber: 436,
		DetailsURL:      "https://spdx.org/licenses/LPL-1.02.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://plan9.bell-labs.com/plan9/license.html",
			"https://opensource.org/licenses/LPL-1.02",
		},
		OSIApproved: true,
	},
	"lppl-1.0": {
		ID:              "LPPL-1.0",
		Name:            "LaTeX Project Public License v1.0",
		Reference:       "https://spdx.org/licenses/LPPL-1.0.html",
		ReferenceNumber: 112,
		DetailsURL:      "https://spdx.org/licenses/LPPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.latex-project.org/lppl/lppl-1-0.txt",
		},
		OSIApproved: false,
	},
	"lppl-1.1": {
		ID:              "LPPL-1.1",
		Name:            "LaTeX Project Public License v1.1",
		Reference:       "https://spdx.org/licenses/LPPL-1.1.html",
		ReferenceNumber: 386,
		DetailsURL:      "https://spdx.org/licenses/LPPL-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.latex-project.org/lppl/lppl-1-1.txt",
		},
		OSIApproved: false,
	},
	"lppl-1.2": {
		ID:              "LPPL-1.2",
		Name:            "LaTeX Project Public License v1.2",
		Reference:       "https://spdx.org/licenses/LPPL-1.2.html",
		ReferenceNumber: 517,
		DetailsURL:      "https://spdx.org/licenses/LPPL-1.2.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.latex-project.org/lppl/lppl-1-2.txt",
		},
		OSIApproved: false,
	},
	"lppl-1.3a": {
		ID:              "LPPL-1.3a",
		Name:            "LaTeX Project Public License v1.3a",
		Reference:       "https://spdx.org/licenses/LPPL-1.3a.html",
		ReferenceNumber: 478,
		DetailsURL:      "https://spdx.org/licenses/LPPL-1.3a.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.latex-project.org/lppl/lppl-1-3a.txt",
		},
		OSIApproved: false,
	},
	"lppl-1.3c": {
		ID:              "LPPL-1.3c",
		Name:            "LaTeX Project Public License v1.3c",
		Reference:       "https://spdx.org/licenses/LPPL-1.3c.html",
		ReferenceNumber: 85,
		DetailsURL:      "https://spdx.org/licenses/LPPL-1.3c.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.latex-project.org/lppl/lppl-1-3c.txt",
			"https://opensource.org/licenses/LPPL-1.3c",
		},
		OSIApproved: true,
	},
	"lzma-sdk-9.11-to-9.20": {
		ID:              "LZMA-SDK-9.11-to-9.20",
		Name:            "LZMA SDK License (versions 9.11 to 9.20)",
		Reference:       "https://spdx.org/licenses/LZMA-SDK-9.11-to-9.20.html",
		ReferenceNumber: 378,
		DetailsURL:      "https://spdx.org/licenses/LZMA-SDK-9.11-to-9.20.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.7-zip.org/sdk.html",
			"https://sourceforge.net/projects/sevenzip/files/LZMA%20SDK/",
		},
		OSIApproved: false,
	},
	"lzma-sdk-9.22": {
		ID:              "LZMA-SDK-9.22",
		Name:            "LZMA SDK License (versions 9.22 and beyond)",
		Reference:       "https://spdx.org/licenses/LZMA-SDK-9.22.html",
		ReferenceNumber: 253,
		DetailsURL:      "https://spdx.org/licenses/LZMA-SDK-9.22.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.7-zip.org/sdk.html",
			"https://sourceforge.net/projects/sevenzip/files/LZMA%20SDK/",
		},
		OSIApproved: false,
	},
	"latex2e": {
		ID:              "Latex2e",
		Name:            "Latex2e License",
		Reference:       "https://spdx.org/licenses/Latex2e.html",
		ReferenceNumber: 254,
		DetailsURL:      "https://spdx.org/licenses/Latex2e.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Latex2e",
		},
		OSIApproved: false,
	},
	"latex2e-translated-notice": {
		ID:              "Latex2e-translated-notice",
		Name:            "Latex2e with translated notice permission",
		Reference:       "https://spdx.org/licenses/Latex2e-translated-notice.html",
		ReferenceNumber: 435,
		DetailsURL:      "https://spdx.org/licenses/Latex2e-translated-notice.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://git.savannah.gnu.org/cgit/indent.git/tree/doc/indent.texi?id=a74c6b4ee49397cf330b333da1042bffa60ed14f#n74",
		},
		OSIApproved: false,
	},
	"leptonica": {
		ID:              "Leptonica",
		Name:            "Leptonica License",
		Reference:       "https://spdx.org/licenses/Leptonica.html",
		ReferenceNumber: 294,
		DetailsURL:      "https://spdx.org/licenses/Leptonica.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Leptonica",
		},
		OSIApproved: false,
	},
	"liliq-p-1.1": {
		ID:              "LiLiQ-P-1.1",
		Name:            "Licence Libre du Québec – Permissive version 1.1",
		Reference:       "https://spdx.org/licenses/LiLiQ-P-1.1.html",
		ReferenceNumber: 534,
		DetailsURL:      "https://spdx.org/licenses/LiLiQ-P-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://forge.gouv.qc.ca/licence/fr/liliq-v1-1/",
			"http://opensource.org/licenses/LiLiQ-P-1.1",
		},
		OSIApproved: true,
	},
	"liliq-r-1.1": {
		ID:              "LiLiQ-R-1.1",
		Name:            "Licence Libre du Québec – Réciprocité version 1.1",
		Reference:       "https://spdx.org/licenses/LiLiQ-R-1.1.html",
		ReferenceNumber: 65,
		DetailsURL:      "https://spdx.org/licenses/LiLiQ-R-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-liliq-r-v1-1/",
			"http://opensource.org/licenses/LiLiQ-R-1.1",
		},
		OSIApproved: true,
	},
	"liliq-rplus-1.1": {
		ID:              "LiLiQ-Rplus-1.1",
		Name:            "Licence Libre du Québec – Réciprocité forte version 1.1",
		Reference:       "https://spdx.org/licenses/LiLiQ-Rplus-1.1.html",
		ReferenceNumber: 500,
		DetailsURL:      "https://spdx.org/licenses/LiLiQ-Rplus-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.forge.gouv.qc.ca/participez/licence-logicielle/licence-libre-du-quebec-liliq-en-francais/licence-libre-du-quebec-reciprocite-forte-liliq-r-v1-1/",
			"http://opensource.org/licenses/LiLiQ-Rplus-1.1",
		},
		OSIApproved: true,
	},
	"libpng": {
		ID:              "Libpng",
		Name:            "libpng License",
		Reference:       "https://spdx.org/licenses/Libpng.html",
		ReferenceNumber: 140,
		DetailsURL:      "https://spdx.org/licenses/Libpng.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.libpng.org/pub/png/src/libpng-LICENSE.txt",
		},
		OSIApproved: false,
	},
	"linux-openib": {
		ID:              "Linux-OpenIB",
		Name:            "Linux Kernel Variant of OpenIB.org license",
		Reference:       "https://spdx.org/licenses/Linux-OpenIB.html",
		ReferenceNumber: 487,
		DetailsURL:      "https://spdx.org/licenses/Linux-OpenIB.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/tree/drivers/infiniband/core/sa.h",
		},
		OSIApproved: false,
	},
	"linux-man-pages-1-para": {
		ID:              "Linux-man-pages-1-para",
		Name:            "Linux man-pages - 1 paragraph",
		Reference:       "https://spdx.org/licenses/Linux-man-pages-1-para.html",
		ReferenceNumber: 188,
		DetailsURL:      "https://spdx.org/licenses/Linux-man-pages-1-para.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://git.kernel.org/pub/scm/docs/man-pages/man-pages.git/tree/man2/getcpu.2#n4",
		},
		OSIApproved: false,
	},
	"linux-man-pages-copyleft": {
		ID:              "Linux-man-pages-copyleft",
		Name:            "Linux man-pages Copyleft",
		Reference:       "https://spdx.org/licenses/Linux-man-pages-copyleft.html",
		ReferenceNumber: 496,
		DetailsURL:      "https://spdx.org/licenses/Linux-man-pages-copyleft.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.kernel.org/doc/man-pages/licenses.html",
		},
		OSIApproved: false,
	},
	"linux-man-pages-copyleft-2-para": {
		ID:              "Linux-man-pages-copyleft-2-para",
		Name:            "Linux man-pages Copyleft - 2 paragraphs",
		Reference:       "https://spdx.org/licenses/Linux-man-pages-copyleft-2-para.html",
		ReferenceNumber: 460,
		DetailsURL:      "https://spdx.org/licenses/Linux-man-pages-copyleft-2-para.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://git.kernel.org/pub/scm/docs/man-pages/man-pages.git/tree/man2/move_pages.2#n5",
			"https://git.kernel.org/pub/scm/docs/man-pages/man-pages.git/tree/man2/migrate_pages.2#n8",
		},
		OSIApproved: false,
	},
	"linux-man-pages-copyleft-var": {
		ID:              "Linux-man-pages-copyleft-var",
		Name:            "Linux man-pages Copyleft Variant",
		Reference:       "https://spdx.org/licenses/Linux-man-pages-copyleft-var.html",
		ReferenceNumber: 105,
		DetailsURL:      "https://spdx.org/licenses/Linux-man-pages-copyleft-var.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://git.kernel.org/pub/scm/docs/man-pages/man-pages.git/tree/man2/set_mempolicy.2#n5",
		},
		OSIApproved: false,
	},
	"lucida-bitmap-fonts": {
		ID:              "Lucida-Bitmap-Fonts",
		Name:            "Lucida Bitmap Fonts License",
		Reference:       "https://spdx.org/licenses/Lucida-Bitmap-Fonts.html",
		ReferenceNumber: 62,
		DetailsURL:      "https://spdx.org/licenses/Lucida-Bitmap-Fonts.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://gitlab.freedesktop.org/xorg/font/bh-100dpi/-/blob/master/COPYING?ref_type=heads",
		},
		OSIApproved: false,
	},
	"mit": {
		ID:              "MIT",
		Name:            "MIT License",
		Reference:       "https://spdx.org/licenses/MIT.html",
		ReferenceNumber: 124,
		DetailsURL:      "https://spdx.org/licenses/MIT.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/license/mit/",
		},
		OSIApproved: true,
	},
	"mit-0": {
		ID:              "MIT-0",
		Name:            "MIT No Attribution",
		Reference:       "https://spdx.org/licenses/MIT-0.html",
		ReferenceNumber: 238,
		DetailsURL:      "https://spdx.org/licenses/MIT-0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/aws/mit-0",
			"https://romanrm.net/mit-zero",
			"https://github.com/awsdocs/aws-cloud9-user-guide/blob/master/LICENSE-SAMPLECODE",
		},
		OSIApproved: true,
	},
	"mit-cmu": {
		ID:              "MIT-CMU",
		Name:            "CMU License",
		Reference:       "https://spdx.org/licenses/MIT-CMU.html",
		ReferenceNumber: 415,
		DetailsURL:      "https://spdx.org/licenses/MIT-CMU.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing:MIT?rd=Licensing/MIT#CMU_Style",
			"https://github.com/python-pillow/Pillow/blob/fffb426092c8db24a5f4b6df243a8a3c01fb63cd/LICENSE",
		},
		OSIApproved: false,
	},
	"mit-festival": {
		ID:              "MIT-Festival",
		Name:            "MIT Festival Variant",
		Reference:       "https://spdx.org/licenses/MIT-Festival.html",
		ReferenceNumber: 595,
		DetailsURL:      "https://spdx.org/licenses/MIT-Festival.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/festvox/flite/blob/master/COPYING",
			"https://github.com/festvox/speech_tools/blob/master/COPYING",
		},
		OSIApproved: false,
	},
	"mit-modern-variant": {
		ID:              "MIT-Modern-Variant",
		Name:            "MIT License Modern Variant",
		Reference:       "https://spdx.org/licenses/MIT-Modern-Variant.html",
		ReferenceNumber: 44,
		DetailsURL:      "https://spdx.org/licenses/MIT-Modern-Variant.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing:MIT#Modern_Variants",
			"https://ptolemy.berkeley.edu/copyright.htm",
			"https://pirlwww.lpl.arizona.edu/resources/guide/software/PerlTk/Tixlic.html",
		},
		OSIApproved: true,
	},
	"mit-wu": {
		ID:              "MIT-Wu",
		Name:            "MIT Tom Wu Variant",
		Reference:       "https://spdx.org/licenses/MIT-Wu.html",
		ReferenceNumber: 608,
		DetailsURL:      "https://spdx.org/licenses/MIT-Wu.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/chromium/octane/blob/master/crypto.js",
		},
		OSIApproved: false,
	},
	"mit-advertising": {
		ID:              "MIT-advertising",
		Name:            "Enlightenment License (e16)",
		Reference:       "https://spdx.org/licenses/MIT-advertising.html",
		ReferenceNumber: 77,
		DetailsURL:      "https://spdx.org/licenses/MIT-advertising.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/MIT_With_Advertising",
		},
		OSIApproved: false,
	},
	"mit-enna": {
		ID:              "MIT-enna",
		Name:            "enna License",
		Reference:       "https://spdx.org/licenses/MIT-enna.html",
		ReferenceNumber: 129,
		DetailsURL:      "https://spdx.org/licenses/MIT-enna.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/MIT#enna",
		},
		OSIApproved: false,
	},
	"mit-feh": {
		ID:              "MIT-feh",
		Name:            "feh License",
		Reference:       "https://spdx.org/licenses/MIT-feh.html",
		ReferenceNumber: 37,
		DetailsURL:      "https://spdx.org/licenses/MIT-feh.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/MIT#feh",
		},
		OSIApproved: false,
	},
	"mit-open-group": {
		ID:              "MIT-open-group",
		Name:            "MIT Open Group variant",
		Reference:       "https://spdx.org/licenses/MIT-open-group.html",
		ReferenceNumber: 543,
		DetailsURL:      "https://spdx.org/licenses/MIT-open-group.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://gitlab.freedesktop.org/xorg/app/iceauth/-/blob/master/COPYING",
			"https://gitlab.freedesktop.org/xorg/app/xvinfo/-/blob/master/COPYING",
			"https://gitlab.freedesktop.org/xorg/app/xsetroot/-/blob/master/COPYING",
			"https://gitlab.freedesktop.org/xorg/app/xauth/-/blob/master/COPYING",
		},
		OSIApproved: false,
	},
	"mit-testregex": {
		ID:              "MIT-testregex",
		Name:            "MIT testregex Variant",
		Reference:       "https://spdx.org/licenses/MIT-testregex.html",
		ReferenceNumber: 250,
		DetailsURL:      "https://spdx.org/licenses/MIT-testregex.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/dotnet/runtime/blob/55e1ac7c07df62c4108d4acedf78f77574470ce5/src/libraries/System.Text.RegularExpressions/tests/FunctionalTests/AttRegexTests.cs#L12-L28",
		},
		OSIApproved: false,
	},
	"mitnfa": {
		ID:              "MITNFA",
		Name:            "MIT +no-false-attribs license",
		Reference:       "https://spdx.org/licenses/MITNFA.html",
		ReferenceNumber: 526,
		DetailsURL:      "https://spdx.org/licenses/MITNFA.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/MITNFA",
		},
		OSIApproved: false,
	},
	"mmixware": {
		ID:              "MMIXware",
		Name:            "MMIXware License",
		Reference:       "https://spdx.org/licenses/MMIXware.html",
		ReferenceNumber: 252,
		DetailsURL:      "https://spdx.org/licenses/MMIXware.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://gitlab.lrz.de/mmix/mmixware/-/blob/master/boilerplate.w",
		},
		OSIApproved: false,
	},
	"mpeg-ssg": {
		ID:              "MPEG-SSG",
		Name:            "MPEG Software Simulation",
		Reference:       "https://spdx.org/licenses/MPEG-SSG.html",
		ReferenceNumber: 202,
		DetailsURL:      "https://spdx.org/licenses/MPEG-SSG.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://sourceforge.net/p/netpbm/code/HEAD/tree/super_stable/converter/ppm/ppmtompeg/jrevdct.c#l1189",
		},
		OSIApproved: false,
	},
	"mpl-1.0": {
		ID:              "MPL-1.0",
		Name:            "Mozilla Public License 1.0",
		Reference:       "https://spdx.org/licenses/MPL-1.0.html",
		ReferenceNumber: 499,
		DetailsURL:      "https://spdx.org/licenses/MPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.mozilla.org/MPL/MPL-1.0.html",
			"https://opensource.org/licenses/MPL-1.0",
		},
		OSIApproved: true,
	},
	"mpl-1.1": {
		ID:              "MPL-1.1",
		Name:            "Mozilla Public License 1.1",
		Reference:       "https://spdx.org/licenses/MPL-1.1.html",
		ReferenceNumber: 183,
		DetailsURL:      "https://spdx.org/licenses/MPL-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.mozilla.org/MPL/MPL-1.1.html",
			"https://opensource.org/licenses/MPL-1.1",
		},
		OSIApproved: true,
	},
	"mpl-2.0": {
		ID:              "MPL-2.0",
		Name:            "Mozilla Public License 2.0",
		Reference:       "https://spdx.org/licenses/MPL-2.0.html",
		ReferenceNumber: 573,
		DetailsURL:      "https://spdx.org/licenses/MPL-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.mozilla.org/MPL/2.0/",
			"https://opensource.org/licenses/MPL-2.0",
		},
		OSIApproved: true,
	},
	"mpl-2.0-no-copyleft-exception": {
		ID:              "MPL-2.0-no-copyleft-exception",
		Name:            "Mozilla Public License 2.0 (no copyleft exception)",
		Reference:       "https://spdx.org/licenses/MPL-2.0-no-copyleft-exception.html",
		ReferenceNumber: 397,
		DetailsURL:      "https://spdx.org/licenses/MPL-2.0-no-copyleft-exception.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.mozilla.org/MPL/2.0/",
			"https://opensource.org/licenses/MPL-2.0",
		},
		OSIApproved: true,
	},
	"ms-lpl": {
		ID:              "MS-LPL",
		Name:            "Microsoft Limited Public License",
		Reference:       "https://spdx.org/licenses/MS-LPL.html",
		ReferenceNumber: 199,
		DetailsURL:      "https://spdx.org/licenses/MS-LPL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.openhub.net/licenses/mslpl",
			"https://github.com/gabegundy/atlserver/blob/master/License.txt",
			"https://en.wikipedia.org/wiki/Shared_Source_Initiative#Microsoft_Limited_Public_License_(Ms-LPL)",
		},
		OSIApproved: false,
	},
	"ms-pl": {
		ID:              "MS-PL",
		Name:            "Microsoft Public License",
		Reference:       "https://spdx.org/licenses/MS-PL.html",
		ReferenceNumber: 485,
		DetailsURL:      "https://spdx.org/licenses/MS-PL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.microsoft.com/opensource/licenses.mspx",
			"https://opensource.org/licenses/MS-PL",
		},
		OSIApproved: true,
	},
	"ms-rl": {
		ID:              "MS-RL",
		Name:            "Microsoft Reciprocal License",
		Reference:       "https://spdx.org/licenses/MS-RL.html",
		ReferenceNumber: 284,
		DetailsURL:      "https://spdx.org/licenses/MS-RL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.microsoft.com/opensource/licenses.mspx",
			"https://opensource.org/licenses/MS-RL",
		},
		OSIApproved: true,
	},
	"mtll": {
		ID:              "MTLL",
		Name:            "Matrix Template Library License",
		Reference:       "https://spdx.org/licenses/MTLL.html",
		ReferenceNumber: 387,
		DetailsURL:      "https://spdx.org/licenses/MTLL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Matrix_Template_Library_License",
		},
		OSIApproved: false,
	},
	"mackerras-3-clause": {
		ID:              "Mackerras-3-Clause",
		Name:            "Mackerras 3-Clause License",
		Reference:       "https://spdx.org/licenses/Mackerras-3-Clause.html",
		ReferenceNumber: 42,
		DetailsURL:      "https://spdx.org/licenses/Mackerras-3-Clause.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/ppp-project/ppp/blob/master/pppd/chap_ms.c#L6-L28",
		},
		OSIApproved: false,
	},
	"mackerras-3-clause-acknowledgment": {
		ID:              "Mackerras-3-Clause-acknowledgment",
		Name:            "Mackerras 3-Clause - acknowledgment variant",
		Reference:       "https://spdx.org/licenses/Mackerras-3-Clause-acknowledgment.html",
		ReferenceNumber: 605,
		DetailsURL:      "https://spdx.org/licenses/Mackerras-3-Clause-acknowledgment.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/ppp-project/ppp/blob/master/pppd/auth.c#L6-L28",
		},
		OSIApproved: false,
	},
	"makeindex": {
		ID:              "MakeIndex",
		Name:            "MakeIndex License",
		Reference:       "https://spdx.org/licenses/MakeIndex.html",
		ReferenceNumber: 22,
		DetailsURL:      "https://spdx.org/licenses/MakeIndex.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/MakeIndex",
		},
		OSIApproved: false,
	},
	"martin-birgmeier": {
		ID:              "Martin-Birgmeier",
		Name:            "Martin Birgmeier License",
		Reference:       "https://spdx.org/licenses/Martin-Birgmeier.html",
		ReferenceNumber: 382,
		DetailsURL:      "https://spdx.org/licenses/Martin-Birgmeier.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/Perl/perl5/blob/blead/util.c#L6136",
		},
		OSIApproved: false,
	},
	"mcphee-slideshow": {
		ID:              "McPhee-slideshow",
		Name:            "McPhee Slideshow License",
		Reference:       "https://spdx.org/licenses/McPhee-slideshow.html",
		ReferenceNumber: 288,
		DetailsURL:      "https://spdx.org/licenses/McPhee-slideshow.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://mirror.las.iastate.edu/tex-archive/graphics/metapost/contrib/macros/slideshow/slideshow.mp",
		},
		OSIApproved: false,
	},
	"minpack": {
		ID:              "Minpack",
		Name:            "Minpack License",
		Reference:       "https://spdx.org/licenses/Minpack.html",
		ReferenceNumber: 179,
		DetailsURL:      "https://spdx.org/licenses/Minpack.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.netlib.org/minpack/disclaimer",
			"https://gitlab.com/libeigen/eigen/-/blob/master/COPYING.MINPACK",
		},
		OSIApproved: false,
	},
	"miros": {
		ID:              "MirOS",
		Name:            "The MirOS Licence",
		Reference:       "https://spdx.org/licenses/MirOS.html",
		ReferenceNumber: 23,
		DetailsURL:      "https://spdx.org/licenses/MirOS.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/MirOS",
		},
		OSIApproved: true,
	},
	"motosoto": {
		ID:              "Motosoto",
		Name:            "Motosoto License",
		Reference:       "https://spdx.org/licenses/Motosoto.html",
		ReferenceNumber: 448,
		DetailsURL:      "https://spdx.org/licenses/Motosoto.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/Motosoto",
		},
		OSIApproved: true,
	},
	"mulanpsl-1.0": {
		ID:              "MulanPSL-1.0",
		Name:            "Mulan Permissive Software License, Version 1",
		Reference:       "https://spdx.org/licenses/MulanPSL-1.0.html",
		ReferenceNumber: 407,
		DetailsURL:      "https://spdx.org/licenses/MulanPSL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://license.coscl.org.cn/MulanPSL/",
			"https://github.com/yuwenlong/longphp/blob/25dfb70cc2a466dc4bb55ba30901cbce08d164b5/LICENSE",
		},
		OSIApproved: false,
	},
	"mulanpsl-2.0": {
		ID:              "MulanPSL-2.0",
		Name:            "Mulan Permissive Software License, Version 2",
		Reference:       "https://spdx.org/licenses/MulanPSL-2.0.html",
		ReferenceNumber: 439,
		DetailsURL:      "https://spdx.org/licenses/MulanPSL-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://license.coscl.org.cn/MulanPSL2",
		},
		OSIApproved: true,
	},
	"multics": {
		ID:              "Multics",
		Name:            "Multics License",
		Reference:       "https://spdx.org/licenses/Multics.html",
		ReferenceNumber: 465,
		DetailsURL:      "https://spdx.org/licenses/Multics.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/Multics",
		},
		OSIApproved: true,
	},
	"mup": {
		ID:              "Mup",
		Name:            "Mup License",
		Reference:       "https://spdx.org/licenses/Mup.html",
		ReferenceNumber: 607,
		DetailsURL:      "https://spdx.org/licenses/Mup.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Mup",
		},
		OSIApproved: false,
	},
	"naist-2003": {
		ID:              "NAIST-2003",
		Name:            "Nara Institute of Science and Technology License (2003)",
		Reference:       "https://spdx.org/licenses/NAIST-2003.html",
		ReferenceNumber: 265,
		DetailsURL:      "https://spdx.org/licenses/NAIST-2003.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://enterprise.dejacode.com/licenses/public/naist-2003/#license-text",
			"https://github.com/nodejs/node/blob/4a19cc8947b1bba2b2d27816ec3d0edf9b28e503/LICENSE#L343",
		},
		OSIApproved: false,
	},
	"nasa-1.3": {
		ID:              "NASA-1.3",
		Name:            "NASA Open Source Agreement 1.3",
		Reference:       "https://spdx.org/licenses/NASA-1.3.html",
		ReferenceNumber: 507,
		DetailsURL:      "https://spdx.org/licenses/NASA-1.3.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://ti.arc.nasa.gov/opensource/nosa/",
			"https://opensource.org/licenses/NASA-1.3",
		},
		OSIApproved: true,
	},
	"nbpl-1.0": {
		ID:              "NBPL-1.0",
		Name:            "Net Boolean Public License v1",
		Reference:       "https://spdx.org/licenses/NBPL-1.0.html",
		ReferenceNumber: 61,
		DetailsURL:      "https://spdx.org/licenses/NBPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=37b4b3f6cc4bf34e1d3dec61e69914b9819d8894",
		},
		OSIApproved: false,
	},
	"ncgl-uk-2.0": {
		ID:              "NCGL-UK-2.0",
		Name:            "Non-Commercial Government Licence",
		Reference:       "https://spdx.org/licenses/NCGL-UK-2.0.html",
		ReferenceNumber: 443,
		DetailsURL:      "https://spdx.org/licenses/NCGL-UK-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.nationalarchives.gov.uk/doc/non-commercial-government-licence/version/2/",
		},
		OSIApproved: false,
	},
	"ncsa": {
		ID:              "NCSA",
		Name:            "University of Illinois/NCSA Open Source License",
		Reference:       "https://spdx.org/licenses/NCSA.html",
		ReferenceNumber: 45,
		DetailsURL:      "https://spdx.org/licenses/NCSA.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://otm.illinois.edu/uiuc_openSource",
			"https://opensource.org/licenses/NCSA",
		},
		OSIApproved: true,
	},
	"ngpl": {
		ID:              "NGPL",
		Name:            "Nethack General Public License",
		Reference:       "https://spdx.org/licenses/NGPL.html",
		ReferenceNumber: 248,
		DetailsURL:      "https://spdx.org/licenses/NGPL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/NGPL",
		},
		OSIApproved: true,
	},
	"nicta-1.0": {
		ID:              "NICTA-1.0",
		Name:            "NICTA Public Software License, Version 1.0",
		Reference:       "https://spdx.org/licenses/NICTA-1.0.html",
		ReferenceNumber: 48,
		DetailsURL:      "https://spdx.org/licenses/NICTA-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.apple.com/source/mDNSResponder/mDNSResponder-320.10/mDNSPosix/nss_ReadMe.txt",
		},
		OSIApproved: false,
	},
	"nist-pd": {
		ID:              "NIST-PD",
		Name:            "NIST Public Domain Notice",
		Reference:       "https://spdx.org/licenses/NIST-PD.html",
		ReferenceNumber: 209,
		DetailsURL:      "https://spdx.org/licenses/NIST-PD.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/tcheneau/simpleRPL/blob/e645e69e38dd4e3ccfeceb2db8cba05b7c2e0cd3/LICENSE.txt",
			"https://github.com/tcheneau/Routing/blob/f09f46fcfe636107f22f2c98348188a65a135d98/README.md",
		},
		OSIApproved: false,
	},
	"nist-pd-fallback": {
		ID:              "NIST-PD-fallback",
		Name:            "NIST Public Domain Notice with license fallback",
		Reference:       "https://spdx.org/licenses/NIST-PD-fallback.html",
		ReferenceNumber: 49,
		DetailsURL:      "https://spdx.org/licenses/NIST-PD-fallback.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/usnistgov/jsip/blob/59700e6926cbe96c5cdae897d9a7d2656b42abe3/LICENSE",
			"https://github.com/usnistgov/fipy/blob/86aaa5c2ba2c6f1be19593c5986071cf6568cc34/LICENSE.rst",
		},
		OSIApproved: false,
	},
	"nist-software": {
		ID:              "NIST-Software",
		Name:            "NIST Software License",
		Reference:       "https://spdx.org/licenses/NIST-Software.html",
		ReferenceNumber: 94,
		DetailsURL:      "https://spdx.org/licenses/NIST-Software.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/open-quantum-safe/liboqs/blob/40b01fdbb270f8614fde30e65d30e9da18c02393/src/common/rand/rand_nist.c#L1-L15",
		},
		OSIApproved: false,
	},
	"nlod-1.0": {
		ID:              "NLOD-1.0",
		Name:            "Norwegian Licence for Open Government Data (NLOD) 1.0",
		Reference:       "https://spdx.org/licenses/NLOD-1.0.html",
		ReferenceNumber: 217,
		DetailsURL:      "https://spdx.org/licenses/NLOD-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://data.norge.no/nlod/en/1.0",
		},
		OSIApproved: false,
	},
	"nlod-2.0": {
		ID:              "NLOD-2.0",
		Name:            "Norwegian Licence for Open Government Data (NLOD) 2.0",
		Reference:       "https://spdx.org/licenses/NLOD-2.0.html",
		ReferenceNumber: 373,
		DetailsURL:      "https://spdx.org/licenses/NLOD-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://data.norge.no/nlod/en/2.0",
		},
		OSIApproved: false,
	},
	"nlpl": {
		ID:              "NLPL",
		Name:            "No Limit Public License",
		Reference:       "https://spdx.org/licenses/NLPL.html",
		ReferenceNumber: 66,
		DetailsURL:      "https://spdx.org/licenses/NLPL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/NLPL",
		},
		OSIApproved: false,
	},
	"nosl": {
		ID:              "NOSL",
		Name:            "Netizen Open Source License",
		Reference:       "https://spdx.org/licenses/NOSL.html",
		ReferenceNumber: 1,
		DetailsURL:      "https://spdx.org/licenses/NOSL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://bits.netizen.com.au/licenses/NOSL/nosl.txt",
		},
		OSIApproved: false,
	},
	"npl-1.0": {
		ID:              "NPL-1.0",
		Name:            "Netscape Public License v1.0",
		Reference:       "https://spdx.org/licenses/NPL-1.0.html",
		ReferenceNumber: 210,
		DetailsURL:      "https://spdx.org/licenses/NPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.mozilla.org/MPL/NPL/1.0/",
		},
		OSIApproved: false,
	},
	"npl-1.1": {
		ID:              "NPL-1.1",
		Name:            "Netscape Public License v1.1",
		Reference:       "https://spdx.org/licenses/NPL-1.1.html",
		ReferenceNumber: 337,
		DetailsURL:      "https://spdx.org/licenses/NPL-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.mozilla.org/MPL/NPL/1.1/",
		},
		OSIApproved: false,
	},
	"nposl-3.0": {
		ID:              "NPOSL-3.0",
		Name:            "Non-Profit Open Software License 3.0",
		Reference:       "https://spdx.org/licenses/NPOSL-3.0.html",
		ReferenceNumber: 635,
		DetailsURL:      "https://spdx.org/licenses/NPOSL-3.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/NOSL3.0",
		},
		OSIApproved: true,
	},
	"nrl": {
		ID:              "NRL",
		Name:            "NRL License",
		Reference:       "https://spdx.org/licenses/NRL.html",
		ReferenceNumber: 369,
		DetailsURL:      "https://spdx.org/licenses/NRL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://web.mit.edu/network/isakmp/nrllicense.html",
		},
		OSIApproved: false,
	},
	"ntp": {
		ID:              "NTP",
		Name:            "NTP License",
		Reference:       "https://spdx.org/licenses/NTP.html",
		ReferenceNumber: 470,
		DetailsURL:      "https://spdx.org/licenses/NTP.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/NTP",
		},
		OSIApproved: true,
	},
	"ntp-0": {
		ID:              "NTP-0",
		Name:            "NTP No Attribution",
		Reference:       "https://spdx.org/licenses/NTP-0.html",
		ReferenceNumber: 186,
		DetailsURL:      "https://spdx.org/licenses/NTP-0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/tytso/e2fsprogs/blob/master/lib/et/et_name.c",
		},
		OSIApproved: false,
	},
	"naumen": {
		ID:              "Naumen",
		Name:            "Naumen Public License",
		Reference:       "https://spdx.org/licenses/Naumen.html",
		ReferenceNumber: 221,
		DetailsURL:      "https://spdx.org/licenses/Naumen.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/Naumen",
		},
		OSIApproved: true,
	},
	"net-snmp": {
		ID:              "Net-SNMP",
		Name:            "Net-SNMP License",
		Reference:       "https://spdx.org/licenses/Net-SNMP.html",
		ReferenceNumber: 71,
		DetailsURL:      "https://spdx.org/licenses/Net-SNMP.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://net-snmp.sourceforge.net/about/license.html",
		},
		OSIApproved: false,
	},
	"netcdf": {
		ID:              "NetCDF",
		Name:            "NetCDF license",
		Reference:       "https://spdx.org/licenses/NetCDF.html",
		ReferenceNumber: 119,
		DetailsURL:      "https://spdx.org/licenses/NetCDF.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.unidata.ucar.edu/software/netcdf/copyright.html",
		},
		OSIApproved: false,
	},
	"newsletr": {
		ID:              "Newsletr",
		Name:            "Newsletr License",
		Reference:       "https://spdx.org/licenses/Newsletr.html",
		ReferenceNumber: 616,
		DetailsURL:      "https://spdx.org/licenses/Newsletr.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Newsletr",
		},
		OSIApproved: false,
	},
	"nokia": {
		ID:              "Nokia",
		Name:            "Nokia Open Source License",
		Reference:       "https://spdx.org/licenses/Nokia.html",
		ReferenceNumber: 128,
		DetailsURL:      "https://spdx.org/licenses/Nokia.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/nokia",
		},
		OSIApproved: true,
	},
	"noweb": {
		ID:              "Noweb",
		Name:            "Noweb License",
		Reference:       "https://spdx.org/licenses/Noweb.html",
		ReferenceNumber: 476,
		DetailsURL:      "https://spdx.org/licenses/Noweb.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Noweb",
		},
		OSIApproved: false,
	},
	"nunit": {
		ID:              "Nunit",
		Name:            "Nunit License",
		Reference:       "https://spdx.org/licenses/Nunit.html",
		ReferenceNumber: 471,
		DetailsURL:      "https://spdx.org/licenses/Nunit.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Nunit",
		},
		OSIApproved: false,
	},
	"o-uda-1.0": {
		ID:              "O-UDA-1.0",
		Name:            "Open Use of Data Agreement v1.0",
		Reference:       "https://spdx.org/licenses/O-UDA-1.0.html",
		ReferenceNumber: 118,
		DetailsURL:      "https://spdx.org/licenses/O-UDA-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/microsoft/Open-Use-of-Data-Agreement/blob/v1.0/O-UDA-1.0.md",
			"https://cdla.dev/open-use-of-data-agreement-v1-0/",
		},
		OSIApproved: false,
	},
	"occt-pl": {
		ID:              "OCCT-PL",
		Name:            "Open CASCADE Technology Public License",
		Reference:       "https://spdx.org/licenses/OCCT-PL.html",
		ReferenceNumber: 521,
		DetailsURL:      "https://spdx.org/licenses/OCCT-PL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.opencascade.com/content/occt-public-license",
		},
		OSIApproved: false,
	},
	"oclc-2.0": {
		ID:              "OCLC-2.0",
		Name:            "OCLC Research Public License 2.0",
		Reference:       "https://spdx.org/licenses/OCLC-2.0.html",
		ReferenceNumber: 566,
		DetailsURL:      "https://spdx.org/licenses/OCLC-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.oclc.org/research/activities/software/license/v2final.htm",
			"https://opensource.org/licenses/OCLC-2.0",
		},
		OSIApproved: true,
	},
	"odc-by-1.0": {
		ID:              "ODC-By-1.0",
		Name:            "Open Data Commons Attribution License v1.0",
		Reference:       "https://spdx.org/licenses/ODC-By-1.0.html",
		ReferenceNumber: 141,
		DetailsURL:      "https://spdx.org/licenses/ODC-By-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opendatacommons.org/licenses/by/1.0/",
		},
		OSIApproved: false,
	},
	"odbl-1.0": {
		ID:              "ODbL-1.0",
		Name:            "Open Data Commons Open Database License v1.0",
		Reference:       "https://spdx.org/licenses/ODbL-1.0.html",
		ReferenceNumber: 589,
		DetailsURL:      "https://spdx.org/licenses/ODbL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.opendatacommons.org/licenses/odbl/1.0/",
			"https://opendatacommons.org/licenses/odbl/1-0/",
		},
		OSIApproved: false,
	},
	"offis": {
		ID:              "OFFIS",
		Name:            "OFFIS License",
		Reference:       "https://spdx.org/licenses/OFFIS.html",
		ReferenceNumber: 603,
		DetailsURL:      "https://spdx.org/licenses/OFFIS.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://sourceforge.net/p/xmedcon/code/ci/master/tree/libs/dicom/README",
		},
		OSIApproved: false,
	},
	"ofl-1.0": {
		ID:              "OFL-1.0",
		Name:            "SIL Open Font License 1.0",
		Reference:       "https://spdx.org/licenses/OFL-1.0.html",
		ReferenceNumber: 91,
		DetailsURL:      "https://spdx.org/licenses/OFL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web",
		},
		OSIApproved: false,
	},
	"ofl-1.0-rfn": {
		ID:              "OFL-1.0-RFN",
		Name:            "SIL Open Font License 1.0 with Reserved Font Name",
		Reference:       "https://spdx.org/licenses/OFL-1.0-RFN.html",
		ReferenceNumber: 568,
		DetailsURL:      "https://spdx.org/licenses/OFL-1.0-RFN.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web",
		},
		OSIApproved: false,
	},
	"ofl-1.0-no-rfn": {
		ID:              "OFL-1.0-no-RFN",
		Name:            "SIL Open Font License 1.0 with no Reserved Font Name",
		Reference:       "https://spdx.org/licenses/OFL-1.0-no-RFN.html",
		ReferenceNumber: 149,
		DetailsURL:      "https://spdx.org/licenses/OFL-1.0-no-RFN.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://scripts.sil.org/cms/scripts/page.php?item_id=OFL10_web",
		},
		OSIApproved: false,
	},
	"ofl-1.1": {
		ID:              "OFL-1.1",
		Name:            "SIL Open Font License 1.1",
		Reference:       "https://spdx.org/licenses/OFL-1.1.html",
		ReferenceNumber: 163,
		DetailsURL:      "https://spdx.org/licenses/OFL-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web",
			"https://opensource.org/licenses/OFL-1.1",
		},
		OSIApproved: true,
	},
	"ofl-1.1-rfn": {
		ID:              "OFL-1.1-RFN",
		Name:            "SIL Open Font License 1.1 with Reserved Font Name",
		Reference:       "https://spdx.org/licenses/OFL-1.1-RFN.html",
		ReferenceNumber: 80,
		DetailsURL:      "https://spdx.org/licenses/OFL-1.1-RFN.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web",
			"https://opensource.org/licenses/OFL-1.1",
		},
		OSIApproved: true,
	},
	"ofl-1.1-no-rfn": {
		ID:              "OFL-1.1-no-RFN",
		Name:            "SIL Open Font License 1.1 with no Reserved Font Name",
		Reference:       "https://spdx.org/licenses/OFL-1.1-no-RFN.html",
		ReferenceNumber: 270,
		DetailsURL:      "https://spdx.org/licenses/OFL-1.1-no-RFN.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://scripts.sil.org/cms/scripts/page.php?item_id=OFL_web",
			"https://opensource.org/licenses/OFL-1.1",
		},
		OSIApproved: true,
	},
	"ogc-1.0": {
		ID:              "OGC-1.0",
		Name:            "OGC Software License, Version 1.0",
		Reference:       "https://spdx.org/licenses/OGC-1.0.html",
		ReferenceNumber: 86,
		DetailsURL:      "https://spdx.org/licenses/OGC-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.ogc.org/ogc/software/1.0",
		},
		OSIApproved: false,
	},
	"ogdl-taiwan-1.0": {
		ID:              "OGDL-Taiwan-1.0",
		Name:            "Taiwan Open Government Data License, version 1.0",
		Reference:       "https://spdx.org/licenses/OGDL-Taiwan-1.0.html",
		ReferenceNumber: 347,
		DetailsURL:      "https://spdx.org/licenses/OGDL-Taiwan-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://data.gov.tw/license",
		},
		OSIApproved: false,
	},
	"ogl-canada-2.0": {
		ID:              "OGL-Canada-2.0",
		Name:            "Open Government Licence - Canada",
		Reference:       "https://spdx.org/licenses/OGL-Canada-2.0.html",
		ReferenceNumber: 506,
		DetailsURL:      "https://spdx.org/licenses/OGL-Canada-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://open.canada.ca/en/open-government-licence-canada",
		},
		OSIApproved: false,
	},
	"ogl-uk-1.0": {
		ID:              "OGL-UK-1.0",
		Name:            "Open Government Licence v1.0",
		Reference:       "https://spdx.org/licenses/OGL-UK-1.0.html",
		ReferenceNumber: 245,
		DetailsURL:      "https://spdx.org/licenses/OGL-UK-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.nationalarchives.gov.uk/doc/open-government-licence/version/1/",
		},
		OSIApproved: false,
	},
	"ogl-uk-2.0": {
		ID:              "OGL-UK-2.0",
		Name:            "Open Government Licence v2.0",
		Reference:       "https://spdx.org/licenses/OGL-UK-2.0.html",
		ReferenceNumber: 399,
		DetailsURL:      "https://spdx.org/licenses/OGL-UK-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.nationalarchives.gov.uk/doc/open-government-licence/version/2/",
		},
		OSIApproved: false,
	},
	"ogl-uk-3.0": {
		ID:              "OGL-UK-3.0",
		Name:            "Open Government Licence v3.0",
		Reference:       "https://spdx.org/licenses/OGL-UK-3.0.html",
		ReferenceNumber: 142,
		DetailsURL:      "https://spdx.org/licenses/OGL-UK-3.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.nationalarchives.gov.uk/doc/open-government-licence/version/3/",
		},
		OSIApproved: false,
	},
	"ogtsl": {
		ID:              "OGTSL",
		Name:            "Open Group Test Suite License",
		Reference:       "https://spdx.org/licenses/OGTSL.html",
		ReferenceNumber: 214,
		DetailsURL:      "https://spdx.org/licenses/OGTSL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.opengroup.org/testing/downloads/The_Open_Group_TSL.txt",
			"https://opensource.org/licenses/OGTSL",
		},
		OSIApproved: true,
	},
	"oldap-1.1": {
		ID:              "OLDAP-1.1",
		Name:            "Open LDAP Public License v1.1",
		Reference:       "https://spdx.org/licenses/OLDAP-1.1.html",
		ReferenceNumber: 565,
		DetailsURL:      "https://spdx.org/licenses/OLDAP-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=806557a5ad59804ef3a44d5abfbe91d706b0791f",
		},
		OSIApproved: false,
	},
	"oldap-1.2": {
		ID:              "OLDAP-1.2",
		Name:            "Open LDAP Public License v1.2",
		Reference:       "https://spdx.org/licenses/OLDAP-1.2.html",
		ReferenceNumber: 321,
		DetailsURL:      "https://spdx.org/licenses/OLDAP-1.2.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=42b0383c50c299977b5893ee695cf4e486fb0dc7",
		},
		OSIApproved: false,
	},
	"oldap-1.3": {
		ID:              "OLDAP-1.3",
		Name:            "Open LDAP Public License v1.3",
		Reference:       "https://spdx.org/licenses/OLDAP-1.3.html",
		ReferenceNumber: 312,
		DetailsURL:      "https://spdx.org/licenses/OLDAP-1.3.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=e5f8117f0ce088d0bd7a8e18ddf37eaa40eb09b1",
		},
		OSIApproved: false,
	},
	"oldap-1.4": {
		ID:              "OLDAP-1.4",
		Name:            "Open LDAP Public License v1.4",
		Reference:       "https://spdx.org/licenses/OLDAP-1.4.html",
		ReferenceNumber: 120,
		DetailsURL:      "https://spdx.org/licenses/OLDAP-1.4.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=c9f95c2f3f2ffb5e0ae55fe7388af75547660941",
		},
		OSIApproved: false,
	},
	"oldap-2.0": {
		ID:              "OLDAP-2.0",
		Name:            "Open LDAP Public License v2.0 (or possibly 2.0A and 2.0B)",
		Reference:       "https://spdx.org/licenses/OLDAP-2.0.html",
		ReferenceNumber: 450,
		DetailsURL:      "https://spdx.org/licenses/OLDAP-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cbf50f4e1185a21abd4c0a54d3f4341fe28f36ea",
		},
		OSIApproved: false,
	},
	"oldap-2.0.1": {
		ID:              "OLDAP-2.0.1",
		Name:            "Open LDAP Public License v2.0.1",
		Reference:       "https://spdx.org/licenses/OLDAP-2.0.1.html",
		ReferenceNumber: 59,
		DetailsURL:      "https://spdx.org/licenses/OLDAP-2.0.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b6d68acd14e51ca3aab4428bf26522aa74873f0e",
		},
		OSIApproved: false,
	},
	"oldap-2.1": {
		ID:              "OLDAP-2.1",
		Name:            "Open LDAP Public License v2.1",
		Reference:       "https://spdx.org/licenses/OLDAP-2.1.html",
		ReferenceNumber: 458,
		DetailsURL:      "https://spdx.org/licenses/OLDAP-2.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=b0d176738e96a0d3b9f85cb51e140a86f21be715",
		},
		OSIApproved: false,
	},
	"oldap-2.2": {
		ID:              "OLDAP-2.2",
		Name:            "Open LDAP Public License v2.2",
		Reference:       "https://spdx.org/licenses/OLDAP-2.2.html",
		ReferenceNumber: 175,
		DetailsURL:      "https://spdx.org/licenses/OLDAP-2.2.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=470b0c18ec67621c85881b2733057fecf4a1acc3",
		},
		OSIApproved: false,
	},
	"oldap-2.2.1": {
		ID:              "OLDAP-2.2.1",
		Name:            "Open LDAP Public License v2.2.1",
		Reference:       "https://spdx.org/licenses/OLDAP-2.2.1.html",
		ReferenceNumber: 32,
		DetailsURL:      "https://spdx.org/licenses/OLDAP-2.2.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=4bc786f34b50aa301be6f5600f58a980070f481e",
		},
		OSIApproved: false,
	},
	"oldap-2.2.2": {
		ID:              "OLDAP-2.2.2",
		Name:            "Open LDAP Public License 2.2.2",
		Reference:       "https://spdx.org/licenses/OLDAP-2.2.2.html",
		ReferenceNumber: 293,
		DetailsURL:      "https://spdx.org/licenses/OLDAP-2.2.2.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=df2cc1e21eb7c160695f5b7cffd6296c151ba188",
		},
		OSIApproved: false,
	},
	"oldap-2.3": {
		ID:              "OLDAP-2.3",
		Name:            "Open LDAP Public License v2.3",
		Reference:       "https://spdx.org/licenses/OLDAP-2.3.html",
		ReferenceNumber: 405,
		DetailsURL:      "https://spdx.org/licenses/OLDAP-2.3.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=d32cf54a32d581ab475d23c810b0a7fbaf8d63c3",
		},
		OSIApproved: false,
	},
	"oldap-2.4": {
		ID:              "OLDAP-2.4",
		Name:            "Open LDAP Public License v2.4",
		Reference:       "https://spdx.org/licenses/OLDAP-2.4.html",
		ReferenceNumber: 619,
		DetailsURL:      "https://spdx.org/licenses/OLDAP-2.4.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=cd1284c4a91a8a380d904eee68d1583f989ed386",
		},
		OSIApproved: false,
	},
	"oldap-2.5": {
		ID:              "OLDAP-2.5",
		Name:            "Open LDAP Public License v2.5",
		Reference:       "https://spdx.org/licenses/OLDAP-2.5.html",
		ReferenceNumber: 426,
		DetailsURL:      "https://spdx.org/licenses/OLDAP-2.5.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=6852b9d90022e8593c98205413380536b1b5a7cf",
		},
		OSIApproved: false,
	},
	"oldap-2.6": {
		ID:              "OLDAP-2.6",
		Name:            "Open LDAP Public License v2.6",
		Reference:       "https://spdx.org/licenses/OLDAP-2.6.html",
		ReferenceNumber: 9,
		DetailsURL:      "https://spdx.org/licenses/OLDAP-2.6.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=1cae062821881f41b73012ba816434897abf4205",
		},
		OSIApproved: false,
	},
	"oldap-2.7": {
		ID:              "OLDAP-2.7",
		Name:            "Open LDAP Public License v2.7",
		Reference:       "https://spdx.org/licenses/OLDAP-2.7.html",
		ReferenceNumber: 178,
		DetailsURL:      "https://spdx.org/licenses/OLDAP-2.7.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.openldap.org/devel/gitweb.cgi?p=openldap.git;a=blob;f=LICENSE;hb=47c2415c1df81556eeb39be6cad458ef87c534a2",
		},
		OSIApproved: false,
	},
	"oldap-2.8": {
		ID:              "OLDAP-2.8",
		Name:            "Open LDAP Public License v2.8",
		Reference:       "https://spdx.org/licenses/OLDAP-2.8.html",
		ReferenceNumber: 132,
		DetailsURL:      "https://spdx.org/licenses/OLDAP-2.8.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.openldap.org/software/release/license.html",
		},
		OSIApproved: true,
	},
	"olfl-1.3": {
		ID:              "OLFL-1.3",
		Name:            "Open Logistics Foundation License Version 1.3",
		Reference:       "https://spdx.org/licenses/OLFL-1.3.html",
		ReferenceNumber: 556,
		DetailsURL:      "https://spdx.org/licenses/OLFL-1.3.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://openlogisticsfoundation.org/licenses/",
			"https://opensource.org/license/olfl-1-3/",
		},
		OSIApproved: true,
	},
	"oml": {
		ID:              "OML",
		Name:            "Open Market License",
		Reference:       "https://spdx.org/licenses/OML.html",
		ReferenceNumber: 325,
		DetailsURL:      "https://spdx.org/licenses/OML.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Open_Market_License",
		},
		OSIApproved: false,
	},
	"opl-1.0": {
		ID:              "OPL-1.0",
		Name:            "Open Public License v1.0",
		Reference:       "https://spdx.org/licenses/OPL-1.0.html",
		ReferenceNumber: 116,
		DetailsURL:      "https://spdx.org/licenses/OPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://old.koalateam.com/jackaroo/OPL_1_0.TXT",
			"https://fedoraproject.org/wiki/Licensing/Open_Public_License",
		},
		OSIApproved: false,
	},
	"opl-uk-3.0": {
		ID:              "OPL-UK-3.0",
		Name:            "United    Kingdom Open Parliament Licence v3.0",
		Reference:       "https://spdx.org/licenses/OPL-UK-3.0.html",
		ReferenceNumber: 276,
		DetailsURL:      "https://spdx.org/licenses/OPL-UK-3.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.parliament.uk/site-information/copyright-parliament/open-parliament-licence/",
		},
		OSIApproved: false,
	},
	"opubl-1.0": {
		ID:              "OPUBL-1.0",
		Name:            "Open Publication License v1.0",
		Reference:       "https://spdx.org/licenses/OPUBL-1.0.html",
		ReferenceNumber: 479,
		DetailsURL:      "https://spdx.org/licenses/OPUBL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://opencontent.org/openpub/",
			"https://www.debian.org/opl",
			"https://www.ctan.org/license/opl",
		},
		OSIApproved: false,
	},
	"oset-pl-2.1": {
		ID:              "OSET-PL-2.1",
		Name:            "OSET Public License version 2.1",
		Reference:       "https://spdx.org/licenses/OSET-PL-2.1.html",
		ReferenceNumber: 19,
		DetailsURL:      "https://spdx.org/licenses/OSET-PL-2.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.osetfoundation.org/public-license",
			"https://opensource.org/licenses/OPL-2.1",
		},
		OSIApproved: true,
	},
	"osl-1.0": {
		ID:              "OSL-1.0",
		Name:            "Open Software License 1.0",
		Reference:       "https://spdx.org/licenses/OSL-1.0.html",
		ReferenceNumber: 511,
		DetailsURL:      "https://spdx.org/licenses/OSL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/OSL-1.0",
		},
		OSIApproved: true,
	},
	"osl-1.1": {
		ID:              "OSL-1.1",
		Name:            "Open Software License 1.1",
		Reference:       "https://spdx.org/licenses/OSL-1.1.html",
		ReferenceNumber: 327,
		DetailsURL:      "https://spdx.org/licenses/OSL-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/OSL1.1",
		},
		OSIApproved: false,
	},
	"osl-2.0": {
		ID:              "OSL-2.0",
		Name:            "Open Software License 2.0",
		Reference:       "https://spdx.org/licenses/OSL-2.0.html",
		ReferenceNumber: 579,
		DetailsURL:      "https://spdx.org/licenses/OSL-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://web.archive.org/web/20041020171434/http://www.rosenlaw.com/osl2.0.html",
		},
		OSIApproved: true,
	},
	"osl-2.1": {
		ID:              "OSL-2.1",
		Name:            "Open Software License 2.1",
		Reference:       "https://spdx.org/licenses/OSL-2.1.html",
		ReferenceNumber: 480,
		DetailsURL:      "https://spdx.org/licenses/OSL-2.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://web.archive.org/web/20050212003940/http://www.rosenlaw.com/osl21.htm",
			"https://opensource.org/licenses/OSL-2.1",
		},
		OSIApproved: true,
	},
	"osl-3.0": {
		ID:              "OSL-3.0",
		Name:            "Open Software License 3.0",
		Reference:       "https://spdx.org/licenses/OSL-3.0.html",
		ReferenceNumber: 72,
		DetailsURL:      "https://spdx.org/licenses/OSL-3.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://web.archive.org/web/20120101081418/http://rosenlaw.com:80/OSL3.0.htm",
			"https://opensource.org/licenses/OSL-3.0",
		},
		OSIApproved: true,
	},
	"openpbs-2.3": {
		ID:              "OpenPBS-2.3",
		Name:            "OpenPBS v2.3 Software License",
		Reference:       "https://spdx.org/licenses/OpenPBS-2.3.html",
		ReferenceNumber: 490,
		DetailsURL:      "https://spdx.org/licenses/OpenPBS-2.3.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/adaptivecomputing/torque/blob/master/PBS_License.txt",
			"https://www.mcs.anl.gov/research/projects/openpbs/PBS_License.txt",
		},
		OSIApproved: false,
	},
	"openssl": {
		ID:              "OpenSSL",
		Name:            "OpenSSL License",
		Reference:       "https://spdx.org/licenses/OpenSSL.html",
		ReferenceNumber: 564,
		DetailsURL:      "https://spdx.org/licenses/OpenSSL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.openssl.org/source/license.html",
		},
		OSIApproved: false,
	},
	"openssl-standalone": {
		ID:              "OpenSSL-standalone",
		Name:            "OpenSSL License - standalone",
		Reference:       "https://spdx.org/licenses/OpenSSL-standalone.html",
		ReferenceNumber: 597,
		DetailsURL:      "https://spdx.org/licenses/OpenSSL-standalone.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://library.netapp.com/ecm/ecm_download_file/ECMP1196395",
			"https://hstechdocs.helpsystems.com/manuals/globalscape/archive/cuteftp6/open_ssl_license_agreement.htm",
		},
		OSIApproved: false,
	},
	"openvision": {
		ID:              "OpenVision",
		Name:            "OpenVision License",
		Reference:       "https://spdx.org/licenses/OpenVision.html",
		ReferenceNumber: 590,
		DetailsURL:      "https://spdx.org/licenses/OpenVision.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/krb5/krb5/blob/krb5-1.21.2-final/NOTICE#L66-L98",
			"https://web.mit.edu/kerberos/krb5-1.21/doc/mitK5license.html",
			"https://fedoraproject.org/wiki/Licensing:MIT#OpenVision_Variant",
		},
		OSIApproved: false,
	},
	"padl": {
		ID:              "PADL",
		Name:            "PADL License",
		Reference:       "https://spdx.org/licenses/PADL.html",
		ReferenceNumber: 145,
		DetailsURL:      "https://spdx.org/licenses/PADL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://git.openldap.org/openldap/openldap/-/blob/master/libraries/libldap/os-local.c?ref_type=heads#L19-23",
		},
		OSIApproved: false,
	},
	"pddl-1.0": {
		ID:              "PDDL-1.0",
		Name:            "Open Data Commons Public Domain Dedication & License 1.0",
		Reference:       "https://spdx.org/licenses/PDDL-1.0.html",
		ReferenceNumber: 231,
		DetailsURL:      "https://spdx.org/licenses/PDDL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://opendatacommons.org/licenses/pddl/1.0/",
			"https://opendatacommons.org/licenses/pddl/",
		},
		OSIApproved: false,
	},
	"php-3.0": {
		ID:              "PHP-3.0",
		Name:            "PHP License v3.0",
		Reference:       "https://spdx.org/licenses/PHP-3.0.html",
		ReferenceNumber: 622,
		DetailsURL:      "https://spdx.org/licenses/PHP-3.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.php.net/license/3_0.txt",
			"https://opensource.org/licenses/PHP-3.0",
		},
		OSIApproved: true,
	},
	"php-3.01": {
		ID:              "PHP-3.01",
		Name:            "PHP License v3.01",
		Reference:       "https://spdx.org/licenses/PHP-3.01.html",
		ReferenceNumber: 11,
		DetailsURL:      "https://spdx.org/licenses/PHP-3.01.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.php.net/license/3_01.txt",
		},
		OSIApproved: true,
	},
	"psf-2.0": {
		ID:              "PSF-2.0",
		Name:            "Python Software Foundation License 2.0",
		Reference:       "https://spdx.org/licenses/PSF-2.0.html",
		ReferenceNumber: 381,
		DetailsURL:      "https://spdx.org/licenses/PSF-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/Python-2.0",
		},
		OSIApproved: false,
	},
	"parity-6.0.0": {
		ID:              "Parity-6.0.0",
		Name:            "The Parity Public License 6.0.0",
		Reference:       "https://spdx.org/licenses/Parity-6.0.0.html",
		ReferenceNumber: 546,
		DetailsURL:      "https://spdx.org/licenses/Parity-6.0.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://paritylicense.com/versions/6.0.0.html",
		},
		OSIApproved: false,
	},
	"parity-7.0.0": {
		ID:              "Parity-7.0.0",
		Name:            "The Parity Public License 7.0.0",
		Reference:       "https://spdx.org/licenses/Parity-7.0.0.html",
		ReferenceNumber: 281,
		DetailsURL:      "https://spdx.org/licenses/Parity-7.0.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://paritylicense.com/versions/7.0.0.html",
		},
		OSIApproved: false,
	},
	"pixar": {
		ID:              "Pixar",
		Name:            "Pixar License",
		Reference:       "https://spdx.org/licenses/Pixar.html",
		ReferenceNumber: 240,
		DetailsURL:      "https://spdx.org/licenses/Pixar.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/PixarAnimationStudios/OpenSubdiv/raw/v3_5_0/LICENSE.txt",
			"https://graphics.pixar.com/opensubdiv/docs/license.html",
			"https://github.com/PixarAnimationStudios/OpenSubdiv/blob/v3_5_0/opensubdiv/version.cpp#L2-L22",
		},
		OSIApproved: false,
	},
	"plexus": {
		ID:              "Plexus",
		Name:            "Plexus Classworlds License",
		Reference:       "https://spdx.org/licenses/Plexus.html",
		ReferenceNumber: 354,
		DetailsURL:      "https://spdx.org/licenses/Plexus.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Plexus_Classworlds_License",
		},
		OSIApproved: false,
	},
	"polyform-noncommercial-1.0.0": {
		ID:              "PolyForm-Noncommercial-1.0.0",
		Name:            "PolyForm Noncommercial License 1.0.0",
		Reference:       "https://spdx.org/licenses/PolyForm-Noncommercial-1.0.0.html",
		ReferenceNumber: 343,
		DetailsURL:      "https://spdx.org/licenses/PolyForm-Noncommercial-1.0.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://polyformproject.org/licenses/noncommercial/1.0.0",
		},
		OSIApproved: false,
	},
	"polyform-small-business-1.0.0": {
		ID:              "PolyForm-Small-Business-1.0.0",
		Name:            "PolyForm Small Business License 1.0.0",
		Reference:       "https://spdx.org/licenses/PolyForm-Small-Business-1.0.0.html",
		ReferenceNumber: 455,
		DetailsURL:      "https://spdx.org/licenses/PolyForm-Small-Business-1.0.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://polyformproject.org/licenses/small-business/1.0.0",
		},
		OSIApproved: false,
	},
	"postgresql": {
		ID:              "PostgreSQL",
		Name:            "PostgreSQL License",
		Reference:       "https://spdx.org/licenses/PostgreSQL.html",
		ReferenceNumber: 390,
		DetailsURL:      "https://spdx.org/licenses/PostgreSQL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.postgresql.org/about/licence",
			"https://opensource.org/licenses/PostgreSQL",
		},
		OSIApproved: true,
	},
	"python-2.0": {
		ID:              "Python-2.0",
		Name:            "Python License 2.0",
		Reference:       "https://spdx.org/licenses/Python-2.0.html",
		ReferenceNumber: 383,
		DetailsURL:      "https://spdx.org/licenses/Python-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/Python-2.0",
		},
		OSIApproved: true,
	},
	"python-2.0.1": {
		ID:              "Python-2.0.1",
		Name:            "Python License 2.0.1",
		Reference:       "https://spdx.org/licenses/Python-2.0.1.html",
		ReferenceNumber: 559,
		DetailsURL:      "https://spdx.org/licenses/Python-2.0.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.python.org/download/releases/2.0.1/license/",
			"https://docs.python.org/3/license.html",
			"https://github.com/python/cpython/blob/main/LICENSE",
		},
		OSIApproved: false,
	},
	"qpl-1.0": {
		ID:              "QPL-1.0",
		Name:            "Q Public License 1.0",
		Reference:       "https://spdx.org/licenses/QPL-1.0.html",
		ReferenceNumber: 459,
		DetailsURL:      "https://spdx.org/licenses/QPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://doc.qt.nokia.com/3.3/license.html",
			"https://opensource.org/licenses/QPL-1.0",
			"https://doc.qt.io/archives/3.3/license.html",
		},
		OSIApproved: true,
	},
	"qpl-1.0-inria-2004": {
		ID:              "QPL-1.0-INRIA-2004",
		Name:            "Q Public License 1.0 - INRIA 2004 variant",
		Reference:       "https://spdx.org/licenses/QPL-1.0-INRIA-2004.html",
		ReferenceNumber: 537,
		DetailsURL:      "https://spdx.org/licenses/QPL-1.0-INRIA-2004.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/maranget/hevea/blob/master/LICENSE",
		},
		OSIApproved: false,
	},
	"qhull": {
		ID:              "Qhull",
		Name:            "Qhull License",
		Reference:       "https://spdx.org/licenses/Qhull.html",
		ReferenceNumber: 241,
		DetailsURL:      "https://spdx.org/licenses/Qhull.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Qhull",
		},
		OSIApproved: false,
	},
	"rhecos-1.1": {
		ID:              "RHeCos-1.1",
		Name:            "Red Hat eCos Public License v1.1",
		Reference:       "https://spdx.org/licenses/RHeCos-1.1.html",
		ReferenceNumber: 484,
		DetailsURL:      "https://spdx.org/licenses/RHeCos-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://ecos.sourceware.org/old-license.html",
		},
		OSIApproved: false,
	},
	"rpl-1.1": {
		ID:              "RPL-1.1",
		Name:            "Reciprocal Public License 1.1",
		Reference:       "https://spdx.org/licenses/RPL-1.1.html",
		ReferenceNumber: 613,
		DetailsURL:      "https://spdx.org/licenses/RPL-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/RPL-1.1",
		},
		OSIApproved: true,
	},
	"rpl-1.5": {
		ID:              "RPL-1.5",
		Name:            "Reciprocal Public License 1.5",
		Reference:       "https://spdx.org/licenses/RPL-1.5.html",
		ReferenceNumber: 531,
		DetailsURL:      "https://spdx.org/licenses/RPL-1.5.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/RPL-1.5",
		},
		OSIApproved: true,
	},
	"rpsl-1.0": {
		ID:              "RPSL-1.0",
		Name:            "RealNetworks Public Source License v1.0",
		Reference:       "https://spdx.org/licenses/RPSL-1.0.html",
		ReferenceNumber: 168,
		DetailsURL:      "https://spdx.org/licenses/RPSL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://helixcommunity.org/content/rpsl",
			"https://opensource.org/licenses/RPSL-1.0",
		},
		OSIApproved: true,
	},
	"rsa-md": {
		ID:              "RSA-MD",
		Name:            "RSA Message-Digest License",
		Reference:       "https://spdx.org/licenses/RSA-MD.html",
		ReferenceNumber: 515,
		DetailsURL:      "https://spdx.org/licenses/RSA-MD.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.faqs.org/rfcs/rfc1321.html",
		},
		OSIApproved: false,
	},
	"rscpl": {
		ID:              "RSCPL",
		Name:            "Ricoh Source Code Public License",
		Reference:       "https://spdx.org/licenses/RSCPL.html",
		ReferenceNumber: 580,
		DetailsURL:      "https://spdx.org/licenses/RSCPL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://wayback.archive.org/web/20060715140826/http://www.risource.org/RPL/RPL-1.0A.shtml",
			"https://opensource.org/licenses/RSCPL",
		},
		OSIApproved: true,
	},
	"rdisc": {
		ID:              "Rdisc",
		Name:            "Rdisc License",
		Reference:       "https://spdx.org/licenses/Rdisc.html",
		ReferenceNumber: 591,
		DetailsURL:      "https://spdx.org/licenses/Rdisc.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Rdisc_License",
		},
		OSIApproved: false,
	},
	"ruby": {
		ID:              "Ruby",
		Name:            "Ruby License",
		Reference:       "https://spdx.org/licenses/Ruby.html",
		ReferenceNumber: 528,
		DetailsURL:      "https://spdx.org/licenses/Ruby.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.ruby-lang.org/en/about/license.txt",
		},
		OSIApproved: false,
	},
	"sax-pd": {
		ID:              "SAX-PD",
		Name:            "Sax Public Domain Notice",
		Reference:       "https://spdx.org/licenses/SAX-PD.html",
		ReferenceNumber: 169,
		DetailsURL:      "https://spdx.org/licenses/SAX-PD.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.saxproject.org/copying.html",
		},
		OSIApproved: false,
	},
	"sax-pd-2.0": {
		ID:              "SAX-PD-2.0",
		Name:            "Sax Public Domain Notice 2.0",
		Reference:       "https://spdx.org/licenses/SAX-PD-2.0.html",
		ReferenceNumber: 585,
		DetailsURL:      "https://spdx.org/licenses/SAX-PD-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.saxproject.org/copying.html",
		},
		OSIApproved: false,
	},
	"scea": {
		ID:              "SCEA",
		Name:            "SCEA Shared Source License",
		Reference:       "https://spdx.org/licenses/SCEA.html",
		ReferenceNumber: 230,
		DetailsURL:      "https://spdx.org/licenses/SCEA.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://research.scea.com/scea_shared_source_license.html",
		},
		OSIApproved: false,
	},
	"sgi-b-1.0": {
		ID:              "SGI-B-1.0",
		Name:            "SGI Free Software License B v1.0",
		Reference:       "https://spdx.org/licenses/SGI-B-1.0.html",
		ReferenceNumber: 25,
		DetailsURL:      "https://spdx.org/licenses/SGI-B-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://oss.sgi.com/projects/FreeB/SGIFreeSWLicB.1.0.html",
		},
		OSIApproved: false,
	},
	"sgi-b-1.1": {
		ID:              "SGI-B-1.1",
		Name:            "SGI Free Software License B v1.1",
		Reference:       "https://spdx.org/licenses/SGI-B-1.1.html",
		ReferenceNumber: 16,
		DetailsURL:      "https://spdx.org/licenses/SGI-B-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://oss.sgi.com/projects/FreeB/",
		},
		OSIApproved: false,
	},
	"sgi-b-2.0": {
		ID:              "SGI-B-2.0",
		Name:            "SGI Free Software License B v2.0",
		Reference:       "https://spdx.org/licenses/SGI-B-2.0.html",
		ReferenceNumber: 431,
		DetailsURL:      "https://spdx.org/licenses/SGI-B-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://oss.sgi.com/projects/FreeB/SGIFreeSWLicB.2.0.pdf",
		},
		OSIApproved: false,
	},
	"sgi-opengl": {
		ID:              "SGI-OpenGL",
		Name:            "SGI OpenGL License",
		Reference:       "https://spdx.org/licenses/SGI-OpenGL.html",
		ReferenceNumber: 408,
		DetailsURL:      "https://spdx.org/licenses/SGI-OpenGL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://gitlab.freedesktop.org/mesa/glw/-/blob/master/README?ref_type=heads",
		},
		OSIApproved: false,
	},
	"sgp4": {
		ID:              "SGP4",
		Name:            "SGP4 Permission Notice",
		Reference:       "https://spdx.org/licenses/SGP4.html",
		ReferenceNumber: 461,
		DetailsURL:      "https://spdx.org/licenses/SGP4.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://celestrak.org/publications/AIAA/2006-6753/faq.php",
		},
		OSIApproved: false,
	},
	"shl-0.5": {
		ID:              "SHL-0.5",
		Name:            "Solderpad Hardware License v0.5",
		Reference:       "https://spdx.org/licenses/SHL-0.5.html",
		ReferenceNumber: 298,
		DetailsURL:      "https://spdx.org/licenses/SHL-0.5.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://solderpad.org/licenses/SHL-0.5/",
		},
		OSIApproved: false,
	},
	"shl-0.51": {
		ID:              "SHL-0.51",
		Name:            "Solderpad Hardware License, Version 0.51",
		Reference:       "https://spdx.org/licenses/SHL-0.51.html",
		ReferenceNumber: 504,
		DetailsURL:      "https://spdx.org/licenses/SHL-0.51.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://solderpad.org/licenses/SHL-0.51/",
		},
		OSIApproved: false,
	},
	"sissl": {
		ID:              "SISSL",
		Name:            "Sun Industry Standards Source License v1.1",
		Reference:       "https://spdx.org/licenses/SISSL.html",
		ReferenceNumber: 525,
		DetailsURL:      "https://spdx.org/licenses/SISSL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.openoffice.org/licenses/sissl_license.html",
			"https://opensource.org/licenses/SISSL",
		},
		OSIApproved: true,
	},
	"sissl-1.2": {
		ID:              "SISSL-1.2",
		Name:            "Sun Industry Standards Source License v1.2",
		Reference:       "https://spdx.org/licenses/SISSL-1.2.html",
		ReferenceNumber: 493,
		DetailsURL:      "https://spdx.org/licenses/SISSL-1.2.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://gridscheduler.sourceforge.net/Gridengine_SISSL_license.html",
		},
		OSIApproved: false,
	},
	"sl": {
		ID:              "SL",
		Name:            "SL License",
		Reference:       "https://spdx.org/licenses/SL.html",
		ReferenceNumber: 190,
		DetailsURL:      "https://spdx.org/licenses/SL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/mtoyoda/sl/blob/master/LICENSE",
		},
		OSIApproved: false,
	},
	"smlnj": {
		ID:              "SMLNJ",
		Name:            "Standard ML of New Jersey License",
		Reference:       "https://spdx.org/licenses/SMLNJ.html",
		ReferenceNumber: 63,
		DetailsURL:      "https://spdx.org/licenses/SMLNJ.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.smlnj.org/license.html",
		},
		OSIApproved: false,
	},
	"smppl": {
		ID:              "SMPPL",
		Name:            "Secure Messaging Protocol Public License",
		Reference:       "https://spdx.org/licenses/SMPPL.html",
		ReferenceNumber: 193,
		DetailsURL:      "https://spdx.org/licenses/SMPPL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/dcblake/SMP/blob/master/Documentation/License.txt",
		},
		OSIApproved: false,
	},
	"snia": {
		ID:              "SNIA",
		Name:            "SNIA Public License 1.1",
		Reference:       "https://spdx.org/licenses/SNIA.html",
		ReferenceNumber: 211,
		DetailsURL:      "https://spdx.org/licenses/SNIA.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/SNIA_Public_License",
		},
		OSIApproved: false,
	},
	"spl-1.0": {
		ID:              "SPL-1.0",
		Name:            "Sun Public License v1.0",
		Reference:       "https://spdx.org/licenses/SPL-1.0.html",
		ReferenceNumber: 3,
		DetailsURL:      "https://spdx.org/licenses/SPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/SPL-1.0",
		},
		OSIApproved: true,
	},
	"ssh-openssh": {
		ID:              "SSH-OpenSSH",
		Name:            "SSH OpenSSH license",
		Reference:       "https://spdx.org/licenses/SSH-OpenSSH.html",
		ReferenceNumber: 364,
		DetailsURL:      "https://spdx.org/licenses/SSH-OpenSSH.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/openssh/openssh-portable/blob/1b11ea7c58cd5c59838b5fa574cd456d6047b2d4/LICENCE#L10",
		},
		OSIApproved: false,
	},
	"ssh-short": {
		ID:              "SSH-short",
		Name:            "SSH short notice",
		Reference:       "https://spdx.org/licenses/SSH-short.html",
		ReferenceNumber: 428,
		DetailsURL:      "https://spdx.org/licenses/SSH-short.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/openssh/openssh-portable/blob/1b11ea7c58cd5c59838b5fa574cd456d6047b2d4/pathnames.h",
			"http://web.mit.edu/kolya/.f/root/athena.mit.edu/sipb.mit.edu/project/openssh/OldFiles/src/openssh-2.9.9p2/ssh-add.1",
			"https://joinup.ec.europa.eu/svn/lesoll/trunk/italc/lib/src/dsa_key.cpp",
		},
		OSIApproved: false,
	},
	"ssleay-standalone": {
		ID:              "SSLeay-standalone",
		Name:            "SSLeay License - standalone",
		Reference:       "https://spdx.org/licenses/SSLeay-standalone.html",
		ReferenceNumber: 419,
		DetailsURL:      "https://spdx.org/licenses/SSLeay-standalone.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.tq-group.com/filedownloads/files/software-license-conditions/OriginalSSLeay/OriginalSSLeay.pdf",
		},
		OSIApproved: false,
	},
	"sspl-1.0": {
		ID:              "SSPL-1.0",
		Name:            "Server Side Public License, v 1",
		Reference:       "https://spdx.org/licenses/SSPL-1.0.html",
		ReferenceNumber: 156,
		DetailsURL:      "https://spdx.org/licenses/SSPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.mongodb.com/licensing/server-side-public-license",
		},
		OSIApproved: false,
	},
	"swl": {
		ID:              "SWL",
		Name:            "Scheme Widget Library (SWL) Software License Agreement",
		Reference:       "https://spdx.org/licenses/SWL.html",
		ReferenceNumber: 360,
		DetailsURL:      "https://spdx.org/licenses/SWL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/SWL",
		},
		OSIApproved: false,
	},
	"saxpath": {
		ID:              "Saxpath",
		Name:            "Saxpath License",
		Reference:       "https://spdx.org/licenses/Saxpath.html",
		ReferenceNumber: 430,
		DetailsURL:      "https://spdx.org/licenses/Saxpath.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Saxpath_License",
		},
		OSIApproved: false,
	},
	"schemereport": {
		ID:              "SchemeReport",
		Name:            "Scheme Language Report License",
		Reference:       "https://spdx.org/licenses/SchemeReport.html",
		ReferenceNumber: 552,
		DetailsURL:      "https://spdx.org/licenses/SchemeReport.json",
		Deprecated:      false,
		SeeAlso:         []string{},
		OSIApproved:     false,
	},
	"sendmail": {
		ID:              "Sendmail",
		Name:            "Sendmail License",
		Reference:       "https://spdx.org/licenses/Sendmail.html",
		ReferenceNumber: 427,
		DetailsURL:      "https://spdx.org/licenses/Sendmail.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.sendmail.com/pdfs/open_source/sendmail_license.pdf",
			"https://web.archive.org/web/20160322142305/https://www.sendmail.com/pdfs/open_source/sendmail_license.pdf",
		},
		OSIApproved: false,
	},
	"sendmail-8.23": {
		ID:              "Sendmail-8.23",
		Name:            "Sendmail License 8.23",
		Reference:       "https://spdx.org/licenses/Sendmail-8.23.html",
		ReferenceNumber: 24,
		DetailsURL:      "https://spdx.org/licenses/Sendmail-8.23.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.proofpoint.com/sites/default/files/sendmail-license.pdf",
			"https://web.archive.org/web/20181003101040/https://www.proofpoint.com/sites/default/files/sendmail-license.pdf",
		},
		OSIApproved: false,
	},
	"simpl-2.0": {
		ID:              "SimPL-2.0",
		Name:            "Simple Public License 2.0",
		Reference:       "https://spdx.org/licenses/SimPL-2.0.html",
		ReferenceNumber: 617,
		DetailsURL:      "https://spdx.org/licenses/SimPL-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/SimPL-2.0",
		},
		OSIApproved: true,
	},
	"sleepycat": {
		ID:              "Sleepycat",
		Name:            "Sleepycat License",
		Reference:       "https://spdx.org/licenses/Sleepycat.html",
		ReferenceNumber: 239,
		DetailsURL:      "https://spdx.org/licenses/Sleepycat.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/Sleepycat",
		},
		OSIApproved: true,
	},
	"soundex": {
		ID:              "Soundex",
		Name:            "Soundex License",
		Reference:       "https://spdx.org/licenses/Soundex.html",
		ReferenceNumber: 43,
		DetailsURL:      "https://spdx.org/licenses/Soundex.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://metacpan.org/release/RJBS/Text-Soundex-3.05/source/Soundex.pm#L3-11",
		},
		OSIApproved: false,
	},
	"spencer-86": {
		ID:              "Spencer-86",
		Name:            "Spencer License 86",
		Reference:       "https://spdx.org/licenses/Spencer-86.html",
		ReferenceNumber: 469,
		DetailsURL:      "https://spdx.org/licenses/Spencer-86.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License",
		},
		OSIApproved: false,
	},
	"spencer-94": {
		ID:              "Spencer-94",
		Name:            "Spencer License 94",
		Reference:       "https://spdx.org/licenses/Spencer-94.html",
		ReferenceNumber: 583,
		DetailsURL:      "https://spdx.org/licenses/Spencer-94.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Henry_Spencer_Reg-Ex_Library_License",
			"https://metacpan.org/release/KNOK/File-MMagic-1.30/source/COPYING#L28",
		},
		OSIApproved: false,
	},
	"spencer-99": {
		ID:              "Spencer-99",
		Name:            "Spencer License 99",
		Reference:       "https://spdx.org/licenses/Spencer-99.html",
		ReferenceNumber: 420,
		DetailsURL:      "https://spdx.org/licenses/Spencer-99.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.opensource.apple.com/source/tcl/tcl-5/tcl/generic/regfronts.c",
		},
		OSIApproved: false,
	},
	"standardml-nj": {
		ID:              "StandardML-NJ",
		Name:            "Standard ML of New Jersey License",
		Reference:       "https://spdx.org/licenses/StandardML-NJ.html",
		ReferenceNumber: 510,
		DetailsURL:      "https://spdx.org/licenses/StandardML-NJ.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.smlnj.org/license.html",
		},
		OSIApproved: false,
	},
	"sugarcrm-1.1.3": {
		ID:              "SugarCRM-1.1.3",
		Name:            "SugarCRM Public License v1.1.3",
		Reference:       "https://spdx.org/licenses/SugarCRM-1.1.3.html",
		ReferenceNumber: 33,
		DetailsURL:      "https://spdx.org/licenses/SugarCRM-1.1.3.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.sugarcrm.com/crm/SPL",
		},
		OSIApproved: false,
	},
	"sun-ppp": {
		ID:              "Sun-PPP",
		Name:            "Sun PPP License",
		Reference:       "https://spdx.org/licenses/Sun-PPP.html",
		ReferenceNumber: 598,
		DetailsURL:      "https://spdx.org/licenses/Sun-PPP.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/ppp-project/ppp/blob/master/pppd/eap.c#L7-L16",
		},
		OSIApproved: false,
	},
	"sunpro": {
		ID:              "SunPro",
		Name:            "SunPro License",
		Reference:       "https://spdx.org/licenses/SunPro.html",
		ReferenceNumber: 95,
		DetailsURL:      "https://spdx.org/licenses/SunPro.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/freebsd/freebsd-src/blob/main/lib/msun/src/e_acosh.c",
			"https://github.com/freebsd/freebsd-src/blob/main/lib/msun/src/e_lgammal.c",
		},
		OSIApproved: false,
	},
	"symlinks": {
		ID:              "Symlinks",
		Name:            "Symlinks License",
		Reference:       "https://spdx.org/licenses/Symlinks.html",
		ReferenceNumber: 488,
		DetailsURL:      "https://spdx.org/licenses/Symlinks.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.mail-archive.com/debian-bugs-rc@lists.debian.org/msg11494.html",
		},
		OSIApproved: false,
	},
	"tapr-ohl-1.0": {
		ID:              "TAPR-OHL-1.0",
		Name:            "TAPR Open Hardware License v1.0",
		Reference:       "https://spdx.org/licenses/TAPR-OHL-1.0.html",
		ReferenceNumber: 403,
		DetailsURL:      "https://spdx.org/licenses/TAPR-OHL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.tapr.org/OHL",
		},
		OSIApproved: false,
	},
	"tcl": {
		ID:              "TCL",
		Name:            "TCL/TK License",
		Reference:       "https://spdx.org/licenses/TCL.html",
		ReferenceNumber: 494,
		DetailsURL:      "https://spdx.org/licenses/TCL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.tcl.tk/software/tcltk/license.html",
			"https://fedoraproject.org/wiki/Licensing/TCL",
		},
		OSIApproved: false,
	},
	"tcp-wrappers": {
		ID:              "TCP-wrappers",
		Name:            "TCP Wrappers License",
		Reference:       "https://spdx.org/licenses/TCP-wrappers.html",
		ReferenceNumber: 194,
		DetailsURL:      "https://spdx.org/licenses/TCP-wrappers.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://rc.quest.com/topics/openssh/license.php#tcpwrappers",
		},
		OSIApproved: false,
	},
	"tgppl-1.0": {
		ID:              "TGPPL-1.0",
		Name:            "Transitive Grace Period Public Licence 1.0",
		Reference:       "https://spdx.org/licenses/TGPPL-1.0.html",
		ReferenceNumber: 208,
		DetailsURL:      "https://spdx.org/licenses/TGPPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/TGPPL",
			"https://tahoe-lafs.org/trac/tahoe-lafs/browser/trunk/COPYING.TGPPL.rst",
		},
		OSIApproved: false,
	},
	"tmate": {
		ID:              "TMate",
		Name:            "TMate Open Source License",
		Reference:       "https://spdx.org/licenses/TMate.html",
		ReferenceNumber: 541,
		DetailsURL:      "https://spdx.org/licenses/TMate.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://svnkit.com/license.html",
		},
		OSIApproved: false,
	},
	"torque-1.1": {
		ID:              "TORQUE-1.1",
		Name:            "TORQUE v2.5+ Software License v1.1",
		Reference:       "https://spdx.org/licenses/TORQUE-1.1.html",
		ReferenceNumber: 332,
		DetailsURL:      "https://spdx.org/licenses/TORQUE-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/TORQUEv1.1",
		},
		OSIApproved: false,
	},
	"tosl": {
		ID:              "TOSL",
		Name:            "Trusster Open Source License",
		Reference:       "https://spdx.org/licenses/TOSL.html",
		ReferenceNumber: 574,
		DetailsURL:      "https://spdx.org/licenses/TOSL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/TOSL",
		},
		OSIApproved: false,
	},
	"tpdl": {
		ID:              "TPDL",
		Name:            "Time::ParseDate License",
		Reference:       "https://spdx.org/licenses/TPDL.html",
		ReferenceNumber: 302,
		DetailsURL:      "https://spdx.org/licenses/TPDL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://metacpan.org/pod/Time::ParseDate#LICENSE",
		},
		OSIApproved: false,
	},
	"tpl-1.0": {
		ID:              "TPL-1.0",
		Name:            "THOR Public License 1.0",
		Reference:       "https://spdx.org/licenses/TPL-1.0.html",
		ReferenceNumber: 134,
		DetailsURL:      "https://spdx.org/licenses/TPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing:ThorPublicLicense",
		},
		OSIApproved: false,
	},
	"ttwl": {
		ID:              "TTWL",
		Name:            "Text-Tabs+Wrap License",
		Reference:       "https://spdx.org/licenses/TTWL.html",
		ReferenceNumber: 28,
		DetailsURL:      "https://spdx.org/licenses/TTWL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/TTWL",
			"https://github.com/ap/Text-Tabs/blob/master/lib.modern/Text/Tabs.pm#L148",
		},
		OSIApproved: false,
	},
	"ttyp0": {
		ID:              "TTYP0",
		Name:            "TTYP0 License",
		Reference:       "https://spdx.org/licenses/TTYP0.html",
		ReferenceNumber: 207,
		DetailsURL:      "https://spdx.org/licenses/TTYP0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://people.mpi-inf.mpg.de/~uwe/misc/uw-ttyp0/",
		},
		OSIApproved: false,
	},
	"tu-berlin-1.0": {
		ID:              "TU-Berlin-1.0",
		Name:            "Technische Universitaet Berlin License 1.0",
		Reference:       "https://spdx.org/licenses/TU-Berlin-1.0.html",
		ReferenceNumber: 98,
		DetailsURL:      "https://spdx.org/licenses/TU-Berlin-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/swh/ladspa/blob/7bf6f3799fdba70fda297c2d8fd9f526803d9680/gsm/COPYRIGHT",
		},
		OSIApproved: false,
	},
	"tu-berlin-2.0": {
		ID:              "TU-Berlin-2.0",
		Name:            "Technische Universitaet Berlin License 2.0",
		Reference:       "https://spdx.org/licenses/TU-Berlin-2.0.html",
		ReferenceNumber: 533,
		DetailsURL:      "https://spdx.org/licenses/TU-Berlin-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/CorsixTH/deps/blob/fd339a9f526d1d9c9f01ccf39e438a015da50035/licences/libgsm.txt",
		},
		OSIApproved: false,
	},
	"termreadkey": {
		ID:              "TermReadKey",
		Name:            "TermReadKey License",
		Reference:       "https://spdx.org/licenses/TermReadKey.html",
		ReferenceNumber: 412,
		DetailsURL:      "https://spdx.org/licenses/TermReadKey.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/jonathanstowe/TermReadKey/blob/master/README#L9-L10",
		},
		OSIApproved: false,
	},
	"ucar": {
		ID:              "UCAR",
		Name:            "UCAR License",
		Reference:       "https://spdx.org/licenses/UCAR.html",
		ReferenceNumber: 371,
		DetailsURL:      "https://spdx.org/licenses/UCAR.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/Unidata/UDUNITS-2/blob/master/COPYRIGHT",
		},
		OSIApproved: false,
	},
	"ucl-1.0": {
		ID:              "UCL-1.0",
		Name:            "Upstream Compatibility License v1.0",
		Reference:       "https://spdx.org/licenses/UCL-1.0.html",
		ReferenceNumber: 88,
		DetailsURL:      "https://spdx.org/licenses/UCL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/UCL-1.0",
		},
		OSIApproved: true,
	},
	"umich-merit": {
		ID:              "UMich-Merit",
		Name:            "Michigan/Merit Networks License",
		Reference:       "https://spdx.org/licenses/UMich-Merit.html",
		ReferenceNumber: 413,
		DetailsURL:      "https://spdx.org/licenses/UMich-Merit.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/radcli/radcli/blob/master/COPYRIGHT#L64",
		},
		OSIApproved: false,
	},
	"upl-1.0": {
		ID:              "UPL-1.0",
		Name:            "Universal Permissive License v1.0",
		Reference:       "https://spdx.org/licenses/UPL-1.0.html",
		ReferenceNumber: 165,
		DetailsURL:      "https://spdx.org/licenses/UPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/UPL",
		},
		OSIApproved: true,
	},
	"urt-rle": {
		ID:              "URT-RLE",
		Name:            "Utah Raster Toolkit Run Length Encoded License",
		Reference:       "https://spdx.org/licenses/URT-RLE.html",
		ReferenceNumber: 416,
		DetailsURL:      "https://spdx.org/licenses/URT-RLE.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://sourceforge.net/p/netpbm/code/HEAD/tree/super_stable/converter/other/pnmtorle.c",
			"https://sourceforge.net/p/netpbm/code/HEAD/tree/super_stable/converter/other/rletopnm.c",
		},
		OSIApproved: false,
	},
	"unicode-3.0": {
		ID:              "Unicode-3.0",
		Name:            "Unicode License v3",
		Reference:       "https://spdx.org/licenses/Unicode-3.0.html",
		ReferenceNumber: 287,
		DetailsURL:      "https://spdx.org/licenses/Unicode-3.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.unicode.org/license.txt",
		},
		OSIApproved: true,
	},
	"unicode-dfs-2015": {
		ID:              "Unicode-DFS-2015",
		Name:            "Unicode License Agreement - Data Files and Software (2015)",
		Reference:       "https://spdx.org/licenses/Unicode-DFS-2015.html",
		ReferenceNumber: 137,
		DetailsURL:      "https://spdx.org/licenses/Unicode-DFS-2015.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://web.archive.org/web/20151224134844/http://unicode.org/copyright.html",
		},
		OSIApproved: false,
	},
	"unicode-dfs-2016": {
		ID:              "Unicode-DFS-2016",
		Name:            "Unicode License Agreement - Data Files and Software (2016)",
		Reference:       "https://spdx.org/licenses/Unicode-DFS-2016.html",
		ReferenceNumber: 295,
		DetailsURL:      "https://spdx.org/licenses/Unicode-DFS-2016.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.unicode.org/license.txt",
			"http://web.archive.org/web/20160823201924/http://www.unicode.org/copyright.html#License",
			"http://www.unicode.org/copyright.html",
		},
		OSIApproved: true,
	},
	"unicode-tou": {
		ID:              "Unicode-TOU",
		Name:            "Unicode Terms of Use",
		Reference:       "https://spdx.org/licenses/Unicode-TOU.html",
		ReferenceNumber: 432,
		DetailsURL:      "https://spdx.org/licenses/Unicode-TOU.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://web.archive.org/web/20140704074106/http://www.unicode.org/copyright.html",
			"http://www.unicode.org/copyright.html",
		},
		OSIApproved: false,
	},
	"unixcrypt": {
		ID:              "UnixCrypt",
		Name:            "UnixCrypt License",
		Reference:       "https://spdx.org/licenses/UnixCrypt.html",
		ReferenceNumber: 275,
		DetailsURL:      "https://spdx.org/licenses/UnixCrypt.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://foss.heptapod.net/python-libs/passlib/-/blob/branch/stable/LICENSE#L70",
			"https://opensource.apple.com/source/JBoss/JBoss-737/jboss-all/jetty/src/main/org/mortbay/util/UnixCrypt.java.auto.html",
			"https://archive.eclipse.org/jetty/8.0.1.v20110908/xref/org/eclipse/jetty/http/security/UnixCrypt.html",
		},
		OSIApproved: false,
	},
	"unlicense": {
		ID:              "Unlicense",
		Name:            "The Unlicense",
		Reference:       "https://spdx.org/licenses/Unlicense.html",
		ReferenceNumber: 58,
		DetailsURL:      "https://spdx.org/licenses/Unlicense.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://unlicense.org/",
		},
		OSIApproved: true,
	},
	"vostrom": {
		ID:              "VOSTROM",
		Name:            "VOSTROM Public License for Open Source",
		Reference:       "https://spdx.org/licenses/VOSTROM.html",
		ReferenceNumber: 516,
		DetailsURL:      "https://spdx.org/licenses/VOSTROM.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/VOSTROM",
		},
		OSIApproved: false,
	},
	"vsl-1.0": {
		ID:              "VSL-1.0",
		Name:            "Vovida Software License v1.0",
		Reference:       "https://spdx.org/licenses/VSL-1.0.html",
		ReferenceNumber: 440,
		DetailsURL:      "https://spdx.org/licenses/VSL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/VSL-1.0",
		},
		OSIApproved: true,
	},
	"vim": {
		ID:              "Vim",
		Name:            "Vim License",
		Reference:       "https://spdx.org/licenses/Vim.html",
		ReferenceNumber: 296,
		DetailsURL:      "https://spdx.org/licenses/Vim.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://vimdoc.sourceforge.net/htmldoc/uganda.html",
		},
		OSIApproved: false,
	},
	"w3c": {
		ID:              "W3C",
		Name:            "W3C Software Notice and License (2002-12-31)",
		Reference:       "https://spdx.org/licenses/W3C.html",
		ReferenceNumber: 13,
		DetailsURL:      "https://spdx.org/licenses/W3C.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.w3.org/Consortium/Legal/2002/copyright-software-20021231.html",
			"https://opensource.org/licenses/W3C",
		},
		OSIApproved: true,
	},
	"w3c-19980720": {
		ID:              "W3C-19980720",
		Name:            "W3C Software Notice and License (1998-07-20)",
		Reference:       "https://spdx.org/licenses/W3C-19980720.html",
		ReferenceNumber: 625,
		DetailsURL:      "https://spdx.org/licenses/W3C-19980720.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.w3.org/Consortium/Legal/copyright-software-19980720.html",
		},
		OSIApproved: false,
	},
	"w3c-20150513": {
		ID:              "W3C-20150513",
		Name:            "W3C Software Notice and Document License (2015-05-13)",
		Reference:       "https://spdx.org/licenses/W3C-20150513.html",
		ReferenceNumber: 524,
		DetailsURL:      "https://spdx.org/licenses/W3C-20150513.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.w3.org/Consortium/Legal/2015/copyright-software-and-document",
		},
		OSIApproved: false,
	},
	"wtfpl": {
		ID:              "WTFPL",
		Name:            "Do What The F*ck You Want To Public License",
		Reference:       "https://spdx.org/licenses/WTFPL.html",
		ReferenceNumber: 315,
		DetailsURL:      "https://spdx.org/licenses/WTFPL.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.wtfpl.net/about/",
			"http://sam.zoy.org/wtfpl/COPYING",
		},
		OSIApproved: false,
	},
	"watcom-1.0": {
		ID:              "Watcom-1.0",
		Name:            "Sybase Open Watcom Public License 1.0",
		Reference:       "https://spdx.org/licenses/Watcom-1.0.html",
		ReferenceNumber: 81,
		DetailsURL:      "https://spdx.org/licenses/Watcom-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/Watcom-1.0",
		},
		OSIApproved: true,
	},
	"widget-workshop": {
		ID:              "Widget-Workshop",
		Name:            "Widget Workshop License",
		Reference:       "https://spdx.org/licenses/Widget-Workshop.html",
		ReferenceNumber: 503,
		DetailsURL:      "https://spdx.org/licenses/Widget-Workshop.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/novnc/noVNC/blob/master/core/crypto/des.js#L24",
		},
		OSIApproved: false,
	},
	"wsuipa": {
		ID:              "Wsuipa",
		Name:            "Wsuipa License",
		Reference:       "https://spdx.org/licenses/Wsuipa.html",
		ReferenceNumber: 612,
		DetailsURL:      "https://spdx.org/licenses/Wsuipa.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Wsuipa",
		},
		OSIApproved: false,
	},
	"x11": {
		ID:              "X11",
		Name:            "X11 License",
		Reference:       "https://spdx.org/licenses/X11.html",
		ReferenceNumber: 518,
		DetailsURL:      "https://spdx.org/licenses/X11.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.xfree86.org/3.3.6/COPYRIGHT2.html#3",
		},
		OSIApproved: false,
	},
	"x11-distribute-modifications-variant": {
		ID:              "X11-distribute-modifications-variant",
		Name:            "X11 License Distribution Modification Variant",
		Reference:       "https://spdx.org/licenses/X11-distribute-modifications-variant.html",
		ReferenceNumber: 587,
		DetailsURL:      "https://spdx.org/licenses/X11-distribute-modifications-variant.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/mirror/ncurses/blob/master/COPYING",
		},
		OSIApproved: false,
	},
	"xfree86-1.1": {
		ID:              "XFree86-1.1",
		Name:            "XFree86 License 1.1",
		Reference:       "https://spdx.org/licenses/XFree86-1.1.html",
		ReferenceNumber: 247,
		DetailsURL:      "https://spdx.org/licenses/XFree86-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.xfree86.org/current/LICENSE4.html",
		},
		OSIApproved: false,
	},
	"xskat": {
		ID:              "XSkat",
		Name:            "XSkat License",
		Reference:       "https://spdx.org/licenses/XSkat.html",
		ReferenceNumber: 356,
		DetailsURL:      "https://spdx.org/licenses/XSkat.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/XSkat_License",
		},
		OSIApproved: false,
	},
	"xdebug-1.03": {
		ID:              "Xdebug-1.03",
		Name:            "Xdebug License v 1.03",
		Reference:       "https://spdx.org/licenses/Xdebug-1.03.html",
		ReferenceNumber: 198,
		DetailsURL:      "https://spdx.org/licenses/Xdebug-1.03.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/xdebug/xdebug/blob/master/LICENSE",
		},
		OSIApproved: false,
	},
	"xerox": {
		ID:              "Xerox",
		Name:            "Xerox License",
		Reference:       "https://spdx.org/licenses/Xerox.html",
		ReferenceNumber: 320,
		DetailsURL:      "https://spdx.org/licenses/Xerox.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Xerox",
		},
		OSIApproved: false,
	},
	"xfig": {
		ID:              "Xfig",
		Name:            "Xfig License",
		Reference:       "https://spdx.org/licenses/Xfig.html",
		ReferenceNumber: 171,
		DetailsURL:      "https://spdx.org/licenses/Xfig.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/Distrotech/transfig/blob/master/transfig/transfig.c",
			"https://fedoraproject.org/wiki/Licensing:MIT#Xfig_Variant",
			"https://sourceforge.net/p/mcj/xfig/ci/master/tree/src/Makefile.am",
		},
		OSIApproved: false,
	},
	"xnet": {
		ID:              "Xnet",
		Name:            "X.Net License",
		Reference:       "https://spdx.org/licenses/Xnet.html",
		ReferenceNumber: 125,
		DetailsURL:      "https://spdx.org/licenses/Xnet.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/Xnet",
		},
		OSIApproved: true,
	},
	"ypl-1.0": {
		ID:              "YPL-1.0",
		Name:            "Yahoo! Public License v1.0",
		Reference:       "https://spdx.org/licenses/YPL-1.0.html",
		ReferenceNumber: 27,
		DetailsURL:      "https://spdx.org/licenses/YPL-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.zimbra.com/license/yahoo_public_license_1.0.html",
		},
		OSIApproved: false,
	},
	"ypl-1.1": {
		ID:              "YPL-1.1",
		Name:            "Yahoo! Public License v1.1",
		Reference:       "https://spdx.org/licenses/YPL-1.1.html",
		ReferenceNumber: 170,
		DetailsURL:      "https://spdx.org/licenses/YPL-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.zimbra.com/license/yahoo_public_license_1.1.html",
		},
		OSIApproved: false,
	},
	"zpl-1.1": {
		ID:              "ZPL-1.1",
		Name:            "Zope Public License 1.1",
		Reference:       "https://spdx.org/licenses/ZPL-1.1.html",
		ReferenceNumber: 79,
		DetailsURL:      "https://spdx.org/licenses/ZPL-1.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://old.zope.org/Resources/License/ZPL-1.1",
		},
		OSIApproved: false,
	},
	"zpl-2.0": {
		ID:              "ZPL-2.0",
		Name:            "Zope Public License 2.0",
		Reference:       "https://spdx.org/licenses/ZPL-2.0.html",
		ReferenceNumber: 629,
		DetailsURL:      "https://spdx.org/licenses/ZPL-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://old.zope.org/Resources/License/ZPL-2.0",
			"https://opensource.org/licenses/ZPL-2.0",
		},
		OSIApproved: true,
	},
	"zpl-2.1": {
		ID:              "ZPL-2.1",
		Name:            "Zope Public License 2.1",
		Reference:       "https://spdx.org/licenses/ZPL-2.1.html",
		ReferenceNumber: 301,
		DetailsURL:      "https://spdx.org/licenses/ZPL-2.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://old.zope.org/Resources/ZPL/",
		},
		OSIApproved: true,
	},
	"zed": {
		ID:              "Zed",
		Name:            "Zed License",
		Reference:       "https://spdx.org/licenses/Zed.html",
		ReferenceNumber: 505,
		DetailsURL:      "https://spdx.org/licenses/Zed.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Zed",
		},
		OSIApproved: false,
	},
	"zeeff": {
		ID:              "Zeeff",
		Name:            "Zeeff License",
		Reference:       "https://spdx.org/licenses/Zeeff.html",
		ReferenceNumber: 177,
		DetailsURL:      "https://spdx.org/licenses/Zeeff.json",
		Deprecated:      false,
		SeeAlso: []string{
			"ftp://ftp.tin.org/pub/news/utils/newsx/newsx-1.6.tar.gz",
		},
		OSIApproved: false,
	},
	"zend-2.0": {
		ID:              "Zend-2.0",
		Name:            "Zend License v2.0",
		Reference:       "https://spdx.org/licenses/Zend-2.0.html",
		ReferenceNumber: 290,
		DetailsURL:      "https://spdx.org/licenses/Zend-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://web.archive.org/web/20130517195954/http://www.zend.com/license/2_00.txt",
		},
		OSIApproved: false,
	},
	"zimbra-1.3": {
		ID:              "Zimbra-1.3",
		Name:            "Zimbra Public License v1.3",
		Reference:       "https://spdx.org/licenses/Zimbra-1.3.html",
		ReferenceNumber: 561,
		DetailsURL:      "https://spdx.org/licenses/Zimbra-1.3.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://web.archive.org/web/20100302225219/http://www.zimbra.com/license/zimbra-public-license-1-3.html",
		},
		OSIApproved: false,
	},
	"zimbra-1.4": {
		ID:              "Zimbra-1.4",
		Name:            "Zimbra Public License v1.4",
		Reference:       "https://spdx.org/licenses/Zimbra-1.4.html",
		ReferenceNumber: 185,
		DetailsURL:      "https://spdx.org/licenses/Zimbra-1.4.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.zimbra.com/legal/zimbra-public-license-1-4",
		},
		OSIApproved: false,
	},
	"zlib": {
		ID:              "Zlib",
		Name:            "zlib License",
		Reference:       "https://spdx.org/licenses/Zlib.html",
		ReferenceNumber: 606,
		DetailsURL:      "https://spdx.org/licenses/Zlib.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.zlib.net/zlib_license.html",
			"https://opensource.org/licenses/Zlib",
		},
		OSIApproved: true,
	},
	"bcrypt-solar-designer": {
		ID:              "bcrypt-Solar-Designer",
		Name:            "bcrypt Solar Designer License",
		Reference:       "https://spdx.org/licenses/bcrypt-Solar-Designer.html",
		ReferenceNumber: 166,
		DetailsURL:      "https://spdx.org/licenses/bcrypt-Solar-Designer.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/bcrypt-ruby/bcrypt-ruby/blob/master/ext/mri/crypt_blowfish.c",
		},
		OSIApproved: false,
	},
	"blessing": {
		ID:              "blessing",
		Name:            "SQLite Blessing",
		Reference:       "https://spdx.org/licenses/blessing.html",
		ReferenceNumber: 618,
		DetailsURL:      "https://spdx.org/licenses/blessing.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.sqlite.org/src/artifact/e33a4df7e32d742a?ln=4-9",
			"https://sqlite.org/src/artifact/df5091916dbb40e6",
		},
		OSIApproved: false,
	},
	"bzip2-1.0.5": {
		ID:              "bzip2-1.0.5",
		Name:            "bzip2 and libbzip2 License v1.0.5",
		Reference:       "https://spdx.org/licenses/bzip2-1.0.5.html",
		ReferenceNumber: 283,
		DetailsURL:      "https://spdx.org/licenses/bzip2-1.0.5.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://sourceware.org/bzip2/1.0.5/bzip2-manual-1.0.5.html",
			"http://bzip.org/1.0.5/bzip2-manual-1.0.5.html",
		},
		OSIApproved: false,
	},
	"bzip2-1.0.6": {
		ID:              "bzip2-1.0.6",
		Name:            "bzip2 and libbzip2 License v1.0.6",
		Reference:       "https://spdx.org/licenses/bzip2-1.0.6.html",
		ReferenceNumber: 206,
		DetailsURL:      "https://spdx.org/licenses/bzip2-1.0.6.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://sourceware.org/git/?p=bzip2.git;a=blob;f=LICENSE;hb=bzip2-1.0.6",
			"http://bzip.org/1.0.5/bzip2-manual-1.0.5.html",
			"https://sourceware.org/cgit/valgrind/tree/mpi/libmpiwrap.c",
		},
		OSIApproved: false,
	},
	"check-cvs": {
		ID:              "check-cvs",
		Name:            "check-cvs License",
		Reference:       "https://spdx.org/licenses/check-cvs.html",
		ReferenceNumber: 334,
		DetailsURL:      "https://spdx.org/licenses/check-cvs.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://cvs.savannah.gnu.org/viewvc/cvs/ccvs/contrib/check_cvs.in?revision=1.1.4.3&view=markup&pathrev=cvs1-11-23#l2",
		},
		OSIApproved: false,
	},
	"checkmk": {
		ID:              "checkmk",
		Name:            "Checkmk License",
		Reference:       "https://spdx.org/licenses/checkmk.html",
		ReferenceNumber: 111,
		DetailsURL:      "https://spdx.org/licenses/checkmk.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/libcheck/check/blob/master/checkmk/checkmk.in",
		},
		OSIApproved: false,
	},
	"copyleft-next-0.3.0": {
		ID:              "copyleft-next-0.3.0",
		Name:            "copyleft-next 0.3.0",
		Reference:       "https://spdx.org/licenses/copyleft-next-0.3.0.html",
		ReferenceNumber: 340,
		DetailsURL:      "https://spdx.org/licenses/copyleft-next-0.3.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/copyleft-next/copyleft-next/blob/master/Releases/copyleft-next-0.3.0",
		},
		OSIApproved: false,
	},
	"copyleft-next-0.3.1": {
		ID:              "copyleft-next-0.3.1",
		Name:            "copyleft-next 0.3.1",
		Reference:       "https://spdx.org/licenses/copyleft-next-0.3.1.html",
		ReferenceNumber: 553,
		DetailsURL:      "https://spdx.org/licenses/copyleft-next-0.3.1.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/copyleft-next/copyleft-next/blob/master/Releases/copyleft-next-0.3.1",
		},
		OSIApproved: false,
	},
	"curl": {
		ID:              "curl",
		Name:            "curl License",
		Reference:       "https://spdx.org/licenses/curl.html",
		ReferenceNumber: 429,
		DetailsURL:      "https://spdx.org/licenses/curl.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/bagder/curl/blob/master/COPYING",
		},
		OSIApproved: false,
	},
	"diffmark": {
		ID:              "diffmark",
		Name:            "diffmark license",
		Reference:       "https://spdx.org/licenses/diffmark.html",
		ReferenceNumber: 365,
		DetailsURL:      "https://spdx.org/licenses/diffmark.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/diffmark",
		},
		OSIApproved: false,
	},
	"dtoa": {
		ID:              "dtoa",
		Name:            "David M. Gay dtoa License",
		Reference:       "https://spdx.org/licenses/dtoa.html",
		ReferenceNumber: 74,
		DetailsURL:      "https://spdx.org/licenses/dtoa.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/SWI-Prolog/swipl-devel/blob/master/src/os/dtoa.c",
		},
		OSIApproved: false,
	},
	"dvipdfm": {
		ID:              "dvipdfm",
		Name:            "dvipdfm License",
		Reference:       "https://spdx.org/licenses/dvipdfm.html",
		ReferenceNumber: 309,
		DetailsURL:      "https://spdx.org/licenses/dvipdfm.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/dvipdfm",
		},
		OSIApproved: false,
	},
	"ecos-2.0": {
		ID:              "eCos-2.0",
		Name:            "eCos license version 2.0",
		Reference:       "https://spdx.org/licenses/eCos-2.0.html",
		ReferenceNumber: 173,
		DetailsURL:      "https://spdx.org/licenses/eCos-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://www.gnu.org/licenses/ecos-license.html",
		},
		OSIApproved: false,
	},
	"egenix": {
		ID:              "eGenix",
		Name:            "eGenix.com Public License 1.1.0",
		Reference:       "https://spdx.org/licenses/eGenix.html",
		ReferenceNumber: 102,
		DetailsURL:      "https://spdx.org/licenses/eGenix.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.egenix.com/products/eGenix.com-Public-License-1.1.0.pdf",
			"https://fedoraproject.org/wiki/Licensing/eGenix.com_Public_License_1.1.0",
		},
		OSIApproved: false,
	},
	"etalab-2.0": {
		ID:              "etalab-2.0",
		Name:            "Etalab Open License 2.0",
		Reference:       "https://spdx.org/licenses/etalab-2.0.html",
		ReferenceNumber: 299,
		DetailsURL:      "https://spdx.org/licenses/etalab-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/DISIC/politique-de-contribution-open-source/blob/master/LICENSE.pdf",
			"https://raw.githubusercontent.com/DISIC/politique-de-contribution-open-source/master/LICENSE",
		},
		OSIApproved: false,
	},
	"fwlw": {
		ID:              "fwlw",
		Name:            "fwlw License",
		Reference:       "https://spdx.org/licenses/fwlw.html",
		ReferenceNumber: 258,
		DetailsURL:      "https://spdx.org/licenses/fwlw.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://mirrors.nic.cz/tex-archive/macros/latex/contrib/fwlw/README",
		},
		OSIApproved: false,
	},
	"gsoap-1.3b": {
		ID:              "gSOAP-1.3b",
		Name:            "gSOAP Public License v1.3b",
		Reference:       "https://spdx.org/licenses/gSOAP-1.3b.html",
		ReferenceNumber: 633,
		DetailsURL:      "https://spdx.org/licenses/gSOAP-1.3b.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.cs.fsu.edu/~engelen/license.html",
		},
		OSIApproved: false,
	},
	"gnuplot": {
		ID:              "gnuplot",
		Name:            "gnuplot License",
		Reference:       "https://spdx.org/licenses/gnuplot.html",
		ReferenceNumber: 268,
		DetailsURL:      "https://spdx.org/licenses/gnuplot.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Gnuplot",
		},
		OSIApproved: false,
	},
	"gtkbook": {
		ID:              "gtkbook",
		Name:            "gtkbook License",
		Reference:       "https://spdx.org/licenses/gtkbook.html",
		ReferenceNumber: 341,
		DetailsURL:      "https://spdx.org/licenses/gtkbook.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/slogan621/gtkbook",
			"https://github.com/oetiker/rrdtool-1.x/blob/master/src/plbasename.c#L8-L11",
		},
		OSIApproved: false,
	},
	"hdparm": {
		ID:              "hdparm",
		Name:            "hdparm License",
		Reference:       "https://spdx.org/licenses/hdparm.html",
		ReferenceNumber: 467,
		DetailsURL:      "https://spdx.org/licenses/hdparm.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/Distrotech/hdparm/blob/4517550db29a91420fb2b020349523b1b4512df2/LICENSE.TXT",
		},
		OSIApproved: false,
	},
	"imatix": {
		ID:              "iMatix",
		Name:            "iMatix Standard Function Library Agreement",
		Reference:       "https://spdx.org/licenses/iMatix.html",
		ReferenceNumber: 307,
		DetailsURL:      "https://spdx.org/licenses/iMatix.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://legacy.imatix.com/html/sfl/sfl4.htm#license",
		},
		OSIApproved: false,
	},
	"libpng-2.0": {
		ID:              "libpng-2.0",
		Name:            "PNG Reference Library version 2",
		Reference:       "https://spdx.org/licenses/libpng-2.0.html",
		ReferenceNumber: 212,
		DetailsURL:      "https://spdx.org/licenses/libpng-2.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://www.libpng.org/pub/png/src/libpng-LICENSE.txt",
		},
		OSIApproved: false,
	},
	"libselinux-1.0": {
		ID:              "libselinux-1.0",
		Name:            "libselinux public domain notice",
		Reference:       "https://spdx.org/licenses/libselinux-1.0.html",
		ReferenceNumber: 266,
		DetailsURL:      "https://spdx.org/licenses/libselinux-1.0.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/SELinuxProject/selinux/blob/master/libselinux/LICENSE",
		},
		OSIApproved: false,
	},
	"libtiff": {
		ID:              "libtiff",
		Name:            "libtiff License",
		Reference:       "https://spdx.org/licenses/libtiff.html",
		ReferenceNumber: 20,
		DetailsURL:      "https://spdx.org/licenses/libtiff.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/libtiff",
		},
		OSIApproved: false,
	},
	"libutil-david-nugent": {
		ID:              "libutil-David-Nugent",
		Name:            "libutil David Nugent License",
		Reference:       "https://spdx.org/licenses/libutil-David-Nugent.html",
		ReferenceNumber: 393,
		DetailsURL:      "https://spdx.org/licenses/libutil-David-Nugent.json",
		Deprecated:      false,
		SeeAlso: []string{
			"http://web.mit.edu/freebsd/head/lib/libutil/login_ok.3",
			"https://cgit.freedesktop.org/libbsd/tree/man/setproctitle.3bsd",
		},
		OSIApproved: false,
	},
	"lsof": {
		ID:              "lsof",
		Name:            "lsof License",
		Reference:       "https://spdx.org/licenses/lsof.html",
		ReferenceNumber: 157,
		DetailsURL:      "https://spdx.org/licenses/lsof.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/lsof-org/lsof/blob/master/COPYING",
		},
		OSIApproved: false,
	},
	"magaz": {
		ID:              "magaz",
		Name:            "magaz License",
		Reference:       "https://spdx.org/licenses/magaz.html",
		ReferenceNumber: 279,
		DetailsURL:      "https://spdx.org/licenses/magaz.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://mirrors.nic.cz/tex-archive/macros/latex/contrib/magaz/magaz.tex",
		},
		OSIApproved: false,
	},
	"mailprio": {
		ID:              "mailprio",
		Name:            "mailprio License",
		Reference:       "https://spdx.org/licenses/mailprio.html",
		ReferenceNumber: 225,
		DetailsURL:      "https://spdx.org/licenses/mailprio.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fossies.org/linux/sendmail/contrib/mailprio",
		},
		OSIApproved: false,
	},
	"metamail": {
		ID:              "metamail",
		Name:            "metamail License",
		Reference:       "https://spdx.org/licenses/metamail.html",
		ReferenceNumber: 567,
		DetailsURL:      "https://spdx.org/licenses/metamail.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/Dual-Life/mime-base64/blob/master/Base64.xs#L12",
		},
		OSIApproved: false,
	},
	"mpi-permissive": {
		ID:              "mpi-permissive",
		Name:            "mpi Permissive License",
		Reference:       "https://spdx.org/licenses/mpi-permissive.html",
		ReferenceNumber: 114,
		DetailsURL:      "https://spdx.org/licenses/mpi-permissive.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://sources.debian.org/src/openmpi/4.1.0-10/ompi/debuggers/msgq_interface.h/?hl=19#L19",
		},
		OSIApproved: false,
	},
	"mpich2": {
		ID:              "mpich2",
		Name:            "mpich2 License",
		Reference:       "https://spdx.org/licenses/mpich2.html",
		ReferenceNumber: 164,
		DetailsURL:      "https://spdx.org/licenses/mpich2.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/MIT",
		},
		OSIApproved: false,
	},
	"mplus": {
		ID:              "mplus",
		Name:            "mplus Font License",
		Reference:       "https://spdx.org/licenses/mplus.html",
		ReferenceNumber: 160,
		DetailsURL:      "https://spdx.org/licenses/mplus.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing:Mplus?rd=Licensing/mplus",
		},
		OSIApproved: false,
	},
	"pnmstitch": {
		ID:              "pnmstitch",
		Name:            "pnmstitch License",
		Reference:       "https://spdx.org/licenses/pnmstitch.html",
		ReferenceNumber: 76,
		DetailsURL:      "https://spdx.org/licenses/pnmstitch.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://sourceforge.net/p/netpbm/code/HEAD/tree/super_stable/editor/pnmstitch.c#l2",
		},
		OSIApproved: false,
	},
	"psfrag": {
		ID:              "psfrag",
		Name:            "psfrag License",
		Reference:       "https://spdx.org/licenses/psfrag.html",
		ReferenceNumber: 150,
		DetailsURL:      "https://spdx.org/licenses/psfrag.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/psfrag",
		},
		OSIApproved: false,
	},
	"psutils": {
		ID:              "psutils",
		Name:            "psutils License",
		Reference:       "https://spdx.org/licenses/psutils.html",
		ReferenceNumber: 146,
		DetailsURL:      "https://spdx.org/licenses/psutils.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/psutils",
		},
		OSIApproved: false,
	},
	"python-ldap": {
		ID:              "python-ldap",
		Name:            "Python ldap License",
		Reference:       "https://spdx.org/licenses/python-ldap.html",
		ReferenceNumber: 581,
		DetailsURL:      "https://spdx.org/licenses/python-ldap.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/python-ldap/python-ldap/blob/main/LICENCE",
		},
		OSIApproved: false,
	},
	"radvd": {
		ID:              "radvd",
		Name:            "radvd License",
		Reference:       "https://spdx.org/licenses/radvd.html",
		ReferenceNumber: 5,
		DetailsURL:      "https://spdx.org/licenses/radvd.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/radvd-project/radvd/blob/master/COPYRIGHT",
		},
		OSIApproved: false,
	},
	"snprintf": {
		ID:              "snprintf",
		Name:            "snprintf License",
		Reference:       "https://spdx.org/licenses/snprintf.html",
		ReferenceNumber: 159,
		DetailsURL:      "https://spdx.org/licenses/snprintf.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/openssh/openssh-portable/blob/master/openbsd-compat/bsd-snprintf.c#L2",
		},
		OSIApproved: false,
	},
	"softsurfer": {
		ID:              "softSurfer",
		Name:            "softSurfer License",
		Reference:       "https://spdx.org/licenses/softSurfer.html",
		ReferenceNumber: 489,
		DetailsURL:      "https://spdx.org/licenses/softSurfer.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/mm2/Little-CMS/blob/master/src/cmssm.c#L207",
			"https://fedoraproject.org/wiki/Licensing/softSurfer",
		},
		OSIApproved: false,
	},
	"ssh-keyscan": {
		ID:              "ssh-keyscan",
		Name:            "ssh-keyscan License",
		Reference:       "https://spdx.org/licenses/ssh-keyscan.html",
		ReferenceNumber: 84,
		DetailsURL:      "https://spdx.org/licenses/ssh-keyscan.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/openssh/openssh-portable/blob/master/LICENCE#L82",
		},
		OSIApproved: false,
	},
	"swrule": {
		ID:              "swrule",
		Name:            "swrule License",
		Reference:       "https://spdx.org/licenses/swrule.html",
		ReferenceNumber: 362,
		DetailsURL:      "https://spdx.org/licenses/swrule.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://ctan.math.utah.edu/ctan/tex-archive/macros/generic/misc/swrule.sty",
		},
		OSIApproved: false,
	},
	"ulem": {
		ID:              "ulem",
		Name:            "ulem License",
		Reference:       "https://spdx.org/licenses/ulem.html",
		ReferenceNumber: 401,
		DetailsURL:      "https://spdx.org/licenses/ulem.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://mirrors.ctan.org/macros/latex/contrib/ulem/README",
		},
		OSIApproved: false,
	},
	"w3m": {
		ID:              "w3m",
		Name:            "w3m License",
		Reference:       "https://spdx.org/licenses/w3m.html",
		ReferenceNumber: 509,
		DetailsURL:      "https://spdx.org/licenses/w3m.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://github.com/tats/w3m/blob/master/COPYING",
		},
		OSIApproved: false,
	},
	"wxwindows": {
		ID:              "wxWindows",
		Name:            "wxWindows Library License",
		Reference:       "https://spdx.org/licenses/wxWindows.html",
		ReferenceNumber: 274,
		DetailsURL:      "https://spdx.org/licenses/wxWindows.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://opensource.org/licenses/WXwindows",
		},
		OSIApproved: true,
	},
	"xinetd": {
		ID:              "xinetd",
		Name:            "xinetd License",
		Reference:       "https://spdx.org/licenses/xinetd.html",
		ReferenceNumber: 17,
		DetailsURL:      "https://spdx.org/licenses/xinetd.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/Xinetd_License",
		},
		OSIApproved: false,
	},
	"xkeyboard-config-zinoviev": {
		ID:              "xkeyboard-config-Zinoviev",
		Name:            "xkeyboard-config Zinoviev License",
		Reference:       "https://spdx.org/licenses/xkeyboard-config-Zinoviev.html",
		ReferenceNumber: 445,
		DetailsURL:      "https://spdx.org/licenses/xkeyboard-config-Zinoviev.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://gitlab.freedesktop.org/xkeyboard-config/xkeyboard-config/-/blob/master/COPYING?ref_type=heads#L178",
		},
		OSIApproved: false,
	},
	"xlock": {
		ID:              "xlock",
		Name:            "xlock License",
		Reference:       "https://spdx.org/licenses/xlock.html",
		ReferenceNumber: 361,
		DetailsURL:      "https://spdx.org/licenses/xlock.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fossies.org/linux/tiff/contrib/ras/ras2tif.c",
		},
		OSIApproved: false,
	},
	"xpp": {
		ID:              "xpp",
		Name:            "XPP License",
		Reference:       "https://spdx.org/licenses/xpp.html",
		ReferenceNumber: 55,
		DetailsURL:      "https://spdx.org/licenses/xpp.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/xpp",
		},
		OSIApproved: false,
	},
	"zlib-acknowledgement": {
		ID:              "zlib-acknowledgement",
		Name:            "zlib/libpng License with Acknowledgement",
		Reference:       "https://spdx.org/licenses/zlib-acknowledgement.html",
		ReferenceNumber: 560,
		DetailsURL:      "https://spdx.org/licenses/zlib-acknowledgement.json",
		Deprecated:      false,
		SeeAlso: []string{
			"https://fedoraproject.org/wiki/Licensing/ZlibWithAcknowledgement",
		},
		OSIApproved: false,
	},
}
